/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.app.ICasFetchParam;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Map;

public class FetchParamCashMgtInitUI
implements ICasFetchParam {
    @Override
    public Map fetchParam(Context ctx, Map paramMap) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = this.getCompany(ctx);
        paramMap.put("company", company);
        paramMap.put("isStart", this.isStart(ctx, company));
        paramMap.put("isGLStart", this.isGLStart(ctx, company));
        paramMap.put("startPeriod", this.getStartPeriod(ctx, company));
        paramMap.put("currentPeriod", this.getCurrentPeriod(ctx, company));
        paramMap.put("baseCurrency", this.getBaseCurrency(ctx, company));
        paramMap.put("currencyCollection", this.getCurrencyCollection(ctx));
        return paramMap;
    }

    public CompanyOrgUnitInfo getCompany(Context ctx) {
        return ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
    }

    public boolean isStart(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ictrol.isStart(new Integer(7).intValue(), company.getId().toString());
    }

    public boolean isGLStart(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ISystemStatusCtrol ictrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        return ictrol.isStart(new Integer(6).intValue(), company.getId().toString());
    }

    public PeriodInfo getStartPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (startPeriodInfo == null) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
        return startPeriodInfo;
    }

    public PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
    }

    public CurrencyInfo getBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
    }

    public CurrencyCollection getCurrencyCollection(Context ctx) throws BOSException, EASBizException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(true);
    }
}

