/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.app.CasRecPayFetchParamHelperBase;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;

public class FetchParamHelperForPaymentBillUI
extends CasRecPayFetchParamHelperBase {
    @Override
    public Map fetchParam(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String permissionItem = (String)(paramMap = super.fetchParam(ctx, paramMap)).get("PermissionItem");
        if (permissionItem == null) {
            permissionItem = "cas_paymentbill_01view";
        }
        paramMap.put("UserOrgRanges", this.getUserOrgRangesWithRange(ctx, permissionItem));
        paramMap.put("currentPeriond", this.getCurrentPeriond(this.currentCompany));
        paramMap.put("currencyCollection", this.getCurrencyCollection());
        if (paramMap.get("CS053") != null) {
            int val = Integer.parseInt((String)paramMap.get("CS053"));
            paramMap.put("isSubmitCtrlOverDraft", val == 1);
        }
        String companyID = this.currentCompany.getId().toString();
        if (paramMap.get("selectCompany") != null && paramMap.get("selectCompany") instanceof Object[]) {
            Object[] companys = (Object[])paramMap.get("selectCompany");
            HashSet<String> companySet = new HashSet<String>();
            for (int i = 0; i < companys.length; ++i) {
                companySet.add(((CompanyOrgUnitInfo)companys[i]).getId().toString());
            }
            paramMap.put("asstActTypeCollection", this.getAsstActTypeColl(companySet, false, false));
        } else {
            paramMap.put("asstActTypeCollection", this.getAsstActTypeColl(companyID, false, false));
        }
        if (paramMap.get("isList") == null) {
            AsstActTypeInfo info;
            boolean isFirtFetch = (Boolean)paramMap.get("isFirtTime");
            if (isFirtFetch) {
                paramMap.put("defaultBillType", this.getDefaultBillType_PaymentBill());
                if (paramMap.get("ID") != null) {
                    paramMap.put("srcAgentPayInfo", this.getSrcAgentPayBillInfo(paramMap.get("ID").toString()));
                }
            }
            if ((info = this.getDefaultAsstActType(companyID, true, false)) == null) {
                paramMap.put("defaultAsstActType", "NULL");
            } else {
                paramMap.put("defaultAsstActType", info);
            }
            PaymentBillInfo paymentBill = new PaymentBillInfo();
            boolean hasCodingRule = this.hasCodingRule((CoreBaseInfo)paymentBill, companyID);
            boolean isAddView = false;
            boolean isModifiable = false;
            if (hasCodingRule) {
                isAddView = this.isAddView((CoreBaseInfo)paymentBill, companyID);
                isModifiable = this.isModifiable((CoreBaseInfo)paymentBill, companyID);
            }
            paramMap.put("hasCodingRule", hasCodingRule);
            paramMap.put("isAddView", isAddView);
            paramMap.put("isModifiable", isModifiable);
            paramMap.put("currentCostCenter", SysContext.getSysContext().getCurrentCostUnit());
            if (this.currentCompany.getBaseCurrency() != null) {
                paramMap.put(this.currentCompany.getBaseCurrency().getId().toString(), CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId())));
            }
            EntityViewInfo countryEvi = new EntityViewInfo();
            FilterInfo countryFilter = new FilterInfo();
            countryFilter.getFilterItems().add(new FilterItemInfo("name", (Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"117_FetchParamHelperForPaymentBillUI", (Locale)ctx.getLocale())));
            countryEvi.setFilter(countryFilter);
            CountryCollection countryCol = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(countryEvi);
            if (countryCol != null && countryCol.size() > 0) {
                CountryInfo china = countryCol.get(0);
                paramMap.put("china", china);
            }
        }
        return paramMap;
    }

    private PaymentBillInfo getSrcAgentPayBillInfo(String id) throws BOSException, EASBizException {
        boolean isExist = PaymentBillFactory.getLocalInstance(this.ctx).exists((IObjectPK)new ObjectUuidPK(id));
        if (EmptyUtil.isEmpty((String)id) || !isExist) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        PaymentBillInfo agentPayBill = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        String srcAgentPayBillID = agentPayBill.getSrcAgenPaymentBillID();
        if (EmptyUtil.isEmpty((String)srcAgentPayBillID)) {
            return null;
        }
        PaymentBillInfo srcAgentPayBill = PaymentBillFactory.getLocalInstance(this.ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(srcAgentPayBillID));
        return srcAgentPayBill;
    }
}

