/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.FinalCheckoutFactory;
import com.kingdee.eas.fi.cas.IFinalCheckout;
import com.kingdee.eas.fi.cas.app.AbstractFinalCheckOutWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.FMClientHelper;
import com.kingdee.eas.fi.cas.utils.PeriodHelper;
import com.kingdee.eas.fi.cas.utils.PeriodUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.DateTimeUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FinalCheckOutWebFacadeControllerBean
extends AbstractFinalCheckOutWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.FinalCheckOutWebFacadeControllerBean");
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CheckoutResource";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private PeriodInfo startPeriod = null;
    private PeriodInfo periodInfo = null;
    private PeriodInfo prevPeriodInfo = null;
    private StringBuffer buff2 = null;
    private StringBuffer buff = null;
    private List initData = null;

    @Override
    protected Map _getInitData(Context ctx, boolean share, Map map) throws BOSException, EASBizException {
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        int error = 0;
        String errorMsg = null;
        try {
            this.initData = FinalCheckoutFactory.getLocalInstance(ctx).getInitData(map);
            if (map != null) {
                List periodList = (List)this.initData.remove(0);
                onloadData.put("periodList", periodList);
            }
            List processData = this.processData(ctx, this.initData);
            if (!share) {
                CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
                if (currentCompany == null) {
                    throw new CasWebException(CasWebException.NO_FINALCHECKOUT_AUTHRIZED);
                }
                for (int i = 0; i < processData.size(); ++i) {
                    Map processMap = (Map)processData.get(i);
                    FullOrgUnitInfo rowCompany = (FullOrgUnitInfo)processMap.get("company");
                    if (rowCompany.getId().equals((Object)currentCompany.getId())) continue;
                    processData.remove(i);
                    --i;
                }
                if (processData.size() == 0 && !CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(currentCompany.getId().toString()), "cas_finalcheckout_01checkout")) {
                    throw new CasWebException(CasWebException.NO_FINALCHECKOUT_AUTHRIZED);
                }
            }
            String result = "";
            if (processData != null) {
                ArrayList loadData = new ArrayList();
                for (int i = 0; i < processData.size(); ++i) {
                    Map info = (Map)processData.get(i);
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    FullOrgUnitInfo curCompany = (FullOrgUnitInfo)info.get("company");
                    PeriodInfo curPeriodInfo = (PeriodInfo)info.get("curPeriod");
                    Object[] args = new String[]{String.valueOf(curPeriodInfo.getPeriodYear()), String.valueOf(curPeriodInfo.getPeriodNumber())};
                    result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()), args);
                    row.put("id", curCompany.getId().toString());
                    row.put("company_id", curCompany.getId().toString());
                    row.put("company_name", curCompany.getName());
                    row.put("company_number", curCompany.getNumber());
                    row.put("period_id", curPeriodInfo.getId().toString());
                    row.put("period", result);
                    row.put("close_init", info.get("isStart"));
                    row.put("voucher_book", info.get("needAllBook"));
                    row.put("bookType", info.get("bookType"));
                    row.put("balace_equal", info.get("is_gl_balance"));
                    row.put("inside_not_voucher", info.get("insideNotVoucher"));
                    row.put("outside_not_voucher", info.get("outsideNotVoucher"));
                    row.put("isStart_msg", info.get("isStart_msg"));
                    row.put("gl_balance_msg", info.get("gl_balance_msg"));
                    row.put("needAllBook_Msg", info.get("needAllBook_Msg"));
                    row.put("checkInsideNotVoucher_Msg", info.get("checkInsideNotVoucher_Msg"));
                    row.put("checkInsideNotVoucher_PAYIN", info.get("checkInsideNotVoucher_PAYIN"));
                    row.put("checkInsideNotVoucher_RECIN", info.get("checkInsideNotVoucher_RECIN"));
                    row.put("checkOutsideNotVoucher_Msg", info.get("checkOutsideNotVoucher_Msg"));
                    row.put("checkOutsideNotVoucher_PAYOUT", info.get("checkOutsideNotVoucher_PAYOUT"));
                    row.put("checkOutsideNotVoucher_RECOUT", info.get("checkOutsideNotVoucher_RECOUT"));
                    row.put("curPeriod", curPeriodInfo.getEndDate().getMonth() + 1);
                    loadData.add(row);
                }
                onloadData.put("onloadData", loadData);
                onloadData.put("error", error);
                onloadData.put("errorMsg", errorMsg);
                return onloadData;
            }
        }
        catch (Exception e) {
            EASBizException be;
            if (e instanceof EASBizException && (be = (EASBizException)((Object)e)).getMainCode().equals("20") && be.getSubCode().equals("022")) {
                throw be;
            }
            e.printStackTrace();
            error = 1;
            errorMsg = e.getMessage();
        }
        onloadData.put("error", error);
        onloadData.put("errorMsg", errorMsg);
        return onloadData;
    }

    private List processData(Context ctx, List initData) {
        ArrayList processData = new ArrayList();
        if (initData != null) {
            for (int i = 0; i < initData.size(); ++i) {
                Vector tmpVec;
                String gl_balanceMsg;
                HashMap<String, Object> processMap = new HashMap<String, Object>();
                Map info = (Map)initData.get(i);
                Map checkMsg = (Map)info.get("checkMsg");
                processMap.put("checkMsg", checkMsg);
                processMap.put("company", info.get("company"));
                processMap.put("curPeriod", info.get("curPeriod"));
                processMap.put("CS001", info.get("CS001"));
                processMap.put("CS002", info.get("CS002"));
                processMap.put("CS055", info.get("CS055"));
                processMap.put("CS056", info.get("CS056"));
                boolean isStart = (Boolean)info.get("isStart");
                if (!isStart) {
                    String isStartMsg = "";
                    isStartMsg = EASResource.getString((String)resourcePath, (String)"StartPeriod_NullMsg", (Locale)ctx.getLocale());
                    processMap.put("isStart_msg", isStartMsg);
                    processMap.put("needAllBook", false);
                    processMap.put("insideNotVoucher", false);
                    processMap.put("outsideNotVoucher", false);
                }
                processMap.put("isStart", isStart);
                boolean CS019 = Boolean.valueOf((String)info.get("CS019"));
                boolean is_gl_balance = Boolean.valueOf((String)info.get("CS019"));
                processMap.put("is_gl_balance_ignore", false);
                if (CS019 && checkMsg.get("gl_balance") != null) {
                    gl_balanceMsg = "";
                    tmpVec = (Vector)checkMsg.get("gl_balance");
                    if (!tmpVec.isEmpty()) {
                        gl_balanceMsg = EASResource.getString((String)resourcePath, (String)"gl_balance", (Locale)ctx.getLocale());
                        is_gl_balance = false;
                        processMap.put("gl_balance_msg", gl_balanceMsg);
                    } else {
                        is_gl_balance = true;
                    }
                } else if (!CS019) {
                    is_gl_balance = true;
                }
                if (!CS019 && checkMsg.get("gl_balance") != null) {
                    processMap.put("is_gl_balance_ignore", true);
                    gl_balanceMsg = "";
                    tmpVec = (Vector)checkMsg.get("gl_balance");
                    if (!tmpVec.isEmpty()) {
                        gl_balanceMsg = EASResource.getString((String)resourcePath, (String)"gl_balance", (Locale)ctx.getLocale());
                        is_gl_balance = false;
                        processMap.put("gl_balance_msg", gl_balanceMsg);
                    } else {
                        is_gl_balance = true;
                    }
                }
                processMap.put("is_gl_balance", is_gl_balance);
                boolean needAllBook = Boolean.valueOf((String)info.get("CS002"));
                int bookType = Integer.valueOf((String)info.get("CS001"));
                String needAllBookMsg = this.checkNotBookBill(ctx, true, bookType, checkMsg);
                if (!FMHelper.isEmpty((String)needAllBookMsg)) {
                    processMap.put("needAllBook_Msg", needAllBookMsg);
                    needAllBook = false;
                } else {
                    needAllBook = true;
                }
                processMap.put("needAllBook", needAllBook);
                processMap.put("bookType", bookType);
                boolean insideNotVoucher = Boolean.valueOf((String)info.get("CS055"));
                if (insideNotVoucher) {
                    String checkInsideMsg = this.checkInsideNotVoucherBill(ctx, checkMsg);
                    if (!FMHelper.isEmpty((String)checkInsideMsg)) {
                        processMap.put("checkInsideNotVoucher_Msg", checkInsideMsg);
                        StringBuffer singleMsg = new StringBuffer();
                        Vector tmpVec2 = null;
                        String strInfo = "";
                        if (checkMsg.get("PAYINNOTVOUCHER") != null && !(tmpVec2 = (Vector)checkMsg.get("PAYINNOTVOUCHER")).isEmpty()) {
                            strInfo = tmpVec2.toString();
                            singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouPay", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
                            singleMsg.append(LINE_SEPARATOR);
                            processMap.put("checkInsideNotVoucher_PAYIN", singleMsg.toString());
                        }
                        if (checkMsg.get("RECINNOTVOUCHER") != null) {
                            tmpVec2 = (Vector)checkMsg.get("RECINNOTVOUCHER");
                            if (!tmpVec2.isEmpty()) {
                                singleMsg = new StringBuffer();
                                strInfo = tmpVec2.toString();
                                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouRec", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
                            }
                            singleMsg.append(LINE_SEPARATOR);
                            processMap.put("checkInsideNotVoucher_RECIN", singleMsg.toString());
                        }
                        insideNotVoucher = false;
                    } else {
                        insideNotVoucher = true;
                    }
                } else {
                    insideNotVoucher = !insideNotVoucher;
                }
                processMap.put("insideNotVoucher", insideNotVoucher);
                boolean outsideNotVoucher = Boolean.valueOf((String)info.get("CS056"));
                if (outsideNotVoucher) {
                    String checkOutsideMsg = this.checkOutsideNotVoucherBill(ctx, checkMsg);
                    if (!FMHelper.isEmpty((String)checkOutsideMsg)) {
                        processMap.put("checkOutsideNotVoucher_Msg", checkOutsideMsg);
                        StringBuffer singleMsg = new StringBuffer();
                        Vector tmpVec3 = null;
                        String strInfo = "";
                        if (checkMsg.get("PAYOUTNOTVOUCHER") != null) {
                            tmpVec3 = (Vector)checkMsg.get("PAYOUTNOTVOUCHER");
                            if (!tmpVec3.isEmpty()) {
                                strInfo = tmpVec3.toString();
                                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouPay", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
                            }
                            singleMsg.append(LINE_SEPARATOR);
                            processMap.put("checkOutsideNotVoucher_PAYOUT", singleMsg.toString());
                        }
                        if (checkMsg.get("RECOUTNOTVOUCHER") != null) {
                            tmpVec3 = (Vector)checkMsg.get("RECOUTNOTVOUCHER");
                            if (!tmpVec3.isEmpty()) {
                                strInfo = tmpVec3.toString();
                                singleMsg = new StringBuffer();
                                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouRec", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
                            }
                            singleMsg.append(LINE_SEPARATOR);
                            processMap.put("checkOutsideNotVoucher_RECOUT", singleMsg.toString());
                        }
                        outsideNotVoucher = false;
                    } else {
                        outsideNotVoucher = true;
                    }
                } else {
                    outsideNotVoucher = !outsideNotVoucher;
                }
                processMap.put("outsideNotVoucher", outsideNotVoucher);
                processData.add(processMap);
            }
        }
        return processData;
    }

    private String checkNotBookBill(Context ctx, boolean needAllBook, int bookType, Map checkMsg) {
        StringBuffer singleMsg = new StringBuffer();
        Vector tmpVec = null;
        String strInfo = null;
        if (bookType == 0) {
            if (checkMsg.get("RECEIVINGBOOK") != null) {
                tmpVec = (Vector)checkMsg.get("RECEIVINGBOOK");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    singleMsg.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookRecMsg", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                singleMsg.append(LINE_SEPARATOR);
            }
            if (checkMsg.get("PAYMENTBOOK") != null) {
                tmpVec = (Vector)checkMsg.get("PAYMENTBOOK");
                if (!tmpVec.isEmpty()) {
                    strInfo = tmpVec.toString();
                    singleMsg.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookPayMsg", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
                }
                singleMsg.append(LINE_SEPARATOR);
            }
        }
        if (needAllBook && bookType == 1 && checkMsg.get("VOUCHERBOOK") != null) {
            tmpVec = (Vector)checkMsg.get("VOUCHERBOOK");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)resourcePath, (String)"ExistNoBookVoucherMsg", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        return singleMsg.toString();
    }

    private String checkInsideNotVoucherBill(Context ctx, Map checkMsg) {
        StringBuffer singleMsg = new StringBuffer();
        Vector tmpVec = null;
        String strInfo = "";
        if (checkMsg.get("PAYINNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("PAYINNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouPay", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        if (checkMsg.get("RECINNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("RECINNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasInSideNotVouRec", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        return singleMsg.toString();
    }

    private String checkOutsideNotVoucherBill(Context ctx, Map checkMsg) {
        String strInfo;
        Vector tmpVec;
        StringBuffer singleMsg = new StringBuffer();
        if (checkMsg.get("PAYOUTNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("PAYOUTNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouPay", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        if (checkMsg.get("RECOUTNOTVOUCHER") != null) {
            tmpVec = (Vector)checkMsg.get("RECOUTNOTVOUCHER");
            if (!tmpVec.isEmpty()) {
                strInfo = tmpVec.toString();
                singleMsg.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"hasOutSideNotVouRec", (Locale)ctx.getLocale())).append(strInfo.subSequence(1, strInfo.length() - 1));
            }
            singleMsg.append(LINE_SEPARATOR);
        }
        return singleMsg.toString();
    }

    @Override
    protected Map _checkOut(Context ctx, String modelStr) throws BOSException, EASBizException {
        HashMap<String, Object> checkOutMsg;
        block36: {
            int error = 0;
            String errorMsg = null;
            checkOutMsg = new HashMap<String, Object>();
            ArrayList errors = new ArrayList();
            checkOutMsg.put("errors", errors);
            int errorIndex = 0;
            IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
            Map initCompanyData = this.getInitDataCompanyMap(ctx);
            ArrayList<String> validComList = new ArrayList<String>();
            ArrayList<String> invalidComList = new ArrayList<String>();
            HashMap<String, String> notCheckOutMsgMap = new HashMap<String, String>();
            boolean isFalse = true;
            boolean isByhand = false;
            if (modelStr.startsWith("checkoutByhand")) {
                isByhand = true;
                modelStr = modelStr.substring(14);
            }
            try {
                List checkOutData = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr, List.class);
                if (modelStr == null || checkOutData.size() == 0) {
                    error = 1;
                    errorMsg = CASWebUtil.getResource(ctx, "PelSelectedOneDataRow");
                    checkOutMsg.put("error", error);
                    checkOutMsg.put("errorMsg", errorMsg);
                    return checkOutMsg;
                }
                if (checkOutData.size() <= 0) break block36;
                ArrayList checkMsg = new ArrayList();
                List initCheckoutData = null;
                for (int i = 0; i < checkOutData.size(); ++i) {
                    String checkNotBookMsg;
                    HashMap<String, Object> errorListMsg;
                    boolean isIgnore = false;
                    Map row = (Map)checkOutData.get(i);
                    HashMap checkRow = new HashMap();
                    String reportMsg = null;
                    String companyId = (String)row.get("company_id");
                    HashMap<String, String> map = new HashMap<String, String>();
                    String filters = "a.Fid = '" + companyId + "'";
                    map.put("filters", filters);
                    initCheckoutData = FinalCheckoutFactory.getLocalInstance(ctx).getInitData(map);
                    if (initCheckoutData != null && initCheckoutData.size() > 0) {
                        initCheckoutData.remove(0);
                    }
                    List processData = this.processData(ctx, initCheckoutData);
                    int cs001 = new Integer(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS001"));
                    boolean cs002 = Boolean.valueOf(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS002"));
                    if (processData != null) {
                        for (int z = 0; z < processData.size(); ++z) {
                            Map info = (Map)processData.get(z);
                            FullOrgUnitInfo curCompany = (FullOrgUnitInfo)info.get("company");
                            PeriodInfo curPeriodInfo = (PeriodInfo)info.get("curPeriod");
                            if (!companyId.equals(curCompany.getId().toString())) continue;
                            row.put("close_init", info.get("isStart").toString());
                            row.put("voucher_book", info.get("needAllBook").toString());
                            row.put("bookType", info.get("bookType").toString());
                            row.put("balace_equal", info.get("is_gl_balance").toString());
                            row.put("inside_not_voucher", info.get("insideNotVoucher").toString());
                            row.put("outside_not_voucher", info.get("outsideNotVoucher").toString());
                            row.put("isIgnore", info.get("is_gl_balance_ignore").toString());
                            row.put("isStart_msg", info.get("isStart_msg"));
                            row.put("gl_balance_msg", info.get("gl_balance_msg"));
                            row.put("needAllBook_Msg", info.get("needAllBook_Msg"));
                            row.put("checkInsideNotVoucher_Msg", info.get("checkInsideNotVoucher_Msg"));
                            row.put("checkInsideNotVoucher_PAYIN", info.get("checkInsideNotVoucher_PAYIN"));
                            row.put("checkInsideNotVoucher_RECIN", info.get("checkInsideNotVoucher_RECIN"));
                            row.put("checkOutsideNotVoucher_Msg", info.get("checkOutsideNotVoucher_Msg"));
                            row.put("checkOutsideNotVoucher_PAYOUT", info.get("checkOutsideNotVoucher_PAYOUT"));
                            row.put("checkOutsideNotVoucher_RECOUT", info.get("checkOutsideNotVoucher_RECOUT"));
                        }
                    }
                    boolean isStart = Boolean.parseBoolean((String)row.get("close_init"));
                    boolean is_gl_balance = Boolean.parseBoolean((String)row.get("balace_equal"));
                    boolean needAllBook = Boolean.parseBoolean((String)row.get("voucher_book"));
                    boolean forbitInsideNotVoucherBill = Boolean.parseBoolean((String)row.get("inside_not_voucher"));
                    boolean forbitOutsideNotVoucherBill = Boolean.parseBoolean((String)row.get("outside_not_voucher"));
                    isIgnore = Boolean.parseBoolean((String)row.get("isIgnore"));
                    checkRow.put("id", row.get("id"));
                    checkRow.put("companyId", companyId);
                    checkRow.put("period", row.get("period"));
                    checkRow.put("operation", "no");
                    checkRow.put("periodError", "");
                    checkRow.put("isStart", "");
                    checkRow.put("periodIsAdjust", "");
                    checkRow.put("exception", "");
                    checkRow.put("notCheckoutByCompany", "");
                    checkRow.put("unCheckout", "");
                    checkRow.put("antiCheckOut_PeriodMsg", "");
                    checkRow.put("samePeriod", "");
                    checkRow.put("cancelCASAndGL", "");
                    checkRow.put("checkOut", "true");
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_finalcheckout_01checkout");
                    if (!isPermission) {
                        String checkOutPermission;
                        reportMsg = errorMsg = (checkOutPermission = CASWebUtil.getResource(ctx, "281_noCheckOutPermission"));
                        checkRow.put("periodError", errorMsg);
                        checkRow.put("checkMsg", reportMsg);
                        checkMsg.add(checkRow);
                        continue;
                    }
                    PeriodInfo period = new PeriodInfo();
                    period.setId(BOSUuid.read((String)row.get("period_id").toString()));
                    period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
                    if (isByhand || isStart && needAllBook && is_gl_balance && forbitInsideNotVoucherBill && forbitOutsideNotVoucherBill) {
                        validComList.add(companyId);
                    } else {
                        invalidComList.add(companyId);
                        StringBuffer msg = new StringBuffer();
                        msg.append(row.get("isStart_msg") != null ? row.get("isStart_msg") : "").append(row.get("gl_balance_msg") != null ? row.get("gl_balance_msg") : "").append(row.get("needAllBook_Msg") != null ? row.get("needAllBook_Msg") : "").append(row.get("checkInsideNotVoucher_Msg") != null ? row.get("checkInsideNotVoucher_Msg") : "").append(row.get("checkOutsideNotVoucher_Msg") != null ? row.get("checkOutsideNotVoucher_Msg") : "");
                        notCheckOutMsgMap.put(companyId, msg.toString());
                        checkRow.put("isStart_msg", row.get("isStart_msg"));
                        checkRow.put("gl_balance_msg", row.get("gl_balance_msg"));
                        checkRow.put("needAllBook_Msg", row.get("needAllBook_Msg"));
                        checkRow.put("checkInsideNotVoucher_Msg", row.get("checkInsideNotVoucher_Msg"));
                        checkRow.put("checkOutsideNotVoucher_Msg", row.get("checkOutsideNotVoucher_Msg"));
                        reportMsg = msg.toString();
                        isFalse = false;
                        if (row.get("isStart_msg") != null && !row.get("isStart_msg").equals("")) {
                            checkMsg.add(checkRow);
                            checkOutMsg.put("checkMsg", checkMsg);
                            checkOutMsg.put("error", error);
                            checkOutMsg.put("errorMsg", row.get("isStart_msg"));
                            errorListMsg = new HashMap();
                            errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                            errorListMsg.put("company_name", row.get("isStart_msg"));
                            errorListMsg.put("operation", CASWebUtil.getResource(ctx, "335_PROCESS"));
                            errorListMsg.put("operatfunction", "showIsStart");
                            errorListMsg.put("company_id", checkRow.get("companyId"));
                            errors.add(errorListMsg);
                        }
                        if (row.get("gl_balance_msg") != null && !row.get("gl_balance_msg").equals("")) {
                            checkMsg.add(checkRow);
                            checkOutMsg.put("checkMsg", checkMsg);
                            checkOutMsg.put("error", error);
                            checkOutMsg.put("errorMsg", row.get("gl_balance_msg"));
                            errorListMsg = new HashMap();
                            errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                            errorListMsg.put("company_name", row.get("gl_balance_msg"));
                            errorListMsg.put("operation", CASWebUtil.getResource(ctx, "335_PROCESS"));
                            if (isIgnore) {
                                errorListMsg.put("orgNumber", "ignore");
                            }
                            errorListMsg.put("operatfunction", "glBalance");
                            errorListMsg.put("company_id", checkRow.get("companyId"));
                            errorListMsg.put("period_id", period.getNumber());
                            errors.add(errorListMsg);
                        }
                        if (row.get("needAllBook_Msg") != null && !row.get("needAllBook_Msg").equals("")) {
                            checkMsg.add(checkRow);
                            checkOutMsg.put("checkMsg", checkMsg);
                            checkOutMsg.put("error", error);
                            checkOutMsg.put("errorMsg", row.get("needAllBook_Msg"));
                            errorListMsg = new HashMap();
                            errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                            errorListMsg.put("company_name", row.get("needAllBook_Msg"));
                            errorListMsg.put("operation", CASWebUtil.getResource(ctx, "335_PROCESS"));
                            errorListMsg.put("operatfunction", "needAllBook");
                            if (!cs002 || cs001 == 0) {
                                errorListMsg.put("continueCheckOut", CASWebUtil.getResource(ctx, "509_CONTINUECHECKOUT"));
                                errorListMsg.put("continueCheckOutfuc", "checkOut");
                            }
                            errorListMsg.put("company_id", checkRow.get("companyId"));
                            errorListMsg.put("period_beginDate", period.getBeginDate());
                            errorListMsg.put("period_endDate", period.getEndDate());
                            errors.add(errorListMsg);
                        }
                        if (row.get("checkInsideNotVoucher_Msg") != null && !row.get("checkInsideNotVoucher_Msg").equals("")) {
                            checkMsg.add(checkRow);
                            checkOutMsg.put("checkMsg", checkMsg);
                            checkOutMsg.put("error", error);
                            checkOutMsg.put("errorMsg", row.get("checkInsideNotVoucher_Msg"));
                            errorListMsg = new HashMap();
                            if (row.get("checkInsideNotVoucher_RECIN") != null && !row.get("checkInsideNotVoucher_RECIN").equals("")) {
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", row.get("checkInsideNotVoucher_RECIN"));
                                errorListMsg.put("operation", CASWebUtil.getResource(ctx, "335_PROCESS"));
                                errorListMsg.put("operatfunction", "recInNotVoucher");
                                if (!cs002 || cs001 == 0) {
                                    errorListMsg.put("continueCheckOut", CASWebUtil.getResource(ctx, "509_CONTINUECHECKOUT"));
                                    errorListMsg.put("continueCheckOutfuc", "checkOut");
                                }
                                errorListMsg.put("company_id", checkRow.get("companyId"));
                                errorListMsg.put("period_beginDate", period.getBeginDate());
                                errorListMsg.put("period_endDate", period.getEndDate());
                                errors.add(errorListMsg);
                            }
                            if (row.get("checkInsideNotVoucher_PAYIN") != null && !row.get("checkInsideNotVoucher_PAYIN").equals("")) {
                                errorListMsg = new HashMap();
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", row.get("checkInsideNotVoucher_PAYIN"));
                                errorListMsg.put("operation", CASWebUtil.getResource(ctx, "335_PROCESS"));
                                errorListMsg.put("operatfunction", "payInNotVoucher");
                                if (!cs002 || cs001 == 0) {
                                    errorListMsg.put("continueCheckOut", CASWebUtil.getResource(ctx, "509_CONTINUECHECKOUT"));
                                    errorListMsg.put("continueCheckOutfuc", "checkOut");
                                }
                                errorListMsg.put("company_id", checkRow.get("companyId"));
                                errorListMsg.put("period_beginDate", period.getBeginDate());
                                errorListMsg.put("period_endDate", period.getEndDate());
                                errors.add(errorListMsg);
                            }
                        }
                        if (row.get("checkOutsideNotVoucher_Msg") != null && !row.get("checkOutsideNotVoucher_Msg").equals("")) {
                            checkMsg.add(checkRow);
                            checkOutMsg.put("checkMsg", checkMsg);
                            checkOutMsg.put("error", error);
                            checkOutMsg.put("errorMsg", row.get("checkOutsideNotVoucher_Msg"));
                            errorListMsg = new HashMap();
                            if (row.get("checkOutsideNotVoucher_RECOUT") != null && !row.get("checkOutsideNotVoucher_RECOUT").equals("")) {
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", row.get("checkOutsideNotVoucher_RECOUT"));
                                errorListMsg.put("operation", CASWebUtil.getResource(ctx, "335_PROCESS"));
                                errorListMsg.put("operatfunction", "recInNotVoucher");
                                if (!cs002 || cs001 == 0) {
                                    errorListMsg.put("continueCheckOut", CASWebUtil.getResource(ctx, "509_CONTINUECHECKOUT"));
                                    errorListMsg.put("continueCheckOutfuc", "checkOut");
                                }
                                errorListMsg.put("company_id", checkRow.get("companyId"));
                                errorListMsg.put("period_beginDate", period.getBeginDate());
                                errorListMsg.put("period_endDate", period.getEndDate());
                                errors.add(errorListMsg);
                            }
                            if (row.get("checkOutsideNotVoucher_PAYOUT") != null && !row.get("checkOutsideNotVoucher_PAYOUT").equals("")) {
                                errorListMsg = new HashMap();
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", row.get("checkOutsideNotVoucher_PAYOUT"));
                                errorListMsg.put("operation", CASWebUtil.getResource(ctx, "335_PROCESS"));
                                errorListMsg.put("operatfunction", "payInNotVoucher");
                                if (!cs002 || cs001 == 0) {
                                    errorListMsg.put("continueCheckOut", CASWebUtil.getResource(ctx, "509_CONTINUECHECKOUT"));
                                    errorListMsg.put("continueCheckOutfuc", "checkOut");
                                }
                                errorListMsg.put("company_id", checkRow.get("companyId"));
                                errorListMsg.put("period_beginDate", period.getBeginDate());
                                errorListMsg.put("period_endDate", period.getEndDate());
                                errors.add(errorListMsg);
                            }
                        }
                    }
                    if (EmptyUtil.isEmpty((String)((String)row.get("period_id")))) {
                        String periodError = EASResource.getString((String)resourcePath, (String)"MSG_periodError", (Locale)ctx.getLocale());
                        errorMsg = errorMsg + periodError;
                        reportMsg = reportMsg + errorMsg;
                        isFalse = false;
                        checkMsg.add(checkRow);
                        checkOutMsg.put("checkMsg", checkMsg);
                        checkOutMsg.put("error", error);
                        checkOutMsg.put("errorMsg", errorMsg);
                        errorListMsg = new HashMap<String, Object>();
                        errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                        errorListMsg.put("company_name", errorMsg);
                        errors.add(errorListMsg);
                    }
                    int bookType = Integer.parseInt((String)row.get("bookType"));
                    if (!(needAllBook && bookType == 1 || (Map)row.get("checkMsg") == null || FMHelper.isEmpty((String)(checkNotBookMsg = this.checkNotBookBill(ctx, needAllBook, bookType, (Map)row.get("checkMsg"))).toString()))) {
                        errorMsg = errorMsg + checkNotBookMsg;
                        reportMsg = reportMsg + errorMsg;
                        isFalse = false;
                        checkMsg.add(checkRow);
                        checkOutMsg.put("checkMsg", checkMsg);
                        checkOutMsg.put("error", error);
                        checkOutMsg.put("errorMsg", errorMsg);
                        HashMap<String, String> errorListMsg2 = new HashMap<String, String>();
                        errorListMsg2.put("id", checkRow.get("id") + "_" + ++errorIndex);
                        errorListMsg2.put("company_name", errorMsg);
                        errors.add(errorListMsg2);
                    }
                    checkRow.put("checkMsg", reportMsg);
                    checkMsg.add(checkRow);
                }
                if (!isFalse) {
                    checkOutMsg.put("checkMsg", checkMsg);
                    checkOutMsg.put("error", error);
                }
                Map checkOutMap = new HashMap();
                if (validComList.size() > 0) {
                    try {
                        checkOutMap = FinalCheckoutFactory.getLocalInstance(ctx).finalCheckOutBatch(validComList);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        error = 1;
                        errorMsg = e.getMessage();
                    }
                }
                StringBuffer checkOutSuccMsg = new StringBuffer();
                if (checkOutMap.keySet().size() > 0) {
                    for (String key : checkOutMap.keySet()) {
                        FullOrgUnitInfo company = (FullOrgUnitInfo)initCompanyData.get(key);
                        for (int i = 0; i < checkMsg.size(); ++i) {
                            Object object = checkOutMap.get(key);
                            Map checkRow = (Map)checkMsg.get(i);
                            String companyId = (String)checkRow.get("companyId");
                            if (object instanceof String) {
                                if (!company.getId().toString().equals(companyId)) continue;
                                ((Map)checkMsg.get(i)).put("id", checkRow.get("id"));
                                ((Map)checkMsg.get(i)).put("company_id", checkRow.get("companyId"));
                                ((Map)checkMsg.get(i)).put("period", checkRow.get("period"));
                                String errorMessage = (String)object;
                                StringBuffer sb = new StringBuffer();
                                sb.append(company.getNumber()).append(" ").append(company.getName()).append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"454_FinalCheckOutBatchUI", (Locale)ctx.getLocale())).append(errorMessage).append(LINE_SEPARATOR);
                                ((Map)checkMsg.get(i)).put("checkMsg", sb.toString());
                                ((Map)checkMsg.get(i)).put("operation", "ng");
                                HashMap<String, String> errorListMsg = new HashMap<String, String>();
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", errorMessage);
                                errorListMsg.put("operatfunction", "showIsStart");
                                errorListMsg.put("company_id", (String)checkRow.get("companyId"));
                                errors.add(errorListMsg);
                                continue;
                            }
                            PeriodInfo period = (PeriodInfo)checkOutMap.get(key);
                            String[] args = new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())};
                            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()));
                            String result = mf.format(args);
                            if (!company.getId().toString().equals(companyId)) continue;
                            ((Map)checkMsg.get(i)).put("id", checkRow.get("id"));
                            ((Map)checkMsg.get(i)).put("company_id", checkRow.get("companyId"));
                            ((Map)checkMsg.get(i)).put("period", result);
                            ((Map)checkMsg.get(i)).put("checkMsg", CASWebUtil.getResource(ctx, "CHECKOUT_Success", new String[]{company.getNumber(), company.getName()}));
                            ((Map)checkMsg.get(i)).put("operation", "ok");
                        }
                    }
                    checkOutSuccMsg.append(LINE_SEPARATOR);
                }
                checkOutMsg.put("checkMsg", checkMsg);
                checkOutMsg.put("error", error);
            }
            catch (Exception e) {
                error = 1;
                errorMsg = e.getMessage();
                e.printStackTrace();
            }
        }
        return checkOutMsg;
    }

    private Map getInitDataCompanyMap(Context ctx) {
        HashMap<String, FullOrgUnitInfo> initCompanyMap = new HashMap<String, FullOrgUnitInfo>();
        try {
            this.initData = FinalCheckoutFactory.getLocalInstance(ctx).getInitData(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.initData != null) {
            for (int i = 0; i < this.initData.size(); ++i) {
                Map info = (Map)this.initData.get(i);
                FullOrgUnitInfo company = (FullOrgUnitInfo)info.get("company");
                initCompanyMap.put(company.getId().toString(), company);
            }
        }
        return initCompanyMap;
    }

    @Override
    protected Map _antiCheckOut(Context ctx, String modelStr) throws BOSException, EASBizException {
        HashMap<String, Object> antiCheckOutMsg;
        block26: {
            int error = 0;
            String errorMsg = null;
            antiCheckOutMsg = new HashMap<String, Object>();
            ArrayList errors = new ArrayList();
            boolean isFalse = true;
            antiCheckOutMsg.put("errors", errors);
            int errorIndex = 0;
            try {
                List antiCheckOutData = (List)JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr, List.class);
                if (modelStr == null || antiCheckOutData.size() == 0) {
                    error = 1;
                    errorMsg = CASWebUtil.getResource(ctx, "PelSelectedOneDataRow");
                    antiCheckOutMsg.put("error", error);
                    antiCheckOutMsg.put("errorMsg", errorMsg);
                    return antiCheckOutMsg;
                }
                if (antiCheckOutData.size() <= 0) break block26;
                ArrayList checkMsg = new ArrayList();
                for (int i = 0; i < antiCheckOutData.size(); ++i) {
                    Map row = (Map)antiCheckOutData.get(i);
                    HashMap checkRow = new HashMap();
                    String reportMsg = "";
                    String companyId = (String)row.get("company_id");
                    isFalse = true;
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)companyId));
                    checkRow.put("id", row.get("id"));
                    checkRow.put("companyId", companyId);
                    checkRow.put("operation", "no");
                    checkRow.put("checkOut", "");
                    try {
                        HashMap<String, String> errorListMsg;
                        HashMap<String, String> errorListMsg2;
                        this.startPeriod = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
                        this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
                        boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_finalcheckout_02unCheckout");
                        if (!isPermission) {
                            String checkOutUnPermission;
                            reportMsg = errorMsg = (checkOutUnPermission = CASWebUtil.getResource(ctx, "282_antiCheckOutPermission"));
                            checkRow.put("periodError", errorMsg);
                            checkRow.put("checkMsg", reportMsg);
                            checkMsg.add(checkRow);
                            continue;
                        }
                        if (this.startPeriod != null && PeriodHelper.isAfterStartPeriod(this.startPeriod, this.periodInfo)) {
                            this.prevPeriodInfo = PeriodUtils.getPrePeriodInfo(ctx, this.periodInfo);
                            if (this.prevPeriodInfo != null && PeriodHelper.isAfterStartPeriod(this.startPeriod, this.prevPeriodInfo)) {
                                if (this.periodInfo == null) {
                                    errorMsg = EASResource.getString((String)resourcePath, (String)"MSG_periodError", (Locale)ctx.getLocale());
                                    reportMsg = reportMsg + errorMsg;
                                    checkRow.put("periodError", errorMsg);
                                    isFalse = false;
                                    checkMsg.add(checkRow);
                                    antiCheckOutMsg.put("checkMsg", checkMsg);
                                    antiCheckOutMsg.put("error", error);
                                    antiCheckOutMsg.put("errorMsg", errorMsg);
                                    errorListMsg2 = new HashMap();
                                    errorListMsg2.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                    errorListMsg2.put("company_name", errorMsg);
                                    errors.add(errorListMsg2);
                                    return antiCheckOutMsg;
                                }
                                this.buff = new StringBuffer();
                                this.buff.append(EASResource.getString((String)resourcePath, (String)"CHECKOUT_current", (Locale)ctx.getLocale()));
                                Object[] args = new String[]{String.valueOf(this.periodInfo.getPeriodYear()), String.valueOf(this.periodInfo.getPeriodNumber())};
                                String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()), args);
                                this.buff.append(result);
                                this.buff.append(LINE_SEPARATOR);
                                this.buff2 = new StringBuffer();
                                this.buff2.append(this.buff);
                                this.buff2.append(EASResource.getString((String)resourcePath, (String)"PrevPeriod_Msg", (Locale)ctx.getLocale()));
                                args = new String[]{String.valueOf(this.prevPeriodInfo.getPeriodYear()), String.valueOf(this.prevPeriodInfo.getPeriodNumber())};
                                result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()), args);
                                this.buff2.append(result);
                                this.buff2.append(LINE_SEPARATOR);
                                this.buff2.append("");
                                this.buff2.append(LINE_SEPARATOR);
                            }
                        } else {
                            errorMsg = EASResource.getString((String)resourcePath, (String)"MSG_periodError", (Locale)ctx.getLocale());
                            reportMsg = reportMsg + errorMsg;
                            checkRow.put("periodError", errorMsg);
                            isFalse = false;
                            checkMsg.add(checkRow);
                            antiCheckOutMsg.put("checkMsg", checkMsg);
                            antiCheckOutMsg.put("error", error);
                            antiCheckOutMsg.put("errorMsg", errorMsg);
                            errorListMsg2 = new HashMap<String, String>();
                            errorListMsg2.put("id", checkRow.get("id") + "_" + ++errorIndex);
                            errorListMsg2.put("company_name", errorMsg);
                            errors.add(errorListMsg2);
                            return antiCheckOutMsg;
                        }
                        boolean flag = SystemStatusCtrolUtils.isStart(ctx, SystemEnum.CASHMANAGEMENT, company);
                        if (!flag) {
                            errorMsg = CASWebUtil.getResource(ctx, "AntiCheckOut_Not_Start_Msg");
                            reportMsg = reportMsg + errorMsg;
                            checkRow.put("isStart", errorMsg);
                            isFalse = false;
                            checkMsg.add(checkRow);
                            antiCheckOutMsg.put("checkMsg", checkMsg);
                            antiCheckOutMsg.put("error", error);
                            antiCheckOutMsg.put("errorMsg", errorMsg);
                            HashMap<String, String> errorListMsg3 = new HashMap<String, String>();
                            errorListMsg3.put("id", checkRow.get("id") + "_" + ++errorIndex);
                            errorListMsg3.put("company_name", errorMsg);
                            errors.add(errorListMsg3);
                            return antiCheckOutMsg;
                        }
                        if (this.periodInfo.isIsAdjustPeriod()) {
                            String companyid = company.getId().toString();
                            try {
                                AccountRefContrastCollection coll = FMClientHelper.getEnabledAcctRefContrastColl(ctx, companyid, DateTimeUtils.truncateDate((Date)this.periodInfo.getBeginDate()), DateTimeUtils.truncateDate((Date)this.periodInfo.getEndDate()));
                                if (coll != null && !coll.isEmpty()) {
                                    errorMsg = EASResource.getString((String)resourcePath, (String)"periodIsAdjust", (Locale)ctx.getLocale());
                                    reportMsg = reportMsg + errorMsg;
                                    checkRow.put("periodIsAdjust", errorMsg);
                                    isFalse = false;
                                    checkMsg.add(checkRow);
                                    antiCheckOutMsg.put("checkMsg", checkMsg);
                                    antiCheckOutMsg.put("error", error);
                                    antiCheckOutMsg.put("errorMsg", errorMsg);
                                    errorListMsg = new HashMap();
                                    errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                    errorListMsg.put("company_name", errorMsg);
                                    errors.add(errorListMsg);
                                    return antiCheckOutMsg;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                errorMsg = CASWebUtil.getResource(ctx, "AntiCheckOut_ExceptionMsg");
                                reportMsg = reportMsg + errorMsg;
                                checkRow.put("exception", errorMsg);
                                isFalse = false;
                                checkMsg.add(checkRow);
                                antiCheckOutMsg.put("checkMsg", checkMsg);
                                antiCheckOutMsg.put("error", error);
                                antiCheckOutMsg.put("errorMsg", errorMsg);
                                errorListMsg = new HashMap<String, String>();
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", errorMsg);
                                errors.add(errorListMsg);
                                return antiCheckOutMsg;
                            }
                        }
                        Date now = new Date();
                        Date invalidDate = company.getInvalidDate();
                        if (invalidDate != null && !invalidDate.after(now)) {
                            errorMsg = EASResource.getString((String)resourcePath, (String)"NotCheckoutByCompany", (Locale)ctx.getLocale());
                            reportMsg = reportMsg + errorMsg;
                            checkRow.put("notCheckoutByCompany", errorMsg);
                            isFalse = false;
                            checkMsg.add(checkRow);
                            antiCheckOutMsg.put("checkMsg", checkMsg);
                            antiCheckOutMsg.put("error", error);
                            antiCheckOutMsg.put("errorMsg", errorMsg);
                            errorListMsg = new HashMap();
                            errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                            errorListMsg.put("company_name", errorMsg);
                            errors.add(errorListMsg);
                            return antiCheckOutMsg;
                        }
                        try {
                            if (this.periodInfo.equals((Object)this.startPeriod)) {
                                errorMsg = EASResource.getString((String)resourcePath, (String)"MSG_unCheckout", (Locale)ctx.getLocale());
                                reportMsg = reportMsg + errorMsg;
                                checkRow.put("unCheckout", errorMsg);
                                isFalse = false;
                                checkMsg.add(checkRow);
                                antiCheckOutMsg.put("checkMsg", checkMsg);
                                antiCheckOutMsg.put("error", error);
                                antiCheckOutMsg.put("errorMsg", errorMsg);
                                errorListMsg = new HashMap();
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", errorMsg);
                                errors.add(errorListMsg);
                                return antiCheckOutMsg;
                            }
                            if (!PeriodHelper.isAfterStartPeriod(this.startPeriod, this.prevPeriodInfo)) {
                                errorMsg = EASResource.getString((String)resourcePath, (String)"AntiCheckOut_PeriodMsg", (Locale)ctx.getLocale());
                                reportMsg = reportMsg + errorMsg;
                                checkRow.put("antiCheckOut_PeriodMsg", errorMsg);
                                isFalse = false;
                                checkMsg.add(checkRow);
                                antiCheckOutMsg.put("checkMsg", checkMsg);
                                antiCheckOutMsg.put("error", error);
                                antiCheckOutMsg.put("errorMsg", errorMsg);
                                errorListMsg = new HashMap();
                                errorListMsg.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                errorListMsg.put("company_name", errorMsg);
                                errors.add(errorListMsg);
                                return antiCheckOutMsg;
                            }
                            SystemStatusCtrolUtils sscUtils = new SystemStatusCtrolUtils();
                            if (sscUtils.isRelatedAccount4Client(ctx, companyId, SystemEnum.CASHMANAGEMENT)) {
                                HashMap<String, String> errorListMsg4;
                                PeriodInfo glCurPeriod = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemEnum.GENERALLEDGER, company);
                                if (glCurPeriod != null && this.periodInfo != null && this.periodInfo.getPeriodYear() == glCurPeriod.getPeriodYear() && this.periodInfo.getPeriodNumber() == glCurPeriod.getPeriodNumber()) {
                                    errorMsg = CASWebUtil.getResource(ctx, "PeriodSameCASAndGL");
                                    reportMsg = reportMsg + errorMsg;
                                    checkRow.put("samePeriod", errorMsg);
                                    isFalse = false;
                                    checkMsg.add(checkRow);
                                    antiCheckOutMsg.put("checkMsg", checkMsg);
                                    antiCheckOutMsg.put("error", error);
                                    antiCheckOutMsg.put("errorMsg", errorMsg);
                                    errorListMsg4 = new HashMap();
                                    errorListMsg4.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                    errorListMsg4.put("company_name", errorMsg);
                                    errors.add(errorListMsg4);
                                    return antiCheckOutMsg;
                                }
                                if (sscUtils.isEqualsCurPeriodAndRelPeriod4Client(ctx, companyId, SystemEnum.CASHMANAGEMENT)) {
                                    errorMsg = CASWebUtil.getResource(ctx, "278_CancelCASAndGL");
                                    reportMsg = reportMsg + errorMsg;
                                    checkRow.put("cancelCASAndGL", errorMsg);
                                    isFalse = false;
                                    checkMsg.add(checkRow);
                                    antiCheckOutMsg.put("checkMsg", checkMsg);
                                    antiCheckOutMsg.put("error", error);
                                    antiCheckOutMsg.put("errorMsg", errorMsg);
                                    errorListMsg4 = new HashMap<String, String>();
                                    errorListMsg4.put("id", checkRow.get("id") + "_" + ++errorIndex);
                                    errorListMsg4.put("company_name", errorMsg);
                                    errors.add(errorListMsg4);
                                    return antiCheckOutMsg;
                                }
                            }
                            if (isFalse) {
                                IFinalCheckout checkout = FinalCheckoutFactory.getLocalInstance(ctx);
                                PeriodInfo tempPeriodInfo = checkout.deleteCheckAccount(companyId);
                                StringBuffer buff = new StringBuffer(EASResource.getString((String)resourcePath, (String)"CHECKOUT_turnover", (Locale)ctx.getLocale()));
                                this.periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, company);
                                if (this.periodInfo != null) {
                                    Object[] args = new String[]{String.valueOf(this.periodInfo.getPeriodYear()), String.valueOf(this.periodInfo.getPeriodNumber())};
                                    String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()), args);
                                    checkRow.put("period", result);
                                    checkRow.put("operation", "ok");
                                }
                                reportMsg = buff.toString();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errorMsg = CASWebUtil.getResource(ctx, "AntiCheckOut_ExceptionMsg");
                            reportMsg = reportMsg + errorMsg;
                            checkRow.put("exception", errorMsg);
                            isFalse = false;
                            error = 1;
                            antiCheckOutMsg.put("error", error);
                            antiCheckOutMsg.put("errorMsg", errorMsg);
                            return antiCheckOutMsg;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errorMsg = CASWebUtil.getResource(ctx, "AntiCheckOut_ExceptionMsg");
                        reportMsg = reportMsg + errorMsg;
                        checkRow.put("exception", errorMsg);
                        isFalse = false;
                        error = 1;
                        antiCheckOutMsg.put("error", error);
                        antiCheckOutMsg.put("errorMsg", errorMsg);
                        return antiCheckOutMsg;
                    }
                    checkRow.put("checkMsg", reportMsg);
                    checkMsg.add(checkRow);
                }
                antiCheckOutMsg.put("checkMsg", checkMsg);
                antiCheckOutMsg.put("error", error);
            }
            catch (Exception e) {
                error = 1;
                errorMsg = e.getMessage();
                e.printStackTrace();
            }
        }
        return antiCheckOutMsg;
    }
}

