/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamSimpleInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeSysEnum;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BankBalanceAdjustCollection;
import com.kingdee.eas.fi.cas.BankBalanceAdjustFactory;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasGLItemCheckRptInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IJournalBalance;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceFactory;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.app.AbstractFinalCheckoutControllerBean;
import com.kingdee.eas.fi.cas.subacct.ISubAcctFinalCheckoutFacade;
import com.kingdee.eas.fi.cas.subacct.SubAcctFinalCheckoutFacadeFactory;
import com.kingdee.eas.fi.gl.AccountBalanceCollection;
import com.kingdee.eas.fi.gl.AccountBalanceFactory;
import com.kingdee.eas.fi.gl.AccountBalanceInfo;
import com.kingdee.eas.fi.gl.AssistBalanceCollection;
import com.kingdee.eas.fi.gl.AssistBalanceFactory;
import com.kingdee.eas.fi.gl.AssistBalanceInfo;
import com.kingdee.eas.fi.gl.IAccountBalance;
import com.kingdee.eas.fi.gl.IAssistBalance;
import com.kingdee.eas.fi.gl.IInitAssistBalance;
import com.kingdee.eas.fi.gl.InitAssistBalanceCollection;
import com.kingdee.eas.fi.gl.InitAssistBalanceFactory;
import com.kingdee.eas.fi.gl.InitAssistBalanceInfo;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.fi.rpt.BalanceTypeEnum;
import com.kingdee.eas.fi.rpt.IReportCacl;
import com.kingdee.eas.fi.rpt.ReportCaclFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FinalCheckoutControllerBean
extends AbstractFinalCheckoutControllerBean {
    private static final Logger logger = CoreUIObject.getLogger(FinalCheckoutControllerBean.class);
    private static final String STRING_ZERO = "0";
    private static final String STRING_ONE = "1";
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    protected Map _checkBeforeCheckAccount(Context ctx, String companyId, Date beginDate, Date endDate, int param) throws EASBizException, BOSException {
        HashMap hashMap = new HashMap();
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo glPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)company);
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        param = new Integer(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS001"));
        boolean insideNotVoucheredBill = Boolean.valueOf(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS055"));
        boolean notVoucherBook = Boolean.valueOf(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS002"));
        boolean outsideNotVoucheredBill = Boolean.valueOf(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS056"));
        HashSet<String> companySet = new HashSet<String>();
        companySet.add(companyId);
        HashMap<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
        periodMap.put(companyId, periodInfo);
        if (insideNotVoucheredBill) {
            this.checkInsideNotVoucheredBill(ctx, hashMap, companySet, periodMap, beginDate, endDate);
        }
        if (outsideNotVoucheredBill) {
            this.checkOutsideNotVoucheredBill(ctx, hashMap, companySet, periodMap, beginDate, endDate);
        }
        if (param == 0) {
            this.checkRecPayBillBook(ctx, hashMap, companySet, periodMap, beginDate, endDate);
        }
        if (param == 1) {
            this.checkVoucherBook(ctx, hashMap, companySet, periodMap, beginDate, endDate);
        }
        if (SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company)) {
            IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
            boolean finalCheckOutIfCalEqualGl = localInstance.getBooleanParam("CS019", (IObjectPK)new ObjectUuidPK(company.getId()));
            if (glPeriodInfo != null && finalCheckOutIfCalEqualGl) {
                this._finalCheckAccount(ctx, companyId);
                Vector vec = this.getContrastWithGL(ctx, companyId, periodInfo.getId().toString());
                if (EmptyUtil.isEmpty(hashMap.get(companyId))) {
                    HashMap<String, Vector> gl = new HashMap<String, Vector>();
                    gl.put("gl_balance", vec);
                    hashMap.put(companyId, gl);
                } else {
                    ((Map)hashMap.get(companyId)).put("gl_balance", vec);
                }
                this._deleteCheckAccount(ctx, companyId);
            }
        }
        return hashMap;
    }

    protected Map checkAccountBefore(Context ctx, Set companySet, Map periodMap, Map hmAllParam) throws EASBizException, BOSException {
        HashSet<String> CS001Company = new HashSet<String>();
        Date begin001Date = null;
        Timestamp end001Date = null;
        HashSet<String> CS055Company = new HashSet<String>();
        Date begin055Date = null;
        Timestamp end055Date = null;
        HashSet<String> CS056Company = new HashSet<String>();
        Date begin056Date = null;
        Timestamp end056Date = null;
        HashSet<String> CS001BillCompany = new HashSet<String>();
        Date beginDate = null;
        Timestamp endDate = null;
        for (String comId : hmAllParam.keySet()) {
            Map params = (Map)hmAllParam.get(comId);
            PeriodInfo curPeriod = (PeriodInfo)periodMap.get(comId);
            int bookType = Integer.valueOf((String)params.get("CS001"));
            boolean notVoucherBook = Boolean.valueOf((String)params.get("CS002"));
            boolean insideNotVoucheredBill = Boolean.valueOf((String)params.get("CS055"));
            boolean outsideNotVoucheredBill = Boolean.valueOf((String)params.get("CS056"));
            if (bookType == 0) {
                CS001BillCompany.add(comId);
                if (beginDate == null || curPeriod.getBeginDate().before(beginDate)) {
                    beginDate = curPeriod.getBeginDate();
                }
                if (endDate == null || curPeriod.getEndDate().after((Date)endDate)) {
                    endDate = curPeriod.getEndDate();
                }
            }
            if (bookType == 1) {
                CS001Company.add(comId);
                if (begin001Date == null || curPeriod.getBeginDate().before(begin001Date)) {
                    begin001Date = curPeriod.getBeginDate();
                }
                if (end001Date == null || curPeriod.getEndDate().after((Date)end001Date)) {
                    end001Date = curPeriod.getEndDate();
                }
            }
            if (insideNotVoucheredBill) {
                CS055Company.add(comId);
                if (begin055Date == null || curPeriod.getBeginDate().before(begin055Date)) {
                    begin055Date = curPeriod.getBeginDate();
                }
                if (end055Date == null || curPeriod.getEndDate().after((Date)end055Date)) {
                    end055Date = curPeriod.getEndDate();
                }
            }
            if (!outsideNotVoucheredBill) continue;
            CS056Company.add(comId);
            if (begin056Date == null || curPeriod.getBeginDate().before(begin056Date)) {
                begin056Date = curPeriod.getBeginDate();
            }
            if (end056Date != null && !curPeriod.getEndDate().after((Date)end056Date)) continue;
            end056Date = curPeriod.getEndDate();
        }
        HashMap hashMap = new HashMap();
        if (CS055Company.size() > 0) {
            this.checkInsideNotVoucheredBill(ctx, hashMap, CS055Company, periodMap, begin055Date, end055Date);
        }
        if (CS056Company.size() > 0) {
            this.checkOutsideNotVoucheredBill(ctx, hashMap, CS056Company, periodMap, begin056Date, end056Date);
        }
        if (CS001BillCompany.size() > 0) {
            this.checkRecPayBillBook(ctx, hashMap, companySet, periodMap, beginDate, endDate);
        }
        if (CS001Company.size() > 0) {
            this.checkVoucherBook(ctx, hashMap, CS001Company, periodMap, begin001Date, end001Date);
        }
        return hashMap;
    }

    private void checkOutsideNotVoucheredBill(Context ctx, Map hashMap, Set companySet, Map periodMap, Date beginDate, Date endDate) throws BOSException {
        PeriodInfo period;
        String comId;
        RecPayBillInfo info;
        int index;
        EntityViewInfo viewInfo = this.getNotVoucherEntityViewInfo(companySet, beginDate, endDate);
        HashSet<Integer> outsideSettBizType = new HashSet<Integer>();
        outsideSettBizType.add(new Integer(2));
        outsideSettBizType.add(new Integer(1));
        FilterItemInfo filterOutside = new FilterItemInfo("bizType.type", outsideSettBizType, CompareType.INCLUDE);
        FilterInfo SettBizTypeFilter = new FilterInfo();
        SettBizTypeFilter.getFilterItems().add(filterOutside);
        viewInfo.getFilter().mergeFilter(SettBizTypeFilter, "and");
        IPaymentBill payment = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillCollection payCollection = payment.getPaymentBillCollection(viewInfo);
        IReceivingBill receive = ReceivingBillFactory.getLocalInstance(ctx);
        ReceivingBillCollection receiveCollection = receive.getReceivingBillCollection(viewInfo);
        for (index = 0; index < payCollection.size(); ++index) {
            info = payCollection.get(index);
            comId = info.getCompany().getId().toString();
            period = (PeriodInfo)periodMap.get(comId);
            if (!info.getBizDate().after(period.getBeginDate()) || !info.getBizDate().before(period.getEndDate())) continue;
            this.putNumberMap(hashMap, comId, info.getNumber(), "PAYOUTNOTVOUCHER");
        }
        for (index = 0; index < receiveCollection.size(); ++index) {
            info = receiveCollection.get(index);
            comId = info.getCompany().getId().toString();
            period = (PeriodInfo)periodMap.get(comId);
            if (!info.getBizDate().after(period.getBeginDate()) || !info.getBizDate().before(period.getEndDate())) continue;
            this.putNumberMap(hashMap, comId, info.getNumber(), "RECOUTNOTVOUCHER");
        }
    }

    private void checkInsideNotVoucheredBill(Context ctx, Map hashMap, Set companySet, Map periodMap, Date beginDate, Date endDate) throws BOSException {
        PeriodInfo period;
        String comId;
        RecPayBillInfo info;
        int index;
        EntityViewInfo viewInfo = this.getNotVoucherEntityViewInfo(companySet, beginDate, endDate);
        HashSet<Integer> outsideSettBizType = new HashSet<Integer>();
        outsideSettBizType.add(new Integer(4));
        outsideSettBizType.add(new Integer(3));
        outsideSettBizType.add(new Integer(51));
        outsideSettBizType.add(new Integer(52));
        FilterItemInfo filterOutside = new FilterItemInfo("bizType.type", outsideSettBizType, CompareType.INCLUDE);
        FilterInfo SettBizTypeFilter = new FilterInfo();
        SettBizTypeFilter.getFilterItems().add(filterOutside);
        viewInfo.getFilter().mergeFilter(SettBizTypeFilter, "and");
        IPaymentBill payment = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillCollection payCollection = payment.getPaymentBillCollection(viewInfo);
        IReceivingBill receive = ReceivingBillFactory.getLocalInstance(ctx);
        ReceivingBillCollection receiveCollection = receive.getReceivingBillCollection(viewInfo);
        for (index = 0; index < payCollection.size(); ++index) {
            info = payCollection.get(index);
            comId = info.getCompany().getId().toString();
            period = (PeriodInfo)periodMap.get(comId);
            if (!info.getBizDate().after(period.getBeginDate()) || !info.getBizDate().before(period.getEndDate())) continue;
            this.putNumberMap(hashMap, comId, info.getNumber(), "PAYINNOTVOUCHER");
        }
        for (index = 0; index < receiveCollection.size(); ++index) {
            info = receiveCollection.get(index);
            comId = info.getCompany().getId().toString();
            period = (PeriodInfo)periodMap.get(comId);
            if (!info.getBizDate().after(period.getBeginDate()) || !info.getBizDate().before(period.getEndDate())) continue;
            this.putNumberMap(hashMap, comId, info.getNumber(), "RECINNOTVOUCHER");
        }
    }

    protected void putNumberMap(Map hashMap, String comId, String number, String key) {
        if (hashMap.containsKey(comId)) {
            Map numberMap = (Map)hashMap.get(comId);
            if (numberMap.containsKey(key)) {
                Vector vecBook = (Vector)numberMap.get(key);
                if (vecBook.size() >= 5) {
                    if (vecBook.size() == 5) {
                        vecBook.add("......");
                    }
                } else {
                    vecBook.add(number);
                }
            } else {
                Vector<String> vecBook = new Vector<String>();
                vecBook.add(number);
                numberMap.put(key, vecBook);
            }
        } else {
            HashMap numberMap = new HashMap();
            Vector<String> vecBook = new Vector<String>();
            vecBook.add(number);
            numberMap.put(key, vecBook);
            hashMap.put(comId, numberMap);
        }
    }

    private EntityViewInfo getNotVoucherEntityViewInfo(Set companySet, Date periodStart, Date periodEnd) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("bizDate", (Object)periodStart, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("bizDate", (Object)periodEnd, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("fiVouchered", (Object)Boolean.FALSE));
        filterInfo.setMaskString("#0 and #1 and #2 and #3 ");
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("bizDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("company.id"));
        return viewInfo;
    }

    private EntityViewInfo getCheckEntityViewInfo(Set companySet, Date periodStart, Date periodEnd, int isneedpay) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("bizDate", (Object)periodStart, CompareType.GREATER_EQUALS));
        filterItems.add(new FilterItemInfo("bizDate", (Object)periodEnd, CompareType.LESS_EQUALS));
        filterItems.add(new FilterItemInfo("company.id", (Object)companySet, CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("cashier", null, CompareType.EQUALS));
        if (isneedpay == 1) {
            filterItems.add(new FilterItemInfo("isneedpay", (Object)new Integer(isneedpay)));
            filterInfo.setMaskString("#0 and #1 and #2 and #3 and #4");
        } else {
            filterInfo.setMaskString("#0 and #1 and #2 and #3 ");
        }
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo("bizDate"));
        viewInfo.getSelector().add(new SelectorItemInfo("company.id"));
        return viewInfo;
    }

    private void checkRecPayBillBook(Context ctx, Map hashMap, Set companySet, Map periodMap, Date beginDate, Date endDate) throws BOSException {
        PeriodInfo period;
        String comId;
        RecPayBillInfo info;
        int index;
        EntityViewInfo viewInfo = this.getCheckEntityViewInfo(companySet, beginDate, endDate, 1);
        IPaymentBill payment = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillCollection payColl = payment.getPaymentBillCollection(viewInfo);
        EntityViewInfo evi = this.getCheckEntityViewInfo(companySet, beginDate, endDate, 0);
        IReceivingBill receive = ReceivingBillFactory.getLocalInstance(ctx);
        ReceivingBillCollection recColl = receive.getReceivingBillCollection(evi);
        for (index = 0; index < payColl.size(); ++index) {
            info = payColl.get(index);
            comId = info.getCompany().getId().toString();
            period = (PeriodInfo)periodMap.get(comId);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier()) || !info.getBizDate().after(DateUtil.getBeforeDay((Date)period.getBeginDate())) || !info.getBizDate().before(DateUtil.getAfterDay((Date)period.getEndDate()))) continue;
            this.putNumberMap(hashMap, comId, info.getNumber(), "PAYMENTBOOK");
        }
        for (index = 0; index < recColl.size(); ++index) {
            info = recColl.get(index);
            comId = info.getCompany().getId().toString();
            period = (PeriodInfo)periodMap.get(comId);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCashier()) || !info.getBizDate().after(DateUtil.getBeforeDay((Date)period.getBeginDate())) || !info.getBizDate().before(DateUtil.getAfterDay((Date)period.getEndDate()))) continue;
            this.putNumberMap(hashMap, comId, info.getNumber(), "RECEIVINGBOOK");
        }
    }

    private void checkVoucherBook(Context ctx, Map hashMap, Set companySet, Map periodMap, Date beginDate, Date endDate) throws BOSException {
        this.checkVocherByBill(ctx, hashMap, companySet, periodMap, beginDate, endDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkVocherByBill(Context ctx, Map hashMap, Set companySet, Map periodMap, Date beginDate, Date endDate) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select v.FCompanyID, v.fnumber, v.FBookedDate from T_GL_VOUCHER v   \t\t\r\n").append("left join T_GL_VOUCHERENTRY ve on v.fid=ve.fbillid             \t\t\r\n").append("left join T_BD_ACCOUNTVIEW av on ve.faccountid=av.fid     \t\t\t\t\r\n").append(" where (av.fiscash =1 or av.fisbank=1)                             \t\r\n").append(" and (ve.FAccountID in (Select FAccountid From T_BD_AccountBanks) or av.fiscash =1) \r\n").append(" and ve.FCashierID is null and ve.FAccountID is not null           \t\r\n").append(" and v.FCompanyID in " + FMHelper.setTran2String((Set)companySet) + "       \r\n").append(" and v.FBookedDate >= ? and v.FBookedDate <= ? and v.fbizStatus <> ?   \r\n");
        String sql = sb.toString();
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.prepareStatement(sql);
            stmt.setDate(1, new java.sql.Date(beginDate.getTime()));
            stmt.setDate(2, new java.sql.Date(endDate.getTime()));
            stmt.setInt(3, 2);
            rs = stmt.executeQuery();
            while (rs.next()) {
                PeriodInfo period;
                String number = rs.getString("FNumber");
                String comId = rs.getString("FCompanyID");
                java.sql.Date bizDate = rs.getDate("FBookedDate");
                if (!bizDate.after(DateUtil.getBeforeDay((Date)(period = (PeriodInfo)periodMap.get(comId)).getBeginDate())) || !bizDate.before(DateUtil.getAfterDay((Date)period.getEndDate()))) continue;
                this.putNumberMap(hashMap, comId, number, "VOUCHERBOOK");
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    @Override
    protected IObjectValue _finalCheckAccount(Context ctx, String companyId) throws BOSException, EASBizException {
        this.addDataLock(ctx, companyId);
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        PeriodInfo nextPeriodInfo = PeriodUtils.getNextPeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
        if (nextPeriodInfo == null || nextPeriodInfo.getPeriodYear() == 0) {
            throw new CasException(CasException.NOPERIODDEF);
        }
        boolean isYearCheck = false;
        if (periodInfo.getPeriodYear() != nextPeriodInfo.getPeriodYear()) {
            isYearCheck = true;
        }
        this.genCurrentPeriodDataBySQL(ctx, companyId, periodInfo.getId().toString(), nextPeriodInfo.getId().toString(), isYearCheck);
        this.deleteUnCheckDataBySQL(ctx, companyId, periodInfo.getId().toString());
        this.genNextPeriodDataBySQL(ctx, companyId, periodInfo.getId().toString(), nextPeriodInfo.getId().toString(), isYearCheck);
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        ctrol.nextPeriod(SystemEnum.CASHMANAGEMENT, (OrgUnitInfo)company);
        this.addTaskExecutionRecord(ctx, companyId, periodInfo, false);
        return nextPeriodInfo;
    }

    protected void addTaskExecutionRecord(Context ctx, String companyId, PeriodInfo periodInfo, boolean isReverse) throws BOSException {
        TaskExecutionRecordThead thread = new TaskExecutionRecordThead(ctx, companyId, periodInfo, isReverse);
        thread.start();
    }

    private void genCurrentPeriodDataBySQL(Context ctx, String companyId, String currentPeriodId, String nextPeriodId, boolean isYearCheck) throws BOSException, EASBizException {
        StringBuffer strBuff = new StringBuffer();
        JournalBalanceInfo journalBalInfo = new JournalBalanceInfo();
        strBuff.append("insert into T_CAS_JournalBalance   \r\n").append("(  \r\n").append("FID,  \r\n").append("FCreateTime,  \r\n").append("FCompanyId, \r\n").append("FAccountViewId,  \r\n").append("FCurrencyId,  \r\n").append("FAccountBankId,  \r\n").append("FPeriodId,  \r\n").append("FMonthDebitAmt,  \r\n").append("FMonthCreditAmt,  \r\n").append("FMonthStartAmt,  \r\n").append("FMonthBalance,  \r\n").append("FYearStartAmt,  \r\n").append("FYearDebitAmt,  \r\n").append("FYearCreditAmt,  \r\n").append("FYearBalance,  \r\n").append("FDebitStartAmt,  \r\n").append("FCreditStartAmt,  \r\n").append("FIsInit,  \r\n").append("FIsBalanced,  \r\n").append("FType  \r\n").append(")  \r\n").append("select  \r\n").append("dbo.newbosid('").append(journalBalInfo.getBOSType().toString()).append("')  as FID,  \r\n").append("getDate(), \r\n").append("FCompanyId,  \r\n").append("FAccountViewId,  \r\n").append("FCurrencyId,  \r\n").append("FAccountBankId,  \r\n").append("FPeriodId,  \r\n").append("sum(ISNULL(FDebitAmount,0.00)) as FMonthDebitAmt,  \r\n").append("sum(ISNULL(FCreditAmount,0.00)) as FMonthCreditAmt,  \r\n");
        strBuff.append("sum(ISNULL(FMonthStartAmt,0.00)) as FMonthStartAmt,  \r\n").append("sum(ISNULL(FDebitAmount,0.00))-sum(ISNULL(FCreditAmount,0.00))+sum(ISNULL(FMonthStartAmt,0.00)) as FMonthBalance,  \r\n").append("sum(ISNULL(FYearStartAmt,0.00)) as FYearStartAmt,  \r\n").append("sum(ISNULL(FDebitAmount,0.00))+sum(ISNULL(FYearDebitAmt,0.00)) as FYearDebitAmt,  \r\n").append("sum(ISNULL(FCreditAmount,0.00))+sum(ISNULL(FYearCreditAmt,0.00)) as FYearCreditAmt,  \r\n").append("sum(ISNULL(FDebitAmount,0.00))-sum(ISNULL(FCreditAmount,0.00))+sum(ISNULL(FMonthStartAmt,0.00)) as FYearBalance,  \r\n");
        strBuff.append("0 as FDebitStartAmt,  \r\n").append("0 as FCreditStartAmt,  \r\n").append("0 AS FIsInit,  \r\n").append("3 AS FIsBalanced,  \r\n").append("FType  \r\n").append("FROM (  \r\n").append("SELECT FAccountBankId, fcurrencyid, fperiodid, faccountviewid,fcompanyid,  \r\n").append("sum(ISNULL(FDebitAmount,0.00)) as FDebitAmount,  \r\n").append("sum(ISNULL(FCreditAmount,0.00)) as FCreditAmount,  \r\n").append("0 as FMonthBalance,  \r\n").append("0 as FMonthStartAmt,  \r\n").append("0 as FYearStartAmt,  \r\n").append("0 as FYearDebitAmt,  \r\n").append("0 as FYearCreditAmt,  \r\n").append("0 as FYearBalance,  \r\n").append("FType  \r\n").append("from T_CAS_Journal  \r\n").append("WHERE FCompanyId=?  \r\n").append("AND FPeriodId=?  \r\n").append("GROUP BY FAccountViewId, FCompanyId, FPeriodId, FCurrencyId, FAccountBankId, FType  \r\n").append("union all  \r\n").append("select  FAccountBankId, fcurrencyid, fperiodid, faccountviewid,fcompanyid,0 as FDebitAmount,0 as FCreditAmount,  \r\n").append("FMonthBalance,FMonthStartAmt,FYearStartAmt, FYearDebitAmt,FYearCreditAmt,FYearBalance,ftype  \r\n").append("from T_CAS_JournalBalance  \r\n").append("WHERE FCompanyId=?  \r\n").append("AND FPeriodId=?  \r\n").append("AND FIsInit=0 and FType != 3  \r\n").append(") summary group by  faccountviewid, fcompanyid,fperiodid,fcurrencyid,FAccountBankId,ftype  \r\n").append("  \r\n").append("  \r\n").append("  \r\n").append("  \r\n");
        String sql = strBuff.toString();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{companyId, currentPeriodId, companyId, currentPeriodId});
    }

    private void deleteUnCheckDataBySQL(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String sql = "DELETE T_CAS_JournalBalance WHERE FCompanyId=? AND FPeriodId=? AND FType != 3 AND FIsInit != 1 AND FIsBalanced!=3 ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, strCompanyId);
            ps.setString(2, strPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void genNextPeriodDataBySQL(Context ctx, String companyId, String currentPeriodId, String nextPeriodId, boolean isYearCheck) throws BOSException, EASBizException {
        StringBuffer strBuff = new StringBuffer();
        JournalBalanceInfo journalBalInfo = new JournalBalanceInfo();
        strBuff.append("insert into T_CAS_JournalBalance   \r\n").append("(  \r\n").append("FID,  \r\n").append("FCompanyId, \r\n").append("FAccountViewId,  \r\n").append("FCurrencyId,  \r\n").append("FAccountBankId,  \r\n").append("FPeriodId,  \r\n").append("FMonthDebitAmt,  \r\n").append("FMonthCreditAmt,  \r\n").append("FMonthStartAmt,  \r\n").append("FMonthBalance,  \r\n").append("FYearStartAmt,  \r\n").append("FYearDebitAmt,  \r\n").append("FYearCreditAmt,  \r\n").append("FYearBalance,  \r\n").append("FDebitStartAmt,  \r\n").append("FCreditStartAmt,  \r\n").append("FIsInit,  \r\n").append("FIsBalanced,  \r\n").append("FType  \r\n").append(")  \r\n").append("select  \r\n").append("dbo.newbosID('").append(journalBalInfo.getBOSType().toString()).append("')  as FID,  \r\n").append("FCompanyId,  \r\n").append("FAccountViewId,  \r\n").append("FCurrencyId,  \r\n").append("FAccountBankId,  \r\n").append("'").append(nextPeriodId).append("'  as FPeriodId,  \r\n").append("0 as FMonthDebitAmt,  \r\n").append("0 as FMonthCreditAmt,  \r\n");
        if (isYearCheck) {
            strBuff.append("ISNULL(FMonthBalance,0.00) as  FMonthStartAmt,  \r\n").append("ISNULL(FMonthBalance,0.00) as FMonthBalance,  \r\n").append("ISNULL(FMonthBalance,0.00) as FYearStartAmt,  \r\n").append("0 as FYearDebitAmt,  \r\n").append("0 as FYearCreditAmt,  \r\n").append("ISNULL(FMonthBalance,0.00) as FYearBalance,  \r\n");
        } else {
            strBuff.append("ISNULL(FMonthBalance,0.00) as FMonthStartAmt,  \r\n").append("ISNULL(FMonthBalance,0.00) as FMonthBalance,  \r\n").append("ISNULL(FYearStartAmt,0.00) as FYearStartAmt,  \r\n").append("FYearDebitAmt,  \r\n").append("FYearCreditAmt,  \r\n").append("ISNULL(FMonthBalance,0.00) as FYearBalance,  \r\n");
        }
        strBuff.append("0 as FDebitStartAmt,  \r\n").append("0 as FCreditStartAmt,  \r\n").append("FIsInit,  \r\n").append("2 as FIsBalanced,  \r\n").append("FType  \r\n").append("from t_cas_journalbalance  \r\n").append("where FCompanyId =?  \r\n").append("and FPeriodId=?  \r\n").append("and FIsInit=0 and ftype != 3  \r\n").append("  \r\n").append("  \r\n").append("  \r\n").append("  \r\n").append("  \r\n").append("  \r\n");
        String sql = strBuff.toString();
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{companyId, currentPeriodId});
    }

    private BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? SysConstant.BIGZERO : big;
    }

    private void deleteOldJournalBalData(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        String sql = "DELETE T_CAS_JournalBalance WHERE FCompanyId=? AND FPeriodId=? AND FType != 3 AND FIsInit != 1 ";
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql);
            ps.setString(1, strCompanyId);
            ps.setString(2, strPeriodId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private EntityViewInfo getJournalBalanceEntityView(String companyId, String periodId) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection items = filterInfo.getFilterItems();
        if (companyId != null) {
            items.add(new FilterItemInfo("company.id", (Object)companyId));
        }
        if (periodId != null) {
            items.add(new FilterItemInfo("period.id", (Object)periodId));
        }
        items.add(new FilterItemInfo("isInit", (Object)Constants.FALSE));
        items.add(new FilterItemInfo("type", (Object)new Integer(3), CompareType.NOTEQUALS));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    private JournalBalanceCollection getJournalBalColl(Context ctx, EntityViewInfo viewInfo) throws BOSException {
        IJournalBalance iJournalBal = JournalBalanceFactory.getLocalInstance(ctx);
        JournalBalanceCollection journalBalColl = iJournalBal.getJournalBalanceCollection(viewInfo);
        return journalBalColl;
    }

    private void addDataLock(Context ctx, String companyId) throws BOSException {
        String sql = "UPDATE T_Org_Company SET FLastUpdateTime = ? WHERE FID = ? ";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{new Timestamp(Calendar.getInstance().getTimeInMillis()), companyId});
    }

    @Override
    protected IObjectValue _deleteCheckAccount(Context ctx, String companyId) throws BOSException, EASBizException {
        this.addDataLock(ctx, companyId);
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo.setId(BOSUuid.read((String)companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        String periodId = periodInfo.getId().toString();
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriodInfo.equals((Object)periodInfo) || !this.isAfterStartPeriod(startPeriodInfo, periodInfo)) {
            throw new CasException(CasException.CHECK_ANTICHECKOUT);
        }
        PeriodInfo prePeriodInfo = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)periodInfo);
        this.deleteOldJournalBalData(ctx, companyId, periodId);
        this.updatePreJournalBalData(ctx, companyId, periodId, prePeriodInfo.getId().toString());
        ISubAcctFinalCheckoutFacade iSubAcctFinalCheckoutFacade = SubAcctFinalCheckoutFacadeFactory.getLocalInstance(ctx);
        iSubAcctFinalCheckoutFacade.deleteCheckAccount(companyId);
        ISystemStatusCtrol ctrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        ctrol.prePeriod(SystemEnum.CASHMANAGEMENT, (OrgUnitInfo)companyInfo);
        this.addTaskExecutionRecord(ctx, companyId, periodInfo, true);
        return prePeriodInfo;
    }

    private boolean isAfterStartPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() <= periodInfo.getPeriodNumber();
    }

    private void updatePreJournalBalData(Context ctx, String companyId, String periodId, String prePeriodId) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = this.getJournalBalanceEntityView(companyId, prePeriodId);
        JournalBalanceCollection journalBalColl = this.getJournalBalColl(ctx, viewInfo);
        IJournalBalance iJournalBal = JournalBalanceFactory.getLocalInstance(ctx);
        int size = journalBalColl.size();
        for (int i = 0; i < size; ++i) {
            JournalBalanceInfo journalBalInfo = journalBalColl.get(i);
            BigDecimal debitAmt = this.getBigDecimal(journalBalInfo.getMonthDebitAmt());
            BigDecimal creditAmt = this.getBigDecimal(journalBalInfo.getMonthCreditAmt());
            BigDecimal monthEndBalance = this.getBigDecimal(journalBalInfo.getMonthBalance());
            journalBalInfo.setMonthBalance(monthEndBalance.subtract(debitAmt).add(creditAmt));
            journalBalInfo.setMonthDebitAmt(SysConstant.BIGZERO);
            journalBalInfo.setMonthCreditAmt(SysConstant.BIGZERO);
            BigDecimal yearDebitAmt = this.getBigDecimal(journalBalInfo.getYearDebitAmt());
            BigDecimal yearCreditAmt = this.getBigDecimal(journalBalInfo.getYearCreditAmt());
            journalBalInfo.setYearDebitAmt(yearDebitAmt.subtract(debitAmt));
            journalBalInfo.setYearCreditAmt(yearCreditAmt.subtract(creditAmt));
            journalBalInfo.setIsBalanced(false);
            BigDecimal yearEndBalance = this.getBigDecimal(journalBalInfo.getYearBalance());
            journalBalInfo.setYearBalance(yearEndBalance.subtract(debitAmt).add(creditAmt));
            iJournalBal.update((IObjectPK)new ObjectUuidPK(journalBalInfo.getId()), journalBalInfo);
        }
    }

    @Override
    protected void _synCasPeriod(Context ctx, String companyNumber, int periodYear, int periodNumber) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyNumber)) {
            return;
        }
        if (periodYear == 0) {
            throw new BOSException("periodYear can not is " + periodNumber);
        }
        if (periodNumber == 0) {
            throw new BOSException("periodNumber can not is " + periodNumber);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyNumber));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyNumber));
        filter.setMaskString("#0 or #1");
        ev.setFilter(filter);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        if (coll.size() == 0) {
            throw new BOSException("company " + companyNumber + "  not  exists ");
        }
        CompanyOrgUnitInfo com = coll.get(0);
        PeriodTypeInfo periodType = com.getAccountPeriodType();
        if (periodType == null) {
            throw new BOSException("periodType is null");
        }
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(periodYear, periodNumber, periodType);
        if (period == null || period.getId() == null) {
            throw new BOSException("period is null");
        }
        boolean isOK = false;
        while (!isOK) {
            isOK = this.synCasPeriod(ctx, com, period);
        }
    }

    private boolean synCasPeriod(Context ctx, CompanyOrgUnitInfo com, PeriodInfo period) throws BOSException, EASBizException {
        PeriodInfo currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)com);
        if (currPeriod.equalsPK((IObjectValue)period)) {
            return true;
        }
        if (period.getPeriodYear() * 100 + period.getPeriodNumber() < currPeriod.getPeriodYear() * 100 + currPeriod.getPeriodNumber()) {
            this._deleteCheckAccount(ctx, com.getId().toString());
        } else {
            this._finalCheckAccount(ctx, com.getId().toString());
        }
        return false;
    }

    protected Vector getContrastWithGL(Context ctx, String strCompanyId, String strPeriodId) throws BOSException, EASBizException {
        Vector vectorReport = new Vector();
        String currAcctTableId = this.getCurrAcctTableId(ctx, strCompanyId, strPeriodId);
        this.createContrastReportByCashAcct(ctx, strCompanyId, currAcctTableId, strPeriodId, vectorReport);
        this.createContrastReportByBank(ctx, strCompanyId, currAcctTableId, strPeriodId, vectorReport);
        this.createContrastReportByBankAcct(ctx, strCompanyId, currAcctTableId, strPeriodId, vectorReport);
        vectorReport.remove(null);
        return vectorReport;
    }

    private String getCurrAcctTableId(Context ctx, String companyId, String periodId) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String cuId = company.getCU().getId().toString();
        String acctTableId = company.getAccountTable().getId().toString();
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        String currAcctTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)cuId, (String)acctTableId, (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        return currAcctTableId;
    }

    private void createContrastReportByCashAcct(Context ctx, String strCompanyId, String acctTableId, String strPeriodId, Vector vectorReport) throws BOSException, EASBizException {
        CasGLItemCheckRptInfo rptInfo = null;
        String[] glsKeys = new String[]{"orgUnit", "account", "currency", "period"};
        String[] casKeys = new String[]{"company", "accountView", "currency", "period"};
        String[] bankKeys = new String[]{"company", "accountBank", "accountView", "currency", "period"};
        AccountBalanceCollection glsColl = this.getGLBalanceCollection(ctx, strCompanyId, acctTableId, strPeriodId, true);
        Map glsMap = null;
        if (glsColl != null && glsColl.size() > 0) {
            glsMap = CashHelper.getVOHashSearchMapWithPeriod((IObjectCollection)glsColl, glsKeys);
        }
        JournalBalanceInfo journalBalInfo2 = null;
        boolean isInitPeriod = this.isInitPeriod(ctx, strCompanyId, strPeriodId);
        isInitPeriod = false;
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, acctTableId, null, strPeriodId, AccountTypeEnum.CASHACCOUNT, isInitPeriod);
        Map casMap = new HashMap();
        if (journalBalColl != null && journalBalColl.size() > 0) {
            casMap = CashHelper.getVOHashSearchMapWithPeriod((IObjectCollection)journalBalColl, bankKeys);
        }
        int journalBalSize = 0;
        if (journalBalColl != null) {
            journalBalSize = journalBalColl.size();
        }
        Vector<String> glVec = new Vector<String>();
        Vector<String> casVec = new Vector<String>();
        if (glsMap != null && casMap != null && glsMap.size() > 0 && casMap.size() > 0) {
            for (int i = 0; i < journalBalSize; ++i) {
                AccountTypeEnum type;
                AccountBalanceInfo acctBalInfo;
                JournalBalanceInfo cashInfo = journalBalColl.get(i);
                String keyString = FMHelper.getKeyStringWithPeriod((IObjectValue)cashInfo, (String[])casKeys);
                String bankKeyString = FMHelper.getKeyStringWithPeriod((IObjectValue)cashInfo, (String[])bankKeys);
                if (!glsMap.containsKey(keyString) || this.isGeneralCurrency((acctBalInfo = (AccountBalanceInfo)glsMap.get(keyString)).getCurrency()) || (!(type = cashInfo.getType()).equals((Object)AccountTypeEnum.CASHACCOUNT) || !acctBalInfo.getAccount().isIsCash()) && (!type.equals((Object)AccountTypeEnum.BANKACCOUNT) || !acctBalInfo.getAccount().isIsBank())) continue;
                rptInfo = this.cashContrastGL(ctx, acctBalInfo, cashInfo);
                if (rptInfo != null) {
                    vectorReport.add(rptInfo);
                }
                glVec.add(keyString);
                casVec.add(bankKeyString);
            }
        }
        String removeKey = null;
        if (casVec != null && casVec.size() > 0) {
            for (int i = 0; i < casVec.size(); ++i) {
                removeKey = (String)casVec.get(i);
                casMap.remove(removeKey);
            }
        }
        if (casMap != null && casMap.size() > 0) {
            for (JournalBalanceInfo journalBalInfo2 : casMap.values()) {
                if (journalBalInfo2 == null || (rptInfo = this.cashContrastGL(ctx, null, journalBalInfo2)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
        if (glVec != null && glVec.size() > 0) {
            int size = glVec.size();
            for (int i = 0; i < size; ++i) {
                removeKey = (String)glVec.get(i);
                glsMap.remove(removeKey);
            }
        }
        if (glsMap != null && glsMap.size() > 0) {
            for (AccountBalanceInfo glAcctBalInfo : glsMap.values()) {
                if (glAcctBalInfo == null || this.isGeneralCurrency(glAcctBalInfo.getCurrency()) || (rptInfo = this.cashContrastGL(ctx, glAcctBalInfo, null)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
    }

    private void createContrastReportByBank(Context ctx, String strCompanyId, String acctTableId, String strPeriodId, Vector vectorReport) throws BOSException, EASBizException {
        JournalBalanceInfo journalBalInfo;
        boolean fGLStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompanyById(ctx, strCompanyId));
        JournalBalanceCollection bankJournalBalColl = null;
        bankJournalBalColl = this.isInitPeriod(ctx, strCompanyId, strPeriodId) ? this.getJournalBalanceCollection(ctx, strCompanyId, acctTableId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT, false) : this.getJournalBalanceCollection(ctx, strCompanyId, acctTableId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT, false);
        AccountBankCollection acctBankCol = this.getAccountBankCollection(ctx, strCompanyId, null);
        acctBankCol = FMHelper.getJouranlBalanceAcctBank((Context)ctx, (AccountBankCollection)acctBankCol, (String)strPeriodId, (String)acctTableId);
        Hashtable<String, JournalBalanceInfo> htExistCollection = new Hashtable<String, JournalBalanceInfo>();
        HashSet<String> currencySet = new HashSet<String>();
        if (bankJournalBalColl != null && bankJournalBalColl.size() != 0) {
            for (int i = 0; i < bankJournalBalColl.size(); ++i) {
                journalBalInfo = bankJournalBalColl.get(i);
                String accountBankId = journalBalInfo.getAccountBank().getId().toString();
                String acctViewId = journalBalInfo.getAccountView().getId().toString();
                String currencyId = journalBalInfo.getCurrency().getId().toString();
                currencySet.add(currencyId);
                htExistCollection.put(this.getIndexKey(accountBankId, acctViewId, currencyId), journalBalInfo);
            }
        }
        this.filterCurrencyId(ctx, currencySet, strCompanyId, strPeriodId);
        int intAcctBankColSize = 0;
        if (acctBankCol != null) {
            intAcctBankColSize = acctBankCol.size();
        }
        journalBalInfo = null;
        AccountBankInfo acctBankInfo = null;
        CasGLItemCheckRptInfo rptInfo = null;
        String indexKey = null;
        String strCurrencyId2 = null;
        for (int i = 0; i < intAcctBankColSize; ++i) {
            acctBankInfo = acctBankCol.get(i);
            String acctBankId = acctBankInfo.getId().toString();
            String strAccountId = acctBankInfo.getAccount().getId().toString();
            if (!acctBankInfo.getAccount().isIsBank()) continue;
            for (String strCurrencyId2 : currencySet) {
                indexKey = this.getIndexKey(acctBankId, strAccountId, strCurrencyId2);
                if (htExistCollection.containsKey(indexKey)) {
                    journalBalInfo = (JournalBalanceInfo)htExistCollection.get(indexKey);
                    strCurrencyId2 = journalBalInfo.getCurrency().getId().toString();
                    rptInfo = null;
                    rptInfo = this.cashContrastGLForCAS(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId2, strPeriodId, journalBalInfo, fGLStart);
                    if (rptInfo == null) continue;
                    vectorReport.add(rptInfo);
                    continue;
                }
                journalBalInfo = new JournalBalanceInfo();
                journalBalInfo.setAccountBank(acctBankInfo);
                journalBalInfo.setType(AccountTypeEnum.BANKACCOUNT);
                journalBalInfo.setAccountView(acctBankInfo.getAccount());
                journalBalInfo.setCurrency(this.getCurrencyById(ctx, strCurrencyId2));
                rptInfo = null;
                rptInfo = this.cashContrastGLForCAS(ctx, strCompanyId, acctBankInfo, strAccountId, strCurrencyId2, strPeriodId, journalBalInfo, fGLStart);
                if (rptInfo == null) continue;
                vectorReport.add(rptInfo);
            }
        }
    }

    private void createContrastReportByBankAcct(Context ctx, String strCompanyId, String acctTableId, String strPeriodId, Vector vectorReport) throws BOSException, EASBizException {
        CasGLItemCheckRptInfo rptInfo = null;
        String[] glsKeys = new String[]{"orgUnit", "account", "currency", "period"};
        String[] casKeys = new String[]{"company", "accountView", "currency", "period"};
        AccountBalanceCollection glsColl = this.getGLBalanceCollection(ctx, strCompanyId, acctTableId, strPeriodId, false);
        Map glsMap = new HashMap();
        if (glsColl != null && glsColl.size() > 0) {
            glsMap = CashHelper.getVOHashSearchMapWithPeriod((IObjectCollection)glsColl, glsKeys);
        }
        JournalBalanceInfo journalBalInfo2 = null;
        boolean isInitPeriod = this.isInitPeriod(ctx, strCompanyId, strPeriodId);
        isInitPeriod = false;
        JournalBalanceCollection journalBalColl = this.getJournalBalanceCollection(ctx, strCompanyId, acctTableId, null, strPeriodId, AccountTypeEnum.BANKACCOUNT, isInitPeriod);
        Map casMap = new HashMap();
        if (journalBalColl != null && journalBalColl.size() > 0) {
            casMap = this.getAcctBankSumSearchMap(journalBalColl, casKeys);
        }
        Vector<String> glVec = new Vector<String>();
        Vector<String> casVec = new Vector<String>();
        if (glsMap != null && casMap != null && glsMap.size() > 0 && casMap.size() > 0) {
            for (JournalBalanceInfo cashInfo : casMap.values()) {
                AccountBalanceInfo acctBalInfo;
                String keyString = FMHelper.getKeyStringWithPeriod((IObjectValue)cashInfo, (String[])casKeys);
                if (!glsMap.containsKey(keyString) || this.isGeneralCurrency((acctBalInfo = (AccountBalanceInfo)glsMap.get(keyString)).getCurrency())) continue;
                rptInfo = this.cashContrastGL(ctx, acctBalInfo, cashInfo);
                if (rptInfo != null) {
                    vectorReport.add(rptInfo);
                }
                glVec.add(keyString);
                casVec.add(keyString);
            }
        }
        String removeKey = null;
        if (casVec != null && casVec.size() > 0) {
            for (int i = 0; i < casVec.size(); ++i) {
                removeKey = (String)casVec.get(i);
                casMap.remove(removeKey);
            }
        }
        if (casMap != null && casMap.size() > 0) {
            for (JournalBalanceInfo journalBalInfo2 : casMap.values()) {
                if (journalBalInfo2 == null || (rptInfo = this.cashContrastGL(ctx, null, journalBalInfo2)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
        if (glVec != null && glVec.size() > 0) {
            int size = glVec.size();
            for (int i = 0; i < size; ++i) {
                removeKey = (String)glVec.get(i);
                glsMap.remove(removeKey);
            }
        }
        if (glsMap != null && glsMap.size() > 0) {
            for (AccountBalanceInfo glAcctBalInfo : glsMap.values()) {
                if (glAcctBalInfo == null || this.isGeneralCurrency(glAcctBalInfo.getCurrency()) || (rptInfo = this.cashContrastGL(ctx, glAcctBalInfo, null)) == null) continue;
                vectorReport.add(rptInfo);
            }
        }
    }

    private boolean isGeneralCurrency(CurrencyInfo currency) {
        String currencyId = null;
        if (currency == null) {
            return false;
        }
        currencyId = currency.getId().toString();
        return currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString());
    }

    private CasGLItemCheckRptInfo cashContrastGL(Context ctx, AccountBalanceInfo glInitInfo, JournalBalanceInfo journalBalInfo) throws EASBizException, BOSException {
        CasGLItemCheckRptInfo rpt = null;
        if (glInitInfo == null && journalBalInfo == null) {
            return null;
        }
        BigDecimal casMonthBalance = ZERO;
        BigDecimal glMonthBalance = ZERO;
        AccountTypeEnum acctType = AccountTypeEnum.CASHACCOUNT;
        if (glInitInfo != null && journalBalInfo != null) {
            AccountViewInfo acctViewInfo;
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            acctType = journalBalInfo.getType();
            casMonthBalance = this.getBigDecimal(journalBalInfo.getMonthBalance()).setScale(journalBalInfo.getCurrency().getPrecision(), 1);
            glMonthBalance = this.getBigDecimal(glInitInfo.getEndBalanceFor().setScale(glInitInfo.getCurrency().getPrecision(), 1));
            if ((acctType.equals((Object)AccountTypeEnum.BANKACCOUNT) || acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) && (acctViewInfo = glInitInfo.getAccount()).isIsBank() && (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null)) {
                AsstAccountInfo asstAcctInfo = null;
                if (acctViewInfo.getGAA() != null) {
                    asstAcctInfo = acctViewInfo.getGAA();
                }
                if (acctViewInfo.getCAA() != null) {
                    asstAcctInfo = acctViewInfo.getCAA();
                }
                Object asstHGInfo = null;
                if (asstAcctInfo != null && asstAcctInfo.getId() != null) {
                    this.getHasAssistant(ctx, journalBalInfo.getAccountBank().getId().toString(), asstAcctInfo.getId().toString());
                }
                if (asstHGInfo != null) {
                    String asstHGId = asstHGInfo.getId().toString();
                    glMonthBalance = this.getAssistantBeginAmt(ctx, journalBalInfo, journalBalInfo.getCompany().getId().toString(), journalBalInfo.getCurrency().getId().toString(), journalBalInfo.getPeriod().getId().toString(), acctViewInfo.getId().toString(), asstHGId, false);
                }
            }
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            if (casMonthBalance.compareTo(glMonthBalance) != 0) {
                rpt = this.getContrastRptInfo(ctx, journalBalInfo, casMonthBalance, glMonthBalance);
            }
        } else if (glInitInfo != null && journalBalInfo == null) {
            if (this.isGeneralCurrency(glInitInfo.getCurrency())) {
                return null;
            }
            glMonthBalance = this.getBigDecimal(glInitInfo.getEndBalanceFor()).setScale(glInitInfo.getCurrency().getPrecision(), 4);
            if (glMonthBalance.signum() != 0) {
                rpt = this.getGLContrastRptInfo(glInitInfo, casMonthBalance, glMonthBalance, null);
            }
        } else if (glInitInfo == null && journalBalInfo != null) {
            if (this.isGeneralCurrency(journalBalInfo.getCurrency())) {
                return null;
            }
            casMonthBalance = this.getBigDecimal(journalBalInfo.getMonthBalance()).setScale(journalBalInfo.getCurrency().getPrecision(), 4);
            if (casMonthBalance.signum() != 0) {
                rpt = this.getContrastRptInfo(ctx, journalBalInfo, casMonthBalance, glMonthBalance);
            }
        }
        return rpt;
    }

    private CasGLItemCheckRptInfo getGLContrastRptInfo(AccountBalanceInfo glInitInfo, BigDecimal casMonthBalance, BigDecimal glMonthBalance, AccountBankInfo acctBankInfo) {
        CurrencyInfo currency = glInitInfo.getCurrency();
        if (currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) || currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) {
            return null;
        }
        CasGLItemCheckRptInfo rptInfo = new CasGLItemCheckRptInfo();
        if (acctBankInfo != null) {
            rptInfo.setAccountBankInfo(acctBankInfo);
            rptInfo.setBankInfo(this.getBankInfo(acctBankInfo));
        }
        AccountViewInfo accountInfo = glInitInfo.getAccount();
        rptInfo.setAccountViewInfo(accountInfo);
        rptInfo.setCurrencyInfo(currency);
        rptInfo.setCasStartAmt(casMonthBalance);
        rptInfo.setGlStartAmt(glMonthBalance);
        return rptInfo;
    }

    private BankInfo getBankInfo(AccountBankInfo acctBankInfo) {
        if (acctBankInfo == null || acctBankInfo.getBank() == null) {
            return null;
        }
        return acctBankInfo.getBank();
    }

    private CasGLItemCheckRptInfo getContrastRptInfo(Context ctx, JournalBalanceInfo journalBalInfo, BigDecimal casMonthBalance, BigDecimal glMonthBalance) throws EASBizException, BOSException {
        AccountBankInfo accountBank;
        boolean needCheck;
        CurrencyInfo currency = journalBalInfo.getCurrency();
        if (currency.getId().equals((Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID) || currency.getId().equals((Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID)) {
            return null;
        }
        if (journalBalInfo.getType() != null && journalBalInfo.getType().equals((Object)AccountTypeEnum.BANKACCOUNT) && !(needCheck = this.needCheck(ctx, (accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(journalBalInfo.getAccountBank().getId()))).getCompany().getId().toString(), accountBank, journalBalInfo.getAccountView().getId().toString()))) {
            return null;
        }
        CasGLItemCheckRptInfo rptInfo = new CasGLItemCheckRptInfo();
        if (journalBalInfo.getType() != null && journalBalInfo.getType().equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            rptInfo.setAccountBankInfo(journalBalInfo.getAccountBank());
            rptInfo.setBankInfo(this.getBankInfo(journalBalInfo.getAccountBank()));
        }
        rptInfo.setAccountViewInfo(journalBalInfo.getAccountView());
        rptInfo.setCurrencyInfo(currency);
        rptInfo.setCasStartAmt(casMonthBalance);
        rptInfo.setGlStartAmt(glMonthBalance);
        return rptInfo;
    }

    public boolean needCheck(Context ctx, String companyId, AccountBankInfo acctBank, String accountId) throws EASBizException, BOSException {
        AccountViewInfo acctViewInfo = this.getAcctViewInfoById(ctx, accountId);
        if (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null) {
            AsstAccountInfo asstAcctInfo = null;
            if (acctViewInfo.getGAA() != null) {
                asstAcctInfo = acctViewInfo.getGAA();
            }
            if (acctViewInfo.getCAA() != null) {
                asstAcctInfo = acctViewInfo.getCAA();
            }
            if (this.isHasAssistant(ctx, acctBank.getId().toString(), asstAcctInfo.getId().toString())) {
                return true;
            }
        }
        return !FMHelper.isExistMultiBankAcct((Context)ctx, (String)companyId, (String)accountId);
    }

    private boolean isHasAssistant(Context ctx, String bankAccountId, String asstAcctViewId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAcctViewId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        return assistantHGColl != null && assistantHGColl.size() != 0;
    }

    private AccountViewInfo getAcctViewInfoById(Context ctx, String acctViewId) throws EASBizException, BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("GAA.id"));
        selector.add(new SelectorItemInfo("GAA.name"));
        selector.add(new SelectorItemInfo("CAA.id"));
        selector.add(new SelectorItemInfo("CAA.name"));
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("id", (Object)acctViewId));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        AccountViewCollection acctViewCol = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(evi);
        return acctViewCol == null ? null : acctViewCol.get(0);
    }

    private JournalBalanceCollection getJournalBalanceCollection(Context ctx, String strCompanyId, String acctTableId, String strCurrencyId, String strPeriodId, AccountTypeEnum type, boolean isInit) throws BOSException {
        IJournalBalance iJournalBalance = JournalBalanceFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        viewInfo.setFilter(filterInfo);
        if (strCurrencyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("currency", (Object)strCurrencyId));
        }
        if (strCompanyId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)strCompanyId));
        }
        if (strPeriodId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)strPeriodId));
        }
        if (isInit) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)STRING_ONE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("isInit", (Object)STRING_ZERO));
        }
        if (type != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(type.getValue())));
        }
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountView.id"));
        sic.add(new SelectorItemInfo("accountView.number"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("accountBank.id"));
        sic.add(new SelectorItemInfo("accountBank.number"));
        sic.add(new SelectorItemInfo("accountBank.name"));
        sic.add(new SelectorItemInfo("accountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("accountBank.account.id"));
        sic.add(new SelectorItemInfo("accountBank.account.isBank"));
        sic.add(new SelectorItemInfo("accountBank.account.name"));
        sic.add(new SelectorItemInfo("accountBank.account.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("period.name"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("accountBank.bank.id"));
        sic.add(new SelectorItemInfo("accountBank.bank.name"));
        sic.add(new SelectorItemInfo("accountBank.bank.number"));
        sic.add(new SelectorItemInfo("monthStartAmt"));
        sic.add(new SelectorItemInfo("monthDebitAmt"));
        sic.add(new SelectorItemInfo("monthCreditAmt"));
        sic.add(new SelectorItemInfo("monthBalance"));
        sic.add(new SelectorItemInfo("yearStartAmt"));
        sic.add(new SelectorItemInfo("yearDebitAmt"));
        sic.add(new SelectorItemInfo("yearCreditAmt"));
        sic.add(new SelectorItemInfo("yearBalance"));
        sic.add(new SelectorItemInfo("debitStartAmt"));
        sic.add(new SelectorItemInfo("creditStartAmt"));
        sic.add(new SelectorItemInfo("isInit"));
        sic.add(new SelectorItemInfo("isBalanced"));
        sic.add(new SelectorItemInfo("type"));
        JournalBalanceCollection JournalBalanceCollection2 = iJournalBalance.getJournalBalanceCollection(viewInfo);
        return JournalBalanceCollection2;
    }

    private boolean isInitPeriod(Context ctx, String strCompanyId, String strPeriodId) throws EASBizException, BOSException {
        PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (IObjectPK)new ObjectUuidPK(strCompanyId));
        return startPeriodInfo.getId().toString().equals(strPeriodId);
    }

    private AccountBalanceCollection getGLBalanceCollection(Context ctx, String companyId, String acctTableId, String periodId, boolean isCash) throws BOSException {
        IAccountBalance iGL = AccountBalanceFactory.getLocalInstance((Context)ctx);
        EntityViewInfo glView = new EntityViewInfo();
        FilterInfo glFilter = new FilterInfo();
        glView.setFilter(glFilter);
        glFilter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)companyId));
        glFilter.getFilterItems().add(new FilterItemInfo("period", (Object)periodId));
        if (isCash) {
            glFilter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)STRING_ZERO));
            glFilter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)STRING_ONE));
        } else {
            glFilter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)STRING_ONE));
            glFilter.getFilterItems().add(new FilterItemInfo("account.isCash", (Object)STRING_ZERO));
            Set idSet = this.getAccountForBankAccount(ctx, companyId);
            if (idSet.size() <= 0) {
                return null;
            }
            glFilter.getFilterItems().add(new FilterItemInfo("account.id", (Object)idSet, CompareType.INCLUDE));
        }
        glFilter.getFilterItems().add(new FilterItemInfo("account.isLeaf", (Object)STRING_ONE));
        glFilter.getFilterItems().add(new FilterItemInfo("account.accountTableID.id", (Object)acctTableId));
        glView.getSelector().add(new SelectorItemInfo("id"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceFor"));
        glView.getSelector().add(new SelectorItemInfo("beginBalanceLocal"));
        glView.getSelector().add(new SelectorItemInfo("account.id"));
        glView.getSelector().add(new SelectorItemInfo("account.*"));
        glView.getSelector().add(new SelectorItemInfo("account.isBank"));
        glView.getSelector().add(new SelectorItemInfo("currency.id"));
        glView.getSelector().add(new SelectorItemInfo("currency.number"));
        glView.getSelector().add(new SelectorItemInfo("currency.name"));
        glView.getSelector().add(new SelectorItemInfo("currency.precision"));
        glView.getSelector().add(new SelectorItemInfo("endBalanceFor"));
        glView.getSelector().add(new SelectorItemInfo("endBalanceLocal"));
        AccountBalanceCollection acctBalColl = iGL.getAccountBalanceCollection(glView);
        return acctBalColl;
    }

    private Set getAccountForBankAccount(Context ctx, String companyid) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.TRUE));
        AccountBankCollection colls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
        HashSet<String> idSet = new HashSet<String>();
        for (int index = 0; index < colls.size(); ++index) {
            idSet.add(colls.get(index).getAccount().getId().toString());
        }
        return idSet;
    }

    private CompanyOrgUnitInfo getCompanyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strId));
        return company;
    }

    private String getIndexKey(String accountBankId, String acctViewId, String currencyId) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append(accountBankId);
        strBuff.append("_");
        strBuff.append(acctViewId);
        strBuff.append("_");
        strBuff.append(currencyId);
        return strBuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void filterCurrencyId(Context ctx, HashSet currencySet, String companyId, String periodId) {
        ResultSet rs;
        PreparedStatement stmt;
        Connection con;
        block7: {
            String strSql = "SELECT distinct FCurrencyID FROM T_GL_AccountBalance WHERE FOrgUnitID=? AND FPeriodID=? ";
            con = null;
            stmt = null;
            rs = null;
            String currencyId = null;
            try {
                con = this.getConnection(ctx);
                stmt = con.prepareStatement(strSql.toString());
                stmt.setString(1, companyId);
                stmt.setString(2, periodId);
                rs = stmt.executeQuery();
                if (rs == null) break block7;
                while (rs.next()) {
                    currencyId = rs.getString("FCurrencyID");
                    if (currencyId.equals(CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID.toString()) || currencyId.equals(CurrencyInfo.GENERAL_REPORT_CURRENCY_ID.toString())) continue;
                    currencySet.add(currencyId);
                }
            }
            catch (SQLDataException e) {
                logger.error((Object)e);
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
            catch (SQLException e2) {
                logger.error((Object)e2);
                {
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)con);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup(rs, (Statement)stmt, (Connection)con);
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)con);
    }

    private CasGLItemCheckRptInfo cashContrastGLForCAS(Context ctx, String companyId, AccountBankInfo acctBankInfo, String accountId, String currencyId, String periodId, JournalBalanceInfo journalBalInfo, boolean isGLStart) throws EASBizException, BOSException {
        CasGLItemCheckRptInfo rpt = null;
        BigDecimal casMonthBalance = ZERO;
        BigDecimal glMonthBalance = ZERO;
        casMonthBalance = this.getBigDecimal(journalBalInfo.getMonthBalance());
        if (isGLStart) {
            glMonthBalance = this.getGLData(ctx, companyId, acctBankInfo, accountId, currencyId, periodId);
            AccountViewInfo accountViewInfo = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountId));
            if (accountViewInfo.getDC().equals((Object)BalanceDirectionEnum.CREDIT)) {
                glMonthBalance = glMonthBalance.multiply(new BigDecimal(-1));
            }
        }
        casMonthBalance = casMonthBalance.setScale(journalBalInfo.getCurrency().getPrecision(), 4);
        if ((glMonthBalance = glMonthBalance.setScale(journalBalInfo.getCurrency().getPrecision(), 4)).compareTo(casMonthBalance) != 0) {
            rpt = this.getContrastRptInfo(ctx, journalBalInfo, casMonthBalance, glMonthBalance);
        }
        return rpt;
    }

    public Map getAcctBankSumSearchMap(JournalBalanceCollection journalBalances, String[] keys) {
        HashMap<String, JournalBalanceInfo> map = new HashMap<String, JournalBalanceInfo>();
        for (int i = 0; i < journalBalances.size(); ++i) {
            JournalBalanceInfo journalBalance = journalBalances.get(i);
            String keyString = FMHelper.getKeyStringWithPeriod((IObjectValue)journalBalance, (String[])keys);
            if (map.get(keyString) == null) {
                JournalBalanceInfo journalBalanceBak = (JournalBalanceInfo)journalBalance.clone();
                journalBalanceBak.setType(AccountTypeEnum.CASHACCOUNT);
                map.put(keyString, journalBalanceBak);
                continue;
            }
            JournalBalanceInfo journalBalanceOld = (JournalBalanceInfo)map.get(keyString);
            journalBalanceOld.setMonthStartAmt(journalBalance.getMonthBalance().add(journalBalanceOld.getMonthBalance()));
            journalBalanceOld.setMonthDebitAmt(journalBalance.getMonthDebitAmt().add(journalBalanceOld.getMonthDebitAmt()));
            journalBalanceOld.setMonthCreditAmt(journalBalance.getMonthCreditAmt().add(journalBalanceOld.getMonthCreditAmt()));
            journalBalanceOld.setMonthBalance(journalBalance.getMonthBalance().add(journalBalanceOld.getMonthBalance()));
        }
        return map;
    }

    private BigDecimal getGLData(Context ctx, String companyId, AccountBankInfo acctBank, String accountId, String currencyId, String periodId) throws BOSException, EASBizException {
        return this.getGLData(ctx, companyId, acctBank, accountId, currencyId, periodId, BalanceTypeEnum.Y);
    }

    private BigDecimal getGLData(Context ctx, String companyId, AccountBankInfo acctBank, String accountId, String currencyId, String periodId, BalanceTypeEnum balanceType) throws BOSException, EASBizException {
        if (accountId == null) {
            return ZERO;
        }
        boolean includeVoucher = false;
        boolean checkDataRight = false;
        PeriodInfo period = this.getPeriodById(ctx, periodId);
        int startYear = period.getPeriodYear();
        int startNum = period.getPeriodNumber();
        int endYear = startYear;
        int endNum = startNum;
        BigDecimal balance = ZERO;
        AccountViewInfo acctViewInfo = this.getAcctViewInfoById(ctx, accountId);
        if (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null) {
            AsstAccountInfo asstAcctInfo = new AsstAccountInfo();
            if (acctViewInfo.getGAA() != null) {
                asstAcctInfo = acctViewInfo.getGAA();
            }
            if (acctViewInfo.getCAA() != null) {
                asstAcctInfo = acctViewInfo.getCAA();
            }
            if (this.isHasAssistant(ctx, acctBank.getId().toString(), asstAcctInfo.getId().toString())) {
                IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
                IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
                AsstActTypeInfo asstAct = asstActType.getAsstActType(AsstActTypeSysEnum.BANKACCOUNT);
                if (asstAct != null) {
                    balance = reportCacl.acct(this.getCompanyById(ctx, companyId).getNumber(), this.getAccountViewById(ctx, accountId).getNumber() + "|" + asstAct.getNumber() + "|" + acctBank.getNumber(), balanceType, startYear, startNum, endYear, endNum, this.getCurrencyById(ctx, currencyId).getNumber(), false, includeVoucher, checkDataRight);
                    return balance == null ? ZERO : balance;
                }
            }
        }
        if (!FMHelper.isExistMultiBankAcct((Context)ctx, (String)companyId, (String)accountId)) {
            IReportCacl reportCacl = ReportCaclFactory.getLocalInstance((Context)ctx);
            balance = reportCacl.acct(this.getCompanyById(ctx, companyId).getNumber(), this.getAccountViewById(ctx, accountId).getNumber(), balanceType, startYear, startNum, endYear, endNum, this.getCurrencyById(ctx, currencyId).getNumber(), false, includeVoucher, checkDataRight);
        }
        return balance == null ? ZERO : balance;
    }

    private AccountViewInfo getAccountViewById(Context ctx, String strId) throws EASBizException, BOSException {
        IAccountView iAcct = AccountViewFactory.getLocalInstance((Context)ctx);
        AccountViewInfo acctView = iAcct.getAccountViewInfo((IObjectPK)new ObjectUuidPK(strId));
        return acctView;
    }

    private CurrencyInfo getCurrencyById(Context ctx, String strId) throws EASBizException, BOSException {
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currency = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(strId));
        return currency;
    }

    private AccountBankCollection getAccountBankCollection(Context ctx, String strCompanyId, String strCurrencyId) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("*");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("bank.number");
        selector.add("account.id");
        selector.add("account.*");
        FilterInfo fi = new FilterInfo();
        FilterItemCollection items = fi.getFilterItems();
        items.add(new FilterItemInfo("company.id", (Object)strCompanyId));
        items.add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        items.add(new FilterItemInfo("isBank", (Object)Constants.TRUE));
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("number"));
        AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        ICompanyOrgUnit company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = company.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(strCompanyId));
        CurrencyInfo localCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(comInfo);
        AccountBankCollection coll = new AccountBankCollection();
        if (acctBankCol == null) {
            return null;
        }
        if (strCurrencyId == null) {
            return acctBankCol;
        }
        AccountBankInfo info = null;
        boolean isLocalCurrency = false;
        if (localCurrency.getId().toString().equals(strCurrencyId)) {
            isLocalCurrency = true;
        }
        int size = acctBankCol.size();
        block5: for (int i = 0; i < size; ++i) {
            info = acctBankCol.get(i);
            switch (info.getAccount().getAccountingcurrency().getValue()) {
                case 2: {
                    coll.add(info);
                    continue block5;
                }
                case 0: {
                    if (!isLocalCurrency) continue block5;
                    coll.add(info);
                    continue block5;
                }
                case 1: {
                    AccountCurrencyCollection acctCurColl = this.getAccountCurrencyCollection(ctx, info.getAccount().getId().toString());
                    for (int j = 0; j < acctCurColl.size(); ++j) {
                        if (!acctCurColl.get(j).getCurrency().getId().toString().equals(strCurrencyId)) continue;
                        coll.add(info);
                        continue block5;
                    }
                    continue block5;
                }
            }
        }
        return coll;
    }

    private AssistantHGInfo getHasAssistant(Context ctx, String bankAccountId, String asstAccountId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (bankAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        }
        if (asstAccountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAccountId));
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bankAccount.id"));
        selector.add(new SelectorItemInfo("asstAccount.id"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        if (assistantHGColl == null || assistantHGColl.size() == 0) {
            return null;
        }
        return assistantHGColl.get(0);
    }

    private BigDecimal getAssistantBeginAmt(Context ctx, JournalBalanceInfo journalBalInfo, String companyId, String currencyId, String periodId, String accountId, String assistGrpId, boolean bln) throws EASBizException, BOSException {
        PeriodInfo glStartPeriodInfo = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.getCompanyById(ctx, companyId));
        boolean isGLInit = periodId.equals(glStartPeriodInfo.getId().toString());
        BigDecimal monthBalance = this.getBigDecimal(journalBalInfo.getMonthBalance());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (companyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyId));
        }
        if (!isGLInit && periodId != null) {
            fi.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodId));
        }
        if (accountId != null) {
            fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        }
        if (currencyId != null) {
            fi.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        if (!isGLInit) {
            if (assistGrpId != null) {
                fi.getFilterItems().add(new FilterItemInfo("assistGrp.id", (Object)assistGrpId));
            }
            if (bln) {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(5)));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("balType", (Object)new Integer(1)));
            }
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("yearDebitFor"));
        selector.add(new SelectorItemInfo("yearCreditFor"));
        selector.add(new SelectorItemInfo("beginBalanceFor"));
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        if (isGLInit) {
            IInitAssistBalance iInitAsstBal = InitAssistBalanceFactory.getLocalInstance((Context)ctx);
            InitAssistBalanceCollection initAssistBalColl = iInitAsstBal.getInitAssistBalanceCollection(evi);
            if (initAssistBalColl != null && initAssistBalColl.size() > 0) {
                InitAssistBalanceInfo initAssistBalInfo = initAssistBalColl.get(0);
                monthBalance = this.getBigDecimal(initAssistBalInfo.getEndBalanceFor());
            }
        } else {
            IAssistBalance iAssistBal = AssistBalanceFactory.getLocalInstance((Context)ctx);
            AssistBalanceCollection assistBalColl = iAssistBal.getAssistBalanceCollection(evi);
            if (assistBalColl != null && assistBalColl.size() > 0) {
                AssistBalanceInfo assistBalInfo = assistBalColl.get(0);
                monthBalance = this.getBigDecimal(assistBalInfo.getEndBalanceFor());
            }
        }
        return monthBalance;
    }

    private PeriodInfo getPeriodById(Context ctx, String strId) throws EASBizException, BOSException {
        IPeriod iPeriod = PeriodFactory.getLocalInstance((Context)ctx);
        PeriodInfo period = iPeriod.getPeriodInfo((IObjectPK)new ObjectUuidPK(strId));
        return period;
    }

    private AccountCurrencyCollection getAccountCurrencyCollection(Context ctx, String accountId) throws EASBizException, BOSException, UuidException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountId)), sic);
        return account.getAccountCurrency();
    }

    @Override
    protected List _getInitData(Context ctx, Map map) throws BOSException, EASBizException {
        long startTime = System.currentTimeMillis();
        ArrayList<Cloneable> result = new ArrayList<Cloneable>();
        HashSet<String> companyIdSet = new HashSet<String>();
        BOSUuid userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("unit.isOUSealUp", (Object)STRING_ZERO));
        viewInfo.setFilter(filterInfo);
        FullOrgUnitCollection mainOrgs = iPermission.getAuthorizedOrg((IObjectPK)new ObjectUuidPK(userId), OrgType.Company, null, "cas_finalcheckout_01checkout", viewInfo);
        long endTime = System.currentTimeMillis();
        logger.error((Object)("\u53d6\u6709\u6743\u9650\u7ec4\u7ec7\u8017\u65f6\uff1a" + (endTime - startTime)));
        startTime = System.currentTimeMillis();
        for (int i = 0; i < mainOrgs.size(); ++i) {
            companyIdSet.add(mainOrgs.get(i).getId().toString());
        }
        endTime = System.currentTimeMillis();
        logger.error((Object)("\u6709\u6743\u9650\u7ec4\u7ec7\u5faa\u73af\u5149\u6807\u8017\u65f6\uff1a" + (endTime - startTime)));
        startTime = System.currentTimeMillis();
        String companyArray = StringUtil.buildIn((String)"a.fid", (Object[])companyIdSet.toArray());
        if (companyArray == null || companyArray.trim().equals("")) {
            companyArray = " a.fid='GodBlessYou' ";
        }
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        TreeSet<Integer> periodSet = new TreeSet<Integer>();
        boolean isInit = false;
        String fid = null;
        if (!EmptyUtil.isEmpty((Object)map)) {
            if (map.get("isInit") != null) {
                isInit = true;
            }
            if ((fid = map.get("filters").toString()).indexOf("a.Fid") == -1) {
                fid = fid.replace("id", "a.fid");
            }
            fid = fid.replace("period.number", "d.fnumber");
        }
        String sql = "select a.fid comId, b.fisStart, b.fcurrentperiodid periodId, a.fnumber,a.fname_" + loc + " fname, a.fcontrolunitid cuid, d.fnumber curPeriod,\t\t\t\t\t\t               \t\r\n\t\td.fperiodyear curYear, d.fperiodnumber curNumber, d.FBeginDate beginDate, d.FEndDate endDate, a.FaccounttableId accounttableid, d.FbeginDate, d.FendDate, d.fid periodId \t \r\n\t\tfrom t_org_company a \t\t\t\t\t\t\t\t\t\t\t\t\t\t\r\n\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fcompanyid \t\t\t\t\t\r\n\t\tinner join t_bd_systemstatus c on c.fid=b.fsystemstatusid\t\t\t\t\t\r\n\t\tinner join t_bd_period d on d.fid=b.fcurrentperiodid \t\t\t\t\t\t\r\n\t\twhere c.fname = " + 7 + " and a.fisbizunit=1  \r\n";
        sql = !EmptyUtil.isEmpty((Object)map) && !EmptyUtil.isEmpty(map.get("filters")) ? sql + "\tand (" + fid + ")                           \r\n" : sql + "\tand " + companyArray + "\t\t\t                                \r\n";
        sql = sql + "\t\torder by a.fnumber\t\t\t\t\t\t\t\t\t                \r\n";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        endTime = System.currentTimeMillis();
        logger.error((Object)("\u83b7\u53d6\u6743\u9650\u8303\u56f4\u7ec4\u7ec7\u5f53\u524d\u671f\u95f4\u8017\u65f6\uff1a" + (endTime - startTime)));
        startTime = System.currentTimeMillis();
        try {
            HashMap<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
            companyIdSet.clear();
            while (rs.next()) {
                String comId = rs.getString("comId");
                companyIdSet.add(comId);
                periodSet.add(rs.getInt("curPeriod"));
                String periodId = rs.getString("periodId");
                PeriodInfo curPeriodInfo = new PeriodInfo();
                curPeriodInfo.setId(BOSUuid.read((String)periodId));
                java.sql.Date beginDate = rs.getDate("beginDate");
                java.sql.Date endDate = rs.getDate("endDate");
                curPeriodInfo.setPeriodYear(rs.getInt("curYear"));
                curPeriodInfo.setPeriodNumber(rs.getInt("curNumber"));
                curPeriodInfo.setBeginDate((Date)beginDate);
                curPeriodInfo.setEndDate(new Timestamp(endDate.getTime()));
                periodMap.put(comId, curPeriodInfo);
            }
            if (!EmptyUtil.isEmpty((Object)map)) {
                ArrayList<Integer> periodList = new ArrayList<Integer>();
                periodList.addAll(periodSet);
                result.add(periodList);
            }
            Map hmAllParam = new HashMap();
            Map checkAllMap = new HashMap();
            if (companyIdSet != null && companyIdSet.size() > 0) {
                hmAllParam = this._getDefaultCasParam(ctx, companyIdSet);
                endTime = System.currentTimeMillis();
                logger.error((Object)("\u83b7\u53d6" + companyIdSet.size() + "\u5bb6\u7ec4\u7ec7\u53c2\u6570\u8017\u65f6\uff1a" + (endTime - startTime)));
                startTime = System.currentTimeMillis();
                checkAllMap = this.checkAccountBefore(ctx, companyIdSet, periodMap, hmAllParam);
                endTime = System.currentTimeMillis();
                logger.error((Object)("\u83b7\u53d6" + companyIdSet.size() + "\u5bb6\u7ec4\u7ec7\u4e1a\u52a1\u6821\u9a8c\u8017\u65f6\uff1a" + (endTime - startTime)));
                startTime = System.currentTimeMillis();
            }
            if (!isInit) {
                rs.beforeFirst();
                while (rs.next()) {
                    String comId = rs.getString("comId");
                    boolean isStart = rs.getBoolean("fisStart");
                    String accounttableid = rs.getString("accounttableid");
                    HashMap<String, Object> checkOutResultMap = new HashMap<String, Object>();
                    FullOrgUnitInfo curCompany = (FullOrgUnitInfo)mainOrgs.getObject((Object)BOSUuid.read((String)comId));
                    checkOutResultMap.put("company", curCompany);
                    PeriodInfo curPeriodInfo = (PeriodInfo)periodMap.get(comId);
                    checkOutResultMap.put("curPeriod", curPeriodInfo);
                    checkOutResultMap.put("isStart", isStart);
                    checkOutResultMap.put("accounttableid", accounttableid);
                    Map allParam = (Map)hmAllParam.get(comId);
                    checkOutResultMap.putAll(allParam);
                    if (isStart) {
                        HashMap checkMap = (HashMap)checkAllMap.get(comId);
                        if (checkMap == null) {
                            checkMap = new HashMap();
                        }
                        checkOutResultMap.put("checkMsg", checkMap);
                    } else {
                        checkOutResultMap.put("checkMsg", new HashMap());
                    }
                    result.add(checkOutResultMap);
                }
            }
            endTime = System.currentTimeMillis();
            logger.error((Object)("\u62fc\u63a5\u8fd4\u56de\u7ed3\u679c\u8017\u65f6\uff1a" + (endTime - startTime)));
            startTime = System.currentTimeMillis();
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private Map _getDefaultCasParam(Context ctx, Set companyIdSet) throws BOSException, EASBizException {
        ArrayList orgIdStrList = new ArrayList();
        Iterator it = companyIdSet.iterator();
        while (it.hasNext()) {
            orgIdStrList.add(it.next());
        }
        ArrayList<String> paramNumberList = new ArrayList<String>();
        paramNumberList.add("CS001");
        paramNumberList.add("CS002");
        paramNumberList.add("CS055");
        paramNumberList.add("CS056");
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        ArrayList hmAllParam = pc.getParamListPatch(paramNumberList, orgIdStrList);
        HashMap hmAllCompanyParam = new HashMap();
        for (ParamSimpleInfo info : hmAllParam) {
            Map<String, String> paramMap;
            String orgId = info.getOrgUnitPK().toString();
            String param = info.getParamNumber();
            String paramValue = info.getParamValue();
            if (hmAllCompanyParam.containsKey(orgId)) {
                paramMap = (Map)hmAllCompanyParam.get(orgId);
                paramMap.put(param, paramValue);
                continue;
            }
            paramMap = new HashMap();
            paramMap.put(param, paramValue);
            hmAllCompanyParam.put(orgId, paramMap);
        }
        return hmAllCompanyParam;
    }

    private Boolean transStringToBoolean(Object value) {
        String stringValue = value.toString();
        if (FMHelper.isEmpty((String)stringValue)) {
            return Boolean.FALSE;
        }
        if (stringValue.compareTo("true") == 0 || stringValue.compareTo("false") == 0) {
            return Boolean.valueOf(stringValue);
        }
        return Boolean.FALSE;
    }

    @Override
    protected Map _finalCheckOutBatch(Context ctx, List companyList) throws BOSException, EASBizException {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String companyID : companyList) {
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyID));
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
            try {
                Vector vec;
                List list = this.checkBalanceAdjustAudit(ctx, companyID);
                if (!EmptyUtil.isEmpty((Collection)list)) {
                    StringBuffer message = new StringBuffer();
                    message.append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"155_FinalCheckoutControllerBean", (Locale)ctx.getLocale()));
                    for (AccountBankInfo acctBank : list) {
                        message.append(acctBank.getName() + ", ");
                    }
                    message.append(" \n \n");
                    resultMap.put(companyID, message.toString());
                    continue;
                }
                PeriodInfo period = this.finalCheckAccount(ctx, companyID);
                IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
                boolean CS019 = this.transStringToBoolean(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyID), "CS019"));
                boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                if (CS019 && isRelAccount && (vec = this.getContrastWithGL(ctx, companyID, periodInfo.getId().toString())) != null && vec.size() > 0) {
                    this.deleteCheckAccount(ctx, companyID);
                    resultMap.put(companyID, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"496_FailTip", (Locale)ctx.getLocale()));
                    continue;
                }
                resultMap.put(companyID, (String)period);
            }
            catch (EASBizException biz) {
                logger.error((Object)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"118_FinalCheckoutControllerBean", (Locale)ctx.getLocale()), (Throwable)biz);
                resultMap.put(companyID, biz.getMessage());
            }
        }
        return resultMap;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected List _checkBalanceAdjustAudit(Context ctx, String companyId) throws BOSException, EASBizException {
        if (companyId == null || companyId == "") {
            CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
            companyId = company.getId().toString();
        }
        ArrayList<AccountBankInfo> list = new ArrayList<AccountBankInfo>();
        IParamControl pc = ParamControlFactory.getLocalInstance((Context)ctx);
        boolean CS133 = this.transStringToBoolean(pc.getParamValue((IObjectPK)new ObjectUuidPK(companyId), "CS133"));
        if (!CS133) return list;
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)companyId));
        PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isClosed", (Object)FMConstants.FALSE));
        filterInfo.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("name");
        selector.add("number");
        selector.add("shareAcct.*");
        selector.add("shareType");
        viewInfo.setFilter(filterInfo);
        viewInfo.setSelector(selector);
        AccountBankCollection acctColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(viewInfo);
        if (EmptyUtil.isEmpty((AbstractObjectCollection)acctColl)) return list;
        block0: for (int i = 0; i < acctColl.size(); ++i) {
            SharedAcctInfo sharedAcctInfo;
            AccountBankInfo accountBank = acctColl.get(i);
            if (accountBank.getShareType() != null && 0 != accountBank.getShareType().getValue() && !(sharedAcctInfo = accountBank.getShareAcct()).getShareBalanceOfAcctCompany().getId().toString().equals(companyId)) continue;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)accountBank.getId().toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)periodInfo.getId().toString(), CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("auditTime");
            view.setFilter(filter);
            view.setSelector(sic);
            BankBalanceAdjustCollection balanceColl = BankBalanceAdjustFactory.getLocalInstance(ctx).getBankBalanceAdjustCollection(view);
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)balanceColl)) {
                for (int j = 0; j < balanceColl.size(); ++j) {
                    Timestamp auditTime = balanceColl.get(j).getAuditTime();
                    if (auditTime != null) continue;
                    list.add(accountBank);
                    continue block0;
                }
                continue;
            }
            list.add(accountBank);
        }
        return list;
    }

    class TaskExecutionRecordThead
    extends Thread {
        Context ctx;
        String companyId;
        PeriodInfo periodInfo;
        boolean isReverse;

        public TaskExecutionRecordThead(Context ctx, String companyId, PeriodInfo periodInfo, boolean isReverse) {
            this.ctx = ctx;
            this.companyId = companyId;
            this.periodInfo = periodInfo;
            this.isReverse = isReverse;
        }

        @Override
        public void run() {
            try {
                FIClosingCenterFacadeFactory.getLocalInstance((Context)this.ctx).taskExecutionRecord(this.companyId, "hmNKvQbNSVy3knQ6wk+w5M4XzhY=", this.periodInfo.getId().toString(), this.isReverse);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }
}

