/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentBillWebFacade;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillWebFacadeFactory;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundDispatchBillSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.FundDispatchBillSmartFilter");

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        String queryOql = "";
        try {
            FilterInfo filterInfo = new FilterInfo(filterSql);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String compareOp;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String filterValue = "";
                    Object cmpVal = filterItemInfo.getCompareValue();
                    if (cmpVal != null) {
                        filterValue = cmpVal.toString();
                    }
                    if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endValue = "";
                    try {
                        Date date = df.parse(filterValue);
                        date.setTime(date.getTime() + 1000L);
                        endValue = df.format(date);
                        if (EmptyUtil.isEmpty((String)endValue)) continue;
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("FundDispatchBillSmartFilter===" + iexec.getSQL() + " and fissmart in (1,3)  and FFundDispatchType != 0"));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL() + " and fissmart in (1,3)  and FFundDispatchType != 0");
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"156_FundDispatchBillSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"157_FundDispatchBillSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(filterSql);
            }
        } else {
            result.append(filterSql);
        }
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.plan_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_submit_audit_approve.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_submit_audit_approve_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_submit_audit_approve_commitBank_link.getName().equals(operatorNumber)) {
            result.append(" and billStatus in (10,11) ");
        }
        if (InterfaceTypeEnum.plan_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_audit_approve.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_audit_approve_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_audit_approve_commitBank_link.getName().equals(operatorNumber)) {
            result.append(" and billStatus  in (11,8) ");
        }
        if (InterfaceTypeEnum.plan_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_commitBank_link.getName().equals(operatorNumber) || InterfaceTypeEnum.plan_commitBank.getName().equals(operatorNumber)) {
            result.append(" and billStatus = 12 ");
        }
        return result.toString();
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("settlementType.ntType.*"));
        sic.add(new SelectorItemInfo("actRecAccountBank.*"));
        sic.add(new SelectorItemInfo("payerInAcctID.*"));
        sic.add(new SelectorItemInfo("cheque.*"));
        sic.add(new SelectorItemInfo("cheque.applyRec.applyCompany.id"));
        sic.add(new SelectorItemInfo("payerBank.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.*"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.account.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.clearingHouse.*"));
        sic.add(new SelectorItemInfo("agentPayCompany.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        sic.add(new SelectorItemInfo("payeeType.*"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("payBillType.*"));
        sic.add(new SelectorItemInfo("feeType.*"));
        sic.add(new SelectorItemInfo("payerAccount.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        sic.add(new SelectorItemInfo("person.*"));
        sic.add(new SelectorItemInfo("project.*"));
        sic.add(new SelectorItemInfo("costCenter.*"));
        sic.add(new SelectorItemInfo("profitCenter.*"));
        sic.add(new SelectorItemInfo("projectManager.*"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("FRecCountry.id"));
        sic.add(new SelectorItemInfo("FRecCountry.number"));
        sic.add(new SelectorItemInfo("FRecCountry.name"));
        sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("oppAccount.accountTableID.id"));
        sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("oppAccount.CAA.id"));
        sic.add(new SelectorItemInfo("oppAccount.CAA.isQty"));
        sic.add(new SelectorItemInfo("oppAccount.AC"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("remitAccountBank.id"));
        sic.add(new SelectorItemInfo("remitAccountBank.number"));
        sic.add(new SelectorItemInfo("remitAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("remitAccountBank.name"));
        sic.add(new SelectorItemInfo("assItems.*"));
        sic.add(new SelectorItemInfo("entries.assItemsEntries.*"));
        sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.accountTableID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.CAA.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.CAA.isQty"));
        sic.add(new SelectorItemInfo("entries.oppAccount.AC"));
        sic.add(new SelectorItemInfo("entries.oppAccount.name"));
        sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        sic.add(new SelectorItemInfo("entries.oppAccount.longName"));
        sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        sic.add(new SelectorItemInfo("entries.costCenter.name"));
        sic.add(new SelectorItemInfo("entries.costCenter.number"));
        sic.add(new SelectorItemInfo("entries.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.expenseType.number"));
        sic.add(new SelectorItemInfo("entries.rebate"));
        sic.add(new SelectorItemInfo("entries.rebateLocAmt"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.number"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.name"));
        return sic;
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        String companyID = "" + paramMap.get("companyID");
        String auditor = "";
        String payer = "";
        String approve = "";
        if (schemaInfo != null && schemaInfo.getAuditor() != null) {
            auditor = schemaInfo.getAuditor().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getPayer() != null) {
            payer = schemaInfo.getPayer().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getApprove() != null) {
            approve = schemaInfo.getApprove().getId().toString();
        }
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            Map pageModel;
            HashSet set;
            HashSet set2;
            String operatorNumber = busiInfo.getOperatorNumber();
            IPaymentBill biz = PaymentBillFactory.getLocalInstance(ctx);
            IPaymentBillWebFacade bizWeb = PaymentBillWebFacadeFactory.getLocalInstance(ctx);
            boolean mustAuditParam = false;
            if (!EmptyUtil.isEmpty((String)companyID)) {
                mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(companyID));
            }
            if (InterfaceTypeEnum.plan_submit.getName().equals(operatorNumber)) {
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        Map pageModel2 = bizWeb.submit(biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())), this.getSelector()));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.plan_audit.getName().equals(operatorNumber)) {
                HashSet auditSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        if (mustAuditParam) {
                            biz.approve(set2);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
            }
            if (InterfaceTypeEnum.plan_audit_approve.getName().equals(operatorNumber)) {
                HashSet approveSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        biz.audit(set2);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
            }
            if (InterfaceTypeEnum.plan_pay.getName().equals(operatorNumber)) {
                HashSet payerSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        biz.pay(set2);
                        if (!EmptyUtil.isEmpty((String)payer)) {
                            String sql = " UPDATE T_CAS_PaymentBill SET FCASHIERID = ?  WHERE FID = ?  ";
                            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{payer, billList.get(i)});
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(payerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
            if (InterfaceTypeEnum.plan_commitBank_link.getName().equals(operatorNumber)) {
                HashSet set3 = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    set3.add(billList.get(i));
                }
                try {
                    biz.commitToBENewBatch(set3);
                    success = set3.size();
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])set3.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
                catch (Exception e) {
                    failure = set3.size();
                    errorMsg = errorMsg + e.getMessage();
                }
            }
            if (InterfaceTypeEnum.plan_commitBank.getName().equals(operatorNumber)) {
                HashSet set4 = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    set4.add(billList.get(i));
                }
                try {
                    biz.commitToBENewBatch(set4);
                    success = set4.size();
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])set4.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
                catch (Exception e) {
                    failure = set4.size();
                    errorMsg = errorMsg + e.getMessage();
                }
            }
            if (InterfaceTypeEnum.plan_submit_audit_approve.getName().equals(operatorNumber)) {
                HashSet approveSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        Map pageModel3 = bizWeb.submit(biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())), this.getSelector()));
                        if ("1".equals(pageModel3.get("error") + "")) continue;
                        biz.audit(set2);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
            }
            if (InterfaceTypeEnum.plan_submit_audit_approve_pay.getName().equals(operatorNumber)) {
                HashSet approveSet = new HashSet();
                HashSet payerSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        PaymentBillInfo info;
                        set = new HashSet();
                        set.add(billList.get(i));
                        pageModel = bizWeb.submit(biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())), this.getSelector()));
                        if ("1".equals(pageModel.get("error") + "")) continue;
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if ((info = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info.getSettlementStatus().getValue() == 11) continue;
                        biz.pay(set);
                        if (!EmptyUtil.isEmpty((String)payer)) {
                            payerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE ");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(payerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE ");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
            if (InterfaceTypeEnum.plan_submit_audit_approve_commitBank_link.getName().equals(operatorNumber)) {
                HashSet bankSet = new HashSet();
                HashSet approveSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet();
                        set.add(billList.get(i));
                        pageModel = bizWeb.submit(biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())), this.getSelector()));
                        if ("1".equals(pageModel.get("error") + "")) continue;
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        bankSet.add(billList.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    try {
                        biz.commitToBENewBatch(bankSet);
                        success = bankSet.size();
                        StringBuffer sb = new StringBuffer();
                        sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.plan_audit_approve_pay.getName().equals(operatorNumber)) {
                HashSet approveSet = new HashSet();
                HashSet payerSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet();
                        set.add(billList.get(i));
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        biz.pay(set);
                        if (!EmptyUtil.isEmpty((String)payer)) {
                            payerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(payerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
            if (InterfaceTypeEnum.plan_audit_approve_commitBank_link.getName().equals(operatorNumber)) {
                HashSet bankSet = new HashSet();
                HashSet approveSet = new HashSet();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet();
                        set.add(billList.get(i));
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        bankSet.add(billList.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    try {
                        biz.commitToBENewBatch(bankSet);
                        success = bankSet.size();
                        StringBuffer sb = new StringBuffer();
                        sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }
}

