/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FlowItemStateEnum;
import com.kingdee.eas.fi.cas.FundFlowItemCollection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.JournalFlowItemFactory;
import com.kingdee.eas.fi.cas.app.AbstractFundFlowItemControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundFlowItemControllerBean
extends AbstractFundFlowItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.FundFlowItemControllerBean");

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo f1 = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)false);
        if (this._exists(ctx, f1)) {
            throw new EASBizException(new NumericExceptionSubItem("", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.FundFlowResource", (String)"numberDump", (Locale)ctx.getLocale())));
        }
        FundFlowItemInfo info = (FundFlowItemInfo)model;
        IObjectPK pk = super._submit(ctx, model);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected void _enable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundFlowItemInfo info = this.getFundFlowItemInfo(ctx, pk);
        info.setState(FlowItemStateEnum.ENABLE);
        this._update(ctx, pk, (IObjectValue)info);
        if (!info.isIsLeaf()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid as c from T_CAS_FundFlowItem where FparentId=?", (Object[])new Object[]{info.getId().toString()});
            try {
                while (rs.next()) {
                    String fid = rs.getString("c");
                    if (fid == null) continue;
                    ObjectUuidPK pk1 = new ObjectUuidPK(fid);
                    this._enable(ctx, (IObjectPK)pk1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _disable(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundFlowItemInfo info = this.getFundFlowItemInfo(ctx, pk);
        info.setState(FlowItemStateEnum.DISABLE);
        this._update(ctx, pk, (IObjectValue)info);
        if (!info.isIsLeaf()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid as c from T_CAS_FundFlowItem where FparentId=?", (Object[])new Object[]{info.getId().toString()});
            try {
                while (rs.next()) {
                    String fid = rs.getString("c");
                    if (fid == null) continue;
                    ObjectUuidPK pk1 = new ObjectUuidPK(fid);
                    this._disable(ctx, (IObjectPK)pk1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected Map _batchDelete(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        evi.setFilter(filter);
        FundFlowItemCollection col = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
        HashMap<String, Object> map = new HashMap<String, Object>();
        StringBuffer result = new StringBuffer();
        StringBuffer failInfo = new StringBuffer();
        ArrayList<String> msgList = new ArrayList<String>();
        int size = col.size();
        int successCount = 0;
        int failCount = 0;
        boolean flag = false;
        if (size <= 0) {
            return null;
        }
        FundFlowItemInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)info.getId().toString()));
            if (!this.referenceVerfiy(ctx, (IObjectPK)pk)) {
                super.delete(ctx, (IObjectPK)pk);
                ++successCount;
                continue;
            }
            flag = true;
            String BatchDelete_resource = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.FundFlowResource", (String)"deleteError", (Locale)ctx.getLocale());
            failInfo.append(MessageFormat.format(BatchDelete_resource, info.getNumber()));
            msgList.add(MessageFormat.format(BatchDelete_resource, info.getNumber()));
            ++failCount;
        }
        String BatchDelete_result = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.FundFlowResource", (String)"deleteEx", (Locale)ctx.getLocale());
        result.append(MessageFormat.format(BatchDelete_result, "" + size, "" + (size - failCount), "" + failCount));
        map.put("result", result.toString());
        map.put("failInfo", failInfo.toString());
        map.put("failCount", failCount);
        map.put("MsgDetail", msgList);
        return map;
    }

    @Override
    protected boolean _referenceVerfiy(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean isRefer = false;
        FundFlowItemInfo info = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemInfo(pk);
        if (!info.isIsLeaf()) {
            isRefer = true;
        } else {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("fundFlowItem.id", (Object)pk.toString()));
            isRefer = JournalFlowItemFactory.getLocalInstance(ctx).exists(filter);
        }
        return isRefer;
    }

    @Override
    protected Map _batchDeleteIgnoreReference(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        evi.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        evi.setSorter(sorter);
        FundFlowItemCollection col = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
        HashMap<String, String> map = new HashMap<String, String>();
        int size = col.size();
        if (size <= 0) {
            return null;
        }
        FundFlowItemInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("longnumber"));
        FundFlowItemCollection ffiColl = null;
        int count = 0;
        HashMap<BOSUuid, FundFlowItemInfo> containMap = new HashMap<BOSUuid, FundFlowItemInfo>();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
            evi.setSelector(sic);
            evi.setFilter(filter);
            ffiColl = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
            for (int k = 0; k < col.size(); ++k) {
                if (!ffiColl.containsKey(col.get(k).getId())) continue;
                containMap.put(col.get(k).getId(), col.get(k));
            }
        }
        Iterator it = containMap.keySet().iterator();
        while (it.hasNext()) {
            col.remove((FundFlowItemInfo)containMap.get(it.next()));
        }
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
            evi.setSelector(sic);
            evi.setFilter(filter);
            ffiColl = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
            ffiColl.add(info);
            ffiColl.sort("longnumber");
            count += ffiColl.size();
            for (int j = 0; j < ffiColl.size(); ++j) {
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)info.getId().toString()));
                if (!this._exists(ctx, (IObjectPK)pk)) continue;
                this._deleteIgnoreReference(ctx, (IObjectPK)pk);
            }
        }
        map.put("result", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.FundFlowResource", (String)"deleteSuccess", (Locale)ctx.getLocale(), (Object[])new Object[]{count}));
        return map;
    }

    @Override
    protected void _deleteIgnoreReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Object map = null;
        FundFlowItemInfo info = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo(pk);
        if (!info.isIsLeaf()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid as c from T_CAS_FundFlowItem where FparentId=?", (Object[])new Object[]{info.getId().toString()});
            try {
                while (rs.next()) {
                    String fid = rs.getString("c");
                    if (fid == null) continue;
                    ObjectUuidPK pk1 = new ObjectUuidPK(fid);
                    this._deleteIgnoreReference(ctx, (IObjectPK)pk1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        } else {
            super.delete(ctx, pk);
        }
    }

    @Override
    protected void _enableIgnoreReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundFlowItemInfo info = this.getFundFlowItemInfo(ctx, pk);
        if (info.getState().equals((Object)FlowItemStateEnum.ENABLE)) {
            return;
        }
        info.setState(FlowItemStateEnum.ENABLE);
        this._updateIgnoreReference(ctx, pk, (IObjectValue)info);
        if (!info.isIsLeaf()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid as c from T_CAS_FundFlowItem where FparentId=?", (Object[])new Object[]{info.getId().toString()});
            try {
                while (rs.next()) {
                    String fid = rs.getString("c");
                    if (fid == null) continue;
                    ObjectUuidPK pk1 = new ObjectUuidPK(fid);
                    this._enableIgnoreReference(ctx, (IObjectPK)pk1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void _disableIgnoreReference(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundFlowItemInfo info = this.getFundFlowItemInfo(ctx, pk);
        if (info.getState().equals((Object)FlowItemStateEnum.DISABLE)) {
            return;
        }
        info.setState(FlowItemStateEnum.DISABLE);
        this._updateIgnoreReference(ctx, pk, (IObjectValue)info);
        if (!info.isIsLeaf()) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select fid as c from T_CAS_FundFlowItem where FparentId=?", (Object[])new Object[]{info.getId().toString()});
            try {
                while (rs.next()) {
                    String fid = rs.getString("c");
                    if (fid == null) continue;
                    ObjectUuidPK pk1 = new ObjectUuidPK(fid);
                    this._disableIgnoreReference(ctx, (IObjectPK)pk1);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected Map _batchDisableIgnoreReference(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        evi.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        evi.setSorter(sorter);
        FundFlowItemCollection col = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
        StringBuffer result = new StringBuffer();
        int size = col.size();
        if (size <= 0) {
            return null;
        }
        FundFlowItemInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("longnumber"));
        FundFlowItemCollection ffiColl = null;
        FundFlowItemInfo oneChildNode = null;
        int count = 0;
        HashMap<BOSUuid, FundFlowItemInfo> containMap = new HashMap<BOSUuid, FundFlowItemInfo>();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
            evi.setSelector(sic);
            evi.setFilter(filter);
            ffiColl = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
            for (int k = 0; k < col.size(); ++k) {
                if (!ffiColl.containsKey(col.get(k).getId())) continue;
                containMap.put(col.get(k).getId(), col.get(k));
            }
        }
        Iterator it = containMap.keySet().iterator();
        while (it.hasNext()) {
            col.remove((FundFlowItemInfo)containMap.get(it.next()));
        }
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
            evi.setSelector(sic);
            evi.setFilter(filter);
            ffiColl = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
            ffiColl.add(info);
            count += ffiColl.size();
            for (int j = 0; j < ffiColl.size(); ++j) {
                oneChildNode = ffiColl.get(j);
                if (oneChildNode.getState().equals((Object)FlowItemStateEnum.DISABLE)) continue;
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)oneChildNode.getId().toString()));
                this._disableIgnoreReference(ctx, (IObjectPK)pk);
            }
        }
        map.put("MsgStr", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.FundFlowResource", (String)"15_disableSuccess", (Locale)ctx.getLocale(), (Object[])new Object[]{count}));
        return map;
    }

    @Override
    protected Map _batchEnableIgnoreReference(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        evi.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        evi.setSorter(sorter);
        FundFlowItemCollection col = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
        int size = col.size();
        if (size <= 0) {
            return null;
        }
        FundFlowItemInfo info = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("longnumber"));
        FundFlowItemCollection ffiColl = null;
        FundFlowItemInfo oneChildNode = null;
        int count = 0;
        HashMap<BOSUuid, FundFlowItemInfo> containMap = new HashMap<BOSUuid, FundFlowItemInfo>();
        for (int i = 0; i < size; ++i) {
            info = col.get(i);
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
            evi.setSelector(sic);
            evi.setFilter(filter);
            ffiColl = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
            for (int k = 0; k < col.size(); ++k) {
                if (!ffiColl.containsKey(col.get(k).getId())) continue;
                containMap.put(col.get(k).getId(), col.get(k));
            }
        }
        Iterator it = containMap.keySet().iterator();
        while (it.hasNext()) {
            col.remove((FundFlowItemInfo)containMap.get(it.next()));
        }
        for (int i = 0; i < col.size(); ++i) {
            info = col.get(i);
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!" + "%"), CompareType.LIKE));
            evi.setSelector(sic);
            evi.setFilter(filter);
            ffiColl = FundFlowItemFactory.getLocalInstance(ctx).getFundFlowItemCollection(evi);
            ffiColl.add(info);
            count += ffiColl.size();
            for (int j = 0; j < ffiColl.size(); ++j) {
                oneChildNode = ffiColl.get(j);
                if (oneChildNode.getState().equals((Object)FlowItemStateEnum.ENABLE)) continue;
                ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)oneChildNode.getId().toString()));
                this._enableIgnoreReference(ctx, (IObjectPK)pk);
            }
        }
        map.put("MsgStr", ResourceBase.getString((String)"com.kingdee.eas.fi.cas.FundFlowResource", (String)"16_enableSuccess", (Locale)ctx.getLocale(), (Object[])new Object[]{count}));
        return map;
    }

    @Override
    protected void _updateIgnoreReference(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FundFlowItemInfo info = (FundFlowItemInfo)model;
        super._update(ctx, pk, model);
    }
}

