/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.FlowItemStateEnum;
import com.kingdee.eas.fi.cas.FundFlowDirection;
import com.kingdee.eas.fi.cas.FundFlowItemCollection;
import com.kingdee.eas.fi.cas.FundFlowItemFactory;
import com.kingdee.eas.fi.cas.FundFlowItemInfo;
import com.kingdee.eas.fi.cas.IFundFlowItem;
import com.kingdee.eas.fi.cas.app.AbstractFundFlowItemWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.FundFlowItemHelper;
import com.kingdee.eas.fi.cas.vo.FundFlowItemVO;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class FundFlowItemWebFacadeControllerBean
extends AbstractFundFlowItemWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.FundFlowItemWebFacadeControllerBean");
    private static String PERMITEM_FUNDFLOWITEM_DELETE = "cas_fundflowItem_04remove";
    private static String PERMITEM_FUNDFLOWITEM_EDIT = "cas_fundflowItem_03edit";
    private static String PERMITEM_FUNDFLOWITEM_VIEW = "cas_fundflowItem_06view";
    private static String PERMITEM_FUNDFLOWITEM_ADDNEW = "cas_fundflowItem_02addnew";

    @Override
    protected Map _saveFundFlowItem(Context ctx, String jsonStr, String parentNodeIdStr) throws BOSException, EASBizException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        FundFlowItemVO dataVO = (FundFlowItemVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, FundFlowItemVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstData;
        }
        FundFlowItemInfo fundFlowItemInfo = FundFlowItemHelper.getInstance().VOToInfo(ctx, dataVO);
        IFundFlowItem iFundFlowItem = FundFlowItemFactory.getLocalInstance(ctx);
        IObjectPK rstID = null;
        Object coll = null;
        try {
            boolean isAddNewPermission;
            boolean bl = isAddNewPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_ADDNEW, false).size() > 0;
            if (!isAddNewPermission) {
                throw new CasWebException(CasWebException.NO_ADDNEW_AUTHRIZED);
            }
            ObjectUuidPK parentNodePk = null;
            if (parentNodeIdStr != null) {
                if ("treeId".equals(parentNodeIdStr)) {
                    fundFlowItemInfo.setIsLeaf(true);
                    fundFlowItemInfo.setParent(null);
                    rstID = iFundFlowItem.submit((CoreBaseInfo)fundFlowItemInfo);
                } else {
                    parentNodePk = new ObjectUuidPK(parentNodeIdStr);
                    FundFlowItemInfo parentFundFlowItemInfo = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)parentNodePk);
                    if (!parentFundFlowItemInfo.getProperty().toString().equals(fundFlowItemInfo.getProperty().toString())) {
                        rstData.put("MsgStr", CASWebUtil.getResource(ctx, "503_PropertNotEqualsParent"));
                        rstData.put("OPStatus", "failure");
                        return rstData;
                    }
                    if (!parentFundFlowItemInfo.getDirection().toString().equals(fundFlowItemInfo.getDirection().toString()) && !FundFlowDirection.getEnum(0).toString().equals(parentFundFlowItemInfo.getDirection().toString())) {
                        rstData.put("MsgStr", CASWebUtil.getResource(ctx, "504_DirectionNotEqualsParent"));
                        rstData.put("OPStatus", "failure");
                        return rstData;
                    }
                    if (parentFundFlowItemInfo.getState().toString().equals(FlowItemStateEnum.DISABLE.toString())) {
                        rstData.put("MsgStr", CASWebUtil.getResource(ctx, "505_ParentStateDisable"));
                        rstData.put("OPStatus", "failure");
                        return rstData;
                    }
                    fundFlowItemInfo.setIsLeaf(true);
                    if (parentFundFlowItemInfo.isIsLeaf()) {
                        parentFundFlowItemInfo.setIsLeaf(false);
                        FundFlowItemFactory.getRemoteInstance().save((CoreBaseInfo)parentFundFlowItemInfo);
                    }
                    fundFlowItemInfo.setParent(parentFundFlowItemInfo);
                    rstID = iFundFlowItem.submit((CoreBaseInfo)fundFlowItemInfo);
                }
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        if (rstID != null) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg(ctx, "SAVE_Successfully"));
            rstData.put("OPStatus", "success");
            rstData.put("IdAfterSave", (String)rstID);
        }
        return rstData;
    }

    private EntityViewInfo getSelector() {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("property"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("remarks"));
        sic.add(new SelectorItemInfo("isleaf"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("description"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setSorter(sorter);
        return view;
    }

    private EntityViewInfo getChildrenSelector(String curNodeId) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("property"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("remarks"));
        sic.add(new SelectorItemInfo("isleaf"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("description"));
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setSorter(sorter);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(curNodeId + "!" + "%"), CompareType.LIKE));
        view.setFilter(filter);
        return view;
    }

    @Override
    protected Map _deleteFundFlowItem(Context ctx, String idStr, String curNodeId) throws BOSException {
        Map<String, FundFlowItemCollection> rstData = new HashMap();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        try {
            boolean isPermission;
            boolean bl = isPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_DELETE, false).size() > 0;
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
            }
            String[] idArr = idStr.split(",");
            ArrayList<String> sucPKList = new ArrayList<String>();
            StringBuffer errorMsg = new StringBuffer();
            for (int idx = 0; idx < idArr.length; ++idx) {
                sucPKList.add(idArr[idx]);
            }
            EntityViewInfo view = this.getFilterSelector("id", sucPKList);
            FundFlowItemCollection collSortByLongNumber = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
            FundFlowItemInfo fundFlowItemInfoCur = collSortByLongNumber.get(0);
            FundFlowItemInfo parentInfo = fundFlowItemInfoCur.getParent();
            rstData = FundFlowItemFactory.getRemoteInstance().batchDeleteIgnoreReference(sucPKList);
            FundFlowItemCollection coll = null;
            if (parentInfo != null && parentInfo.getId() != null) {
                FundFlowItemInfo parentFundFlowItemInfo = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId().toString()));
                view = this.getChildrenSelector(parentFundFlowItemInfo.getLongNumber());
                coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
                coll.add(parentFundFlowItemInfo);
                coll.sort("longnumber");
            } else {
                view = this.getSelector();
                coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
            }
            rstData.put("resultCollection", coll);
        }
        catch (EASBizException e) {
            errorMsgList.add(e.getMessage(ctx.getLocale()));
        }
        rstData.put("summaryMsg", (FundFlowItemCollection)((Object)rstData.get("result")));
        rstData.put("OPStatus", (FundFlowItemCollection)((Object)"success"));
        rstData.put("detailMsgList", (FundFlowItemCollection)((Object)errorMsgList));
        return rstData;
    }

    @Override
    protected Map _saveFundFlowItemForEdit(Context ctx, String jsonStr, String rowIdChecked) throws BOSException {
        HashMap<String, String> rstData = new HashMap<String, String>();
        FundFlowItemVO dataVO = (FundFlowItemVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonStr, FundFlowItemVO.class);
        if (dataVO == null) {
            rstData.put("MsgStr", CASWebUtil.getResource(ctx, "InputDataExption"));
            return rstData;
        }
        FundFlowItemInfo fundFlowItemInfo = FundFlowItemHelper.getInstance().VOToInfo(ctx, dataVO);
        IFundFlowItem iFundFlowItem = FundFlowItemFactory.getLocalInstance(ctx);
        IObjectPK rstID = null;
        try {
            boolean isEditPermission;
            boolean bl = isEditPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_EDIT, false).size() > 0;
            if (!isEditPermission) {
                throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
            }
            ObjectUuidPK curNodePk = null;
            if (rowIdChecked != null) {
                curNodePk = new ObjectUuidPK(rowIdChecked.toString());
                FundFlowItemInfo curFundFlowItemInfo = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)curNodePk);
                if (!curFundFlowItemInfo.getProperty().toString().equals(fundFlowItemInfo.getProperty().toString())) {
                    rstData.put("MsgStr", CASWebUtil.getResource(ctx, "503_PropertNotEqualsParent"));
                    rstData.put("OPStatus", "failure");
                    return rstData;
                }
                if (!curFundFlowItemInfo.getDirection().toString().equals(fundFlowItemInfo.getDirection().toString()) && !FundFlowDirection.getEnum(0).toString().equals(curFundFlowItemInfo.getDirection().toString())) {
                    rstData.put("MsgStr", CASWebUtil.getResource(ctx, "504_DirectionNotEqualsParent"));
                    rstData.put("OPStatus", "failure");
                    return rstData;
                }
                if (curFundFlowItemInfo.getState().toString().equals(FlowItemStateEnum.DISABLE.toString())) {
                    rstData.put("MsgStr", CASWebUtil.getResource(ctx, "506_CurStateDisable"));
                    rstData.put("OPStatus", "failure");
                    return rstData;
                }
                if (!curFundFlowItemInfo.isIsLeaf()) {
                    rstData.put("MsgStr", CASWebUtil.getResource(ctx, "507_CurIsNotLeaf"));
                    rstData.put("OPStatus", "failure");
                    return rstData;
                }
                fundFlowItemInfo.setId(curFundFlowItemInfo.getId());
                rstID = iFundFlowItem.submit((CoreBaseInfo)fundFlowItemInfo);
            }
        }
        catch (EASBizException e1) {
            rstData.put("MsgStr", e1.getMessage(ctx.getLocale()));
            e1.printStackTrace();
            logger.debug((Object)e1);
            return rstData;
        }
        catch (BOSException e2) {
            rstData.put("MsgStr", e2.getMessage());
            e2.printStackTrace();
            logger.debug((Object)e2);
            return rstData;
        }
        if (rstID != null) {
            rstData.put("MsgStr", CASWebHelper.getCASMsg(ctx, "SAVE_Successfully"));
            rstData.put("OPStatus", "success");
            rstData.put("IdAfterSave", (String)rstID);
        }
        return rstData;
    }

    @Override
    protected Map _enableRecord(Context ctx, String idStr, String curNodeId) throws BOSException, EASBizException {
        boolean isEditPermission;
        Map rstData = new HashMap();
        boolean bl = isEditPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_EDIT, false).size() > 0;
        if (!isEditPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        HashSet set = new HashSet();
        ArrayList<String> list = new ArrayList<String>();
        String[] idArr = idStr.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            list.add(idArr[i]);
        }
        rstData = FundFlowItemFactory.getRemoteInstance().batchEnableIgnoreReference(list);
        rstData.put("summaryMsg", rstData.get("MsgStr"));
        return rstData;
    }

    @Override
    protected Map _disableRecord(Context ctx, String idStr, String curNodeId) throws BOSException, EASBizException {
        boolean isEditPermission;
        Map rstData = new HashMap();
        boolean bl = isEditPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_EDIT, false).size() > 0;
        if (!isEditPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        HashSet set = new HashSet();
        ArrayList<String> list = new ArrayList<String>();
        String[] idArr = idStr.split(",");
        for (int i = 0; i < idArr.length; ++i) {
            list.add(idArr[i]);
        }
        rstData = FundFlowItemFactory.getRemoteInstance().batchDisableIgnoreReference(list);
        rstData.put("summaryMsg", rstData.get("MsgStr"));
        return rstData;
    }

    @Override
    protected Map _loadTreeData(Context ctx) throws BOSException, EASBizException {
        boolean isViewPermission;
        HashMap<String, FundFlowItemCollection> rstData = new HashMap<String, FundFlowItemCollection>();
        boolean bl = isViewPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_VIEW, false).size() > 0;
        if (!isViewPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        EntityViewInfo view = this.getSelector();
        FundFlowItemCollection coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
        rstData.put("resultCollection", coll);
        return rstData;
    }

    @Override
    protected Map _loadGridData(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, FundFlowItemCollection> rstData = new HashMap<String, FundFlowItemCollection>();
        FundFlowItemCollection coll = null;
        FundFlowItemInfo flowItemInfo = null;
        if ("treeId".equals(id)) {
            EntityViewInfo view = this.getSelector();
            coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
        } else {
            flowItemInfo = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(id));
            EntityViewInfo view = this.getChildrenSelector(flowItemInfo.getLongNumber());
            coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
            coll.add(flowItemInfo);
            coll.sort("longnumber");
        }
        rstData.put("resultCollection", coll);
        return rstData;
    }

    @Override
    protected Map _refreshPageDataByIdForAddNew(Context ctx, String curNodeId) throws BOSException, EASBizException {
        boolean isViewPermission;
        HashMap<String, FundFlowItemCollection> rstData = new HashMap<String, FundFlowItemCollection>();
        boolean bl = isViewPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_VIEW, false).size() > 0;
        if (!isViewPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        EntityViewInfo view = this.getSelector();
        FundFlowItemCollection coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
        rstData.put("resultCollectionForTree", coll);
        FundFlowItemInfo flowItemInfo = null;
        if ("treeId".equals(curNodeId)) {
            view = this.getSelector();
            coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
            flowItemInfo = new FundFlowItemInfo();
            rstData.put("resultCollectionForGrid", coll);
        } else {
            flowItemInfo = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(curNodeId));
            view = this.getChildrenSelector(flowItemInfo.getLongNumber());
            coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
            coll.add(flowItemInfo);
            coll.sort("longnumber");
            rstData.put("resultCollectionForGrid", coll);
        }
        return rstData;
    }

    @Override
    protected Map _refreshPageDataById(Context ctx, String parentNodeId) throws BOSException, EASBizException {
        boolean isViewPermission;
        HashMap<String, FundFlowItemCollection> rstData = new HashMap<String, FundFlowItemCollection>();
        boolean bl = isViewPermission = CASWebHelper.getAuthorizedOrg(ctx, PERMITEM_FUNDFLOWITEM_VIEW, false).size() > 0;
        if (!isViewPermission) {
            throw new CasWebException(CasWebException.NO_EDIT_AUTHRIZED);
        }
        EntityViewInfo view = this.getSelector();
        FundFlowItemCollection coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
        rstData.put("resultCollectionForTree", coll);
        if ("treeId".equals(parentNodeId)) {
            view = this.getSelector();
            coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
            rstData.put("resultCollectionForGrid", coll);
        } else {
            FundFlowItemInfo parentFundFlowItemInfo = null;
            parentFundFlowItemInfo = FundFlowItemFactory.getRemoteInstance().getFundFlowItemInfo((IObjectPK)new ObjectUuidPK(parentNodeId));
            view = this.getChildrenSelector(parentFundFlowItemInfo.getLongNumber());
            coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(view);
            coll.add(parentFundFlowItemInfo);
            coll.sort("longnumber");
            rstData.put("resultCollectionForGrid", coll);
        }
        return rstData;
    }

    @Override
    protected Map _getAdvanceQueryData(Context ctx, String advQryFilter) throws BOSException, EASBizException {
        HashMap<String, FundFlowItemCollection> rstData = new HashMap<String, FundFlowItemCollection>();
        EntityViewInfo entityViewInfo = this.getAdvanceQryFilterSelector(advQryFilter);
        FundFlowItemCollection coll = FundFlowItemFactory.getRemoteInstance().getFundFlowItemCollection(entityViewInfo);
        rstData.put("resultCollection", coll);
        return rstData;
    }

    private EntityViewInfo getAdvanceQryFilterSelector(String filterStr) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("property"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("remarks"));
        sic.add(new SelectorItemInfo("isleaf"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("description"));
        view.setSelector(sic);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setSorter(sorter);
        FilterInfo filterInfo = null;
        try {
            if (filterStr != null && !"".equals(filterStr)) {
                filterInfo = new FilterInfo(filterStr);
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        view.setFilter(filterInfo);
        return view;
    }

    private EntityViewInfo getFilterSelector(String compareExpr, List list) {
        EntityViewInfo view = new EntityViewInfo();
        HashSet set = new HashSet(list);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("direction"));
        sic.add(new SelectorItemInfo("property"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("remarks"));
        sic.add(new SelectorItemInfo("isleaf"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("longnumber"));
        sic.add(new SelectorItemInfo("description"));
        view.setSelector(sic);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(compareExpr, set, CompareType.INCLUDE));
        view.setFilter(filterInfo);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("longnumber"));
        view.setSorter(sorter);
        return view;
    }

    @Override
    protected Map _getSumInfo(Context ctx, String filter, String selectedIds) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuffer validIdSql = new StringBuffer("SELECT id where " + filter + " and id in('NE'");
        ArrayList<String> validIdList = new ArrayList<String>();
        if (!selectedIds.equals("")) {
            String[] idArr = selectedIds.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                validIdSql.append(",'" + idArr[i] + "'");
            }
            validIdSql.append(")");
            IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.app.FundFlowItemQuery"));
            queryExecutor.setObjectView(validIdSql.toString());
            IRowSet rowSet = queryExecutor.executeQuery();
            try {
                while (rowSet.next()) {
                    validIdList.add(rowSet.getString("id"));
                }
            }
            catch (Exception e) {
                result.put("error", 1);
                result.put("msg", e.getMessage());
                e.printStackTrace();
            }
        }
        result.put("validIdList", validIdList);
        return result;
    }
}

