/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.FundsMoveBillBookNotifyBuilder;
import com.kingdee.eas.fi.cas.FundsMoveBillCollection;
import com.kingdee.eas.fi.cas.FundsMoveBillFactory;
import com.kingdee.eas.fi.cas.FundsMoveBillInfo;
import com.kingdee.eas.fi.cas.FundsMoveBillStateEnum;
import com.kingdee.eas.fi.cas.FundsMoveException;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.app.AbstractFundsMoveBillControllerBean;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMBGHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.IFMBgUsed;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class FundsMoveBillControllerBean
extends AbstractFundsMoveBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.FundsMoveBillControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FundsMoveBillInfo info = (FundsMoveBillInfo)model;
        if (FMHelper.isEmpty((String)info.getNumber())) {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FundsMoveBillInfo info = (FundsMoveBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((FundsMoveBillInfo)model));
        if (info.getBillState() == null) {
            info.setBillState(FundsMoveBillStateEnum.saved);
            info.setFiVouchered(false);
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FundsMoveBillInfo info = (FundsMoveBillInfo)model;
        FMBGHelper.fillBgItem((Context)ctx, (IFMBgUsed)((FundsMoveBillInfo)model));
        if (info.getBillState() == null || info.getBillState() == FundsMoveBillStateEnum.saved) {
            info.setBillState(FundsMoveBillStateEnum.submited);
        }
        IObjectPK pk = super._submit(ctx, model);
        FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)((FundsMoveBillInfo)model));
        FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
        return pk;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _audit(Context ctx, Set pks) throws BOSException, EASBizException {
        if (pks == null || pks.size() == 0) {
            throw new FundsMoveException(FundsMoveException.IDSETISNULL);
        }
        Iterator it = pks.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            this.singleAudit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _singleAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        FundsMoveBillInfo info = FundsMoveBillFactory.getLocalInstance(ctx).getFundsMoveBillInfo(pk);
        if (info.getBillState() != FundsMoveBillStateEnum.submited) {
            throw new FundsMoveException(FundsMoveException.SELECT_SUBMITED_BILL);
        }
        info.setBillState(FundsMoveBillStateEnum.audited);
        info.setAuditor(userInfo);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"119_FundsMoveBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new FundsMoveBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fi_cas_fundsmove_audit");
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _antiAudit(Context ctx, Set pks) throws BOSException, EASBizException {
        String ids = FMHelper.setTran2String((Set)pks);
        String sql = "select top 1 fid from T_BOT_RELATION where FSRCOBJECTID in " + ids;
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (set.size() > 0) {
            throw new FundsMoveException(FundsMoveException.ISGENBILL);
        }
        if (pks == null || pks.size() == 0) {
            throw new FundsMoveException(FundsMoveException.IDSETISNULL);
        }
        Iterator it = pks.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            this.singleAntiAudit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _singleAntiAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundsMoveBillInfo info = FundsMoveBillFactory.getLocalInstance(ctx).getFundsMoveBillInfo(pk);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"120_FundsMoveBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new FundsMoveBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fi_cas_fundsmove_antiAudit");
        if (info.getBillState() != FundsMoveBillStateEnum.audited) {
            throw new FundsMoveException(FundsMoveException.SELECT_AUDIT_BILL);
        }
        if (info.isFiVouchered()) {
            throw new FundsMoveException(FundsMoveException.HAS_VOUCHERED);
        }
        info.setBillState(FundsMoveBillStateEnum.submited);
        info.setNull("auditor");
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId()), (IObjectValue)info);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _settle(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            throw new FundsMoveException(FundsMoveException.IDSETISNULL);
        }
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            this.singleSettle(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _singleSettle(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("moveOutAccountView.*");
        sic.add("moveInAccountView.*");
        sic.add("feeBankAccount.*");
        FundsMoveBillInfo info = FundsMoveBillFactory.getLocalInstance(ctx).getFundsMoveBillInfo(pk, sic);
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_CAS_FundsMoveBill SET FCashier = ? ,fbillstate=4 WHERE fid=?");
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"121_FundsMoveBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new FundsMoveBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fi_cas_fundsmove_settle");
        if (info.getBillState() != FundsMoveBillStateEnum.audited) {
            throw new FundsMoveException(FundsMoveException.SELECT_AUDITED_SETTLE);
        }
        FundsMoveBillBookNotifyBuilder builder = new FundsMoveBillBookNotifyBuilder();
        JournalCollection journalColl = builder.getJournalColl(ctx, info.getId().toString());
        BookNotifyFacadeFactory.getLocalInstance(ctx).bookBatch(journalColl);
        String userid = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId().toString();
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{userid, info.getId().toString()});
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    @Override
    protected void _antiSettle(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() == 0) {
            throw new FundsMoveException(FundsMoveException.IDSETISNULL);
        }
        Iterator it = idSet.iterator();
        while (it.hasNext()) {
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)it.next().toString()));
            this.singleAntiSettle(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _singleAntiSettle(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundsMoveBillInfo info = FundsMoveBillFactory.getLocalInstance(ctx).getFundsMoveBillInfo(pk);
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE T_CAS_FundsMoveBill SET FCashier = NULL ,fbillstate=3 WHERE fid=?");
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"122_FundsMoveBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new FundsMoveBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"fi_cas_fundsmove_antiSettle");
        if (info.getBillState() != FundsMoveBillStateEnum.settled) {
            throw new FundsMoveException(FundsMoveException.SELECT_SETTLED_ANTISETTLE);
        }
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{info.getId().toString()});
        BookNotifyFacadeFactory.getLocalInstance(ctx).antiBook(info.getId().toString());
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FundsMoveBillInfo info = (FundsMoveBillInfo)model;
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"123_FundsMoveBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new FundsMoveBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"cas_fundsmove_update");
        super._update(ctx, pk, model);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundsMoveBillInfo info = (FundsMoveBillInfo)this._getValue(ctx, pk);
        IObjectPK pkOut = LogUtil.beginLog((Context)ctx, (String)ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"124_FundsMoveBillControllerBean", (Locale)ctx.getLocale()), (BOSObjectType)new FundsMoveBillInfo().getBOSType(), null, (String)info.getNumber(), (String)"cas_fundsmove_remove");
        if (info.getBillState() == FundsMoveBillStateEnum.audited || info.getBillState() == FundsMoveBillStateEnum.settled) {
            throw new FundsMoveException(FundsMoveException.AUDITED_BILL_CANT_UPDATE);
        }
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        FmMbgHelper.returnBudget((Context)ctx, (IObjectPK)pk);
        LogUtil.afterLog((Context)ctx, (IObjectPK)pkOut);
        FMBGHelper.signBgItemRelease((Context)ctx, (IObjectPK)pk);
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo relation = (BOTRelationInfo)bOTRelationInfo;
        BOSObjectType bosType = BOSUuid.read((String)relation.getDestObjectID()).getType();
        if (bosType.equals((Object)new VoucherInfo().getBOSType())) {
            FundsMoveBillInfo info = (FundsMoveBillInfo)srcBillVO;
            if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.DELETE)) {
                info.setAccountant(null);
                info.setVoucher(null);
                info.setFiVouchered(false);
            } else if (bOTBillOperStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW)) {
                String voucherID = relation.getDestObjectID();
                VoucherInfo voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(voucherID));
                info.setAccountant(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser());
                info.setVoucher(voucherInfo);
                info.setFiVouchered(true);
            }
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    @Override
    protected Map _saveBatch(Context ctx, List idList) throws BOSException, EASBizException {
        FundsMoveBillCollection FundsMoveBillCol = this.getFundsMoveBillCollection(ctx, this.getEntityViewByIDList(idList));
        int size = FundsMoveBillCol.size();
        FundsMoveBillInfo info = null;
        for (int i = 0; i < size; ++i) {
            info = FundsMoveBillCol.get(i);
            if (info.getBillState() != FundsMoveBillStateEnum.saved) continue;
            info.setBillState(FundsMoveBillStateEnum.submited);
            try {
                IObjectPK pk = FundsMoveBillFactory.getLocalInstance(ctx).submit((CoreBaseInfo)info);
                FMBGHelper.signBgItemUsed((Context)ctx, (IObjectPK)pk, (IFMBgUsed)info);
                FmMbgHelper.requestBudget((Context)ctx, (IObjectPK)pk);
                continue;
            }
            catch (Exception e) {
                throw new CasException(CasException.SUBMITERROR, new Object[]{info.getNumber(), e.getMessage()});
            }
        }
        return null;
    }

    private EntityViewInfo getEntityViewByIDList(List idList) {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(idList);
        f.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        env.setFilter(f);
        SelectorItemCollection sic = this.getFundsMoveBillSelectors();
        int size = sic.size();
        for (int i = 0; i < size; ++i) {
            env.getSelector().add(sic.get(i));
        }
        return env;
    }

    protected SelectorItemCollection getFundsMoveBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        return sic;
    }

    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos, IObjectCollection destObjCol) throws BOSException, EASBizException {
        if (bOTRelationInfos == null || bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = this.getConnection(ctx);
            stmt = conn.createStatement();
            if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
                for (int i = 0; i < bOTRelationInfos.size(); ++i) {
                    int j;
                    VoucherEntryCollection col;
                    HashSet<String> idSet;
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    VoucherInfo voucherInfo = new VoucherInfo();
                    if (destObjCol != null && destObjCol.size() > 0) {
                        try {
                            for (int j2 = 0; j2 < destObjCol.size(); ++j2) {
                                voucherInfo = (VoucherInfo)destObjCol.getObject(j2);
                                if (bOTRelationInfos.get(i).getDestObjectID().equals(voucherInfo.getId().toString())) break;
                            }
                        }
                        catch (Exception e) {
                            voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                        }
                    } else {
                        voucherInfo = (VoucherInfo)VoucherFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectStringPK(bOTRelationInfos.get(i).getDestObjectID()));
                    }
                    String oppAccountId = "";
                    VoucherEntryCollection coll = voucherInfo.getEntries();
                    for (int j3 = 0; j3 < coll.size(); ++j3) {
                        VoucherEntryInfo entryInfo = coll.get(j3);
                        if (EntryDC.DEBIT != entryInfo.getEntryDC() || entryInfo.getAccount() == null) continue;
                        oppAccountId = entryInfo.getAccount().getId().toString();
                        break;
                    }
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("billId", (Object)srcBillId, CompareType.EQUALS));
                    boolean isexist = JournalFactory.getLocalInstance(ctx).exists(filter);
                    String billSql = "";
                    String journalSql = "";
                    String vcResultSql = "";
                    if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                        billSql = "Update T_CAS_FundsMoveBill set FVoucherID = null, FFivouchered = 0 ,FACCOUNTANT =null where FID = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = null , FVoucherTypeID = null, FVoucherId = null where FBillId = '" + srcBillId + "'";
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = null, FVOUCHERTYPEID = null where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + srcBillId + "')";
                        } else {
                            idSet = new HashSet<String>();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = null , FBillNumber = null ,FVoucherTypeID = null, FVoucherId = null where FBillId = '" + voucherInfo.getId().toString() + "'  or FBillId in  (" + this.newBuildIn(idSet.toArray());
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = null ,FbillNumber = null , FVOUCHERTYPEID = null where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "'  or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                        }
                    } else if (BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) {
                        billSql = "Update T_CAS_FundsMoveBill set FVoucherID =  '" + voucherInfo.getId().toString() + "' where Fid = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' , FOPPACCOUNTVIEWID = '" + oppAccountId + "' where FBillId = '" + srcBillId + "'";
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + srcBillId + "')";
                        } else {
                            idSet = new HashSet();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            if (idSet.size() > 0) {
                                journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' where FBillId = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray());
                                vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FbillNumber  = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                            }
                        }
                    } else {
                        billSql = "Update T_CAS_FundsMoveBill set FVoucherID =  '" + voucherInfo.getId().toString() + "' , FFivouchered = 1 ,FACCOUNTANT = '" + userId + "'  where Fid = '" + srcBillId + "'";
                        if (isexist) {
                            journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' , FOPPACCOUNTVIEWID = '" + oppAccountId + "' where FBillId = '" + srcBillId + "'";
                            vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + srcBillId + "')";
                        } else {
                            idSet = new HashSet();
                            col = voucherInfo.getEntries();
                            for (j = 0; j < col.size(); ++j) {
                                idSet.add(col.get(j).getId().toString());
                            }
                            if (idSet.size() > 0) {
                                journalSql = "Update T_CAS_Journal set FVoucherNumber = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "' , FVoucherTypeID = '" + voucherInfo.getVoucherType().getId().toString() + "' , FVoucherId = '" + voucherInfo.getId().toString() + "' where FBillId = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray());
                                vcResultSql = "Update T_VC_VcResult set FVOUCHERNUMBER = '" + voucherInfo.getNumber() + "' , FbillNumber  = '" + voucherInfo.getNumber() + "', FVOUCHERTYPEID = '" + voucherInfo.getVoucherType().getId().toString() + "' where FBIZOBJECTID in (select FID from T_CAS_Journal where FBillID = '" + voucherInfo.getId().toString() + "' or FBillId in  (" + this.newBuildIn(idSet.toArray()) + ")";
                            }
                        }
                    }
                    if (!EmptyUtil.isEmpty((String)billSql)) {
                        stmt.addBatch(billSql);
                    }
                    if (!EmptyUtil.isEmpty((String)journalSql)) {
                        stmt.addBatch(journalSql);
                    }
                    if (EmptyUtil.isEmpty((String)vcResultSql)) continue;
                    stmt.addBatch(vcResultSql);
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private String newBuildIn(Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        for (int i = 0; i < set.length; ++i) {
            if (i == set.length - 1) {
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                continue;
            }
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

