/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FundsMoveException;
import com.kingdee.eas.fi.cas.FundsMoveTypeInfo;
import com.kingdee.eas.fi.cas.app.AbstractFundsMoveTypeControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import org.apache.log4j.Logger;

public class FundsMoveTypeControllerBean
extends AbstractFundsMoveTypeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.FundsMoveTypeControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FundsMoveTypeInfo info = (FundsMoveTypeInfo)model;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)info, (String)"number");
        this._checkNumberDup(ctx, (IObjectValue)info);
        return super._addnew(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)false);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._isReferenced(ctx, pk);
        FundsMoveTypeInfo oldInfo = (FundsMoveTypeInfo)this._getValue(ctx, pk);
        FundsMoveTypeInfo newInfo = (FundsMoveTypeInfo)model;
        if (newInfo.isIsSystem()) {
            throw new FundsMoveException(FundsMoveException.SYSTEMBILL_NOT_UPDATE);
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)newInfo, (String)"number");
        if (oldInfo.getNumber() != newInfo.getNumber()) {
            this._checkNumberDup(ctx, (IObjectValue)newInfo);
        }
        super._update(ctx, pk, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FundsMoveTypeInfo info = (FundsMoveTypeInfo)this._getValue(ctx, pk);
        if (info.isIsSystem()) {
            throw new FundsMoveException(FundsMoveException.SYSTEMBILL_NOT_UPDATE);
        }
        this._isReferenced(ctx, pk);
        super._delete(ctx, pk);
    }
}

