/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankBalUnreachDetailFactory;
import com.kingdee.eas.fm.common.DivideCollectionGroup;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class GenBankAdjustDataService
implements Callable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.GenBankAdjustDataService");
    protected Context ctx;
    protected int taskNum;
    protected final int minDealSize = 10;
    protected final int maxThreadSize = 3;
    protected CoreBaseCollection colls;

    public GenBankAdjustDataService() {
    }

    public GenBankAdjustDataService(Context ctx, int taskNum, CoreBaseCollection coll) {
        this.taskNum = taskNum;
        this.colls = coll;
        this.ctx = ctx;
    }

    public Object mutilThreadTrans(Context ctx, CoreBaseCollection coll) {
        int thread = 3;
        if (coll.size() < 30) {
            thread = coll.size() / 10 + 1;
        }
        DivideCollectionGroup batch = new DivideCollectionGroup(coll, thread);
        List result = batch.getResult();
        ExecutorService pool = Executors.newFixedThreadPool(thread);
        ArrayList list = new ArrayList();
        for (int i = 0; i < result.size(); ++i) {
            CoreBaseCollection singleThreadCol = (CoreBaseCollection)result.get(i);
            if (singleThreadCol == null || singleThreadCol.size() <= 0) continue;
            Callable callable = this.getService(ctx, i, singleThreadCol);
            Future f = pool.submit(callable);
            list.add(f);
        }
        pool.shutdown();
        int success = 0;
        for (Future future : list) {
            try {
                success += ((Integer)future.get()).intValue();
            }
            catch (Exception e) {
                HashMap<String, String> errs = new HashMap<String, String>();
                errs.put("err", e.getMessage());
                return errs;
            }
        }
        return success;
    }

    public Object call() throws Exception {
        logger.info((Object)(">>>" + this.taskNum + " \u4efb\u52a1\u542f\u52a8"));
        long startTime = System.currentTimeMillis();
        Object result = this.doTask();
        long endTime = System.currentTimeMillis();
        long time = (endTime - startTime) / 1000L;
        logger.info((Object)(">>>" + this.taskNum + " \u4efb\u52a1\u7ec8\u6b62; \u8017\u65f6\uff1a" + time + "\u79d2"));
        return result;
    }

    protected Callable getService(Context ctx, int taskNum, CoreBaseCollection coll) {
        return new GenBankAdjustDataService(ctx, taskNum, coll);
    }

    protected Object doTask() throws EASBizException, BOSException {
        BankBalUnreachDetailFactory.getLocalInstance(this.ctx).addnewBatchData(this.colls);
        logger.info((Object)(">>>" + this.taskNum + " \u4efb\u52a1\u65b0\u589e\u8bb0\u5f55\uff1a" + this.colls.size() + "\u6761"));
        return this.colls.size();
    }
}

