/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ARAPImportCache;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.PaymentBillImportVerify;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitPaymentBillDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)InitPaymentBillDataImport.class.getName());
    private PaymentBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private String curKey;
    private static final int MAX_Number = 80;
    private static final BigDecimal AMT_MAX_VALUE = new BigDecimal("9999999999999");
    private PeriodInfo startPeriod = null;
    private PeriodInfo currentPeriod = null;
    private boolean isInitBill = false;
    private boolean apIsStart = true;
    private boolean isFinish = false;
    private boolean isImportDataByRule = false;
    private ARAPImportCache importCache = new ARAPImportCache();
    ArApRecPayServerHelper arapServerHelper = new ArApRecPayServerHelper();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PaymentBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public PaymentBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new PaymentBillImportVerify();
        }
        return this.verify;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PaymentBillEntryInfo entry = null;
        PaymentBillInfo head = null;
        boolean isUpdateImport = false;
        String number = (String)this.getData(hsData, "FNumber");
        this.isImportDataByRule = this.importCache.getImportParamByCache(ctx);
        CompanyOrgUnitInfo curCompany = this.importCache.getCompanyByCache(ctx, hsData, "FCompanyID");
        this.importCache.checkOrgPermissionByCache(ctx, curCompany, "fi_ap_InitPayBill_import");
        try {
            this.startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)curCompany);
            this.apIsStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)curCompany);
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (CompanyOrgUnitInfo)curCompany);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new TaskExternalException("Get System Context Error!", (Throwable)ex);
        }
        this.curKey = curCompany.getNumber() + number;
        if (this.infoMap.containsKey(this.curKey)) {
            isUpdateImport = true;
        }
        if (!this.isImportDataByRule && !this.isExistHead(hsData, ctx, curCompany) || head == null) {
            if (!this.infoMap.containsKey(this.curKey)) {
                head = new PaymentBillInfo();
                head.setCompany(curCompany);
                this.parseHead(hsData, ctx, head);
                this.infoMap.put(this.curKey, head);
            } else {
                head = (PaymentBillInfo)this.infoMap.get(this.curKey);
            }
        }
        entry = (PaymentBillEntryInfo)this.parseEntry(hsData, ctx);
        this.getVerify().verifyEntry(ctx, (CoreBaseInfo)entry, head.getSourceType());
        this.getVerify().verifyEntryAmt(ctx, entry, head);
        head.getEntries().add(entry);
        BigDecimal temp = head.getActPayAmt();
        if (temp == null) {
            temp = CasConstants.ZERO;
        }
        if (entry != null) {
            temp = temp.add(entry.getActualAmt());
        }
        head.setActPayAmt(temp);
        temp = head.getActPayLocAmt();
        if (temp == null) {
            temp = CasConstants.ZERO;
        }
        if (entry != null) {
            temp = temp.add(entry.getActualLocAmt());
        }
        head.setActPayLocAmt(temp);
        if (this.isImportDataByRule && !isUpdateImport) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String cid = curCompany.getId().toString();
                if (!iCodingRuleManager.isExist((IObjectValue)head, cid)) {
                    Object[] name = new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.ArApRecPayDataImportResource", (String)"PaymentBill", (Locale)ctx.getLocale())};
                    throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
                }
                head.setNumber(iCodingRuleManager.getNumber((IObjectValue)head, cid, ""));
            }
            catch (Exception e) {
                Object[] name = new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.ArApRecPayDataImportResource", (String)"PaymentBill", (Locale)ctx.getLocale())};
                throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
            }
        }
        this.verifyHead(ctx, (CoreBaseInfo)head);
        if (!head.getBizDate().before(this.startPeriod.getBeginDate())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"125_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        this.isInitBill = true;
        head.setIsInitializeBill(true);
        if (head.getBizDate().before(this.currentPeriod.getBeginDate())) {
            this.isFinish = true;
        }
        if (this.isInitBill && this.apIsStart) {
            throw new TaskExternalException(CasForArApUtil.getStrResource("Cannot_InitBill_Wrong"));
        }
        if (!this.isInitBill && this.isFinish) {
            throw new TaskExternalException(CasForArApUtil.getStrResource("Cannot_FinistBill_Wrong"));
        }
        return head;
    }

    private void parseHead(Hashtable hsData, Context ctx, PaymentBillInfo info) throws TaskExternalException {
        SettlementTypeInfo settleInfo;
        Object data = null;
        PaymentTypeInfo paymentTypeInfo = null;
        String paymentTypeId = null;
        IPaymentType ipaymentType = null;
        paymentTypeId = "2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5";
        try {
            ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        try {
            if (ipaymentType != null) {
                paymentTypeInfo = ipaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(paymentTypeId));
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        info.setPaymentType(paymentTypeInfo);
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"126_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setNumber(data.toString());
        } else if (!this.isImportDataByRule) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"36_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FBizDate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setBizDate(RecAndPayDataImportUtil.objToDate(ctx, data));
        }
        if ((data = this.getData(hsData, "FCurrencyID")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"127_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setCurrency(this.importCache.getCurrencyInfoByCache(ctx, hsData, "FCurrencyID"));
        } else {
            CompanyOrgUnitInfo company = info.getCompany();
            try {
                info.setCurrency(company.getBaseCurrency());
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FExchangeRate");
        if (data != null && data.toString().trim().length() > 0) {
            BigDecimal exchangeRate = TypeConversionUtils.objToBigDecimal((Object)data);
            if (exchangeRate.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"128_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
        } else {
            info.setExchangeRate(CasConstants.ONE);
        }
        data = this.getData(hsData, "FAdminOrgUnit");
        if (data != null && data.toString().trim().length() > 0) {
            this.importCache.getAdminOrgUnitInfoByCache(ctx, hsData, "FAdminOrgUnit");
        }
        if ((data = this.getData(hsData, "FPerson")) != null && data.toString().trim().length() > 0) {
            this.importCache.getPersonInfoByCache(ctx, hsData, "FPerson");
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"131_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeTypeID")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"132_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setPayeeType(this.importCache.getAsstActTypeInfoByCache(ctx, hsData, "FPayeeTypeID"));
        }
        if ((data = this.getData(hsData, "FPayeeNumber")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"133_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            IRowSet asstActInfo = RecAndPayDataImportUtil.getAsstActInfo(info.getPayeeType(), data.toString(), ctx);
            try {
                if (asstActInfo.next()) {
                    info.setPayeeID(asstActInfo.getString("fid"));
                    info.setPayeeNumber(asstActInfo.getString("fnumber"));
                    info.setPayeeName(asstActInfo.getString("fname"));
                }
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        if ((data = this.getData(hsData, "FPayerAccountBankID")) != null && data.toString().trim().length() > 0) {
            info.setPayerAccountBank(this.importCache.getAccountBankByCache(ctx, hsData, info.getCompany().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FPayerAccountBankID"));
            info.setPayerBank(info.getPayerAccountBank().getBank());
        }
        if ((data = this.getData(hsData, "FPayerAccountID")) != null && data.toString().trim().length() > 0) {
            info.setPayerAccount(this.importCache.getRecPayAccountViewInfoByCache(ctx, hsData, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"18_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FPayerAccountID"));
        }
        if ((data = this.getData(hsData, "FSettlementTypeID")) != null && data.toString().trim().length() > 0 && (settleInfo = this.importCache.getSettlementTypeInfoByCache(ctx, hsData, "FSettlementTypeID")) != null) {
            info.setSettlementType(settleInfo);
        }
        data = this.getData(hsData, "FPayType");
        PaymentBillTypeInfo payTypeInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            String key = data.toString();
            if (this.importCache.getPayTypeCache().get(key) != null) {
                payTypeInfo = (PaymentBillTypeInfo)this.importCache.getPayTypeCache().get(key);
            } else {
                payTypeInfo = RecAndPayDataImportUtil.getPayTypeByNumber(data.toString(), ctx);
                this.importCache.getPayTypeCache().put(key, payTypeInfo);
            }
            PaymentBillTypeInfo presetBillType = payTypeInfo;
            PaymentBillTypeInfo paymentBillTypeInfo = presetBillType = payTypeInfo.getPreSetBillType() == null ? presetBillType : payTypeInfo.getPreSetBillType();
            if (presetBillType != null && CasForArApUtil.isTypeOfDigit(presetBillType.getNumber()).booleanValue() && !this.arapServerHelper.checkIsDefaultInitBillType(Integer.valueOf(presetBillType.getNumber()))) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"134_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (null == payTypeInfo) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"182_PaymentBillImportVerify", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"31_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        info.setPayBillType(payTypeInfo);
        data = this.getData(hsData, "FSettlementNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setSettlementNumber(data.toString());
        }
        if ("".equals(data = this.getData(hsData, "FOppAccountID"))) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"135_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        if (data != null && data.toString().trim().length() > 0) {
            info.setOppAccount(this.importCache.getRecPayAccountViewInfoByCache(ctx, hsData, info.getCompany().getId().toString(), info.getCurrency().getId().toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), "FOppAccountID"));
        }
        info.setIsInitializeBill(true);
        info.setIsImport(true);
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setSourceType(SourceTypeEnum.AP);
        info.setSourceSysType(SourceTypeEnum.AP);
    }

    private boolean isExistHead(Hashtable hsData, Context ctx, CompanyOrgUnitInfo company) throws TaskExternalException {
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        fi.getFilterItems().add(new FilterItemInfo("company.number", (Object)company.getNumber()));
        view.setFilter(fi);
        try {
            PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
            if (coll != null && coll.size() > 0) {
                throw new TaskExternalException(number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"22_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
            return false;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"136_InitPaymentBillDataImport", (Locale)ctx.getLocale()) + e.getMessage());
        }
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            PaymentBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        BigDecimal amount;
        PaymentBillEntryInfo info = new PaymentBillEntryInfo();
        info.setPaymentBill(RecAndPayDataImportUtil.getPaymentBillByNumber(hsData, ctx));
        Object data = this.getData(hsData, "Famount");
        if (data != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"137_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setAmount(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FLocalAount")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"138_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setLocalAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "Frebate")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"139_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setRebate(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FRebateLocAmt")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"140_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setRebateLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FActualAmt")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"141_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setActualAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FActualLocAmt")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"142_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setActualLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"143_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FAmountVc")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"144_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setAmountVc(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FLocalAmtVc")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"145_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setLocalAmtVc(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        info.setCoreBillType(this.importCache.getBillTypeByCache(ctx, hsData, "FCoreBillType"));
        info.setCoreBillNumber(CasForArApUtil.getDataString(hsData, "FCoreBillNum"));
        info.setCoreBillEntrySeq(CasForArApUtil.getDataInt(hsData, "FCoreBillSeq"));
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IObjectPK pk = this.getController(ctx).save(coreBaseInfo);
            if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
                coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void verifyHead(Context ctx, CoreBaseInfo head) throws TaskExternalException {
        if (!(head instanceof PaymentBillInfo)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"25_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        PaymentBillInfo info = (PaymentBillInfo)head;
        this.checkEmpty(ctx, info.getCompany(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance", (Locale)ctx.getLocale()));
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.checkEmpty(ctx, info.getCurrency(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"27_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        CurrencyInfo currency = info.getCurrency();
        this.checkEmpty(ctx, info.getExchangeRate(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"28_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        if (info.getExchangeRate().compareTo(Constants.ZERO) < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"29_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo localCurrency = companyInfo.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId()) && info.getExchangeRate().compareTo(Constants.ONE) != 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"30_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        this.checkEmpty(ctx, info.getPayeeType(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"38_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        this.checkEmpty(ctx, info.getPayeeNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"147_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
    }

    private void checkEmpty(Context ctx, Object obj, String msg) throws TaskExternalException {
        if (obj == null) {
            throw new TaskExternalException(msg + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"31_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private BizTypeEnum getFundType(Context ctx, Hashtable hs, String fieldName) throws TaskExternalException {
        Object data = this.getData(hs, fieldName);
        this.checkEmpty(ctx, data, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"148_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
        Integer inte = new Integer(data.toString());
        int value = inte;
        switch (value) {
            case 101: {
                return BizTypeEnum.BANK;
            }
            case 100: {
                return BizTypeEnum.CASH;
            }
            case 102: {
                return BizTypeEnum.OTHER;
            }
        }
        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"149_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
    }

    private AccountViewInfo getAccountViewInfo(Context ctx, Hashtable hs, String fieldName) throws TaskExternalException {
        Object data = this.getData(hs, fieldName);
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        String number = data.toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        AccountViewCollection avc = null;
        try {
            avc = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"150_InitPaymentBillDataImport", (Locale)ctx.getLocale()), (Throwable)e);
        }
        if (avc != null && avc.size() > 0) {
            return avc.get(0);
        }
        return null;
    }

    private AccountBankInfo getAccountBankInfo(Context ctx, Hashtable hs, String fieldName) throws TaskExternalException {
        Object data = this.getData(hs, fieldName);
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        String number = data.toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("bank.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("account.id"));
        AccountBankCollection avc = null;
        try {
            avc = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"150_InitPaymentBillDataImport", (Locale)ctx.getLocale()), (Throwable)e);
        }
        if (avc != null && avc.size() > 0) {
            return avc.get(0);
        }
        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"151_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
    }
}

