/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil;
import com.kingdee.eas.fi.cas.app.ReceivingBillImportVerify;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitReceivingBillDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)InitReceivingBillDataImport.class.getName());
    private ReceivingBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private String curKey = "";
    private static final int MAX_Number = 80;
    private static final BigDecimal AMT_MAX_VALUE = new BigDecimal("9999999999999");
    private PeriodInfo startPeriod = null;
    private PeriodInfo currentPeriod = null;
    private boolean isInitBill = false;
    private boolean arIsStart = true;
    private boolean isFinish = false;
    private boolean isImportDataByRule = false;
    ArApRecPayServerHelper arapServerHelper = new ArApRecPayServerHelper();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ReceivingBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    public ReceivingBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new ReceivingBillImportVerify();
        }
        return this.verify;
    }

    public void setVerify(ReceivingBillImportVerify verify) {
        this.verify = verify;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        BigDecimal temp;
        ReceivingBillEntryInfo entry = null;
        ReceivingBillInfo head = null;
        boolean isUpdateImport = false;
        String number = (String)this.getData(hsData, "FNumber");
        this.isImportDataByRule = RecPayHelper.getImportParam(ctx);
        hsData.put("IsImportDataByRule", this.isImportDataByRule);
        String companyNumber = (String)this.getData(hsData, "FCompanyID");
        CompanyOrgUnitInfo curCompany = RecAndPayDataImportUtil.getCompanyByNumber(ctx, companyNumber);
        this.checkOrgPermission(ctx, curCompany);
        try {
            this.startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)curCompany);
            this.arIsStart = SystemStatusCtrolUtils.isStart((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)curCompany);
            this.currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (CompanyOrgUnitInfo)curCompany);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            throw new TaskExternalException("Get System Context Error!");
        }
        this.curKey = curCompany.getNumber() + number;
        if (this.infoMap.containsKey(this.curKey)) {
            isUpdateImport = true;
        }
        if (!this.isImportDataByRule && !this.isExistHead(hsData, ctx, curCompany) || head == null) {
            if (!this.infoMap.containsKey(this.curKey)) {
                head = new ReceivingBillInfo();
                head.setCompany(curCompany);
                this.parseHead(hsData, ctx, head);
                this.infoMap.put(this.curKey, head);
            } else {
                head = (ReceivingBillInfo)this.infoMap.get(this.curKey);
            }
        }
        entry = (ReceivingBillEntryInfo)this.parseEntry(hsData, ctx);
        this.getVerify().verifyEntry(ctx, (CoreBaseInfo)entry, head.getSourceType());
        this.getVerify().verifyEntryAmt(ctx, entry, head);
        head.getEntries().add(entry);
        BigDecimal bigDecimal = temp = head != null ? head.getActRecAmt() : CasConstants.ZERO;
        if (temp == null) {
            temp = CasConstants.ZERO;
        }
        if (entry != null) {
            temp = temp.add(entry.getActualAmt());
        }
        head.setActRecAmt(temp);
        temp = head.getActRecLocAmt();
        if (temp == null) {
            temp = CasConstants.ZERO;
        }
        if (entry != null) {
            temp = temp.add(entry.getActualLocAmt());
        }
        head.setActRecLocAmt(temp);
        if (this.isImportDataByRule && !isUpdateImport) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                String cid = curCompany.getId().toString();
                if (!iCodingRuleManager.isExist((IObjectValue)head, cid)) {
                    Object[] name = new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.ArApRecPayDataImportResource", (String)"ReceivingBill", (Locale)ctx.getLocale())};
                    throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
                }
                head.setNumber(iCodingRuleManager.getNumber((IObjectValue)head, cid, ""));
            }
            catch (Exception e) {
                Object[] name = new String[]{ResourceBase.getString((String)"com.kingdee.eas.fi.cas.ArApRecPayDataImportResource", (String)"ReceivingBill", (Locale)ctx.getLocale())};
                throw new TaskExternalException(MessageFormat.format(CasForArApUtil.getStrResource("CodingRule_Error"), name));
            }
        }
        this.verifyHead(ctx, (CoreBaseInfo)head);
        if (!head.getBizDate().before(this.startPeriod.getBeginDate())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"125_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        this.isInitBill = true;
        head.setIsInitializeBill(true);
        if (head.getBizDate().before(this.currentPeriod.getBeginDate())) {
            this.isFinish = true;
        }
        if (this.isInitBill && this.arIsStart) {
            throw new TaskExternalException(CasForArApUtil.getStrResource("Cannot_InitBill_Wrong"));
        }
        if (!this.isInitBill && this.isFinish) {
            throw new TaskExternalException(CasForArApUtil.getStrResource("Cannot_FinistBill_Wrong"));
        }
        return head;
    }

    private void parseHead(Hashtable hsData, Context ctx, ReceivingBillInfo info) throws TaskExternalException {
        AdminOrgUnitCollection collection;
        FilterInfo filter;
        EntityViewInfo viewInfo;
        SettlementTypeInfo settleInfo;
        Object data = null;
        PaymentTypeInfo paymentTypeInfo = null;
        String paymentTypeId = null;
        IPaymentType ipaymentType = null;
        boolean isImportDataByRule = false;
        paymentTypeId = "91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5";
        if (hsData.get("IsImportDataByRule") != null) {
            isImportDataByRule = (Boolean)hsData.get("IsImportDataByRule");
        }
        try {
            ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        try {
            if (ipaymentType != null) {
                paymentTypeInfo = ipaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(paymentTypeId));
            }
        }
        catch (EASBizException e1) {
            logger.error((Object)e1);
        }
        catch (BOSException e1) {
            logger.error((Object)e1);
        }
        info.setPaymentType(paymentTypeInfo);
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"126_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setNumber(data.toString());
        } else if (!isImportDataByRule) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"36_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"127_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setCurrency(RecAndPayDataImportUtil.getCurrencyByNumber(ctx, data.toString()));
        } else {
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            try {
                info.setCurrency(company.getBaseCurrency());
            }
            catch (Exception e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FSettlementTypeID");
        if (data != null && data.toString().trim().length() > 0 && (settleInfo = RecAndPayDataImportUtil.getSettlementTypeByNumber(data.toString(), ctx)) != null) {
            info.setSettlementType(settleInfo);
        }
        data = this.getData(hsData, "FRecType");
        ReceivingBillTypeInfo recTypeInfo = null;
        if (data != null && data.toString().trim().length() > 0) {
            ReceivingBillTypeInfo presetBillType = recTypeInfo = RecAndPayDataImportUtil.getRecTypeByNumber(data.toString(), ctx);
            ReceivingBillTypeInfo receivingBillTypeInfo = presetBillType = recTypeInfo.getPreSetBillType() == null ? presetBillType : recTypeInfo.getPreSetBillType();
            if (presetBillType != null && CasForArApUtil.isTypeOfDigit(presetBillType.getNumber()).booleanValue() && !this.arapServerHelper.checkIsDefaultInitBillType(Integer.valueOf(presetBillType.getNumber()))) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"152_InitReceivingBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (null == recTypeInfo) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"212_ReceivingBillImportVerify", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"31_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        info.setRecBillType(recTypeInfo);
        data = this.getData(hsData, "FPayeeAccountBankID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayeeAccountBank(RecAndPayDataImportUtil.getAccountBankByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"47_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), data.toString()));
            info.setPayeeBank(info.getPayeeAccountBank().getBank());
        }
        if ((data = this.getData(hsData, "FPayeeAccountID")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAccount(RecAndPayDataImportUtil.getAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"48_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString()));
        }
        if ("".equals(data = this.getData(hsData, "FIsRedBill"))) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"153_InitReceivingBillDataImport", (Locale)ctx.getLocale()));
        }
        if (data != null && data.toString().trim().length() > 0) {
            info.setIsRedBill(CasForArApUtil.getDataboolean(hsData, "FIsRedBill"));
        }
        if ((data = this.getData(hsData, "FSettlementNumber")) != null && data.toString().trim().length() > 0) {
            info.setSettlementNumber(data.toString());
        }
        if ("".equals(data = this.getData(hsData, "FOppAccountID"))) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"135_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
        }
        if (data != null && data.toString().trim().length() > 0) {
            info.setOppAccount(RecAndPayDataImportUtil.getAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString()));
        }
        info.setBizDate(CasForArApUtil.getDataDate(ctx, hsData, "FBizDate"));
        data = this.getData(hsData, "FExchangeRate");
        if (data != null && data.toString().trim().length() > 0) {
            BigDecimal exchangeRate = TypeConversionUtils.objToBigDecimal((Object)data);
            if (exchangeRate.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"128_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setExchangeRate(exchangeRate);
        } else {
            info.setExchangeRate(CasConstants.ONE);
        }
        data = this.getData(hsData, "FAdminOrgUnit");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"129_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            try {
                IAdminOrgUnit iadminOrg = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString(), CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iadminOrg.getAdminOrgUnitCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    AdminOrgUnitInfo adminOrgInfo = collection.get(0);
                    if (info != null) {
                        info.setAdminOrgUnit(adminOrgInfo);
                    }
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"39_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FPerson")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"130_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            try {
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                viewInfo = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString(), CompareType.EQUALS));
                filter.setMaskString("#0");
                viewInfo.setFilter(filter);
                collection = iPerson.getPersonCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    PersonInfo personInfo = collection.get(0);
                    if (info != null) {
                        info.setPerson(personInfo);
                    }
                }
            }
            catch (BOSException e) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"40_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"131_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FPayerTypeID")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"132_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setPayerType(RecAndPayDataImportUtil.getAsstActTypeByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"38_ArApPaymentBillDataImport", (Locale)ctx.getLocale()), data.toString()));
        }
        if ((data = this.getData(hsData, "FPayerNumber")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"133_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            IRowSet asstActInfo = RecAndPayDataImportUtil.getAsstActInfo(info.getPayerType(), data.toString(), ctx);
            try {
                if (asstActInfo.next()) {
                    info.setPayerID(asstActInfo.getString("fid"));
                    info.setPayerNumber(asstActInfo.getString("fnumber"));
                    info.setPayerName(asstActInfo.getString("fname"));
                }
            }
            catch (SQLException e) {
                throw new TaskExternalException(e.getMessage());
            }
        }
        info.setIsInitializeBill(true);
        info.setIsImport(true);
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setSourceType(SourceTypeEnum.AR);
        info.setSourceSysType(SourceTypeEnum.AR);
        info.setIsRelateReceipt(false);
    }

    private boolean isExistHead(Hashtable hsData, Context ctx, CompanyOrgUnitInfo company) throws TaskExternalException {
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        fi.getFilterItems().add(new FilterItemInfo("company.number", (Object)company.getNumber()));
        view.setFilter(fi);
        try {
            ReceivingBillCollection coll = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillCollection(view);
            if (coll != null && coll.size() > 0) {
                throw new TaskExternalException(number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"22_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
            return false;
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"154_InitReceivingBillDataImport", (Locale)ctx.getLocale()) + e.getMessage());
        }
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IObjectPK pk = ReceivingBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
            coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        BigDecimal amount;
        ReceivingBillEntryInfo info = new ReceivingBillEntryInfo();
        info.setReceivingBill(RecAndPayDataImportUtil.getReceivingBillByNumber(hsData, ctx));
        Object data = this.getData(hsData, "Famount");
        if (data != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"155_InitReceivingBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setAmount(amount);
        }
        if ((data = this.getData(hsData, "FLocalAount")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"156_InitReceivingBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setLocalAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "Frebate")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"139_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setRebate(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FRebateLocAmt")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"140_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setRebateLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FActualAmt")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"141_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setActualAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FActualLocAmt")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"142_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setActualLocAmt(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FRemark")) != null && data.toString().trim().length() > 0) {
            if (data.toString().trim().length() > 80) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"143_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FAmountVc")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"144_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setAmountVc(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        if ((data = this.getData(hsData, "FLocalAmtVc")) != null && data.toString().trim().length() > 0) {
            amount = RecAndPayDataImportUtil.objToBigDecimal(ctx, data);
            if (amount.compareTo(AMT_MAX_VALUE) > 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"145_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            info.setLocalAmtVc(RecAndPayDataImportUtil.objToBigDecimal(ctx, data));
        }
        info.setCoreBillType(CasForArApUtil.getBillType(ctx, hsData, "FCoreBillType"));
        info.setCoreBillNumber(CasForArApUtil.getDataString(hsData, "FCoreBillNum"));
        info.setCoreBillEntrySeq(CasForArApUtil.getDataInt(hsData, "FCoreBillSeq"));
        return info;
    }

    private Object getData(Hashtable hsData, String fieldName) {
        Object data = null;
        if (hsData.get(fieldName) != null) {
            data = ((DataToken)hsData.get((Object)fieldName)).data;
        }
        return data;
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        try {
            IObjectPK pk = this.getController(ctx).save(coreBaseInfo);
            if (coreBaseInfo != null && coreBaseInfo.getId() != null) {
                coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    private void verifyHead(Context ctx, CoreBaseInfo head) throws TaskExternalException {
        if (!(head instanceof ReceivingBillInfo)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"25_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        ReceivingBillInfo info = (ReceivingBillInfo)head;
        this.checkEmpty(ctx, info.getCompany(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance", (Locale)ctx.getLocale()));
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        this.checkEmpty(ctx, info.getCurrency(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"27_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        CurrencyInfo currency = info.getCurrency();
        this.checkEmpty(ctx, info.getExchangeRate(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"28_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        if (info.getExchangeRate().compareTo(SysConstant.BIGZERO) < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"29_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo localCurrency = companyInfo.getBaseCurrency();
        if (currency.getId().equals((Object)localCurrency.getId()) && info.getExchangeRate().compareTo(Constants.ONE) != 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"30_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        this.checkEmpty(ctx, info.getPayerType(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"38_ArApPaymentBillDataImport", (Locale)ctx.getLocale()));
        this.checkEmpty(ctx, info.getPayerNumber(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"147_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
    }

    private void checkEmpty(Context ctx, Object obj, String msg) throws TaskExternalException {
        if (obj == null) {
            throw new TaskExternalException(msg + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"31_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private BizTypeEnum getFundType(Context ctx, Hashtable hs, String fieldName) throws TaskExternalException {
        Object data = this.getData(hs, fieldName);
        this.checkEmpty(ctx, data, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"148_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
        int value = new Integer(data.toString());
        switch (value) {
            case 101: {
                return BizTypeEnum.BANK;
            }
            case 100: {
                return BizTypeEnum.CASH;
            }
            case 102: {
                return BizTypeEnum.OTHER;
            }
        }
        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"149_InitPaymentBillDataImport", (Locale)ctx.getLocale()));
    }

    private AccountViewInfo getAccountViewInfo(Context ctx, Hashtable hs, String fieldName) throws TaskExternalException {
        Object data = this.getData(hs, fieldName);
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        String number = data.toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        AccountViewCollection avc = null;
        try {
            avc = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"150_InitPaymentBillDataImport", (Locale)ctx.getLocale()), (Throwable)e);
        }
        if (avc != null && avc.size() > 0) {
            return avc.get(0);
        }
        return null;
    }

    private AccountBankInfo getAccountBankInfo(Context ctx, Hashtable hs, String fieldName) throws TaskExternalException {
        Object data = this.getData(hs, fieldName);
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        String number = data.toString();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number.trim()));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("bank.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("account.id"));
        AccountBankCollection avc = null;
        try {
            avc = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(viewInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"150_InitPaymentBillDataImport", (Locale)ctx.getLocale()), (Throwable)e);
        }
        if (avc != null && avc.size() > 0) {
            return avc.get(0);
        }
        throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"158_InitReceivingBillDataImport", (Locale)ctx.getLocale()));
    }

    private void checkOrgPermission(Context ctx, CompanyOrgUnitInfo curCompany) throws TaskExternalException {
        OrgType orgType = OrgType.Company;
        try {
            IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            ObjectUuidPK cuId = new ObjectUuidPK(curCompany.getCU().getId().toString());
            FullOrgUnitCollection orgCol = permission.getAuthorizedOrgOfCU((IObjectPK)cuId, ctx.getCaller(), OrgType.Company, (IObjectPK)treePK, "fi_ar_InitReceivingbill_import");
            boolean isHasPerm = false;
            for (int i = 0; i < orgCol.size(); ++i) {
                FullOrgUnitInfo orgInfo = orgCol.get(i);
                if (!orgInfo.getId().toString().equals(curCompany.getId().toString())) continue;
                isHasPerm = true;
            }
            if (!isHasPerm) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.ArApRecPayDataImportResource", (String)"MULTIORGIMPORT", (Locale)ctx.getLocale(), (Object[])new Object[]{curCompany.getNumber()}));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }
}

