/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankGroupFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesCollection;
import com.kingdee.eas.basedata.assistant.AcctBankGroupEntriesInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastCollection;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountRefContrastInfo;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.app.AbstractInnerCashFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.BOTMappingHelperForCas;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InnerCashFacadeControllerBean
extends AbstractInnerCashFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.InnerCashFacadeControllerBean");

    @Override
    protected Map _getDailyBankStatementBalanceMap(Context ctx, String companyID, String currencyID, String bankAcctID, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException {
        FMQuerySqlBuilder builder = new FMQuerySqlBuilder();
        builder.appendSql("select FCreateDate,sum(FCreditAmount-FDebitAmount) amount ");
        builder.appendSql(" from t_cas_Bankstatement");
        builder.appendSql(" where FCompanyId =");
        builder.appendParam((Object)companyID);
        builder.appendSql(" and FCurrencyId =");
        builder.appendParam((Object)currencyID);
        builder.appendSql(" and FAccountBankId=");
        builder.appendParam((Object)bankAcctID);
        builder.appendSql(" and FCreateDate>=");
        builder.appendParam((Object)DateHelper.getSQLBegin((java.util.Date)beginDate));
        builder.appendSql(" and FCreateDate<=");
        builder.appendParam((Object)DateHelper.getSQLBegin((java.util.Date)endDate));
        builder.appendSql(" group by FCreateDate");
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = builder.createState(con);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Date date = rs.getDate("FCreateDate");
                BigDecimal amount = rs.getBigDecimal("amount");
                result.put(date, amount);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sql: " + builder.getTestSql()));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }

    @Override
    protected BigDecimal _getAcctGroupInstantBalance(Context ctx, IObjectPK compnayPK, IObjectPK acctBankGroupPK, IObjectPK currencyPK) throws BOSException, EASBizException {
        if (currencyPK == null || acctBankGroupPK == null) {
            return FMConstants.ZERO;
        }
        BigDecimal totalBal = FMConstants.ZERO;
        BigDecimal bal = FMConstants.ZERO;
        AccountBankGroupInfo acctBankGroup = (AccountBankGroupInfo)AccountBankGroupFactory.getLocalInstance((Context)ctx).getBillBaseInfo(acctBankGroupPK);
        AcctBankGroupEntriesCollection entries = acctBankGroup.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            AcctBankGroupEntriesInfo entry = entries.get(i);
            AccountBankInfo acctBank = entry.getAcctBank();
            bal = this._getInstantBalance(ctx, compnayPK, null, (IObjectPK)new ObjectUuidPK(acctBank.getId()), currencyPK);
            totalBal = totalBal.add(bal);
        }
        return totalBal;
    }

    @Override
    protected BigDecimal _getInstantBalance(Context ctx, IObjectPK company, IObjectPK acctViewPK, IObjectPK acctBankPK, IObjectPK currencyPK) throws BOSException, EASBizException {
        if (company == null) {
            company = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId());
        }
        if (currencyPK == null) {
            return FMConstants.ZERO;
        }
        if (acctViewPK == null && acctBankPK == null) {
            return FMConstants.ZERO;
        }
        BigDecimal totalBalance = FMConstants.ZERO;
        BigDecimal balance = FMConstants.ZERO;
        BigDecimal totalAmt = FMConstants.ZERO;
        ICashManagement iCash = null;
        iCash = ctx == null ? CashManagementFactory.getRemoteInstance() : CashManagementFactory.getLocalInstance(ctx);
        if (acctBankPK != null) {
            balance = iCash.getBankData(company.toString(), acctBankPK.toString(), currencyPK.toString(), new java.util.Date(), new java.util.Date(), CashDataTypeEnum.Y, true);
            totalAmt = iCash.getTotalAmtByAccount(company.toString(), acctBankPK.toString(), currencyPK.toString());
            totalBalance = balance.add(totalAmt);
        } else if (acctViewPK != null) {
            balance = iCash.getCashData(company.toString(), acctViewPK.toString(), currencyPK.toString(), new java.util.Date(), new java.util.Date(), CashDataTypeEnum.Y, true);
            totalAmt = iCash.getTotalAmtByAccountView(company.toString(), acctViewPK.toString(), currencyPK.toString());
            totalBalance = balance.add(totalAmt);
        }
        return totalBalance;
    }

    @Override
    protected String _getActualAcctTableID(Context ctx, String companyID, java.util.Date beginDate, java.util.Date endDate) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        if (FMHelper.isEmpty((String)companyID)) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        } else {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        }
        String cuId = company.getCU().getId().toString();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("cu.id", (Object)cuId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)beginDate, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.endDate", (Object)endDate, CompareType.LESS));
        evi.setFilter(filter);
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getLocalInstance((Context)ctx);
        AccountRefContrastCollection coll = acctContrast.getAccountRefContrastCollection(evi);
        if (coll == null || coll.isEmpty()) {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)beginDate, (CompanyOrgUnitInfo)company);
            int yearNumber = period.getPeriodYear();
            int monthNumber = period.getPeriodNumber();
            AccountTableInfo tbl = company.getAccountTable();
            if (EmptyUtil.isEmpty((CoreBaseInfo)tbl)) {
                CompanyOrgUnitInfo companyinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
                ICompanyOrgUnit companyOrgUnit = null;
                companyOrgUnit = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
                companyinfo = companyOrgUnit.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyinfo.getId().toString()));
                tbl = companyinfo.getAccountTable();
            }
            String currTableId = AccountTools.getCurrentAcctTable((Context)ctx, (String)cuId, (String)tbl.getId().toString(), (int)yearNumber, (int)monthNumber);
            return currTableId;
        }
        return null;
    }

    @Override
    protected String _getActualAcctTableIDEx(Context ctx, String companyID, java.util.Date beginDate, java.util.Date endDate, boolean isAdjustPeriod) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        if (FMHelper.isEmpty((String)companyID)) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        } else {
            ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            company = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
        }
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)beginDate, (boolean)isAdjustPeriod, (CompanyOrgUnitInfo)company);
        String currTableId = company.getAccountTable().getId().toString();
        AccountRefContrastInfo refInfo = AccountRefContrastFactory.getLocalInstance((Context)ctx).getLastAcctInfo(company.getId().toString(), currTableId, period.getId().toString());
        if (refInfo == null) {
            return currTableId;
        }
        if (isAdjustPeriod) {
            return refInfo.getDisabledAcctTable().getId().toString();
        }
        if (beginDate.before(refInfo.getEnabledPeriod().getBeginDate())) {
            return refInfo.getDisabledAcctTable().getId().toString();
        }
        if (endDate.after(refInfo.getEnabledPeriod().getBeginDate())) {
            return refInfo.getEnabledAcctTable().getId().toString();
        }
        return null;
    }

    @Override
    protected String _getActualAcctTableID(Context ctx, String companyID, int startPeriodYear, int startPeriodMonth, int endPeriodYear, int endPeriodMonth) throws BOSException, EASBizException {
        if (FMHelper.isEmpty((String)companyID)) {
            companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        }
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)startPeriodYear, (int)startPeriodMonth, (IObjectPK)new ObjectUuidPK(companyID));
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)endPeriodYear, (int)endPeriodMonth, (IObjectPK)new ObjectUuidPK(companyID));
        return this._getActualAcctTableID(ctx, companyID, beginPeriod.getBeginDate(), endPeriod.getEndDate());
    }

    @Override
    protected String _addBotRelationBatch(Context ctx, IObjectCollection botRelationCollection) throws BOSException, EASBizException {
        if (botRelationCollection == null) {
            return null;
        }
        IBOTRelation iBotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        for (BOTRelationInfo botRel : botRelationCollection) {
            RecPayBillInfo billInfo = null;
            BOTMappingInfo bmpi = null;
            if ("FA44FD5B".equals(botRel.getSrcEntityID().toString())) {
                billInfo = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(botRel.getSrcObjectID()));
            } else if ("40284E81".equals(botRel.getSrcEntityID().toString())) {
                billInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(botRel.getSrcObjectID()));
            }
            bmpi = "40284E81".equals(botRel.getSrcEntityID().toString()) || "FA44FD5B".equals(botRel.getSrcEntityID().toString()) ? BOTMappingHelperForCas.getMapping(ctx, (IObjectValue)billInfo, new VoucherInfo().getBOSType().toString()) : BOTMappingHelper.getMapping((Context)ctx, (IObjectValue)billInfo, (String)new VoucherInfo().getBOSType().toString());
            iBotRelation.removeRelationBySrcObjId(botRel.getSrcObjectID(), botRel.getDestEntityID());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)bmpi)) {
                botRel.setBOTMappingID(bmpi.getId().toString());
            }
            iBotRelation.addnew(botRel);
        }
        return null;
    }

    @Override
    protected BigDecimal _getInstantBalance(Context ctx, IObjectPK company, IObjectPK acctViewPK, IObjectPK acctBankPK, IObjectPK currencyPK, java.util.Date bizDate) throws BOSException, EASBizException {
        if (company == null) {
            company = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId());
        }
        if (currencyPK == null) {
            return FMConstants.ZERO;
        }
        if (acctViewPK == null && acctBankPK == null) {
            return FMConstants.ZERO;
        }
        BigDecimal totalBalance = FMConstants.ZERO;
        BigDecimal balance = FMConstants.ZERO;
        BigDecimal totalAmt = FMConstants.ZERO;
        ICashManagement iCash = null;
        iCash = ctx == null ? CashManagementFactory.getRemoteInstance() : CashManagementFactory.getLocalInstance(ctx);
        if (acctBankPK != null) {
            balance = iCash.getBankData(company.toString(), acctBankPK.toString(), currencyPK.toString(), new java.util.Date(), bizDate, CashDataTypeEnum.Y, true);
            totalAmt = iCash.getTotalAmtByAccount(company.toString(), acctBankPK.toString(), currencyPK.toString(), bizDate);
            totalBalance = balance.add(totalAmt);
        } else if (acctViewPK != null) {
            balance = iCash.getCashData(company.toString(), acctViewPK.toString(), currencyPK.toString(), new java.util.Date(), bizDate, CashDataTypeEnum.Y, true);
            totalAmt = iCash.getTotalAmtByAccountView(company.toString(), acctViewPK.toString(), currencyPK.toString(), bizDate);
            totalBalance = balance.add(totalAmt);
        }
        return totalBalance;
    }

    @Override
    protected Map _getDailyJournalBalanceMap(Context ctx, String companyID, String currencyID, String bankAcctID, java.util.Date beginDate, java.util.Date endDate) throws BOSException {
        FMQuerySqlBuilder builder = new FMQuerySqlBuilder();
        builder.appendSql("select FCreateDate,sum(FDebitAmount-FCreditAmount) amount ");
        builder.appendSql(" from t_cas_Journal");
        builder.appendSql(" where FCompanyId =");
        builder.appendParam((Object)companyID);
        builder.appendSql(" and FCurrencyId =");
        builder.appendParam((Object)currencyID);
        builder.appendSql(" and FAccountBankId=");
        builder.appendParam((Object)bankAcctID);
        builder.appendSql(" and FCreateDate>=");
        builder.appendParam((Object)DateHelper.getSQLBegin((java.util.Date)beginDate));
        builder.appendSql(" and FCreateDate<=");
        builder.appendParam((Object)DateHelper.getSQLBegin((java.util.Date)endDate));
        builder.appendSql(" group by FCreateDate");
        HashMap<Date, BigDecimal> result = new HashMap<Date, BigDecimal>();
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = this.getConnection(ctx);
            pstmt = builder.createState(con);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Date date = rs.getDate("FCreateDate");
                BigDecimal amount = rs.getBigDecimal("amount");
                result.put(date, amount);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)("sql: " + builder.getTestSql()));
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return result;
    }
}

