/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountCurrencyCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.framework.SystemEnum;
import java.util.Date;
import java.util.HashMap;

public class JournalAddBatchDelegate {
    private Context ctx = null;
    private HashMap current_period_Map = new HashMap();
    private HashMap start_period_Map = new HashMap();
    private HashMap acctViewMap = new HashMap();

    public JournalAddBatchDelegate(Context ctx) {
        this.ctx = ctx;
    }

    public void verifyJournalForAdd(JournalInfo journal) throws BOSException, EASBizException {
        AccountViewInfo accountView;
        String periodKey = this.getPeriodKey(SystemEnum.CASHMANAGEMENT, journal.getCompany());
        PeriodInfo currPeriodInfo = null;
        if (this.current_period_Map.get(periodKey) != null) {
            currPeriodInfo = (PeriodInfo)this.current_period_Map.get(periodKey);
        } else {
            currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)journal.getCompany());
            this.current_period_Map.put(periodKey, currPeriodInfo);
        }
        if (journal.getBillType() != null && journal.getBillType().getValue() == 0) {
            journal.setNull("billType");
        }
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(FMConstants.ZERO);
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(FMConstants.ZERO);
        }
        if (journal.getDebitAmount().signum() != 0) {
            journal.setIsDebit(true);
        } else {
            journal.setIsDebit(false);
        }
        if (journal.getPeriod() == null) {
            PeriodInfo startPeriod = null;
            if (this.start_period_Map.get(periodKey) != null) {
                startPeriod = (PeriodInfo)this.start_period_Map.get(periodKey);
            } else {
                startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)this.ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)journal.getCompany());
                this.start_period_Map.put(periodKey, currPeriodInfo);
            }
            if (!journal.getCreateDate().before(startPeriod.getBeginDate())) {
                throw new BOSException("unreached journal's createDate must before startedperiod's beginDate");
            }
        } else {
            PeriodInfo period = PeriodUtils.getPeriodInfo((Context)this.ctx, (Date)journal.getCreateDate(), (CompanyOrgUnitInfo)journal.getCompany());
            if (period == null || period.getId() == null) {
                throw new BOSException("period is not exist");
            }
            if (!period.getId().equals((Object)journal.getPeriod().getId())) {
                journal.setPeriod(period);
            }
            if (!this.PeriodCompare(period, currPeriodInfo)) {
                throw new CasException(CasException.BEFORECURRENTPERIOD);
            }
        }
        if ((accountView = journal.getAccountView()) == null) {
            throw new CasException(CasException.ACCT_NULL);
        }
        if (this.acctViewMap.get(accountView.getId()) == null) {
            accountView = AccountViewFactory.getLocalInstance((Context)this.ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId()), JournalAddBatchDelegate.getAcctViewSic());
            this.acctViewMap.put(accountView.getId(), accountView);
        } else {
            accountView = (AccountViewInfo)this.acctViewMap.get(accountView.getId());
        }
        if (!accountView.isIsBank() && !accountView.isIsCash()) {
            throw new CasException(CasException.ACCT_NOTCASBANK, new Object[]{accountView.getNumber()});
        }
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)journal, (String)"bizDate");
        boolean val = true;
        if (val && journal.getBizDate().after(journal.getCreateDate())) {
            journal.setBizDate(journal.getCreateDate());
        }
        if (journal.getType().equals((Object)JournalTypeEnum.BANK)) {
            if (journal.getAccountBank() == null) {
                throw new CasException(CasException.BANKACCT_NULL);
            }
            String acctBankId = journal.getAccountBank().getId().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("isClosed"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("account.isCFreeze"));
            sic.add(new SelectorItemInfo("company.id"));
            AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)this.ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)acctBankId)), sic);
            if (acctBank.isIsClosed()) {
                throw new CasException(CasException.ACCTBANKCLOSE);
            }
            if (acctBank.getAccount() == null) {
                throw new CasException(CasException.ACCT_NOTIDTIWITHBANK);
            }
            if (acctBank.getAccount().isIsCFreeze()) {
                throw new RecPayException(RecPayException.ACCT_IS_FREEZE);
            }
            if (!acctBank.getAccount().getId().equals((Object)accountView.getId())) {
                throw new CasException(CasException.ACCT_NOTIDTIWITHBANK);
            }
            if (!acctBank.getCompany().getId().equals((Object)journal.getCompany().getId())) {
                throw new CasException(CasException.COMPANY_NOTIDTIWITHBANK);
            }
        }
        this.verifyAccountCurrency(this.ctx, accountView.getId().toString(), journal.getCurrency().getId().toString(), journal.getCompany());
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)journal, (String)"company");
        FMVerifyHelper.checkBlank((Context)this.ctx, (IObjectValue)journal, (String)"verifyStatus");
        journal.setHasEffected(true);
    }

    public boolean PeriodCompare(PeriodInfo sourceperiodInfo, PeriodInfo targetperiodInfo) throws EASBizException, BOSException {
        if (sourceperiodInfo.getId().toString().equals(targetperiodInfo.getId().toString())) {
            return true;
        }
        if (sourceperiodInfo.getPeriodYear() == 0 || sourceperiodInfo.getPeriodNumber() == 0) {
            sourceperiodInfo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(sourceperiodInfo.getId()));
        }
        if (targetperiodInfo.getPeriodYear() == 0 || targetperiodInfo.getPeriodNumber() == 0) {
            targetperiodInfo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(targetperiodInfo.getId()));
        }
        if (sourceperiodInfo.getPeriodYear() > targetperiodInfo.getPeriodYear()) {
            return true;
        }
        if (sourceperiodInfo.getPeriodYear() == targetperiodInfo.getPeriodYear()) {
            return sourceperiodInfo.getPeriodNumber() >= targetperiodInfo.getPeriodNumber();
        }
        return false;
    }

    private String getPeriodKey(SystemEnum cashmanagement, CompanyOrgUnitInfo company) {
        return cashmanagement.getValue() + "_" + company.getId().toString();
    }

    public void verifyAccountCurrency(Context ctx, String accountid, String currencyId, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        SelectorItemCollection sic = JournalAddBatchDelegate.getAcctViewSic();
        AccountViewInfo account = null;
        CurrencyInfo localCurrency = null;
        boolean isLocalCurrency = false;
        if (ctx == null) {
            if (company == null) {
                company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            }
            localCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company);
            account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)accountid)), sic);
        } else {
            if (company == null) {
                company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            }
            localCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(company);
            if (this.acctViewMap.get(new ObjectUuidPK(BOSUuid.read((String)accountid))) == null) {
                account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountid), JournalAddBatchDelegate.getAcctViewSic());
                this.acctViewMap.put(new ObjectUuidPK(BOSUuid.read((String)accountid)), account);
            } else {
                account = (AccountViewInfo)this.acctViewMap.get(new ObjectUuidPK(BOSUuid.read((String)accountid)));
            }
        }
        if (localCurrency == null || localCurrency.getId() == null) {
            return;
        }
        if (localCurrency.getId().toString().equals(currencyId)) {
            isLocalCurrency = true;
        }
        switch (account.getAccountingcurrency().getValue()) {
            case 2: {
                return;
            }
            case 0: {
                if (isLocalCurrency) break;
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
            case 1: {
                AccountCurrencyCollection acctCurColl = account.getAccountCurrency();
                for (int j = 0; j < acctCurColl.size(); ++j) {
                    if (!acctCurColl.get(j).getCurrency().getId().toString().equals(currencyId)) continue;
                    return;
                }
                throw new FMException(FMException.NOACCOUNTCURRENCY);
            }
        }
    }

    private static SelectorItemCollection getAcctViewSic() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("accountingcurrency"));
        sic.add(new SelectorItemInfo("accountCurrency.id"));
        sic.add(new SelectorItemInfo("accountCurrency.currency"));
        sic.add(new SelectorItemInfo("accountCurrency.currency.id"));
        return sic;
    }
}

