/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalBackupFactory;
import com.kingdee.eas.fi.cas.JournalBackupInfo;
import com.kingdee.eas.fi.cas.JournalBaseCollection;
import com.kingdee.eas.fi.cas.JournalBaseInfo;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.app.AbstractJournalBackupControllerBean;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class JournalBackupControllerBean
extends AbstractJournalBackupControllerBean {
    private static final String JOURNAL_ID = "journalId";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.JournalBackupControllerBean");
    private static final String UPDATE_JOURNALFLOWITEM_FJOURNALID = "UPDATE T_CAS_JournalFlowItems SET FParentID = '%s',FJournalId='%s' WHERE FParentID = '%s';\n";
    private static final String UPDATE_JOURNALFLOWITEM_PARENT = "UPDATE T_CAS_JournalFlowItems SET FParentID = '%s' WHERE FParentID = '%s' And FJournalId='%s';\n";

    @Override
    protected IObjectCollection _getCollectionByBatchNo(Context ctx, Set batchNoSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("batchNo", (Object)batchNoSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return JournalBackupFactory.getLocalInstance(ctx).getJournalBackupCollection(view);
    }

    private JournalCollection getJournalColls(Context ctx, Set idSet, SelectorItemCollection selectors, SorterItemCollection sorters) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        if (selectors != null) {
            view.setSelector(selectors);
        }
        if (sorters != null) {
            view.setSorter(sorters);
        }
        return JournalFactory.getLocalInstance(ctx).getJournalCollection(view);
    }

    private void copyJournalInfo(JournalBaseInfo srcInfo, JournalBaseInfo destInfo) {
        destInfo.setSettlementType(srcInfo.getSettlementType());
        destInfo.setBillType(srcInfo.getBillType());
        destInfo.setDescription(srcInfo.getDescription());
        destInfo.setSource(srcInfo.getSource());
        destInfo.setCashier(srcInfo.getCashier());
        destInfo.setCurrency(srcInfo.getCurrency());
        destInfo.setAccountBank(srcInfo.getAccountBank());
        destInfo.setIsDebit(srcInfo.isIsDebit());
        destInfo.setPeriod(srcInfo.getPeriod());
        destInfo.setVerifyStatus(srcInfo.getVerifyStatus());
        destInfo.setType(srcInfo.getType());
        destInfo.setBatchNo(srcInfo.getBatchNo());
        destInfo.setCompany(srcInfo.getCompany());
        destInfo.setCreateDate(srcInfo.getCreateDate());
        destInfo.setBizDate(srcInfo.getBizDate());
        destInfo.setAccountView(srcInfo.getAccountView());
        destInfo.setBillId(srcInfo.getBillId());
        destInfo.setSourceBillId(srcInfo.getSourceBillId());
        destInfo.setCU(srcInfo.getCU());
        destInfo.setHasEffected(srcInfo.isHasEffected());
        destInfo.setSummary(srcInfo.getSummary());
    }

    private String castSubstring(StringBuffer stringBuffer, int maxLength) {
        if (stringBuffer.length() > 0) {
            stringBuffer.delete(0, 1);
        }
        if (stringBuffer.length() > maxLength) {
            return stringBuffer.substring(1, maxLength);
        }
        return stringBuffer.toString();
    }

    private void batchAddByJournalCollection(Context ctx, JournalBaseCollection journalColls) throws BOSException, EASBizException {
        if (journalColls == null || journalColls.isEmpty()) {
            return;
        }
        CoreBaseCollection journalBacks = new CoreBaseCollection();
        int size = journalColls.size();
        for (int i = 0; i < size; ++i) {
            JournalInfo info = (JournalInfo)journalColls.getObject(i);
            JournalBackupInfo model = new JournalBackupInfo();
            Enumeration keys = info.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                model.put(key, info.get(key));
            }
            journalBacks.add((CoreBaseInfo)model);
        }
        this.addnewBatchData(ctx, journalBacks);
    }

    private void addMergeJournal(JournalBaseCollection journals, CoreBaseCollection mergeJournals, JournalBaseCollection backupJournals) {
        JournalInfo mergeJournalInfo = new JournalInfo();
        BigDecimal debitAmountSum = new BigDecimal(0);
        BigDecimal creditAmountSum = new BigDecimal(0);
        HashSet<BOSUuid> voucherTypeIdSet = new HashSet<BOSUuid>();
        StringBuffer billNumbers = new StringBuffer();
        StringBuffer voucherNumbers = new StringBuffer();
        int length = journals.size();
        for (int i = 0; i < length; ++i) {
            String billNumber;
            String voucherNumber;
            JournalBaseInfo info = journals.get(i);
            debitAmountSum = debitAmountSum.add(info.getDebitAmount());
            creditAmountSum = creditAmountSum.add(info.getCreditAmount());
            if (i == 0) {
                this.copyJournalInfo(info, (JournalBaseInfo)mergeJournalInfo);
                mergeJournalInfo.setId(BOSUuid.create((BOSObjectType)mergeJournalInfo.getBOSType()));
            }
            if (info.getVoucherType() != null) {
                voucherTypeIdSet.add(info.getVoucherType().getId());
            }
            if ((voucherNumber = info.getVoucherNumber()) != null && voucherNumbers.indexOf(voucherNumber) == -1) {
                voucherNumbers.append(",").append(voucherNumber);
            }
            if ((billNumber = info.getBillNumber()) != null && billNumbers.indexOf(billNumber) == -1) {
                if (info.getBillType().equals((Object)BillTypeEnum.settleBatch)) {
                    billNumbers.append(",");
                } else {
                    billNumbers.append(";");
                }
                billNumbers.append(billNumber);
            }
            info.put(JOURNAL_ID, mergeJournalInfo.getId().toString());
        }
        if (voucherTypeIdSet.size() == 1) {
            VoucherTypeInfo voucherTypeInfo = new VoucherTypeInfo();
            voucherTypeInfo.setId((BOSUuid)voucherTypeIdSet.iterator().next());
            mergeJournalInfo.setVoucherType(voucherTypeInfo);
        }
        if (voucherNumbers.length() > 0) {
            mergeJournalInfo.setVoucherNumber(this.castSubstring(voucherNumbers, 80));
        }
        if (billNumbers.length() > 0) {
            mergeJournalInfo.setBillNumber(this.castSubstring(billNumbers, 250));
        }
        if (debitAmountSum.compareTo(BigDecimal.ZERO) != 0) {
            mergeJournalInfo.setDebitAmount(debitAmountSum);
        } else {
            mergeJournalInfo.setCreditAmount(creditAmountSum);
        }
        mergeJournals.add((CoreBaseInfo)mergeJournalInfo);
        backupJournals.addCollection(journals);
    }

    private void updateJournalFlowItem(Context ctx, JournalBaseCollection backupJournals, boolean isMerge) throws BOSException, EASBizException {
        String sql = null;
        int size = backupJournals.size();
        for (int i = 0; i < size; ++i) {
            JournalBaseInfo info = backupJournals.get(i);
            String id = info.getId().toString();
            String journalId = info.getString(JOURNAL_ID);
            sql = isMerge ? String.format(UPDATE_JOURNALFLOWITEM_FJOURNALID, journalId, id, id) : String.format(UPDATE_JOURNALFLOWITEM_PARENT, id, journalId, id);
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }

    @Override
    protected List _mergeJournalByBatchNo(Context ctx, Set journalIdSet) throws BOSException, EASBizException {
        SorterItemCollection sorters = new SorterItemCollection();
        sorters.add(new SorterItemInfo("batchNo"));
        sorters.add(new SorterItemInfo("billType"));
        SorterItemInfo sorterItem = new SorterItemInfo("createDate");
        sorterItem.setSortType(SortType.DESCEND);
        sorters.add(sorterItem);
        JournalCollection collection = this.getJournalColls(ctx, journalIdSet, null, sorters);
        HashMap<String, JournalBaseCollection> journalMap = new HashMap<String, JournalBaseCollection>();
        JournalBaseCollection journals = new JournalBaseCollection();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            JournalInfo info = collection.get(i);
            String batchNo = info.getBatchNo();
            if (EmptyUtil.isEmpty((String)batchNo)) continue;
            String key = batchNo + info.getBillType().getName();
            if (!journalMap.containsKey(key)) {
                journals = new JournalBaseCollection();
                journalMap.put(key, journals);
            } else {
                journals = (JournalBaseCollection)((Object)journalMap.get(key));
            }
            journals.add((JournalBaseInfo)info);
        }
        if (!journalMap.isEmpty()) {
            CoreBaseCollection mergeJournals = new CoreBaseCollection();
            JournalBaseCollection backupJournals = new JournalBaseCollection();
            Iterator iterator = journalMap.keySet().iterator();
            while (iterator.hasNext()) {
                journals = (JournalBaseCollection)((Object)journalMap.get(iterator.next()));
                if (journals.size() <= 1) continue;
                this.addMergeJournal(journals, mergeJournals, backupJournals);
            }
            if (mergeJournals.size() > 0) {
                IJournal iJournal = JournalFactory.getLocalInstance(ctx);
                iJournal.addnewBatchData(mergeJournals);
                this.updateJournalFlowItem(ctx, backupJournals, true);
                FilterInfo filter = new FilterInfo();
                HashSet<String> deleteIdSet = new HashSet<String>();
                int length = backupJournals.size();
                for (int i = 0; i < length; ++i) {
                    deleteIdSet.add(backupJournals.get(i).getId().toString());
                }
                filter.getFilterItems().add(new FilterItemInfo("id", deleteIdSet, CompareType.INCLUDE));
                iJournal.delete(filter);
                this.batchAddByJournalCollection(ctx, backupJournals);
            }
        }
        return null;
    }

    @Override
    protected List _splitJournalByBatchNo(Context ctx, Set journalIdSet) throws BOSException, EASBizException {
        if (journalIdSet == null || journalIdSet.isEmpty()) {
            return null;
        }
        CoreBaseCollection journalColls = new CoreBaseCollection();
        HashSet<String> journalBillIdSet = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(JOURNAL_ID, (Object)journalIdSet, CompareType.INCLUDE));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        JournalBaseCollection backupColls = this.getJournalBaseCollection(ctx, view);
        int length = backupColls.size();
        for (int j = 0; j < length; ++j) {
            JournalBackupInfo backupInfo = (JournalBackupInfo)backupColls.get(j);
            JournalInfo journalInfo = new JournalInfo();
            Enumeration keys = backupInfo.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement().toString();
                journalInfo.put(key, backupInfo.get(key));
            }
            journalInfo.setId(backupInfo.getId());
            journalColls.add((CoreBaseInfo)journalInfo);
            journalBillIdSet.add(backupInfo.getJournalId().toString());
        }
        if (journalColls.size() > 0) {
            IJournal iJournal = JournalFactory.getLocalInstance(ctx);
            iJournal.addnewBatchData(journalColls);
            this.updateJournalFlowItem(ctx, backupColls, false);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", journalBillIdSet, CompareType.INCLUDE));
            iJournal.delete(filter);
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(JOURNAL_ID, journalBillIdSet, CompareType.INCLUDE));
            this.delete(ctx, filter);
        }
        return null;
    }
}

