/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.AbstractJournalBalanceAnalyseFacadeControllerBean;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.fm.common.util.DWETLUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class JournalBalanceAnalyseFacadeControllerBean
extends AbstractJournalBalanceAnalyseFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.JournalBalanceAnalyseFacadeControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _getFact(Context ctx) throws BOSException {
        String tblTemp = null;
        String tbl = null;
        try {
            int[] years = this.getYears(ctx);
            int[] months = this.getMonths(ctx);
            tbl = this.getTableTableNameKsql(ctx, "JOURNALBALANCE");
            tblTemp = this.getTableTableNameKsql(ctx, "JOURNALBALANCETEMP");
            String[] currencys = this.getCurrencys(ctx);
            List periodList = this.cutPeriod(ctx, years, months);
            for (int i = 0; i < periodList.size(); ++i) {
                int[] period = (int[])periodList.get(i);
                for (int j = 0; j < currencys.length; ++j) {
                    this.insertFact(ctx, period, currencys[j], tblTemp);
                }
                this.getPeriodRecord(ctx, period, tbl, tblTemp);
                this.truncateTable(ctx, tblTemp);
            }
            this.executeEndSql(ctx, tbl);
        }
        catch (EASBizException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (BOSException e2) {
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.dropTableKsql(ctx, tblTemp);
                this.dropTableKsql(ctx, tbl);
                throw throwable;
            }
        }
        this.dropTableKsql(ctx, tblTemp);
        this.dropTableKsql(ctx, tbl);
    }

    private void executeEndSql(Context ctx, String tbl) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append(" TRUNCATE TABLE ").append("DW_FACT_JOURNALBALANCE");
        DbUtil.execute((Context)ctx, (String)sb.toString());
        StringBuffer sqlEnd = new StringBuffer();
        sqlEnd.append(" INSERT INTO DW_FACT_JOURNALBALANCE(");
        sqlEnd.append("                         FCOMPANYID,");
        sqlEnd.append("                         FPERIODID,");
        sqlEnd.append("                         FCURRENCYID,");
        sqlEnd.append("                         FBANKID,");
        sqlEnd.append("                         FACCOUNTUSAGEID,");
        sqlEnd.append("                         FACCOUNTBANKID,");
        sqlEnd.append("                         FACCOUNTVIEWID,");
        sqlEnd.append("                         FBEGINYEARBANALCE,");
        sqlEnd.append("                         FBEGINMONTHHBALANCE,");
        sqlEnd.append("                         FDEBITAMT,");
        sqlEnd.append("                         FMONTHDEBIT,");
        sqlEnd.append("                         FMONTHCREDIT,");
        sqlEnd.append("                         FYEARDEBIT,");
        sqlEnd.append("                         FYEARCREDIT,");
        sqlEnd.append("                         FENDBMONTH)");
        sqlEnd.append("  SELECT ");
        sqlEnd.append("                 JB.FCOMPANYID,");
        sqlEnd.append("                         JB.FPERIODID,");
        sqlEnd.append("                         JB.FCURRENCYID,");
        sqlEnd.append("                         ACCBANK.FBANK,");
        sqlEnd.append("                         ACCBANK.FPROPERTYID,");
        sqlEnd.append("                         JB.FACCOUNTBANKID,");
        sqlEnd.append("                         JB.FACCOUNTVIEWID,");
        sqlEnd.append("                         JB.FYEARSTARTAMT,");
        sqlEnd.append("                         JB.FMONTHSTARTAMT,");
        sqlEnd.append("                         0,");
        sqlEnd.append("                         JB.FMONTHDEBITAMT,");
        sqlEnd.append("                         JB.FMONTHCREDITAMT,");
        sqlEnd.append("                         JB.FYEARDEBITAMT,");
        sqlEnd.append("                         JB.FYEARCREDITAMT,");
        sqlEnd.append("                         JB.FMONTHBALANCE");
        sqlEnd.append("         FROM ");
        sqlEnd.append(tbl);
        sqlEnd.append("          JB");
        sqlEnd.append("         LEFT OUTER JOIN T_BD_ACCOUNTBANKS ACCBANK ON JB.FACCOUNTBANKID = ACCBANK.FID");
        DbUtil.execute((Context)ctx, (String)sqlEnd.toString());
    }

    @Override
    protected void _getAccount(Context ctx) throws BOSException {
        DWETLUtil.getInstance().etl(ctx, "JournalBalanceAnalyse.xml", "DW_DIM_BD_ACCOUNTVIEW", this.getClass());
    }

    @Override
    protected void _getAccountproperty(Context ctx) throws BOSException {
        DWETLUtil.getInstance().etl(ctx, "JournalBalanceAnalyse.xml", "DW_DIM_BD_ACCOUNTPROPERTY", this.getClass());
    }

    @Override
    protected void _getAccountbanks(Context ctx) throws BOSException {
        DWETLUtil.getInstance().etl(ctx, "JournalBalanceAnalyse.xml", "DW_DIM_BD_ACCOUNTBANKS", this.getClass());
    }

    private void truncateTable(Context ctx, String tableName) throws BOSException {
        if (tableName != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(" TRUNCATE TABLE ");
            stringBuffer.append(tableName);
            DbUtil.execute((Context)ctx, (String)stringBuffer.toString());
        }
    }

    private void dropTableKsql(Context ctx, String tbl) throws BOSException {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        if (tbl != null) {
            pool.releaseTable(tbl);
        }
    }

    private List cutPeriod(Context ctx, int[] years, int[] months) throws BOSException {
        if (years == null || years.length == 0 || months == null || months.length == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"159_JournalBalanceAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        ArrayList<int[]> periodList = new ArrayList<int[]>();
        int[] begin = new int[]{years[0], months[0], years[0], 13};
        periodList.add(begin);
        int[] end = new int[]{years[years.length - 1], 1, years[years.length - 1], months[months.length - 1]};
        for (int i = 1; i < years.length - 1; ++i) {
            int[] meantime = new int[]{years[i], 1, years[i], 13};
            periodList.add(meantime);
        }
        periodList.add(end);
        return periodList;
    }

    private int[] getYears(Context ctx) throws BOSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT (A.FPERIODYEAR) FROM T_BD_PERIOD A ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)stringBuffer.toString());
        int[] years = new int[rowSet.size()];
        try {
            int i = 0;
            while (rowSet.next()) {
                years[i] = rowSet.getInt("fperiodyear");
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return years;
    }

    private int[] getMonths(Context ctx) throws BOSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT DISTINCT (A.FPERIODNUMBER)  ");
        stringBuffer.append("FROM T_BD_PERIOD A  ");
        stringBuffer.append("WHERE A.FNUMBER = (SELECT MIN(FNUMBER) FROM T_BD_PERIOD) ");
        stringBuffer.append("OR A.FNUMBER = (SELECT MAX(FNUMBER) FROM T_BD_PERIOD) ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)stringBuffer.toString());
        int[] months = new int[rowSet.size()];
        try {
            int i = 0;
            while (rowSet.next()) {
                months[i] = rowSet.getInt("fperiodnumber");
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return months;
    }

    private String[] getCurrencys(Context ctx) throws BOSException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  SELECT FID FROM T_BD_CURRENCY  ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)stringBuffer.toString());
        String[] currency = new String[rowSet.size()];
        try {
            int i = 0;
            while (rowSet.next()) {
                currency[i] = rowSet.getString("fid");
                ++i;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return currency;
    }

    private void getPeriodRecord(Context ctx, int[] yearsAndMonths, String tbl, String tblTemp) throws BOSException {
        int beginYear = yearsAndMonths[0];
        int beginMonth = yearsAndMonths[1];
        int endYear = yearsAndMonths[2];
        int endMonth = yearsAndMonths[3];
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(tbl);
        stringBuffer.append(" (FCOMPANYID,FKEY,FBANKID,FACCOUNTVIEWID,FCURRENCYID,FACCOUNTBANKID,FACCOUNTPROPERTYID,");
        stringBuffer.append("FPERIODID,FYEARSTARTAMT,FMONTHSTARTAMT,FMONTHDEBITAMT,FMONTHCREDITAMT,FYEARDEBITAMT,");
        stringBuffer.append("FYEARCREDITAMT,FMONTHBALANCE,FYEARBALANCE,FDEBITSTARTAMT,FCREDITSTARTAMT) ");
        stringBuffer.append("SELECT ");
        stringBuffer.append("JBTEMP.FCOMPANYID,JBTEMP.FKEY,JBTEMP.FBANKID,JBTEMP.FACCOUNTVIEWID,JBTEMP.FCURRENCYID,JBTEMP.FACCOUNTBANKID,JBTEMP.FACCOUNTPROPERTYID,");
        stringBuffer.append("JBTEMP.FPERIODID,JBTEMP.FYEARSTARTAMT,JBTEMP.FMONTHSTARTAMT,JBTEMP.FMONTHDEBITAMT,JBTEMP.FMONTHCREDITAMT,JBTEMP.FYEARDEBITAMT,");
        stringBuffer.append("JBTEMP.FYEARCREDITAMT,JBTEMP.FMONTHBALANCE,JBTEMP.FYEARBALANCE,JBTEMP.FDEBITSTARTAMT,JBTEMP.FCREDITSTARTAMT ");
        stringBuffer.append("FROM ");
        stringBuffer.append(tblTemp);
        stringBuffer.append(" JBTEMP ");
        stringBuffer.append("LEFT OUTER JOIN T_BD_PERIOD PERIOD ON PERIOD.FID = JBTEMP.FPERIODID ");
        stringBuffer.append("WHERE PERIOD.FNUMBER >= ");
        stringBuffer.append(beginYear * 100 + beginMonth).append(" ");
        stringBuffer.append("AND PERIOD.FNUMBER <= ");
        stringBuffer.append(endYear * 100 + endMonth);
        DbUtil.execute((Context)ctx, (String)stringBuffer.toString());
    }

    private void insertFact(Context ctx, int[] yearsAndMonths, String currencyId, String tbl) throws BOSException, EASBizException {
        int beginYear = yearsAndMonths[0];
        int beginMonth = yearsAndMonths[1];
        int endYear = yearsAndMonths[2];
        int endMonth = yearsAndMonths[3];
        StringBuffer sbState = new StringBuffer();
        sbState.append("SELECT ss.fcompanyid , sp.fid spfid,sp.FPERIODYEAR*100 + sp.FPERIODNUMBER startperiod,cp.fid cpfid, cp.FPERIODYEAR*100 + cp.FPERIODNUMBER curPeriod ");
        sbState.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sbState.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sbState.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sbState.append(" and ss.fisstart=1");
        sbState.append(" and ss.fcompanyid in (select fid from t_org_company)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbState.toString());
        HashMap<String, HashSet<String>> otherCompany = new HashMap<String, HashSet<String>>();
        HashSet<String> okCompany = new HashSet<String>();
        HashSet<String> allCompany = new HashSet<String>();
        try {
            while (rs.next()) {
                Set<String> csSet;
                String pkey;
                int beginKey = beginYear * 100 + beginMonth;
                if (beginKey >= rs.getInt("startperiod") && beginKey <= rs.getInt("curPeriod")) {
                    okCompany.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                }
                if (beginKey > rs.getInt("curPeriod")) {
                    pkey = rs.getString("cpfid");
                    csSet = (HashSet<String>)otherCompany.get(pkey);
                    if (csSet == null) {
                        csSet = new HashSet<String>();
                        otherCompany.put(pkey, (HashSet<String>)csSet);
                    }
                    csSet.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                }
                if (beginKey >= rs.getInt("startperiod")) continue;
                pkey = rs.getString("spfid");
                csSet = (Set)otherCompany.get(pkey);
                if (csSet == null) {
                    csSet = new HashSet();
                    otherCompany.put(pkey, (HashSet<String>)csSet);
                }
                csSet.add(rs.getString("fcompanyid"));
                allCompany.add(rs.getString("fcompanyid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String periodtypeId = curCompany.getAccountPeriodType().getId().toString();
        PeriodCollection periocColl = this.getPeriodColl(ctx, periodtypeId, beginYear, beginMonth, endYear, endMonth);
        this.genBalance(ctx, tbl, okCompany, new HashSet(), periocColl, currencyId);
        for (Map.Entry element : otherCompany.entrySet()) {
            String period = (String)element.getKey();
            Set otherCompanySet = (Set)element.getValue();
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period));
            PeriodCollection otherperiocColl = this.getPeriodColl(ctx, periodtypeId, periodInfo.getPeriodYear(), periodInfo.getPeriodNumber(), endYear, endMonth);
            if (otherperiocColl.size() == 0) continue;
            this.genBalance(ctx, tbl, otherCompanySet, new HashSet(), otherperiocColl, currencyId);
        }
    }

    private PeriodCollection getPeriodColl(Context ctx, String periodtypeId, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodtypeId);
        sb.append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("periodyear"));
        ev.getSorter().add(new SorterItemInfo("periodnumber"));
        PeriodCollection periocColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(ev);
        return periocColl;
    }

    private String getTableTableNameKsql(Context ctx, String tableName) throws BOSException {
        if (tableName == null || tableName.length() <= 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"160_JournalBalanceAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        String tempTableName = null;
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tableName);
        createTableSql.append("\t(");
        createTableSql.append("FCOMPANYID        varchar(44),");
        createTableSql.append("FKey        varchar(44),");
        createTableSql.append("FBANKID           varchar(44),");
        createTableSql.append("FACCOUNTVIEWID    varchar(44),");
        createTableSql.append("FCURRENCYID       varchar(44),");
        createTableSql.append("FACCOUNTBANKID    varchar(44),");
        createTableSql.append("FAccountPropertyID    varchar(44),");
        createTableSql.append("FPERIODID         varchar(44),");
        createTableSql.append("FYEARSTARTAMT      NUMERIC(19,4) ,");
        createTableSql.append("FMONTHSTARTAMT     NUMERIC(19,4),");
        createTableSql.append("FMONTHDEBITAMT     NUMERIC(19,4),");
        createTableSql.append("FMONTHCREDITAMT    NUMERIC(19,4) ,");
        createTableSql.append("FYEARDEBITAMT      NUMERIC(19,4),");
        createTableSql.append("FYEARCREDITAMT     NUMERIC(19,4),");
        createTableSql.append("FMONTHBALANCE      NUMERIC(19,4),");
        createTableSql.append("FYEARBALANCE       NUMERIC(19,4),");
        createTableSql.append("FDEBITSTARTAMT     NUMERIC(19,4),");
        createTableSql.append("FCREDITSTARTAMT    NUMERIC(19,4)");
        createTableSql.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tempTableName = pool.createTempTable(createTableSql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (tempTableName == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"161_JournalBalanceAnalyseFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return tempTableName;
    }

    private void genBalance(Context ctx, String tbl, Set companyIdSet, Set bankids, PeriodCollection periodIds, String currencyId) throws BOSException {
        if (companyIdSet.size() == 0) {
            return;
        }
        if (periodIds == null || periodIds.size() == 0) {
            return;
        }
        String beginPeriodId = periodIds.get(0).getId().toString();
        FMQuerySqlBuilder sbfirst = this.getFirstPeriod(companyIdSet, bankids, beginPeriodId, currencyId, tbl);
        sbfirst.execute(ctx);
        for (int i = 1; i < periodIds.size(); ++i) {
            FMQuerySqlBuilder sbnext = this.getNextPeriod(companyIdSet, bankids, periodIds.get(i - 1).getId().toString(), periodIds.get(i).getId().toString(), currencyId, tbl, periodIds.get(i).getPeriodNumber() == 1);
            sbnext.execute(ctx);
        }
    }

    private FMQuerySqlBuilder getFirstPeriod(Set companyIdSet, Set bankids, String beginPeriodId, String currencyId, String tbl) {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid, fperiodid,");
        sb.appendSql(" fyearstartamt,fmonthstartamt,");
        sb.appendSql(" fmonthdebitamt, fmonthcreditamt, fmonthbalance,");
        sb.appendSql(" fyeardebitamt, fyearcreditamt, fyearbalance,");
        sb.appendSql(" fdebitstartamt,fcreditstartamt");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid,s.fperiodid, ");
        sb.appendSql(" SUM (s.fyearstartamt), SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt),  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance,");
        sb.appendSql("  SUM (s.fyeardebitamt),  SUM (s.fyearcreditamt),   SUM (s.fyearstartamt) + SUM (s.fyeardebitamt)   - SUM (s.fyearcreditamt) fyearbalance,");
        sb.appendSql("  SUM (s.fdebitstartamt), SUM (s.fcreditstartamt)");
        sb.appendSql("     FROM (SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid, jb.fperiodid,");
        sb.appendSql("                   jb.fyearstartamt, jb.fmonthstartamt,");
        sb.appendSql("\t\t\t\t  0 fmonthdebitamt, 0 fmonthcreditamt,0 fmonthbalance,");
        sb.appendSql("     \t\t\t   jb.fyeardebitamt -jb.fmonthdebitamt  fyeardebitamt , jb.fyearcreditamt - jb.fmonthcreditamt fyearcreditamt,jb.fyearbalance,");
        sb.appendSql("      \t\t\t   jb.fdebitstartamt, jb.fcreditstartamt");
        sb.appendSql("              FROM t_cas_journalbalance jb");
        sb.appendSql("              WHERE ftype in(1,2) and fisinit=0");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR jb.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql("           UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid, j.fperiodid,");
        sb.appendSql("                  0 fyearstartamt, 0 fmonthstartamt,");
        sb.appendSql("                  SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance,");
        sb.appendSql("                  SUM (fdebitamount) fyeardebitamt, SUM (fcreditamount) fyearcreditamt, 0 fyearbalance,");
        sb.appendSql("                  0 fdebitstartamt, 0 fcreditstartamt");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql("             GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid, j.fperiodid");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, s.fperiodid");
        return sb;
    }

    private FMQuerySqlBuilder getNextPeriod(Set companyIdSet, Set bankids, String beginPeriodId, String nextPeriodId, String currencyId, String tbl, boolean isyear) {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid, fperiodid,");
        sb.appendSql(" fyearstartamt,fmonthstartamt,");
        sb.appendSql(" fmonthdebitamt, fmonthcreditamt,fmonthbalance,");
        sb.appendSql(" fyeardebitamt, fyearcreditamt, fyearbalance,");
        sb.appendSql(" fdebitstartamt,fcreditstartamt");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid,'" + nextPeriodId + "', ");
        sb.appendSql(" SUM (s.fyearstartamt), SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt),  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance,");
        sb.appendSql("  SUM (s.fyeardebitamt),  SUM (s.fyearcreditamt),   SUM (s.fyearstartamt) + SUM (s.fyeardebitamt)   - SUM (s.fyearcreditamt) fyearbalance,");
        sb.appendSql("  SUM (s.fdebitstartamt), SUM (s.fcreditstartamt)");
        sb.appendSql("     FROM (SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid, jb.fperiodid,");
        if (isyear) {
            sb.appendSql("                   jb.fmonthbalance fyearstartamt,jb.fmonthbalance  fmonthstartamt,");
            sb.appendSql("\t\t\t\t  0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthbalance,");
            sb.appendSql("     \t\t\t  0 fyeardebitamt, 0 fyearcreditamt,0 fyearbalance,");
        } else {
            sb.appendSql("                   jb.fyearstartamt fyearstartamt,jb.fmonthbalance  fmonthstartamt,");
            sb.appendSql("\t\t\t\t  0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthbalance,");
            sb.appendSql("     \t\t\t   jb.fyeardebitamt, jb.fyearcreditamt,jb.fyearbalance,");
        }
        sb.appendSql("      \t\t\t   jb.fdebitstartamt, jb.fcreditstartamt");
        sb.appendSql("              FROM " + tbl + " jb");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR jb.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql("           UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid, j.fperiodid,");
        sb.appendSql("                  0 fyearstartamt, 0 fmonthstartamt,");
        sb.appendSql("                  SUM (fdebitamount)  fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance,");
        sb.appendSql("                  SUM (fdebitamount)  fyeardebitamt,  SUM (fcreditamount) fyearcreditamt, 0 fyearbalance,");
        sb.appendSql("                  0 fdebitstartamt, 0 fcreditstartamt");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fperiodid", FMHelper.asSet((String)nextPeriodId), CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql("             GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid, j.fperiodid");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, s.fperiodid");
        return sb;
    }

    @Override
    protected void _getBankFact(Context ctx) throws BOSException {
    }
}

