/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.Journal4ChequeMnt;
import com.kingdee.eas.fi.cas.JournalBackupFactory;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalEAIVerify;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSummaryFactory;
import com.kingdee.eas.fi.cas.JournalSummaryInfo;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.JournalVerify;
import com.kingdee.eas.fi.cas.app.AbstractJournalControllerBean;
import com.kingdee.eas.fi.cas.app.JournalAddBatchDelegate;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.fm.common.IContextHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.RptException;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class JournalControllerBean
extends AbstractJournalControllerBean {
    private static Logger logger = Logger.getLogger((String)JournalControllerBean.class.getName());

    @Override
    protected void _addBatch(Context ctx, IObjectCollection journals) throws BOSException, EASBizException {
        if (journals == null || journals.isEmpty()) {
            return;
        }
        JournalAddBatchDelegate delegate = new JournalAddBatchDelegate(ctx);
        Journal4ChequeMnt chequeMnt = new Journal4ChequeMnt();
        IObjectPK pk = null;
        JournalInfo journal = null;
        IObjectValue info = null;
        IObjectPK[] pks = new IObjectPK[journals.size()];
        for (int i = 0; i < journals.size(); ++i) {
            journal = (JournalInfo)journals.getObject(i);
            journal.setLineNo(i);
            info = this.getInfo(journal.getBillId(), ctx);
            if (journal.getBillCreateTime() == null && info != null && info.get("createtime") != null) {
                journal.setBillCreateTime((Timestamp)info.get("createtime"));
            }
            delegate.verifyJournalForAdd(journal);
            pk = this.addnew(ctx, (IObjectValue)journal, false);
            journal.setId(BOSUuid.read((String)pk.toString()));
            pks[i] = pk;
        }
        chequeMnt.autoVCCheque(ctx, pks);
    }

    public static boolean getCS007(Context ctx, CompanyOrgUnitInfo curr) {
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        return localInstance.getBooleanParam("CS007", (IObjectPK)new ObjectUuidPK(curr.getId()));
    }

    protected IObjectPK addnew(Context ctx, IObjectValue model, boolean isNeedVerify) throws BOSException, EASBizException {
        JournalInfo journal = (JournalInfo)model;
        if (journal.getBillCreateTime() == null) {
            IObjectValue info = this.getInfo(journal.getBillId(), ctx);
            if (info != null && info.get("createtime") != null) {
                journal.setBillCreateTime((Timestamp)info.get("createtime"));
            } else {
                journal.setCreateTime(this.getTime());
                journal.setBillCreateTime(this.getTime());
            }
        }
        if (isNeedVerify) {
            JournalVerify.verifyJournalForAdd(ctx, journal);
        }
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(SysConstant.BIGZERO);
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(SysConstant.BIGZERO);
        }
        if (journal.getDebitAmount().compareTo(FMConstants.ZERO) != 0) {
            journal.setIsDebit(true);
        } else {
            journal.setIsDebit(false);
        }
        if (journal.getCreateDate() != null) {
            journal.setCreateDate(DateTimeUtils.truncateDate((Date)journal.getCreateDate()));
        }
        if (journal.getBizDate() != null) {
            journal.setBizDate(DateTimeUtils.truncateDate((Date)journal.getBizDate()));
        }
        IObjectPK objectPK = super._addnew(ctx, model);
        return objectPK;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        JournalInfo journal = (JournalInfo)model;
        if (journal.getBillCreateTime() == null) {
            IObjectValue info = this.getInfo(journal.getBillId(), ctx);
            if (info != null && info.get("createtime") != null) {
                journal.setBillCreateTime((Timestamp)info.get("createtime"));
            } else {
                journal.setCreateTime(this.getTime());
                journal.setBillCreateTime(this.getTime());
            }
        }
        JournalVerify.verifyJournalForAdd(ctx, journal);
        CurrencyInfo currency = journal.getCurrency();
        int precision = 2;
        if (currency != null) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
            precision = currency.getPrecision();
        }
        if (journal.getDebitAmount() == null) {
            journal.setDebitAmount(SysConstant.BIGZERO);
        } else {
            journal.setDebitAmount(journal.getDebitAmount().setScale(precision, 4));
        }
        if (journal.getCreditAmount() == null) {
            journal.setCreditAmount(SysConstant.BIGZERO);
        } else {
            journal.setCreditAmount(journal.getCreditAmount().setScale(precision, 4));
        }
        if (journal.getDebitAmount().compareTo(FMConstants.ZERO) != 0) {
            journal.setIsDebit(true);
        } else {
            journal.setIsDebit(false);
        }
        if (journal.getCreateDate() != null) {
            journal.setCreateDate(DateTimeUtils.truncateDate((Date)journal.getCreateDate()));
        }
        if (journal.getBizDate() != null) {
            journal.setBizDate(DateTimeUtils.truncateDate((Date)journal.getBizDate()));
        }
        IObjectPK objectPK = super._addnew(ctx, model);
        Journal4ChequeMnt chequeMnt = new Journal4ChequeMnt();
        chequeMnt.autoVCCheque(ctx, objectPK);
        return objectPK;
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        view.getSelector().add("id");
        view.getSelector().add("summary");
        view.getSelector().add("company.id");
        view.getSelector().add("createDate");
        view.getSelector().add("*");
        JournalCollection journals = this.getJournalCollection(ctx, view);
        IObjectPK[] objectPK = new IObjectPK[journals.size()];
        Journal4ChequeMnt chequeMnt = new Journal4ChequeMnt();
        for (int i = 0; i < journals.size(); ++i) {
            JournalInfo journal = journals.get(i);
            objectPK[i] = new ObjectUuidPK(journal.getId());
        }
        chequeMnt.autoCancelVCCheque(ctx, objectPK);
        JournalVerify.verifyJournalsForDelete(ctx, journals);
        IObjectPK[] rest = super._delete(ctx, filter);
        return rest;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        JournalInfo journal = (JournalInfo)this.getValue(ctx, pk);
        JournalCollection journals = new JournalCollection();
        Journal4ChequeMnt chequeMnt = new Journal4ChequeMnt();
        chequeMnt.autoCancelVCCheque(ctx, pk);
        journals.add(journal);
        JournalVerify.verifyJournalsForDelete(ctx, journals);
        super._delete(ctx, pk);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        JournalInfo journal = (JournalInfo)model;
        JournalVerify.verifyJournalForAdd(ctx, journal);
        if (!BillTypeEnum.paymentBill.equals((Object)journal.getBillType())) {
            Journal4ChequeMnt chequeMnt = new Journal4ChequeMnt();
            chequeMnt.autoVCCheque(ctx, (IObjectPK)new ObjectUuidPK(journal.getId()));
        }
        super._update(ctx, pk, model);
    }

    private String createJournalSummary(Context ctx, CompanyOrgUnitInfo company, AccountViewInfo accountView, AccountBankInfo accountBank, CurrencyInfo currency, Date createDate) throws BOSException, EASBizException {
        JournalSummaryInfo summary = new JournalSummaryInfo();
        summary.setCompany(company);
        summary.setAccountBank(accountBank);
        summary.setAccountView(accountView);
        summary.setCurrency(currency);
        summary.setCreateDate(createDate);
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (Date)createDate, (CompanyOrgUnitInfo)company);
        summary.setPeriod(period);
        summary.setDebitAmount(FMConstants.ZERO);
        summary.setCreditAmount(FMConstants.ZERO);
        summary.setDebitCount(0);
        summary.setCreditCount(0);
        if (accountBank == null) {
            summary.setType(JournalTypeEnum.CASH);
        } else {
            summary.setType(JournalTypeEnum.BANK);
        }
        JournalSummaryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)summary);
        return summary.getId().toString();
    }

    protected String getSummaryId(Context ctx, CompanyOrgUnitInfo company, AccountViewInfo accountView, AccountBankInfo accountBank, CurrencyInfo currency, Date createDate) throws EASBizException, BOSException {
        String companyId = company.getId().toString();
        String accountViewId = accountView.getId().toString();
        String accountBankId = null;
        if (accountBank != null) {
            accountBankId = accountBank.getId().toString();
        }
        String currencyId = currency.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("Select FID from T_CAS_JournalSummary where FCompanyId ='");
        sql.append(companyId);
        sql.append("' and FAccountViewId='");
        sql.append(accountViewId);
        sql.append("' and FCurrencyId= '");
        sql.append(currencyId);
        sql.append("' and FCreateDate ={");
        sql.append(TypeConversionUtils.objToDate((Object)createDate));
        sql.append("}");
        if (accountBankId != null) {
            sql.append(" and FAccountBankId = '");
            sql.append(accountBankId);
            sql.append("'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String summaryId = null;
        try {
            if (rs.next()) {
                summaryId = rs.getString("FID");
            }
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            BOSException e = new BOSException();
            e.setStackTrace(ex.getStackTrace());
            throw e;
        }
        if (summaryId == null) {
            summaryId = this.createJournalSummary(ctx, company, accountView, accountBank, currency, createDate);
        }
        return summaryId;
    }

    protected void updateSummary(Context ctx, String[] ids) throws BOSException {
        if (ids == null || ids.length == 0) {
            return;
        }
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stmtQuery = null;
        PreparedStatement stmtUpdate = null;
        PreparedStatement stmtDelete = null;
        HashSet<String> noValues = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            noValues.add(ids[i]);
        }
        try {
            StringBuffer querySql = new StringBuffer();
            querySql.append("Select FSummaryId,sum(FDebitAmount) DebitAmount,sum(FCreditAmount) CreditAmount ,sum(FIsDebit) DebitCount,count(FId)-sum(FIsDebit) CreditCount from T_Cas_Journal where FSummaryId in (");
            for (int i = 0; i < ids.length; ++i) {
                if (i == 0) {
                    querySql.append("'" + ids[i] + "'");
                    continue;
                }
                querySql.append(",'" + ids[i] + "'");
            }
            querySql.append(") group By FSummaryId");
            con = this.getConnection(ctx);
            stmtQuery = con.prepareStatement(querySql.toString());
            rs = stmtQuery.executeQuery();
            String updateSql = "Update T_Cas_JournalSummary set FDebitAmount=? , FCreditAmount=? , FDebitCount=? , FCreditCount=? where FId= ? ";
            stmtUpdate = con.prepareStatement(updateSql);
            while (rs.next()) {
                noValues.remove(rs.getString(1));
                stmtUpdate.setBigDecimal(1, rs.getBigDecimal(2));
                stmtUpdate.setBigDecimal(2, rs.getBigDecimal(3));
                stmtUpdate.setBigDecimal(3, rs.getBigDecimal(4));
                stmtUpdate.setBigDecimal(4, rs.getBigDecimal(5));
                DbUtil.prepareVarcharParam((PreparedStatement)stmtUpdate, (int)5, (String)rs.getString(1));
                stmtUpdate.addBatch();
            }
            stmtUpdate.executeBatch();
            if (noValues.size() != 0) {
                StringBuffer deleteSql = new StringBuffer();
                deleteSql.append("Delete from T_Cas_journalSummary where FId in (");
                String[] noValueIds = noValues.toArray(new String[0]);
                for (int i = 0; i < noValueIds.length; ++i) {
                    if (i == 0) {
                        deleteSql.append("'" + noValueIds[i] + "'");
                        continue;
                    }
                    deleteSql.append(",'" + noValueIds[i] + "'");
                }
                deleteSql.append(")");
                stmtDelete = con.prepareStatement(deleteSql.toString());
                stmtDelete.execute();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtDelete);
                SQLUtils.cleanup(stmtUpdate);
                SQLUtils.cleanup(rs, stmtQuery, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup(stmtDelete);
        SQLUtils.cleanup((Statement)stmtUpdate);
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmtQuery, (Connection)con);
    }

    @Override
    protected void _reCalculateSummary(Context ctx, String companyId, Date fromDate, Date toDate) throws BOSException, EASBizException {
        Connection con = null;
        IRowSet rs = null;
        Statement stmtQuery = null;
        PreparedStatement stmtInsert = null;
        Statement stmtDelete = null;
        StringBuffer querySql = new StringBuffer();
        StringBuffer deleteSql = new StringBuffer();
        StringBuffer insertSql = new StringBuffer();
        deleteSql.append("Delete from T_Cas_journalSummary where 1=1");
        querySql.append("Select FCompanyId,FAccountbankId,FAccountViewId,FCreateDate,FCurrencyId,FPeriodId,sum(FDebitAmount) DebitAmount,sum(FCreditAmount) CreditAmount ,sum(FIsDebit) DebitCount,count(FId)-sum(FIsDebit) CreditCount,FType from T_Cas_Journal  where 1=1");
        if (toDate != null) {
            deleteSql.append(" and FCreateDate<={" + TypeConversionUtils.objToDate((Object)DateTimeUtils.truncateDate((Date)toDate)) + "}");
            querySql.append(" and FCreateDate<={" + TypeConversionUtils.objToDate((Object)DateTimeUtils.truncateDate((Date)toDate)) + "}");
        }
        if (fromDate != null) {
            deleteSql.append(" and  FCreateDate>={" + TypeConversionUtils.objToDate((Object)DateTimeUtils.truncateDate((Date)fromDate)) + "}");
            querySql.append(" and  FCreateDate>={" + TypeConversionUtils.objToDate((Object)DateTimeUtils.truncateDate((Date)fromDate)) + "}");
        }
        if (companyId != null) {
            deleteSql.append(" and  FCompanyid='" + companyId + "'");
            querySql.append(" and  FCompanyid='" + companyId + "'");
        }
        querySql.append(" group by FCompanyId,FAccountbankId,FAccountViewId,FCreateDate,FCurrencyId,FPeriodId,FType");
        insertSql.append("Insert T_Cas_JournalSummary (FId,FCompanyId,FAccountBankId,FAccountViewId,FCreateDate,FCurrencyId,FPeriodId,FDebitAmount,FCreditAmount,FDebitCount,FCreditCount,FType) ");
        insertSql.append(" Values( dbo.newbosid('").append(new JournalSummaryInfo().getBOSType().toString()).append("'),?,?,?,?,?,?,?,?,?,?,?)");
        try {
            con = this.getConnection(ctx);
            DbUtil.execute((Context)ctx, (String)deleteSql.toString());
            rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
            stmtInsert = con.prepareStatement(insertSql.toString());
            while (rs.next()) {
                stmtInsert.setString(1, rs.getString("FCompanyId"));
                stmtInsert.setString(2, rs.getString("FAccountbankId"));
                stmtInsert.setString(3, rs.getString("FAccountViewId"));
                stmtInsert.setDate(4, TypeConversionUtils.objToDate((Object)rs.getDate("FCreateDate")));
                stmtInsert.setString(5, rs.getString("FCurrencyId"));
                stmtInsert.setString(6, rs.getString("FPeriodId"));
                stmtInsert.setBigDecimal(7, rs.getBigDecimal("DebitAmount"));
                stmtInsert.setBigDecimal(8, rs.getBigDecimal("CreditAmount"));
                stmtInsert.setBigDecimal(9, rs.getBigDecimal("DebitCount"));
                stmtInsert.setBigDecimal(10, rs.getBigDecimal("CreditCount"));
                stmtInsert.setBigDecimal(11, rs.getBigDecimal("FType"));
                stmtInsert.addBatch();
            }
            stmtInsert.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmtInsert);
                SQLUtils.cleanup(stmtDelete);
                SQLUtils.cleanup(rs, stmtQuery, (Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmtInsert);
        SQLUtils.cleanup(stmtDelete);
        SQLUtils.cleanup((ResultSet)rs, stmtQuery, (Connection)con);
    }

    @Override
    protected void _inputFromEAI(Context ctx, IObjectValue journal) throws BOSException, EASBizException {
        JournalInfo journalInfo = (JournalInfo)journal;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"source");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"currency");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"accountBank");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"createDate");
        JournalEAIVerify verify = JournalEAIVerify.getInstance(journalInfo.getSource());
        if (verify == null) {
            throw new BOSException("verify is empty");
        }
        verify.verifyImport(ctx, journalInfo);
        this._addnew(ctx, journal);
    }

    @Override
    protected void _importFromDS(Context ctx, IObjectValue journal) throws BOSException, EASBizException {
        JournalInfo journalInfo = (JournalInfo)journal;
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"source");
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"currency");
        if (journalInfo.getType() == JournalTypeEnum.BANK) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"accountBank");
        } else if (journalInfo.getType() == JournalTypeEnum.CASH) {
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"accountView");
        }
        FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"createDate");
        JournalEAIVerify verify = JournalEAIVerify.getInstance(journalInfo.getSource());
        if (verify == null) {
            throw new BOSException("verify is empty");
        }
        verify.verifyImport(ctx, journalInfo);
        this._addnew(ctx, journal);
    }

    private IObjectValue getBillInfo(String id, Context ctx) throws Exception {
        if (id == null || id.trim().length() == 0) {
            return null;
        }
        ObjectUuidPK pk = new ObjectUuidPK(id);
        BOSUuid bosId = BOSUuid.read((String)id);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("bill");
        sic.add("createTime");
        IObjectValue info = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(bosId.getType(), (IObjectPK)pk, sic);
        return info;
    }

    @Override
    protected void _inputFromEAI(Context ctx, String debitAmount, String creditAmount, String description, String createDate, String bizDate, String voucherNumber, String ticketNumber, String currency, String accountBank, String asstActTypeColl, String add1, String add2, String add3, String add4) throws BOSException, EASBizException {
    }

    private IObjectValue getInfo(String billId, Context ctx) {
        IObjectValue info = null;
        try {
            info = this.getBillInfo(billId, ctx);
            if (info instanceof VoucherEntryInfo) {
                VoucherInfo voucher = (VoucherInfo)info.get("bill");
                info = this.getBillInfo(voucher.getId().toString(), ctx);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return info;
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    @Override
    protected Map _getPeriodRange(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        ctx = this.changeContext(ctx);
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        Map map = null;
        map = this.getPeriodRangeNormal(ctx, 3, this.getStartPeriod(ctx, company), this.getCurrentPeriod(ctx, company), company);
        int maxYear = 0;
        int maxPeriod = 0;
        for (Object key : map.keySet()) {
            if (!(key instanceof Integer)) continue;
            int buf = (Integer)key;
            maxYear = maxYear < buf ? buf : maxYear;
        }
        int[] value = (int[])map.get(new Integer(maxYear));
        int n = value.length;
        for (int i = 0; i < n; ++i) {
            maxPeriod = maxPeriod < value[i] ? value[i] : maxPeriod;
        }
        HashMap<Integer, int[]> map2 = new HashMap<Integer, int[]>();
        map2.putAll(map);
        allMap.put("usedPeriod", map);
        allMap.put("queryPeriod", map2);
        allMap.put("currentPeriod", new int[]{maxYear, maxPeriod});
        String periodType = company.getAccountPeriodType().getId().toString();
        StringBuffer sb = new StringBuffer();
        sb.append("select A.c, A.FPeriodYear, B.FPeriodNumber from").append("\n (select count(1) c, FPeriodYear from t_bd_period where FTypeID=? and FPeriodYear*100+FPeriodNumber>? group by FPeriodYear) A").append("\n inner join t_bd_period B on B.FPeriodYear=A.FPeriodYear and B.FPeriodYear*100+B.FPeriodNumber>? and B.FTypeID=?").append("\n order by A.FPeriodYear, B.FPeriodNumber");
        RptRowSet rs = this.executeQuery(sb.toString(), new SqlParams().addString(periodType).addInt(maxYear * 100 + maxPeriod).addInt(maxYear * 100 + maxPeriod).addString(periodType), ctx);
        int i = 0;
        while (rs.next()) {
            int n2 = rs.getInt("c");
            if (n2 == 0) continue;
            int year = rs.getInt("FPeriodYear");
            int[] p = new int[n2];
            p[0] = rs.getInt("FPeriodNumber");
            i = 0;
            while (i++ < n2 - 1) {
                rs.next();
                p[i] = rs.getInt("FPeriodNumber");
            }
            Integer kk = new Integer(year);
            if (map2.containsKey(kk)) {
                int[] op = (int[])map2.get(kk);
                int[] np = new int[op.length + p.length];
                System.arraycopy(op, 0, np, 0, op.length);
                System.arraycopy(p, 0, np, op.length, p.length);
                p = np;
            }
            int max = 0;
            int min = Integer.MAX_VALUE;
            for (int m = 0; m < p.length; ++m) {
                max = max < p[m] ? p[m] : max;
                min = min > p[m] ? p[m] : min;
            }
            map2.put(kk, new int[]{min, max});
        }
        return allMap;
    }

    protected Context changeContext(Context old) {
        String uiName = null;
        if (uiName == null) {
            return old;
        }
        Context newCtx = null;
        try {
            newCtx = EASEjbFactory.getCtx(uiName, (Context)old);
        }
        catch (Exception e) {
            logger.error((Object)"EASEjbFactory.getCtx fail!", (Throwable)e);
            newCtx = old;
        }
        return newCtx;
    }

    protected Map getPeriodRangeNormal(Context ctx, int type, PeriodInfo startPeriod, PeriodInfo currentPeriod, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        HashMap<Integer, int[]> map = new HashMap<Integer, int[]>();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT TP.FPeriodYear, \r\n");
        sql.append("\tMin(TP.FPeriodNumber) MinNumber, \r\n");
        sql.append("\tMax(TP.FPeriodNumber) MaxNumber \r\n");
        sql.append("FROM T_BD_Period TP \r\n");
        sql.append("WHERE TP.FTypeID = ? \r\n");
        if ((type == 1 || type == 3) && startPeriod != null) {
            sql.append(" AND (TP.FPeriodYear>? or (TP.FPeriodYear=?  and TP.FPeriodNumber >= ?)) \r\n");
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            sql.append(" AND (TP.FPeriodYear<? or(TP.FPeriodYear=? and TP.FPeriodNumber <= ?)) \r\n");
        }
        sql.append("GROUP BY TP.FPeriodYear \r\n");
        sql.append("ORDER BY TP.FPeriodYear \r\n");
        SqlParams parameter = new SqlParams();
        parameter.addString(company.getAccountPeriodType().getId().toString());
        if ((type == 1 || type == 3) && startPeriod != null) {
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodYear());
            parameter.addInt(startPeriod.getPeriodNumber());
        }
        if ((type == 2 || type == 3) && currentPeriod != null) {
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodYear());
            parameter.addInt(currentPeriod.getPeriodNumber());
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection con = null;
        try {
            con = this.getConnection(ctx);
            stmt = con.prepareStatement(parameter.getSqlWithParams(sql.toString()));
            stmt.setFetchSize(100);
            rs = stmt.executeQuery();
            int[] yearRange = new int[]{-1, -1};
            while (rs.next()) {
                int year = rs.getInt("FPeriodYear");
                yearRange[0] = yearRange[0] == -1 ? year : yearRange[0];
                yearRange[1] = year;
                int[] periodRange = new int[]{rs.getInt("MinNumber"), rs.getInt("MaxNumber")};
                if (periodRange[0] <= 0 || periodRange[1] <= 0) {
                    throw new RptException(RptException.PERIOD_ERROR);
                }
                map.put(new Integer(year), periodRange);
            }
            if (yearRange[0] <= 0 || yearRange[1] <= 0 || yearRange[0] < startPeriod.getPeriodYear() || yearRange[1] > currentPeriod.getPeriodYear() || map.size() <= 0) {
                throw new RptException(RptException.PERIOD_ERROR);
            }
            HashMap<Integer, int[]> hashMap = map;
            this.close(con, stmt, rs);
            return hashMap;
        }
        catch (SQLException sqle) {
            try {
                sqle.setNextException(new SQLException("The query sql is:" + sql.toString()));
                throw new SQLDataException(sqle);
            }
            catch (Throwable throwable) {
                this.close(con, stmt, rs);
                throw throwable;
            }
        }
    }

    protected PeriodInfo getStartPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getStartPeriod((Context)this.changeContext(ctx), (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    protected PeriodInfo getCurrentPeriod(Context ctx, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        PeriodInfo pi = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.changeContext(ctx), (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        if (pi == null) {
            throw new RptException(RptException.PERIOD_ERROR);
        }
        return pi;
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, Context ctx) throws BOSException {
        return this.executeQuery(sql, parameters, 0, -1, this.changeContext(ctx));
    }

    protected RptRowSet executeQuery(String sql, SqlParams parameters, int from, int length, Context ctx) throws BOSException {
        Connection con = this.getConnection(ctx);
        try {
            RptRowSet rptRowSet = DBUtils.executeQuery((String)sql, (SqlParams)parameters, (int)from, (int)length, (Connection)con);
            return rptRowSet;
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("SQL: " + sql));
            throw new SQLDataException(e);
        }
        finally {
            this.close(con);
        }
    }

    protected void close(Connection con) {
        this.close(con, null, null);
    }

    protected void close(Connection con, Statement statement, ResultSet rs) {
        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)con);
    }

    @Override
    protected void _registerVoucher(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    @Override
    protected List _mergeByBatchNo(Context ctx, Set idSet) throws BOSException, EASBizException {
        return JournalBackupFactory.getLocalInstance(ctx).mergeJournalByBatchNo(idSet);
    }

    @Override
    protected List _splitByBatchNo(Context ctx, Set idSet) throws BOSException, EASBizException {
        return JournalBackupFactory.getLocalInstance(ctx).splitJournalByBatchNo(idSet);
    }

    @Override
    protected boolean _isSourceBillMerged(Context ctx, String billId) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)billId)) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        return JournalBackupFactory.getLocalInstance(ctx).exists(filter);
    }

    @Override
    protected boolean _isMergedByBatchNo(Context ctx, String journalId) throws BOSException, EASBizException {
        if (EmptyUtil.isEmpty((String)journalId)) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("journalId", (Object)journalId));
        return JournalBackupFactory.getLocalInstance(ctx).exists(filter);
    }
}

