/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.DivideGroupNew;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public abstract class MutilThreadDealService
implements Callable {
    protected Context ctx;
    protected int taskNum;
    protected final int minDealSize = 10;
    protected final int maxThreadSize = 10;
    protected Set singleBizDealSet;

    public MutilThreadDealService() {
    }

    public MutilThreadDealService(Context ctx, int taskNum, Set idSet) {
        this.taskNum = taskNum;
        this.singleBizDealSet = idSet;
        this.ctx = ctx;
    }

    public Object mutilThreadTrans(Context ctx, Set allValueSet) {
        int thread = 10;
        if (allValueSet.size() < 100) {
            thread = allValueSet.size() / 10 + 1;
        }
        DivideGroupNew batch = new DivideGroupNew(allValueSet, thread);
        List result = batch.getResult();
        ExecutorService pool = Executors.newFixedThreadPool(thread);
        ArrayList list = new ArrayList();
        for (int i = 0; i < result.size(); ++i) {
            Set singleThreadSet = (Set)result.get(i);
            if (singleThreadSet == null || singleThreadSet.size() <= 0) continue;
            Callable callable = this.getService(ctx, i, singleThreadSet);
            Future f = pool.submit(callable);
            list.add(f);
        }
        pool.shutdown();
        int success = 0;
        for (Future future : list) {
            try {
                success += ((Integer)future.get()).intValue();
            }
            catch (Exception e) {
                HashMap<String, String> errs = new HashMap<String, String>();
                errs.put("err", e.getMessage());
                return errs;
            }
        }
        return success;
    }

    public Object call() throws Exception {
        System.out.println(">>>" + this.taskNum + " \u4efb\u52a1\u542f\u52a8");
        long startTime = System.currentTimeMillis();
        Object result = this.doTask();
        long endTime = System.currentTimeMillis();
        long time = (endTime - startTime) / 1000L;
        System.out.println(">>>" + this.taskNum + " \u4efb\u52a1\u7ec8\u6b62; \u8017\u65f6\uff1a" + time + "\u79d2");
        return result;
    }

    protected abstract Callable getService(Context var1, int var2, Set var3);

    protected abstract Object doTask() throws EASBizException, BOSException;
}

