/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class OpenApiImportHelper {
    private static Logger logger = Logger.getLogger((String)OpenApiImportHelper.class.getName());
    public static final String CASHANDRESOURCE = "com.kingdee.eas.fi.cas.CASHandResource";
    public static final String CASAUTORESOURCE = "com.kingdee.eas.fi.cas.CASAutoGenerateResource";

    public static void verifyNotNullProperty(Context ctx, Map map, String[] notNullPropertys) throws BOSException {
        if (notNullPropertys == null || notNullPropertys.length == 0) {
            return;
        }
        for (int i = 0; i < notNullPropertys.length; ++i) {
            String propertyName = notNullPropertys[i];
            Object data = map.get(propertyName);
            if (!EmptyUtil.isEmpty(data)) continue;
            String msgStr = MessageFormat.format(ResourceBase.getString((String)CASHANDRESOURCE, (String)"ziduan_cannot_be_null", (Locale)ctx.getLocale()), propertyName);
            throw new BOSException(msgStr);
        }
    }

    public static void verifyNotNullProperty(Context ctx, AbstractBaseObjectValue info, String[] notNullPropertys) throws BOSException {
        if (notNullPropertys == null || notNullPropertys.length == 0) {
            return;
        }
        for (int i = 0; i < notNullPropertys.length; ++i) {
            String propertyName = notNullPropertys[i];
            Object data = info.get(propertyName);
            if (!EmptyUtil.isEmpty((Object)data)) continue;
            String msgStr = MessageFormat.format(ResourceBase.getString((String)CASHANDRESOURCE, (String)"ziduan_error", (Locale)ctx.getLocale()), propertyName);
            throw new BOSException(msgStr);
        }
    }

    public static void prepareImport(Context ctx, IObjectValue info, Map map, String[] specialImportFieldNames) throws BOSException {
        List specialImportFieldLsit = null;
        if (specialImportFieldNames != null && specialImportFieldNames.length > 0) {
            specialImportFieldLsit = Arrays.asList((Object[])specialImportFieldNames);
        }
        BOSObjectType type = info.getBOSType();
        EntityObjectInfo entity = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(type);
        PropertyCollection properties = entity.getPropertiesRuntime();
        for (int i = 0; i < properties.size(); ++i) {
            Object data;
            PropertyInfo prop = properties.get(i);
            String fieldName = prop.getName();
            if (EmptyUtil.isEmpty((String)fieldName) || specialImportFieldLsit.contains(fieldName) || EmptyUtil.isEmpty(data = map.get(fieldName))) continue;
            if (prop instanceof LinkPropertyInfo) {
                IObjectValue value = null;
                LinkPropertyInfo new_name = (LinkPropertyInfo)prop;
                EntityObjectInfo sobj = new_name.getRelationship().getSupplierObject();
                BOSObjectType sobjtype = sobj.getType();
                IObjectCollection obj = OpenApiImportHelper.getCollectionByNumber(ctx, data, sobjtype);
                if (obj != null && obj.size() >= 1) {
                    value = obj.getObject(0);
                    info.put(fieldName, (Object)value);
                    continue;
                }
                if (obj == null || obj.size() == 0) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"166_OpenApiImportHelper", (Locale)ctx.getLocale()) + data + sobj.getAlias() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"167_OpenApiImportHelper", (Locale)ctx.getLocale()));
                }
            }
            if (!(prop instanceof OwnPropertyInfo)) continue;
            OwnPropertyInfo new_name = (OwnPropertyInfo)prop;
            DataType datatype = new_name.getDataType();
            if (datatype == DataType.STRING) {
                info.setString(fieldName, OpenApiImportHelper.getString(ctx, data));
                continue;
            }
            if (datatype == DataType.DATE) {
                info.setDate(fieldName, OpenApiImportHelper.getDate(ctx, data));
                continue;
            }
            if (datatype == DataType.TIMESTAMP) {
                info.setDate(fieldName, OpenApiImportHelper.getDate(ctx, data));
                continue;
            }
            if (datatype == DataType.DECIMAL) {
                info.setBigDecimal(fieldName, OpenApiImportHelper.getAmount(ctx, data));
                continue;
            }
            if (datatype != DataType.INTEGER) continue;
            info.setInt(fieldName, OpenApiImportHelper.getInt(ctx, data));
        }
    }

    public static IObjectCollection getCollectionByNumber(Context ctx, Object data, BOSObjectType sobjtype) throws BOSException {
        IObjectCollection obj = null;
        if (data instanceof String) {
            data = data.toString().trim();
        }
        try {
            obj = DynamicObjectFactory.getLocalInstance((Context)ctx).getCollection(sobjtype, "select * where number = '" + data + "'");
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return obj;
    }

    public static BigDecimal getAmount(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return FMConstants.ZERO;
        }
        BigDecimal value = null;
        try {
            value = TypeConversionUtils.objToBigDecimal((Object)data);
        }
        catch (Exception e) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)CASHANDRESOURCE, (String)"dataTransferError", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        return value;
    }

    public static int getInt(Context ctx, Object data) throws BOSException {
        int value;
        if (data == null || data.toString().trim().length() == 0) {
            return 0;
        }
        try {
            value = TypeConversionUtils.objToInt((Object)data);
        }
        catch (Exception e) {
            String msgStr = MessageFormat.format(ResourceBase.getString((String)CASHANDRESOURCE, (String)"dataTransferError", (Locale)ctx.getLocale()), data);
            throw new BOSException(msgStr);
        }
        return value;
    }

    public static String getString(Context ctx, Object data) {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        return data.toString().trim();
    }

    public static Date getDate(Context ctx, Object data) throws BOSException {
        if (data == null || data.toString().trim().length() == 0) {
            return null;
        }
        Date date = null;
        try {
            date = TypeConversionUtils.objToUtilDate((Object)data);
        }
        catch (Exception e) {
            try {
                date = new SimpleDateFormat().parse(data.toString());
            }
            catch (ParseException e1) {
                String msgStr = MessageFormat.format(ResourceBase.getString((String)CASHANDRESOURCE, (String)"dateTransferError", (Locale)ctx.getLocale()), data);
                throw new BOSException(msgStr);
            }
        }
        return date;
    }

    public static void parseHead(Context ctx, Map paymentBillInfoMap, PaymentBillInfo info) throws EASBizException, BOSException {
        String[] notNullPropertys = new String[]{"number", "company", "currency", "exchangeRate", "bizDate"};
        OpenApiImportHelper.verifyNotNullProperty(ctx, paymentBillInfoMap, notNullPropertys);
        String[] specialImportFieldNames = new String[]{"currency", "payerAccount", "payerAccountBank", "description", "oppAccount", "costCenter", "payeeType", "costCenter"};
        OpenApiImportHelper.prepareImport(ctx, (IObjectValue)info, paymentBillInfoMap, specialImportFieldNames);
        OpenApiImportHelper.verifyNotNullProperty(ctx, (AbstractBaseObjectValue)info, notNullPropertys);
        FilterInfo efilter = new FilterInfo();
        efilter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        efilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        if (PaymentBillFactory.getLocalInstance(ctx).exists(efilter)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"168_OpenApiImportHelper", (Locale)ctx.getLocale()));
        }
        Object data = null;
        if (info.getPaymentBillType() == null) {
            info.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
        }
        if ((data = (Object)paymentBillInfoMap.get("currency")) != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString()));
        } else {
            try {
                CurrencyInfo baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany());
                info.setCurrency(baseCurrency);
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)CASAUTORESOURCE, (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = dateFormat.format(info.getBizDate());
        try {
            info.setBizDate(dateFormat.parse(format));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        data = paymentBillInfoMap.get("payerAccount");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayerAccount(RecAndPayDataImportUtil2.getAccountByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"18_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString()));
        }
        if ((data = paymentBillInfoMap.get("payerAccountBank")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), data.toString(), true, true);
            info.setPayerAccountBank(accountBank);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccount()) && !accountBank.getAccount().getId().toString().equals(info.getPayerAccount().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"169_OpenApiImportHelper", (Locale)ctx.getLocale()));
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBank()) && !accountBank.getBank().getId().toString().equals(info.getPayerBank().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"170_OpenApiImportHelper", (Locale)ctx.getLocale()));
            }
            if (accountBank.isIsByCurrency() && !accountBank.getCurrency().getId().toString().equals(info.getCurrency().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"171_OpenApiImportHelper", (Locale)ctx.getLocale()));
            }
            info.setPayerBank(accountBank.getBank());
            info.setPayerAccount(accountBank.getAccount());
        }
        if (info.getFeeType() != null && !info.getFeeType().isIsLeaf()) {
            throw new BOSException(ResourceBase.getString((String)CASAUTORESOURCE, (String)"501_RecAndPayDataImportUtil2", (Locale)ctx.getLocale()));
        }
        data = paymentBillInfoMap.get("description");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new RecPayException(RecPayException.DESCNOTMORE, new String[]{String.valueOf(255)});
            }
            info.setDescription(data.toString());
        }
        info.setSourceType(SourceTypeEnum.CASH);
        if (info.getPayBillType() != null && info.getPayBillType().getSourceSysType() != null) {
            info.setSourceType(info.getPayBillType().getSourceSysType());
        }
        if (info.getSourceSysType() == null) {
            info.setSourceSysType(SourceTypeEnum.CASH);
        }
        if ((data = paymentBillInfoMap.get("oppAccount")) != null && data.toString().trim().length() > 0) {
            boolean cs064 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "CS064"));
            boolean isFromCash = info.getSourceType() == SourceTypeEnum.CASH;
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString(), cs064, isFromCash));
        }
        if ((data = paymentBillInfoMap.get("costCenter")) != null && data.toString().trim().length() > 0) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(data.toString(), ctx));
        }
        if ((data = paymentBillInfoMap.get("payeeType")) != null && data.toString().trim().length() > 0) {
            info.setPayeeType(RecAndPayDataImportUtil2.getAsstActTypeByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"177_PaymentBillDataImport", (Locale)ctx.getLocale()), data.toString()));
        }
        if (EmptyUtil.isEmpty((String)info.getBankNumber()) && !EmptyUtil.isEmpty((String)info.getPayeeBank())) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getPayeeBank().trim(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            view.setFilter(filter);
            BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
            if (coll.size() > 0) {
                info.setBankNumber(coll.get(0).getNumber());
            }
        }
        String companyID = null;
        if (!EmptyUtil.isEmpty((String)info.getPayeeNumber())) {
            if (info.getPayeeType() == null) {
                info.setPayeeName(EmptyUtil.isEmpty((String)info.getPayeeName()) ? info.getPayeeNumber() : info.getPayeeName());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getPayeeNumber().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (companyColl != null && companyColl.size() > 0) {
                    companyID = companyColl.get(0).getId().toString();
                }
            } else {
                IRowSet asstActInfo = RecAndPayDataImportUtil2.getAsstActInfo(info.getPayeeType(), info.getPayeeNumber().trim(), ctx);
                try {
                    if (asstActInfo.next()) {
                        info.setPayeeID(asstActInfo.getString("fid"));
                        info.setPayeeNumber(asstActInfo.getString("fnumber"));
                        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                        info.setPayeeName(asstActInfo.getString("fname_" + loc));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeBank()) && !EmptyUtil.isEmpty((String)info.getPayeeID()) && BOSUuid.read((String)info.getPayeeID()).getType().equals((Object)new SupplierInfo().getBOSType())) {
            ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("province.*"));
            sic.add(new SelectorItemInfo("city.*"));
            SupplierInfo realSupplier = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), sic);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)realSupplier.getProvince()) && !EmptyUtil.isEmpty((CoreBaseInfo)realSupplier.getCity())) {
                info.setRecProvince(realSupplier.getProvince().getName());
                info.setRecCity(realSupplier.getCity().getName());
            }
            info.setBankAcctName(realSupplier.getName());
            SelectorItemCollection spcSelector = new SelectorItemCollection();
            spcSelector.add(new SelectorItemInfo("id"));
            spcSelector.add(new SelectorItemInfo("supplierBank.id"));
            spcSelector.add(new SelectorItemInfo("supplierBank.bank"));
            SupplierCompanyInfoInfo supplierCompany = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
            if (supplierCompany != null && supplierCompany.getSupplierBank() != null && supplierCompany.getSupplierBank().size() > 0) {
                SupplierCompanyBankCollection coll = supplierCompany.getSupplierBank();
                SupplierCompanyBankInfo sBankInfo = coll.get(0);
                info.setPayeeBank(sBankInfo.getBank());
            }
        }
        if (!EmptyUtil.isEmpty((String)info.getPayeeBank())) {
            BEBankInfo beBank = RecAndPayDataImportUtil2.getBeBankByName(ctx, info.getPayeeBank());
            if (beBank != null) {
                info.setBankNumber(beBank.getNumber());
                info.setRecProvince(beBank.getBeProvince());
                info.setRecCity(beBank.getBeCity());
            } else {
                logger.error((Object)("\u4ed8\u6b3e\u5355\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u627e\u5bf9\u5bf9\u5e94\u7684\u884c\u540d\u884c\u53f7\uff0c\u6536\u6b3e\u94f6\u884c=" + info.getPayeeBank()));
            }
        }
        if (!EmptyUtil.isEmpty((String)info.getPayeeAccountBank())) {
            info.setPayeeAccountBankO(RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"47_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), companyID, info.getPayeeAccountBank(), false, true));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccountBankO())) {
            info.setOppInnerAcct(info.getPayeeAccountBankO().getInnerAcct());
        }
        info.setIsInitializeBill(false);
        info.setIsImport(true);
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
    }

    public static void parseEntries(Context ctx, Map paymentBillInfoMap, PaymentBillInfo info) throws EASBizException, BOSException {
        Object data = paymentBillInfoMap.get("entries");
        if (data == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"173_OpenApiImportHelper", (Locale)ctx.getLocale()));
        }
        if (data instanceof List) {
            List entryList = (List)data;
            for (int i = 0; i < entryList.size(); ++i) {
                Object entryObj = entryList.get(i);
                if (!(entryObj instanceof Map)) continue;
                Map entryMap = (Map)entryObj;
                PaymentBillEntryInfo entry = new PaymentBillEntryInfo();
                String[] notNullPropertys = new String[]{"actualAmt"};
                OpenApiImportHelper.verifyNotNullProperty(ctx, entryMap, notNullPropertys);
                String[] specialImportFieldNames = new String[]{"costCenter", "fundFlowItem", "oppAccount"};
                OpenApiImportHelper.prepareImport(ctx, (IObjectValue)entry, entryMap, specialImportFieldNames);
                OpenApiImportHelper.verifyNotNullProperty(ctx, (AbstractBaseObjectValue)info, notNullPropertys);
                Object entryData = null;
                if (EmptyUtil.isEmpty((String)entry.getOutBgItemId()) && !EmptyUtil.isEmpty((String)entry.getOutBgItemNumber())) {
                    BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(entry.getOutBgItemNumber(), ResourceBase.getString((String)CASAUTORESOURCE, (String)"23_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
                    entry.setOutBgItemNumber(data.toString());
                    entry.setOutBgItemId(bgItemInfo.getId().toString());
                    entry.setOutBgItemName(bgItemInfo.getName());
                }
                if (!EmptyUtil.isEmpty((Object)entry.getActualAmt())) {
                    entry.setActualAmt(entry.getActualAmt().setScale(info.getCurrency().getPrecision(), 4));
                }
                if ((entryData = (Object)entryMap.get("costCenter")) != null && entryData.toString().trim().length() > 0) {
                    entry.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(entryData.toString(), ctx));
                }
                if ((entryData = entryMap.get("fundFlowItem")) != null && entryData.toString().trim().length() > 0) {
                    entry.setFundFlowItem(RecAndPayDataImportUtil2.getFundFlowItemByNumber(entryData.toString(), ctx));
                }
                if ((entryData = entryMap.get("oppAccount")) != null && entryData.toString().trim().length() > 0) {
                    boolean cs064 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "CS064"));
                    boolean isFromCash = info.getSourceType() == SourceTypeEnum.CASH;
                    entry.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"179_PaymentBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString(), cs064, isFromCash));
                }
                entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                info.getEntries().add(entry);
            }
        }
        if (info.getEntries().size() == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"174_OpenApiImportHelper", (Locale)ctx.getLocale()));
        }
    }

    public static void parseHead(Context ctx, Map receivingBillInfoMap, ReceivingBillInfo info) throws EASBizException, BOSException {
        String[] notNullPropertys = new String[]{"number", "company", "currency", "exchangeRate", "bizDate"};
        OpenApiImportHelper.verifyNotNullProperty(ctx, receivingBillInfoMap, notNullPropertys);
        String[] specialImportFieldNames = new String[]{"currency", "payeeAccount", "payeeAccountBank", "description", "oppAccount", "costCenter", "payerType"};
        OpenApiImportHelper.prepareImport(ctx, (IObjectValue)info, receivingBillInfoMap, specialImportFieldNames);
        OpenApiImportHelper.verifyNotNullProperty(ctx, (AbstractBaseObjectValue)info, notNullPropertys);
        FilterInfo efilter = new FilterInfo();
        efilter.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        efilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        if (ReceivingBillFactory.getLocalInstance(ctx).exists(efilter)) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"175_OpenApiImportHelper", (Locale)ctx.getLocale()));
        }
        Object data = null;
        data = receivingBillInfoMap.get("currency");
        if (data != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString()));
        } else {
            try {
                CurrencyInfo baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany());
                info.setCurrency(baseCurrency);
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)CASAUTORESOURCE, (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String format = dateFormat.format(info.getBizDate());
        try {
            info.setBizDate(dateFormat.parse(format));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        data = receivingBillInfoMap.get("payeeAccount");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayeeAccount(RecAndPayDataImportUtil2.getAccountByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"48_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString()));
        }
        if ((data = receivingBillInfoMap.get("payeeAccountBank")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"47_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), data.toString(), true, true);
            info.setPayeeAccountBank(accountBank);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccount()) && !accountBank.getAccount().getId().toString().equals(info.getPayeeAccount().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"176_OpenApiImportHelper", (Locale)ctx.getLocale()));
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeBank()) && !accountBank.getBank().getId().toString().equals(info.getPayeeBank().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"177_OpenApiImportHelper", (Locale)ctx.getLocale()));
            }
            if (accountBank.isIsByCurrency() && !accountBank.getCurrency().getId().toString().equals(info.getCurrency().getId().toString())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"178_OpenApiImportHelper", (Locale)ctx.getLocale()));
            }
            info.setPayeeBank(accountBank.getBank());
            info.setPayeeAccount(accountBank.getAccount());
        }
        if (info.getFeeType() != null && !info.getFeeType().isIsLeaf()) {
            throw new BOSException(ResourceBase.getString((String)CASAUTORESOURCE, (String)"501_RecAndPayDataImportUtil2", (Locale)ctx.getLocale()));
        }
        data = receivingBillInfoMap.get("description");
        if (data != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new RecPayException(RecPayException.DESCNOTMORE, new String[]{String.valueOf(255)});
            }
            info.setDescription(data.toString());
        }
        info.setSourceType(SourceTypeEnum.CASH);
        if (info.getRecBillType() != null && info.getRecBillType().getSourceSysType() != null) {
            info.setSourceType(info.getRecBillType().getSourceSysType());
        }
        if (info.getSourceSysType() == null) {
            info.setSourceSysType(SourceTypeEnum.CASH);
        }
        if ((data = receivingBillInfoMap.get("oppAccount")) != null && data.toString().trim().length() > 0) {
            boolean cs063 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "CS063"));
            boolean isFromCash = info.getSourceType() == SourceTypeEnum.CASH;
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString(), cs063, isFromCash));
        }
        if ((data = receivingBillInfoMap.get("payerType")) != null && data.toString().trim().length() > 0) {
            info.setPayerType(RecAndPayDataImportUtil2.getAsstActTypeByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"210_ReceivingBillDataImport", (Locale)ctx.getLocale()), data.toString()));
        }
        String companyID = null;
        if (!EmptyUtil.isEmpty((String)info.getPayerNumber())) {
            if (info.getPayerType() == null) {
                info.setPayerName(EmptyUtil.isEmpty((String)info.getPayerName()) ? info.getPayerNumber() : info.getPayerName());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getPayerNumber().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (companyColl != null && companyColl.size() > 0) {
                    companyID = companyColl.get(0).getId().toString();
                }
            } else {
                IRowSet asstActInfo = RecAndPayDataImportUtil2.getAsstActInfo(info.getPayerType(), info.getPayerNumber().trim(), ctx);
                try {
                    if (asstActInfo.next()) {
                        info.setPayerID(asstActInfo.getString("fid"));
                        info.setPayerNumber(asstActInfo.getString("fnumber"));
                        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                        info.setPayerName(asstActInfo.getString("fname_" + loc));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
        }
        if (!EmptyUtil.isEmpty((String)info.getPayerAccountBank())) {
            info.setPayerAccountBankO(RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), companyID, info.getPayerAccountBank(), false, true));
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBankO())) {
            info.setOppInnerAcct(info.getPayerAccountBankO().getInnerAcct());
        }
        if ((data = receivingBillInfoMap.get("costCenter")) != null && data.toString().trim().length() > 0) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(data.toString().trim(), ctx));
        }
        info.setIsInitializeBill(false);
        info.setIsImport(true);
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
    }

    public static void parseEntries(Context ctx, Map ReceivingBillInfoMap, ReceivingBillInfo info) throws EASBizException, BOSException {
        Object data = ReceivingBillInfoMap.get("entries");
        if (data == null) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"173_OpenApiImportHelper", (Locale)ctx.getLocale()));
        }
        if (data instanceof List) {
            List entryList = (List)data;
            for (int i = 0; i < entryList.size(); ++i) {
                Object entryObj = entryList.get(i);
                if (!(entryObj instanceof Map)) continue;
                Map entryMap = (Map)entryObj;
                ReceivingBillEntryInfo entry = new ReceivingBillEntryInfo();
                String[] notNullPropertys = new String[]{"actualAmt"};
                OpenApiImportHelper.verifyNotNullProperty(ctx, entryMap, notNullPropertys);
                String[] specialImportFieldNames = new String[]{"costCenter", "fundFlowItem", "oppAccount"};
                OpenApiImportHelper.prepareImport(ctx, (IObjectValue)entry, entryMap, specialImportFieldNames);
                OpenApiImportHelper.verifyNotNullProperty(ctx, (AbstractBaseObjectValue)info, notNullPropertys);
                Object entryData = null;
                if (EmptyUtil.isEmpty((String)entry.getOutBgItemId()) && !EmptyUtil.isEmpty((String)entry.getOutBgItemNumber())) {
                    BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(entry.getOutBgItemNumber(), ResourceBase.getString((String)CASAUTORESOURCE, (String)"23_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
                    entry.setOutBgItemNumber(data.toString());
                    entry.setOutBgItemId(bgItemInfo.getId().toString());
                    entry.setOutBgItemName(bgItemInfo.getName());
                }
                if (!EmptyUtil.isEmpty((Object)entry.getActualAmt())) {
                    entry.setActualAmt(entry.getActualAmt().setScale(info.getCurrency().getPrecision(), 4));
                }
                if ((entryData = (Object)entryMap.get("costCenter")) != null && entryData.toString().trim().length() > 0) {
                    entry.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(entryData.toString(), ctx));
                }
                if ((entryData = entryMap.get("fundFlowItem")) != null && entryData.toString().trim().length() > 0) {
                    entry.setFundFlowItem(RecAndPayDataImportUtil2.getFundFlowItemByNumber(entryData.toString(), ctx));
                }
                if ((entryData = entryMap.get("oppAccount")) != null && entryData.toString().trim().length() > 0) {
                    boolean cs063 = Boolean.valueOf(ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "CS063"));
                    boolean isFromCash = info.getSourceType() == SourceTypeEnum.CASH;
                    entry.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)CASAUTORESOURCE, (String)"179_PaymentBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString(), cs063, isFromCash));
                }
                entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                info.getEntries().add(entry);
            }
        }
        if (info.getEntries().size() == 0) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"174_OpenApiImportHelper", (Locale)ctx.getLocale()));
        }
    }
}

