/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPayAdmitScheme;
import com.kingdee.eas.fi.cas.LogCategoryEnum;
import com.kingdee.eas.fi.cas.PayAdmitSchemeCollection;
import com.kingdee.eas.fi.cas.PayAdmitSchemeFactory;
import com.kingdee.eas.fi.cas.PayAdmitSchemeInfo;
import com.kingdee.eas.fi.cas.app.AbstractPayAdmitSchemeControllerBean;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayAdmitSchemeControllerBean
extends AbstractPayAdmitSchemeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.PayAdmitSchemeControllerBean");
    private static final String payAdmitResource = "com.kingdee.eas.fi.cas.PayAdmitResource";
    private static final String enable = "\u542f\u7528";
    private static final String disEnable = "\u7981\u7528";

    @Override
    protected List _cancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> results = new ArrayList<BankPayResult>();
        if (idSet.size() == 0) {
            return results;
        }
        IPayAdmitScheme iPayAdmitScheme = PayAdmitSchemeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PayAdmitSchemeCollection coll = iPayAdmitScheme.getPayAdmitSchemeCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            PayAdmitSchemeInfo info = coll.get(i);
            BankPayResult resultInfo = new BankPayResult();
            if (info.isIsPreset() && !"FKZR".equals(info.getNumber()) && !"DFZR".equals(info.getNumber())) {
                resultInfo.setErrorDetail(ResourceBase.getString((String)payAdmitResource, (String)"13_NoDisable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}));
                results.add(resultInfo);
                continue;
            }
            if (!info.isIsEnable()) {
                resultInfo.setErrorDetail(ResourceBase.getString((String)payAdmitResource, (String)"14_HasBeenDisEnable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}));
                results.add(resultInfo);
                continue;
            }
            try {
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)info, LogCategoryEnum.AccessScheme, enable, disEnable, null);
            }
            catch (Exception e) {
                logger.error((Object)("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38" + e.getMessage()));
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isEnable"));
            info.setIsEnable(false);
            iPayAdmitScheme.updatePartial((CoreBaseInfo)info, sic);
        }
        return results;
    }

    @Override
    protected List _cancelCancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> results = new ArrayList<BankPayResult>();
        if (idSet.size() == 0) {
            return results;
        }
        IPayAdmitScheme iPayAdmitScheme = PayAdmitSchemeFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PayAdmitSchemeCollection coll = iPayAdmitScheme.getPayAdmitSchemeCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            PayAdmitSchemeInfo info = coll.get(i);
            BankPayResult resultInfo = new BankPayResult();
            if (info.isIsEnable()) {
                resultInfo.setErrorDetail(ResourceBase.getString((String)payAdmitResource, (String)"15_HasBeenEnable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}));
                results.add(resultInfo);
                continue;
            }
            if (info.isIsPreset() && !"FKZR".equals(info.getNumber()) && !"DFZR".equals(info.getNumber())) {
                resultInfo.setErrorDetail(ResourceBase.getString((String)payAdmitResource, (String)"35_PreditNoEnable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}));
                results.add(resultInfo);
                continue;
            }
            try {
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)info, LogCategoryEnum.AccessScheme, disEnable, enable, null);
            }
            catch (Exception e) {
                logger.error((Object)("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38" + e.getMessage()));
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isEnable"));
            info.setIsEnable(true);
            iPayAdmitScheme.updatePartial((CoreBaseInfo)info, sic);
        }
        return results;
    }
}

