/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.LogCategoryEnum;
import com.kingdee.eas.fi.cas.PayAdmitSchemeFactory;
import com.kingdee.eas.fi.cas.PayAdmitSchemeInfo;
import com.kingdee.eas.fi.cas.PayAntiRepeatCollection;
import com.kingdee.eas.fi.cas.PayAntiRepeatFactory;
import com.kingdee.eas.fi.cas.PayAntiRepeatInfo;
import com.kingdee.eas.fi.cas.app.AbstractPayAntiRepeatControllerBean;
import com.kingdee.eas.fi.cas.utils.PayAdmitUtils;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class PayAntiRepeatControllerBean
extends AbstractPayAntiRepeatControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.PayAntiRepeatControllerBean");
    private static final String payAdmitResource = "com.kingdee.eas.fi.cas.PayAdmitResource";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PayAntiRepeatInfo info = (PayAntiRepeatInfo)model;
        try {
            if (null != info.getId() && PayAntiRepeatFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                PayAntiRepeatInfo oldAntiInfo = PayAntiRepeatFactory.getLocalInstance(ctx).getPayAntiRepeatInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()));
                if (!(EmptyUtil.isEmpty((String)info.getOnlyKey()) || EmptyUtil.isEmpty((String)oldAntiInfo.getOnlyKey()) || info.getOnlyKey().equals(oldAntiInfo.getOnlyKey()))) {
                    PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)info, LogCategoryEnum.AntiSchemeEdit, oldAntiInfo.getOnlyKey(), info.getOnlyKey(), null);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38" + e.getMessage()));
        }
        IObjectPK pk = super._save(ctx, model);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)pk.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (collection == null || collection.size() == 0) {
            HashMap<String, String> idMap = new HashMap<String, String>();
            idMap.put(info.getPayAdmitScheme().getId().toString(), pk.toString());
            BOTPUtil.saveBOTRelation((Context)ctx, idMap);
        } else {
            BOTRelationInfo botRelationInfo = collection.get(0);
            botRelationInfo.setSrcObjectID(info.getPayAdmitScheme().getId().toString());
            BOTRelationFactory.getLocalInstance((Context)ctx).update((IObjectPK)new ObjectUuidPK(botRelationInfo.getId()), botRelationInfo);
        }
        return pk;
    }

    @Override
    protected List _cancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> results = new ArrayList<BankPayResult>();
        if (idSet.size() == 0) {
            return results;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PayAntiRepeatCollection coll = PayAntiRepeatFactory.getLocalInstance(ctx).getPayAntiRepeatCollection(view);
        CoreBaseCollection updateColl = new CoreBaseCollection();
        CoreBaseCollection admitColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PayAntiRepeatInfo info = coll.get(i);
            BankPayResult resultInfo = new BankPayResult();
            if (info.isIsPreset()) {
                resultInfo.setErrorDetail(ResourceBase.getString((String)payAdmitResource, (String)"13_NoDisable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}));
                results.add(resultInfo);
                continue;
            }
            if (!info.isIsEnable()) {
                resultInfo.setErrorDetail(ResourceBase.getString((String)payAdmitResource, (String)"14_HasBeenDisEnable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}));
                results.add(resultInfo);
                continue;
            }
            try {
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)info, LogCategoryEnum.AntiSchemeOperator, "\u542f\u7528", "\u7981\u7528", null);
            }
            catch (Exception e) {
                logger.error((Object)("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38" + e.getMessage()));
            }
            info.setIsEnable(false);
            updateColl.add((CoreBaseInfo)info);
            PayAdmitSchemeInfo admitInfo = info.getPayAdmitScheme();
            admitInfo.setIsRelated(false);
            admitColl.add((CoreBaseInfo)admitInfo);
        }
        if (updateColl.size() > 0) {
            PayAntiRepeatFactory.getLocalInstance(ctx).updateBatchData(updateColl);
        }
        if (admitColl.size() > 0) {
            PayAdmitSchemeFactory.getLocalInstance(ctx).updateBatchData(admitColl);
        }
        return results;
    }

    @Override
    protected List _cancelCancel(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> results = new ArrayList<BankPayResult>();
        if (idSet.size() == 0) {
            return results;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PayAntiRepeatCollection coll = PayAntiRepeatFactory.getLocalInstance(ctx).getPayAntiRepeatCollection(view);
        CoreBaseCollection updateColl = new CoreBaseCollection();
        CoreBaseCollection admitColl = new CoreBaseCollection();
        for (int i = 0; i < coll.size(); ++i) {
            PayAntiRepeatInfo info = coll.get(i);
            BankPayResult resultInfo = new BankPayResult();
            if (info.isIsEnable()) {
                resultInfo.setErrorDetail(ResourceBase.getString((String)payAdmitResource, (String)"15_HasBeenEnable", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber()}));
                results.add(resultInfo);
                continue;
            }
            try {
                PayAdmitUtils.recordAntiGravityLog(ctx, (CoreBaseInfo)info, LogCategoryEnum.AntiSchemeOperator, "\u7981\u7528", "\u542f\u7528", null);
            }
            catch (Exception e) {
                logger.error((Object)("\u8bb0\u5f55\u65e5\u5fd7\u5f02\u5e38" + e.getMessage()));
            }
            info.setIsEnable(true);
            updateColl.add((CoreBaseInfo)info);
            PayAdmitSchemeInfo admitInfo = info.getPayAdmitScheme();
            admitInfo.setIsRelated(true);
            admitColl.add((CoreBaseInfo)admitInfo);
        }
        if (updateColl.size() > 0) {
            PayAntiRepeatFactory.getLocalInstance(ctx).updateBatchData(updateColl);
        }
        if (admitColl.size() > 0) {
            PayAdmitSchemeFactory.getLocalInstance(ctx).updateBatchData(admitColl);
        }
        return results;
    }
}

