/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.AssItemsForCashPayCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentBillEntry;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.CasPaymentBillImportVerify;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.be.BEBankCollection;
import com.kingdee.eas.fm.be.BEBankFactory;
import com.kingdee.eas.fm.be.BEBankInfo;
import com.kingdee.eas.fm.common.util.BizRelateReceivableBillUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PaymentBillDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)PaymentBillDataImport.class.getName());
    private CasPaymentBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private String lastKey;
    private String curKey;
    private Map seqMap = new HashMap();
    private boolean cs074;
    private boolean cs064;
    private boolean flag = false;
    private Map assTypeIDMap = new HashMap();

    @Override
    protected ICoreBase _getController(Context ctx) throws BOSException {
        return PaymentBillFactory.getLocalInstance(ctx);
    }

    public CasPaymentBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new CasPaymentBillImportVerify();
        }
        return this.verify;
    }

    @Override
    public CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws BOSException, EASBizException {
        String number = (String)this.getData(hsData, "FNumber");
        this.curKey = EmptyUtil.isEmpty((String)number) ? Uuid.create().toString() : number;
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        String companyId = null;
        CompanyOrgUnitInfo company = null;
        Object companyData = this.getData(hsData, "FCompanyID");
        if (companyData != null && companyData.toString().trim().length() > 0) {
            company = RecAndPayDataImportUtil2.getCompanyByNumber(ctx, (String)companyData);
        }
        if (company == null) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        companyId = company.getId().toString();
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        this.cs074 = contextHelper.getBooleanParam("CS074", (IObjectPK)new ObjectUuidPK(companyId));
        this.cs064 = contextHelper.getBooleanParam("CS064", (IObjectPK)new ObjectUuidPK(companyId));
        PaymentBillInfo head = null;
        PaymentBillEntryInfo entry = null;
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (this.infoMap.containsKey(this.curKey)) {
            head = (PaymentBillInfo)this.infoMap.get(this.curKey);
            head.setCompany(company);
        } else {
            head = this.getHeadInfo(ctx, mode, number, companyId);
            head.setCompany(company);
            head = (PaymentBillInfo)this.parseHead(hsData, ctx, head);
            this.infoMap.put(this.curKey, head);
        }
        CurrencyInfo baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(head.getCompany());
        String headId = head.getId() == null ? null : head.getId().toString();
        Integer fseq = this.seqMap.get(this.curKey) == null ? new Integer(1) : (Integer)this.seqMap.get(this.curKey);
        entry = this.getEntryInfo(ctx, mode, headId, fseq.toString());
        this.seqMap.put(this.curKey, new Integer(fseq + 1));
        entry = (PaymentBillEntryInfo)this.parseEntry(hsData, ctx, entry, companyId);
        entry.setSeq(fseq);
        try {
            String data;
            AccountViewInfo acctViewInfo = entry.getOppAccount();
            VoucherInfo.DynamicColumnInfo[] dyColumnInfos = null;
            if (acctViewInfo != null && acctViewInfo.getCAA() != null) {
                Object[] fetchAssColumnInfo;
                IVoucherFacade voucherFacade = VoucherFacadeFactory.getLocalInstance((Context)ctx);
                try {
                    fetchAssColumnInfo = voucherFacade.fetchAssColumnInfo(acctViewInfo.getId().toString(), acctViewInfo.getCAA().getId().toString(), null);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"170_PaymentBillDataImport", (Locale)ctx.getLocale()) + acctViewInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"171_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
                dyColumnInfos = (VoucherInfo.DynamicColumnInfo[])fetchAssColumnInfo[0];
                AssItemsForCashPayCollection assCol = entry.getAssItemsEntries();
                assCol.clear();
                if (assCol == null || assCol.size() == 0) {
                    for (int i = 0; i < dyColumnInfos.length; ++i) {
                        AsstActTypeInfo aTypeinfo_temp = (AsstActTypeInfo)this.assTypeIDMap.get(dyColumnInfos[i].getId());
                        if (aTypeinfo_temp == null) {
                            aTypeinfo_temp = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(dyColumnInfos[i].getId()));
                            this.assTypeIDMap.put(dyColumnInfos[i].getId(), aTypeinfo_temp);
                        }
                        AssItemsForCashPayInfo assInfo_temp = new AssItemsForCashPayInfo();
                        assInfo_temp.setAsstActType(aTypeinfo_temp);
                        assInfo_temp.setIsSelected(false);
                        assInfo_temp.setEntryParent(entry);
                        assInfo_temp.setEntrySeq(entry.getSeq());
                        assInfo_temp.setMappingFileds(aTypeinfo_temp.getMappingFieldName());
                        assInfo_temp.setTableName(aTypeinfo_temp.getRealtionDataObject());
                        assCol.add(assInfo_temp);
                    }
                }
                String entryId = entry.getId() == null ? null : entry.getId().toString();
                for (int k = 1; k <= 8; ++k) {
                    Object data2 = this.getData(hsData, "FAssType" + k);
                    if (data2 != null && data2.toString().trim().length() > 0) {
                        AsstActTypeInfo assTypeInfo = this.getAsstActType(ctx, data2);
                        if (assTypeInfo == null) {
                            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"172_PaymentBillDataImport", (Locale)ctx.getLocale()) + data2.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"173_PaymentBillDataImport", (Locale)ctx.getLocale()));
                        }
                        AssItemsForCashPayInfo assInfo = this.getAssItemInfo(ctx, mode, entryId, assCol, assTypeInfo);
                        assInfo = this.parseAssItem(hsData, ctx, assTypeInfo, assInfo, k, entry);
                        if (assCol != null && assCol.size() > 0) {
                            int exFlag = 0;
                            for (int i = 0; i < assCol.size(); ++i) {
                                AssItemsForCashPayInfo entryInfo = assCol.get(i);
                                if (!entryInfo.getAsstActType().getId().equals((Object)assInfo.getAsstActType().getId())) continue;
                                assCol.set(i, assInfo);
                                ++exFlag;
                                break;
                            }
                            if (exFlag != 0) continue;
                            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + assTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                        }
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + assTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                    }
                    data2 = this.getData(hsData, "FAssNumber" + k);
                    if (data2 == null || data2.toString().trim().length() <= 0) continue;
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"174_PaymentBillDataImport", (Locale)ctx.getLocale()) + data2.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"175_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
            } else {
                entry.getAssItemsEntries().clear();
            }
            this.getVerify().verifyEntry(ctx, (CoreBaseInfo)entry, head.getSourceType(), dyColumnInfos);
            PaymentBillEntryCollection coll = head.getEntries();
            int collSize = coll.size();
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < collSize; ++i) {
                    PaymentBillEntryInfo entryInfo = coll.get(i);
                    if (entryInfo.getSeq() == entry.getSeq()) {
                        coll.set(i, entry);
                    } else {
                        if (entry.getSeq() <= collSize) continue;
                        coll.add(entry);
                    }
                    break;
                }
            } else {
                coll.add(entry);
            }
            String srcCurrId = head.getCurrency().getId().toString();
            String destCurrId = baseCurrency.getId().toString();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(destCurrId));
            ExchangeRateInfo exchangeRate = this.getExRateInfo(ctx, srcCurrId, destCurrId, company, new Date());
            boolean isIndirectExRate = this.isIndirectExRate(exchangeRate);
            int scale = head.getCurrency().getPrecision();
            BigDecimal rate = head.getExchangeRate();
            int round = 4;
            BigDecimal temp = entry.getActualAmt();
            entry.setActualAmt(temp);
            if (rate == null) {
                rate = Constants.ONE;
            }
            if (temp != null) {
                temp = isIndirectExRate ? temp.divide(rate, baseCurrency.getPrecision(), round) : temp.multiply(rate).setScale(baseCurrency.getPrecision(), round);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"176_PaymentBillDataImport", (Locale)ctx.getLocale()));
            }
            entry.setActualLocAmt(temp);
            PaymentBillEntryCollection col = head.getEntries();
            if (col != null) {
                BigDecimal amt = Constants.ZERO;
                BigDecimal amtLoc = Constants.ZERO;
                for (int i = 0; i < col.size(); ++i) {
                    PaymentBillEntryInfo entryInfo = col.get(i);
                    amt = amt.add(entryInfo.getActualAmt()).setScale(scale, round);
                    amtLoc = amtLoc.add(entryInfo.getActualLocAmt()).setScale(baseCurrency.getPrecision(), round);
                }
                head.setActPayAmt(amt);
                head.setActPayLocAmt(amtLoc);
            }
            if ((data = (String)this.getData(hsData, "outBgItemNumber")) != null && data.toString().trim().length() > 0) {
                BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(data.toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"21_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
                head.setOutBgItemNumber(data.toString());
                head.setOutBgItemId(bgItemInfo.getId().toString());
                head.setOutBgItemName(bgItemInfo.getName());
            }
            this.getVerify().verifyHead(ctx, (CoreBaseInfo)head);
        }
        catch (BOSException e) {
            this.seqMap.put(this.curKey, new Integer((Integer)this.seqMap.get(this.curKey) - 1));
            throw e;
        }
        return head;
    }

    private PaymentBillEntryInfo getEntryInfo(Context ctx, int mode, String parentId, String FSeq) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (parentId == null || FSeq == null) {
                return new PaymentBillEntryInfo();
            }
            try {
                IPaymentBillEntry iPaymentBillEntry = PaymentBillEntryFactory.getLocalInstance(ctx);
                PaymentBillEntryCollection coll = iPaymentBillEntry.getPaymentBillEntryCollection("where paymentBill = '" + parentId + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new PaymentBillEntryInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new PaymentBillEntryInfo();
        }
        return new PaymentBillEntryInfo();
    }

    private PaymentBillInfo getHeadInfo(Context ctx, int mode, String number, String companyId) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (companyId == null || number == null) {
                return new PaymentBillInfo();
            }
            try {
                PaymentBillCollection coll = ((IPaymentBill)this.getController(ctx)).getPaymentBillCollection("where number = '" + number + "' and company.id = '" + companyId + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new PaymentBillInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new PaymentBillInfo();
        }
        return new PaymentBillInfo();
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        BizTypeEnum enums;
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        Object data = null;
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FUsage")) != null && data.toString().trim().length() > 0) {
            info.setUsage(data.toString());
        }
        if ((data = this.getData(hsData, "FAccessoryAmt")) != null && data.toString().trim().length() > 0) {
            info.setAccessoryAmt(TypeConversionUtils.objToInt((Object)data));
        }
        if ((data = this.getData(hsData, "FPaymentBillType")) == null) {
            info.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
        }
        if ((data = this.getData(hsData, "FBizDate")) != null && data.toString().trim().length() > 0) {
            Date objToDate = RecAndPayDataImportUtil2.objToDate(ctx, data);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = dateFormat.format(objToDate);
            try {
                info.setBizDate(dateFormat.parse(format));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"16_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString()));
        } else {
            try {
                info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany()));
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FExchangeRate");
        if (data != null && data.toString().trim().length() > 0) {
            info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FFundType")) != null && data.toString().trim().length() > 0 && (enums = BizTypeEnum.getEnum(TypeConversionUtils.objToInt((Object)data))) != null) {
            info.setFundType(enums);
        }
        if ((data = this.getData(hsData, "FBizTypeID")) != null && data.toString().trim().length() > 0) {
            info.setBizType(RecAndPayDataImportUtil2.getBizTypeByNumber(ctx, data.toString()));
        }
        if ((data = this.getData(hsData, "FPayerAccountID")) != null && data.toString().trim().length() > 0) {
            info.setPayerAccount(RecAndPayDataImportUtil2.getAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"18_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString()));
        }
        if ((data = this.getData(hsData, "FPayerAccountBankID")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), data.toString(), true, false);
            info.setPayerAccountBank(accountBank);
            if (accountBank != null) {
                if (!accountBank.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"235_PaymentBillControllerBean", (Locale)ctx.getLocale()));
                }
                info.setPayerBank(accountBank.getBank());
                info.setPayerAccount(accountBank.getAccount());
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"243_PaymentBillDataImport", (Locale)ctx.getLocale()) + data.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"244_PaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FFeeTypeID")) != null && data.toString().trim().length() > 0) {
            FeeTypeInfo feeType = RecAndPayDataImportUtil2.getFeeTypeByNumber(ctx, (String)data);
            info.setFeeType(feeType);
        }
        if ((data = this.getData(hsData, "FSettlementTypeID")) != null && data.toString().trim().length() > 0) {
            info.setSettlementType(RecAndPayDataImportUtil2.getSettlementTypeByNumber(data.toString(), ctx));
        }
        if ((data = this.getData(hsData, "FSettlementNumber")) != null && data.toString().trim().length() > 0) {
            info.setSettlementNumber(data.toString());
            List entryList = BizRelateReceivableBillUtil.assembleReceivableEntryList(null, (String)data.toString(), (int)1);
            info.put("receivableBillEntrys", entryList);
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new RecPayException(RecPayException.DESCNOTMORE, new String[]{String.valueOf(255)});
            }
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FPayBillTypeID")) != null && data.toString().trim().length() > 0) {
            info.setPayBillType(RecAndPayDataImportUtil2.getPayBillTypeByNumber(data.toString(), ctx));
        }
        if (info.getPayBillType().getSourceSysType().equals((Object)SourceTypeEnum.CASH)) {
            this.flag = true;
            info.setSourceType(SourceTypeEnum.CASH);
        } else {
            info.setSourceType(info.getPayBillType().getSourceSysType());
        }
        info.setSourceSysType(SourceTypeEnum.CASH);
        data = this.getData(hsData, "FOppAccountID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString(), this.cs064, this.flag));
        }
        if ((data = this.getData(hsData, "FPayeeTypeID")) != null && data.toString().trim().length() > 0) {
            info.setPayeeType(RecAndPayDataImportUtil2.getAsstActTypeByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"177_PaymentBillDataImport", (Locale)ctx.getLocale()), data.toString()));
        }
        if ((data = this.getData(hsData, "FBankNumber")) != null && data.toString().trim().length() > 0) {
            info.setBankNumber(data.toString());
        } else if (info.getPayeeBank() != null && info.getPayeeBank().trim().length() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("name", (Object)info.getPayeeBank().trim(), CompareType.EQUALS));
            filter2.getFilterItems().add(new FilterItemInfo("state", (Object)1, CompareType.EQUALS));
            view.setFilter(filter2);
            BEBankCollection coll = BEBankFactory.getLocalInstance((Context)ctx).getBEBankCollection(view);
            if (coll.size() > 0) {
                info.setBankNumber(coll.get(0).getNumber());
            }
        }
        String companyID = null;
        data = this.getData(hsData, "FPayeeNumber");
        if (data != null && data.toString().trim().length() > 0) {
            if (info.getPayeeType() == null) {
                info.setPayeeName(data.toString());
                info.setPayeeNumber(data.toString());
                EntityViewInfo view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)data.toString().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (companyColl != null && companyColl.size() > 0) {
                    companyID = companyColl.get(0).getId().toString();
                }
            } else {
                IRowSet asstActInfo = RecAndPayDataImportUtil2.getAsstActInfo(info.getPayeeType(), data.toString(), ctx);
                try {
                    if (asstActInfo.next()) {
                        info.setPayeeID(asstActInfo.getString("fid"));
                        info.setPayeeNumber(asstActInfo.getString("fnumber"));
                        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                        info.setPayeeName(asstActInfo.getString("fname_" + loc));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
        }
        if ((data = this.getData(hsData, "FPayeeBank")) != null && data.toString().trim().length() > 0) {
            info.setPayeeBank(data.toString());
        }
        if ((data = this.getData(hsData, "FPayeeAccountBank")) != null && data.toString().trim().length() > 0) {
            info.setPayeeAccountBank(data.toString());
            info.setPayeeAccountBankO(RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"47_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), companyID, data.toString(), false, true));
        }
        if (EmptyUtil.isEmpty((String)info.getPayeeBank()) && !EmptyUtil.isEmpty((String)info.getPayeeID())) {
            SelectorItemCollection spcSelector;
            SelectorItemCollection sic;
            if (BOSUuid.read((String)info.getPayeeID()).getType().equals((Object)new SupplierInfo().getBOSType())) {
                ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("province.*"));
                sic.add(new SelectorItemInfo("city.*"));
                SupplierInfo realSupplier = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), sic);
                if (!EmptyUtil.isEmpty((CoreBaseInfo)realSupplier.getProvince()) && !EmptyUtil.isEmpty((CoreBaseInfo)realSupplier.getCity())) {
                    info.setRecProvince(realSupplier.getProvince().getName());
                    info.setRecCity(realSupplier.getCity().getName());
                }
                info.setBankAcctName(realSupplier.getName());
                spcSelector = new SelectorItemCollection();
                spcSelector.add(new SelectorItemInfo("id"));
                spcSelector.add(new SelectorItemInfo("supplierBank.id"));
                spcSelector.add(new SelectorItemInfo("supplierBank.bank"));
                spcSelector.add(new SelectorItemInfo("supplierBank.bankAccount"));
                SupplierCompanyInfoInfo supplierCompany = iSupplier.getCompanyInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
                if (supplierCompany != null && supplierCompany.getSupplierBank() != null && supplierCompany.getSupplierBank().size() > 0) {
                    SupplierCompanyBankCollection coll = supplierCompany.getSupplierBank();
                    for (int i = 0; i < coll.size(); ++i) {
                        SupplierCompanyBankInfo sBankInfo = coll.get(i);
                        if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) || !info.getPayeeAccountBank().equals(sBankInfo.getBankAccount())) continue;
                        info.setPayeeBank(sBankInfo.getBank());
                    }
                }
            } else if (BOSUuid.read((String)info.getPayeeID()).getType().equals((Object)new CustomerInfo().getBOSType())) {
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("province.*"));
                sic.add(new SelectorItemInfo("city.*"));
                CustomerInfo realCustomer = iCustomer.getCustomerInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), sic);
                if (!EmptyUtil.isEmpty((CoreBaseInfo)realCustomer.getProvince()) && !EmptyUtil.isEmpty((CoreBaseInfo)realCustomer.getCity())) {
                    info.setRecProvince(realCustomer.getProvince().getName());
                    info.setRecCity(realCustomer.getCity().getName());
                }
                info.setBankAcctName(realCustomer.getName());
                spcSelector = new SelectorItemCollection();
                spcSelector.add(new SelectorItemInfo("id"));
                spcSelector.add(new SelectorItemInfo("customerBank.id"));
                spcSelector.add(new SelectorItemInfo("customerBank.bank"));
                spcSelector.add(new SelectorItemInfo("customerBank.bankAccount"));
                CustomerCompanyInfoInfo customerCompany = iCustomer.getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(info.getPayeeID()), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), spcSelector);
                if (customerCompany != null && customerCompany.getCustomerBank() != null && customerCompany.getCustomerBank().size() > 0) {
                    CustomerCompanyBankCollection coll = customerCompany.getCustomerBank();
                    for (int i = 0; i < coll.size(); ++i) {
                        CustomerCompanyBankInfo sBankInfo = coll.get(i);
                        if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) || !sBankInfo.getBankAccount().equals(info.getPayeeAccountBank())) continue;
                        info.setPayeeBank(sBankInfo.getBank());
                    }
                }
            }
        }
        if (!EmptyUtil.isEmpty((String)info.getPayeeBank())) {
            BEBankInfo beBank = RecAndPayDataImportUtil2.getBeBankByName(ctx, info.getPayeeBank());
            if (info != null && beBank != null) {
                info.setBankNumber(beBank.getNumber());
                info.setRecProvince(beBank.getBeProvince());
                info.setRecCity(beBank.getBeCity());
            } else {
                logger.error((Object)("\u4ed8\u6b3e\u5355\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u627e\u5bf9\u5bf9\u5e94\u7684\u884c\u540d\u884c\u53f7\uff0c\u6536\u6b3e\u94f6\u884c=" + info.getPayeeBank()));
            }
            data = this.getData(hsData, "FRecCountry");
            if (data != null && data.toString().trim().length() > 0) {
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)data.toString().trim()));
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(filter);
                CountryCollection countryColl = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(view);
                info.setFRecCountry(countryColl.get(0));
            }
        }
        if ((data = this.getData(hsData, "FCostCenter")) != null && data.toString().trim().length() > 0) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(data.toString(), ctx, info.getCompany().getId().toString()));
        }
        if (info.getPayeeAccountBankO() != null) {
            info.setOppInnerAcct(info.getPayeeAccountBankO().getInnerAcct());
        } else {
            info.setOppInnerAcct(null);
        }
        info.setIsInitializeBill(false);
        info.setIsImport(true);
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        return info;
    }

    private boolean isExistHead(Hashtable hsData, Context ctx) throws BOSException {
        CompanyOrgUnitInfo currCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String company = currCompany.getNumber();
        String number = (String)this.getData(hsData, "FNumber");
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        evi.setFilter(filter);
        PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(evi);
        if (coll != null && coll.size() > 1) {
            throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"22_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        return false;
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException {
        try {
            PaymentBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx, PaymentBillEntryInfo info, String companyId) throws BOSException, EASBizException {
        this.prepareImport(ctx, (IObjectValue)info, hsData, "entries");
        Object data = null;
        info.setPaymentBill(RecAndPayDataImportUtil2.getPaymentBillByNumber(hsData, ctx));
        data = this.getData(hsData, "FRemark");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FEntries_outBgItemNumber")) != null && data.toString().trim().length() > 0) {
            BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(data.toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"23_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
            info.setOutBgItemNumber(data.toString());
            info.setOutBgItemId(bgItemInfo.getId().toString());
            info.setOutBgItemName(bgItemInfo.getName());
        }
        if ((data = this.getData(hsData, "FEntryExpenseType")) != null && data.toString().trim().length() > 0) {
            info.setExpenseType(RecAndPayDataImportUtil2.getExpenseTypeByNumber(data.toString(), ctx));
        }
        if ((data = this.getData(hsData, "FEntryRemark")) != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        if ((data = this.getData(hsData, "FEntryCostCenter")) != null && data.toString().trim().length() > 0) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(data.toString(), ctx, companyId));
        }
        if ((data = this.getData(hsData, "FEntryFundFlowItem")) != null && data.toString().trim().length() > 0) {
            info.setFundFlowItem(RecAndPayDataImportUtil2.getFundFlowItemByNumber(data.toString(), ctx));
        }
        CurrencyInfo currency = null;
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            currency = RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString());
        } else {
            try {
                currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getPaymentBill().getCompany());
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.cs074 ? this.getData(hsData, "FEntryActualAmt") : this.getData(hsData, "FActualAmt");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                if (data.toString().contains(",")) {
                    Double douData = new DecimalFormat().parse(data.toString()).doubleValue();
                    info.setActualAmt(new BigDecimal(douData).setScale(currency.getPrecision(), 4));
                } else {
                    info.setActualAmt(new BigDecimal(data.toString()).setScale(currency.getPrecision(), 4));
                }
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"178_PaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FEntryOppAccID")) != null && data.toString().trim().length() > 0 && currency != null) {
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"179_PaymentBillDataImport", (Locale)ctx.getLocale()), companyId, currency.getId().toString(), data.toString(), this.cs064, this.flag));
        }
        if (EmptyUtil.isEmpty((Object)info.getId())) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        return info;
    }

    @Override
    protected String getTemplateNumber() {
        return "payingBill";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.cas.CasPaymentBillQuery";
    }

    @Override
    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String entryID;
            String payeeName;
            String FEntryFundFlowItem;
            String FEntryCostCenter;
            String FEntryExpenseType;
            String FEntryRemark;
            BigDecimal FEntryActualAmt;
            String BgItem;
            String entryBgItem;
            String payeeBank;
            String payeeAccountBank;
            java.sql.Date bizDate;
            String entryOppAccount;
            String payeeNumber;
            String payeeType;
            String payBillType;
            String description;
            String oppAccount;
            String settlementNumber;
            String settlementType;
            String feeTypeId;
            String bizType;
            String payerAccountBank;
            String payerAccount;
            BigDecimal exchangeRate;
            String currency;
            BigDecimal actualLocalAmt;
            BigDecimal actualAmt;
            String companyID;
            String number;
            String usage;
            Boolean fivouchered = rs.getBoolean("fivouchered");
            if (fivouchered != null) {
                result.put("FFiVouchered", fivouchered);
            }
            if ((usage = this.getString(rs, "usage")) != null) {
                result.put("FUsage", usage);
            }
            if ((number = this.getString(rs, "number")) != null) {
                result.put("FNumber", number);
            }
            if ((companyID = this.getString(rs, "company.number")) != null) {
                result.put("FCompanyID", companyID);
            }
            if ((actualAmt = rs.getBigDecimal("actPayAmt")) != null) {
                result.put("FActualAmt", actualAmt);
            }
            if ((actualLocalAmt = rs.getBigDecimal("actPayLocAmt")) != null) {
                result.put("FActualLocAmt", actualLocalAmt);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrencyID", currency);
            }
            if ((exchangeRate = rs.getBigDecimal("exchangeRate")) != null) {
                result.put("FExchangeRate", exchangeRate);
            }
            if ((payerAccount = this.getString(rs, "payerAccount.number")) != null) {
                result.put("FPayerAccountID", payerAccount);
            }
            if ((payerAccountBank = this.getString(rs, "payerAccountBank.number")) != null) {
                result.put("FPayerAccountBankID", payerAccountBank);
            }
            if ((bizType = this.getString(rs, "bizType.number")) != null) {
                result.put("FBizTypeID", bizType);
            }
            if ((feeTypeId = this.getString(rs, "feeType.number")) != null) {
                result.put("FFeeTypeID", feeTypeId);
            }
            if ((settlementType = this.getString(rs, "settlementType.number")) != null) {
                result.put("FSettlementTypeID", settlementType);
            }
            if ((settlementNumber = this.getString(rs, "settlementNumber")) != null) {
                result.put("FSettlementNumber", settlementNumber);
            }
            if ((oppAccount = this.getString(rs, "oppAccount.number")) != null) {
                result.put("FOppAccountID", oppAccount);
            }
            if ((description = this.getString(rs, "description")) != null) {
                result.put("FDescription", description);
            }
            if ((payBillType = this.getString(rs, "payBillType.number")) != null) {
                result.put("FPayBillTypeID", payBillType);
            }
            if ((payeeType = this.getString(rs, "payeeType.number")) != null) {
                result.put("FPayeeTypeID", payeeType);
            }
            if ((payeeNumber = this.getString(rs, "payeeNumber")) != null) {
                result.put("FPayeeNumber", payeeNumber);
            }
            if ((entryOppAccount = this.getString(rs, "entries.oppAccount.number")) != null) {
                result.put("FEntryOppAccID", entryOppAccount);
            }
            if ((bizDate = rs.getDate("bizDate")) != null) {
                result.put("FBizDate", DateTimeUtils.format((Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((payeeAccountBank = this.getString(rs, "payeeAccountBank")) != null) {
                result.put("FPayeeAccountBank", payeeAccountBank);
            }
            if ((payeeBank = this.getString(rs, "payeeBank")) != null) {
                result.put("FPayeeBank", payeeBank);
            }
            if ((entryBgItem = this.getString(rs, "entries.outBgItemNumber")) != null) {
                result.put("FEntries_outBgItemNumber", entryBgItem);
            }
            if ((BgItem = this.getString(rs, "outBgItemNumber")) != null) {
                result.put("outBgItemNumber", BgItem);
            }
            if ((FEntryActualAmt = rs.getBigDecimal("entries.actualAmt")) != null) {
                result.put("FEntryActualAmt", FEntryActualAmt);
            }
            if ((FEntryRemark = this.getString(rs, "entries.remark")) != null) {
                result.put("FEntryRemark", FEntryRemark);
            }
            if ((FEntryExpenseType = this.getString(rs, "expenseType.number")) != null) {
                result.put("FEntryExpenseType", FEntryExpenseType);
            }
            if ((FEntryCostCenter = this.getString(rs, "entries.costCenter.number")) != null) {
                result.put("FEntryCostCenter", FEntryCostCenter);
            }
            if ((FEntryFundFlowItem = this.getString(rs, "entries.fundFlowItem.number")) != null) {
                result.put("FEntryFundFlowItem", FEntryFundFlowItem);
            }
            if ((payeeName = this.getString(rs, "payeeName")) != null) {
                result.put("FPayeeName", payeeName);
            }
            if (!EmptyUtil.isEmpty((String)(entryID = this.getString(rs, "entries.id")))) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("asstActType.name"));
                EntityViewInfo view = EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, null);
                AssItemsForCashPayCollection assColl = AssItemsForCashPayFactory.getLocalInstance(ctx).getAssItemsForCashPayCollection(view);
                if (assColl != null && assColl.size() > 0) {
                    int j = assColl.size();
                    for (int i = 0; i < j; ++i) {
                        AssItemsForCashPayInfo assInfo = assColl.get(i);
                        if (assInfo.getAsstActType() != null && assInfo.getAsstActType().getName() != null) {
                            result.put("FAssType" + (i + 1), assInfo.getAsstActType().getName());
                        }
                        if ("T_BD_GeneralAsstActType".equals(assInfo.getTableName())) {
                            if (!EmptyUtil.isEmpty((String)assInfo.getFromID())) {
                                ObjectUuidPK pk = new ObjectUuidPK(assInfo.getFromID());
                                GeneralAsstActTypeInfo info = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeInfo((IObjectPK)pk);
                                result.put("FAssNumber" + (i + 1), info.getLongNumber().replaceAll("!", "."));
                            }
                        } else if (assInfo.getFromNumber() != null) {
                            result.put("FAssNumber" + (i + 1), assInfo.getFromNumber());
                        }
                        if (EmptyUtil.isEmpty((String)assInfo.getFromID())) continue;
                        CoreBaseInfo entityInfo = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(assInfo.getFromID());
                        result.put("FAssName" + (i + 1), entityInfo.get("name"));
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            PaymentBillInfo info = (PaymentBillInfo)coreBaseInfo;
            if (BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) || BillStatusEnum.SUBMIT.equals((Object)info.getBillStatus())) {
                this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"14_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
    }

    private AssItemsForCashPayInfo parseAssItem(Hashtable hsData, Context ctx, AsstActTypeInfo assTypeInfo, AssItemsForCashPayInfo info, int assIndex, PaymentBillEntryInfo entry) throws BOSException {
        Object data = null;
        data = this.getData(hsData, "FAssType" + assIndex);
        if (data != null && data.toString().trim().length() > 0) {
            info.setAsstActType(assTypeInfo);
            info.setEntrySeq(entry.getSeq());
            info.setIsSelected(false);
            info.setEntryParent(entry);
            info.setMappingFileds(assTypeInfo.getMappingFieldName());
            info.setTableName(assTypeInfo.getRealtionDataObject());
            String assNumber = (String)this.getData(hsData, "FAssNumber" + assIndex);
            if (assNumber != null && assNumber.trim().length() > 0) {
                DataBaseInfo assObj = this.getAsstActObject(ctx, assTypeInfo, assNumber);
                if (assObj != null) {
                    if (assObj instanceof ProjectInfo && 2 == ((ProjectInfo)assObj).getStatus().getValue()) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"471_projectClosed", (Locale)ctx.getLocale(), (Object[])new Object[]{assNumber}));
                    }
                    info.setIsSelected(true);
                    info.setFromNumber(assObj.getNumber());
                    info.setFromID(assObj.getId().toString());
                } else {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"180_PaymentBillDataImport", (Locale)ctx.getLocale()) + assNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"173_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
            }
        }
        return info;
    }

    private AssItemsForCashPayInfo getAssItemInfo(Context ctx, int mode, String entryId, AssItemsForCashPayCollection assCol, AsstActTypeInfo assTypeInfo) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (entryId == null || assCol == null || assCol.size() == 0) {
                return new AssItemsForCashPayInfo();
            }
            try {
                Iterator it = assCol.iterator();
                while (it.hasNext()) {
                    AssItemsForCashPayInfo info = (AssItemsForCashPayInfo)it.next();
                    if (!info.getAsstActType().getId().equals((Object)assTypeInfo.getId())) continue;
                    return info;
                }
                return new AssItemsForCashPayInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        return new AssItemsForCashPayInfo();
    }
}

