/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashCommonException;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.RecPayDataImportBaseVerify;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Locale;
import org.apache.log4j.Logger;

public class PaymentBillImportVerify
extends RecPayDataImportBaseVerify {
    private static Logger logger = Logger.getLogger((String)PaymentBillImportVerify.class.getName());

    @Override
    public void verifyHead(Context ctx, CoreBaseInfo head) throws TaskExternalException {
        SourceTypeEnum sourceType;
        if (!(head instanceof PaymentBillInfo)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"25_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        PaymentBillInfo info = (PaymentBillInfo)head;
        CompanyOrgUnitInfo companyInfo = info.getCompany();
        if (null == companyInfo) {
            throw new TaskExternalException(new CashCommonException(CashCommonException.NULL_COMPANY).getMessage());
        }
        if (info.getSourceType() == null) {
            info.setSourceType(SourceTypeEnum.AP);
        }
        if (!(sourceType = info.getSourceType()).equals((Object)SourceTypeEnum.AP) && !sourceType.equals((Object)SourceTypeEnum.CASH)) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"181_PaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
        this.checkEmpty(ctx, info.getBizDate(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"26_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        SystemEnum systemEnum = null;
        PeriodInfo currentPeriod = null;
        if (sourceType.equals((Object)SourceTypeEnum.AP)) {
            systemEnum = SystemEnum.ACCOUNTSPAYABLE;
            try {
                currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"89_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"89_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            if (info.getBizDate().compareTo(currentPeriod.getBeginDate()) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"90_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        } else {
            systemEnum = SystemEnum.CASHMANAGEMENT;
            try {
                currentPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)systemEnum, (CompanyOrgUnitInfo)companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"91_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e);
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"91_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + e.getMessage());
            }
            if (info.getBizDate().compareTo(currentPeriod.getBeginDate()) < 0) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"92_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
            }
        }
        this.checkEmpty(ctx, info.getCurrency(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"27_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        CurrencyInfo currency = info.getCurrency();
        this.checkEmpty(ctx, info.getExchangeRate(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"28_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        if (info.getExchangeRate().compareTo(FMConstants.ZERO) < 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"29_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        CurrencyInfo localCurrency = companyInfo.getBaseCurrency();
        if (localCurrency != null && currency.getId().equals((Object)localCurrency.getId()) && info.getExchangeRate().compareTo(FMConstants.ONE) != 0) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"30_AgentPayBillImportVerify", (Locale)ctx.getLocale()));
        }
        this.checkEmpty(ctx, info.getPayBillType(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"182_PaymentBillImportVerify", (Locale)ctx.getLocale()));
        this.checkPayType(info);
        if (info.getPayerAccountBank() != null && info.getPayerAccountBank().getAccount() != null && !info.getPayerAccount().getId().equals((Object)info.getPayerAccountBank().getAccount().getId())) {
            throw new TaskExternalException(this.getCASAutoGenerateResource(ctx, "519_PAYACCOUNT_NOTMATCH_PAYACCOUNT"));
        }
        if (info.getOppAccount() != null && (info.getOppAccount().isIsBank() || info.getOppAccount().isIsCash())) {
            throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"183_PaymentBillImportVerify", (Locale)ctx.getLocale()));
        }
    }

    private void checkPayType(PaymentBillInfo info) throws TaskExternalException {
        if (StringUtils.isEmpty((String)info.getPayBillType().getNumber())) {
            return;
        }
    }

    @Override
    public void verifyEntry(Context ctx, CoreBaseInfo entry, SourceTypeEnum type) throws TaskExternalException {
        if (!(entry instanceof PaymentBillEntryInfo)) {
            throw new TaskExternalException(this.getCASAutoGenerateResource(ctx, "99_CasPaymentBillImportVerify"));
        }
        PaymentBillEntryInfo info = (PaymentBillEntryInfo)entry;
        if (type.equals((Object)SourceTypeEnum.CASH)) {
            info.setAmount(null);
            info.setLocalAmt(null);
            info.setRebate(null);
            info.setRebateLocAmt(null);
        } else if (type.equals((Object)SourceTypeEnum.AP) || type.equals((Object)SourceTypeEnum.AR)) {
            if (info.getAmount() == null) {
                info.setAmount(CasConstants.ZERO);
            }
            if (info.getRebate() == null) {
                info.setRebate(CasConstants.ZERO);
            }
            if (info.getActualAmt() == null) {
                info.setActualAmt(CasConstants.ZERO);
            }
            BigDecimal temp1 = info.getAmount().subtract(info.getRebate());
            if (info.getActualAmt().compareTo(temp1) != 0) {
                throw new TaskExternalException(this.getCASAutoGenerateResource(ctx, "100_CasPaymentBillImportVerify"));
            }
            if (info.getLocalAmt() == null) {
                info.setLocalAmt(CasConstants.ZERO);
            }
            if (info.getRebateLocAmt() == null) {
                info.setRebateLocAmt(CasConstants.ZERO);
            }
            if (info.getActualLocAmt() == null) {
                info.setActualLocAmt(CasConstants.ZERO);
            }
            temp1 = info.getLocalAmt().subtract(info.getRebateLocAmt());
            if (info.getActualLocAmt().compareTo(temp1) != 0) {
                throw new TaskExternalException(this.getCASAutoGenerateResource(ctx, "102_CasPaymentBillImportVerify"));
            }
        }
    }
}

