/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.AutoMatchAcctSettingFactory;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentBillSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.PaymentBillSmartFilter");

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String operatorNumber = busiInfo.getOperatorNumber();
        String queryOql = "";
        try {
            FilterInfo filterInfo = new FilterInfo(filterSql);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String compareOp;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String filterValue = "";
                    Object cmpVal = filterItemInfo.getCompareValue();
                    if (cmpVal != null) {
                        filterValue = cmpVal.toString();
                    }
                    if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endValue = "";
                    try {
                        Date date = df.parse(filterValue);
                        date.setTime(date.getTime() + 1000L);
                        endValue = df.format(date);
                        if (EmptyUtil.isEmpty((String)endValue)) continue;
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id,number where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("PaymentBillSmartFilter============" + iexec.getSQL() + " and fissmart in (1,3) and (FFundDispatchType = 0 or FFundDispatchType is null) "));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL() + " and fissmart in (1,3) and (FFundDispatchType = 0 or FFundDispatchType is null)  ");
        ArrayList settle_result = new ArrayList();
        boolean auditSettle = false;
        if (!EmptyUtil.isEmpty((String)companyID)) {
            auditSettle = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS026", (IObjectPK)new ObjectUuidPK(companyID));
        }
        if ((InterfaceTypeEnum.pay_settle.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_audit_approve_commitSettle.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_submit_audit_approve_submitSettle.getName().equals(operatorNumber)) && !EmptyUtil.isEmpty(result) || auditSettle && (InterfaceTypeEnum.pay_audit_approve.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_submit_audit_approve.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_submit_audit_approve_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_audit_approve_pay.getName().equals(operatorNumber))) {
            Set set = FMHelper.list2Set(result);
            if (EmptyUtil.isEmpty((Collection)set) || set.size() == 0) {
                return result;
            }
            String sql = "select a.fid id ,FRelatedCompanyId number from t_cas_paymentbill a ,T_BD_AccountBanks b ,T_BD_Bank c where a.FPayerAccountBankID = b.fid and b.FBank = c.fid and " + StringUtil.buildIn((String)"a.fid", (Object[])set.toArray());
            Map idMap = this.getSourceBillRowSetNumber(ctx, sql);
            if (!EmptyUtil.isEmpty((Object)idMap)) {
                idMap = AutoMatchAcctSettingFactory.getLocalInstance((Context)ctx).getCompanyStatus(idMap);
                for (Object key : idMap.keySet()) {
                    if (!((Boolean)idMap.get(key)).booleanValue()) continue;
                    settle_result.add(key);
                }
            }
            return settle_result;
        }
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"156_FundDispatchBillSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"157_FundDispatchBillSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(filterSql);
            }
        } else {
            result.append(filterSql);
        }
        String operatorNumber = busiInfo.getOperatorNumber();
        if (InterfaceTypeEnum.pay_settle.getName().equals(operatorNumber)) {
            result.append(" and ").append(" settlementStatus = 10 ");
        }
        if (InterfaceTypeEnum.pay_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_submit_audit_approve.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_submit_audit_approve_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_submit_audit_approve_commitBank.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_submit_audit_approve_submitSettle.getName().equals(operatorNumber)) {
            result.append(" and billStatus in (10,11) ");
        }
        if (InterfaceTypeEnum.pay_audit_approve.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_audit_approve_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_audit_approve_commitBank.getName().equals(operatorNumber) || "pay_audit_approve_commitBank_bill".equals(operatorNumber) || InterfaceTypeEnum.pay_audit_approve_commitSettle.getName().equals(operatorNumber)) {
            result.append(" and billStatus in (11,8)");
        }
        if (InterfaceTypeEnum.pay_audit.getName().equals(operatorNumber)) {
            result.append(" and billStatus in (11)");
        }
        if (InterfaceTypeEnum.pay_pay.getName().equals(operatorNumber) || InterfaceTypeEnum.pay_commitBank.getName().equals(operatorNumber) || "pay_commitBank_bill".equals(operatorNumber) || InterfaceTypeEnum.pay_settle.getName().equals(operatorNumber)) {
            result.append(" and billStatus = 12 ");
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap map = new HashMap();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        String companyID = "" + paramMap.get("companyID");
        String auditor = "";
        String payer = "";
        String approve = "";
        String creator = "";
        if (schemaInfo != null && schemaInfo.getAuditor() != null) {
            auditor = schemaInfo.getAuditor().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getPayer() != null) {
            payer = schemaInfo.getPayer().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getApprove() != null) {
            approve = schemaInfo.getApprove().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getOriginator() != null) {
            creator = schemaInfo.getOriginator().getId().toString();
        }
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            String msg;
            BankPayResult bankResult;
            StringBuffer failMsg;
            Set bankSet;
            Object[] params;
            PaymentBillInfo info;
            Object[] params2;
            String msg2;
            Set set;
            String sql;
            HashSet set2;
            Object[] params3;
            String msg3;
            PaymentBillInfo info2;
            HashSet auditSet;
            String operatorNumber = busiInfo.getOperatorNumber();
            IPaymentBill biz = PaymentBillFactory.getLocalInstance(ctx);
            boolean mustAuditParam = false;
            if (!EmptyUtil.isEmpty((String)companyID)) {
                mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(companyID));
            }
            boolean auditSettle = false;
            if (!EmptyUtil.isEmpty((String)companyID)) {
                auditSettle = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS026", (IObjectPK)new ObjectUuidPK(companyID));
            }
            boolean cs062 = false;
            if (!EmptyUtil.isEmpty((String)companyID)) {
                cs062 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS062", (IObjectPK)new ObjectUuidPK(companyID));
            }
            String sqlFailMsg = "UPDATE T_CAS_PaymentBill SET fsettleFailMsg = ? where fid = ?";
            if (InterfaceTypeEnum.pay_submit.getName().equals(operatorNumber)) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        e.printStackTrace();
                        String msg4 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg4) && msg4.length() > 2000) {
                            msg4 = msg4.substring(0, 2000);
                        }
                        Object[] params4 = new Object[]{msg4, billList.get(i).toString()};
                        paramList.add(params4);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.pay_audit.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        HashSet set3 = new HashSet();
                        set3.add(billList.get(i));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info2 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info2.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            biz.approve(set3);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        msg3 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                            msg3 = msg3.substring(0, 2000);
                        }
                        params3 = new Object[]{msg3, billList.get(i).toString()};
                        paramList.add(params3);
                    }
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.pay_audit_approve.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                HashSet approveSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        PaymentBillInfo info3 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info3.getCompany().getId().toString()));
                            auditSettle = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS026", (IObjectPK)new ObjectUuidPK(info3.getCompany().getId().toString()));
                        }
                        if (mustAuditParam && info3.getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
                            biz.approve(set2);
                            if (!EmptyUtil.isEmpty((String)approve)) {
                                approveSet.add(billList.get(i));
                            }
                        }
                        String sql2 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql2, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set2);
                        if (!EmptyUtil.isEmpty((String)auditor)) {
                            auditSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg5 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg5) && msg5.length() > 2000) {
                            msg5 = msg5.substring(0, 2000);
                        }
                        Object[] params5 = new Object[]{msg5, billList.get(i).toString()};
                        paramList.add(params5);
                    }
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(approveSet) && auditSettle) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])approveSet.toArray()) + "   ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    sql = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    String sql1 = "UPDATE T_FS_SettlementBill settle  SET  FApproverID  = (SELECT FAUDITORID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql1);
                    String sql2 = "UPDATE T_FS_SettlementBill settle  SET  FEnCreatorid  = (SELECT Fcreatorid  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.pay_pay.getName().equals(operatorNumber)) {
                HashSet payerSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        HashSet set4 = new HashSet();
                        set4.add(billList.get(i));
                        biz.pay(set4);
                        if (!EmptyUtil.isEmpty((String)payer)) {
                            payerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        msg3 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                            msg3 = msg3.substring(0, 2000);
                        }
                        params3 = new Object[]{msg3, billList.get(i).toString()};
                        paramList.add(params3);
                    }
                }
                if (!EmptyUtil.isEmpty(payerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.pay_commitBank.getName().equals(operatorNumber)) {
                set = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    PaymentBillInfo info4 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                    if (info4.getSettlementStatus().getValue() == 12 || info4.getSettlementStatus().getValue() == 11) continue;
                    set.add(billList.get(i));
                }
                if (!EmptyUtil.isEmpty(set)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])set.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(set)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, set, 2);
                    if (verifyChongMap != null) {
                        set = (Set)verifyChongMap.get("idSetCorrectNew");
                        ArrayList resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d===" + resultChongFuList));
                        Set chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d=chongFuSet==" + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i = 0; i < chongFuSet.size(); ++i) {
                                StringBuffer failMsg2 = new StringBuffer(" UPDATE T_CAS_PaymentBill SET FSETTLEFAILMSG = ? where fid = ? ");
                                BankPayResult bankResult2 = (BankPayResult)resultChongFuList.get(i);
                                String msg6 = bankResult2.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg6) && msg6.length() > 2000) {
                                    msg6 = msg6.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg2.toString(), (Object[])new Object[]{msg6, bankResult2.getId()});
                            }
                        }
                    }
                    try {
                        ArrayList resultList = biz.commitToBENewBatch(set);
                        StringBuffer sb = new StringBuffer();
                        sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])set.toArray()) + "  ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                        success = set.size();
                        for (int j = 0; j < resultList.size(); ++j) {
                            BankPayResult resultInfo = (BankPayResult)resultList.get(j);
                            if (resultInfo.getErrorDetail() == null) continue;
                            msg2 = resultInfo.getErrorDetail();
                            if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                                msg2 = msg2.substring(0, 2000);
                            }
                            params2 = new Object[]{msg2, resultInfo.getId()};
                            paramList.add(params2);
                        }
                    }
                    catch (Exception e) {
                        failure = set.size();
                        errorMsg = errorMsg + e.getMessage();
                        e.printStackTrace();
                    }
                    if (!EmptyUtil.isEmpty(paramList)) {
                        DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                    }
                }
            }
            if ("pay_commitBank_bill".equals(operatorNumber)) {
                set = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    PaymentBillInfo info5 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                    if (info5.getSettlementStatus().getValue() == 12 || info5.getSettlementStatus().getValue() == 11) continue;
                    set.add(billList.get(i));
                }
                if (!EmptyUtil.isEmpty(set)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])set.toArray()) + " ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                    Map verifyChongMap = this.verifyChongFuNew(ctx, set, 2);
                    if (verifyChongMap != null) {
                        set = (Set)verifyChongMap.get("idSetCorrectNew");
                        ArrayList resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d===" + resultChongFuList));
                        Set chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d=chongFuSet==" + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i = 0; i < chongFuSet.size(); ++i) {
                                StringBuffer failMsg3 = new StringBuffer(" UPDATE T_CAS_PaymentBill SET FSETTLEFAILMSG = ? where fid = ? ");
                                BankPayResult bankResult3 = (BankPayResult)resultChongFuList.get(i);
                                String msg7 = bankResult3.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg7) && msg7.length() > 2000) {
                                    msg7 = msg7.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg3.toString(), (Object[])new Object[]{msg7, bankResult3.getId()});
                            }
                        }
                    }
                    try {
                        ArrayList resultList = biz.commitToBENewBatch(set);
                        success = set.size();
                        sb = new StringBuffer();
                        sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])set.toArray()) + "  ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                        for (int j = 0; j < resultList.size(); ++j) {
                            BankPayResult resultInfo = (BankPayResult)resultList.get(j);
                            if (resultInfo.getErrorDetail() == null) continue;
                            msg2 = resultInfo.getErrorDetail();
                            if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                                msg2 = msg2.substring(0, 2000);
                            }
                            params2 = new Object[]{msg2, resultInfo.getId()};
                            paramList.add(params2);
                        }
                    }
                    catch (Exception e) {
                        failure = set.size();
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.pay_settle.getName().equals(operatorNumber)) {
                HashSet creatorSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        HashSet set5 = new HashSet();
                        set5.add(billList.get(i));
                        info2 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                        if (info2.getSettlementStatus().getValue() == 12 || info2.getSettlementStatus().getValue() == 11) continue;
                        biz.commitSettle(set5);
                        if (!EmptyUtil.isEmpty((String)creator)) {
                            creatorSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        msg3 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                            msg3 = msg3.substring(0, 2000);
                        }
                        Object[] params6 = new Object[]{msg3, billList.get(i).toString()};
                        paramList.add(params6);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(creatorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])creatorSet.toArray()) + "   ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    String sql3 = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql3);
                    String sql1 = "UPDATE T_FS_SettlementBill settle  SET  FApproverID  = (SELECT FAUDITORID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql1);
                    String sql2 = "UPDATE T_FS_SettlementBill settle  SET  FEnCreatorid  = (SELECT Fcreatorid  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
            }
            if (InterfaceTypeEnum.pay_submit_audit_approve.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                HashSet approveSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            PaymentBillInfo info6 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info6.getCompany().getId().toString()));
                            auditSettle = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS026", (IObjectPK)new ObjectUuidPK(info6.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            biz.approve(set2);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        String sql4 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql4, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set2);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg8 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg8) && msg8.length() > 2000) {
                            msg8 = msg8.substring(0, 2000);
                        }
                        Object[] params7 = new Object[]{msg8, billList.get(i).toString()};
                        paramList.add(params7);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(approveSet) && auditSettle) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])approveSet.toArray()) + "   ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    sql = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql);
                    String sql1 = "UPDATE T_FS_SettlementBill settle  SET  FApproverID  = (SELECT FAUDITORID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql1);
                    String sql2 = "UPDATE T_FS_SettlementBill settle  SET  FEnCreatorid  = (SELECT Fcreatorid  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
            }
            if (InterfaceTypeEnum.pay_submit_audit_approve_pay.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                HashSet approveSet = new HashSet();
                HashSet payerSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        HashSet set6 = new HashSet();
                        set6.add(billList.get(i));
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            PaymentBillInfo info7 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info7.getCompany().getId().toString()));
                            cs062 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS062", (IObjectPK)new ObjectUuidPK(info7.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            biz.approve(set6);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        String sql5 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql5, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set6);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if (((info = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info.getSettlementStatus().getValue() == 11) && cs062) continue;
                        biz.pay(set6);
                        if (!EmptyUtil.isEmpty((String)payer)) {
                            payerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg9 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg9) && msg9.length() > 2000) {
                            msg9 = msg9.substring(0, 2000);
                        }
                        params = new Object[]{msg9, billList.get(i).toString()};
                        paramList.add(params);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE ");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE ");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(payerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE ");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
            if (InterfaceTypeEnum.pay_submit_audit_approve_commitBank.getName().equals(operatorNumber)) {
                bankSet = new HashSet();
                HashSet auditSet2 = new HashSet();
                HashSet approveSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        HashSet set7 = new HashSet();
                        set7.add(billList.get(i));
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            PaymentBillInfo info8 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info8.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            biz.approve(set7);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet2.add(billList.get(i));
                            }
                        }
                        String sql6 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql6, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set7);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if ((info = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info.getSettlementStatus().getValue() == 11) continue;
                        bankSet.add(billList.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg10 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg10) && msg10.length() > 2000) {
                            msg10 = msg10.substring(0, 2000);
                        }
                        params = new Object[]{msg10, billList.get(i).toString()};
                        paramList.add(params);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet2)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet2.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet, 2);
                    if (verifyChongMap != null) {
                        bankSet = (Set)verifyChongMap.get("idSetCorrectNew");
                        ArrayList resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d===" + resultChongFuList));
                        Set chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d=chongFuSet==" + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i = 0; i < chongFuSet.size(); ++i) {
                                failMsg = new StringBuffer(" UPDATE T_CAS_PaymentBill SET FSETTLEFAILMSG = ? where fid = ? ");
                                bankResult = (BankPayResult)resultChongFuList.get(i);
                                msg = bankResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                                    msg = msg.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg.toString(), (Object[])new Object[]{msg, bankResult.getId()});
                            }
                        }
                    }
                    try {
                        biz.commitToBENewBatch(bankSet);
                        success = bankSet.size();
                        StringBuffer sb = new StringBuffer();
                        sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.pay_submit_audit_approve_submitSettle.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                HashSet approveSet = new HashSet();
                HashSet creatorSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        PaymentBillInfo info9;
                        HashSet set8 = new HashSet();
                        set8.add(billList.get(i));
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            PaymentBillInfo info10 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info10.getCompany().getId().toString()));
                            auditSettle = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS026", (IObjectPK)new ObjectUuidPK(info10.getCompany().getId().toString()));
                        }
                        if (mustAuditParam) {
                            biz.approve(set8);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        String sql7 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql7, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set8);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if ((info9 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info9.getSettlementStatus().getValue() == 11) continue;
                        biz.commitSettle(set8);
                        if (!EmptyUtil.isEmpty((String)creator)) {
                            creatorSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg11 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg11) && msg11.length() > 2000) {
                            msg11 = msg11.substring(0, 2000);
                        }
                        Object[] params8 = new Object[]{msg11, billList.get(i).toString()};
                        paramList.add(params8);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                    if (auditSettle) {
                        sb = new StringBuffer();
                        sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])approveSet.toArray()) + "   ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                        String sql8 = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                        DbUtil.execute((Context)ctx, (String)sql8);
                        String sql1 = "UPDATE T_FS_SettlementBill settle  SET  FApproverID  = (SELECT FAUDITORID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                        DbUtil.execute((Context)ctx, (String)sql1);
                        String sql2 = "UPDATE T_FS_SettlementBill settle  SET  FEnCreatorid  = (SELECT Fcreatorid  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                        DbUtil.execute((Context)ctx, (String)sql2);
                    }
                }
                if (!EmptyUtil.isEmpty(creatorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])creatorSet.toArray()) + "   ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    String sql9 = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql9);
                    String sql1 = "UPDATE T_FS_SettlementBill settle  SET  FApproverID  = (SELECT FAUDITORID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql1);
                    String sql2 = "UPDATE T_FS_SettlementBill settle  SET  FEnCreatorid  = (SELECT Fcreatorid  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
            }
            if (InterfaceTypeEnum.pay_audit_approve_pay.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                HashSet approveSet = new HashSet();
                HashSet payerSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        PaymentBillInfo info11;
                        PaymentBillInfo info12;
                        HashSet set9 = new HashSet();
                        set9.add(billList.get(i));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info12 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info12.getCompany().getId().toString()));
                            cs062 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS062", (IObjectPK)new ObjectUuidPK(info12.getCompany().getId().toString()));
                        }
                        if (mustAuditParam && (info12 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
                            biz.approve(set9);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        String sql10 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql10, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set9);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if (((info11 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info11.getSettlementStatus().getValue() == 11) && cs062) continue;
                        biz.pay(set9);
                        if (!EmptyUtil.isEmpty((String)payer)) {
                            payerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg12 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg12) && msg12.length() > 2000) {
                            msg12 = msg12.substring(0, 2000);
                        }
                        Object[] params9 = new Object[]{msg12, billList.get(i).toString()};
                        paramList.add(params9);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(payerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                }
            }
            if (InterfaceTypeEnum.pay_audit_approve_commitBank.getName().equals(operatorNumber)) {
                auditSet = new HashSet();
                HashSet approveSet = new HashSet();
                Set bankSet2 = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        PaymentBillInfo info13;
                        PaymentBillInfo info14;
                        HashSet set10 = new HashSet();
                        set10.add(billList.get(i));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info14 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info14.getCompany().getId().toString()));
                        }
                        if (mustAuditParam && (info14 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
                            biz.approve(set10);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet.add(billList.get(i));
                            }
                        }
                        String sql11 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql11, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set10);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if ((info13 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info13.getSettlementStatus().getValue() == 11) continue;
                        bankSet2.add(billList.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg13 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg13) && msg13.length() > 2000) {
                            msg13 = msg13.substring(0, 2000);
                        }
                        Object[] params10 = new Object[]{msg13, billList.get(i).toString()};
                        paramList.add(params10);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(bankSet2)) {
                    Map verifyChongMap = this.verifyChongFuNew(ctx, bankSet2, 2);
                    if (verifyChongMap != null) {
                        bankSet2 = (Set)verifyChongMap.get("idSetCorrectNew");
                        ArrayList resultChongFuList = (ArrayList)verifyChongMap.get("resultChongFuList");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d===" + resultChongFuList));
                        Set chongFuSet = new LinkedHashSet();
                        chongFuSet = (Set)verifyChongMap.get("chongFuSet");
                        logger.error((Object)("\u7591\u4f3c\u91cd\u590d=chongFuSet==" + chongFuSet));
                        if (chongFuSet != null && chongFuSet.size() > 0 && resultChongFuList != null && resultChongFuList.size() > 0) {
                            for (int i = 0; i < chongFuSet.size(); ++i) {
                                failMsg = new StringBuffer(" UPDATE T_CAS_PaymentBill SET FSETTLEFAILMSG = ? where fid = ? ");
                                bankResult = (BankPayResult)resultChongFuList.get(i);
                                msg = bankResult.getErrorDetail();
                                if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                                    msg = msg.substring(0, 2000);
                                }
                                DbUtil.execute((Context)ctx, (String)failMsg.toString(), (Object[])new Object[]{msg, bankResult.getId()});
                            }
                        }
                    }
                    try {
                        biz.commitToBENewBatch(bankSet2);
                        success = bankSet2.size();
                        StringBuffer sb = new StringBuffer();
                        sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet2.toArray()) + "  ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                    }
                    catch (Exception e) {
                        failure += bankSet2.size();
                        e.getMessage();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if ("pay_audit_approve_commitBank_bill".equals(operatorNumber)) {
                bankSet = new HashSet();
                HashSet auditSet3 = new HashSet();
                HashSet approveSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        PaymentBillInfo info15;
                        PaymentBillInfo info16;
                        HashSet set11 = new HashSet();
                        set11.add(billList.get(i));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info16 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info16.getCompany().getId().toString()));
                        }
                        if (mustAuditParam && (info16 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
                            biz.approve(set11);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet3.add(billList.get(i));
                            }
                        }
                        String sql12 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql12, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set11);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if ((info15 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info15.getSettlementStatus().getValue() == 11) continue;
                        bankSet.add(billList.get(i));
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg14 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg14) && msg14.length() > 2000) {
                            msg14 = msg14.substring(0, 2000);
                        }
                        Object[] params11 = new Object[]{msg14, billList.get(i).toString()};
                        paramList.add(params11);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet3)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet3.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(bankSet)) {
                    try {
                        biz.commitToBENewBatch(bankSet);
                        success = bankSet.size();
                        StringBuffer sb = new StringBuffer();
                        sb.append("UPDATE T_CAS_PaymentBill SET FCASHIERID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"fid", (Object[])bankSet.toArray()) + "  ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payer});
                    }
                    catch (Exception e) {
                        failure += bankSet.size();
                        e.getMessage();
                        errorMsg = errorMsg + e.getMessage();
                    }
                }
            }
            if (InterfaceTypeEnum.pay_audit_approve_commitSettle.getName().equals(operatorNumber)) {
                String sql2;
                bankSet = new HashSet();
                HashSet auditSet4 = new HashSet();
                HashSet approveSet = new HashSet();
                HashSet creatorSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        PaymentBillInfo info17;
                        PaymentBillInfo info18;
                        HashSet set12 = new HashSet();
                        set12.add(billList.get(i));
                        if (EmptyUtil.isEmpty((String)companyID)) {
                            info18 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                            mustAuditParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info18.getCompany().getId().toString()));
                            auditSettle = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS026", (IObjectPK)new ObjectUuidPK(info18.getCompany().getId().toString()));
                        }
                        if (mustAuditParam && (info18 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getBillStatus().equals((Object)BillStatusEnum.SUBMIT)) {
                            biz.approve(set12);
                            if (!EmptyUtil.isEmpty((String)auditor)) {
                                auditSet4.add(billList.get(i));
                            }
                        }
                        String sql13 = "UPDATE T_CAS_PaymentBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql13, (Object[])new Object[]{5, billList.get(i)});
                        biz.audit(set12);
                        if (!EmptyUtil.isEmpty((String)approve)) {
                            approveSet.add(billList.get(i));
                        }
                        if ((info17 = biz.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info17.getSettlementStatus().getValue() == 11) continue;
                        biz.commitSettle(set12);
                        if (!EmptyUtil.isEmpty((String)creator)) {
                            creatorSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        String msg15 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg15) && msg15.length() > 2000) {
                            msg15 = msg15.substring(0, 2000);
                        }
                        params2 = new Object[]{msg15, billList.get(i).toString()};
                        paramList.add(params2);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
                if (!EmptyUtil.isEmpty(auditSet4)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FApproverID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet4.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_PaymentBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])approveSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{approve});
                }
                if (!EmptyUtil.isEmpty(approveSet)) {
                    StringBuffer sb = new StringBuffer();
                    if (auditSettle) {
                        sb = new StringBuffer();
                        sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                        sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])approveSet.toArray()) + "   ");
                        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                        String sql14 = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                        DbUtil.execute((Context)ctx, (String)sql14);
                        String sql1 = "UPDATE T_FS_SettlementBill settle  SET  FApproverID  = (SELECT FAUDITORID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                        DbUtil.execute((Context)ctx, (String)sql1);
                        sql2 = "UPDATE T_FS_SettlementBill settle  SET  FEnCreatorid  = (SELECT Fcreatorid  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])approveSet.toArray()) + ") ";
                        DbUtil.execute((Context)ctx, (String)sql2);
                    }
                }
                if (!EmptyUtil.isEmpty(creatorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])creatorSet.toArray()) + "   ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    String sql15 = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql15);
                    String sql1 = "UPDATE T_FS_SettlementBill settle  SET  FApproverID  = (SELECT FAUDITORID  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql1);
                    sql2 = "UPDATE T_FS_SettlementBill settle  SET  FEnCreatorid  = (SELECT Fcreatorid  FROM T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_PaymentBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }

    public static void main(String args) {
        System.out.println("8");
    }

    public Map verifyChongFuNew(Context ctx, Set idSetCorrectNew, int actionType) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LinkedHashSet<String> chongFuSet = new LinkedHashSet<String>();
        LinkedHashMap allCompanyIdMap = new LinkedHashMap();
        LinkedHashMap<String, PaymentBillInfo> allCompanyInfoMap = new LinkedHashMap<String, PaymentBillInfo>();
        ArrayList<BankPayResult> resultChongFuList = new ArrayList<BankPayResult>();
        ArrayList idSetCorrectNewList = new ArrayList(idSetCorrectNew);
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
        Map resultMap = iPaymentBill.verifyChongFuNew(idSetCorrectNewList, actionType);
        if (resultMap != null && resultMap.size() > 0) {
            for (Object companyId : resultMap.keySet()) {
                HashMap map = (HashMap)resultMap.get(companyId);
                boolean isCS128 = (Boolean)map.get("isCS128");
                map.remove("days");
                map.remove("isCS128");
                allCompanyIdMap.putAll(map);
                HashSet allIdSet = new HashSet();
                for (Object id : map.keySet()) {
                    allIdSet.add(id);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", allIdSet, CompareType.INCLUDE));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("cpmpany.id"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("company.number"));
                sic.add(new SelectorItemInfo("actPayAmt"));
                sic.add(new SelectorItemInfo("currency.precision"));
                view.setSelector(sic);
                view.setFilter(filter);
                PaymentBillCollection coll = iPaymentBill.getPaymentBillCollection(view);
                for (int i = 0; i < coll.size(); ++i) {
                    allCompanyInfoMap.put(coll.get(i).getId().toString(), coll.get(i));
                }
                for (Object id : map.keySet()) {
                    PaymentBillInfo info = (PaymentBillInfo)allCompanyInfoMap.get(id);
                    List likedIdAndNumList = (List)map.get(id);
                    StringBuffer messageOne = new StringBuffer();
                    chongFuSet.add(id.toString());
                    String repeatNumber = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"136_CasPaymentPayRepeat", (Locale)ctx.getLocale(), (Object[])new Object[]{info.getNumber(), info.getActPayAmt()});
                    messageOne.append(info.getCompany().getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"137_Down", (Locale)ctx.getLocale()) + repeatNumber + "\n");
                    for (int i = 0; i < likedIdAndNumList.size(); ++i) {
                        String likedIdAndNum = (String)likedIdAndNumList.get(i);
                        String[] likedIdAndNumArr = likedIdAndNum.split(";");
                        messageOne.append(likedIdAndNumArr[1] + "     ");
                    }
                    messageOne.append("\n");
                }
            }
        }
        if (chongFuSet.size() > 0) {
            for (String id : chongFuSet) {
                PaymentBillInfo info = (PaymentBillInfo)allCompanyInfoMap.get(id);
                BankPayResult resultInfo = new BankPayResult();
                resultInfo.setId(id);
                resultInfo.setNumber(info.getNumber());
                StringBuffer errorDetail = new StringBuffer();
                List likedIdAndNumList = (List)allCompanyIdMap.get(id);
                StringBuffer newDetail = new StringBuffer();
                BigDecimal actPayAmt = Constants.ZERO;
                for (int i = 0; i < likedIdAndNumList.size(); ++i) {
                    String likedIdAndNum = (String)likedIdAndNumList.get(i);
                    String[] likedIdAndNumArr = likedIdAndNum.split(";");
                    newDetail.append(likedIdAndNumArr[1] + "     ");
                }
                int precision = info.getCurrency().getPrecision();
                BigDecimal actPayAmtShow = info.getActPayAmt().multiply(new BigDecimal(1)).setScale(precision, 4);
                NumberFormat nf = NumberFormat.getCurrencyInstance();
                nf.setMinimumFractionDigits(precision);
                String replace = nf.format(actPayAmtShow).replace("\uffe5", "");
                errorDetail.append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"247_PaymentBillSmartFilter", (Locale)ctx.getLocale()) + info.getCompany().getName() + "\uff0c");
                errorDetail.append(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"139_MayBeChongFu", (Locale)ctx.getLocale(), (Object[])new Object[]{replace}));
                errorDetail.append("\n");
                errorDetail.append(newDetail.toString());
                errorDetail.append("\n");
                resultInfo.setErrorDetail(errorDetail.toString());
                resultChongFuList.add(resultInfo);
            }
            idSetCorrectNew.removeAll(chongFuSet);
        }
        result.put("idSetCorrectNew", idSetCorrectNew);
        result.put("chongFuSet", chongFuSet);
        result.put("resultChongFuList", resultChongFuList);
        result.put("allCompanyIdMap", allCompanyIdMap);
        return result;
    }
}

