/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecuteOption;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.QueryDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IDSecondAuthorizeFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyFactory;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CountryCollection;
import com.kingdee.eas.basedata.assistant.CountryFactory;
import com.kingdee.eas.basedata.assistant.CountryInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.cas.AssItemsForCashPayCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashPayFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashPayInfo;
import com.kingdee.eas.fi.cas.AssItemsForTmplPayInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.DeepClone;
import com.kingdee.eas.fi.cas.DifPlaceEnum;
import com.kingdee.eas.fi.cas.FundDispatchTypeEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.ITemplatePaymentBill;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SettleFeeTypeEnum;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.TemplatePaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.TemplatePaymentBillFactory;
import com.kingdee.eas.fi.cas.TemplatePaymentBillInfo;
import com.kingdee.eas.fi.cas.app.AbstractPaymentBillWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteResult;
import com.kingdee.eas.fi.cas.app.mthread.PaymentCommitToBeServiceWeb;
import com.kingdee.eas.fi.cas.app.mthread.TaskManager;
import com.kingdee.eas.fi.cas.app.mthread.task.PaymentBillCommitToBeTask;
import com.kingdee.eas.fi.cas.app.service.PaymentBillVoucherAppointService;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.CasBosUtils;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fi.cas.utils.PeriodHelper;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.FmBeHelper;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.common.FMBooleanEnum;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.FmMbgHelper;
import com.kingdee.eas.fm.common.H;
import com.kingdee.eas.fm.fd.FDException;
import com.kingdee.eas.fm.fd.utils.FDUtils;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeFactory;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.nt.NTTypeGroupEnum;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryFactory;
import com.kingdee.eas.fm.ps.PaymentPlanBillEntryInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentBillWebFacadeControllerBean
extends AbstractPaymentBillWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.PaymentBillWebFacadeControllerBean");
    private static final String OPERATESTATE = "operateState";
    private Map company2Map = new HashMap();
    protected SelectorItemCollection sic = new SelectorItemCollection();

    @Override
    protected Map _save(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayBillType()) && !EmptyUtil.isEmpty((Object)info.getPayBillType().getSourceSysType())) {
            info.setSourceType(info.getPayBillType().getSourceSysType());
        }
        AsstActTypeCollection asstActTypeColl = this.getAsstActTypeColl(ctx, info.getCompany().getId().toString(), false, false);
        if (info.getPayeeType() != null && !asstActTypeColl.contains((Object)BOSUuid.read((String)info.getPayeeType().getId().toString()))) {
            info.setPayeeType(null);
        }
        this.checkPayeeTypeForSysApAr(info);
        this.checkBizDateBeforeSaveSubmit(ctx, info);
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            boolean isSrcBill;
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_02addNew");
            }
            this.transAsstAccount(ctx, info);
            this.transBgDimension(ctx, info);
            IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
            if (iPaymentBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                RecPayHelper.checkPSIsClose(ctx, info);
                boolean isBillInShareFlow = false;
                if (null != info && null != info.getId() && null != info.getBillStatus()) {
                    String billID = info.getId().toString();
                    isBillInShareFlow = CasForArApUtil.isBillInShareFlow(ctx, isBillInShareFlow, billID, info.getBillStatus().getValue(), 11);
                    logger.error((Object)("\u4fdd\u5b58\u5355\u636eID\u4e3a\uff1a" + billID + "\u5355\u636e\u662f\u5426\u5728\u5171\u4eab\u4e2d\uff1a" + isBillInShareFlow));
                    if (!isBillInShareFlow) {
                        FMHelper.CheckIsInWorkFlow((Context)ctx, (String)info.getId().toString());
                    }
                }
            }
            String sourceId = info.getSourceBillId();
            boolean isFromPayPlan = false;
            if (sourceId != null) {
                BOSObjectType bosType = BOSUuid.read((String)sourceId).getType();
                isFromPayPlan = bosType.equals((Object)BOSObjectType.create((String)"FDB9FA00"));
            }
            boolean bl = isSrcBill = info.getPayPlanBillID() != null;
            if (isFromPayPlan) {
                for (int i = 0; i < info.getEntries().size(); ++i) {
                    PaymentBillEntryInfo paymentEntry = info.getEntries().get(i);
                    if (paymentEntry.getActualAmt() == null || paymentEntry.getActualAmt().doubleValue() == 0.0) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "622_ACTUALAMT_NOT_ZERO"));
                    }
                    String srcEntryId = null;
                    srcEntryId = isSrcBill ? paymentEntry.getSrcPlanBillEntryID() : paymentEntry.getSourceBillEntryId();
                    SelectorItemCollection seletor = new SelectorItemCollection();
                    seletor.add(new SelectorItemInfo("payAmt"));
                    seletor.add(new SelectorItemInfo("scheduleAmt"));
                    seletor.add(new SelectorItemInfo("lockAmt"));
                    PaymentPlanBillEntryInfo srcEntryInfo = PaymentPlanBillEntryFactory.getLocalInstance((Context)ctx).getPaymentPlanBillEntryInfo((IObjectPK)new ObjectUuidPK(srcEntryId), seletor);
                    double payAmt = srcEntryInfo.getPayAmt().doubleValue();
                    double scheduleAmt = srcEntryInfo.getScheduleAmt().doubleValue();
                    double lockAmt = srcEntryInfo.getLockAmt().doubleValue();
                    SelectorItemCollection s = new SelectorItemCollection();
                    s.add(new SelectorItemInfo("actualAmt"));
                    PaymentBillEntryInfo oldEntry = PaymentBillEntryFactory.getLocalInstance(ctx).getPaymentBillEntryInfo((IObjectPK)new ObjectUuidPK(paymentEntry.getId().toString()), s);
                    double actualAmt = oldEntry.getActualAmt().doubleValue();
                    double oldLocalAmt = lockAmt - actualAmt;
                    double limitAmt = scheduleAmt - oldLocalAmt - payAmt;
                    if (!(paymentEntry.getActualAmt().doubleValue() > limitAmt)) continue;
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "623_ACTUALAMT_IS_BIG"));
                }
            }
            IObjectPK pk = this.getSavePk(ctx, info);
            pageModel.put("error", 0);
            pageModel.put("id", pk.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    private void checkBizDateBeforeSaveSubmit(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        if (SourceTypeEnum.AP.equals((Object)info.getSourceType())) {
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.ACCOUNTSPAYABLE, info.getCompany());
            if (periodInfo == null) {
                throw new RecPayException(RecPayException.AP_ISNOT_START);
            }
            if (periodInfo.getBeginDate() != null && info.isIsInitializeBill() && info.getBizDate().compareTo(periodInfo.getBeginDate()) >= 0) {
                String str = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"DateAfterStartDate", (Locale)ctx.getLocale());
                throw new RecPayException(new NumericExceptionSubItem("DateAfterStartDate", str));
            }
            if (periodInfo.getBeginDate() != null && !info.isIsInitializeBill() && info.getBizDate().compareTo(periodInfo.getBeginDate()) < 0) {
                throw new RecPayException(RecPayException.AP_BILLDATEMUSTGREATTHANBEGINDATE);
            }
        }
    }

    private AsstActTypeCollection getAsstActTypeColl(Context ctx, String companyID, boolean isPay, boolean isRec) throws EASBizException, BOSException {
        if (EmptyUtil.isEmpty((String)companyID)) {
            companyID = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        }
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and FCompanyID='" + companyID + "'");
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        }
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE=1");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    protected IObjectPK getSavePk(Context ctx, PaymentBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BOTRelationCollection btpRelationCollection = CASWebHelper.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null && (btpRelationCollection == null || btpRelationCollection.size() == 0)) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
        }
        if (btpRelationCollection != null && btpRelationCollection.size() > 0) {
            objectPK = iBTPManager.saveRelations((CoreBillBaseInfo)info, btpRelationCollection);
        } else {
            if (H.same((Object)info.get("isRefundPay"), (Object)true)) {
                String transDetailId = (String)info.get("transDetailId");
                String refundPaymentBillId = (String)info.get("refundPaymentBillId");
                TransDetailInfo detailInfo = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK(transDetailId));
                PaymentBillInfo refundPaymentBillInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(refundPaymentBillId));
                info.put("transDetailInfo", detailInfo);
                info.put("refundPaymentBillInfo", refundPaymentBillInfo);
                info.remove("transDetailId");
                info.remove("refundPaymentBillId");
            }
            objectPK = iPaymentBill.save((CoreBaseInfo)info);
        }
        return objectPK;
    }

    @Override
    protected Map _beforeSubmit(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            AccountBankInfo payerAccountBank;
            Map paramAll = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS053", "CS031", "CS031_01", "CS034", "CS027", "CS036", "CS045", "CS015", "CS073", "CS103", "CS035");
            this.verifyBeforeSubmit(ctx, info, paramAll);
            pageModel.put("error", 0);
            Map<String, Object> beInfo = null;
            Map param = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS116");
            boolean val = (Boolean)param.get("CS116");
            if (EmptyUtil.isEmpty(pageModel.get("msg")) && !EmptyUtil.isEmpty((CoreBaseInfo)(payerAccountBank = info.getPayerAccountBank()))) {
                SettlementTypeInfo settletype;
                if (!payerAccountBank.isIsSetBankInterface()) {
                    payerAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection("select *,bank.name,company.id where id ='" + payerAccountBank.getId().toString() + "'").get(0);
                    info.setPayerAccountBank(payerAccountBank);
                }
                if (payerAccountBank.isIsSetBankInterface() && !SourceTypeEnum.BE.equals((Object)info.getSourceType()) && (settletype = info.getSettlementType()) != null && settletype.isPayThroughBE()) {
                    if (val) {
                        beInfo = this.getBeInfo(ctx, info, false);
                    } else if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) || EmptyUtil.isEmpty((String)info.getPayeeBank()) || EmptyUtil.isEmpty((String)info.getBankAcctName()) && EmptyUtil.isEmpty((String)info.getPayeeName()) || EmptyUtil.isEmpty((String)info.getUsage()) || EmptyUtil.isEmpty((Object)info.getActPayAmt()) || EmptyUtil.isEmpty((String)info.getRecProvince()) || EmptyUtil.isEmpty((String)info.getRecCity())) {
                        beInfo = this.getBeInfo(ctx, info, false);
                    }
                }
            }
            pageModel.put("beInfo", beInfo);
            pageModel.put("currencyInfo", true);
            String payeeAccountBank = info.getPayeeAccountBank();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection selector = view.getSelector();
            selector.add("currency.*");
            selector.add("isByCurrency");
            view.setSelector(selector);
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)payeeAccountBank, CompareType.EQUALS));
            view.setFilter(filter);
            AccountBankCollection coll = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (!info.isIsCBPay() && coll != null && coll.size() > 0 && info.getCurrency() != null && info.getPayerAccountBank() != null) {
                CurrencyInfo Crinfo = info.getCurrency();
                AccountBankInfo payeeAcctBankInfo = coll.get(0);
                CurrencyInfo acctBankCrinfo = payeeAcctBankInfo.getCurrency();
                if (payeeAcctBankInfo.isIsByCurrency() && info.getPayerAccountBank().isIsByCurrency() && !acctBankCrinfo.getId().equals((Object)Crinfo.getId())) {
                    pageModel.put("currencyInfo", false);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    @Override
    protected Map _submitVerifyOverDraft(Context ctx, PaymentBillInfo info, BigDecimal balance) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            BOSUuid sbid;
            boolean allow = true;
            String msg = "";
            Map paramAll = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS053", "CS132");
            AccountBankInfo payerAcctBank = null;
            if (info.getPayerAccountBank() != null) {
                payerAcctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayerAccountBank().getId()));
            }
            int val = Integer.parseInt((String)paramAll.get("CS053"));
            String cs132 = (String)paramAll.get("CS132");
            String sourceBillId = info.getSourceBillId();
            boolean controlOverFraft = true;
            if (sourceBillId != null && (sbid = BOSUuid.read((String)sourceBillId)).getType().equals((Object)new TransDetailInfo().getBOSType()) && !"1".equals(cs132) && payerAcctBank != null && payerAcctBank.isIsSetBankInterface()) {
                controlOverFraft = false;
            }
            if (val == 1 && controlOverFraft && payerAcctBank != null && payerAcctBank != null && payerAcctBank.getCtrlStrategy() != null) {
                AccountBankGroupInfo acctBankGroup;
                AccountMgrStrategyInfo strategy = payerAcctBank.getCtrlStrategy();
                strategy = AccountMgrStrategyFactory.getLocalInstance((Context)ctx).getAccountMgrStrategyInfo((IObjectPK)new ObjectUuidPK(strategy.getId()));
                boolean isCtrlAcctBank = true;
                if (strategy == null) {
                    isCtrlAcctBank = false;
                }
                boolean isRemind = false;
                if (strategy != null) {
                    isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
                }
                BigDecimal amount = balance.subtract(info.getActPayAmt());
                if (isCtrlAcctBank && amount.compareTo(Constants.ZERO) < 0 && isRemind) {
                    msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"BALLESSTHANODAMTDETAIL");
                    msg = MessageFormat.format(msg, payerAcctBank.getName(), amount.abs());
                }
                if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && amount.compareTo(Constants.ZERO) < 0 && amount.negate().compareTo(strategy.getOverDraftAmount()) > 0) {
                    msg = new AccountBankException(AccountBankException.OVERDRAFT, new Object[]{payerAcctBank.getName(), strategy.getOverDraftAmount(), amount.abs().subtract(strategy.getOverDraftAmount())}).getMessage();
                }
                if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
                    if (amount.compareTo(Constants.ZERO) < 0) {
                        msg = new AccountBankException(AccountBankException.NOALLOWOVERDRAFT, new Object[]{payerAcctBank.getName(), amount.abs()}).getMessage();
                        allow = false;
                    }
                } else if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && amount.compareTo(strategy.getLowestBalance()) < 0) {
                    msg = new AccountBankException(AccountBankException.OVERLOWAMOUNT, new Object[]{payerAcctBank.getName(), strategy.getLowestBalance(), strategy.getLowestBalance().subtract(amount).abs()}).getMessage();
                    allow = false;
                }
                if ((acctBankGroup = AccountBankFactory.getLocalInstance((Context)ctx).getAcctBankGroup(info.getPayerAccountBank().getId().toString())) != null) {
                    strategy = acctBankGroup.getStrategy();
                    isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
                    ObjectUuidPK companyPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId());
                    ObjectUuidPK currencyPK = new ObjectUuidPK(info.getCurrency().getId());
                    ObjectUuidPK acctBankGroupPK = new ObjectUuidPK(acctBankGroup.getId());
                    BigDecimal totalbalance = InnerCashFacadeFactory.getLocalInstance(ctx).getAcctGroupInstantBalance((IObjectPK)companyPK, (IObjectPK)acctBankGroupPK, (IObjectPK)currencyPK);
                    amount = totalbalance.subtract(info.getActPayAmt());
                    if (amount.compareTo(Constants.ZERO) < 0 && isRemind) {
                        msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"GroupBALLESSTHANODAMT");
                    }
                }
            }
            pageModel.put("allow", allow);
            pageModel.put("message", msg);
        }
        catch (Exception e) {
            logger.error((Object)e);
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    protected Map<String, Object> getBeInfo(Context ctx, PaymentBillInfo info, boolean actionBe) {
        HashMap<String, Object> beInfo = new HashMap<String, Object>();
        if (actionBe) {
            beInfo.put("be_head", CASWebUtil.getResource(ctx, "338_COMMITBE_BE_HEAD"));
        } else {
            beInfo.put("be_head", CASWebUtil.getResource(ctx, "339_SUBMIT_BE_HEAD"));
        }
        beInfo.put("payeeAccountBank", FMHelper.splitString((String)info.getPayeeAccountBank(), (int)4, (String)" "));
        beInfo.put("payeeBank", info.getPayeeBank());
        if (!EmptyUtil.isEmpty((String)info.getBankAcctName())) {
            beInfo.put("bankAcctName", info.getBankAcctName());
        } else {
            beInfo.put("bankAcctName", info.getPayeeName());
        }
        beInfo.put("payerAccountBank", info.getPayerAccountBank().getBank().getName() + "  " + info.getPayerAccountBank().getBankAccountNumber());
        beInfo.put("actPayAmt", info.getCurrency().getName() + " " + PaymentBillWebFacadeControllerBean.formatDecimal(info.getActPayAmt(), info.getCurrency().getPrecision() == 0 ? 3 : info.getCurrency().getPrecision()));
        beInfo.put("usage", info.getUsage());
        beInfo.put("recProvince", info.getRecProvince());
        beInfo.put("recCity", info.getRecCity());
        beInfo.put("isEmergency", info.getIsEmergency().getAlias(ctx.getLocale()));
        beInfo.put("isLanding", FMBooleanEnum.getEnum((int)(info.isIsLanding() ? 1 : 0)).getAlias(ctx.getLocale()));
        SettlementTypeInfo settleType = info.getSettlementType();
        beInfo.put("settlementType", settleType == null ? null : (settleType.isPayThroughBE() ? settleType.getName() : null));
        return beInfo;
    }

    public static String formatDecimal(BigDecimal val, int scale) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.applyPattern(FMHelper.toPattern((int)scale));
        return decimalFormat.format(val);
    }

    private void checkPayeeTypeForSysApAr(PaymentBillInfo info) throws CasWebException {
        if (info.getPayBillType() != null && (info.getPayBillType().getSourceSysType().equals((Object)SourceTypeEnum.AP) || info.getPayBillType().getSourceSysType().equals((Object)SourceTypeEnum.AR)) && info.getPayeeType() == null) {
            throw new CasWebException(CasWebException.AR_AP_PAYEETYPE_NOT_OTHER);
        }
    }

    protected AsstActTypeCollection getAsstActTypeColl(Context ctx, String cuID, boolean isPay) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("where id in(select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and Fcompanyid='" + cuID + "'");
        if (isPay) {
            sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        }
        sb.append(")");
        EntityViewInfo evi = null;
        try {
            evi = new EntityViewInfo(sb.toString());
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        return asstActType.getAsstActTypeCollection(evi);
    }

    protected AsstActTypeInfo getDefaultAsstActTypeInfo(Context ctx, String cuID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID, FLastUpdateUserId from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and Fcompanyid='" + cuID + "'");
        sb.append(" and FISDEFAULTACCOUNTPAYABLE=1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String id = null;
        try {
            if (rs.next()) {
                do {
                    id = rs.getString("FAsstActTypeID");
                } while (rs.getString("FLastUpdateUserId") == null && rs.next());
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        if (id != null) {
            return AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(id));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _submitById(Context ctx, String id) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "SUBMIT_SUCCESS");
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanAudit = false;
        try {
            isCanAudit = iMutex.requestObjIDForUpdate(id);
            if (!isCanAudit) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            Map submitResult = this.submit(ctx, info);
            result.setError((Integer)submitResult.get("error"));
            if (result.isError() != 0) {
                result.setSummaryMsg((String)submitResult.get("msg"));
            } else {
                result.setSummaryMsg(summary);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            summary = CASWebUtil.getResource(ctx, "SUBMIT_FAILED", new String[]{e.getMessage()});
            result.setSummaryMsg(summary);
        }
        finally {
            if (isCanAudit) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        return result;
    }

    protected SelectorItemCollection getSelector() {
        this.sic.add(new SelectorItemInfo("*"));
        this.sic.add(new SelectorItemInfo("CU.id"));
        this.sic.add(new SelectorItemInfo("CU.name"));
        this.sic.add(new SelectorItemInfo("CU.number"));
        this.sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        this.sic.add(new SelectorItemInfo("settlementType.ntType.*"));
        this.sic.add(new SelectorItemInfo("actRecAccountBank.*"));
        this.sic.add(new SelectorItemInfo("payerInAcctID.id"));
        this.sic.add(new SelectorItemInfo("payerInAcctID.name"));
        this.sic.add(new SelectorItemInfo("payerInAcctID.number"));
        this.sic.add(new SelectorItemInfo("payerInAcctID.InnerAcct.id"));
        this.sic.add(new SelectorItemInfo("cheque.id"));
        this.sic.add(new SelectorItemInfo("cheque.number"));
        this.sic.add(new SelectorItemInfo("cheque.bank"));
        this.sic.add(new SelectorItemInfo("cheque.bankAcct"));
        this.sic.add(new SelectorItemInfo("cheque.state"));
        this.sic.add(new SelectorItemInfo("cheque.applyRec.applyCompany.id"));
        this.sic.add(new SelectorItemInfo("payerBank.*"));
        this.sic.add(new SelectorItemInfo("fundFlowItem.*"));
        this.sic.add(new SelectorItemInfo("company.id"));
        this.sic.add(new SelectorItemInfo("company.number"));
        this.sic.add(new SelectorItemInfo("company.name"));
        this.sic.add(new SelectorItemInfo("company.isBizUnit"));
        this.sic.add(new SelectorItemInfo("company.CU"));
        this.sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        this.sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        this.sic.add(new SelectorItemInfo("company.baseExchangeTable.id"));
        this.sic.add(new SelectorItemInfo("company.baseExchangeTable.number"));
        this.sic.add(new SelectorItemInfo("company.accountTable.id"));
        this.sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        this.sic.add(new SelectorItemInfo("payerAccountBank.*"));
        this.sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.*"));
        this.sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.clearingHouse.*"));
        this.sic.add(new SelectorItemInfo("payeeAccountBankO.*"));
        this.sic.add(new SelectorItemInfo("payeeAccountBankO.account.*"));
        this.sic.add(new SelectorItemInfo("agentPayCompany.id"));
        this.sic.add(new SelectorItemInfo("agentPayCompany.name"));
        this.sic.add(new SelectorItemInfo("entries.*"));
        this.sic.add(new SelectorItemInfo("bizType.id"));
        this.sic.add(new SelectorItemInfo("bizType.number"));
        this.sic.add(new SelectorItemInfo("bizType.name"));
        this.sic.add(new SelectorItemInfo("bizType.type"));
        this.sic.add(new SelectorItemInfo("bizType.notSubmitHouse"));
        this.sic.add(new SelectorItemInfo("payeeType.id"));
        this.sic.add(new SelectorItemInfo("payeeType.number"));
        this.sic.add(new SelectorItemInfo("payeeType.name"));
        this.sic.add(new SelectorItemInfo("payeeType.asstHGAttribute"));
        this.sic.add(new SelectorItemInfo("payeeType.realtionDataObject"));
        this.sic.add(new SelectorItemInfo("auditor.id"));
        this.sic.add(new SelectorItemInfo("settlementType.*"));
        this.sic.add(new SelectorItemInfo("payBillType.*"));
        this.sic.add(new SelectorItemInfo("feeType.id"));
        this.sic.add(new SelectorItemInfo("feeType.name"));
        this.sic.add(new SelectorItemInfo("feeType.number"));
        this.sic.add(new SelectorItemInfo("payerAccount.*"));
        this.sic.add(new SelectorItemInfo("currency.id"));
        this.sic.add(new SelectorItemInfo("currency.name"));
        this.sic.add(new SelectorItemInfo("currency.number"));
        this.sic.add(new SelectorItemInfo("currency.precision"));
        this.sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        this.sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        this.sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        this.sic.add(new SelectorItemInfo("person.id"));
        this.sic.add(new SelectorItemInfo("person.number"));
        this.sic.add(new SelectorItemInfo("person.name"));
        this.sic.add(new SelectorItemInfo("project.id"));
        this.sic.add(new SelectorItemInfo("project.name"));
        this.sic.add(new SelectorItemInfo("project.number"));
        this.sic.add(new SelectorItemInfo("projectManager.id"));
        this.sic.add(new SelectorItemInfo("projectManager.name"));
        this.sic.add(new SelectorItemInfo("projectManager.number"));
        this.sic.add(new SelectorItemInfo("costCenter.name"));
        this.sic.add(new SelectorItemInfo("costCenter.number"));
        this.sic.add(new SelectorItemInfo("costCenter.displayname"));
        this.sic.add(new SelectorItemInfo("profitCenter.*"));
        this.sic.add(new SelectorItemInfo("paymentType.id"));
        this.sic.add(new SelectorItemInfo("paymentType.number"));
        this.sic.add(new SelectorItemInfo("paymentType.name"));
        this.sic.add(new SelectorItemInfo("FRecCountry.id"));
        this.sic.add(new SelectorItemInfo("FRecCountry.number"));
        this.sic.add(new SelectorItemInfo("FRecCountry.name"));
        this.sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        this.sic.add(new SelectorItemInfo("oppAccount.accountTableID.id"));
        this.sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        this.sic.add(new SelectorItemInfo("oppAccount.CAA.id"));
        this.sic.add(new SelectorItemInfo("oppAccount.CAA.isQty"));
        this.sic.add(new SelectorItemInfo("oppAccount.AC"));
        this.sic.add(new SelectorItemInfo("oppAccount.isBank"));
        this.sic.add(new SelectorItemInfo("oppAccount.name"));
        this.sic.add(new SelectorItemInfo("oppAccount.number"));
        this.sic.add(new SelectorItemInfo("remitAccountBank.id"));
        this.sic.add(new SelectorItemInfo("remitAccountBank.number"));
        this.sic.add(new SelectorItemInfo("remitAccountBank.bankAccountNumber"));
        this.sic.add(new SelectorItemInfo("remitAccountBank.name"));
        this.sic.add(new SelectorItemInfo("assItems.*"));
        this.sic.add(new SelectorItemInfo("entries.assItemsEntries.*"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.accountTableID.id"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.CAA.id"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.CAA.isQty"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.AC"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.name"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.longName"));
        this.sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        this.sic.add(new SelectorItemInfo("entries.costCenter.name"));
        this.sic.add(new SelectorItemInfo("entries.costCenter.number"));
        this.sic.add(new SelectorItemInfo("entries.expenseType.name"));
        this.sic.add(new SelectorItemInfo("entries.expenseType.number"));
        this.sic.add(new SelectorItemInfo("entries.rebate"));
        this.sic.add(new SelectorItemInfo("entries.rebateLocAmt"));
        this.sic.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        this.sic.add(new SelectorItemInfo("entries.fundFlowItem.number"));
        this.sic.add(new SelectorItemInfo("entries.fundFlowItem.name"));
        SelectorItemCollection fullSelector = ArApSelectorFactory.getPaymentBillFullSelector(true);
        this.sic = ArApSelectorFactory.margeSelector(fullSelector, this.sic);
        return this.sic;
    }

    protected SelectorItemCollection getTempSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("settlementType.ntType.*"));
        sic.add(new SelectorItemInfo("actRecAccountBank"));
        sic.add(new SelectorItemInfo("payerInAcctID.id"));
        sic.add(new SelectorItemInfo("payerInAcctID.name"));
        sic.add(new SelectorItemInfo("payerInAcctID.number"));
        sic.add(new SelectorItemInfo("payerInAcctID.InnerAcct.id"));
        sic.add(new SelectorItemInfo("cheque.id"));
        sic.add(new SelectorItemInfo("cheque.number"));
        sic.add(new SelectorItemInfo("cheque.bank"));
        sic.add(new SelectorItemInfo("cheque.bankAcct"));
        sic.add(new SelectorItemInfo("cheque.state"));
        sic.add(new SelectorItemInfo("cheque.applyRec.applyCompany.id"));
        sic.add(new SelectorItemInfo("payerBank.*"));
        sic.add(new SelectorItemInfo("fundFlowItem.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.isBizUnit"));
        sic.add(new SelectorItemInfo("company.CU"));
        sic.add(new SelectorItemInfo("company.baseCurrency.number"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("company.baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("company.baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("company.accountTable.*"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.clearingHouse.*"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.*"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.account.*"));
        sic.add(new SelectorItemInfo("agentPayCompany.id"));
        sic.add(new SelectorItemInfo("agentPayCompany.name"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.type"));
        sic.add(new SelectorItemInfo("bizType.notSubmitHouse"));
        sic.add(new SelectorItemInfo("payeeType.id"));
        sic.add(new SelectorItemInfo("payeeType.number"));
        sic.add(new SelectorItemInfo("payeeType.name"));
        sic.add(new SelectorItemInfo("payeeType.asstHGAttribute"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("payBillType.*"));
        sic.add(new SelectorItemInfo("feeType.id"));
        sic.add(new SelectorItemInfo("feeType.name"));
        sic.add(new SelectorItemInfo("feeType.number"));
        sic.add(new SelectorItemInfo("payerAccount.*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("project.number"));
        sic.add(new SelectorItemInfo("projectManager.id"));
        sic.add(new SelectorItemInfo("projectManager.name"));
        sic.add(new SelectorItemInfo("projectManager.number"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("costCenter.number"));
        sic.add(new SelectorItemInfo("costCenter.displayname"));
        sic.add(new SelectorItemInfo("profitCenter.*"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("FRecCountry.id"));
        sic.add(new SelectorItemInfo("FRecCountry.number"));
        sic.add(new SelectorItemInfo("FRecCountry.name"));
        sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("oppAccount.accountTableID.id"));
        sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("oppAccount.CAA.id"));
        sic.add(new SelectorItemInfo("oppAccount.CAA.isQty"));
        sic.add(new SelectorItemInfo("oppAccount.AC"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("remitAccountBank.id"));
        sic.add(new SelectorItemInfo("remitAccountBank.number"));
        sic.add(new SelectorItemInfo("remitAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("remitAccountBank.name"));
        sic.add(new SelectorItemInfo("assItems.*"));
        sic.add(new SelectorItemInfo("entries.assItemsEntries.*"));
        sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.accountTableID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.CAA.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.CAA.isQty"));
        sic.add(new SelectorItemInfo("entries.oppAccount.AC"));
        sic.add(new SelectorItemInfo("entries.oppAccount.name"));
        sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        sic.add(new SelectorItemInfo("entries.oppAccount.longName"));
        sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        sic.add(new SelectorItemInfo("entries.costCenter.name"));
        sic.add(new SelectorItemInfo("entries.costCenter.number"));
        sic.add(new SelectorItemInfo("entries.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.expenseType.number"));
        sic.add(new SelectorItemInfo("entries.rebate"));
        sic.add(new SelectorItemInfo("entries.rebateLocAmt"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.number"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.name"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _submit4CaById(Context ctx, String id, String plainText, String signature) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "SUBMIT_SUCCESS");
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanAudit = false;
        try {
            isCanAudit = iMutex.requestObjIDForUpdate(id);
            if (!isCanAudit) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            Map submitResult = this.submit4Ca(ctx, info, plainText, signature);
            result.setError((Integer)submitResult.get("error"));
            if (result.isError() != 0) {
                result.setSummaryMsg((String)submitResult.get("msg"));
            } else {
                result.setSummaryMsg(summary);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            summary = CASWebUtil.getResource(ctx, "SUBMIT_FAILED", new String[]{e.getMessage()});
            result.setSummaryMsg(summary);
        }
        finally {
            if (isCanAudit) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        return result;
    }

    @Override
    protected Map _submit(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        String pfLogId_submit = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "PaymentbillWebFacadeControllerBean.submit");
        if (PeriodHelper.isAdjustPeriod(ctx, info.getCompany().getId().toString())) {
            String msg = CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD", new String[]{info.getNumber()});
            throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
        }
        AsstActTypeCollection asstActTypeColl = this.getAsstActTypeColl(ctx, info.getCompany().getId().toString(), false, false);
        if (info.getPayeeType() != null && !asstActTypeColl.contains((Object)BOSUuid.read((String)info.getPayeeType().getId().toString()))) {
            info.setPayeeType(null);
        }
        this.checkPayeeTypeForSysApAr(info);
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IObjectPK objectPK;
            IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
            Map param = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS053", "CS031", "CS031_01", "CS034", "CS027", "CS036", "CS045", "CS015", "CS073", "CS103", "CS035");
            if (info.getId() != null && iPaymentBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                this.checkStatusChanged(ctx, info, param);
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayBillType()) && !EmptyUtil.isEmpty((Object)info.getPayBillType().getSourceSysType())) {
                info.setSourceType(info.getPayBillType().getSourceSysType());
            }
            this.transAsstAccount(ctx, info);
            this.transBgDimension(ctx, info);
            this.verifyBeforeSubmit(ctx, info, param);
            RecPayHelper.checkPSIsClose(ctx, info);
            SourceTypeEnum sourceType = info.getSourceType();
            SourceTypeEnum sourceSysType = info.getSourceSysType();
            if (SourceTypeEnum.AP.equals((Object)sourceType) || SourceTypeEnum.AP.equals((Object)sourceSysType)) {
                if (null != info && null != info.getId() && info.getBillStatus().getValue() == 12) {
                    objectPK = new ObjectUuidPK(info.getId());
                    iPaymentBill.update(objectPK, (CoreBaseInfo)info);
                } else {
                    objectPK = this.getSubmitPk(ctx, iPaymentBill, info);
                }
            } else {
                objectPK = this.getSubmitPk(ctx, iPaymentBill, info);
            }
            pageModel.put("id", objectPK.toString());
            pageModel.put("error", 0);
            if (info.getPayeeType() != null) {
                String asstActTypeId = info.getPayeeType().getId().toString();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add("asstHGAttribute");
                AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstActTypeId), sic);
                if (asstActTypeInfo.getAsstHGAttribute().equals("customer")) {
                    String payeeId = info.getPayeeID();
                    String payeeAccountBank = info.getPayeeAccountBank();
                    if (payeeId != null && !"".equals(payeeId) && payeeAccountBank != null && !"".equals(payeeAccountBank)) {
                        EntityViewInfo view = CasBosUtils.entityViewBuilder().select("id").filter("customerCompanyInfo.customer.id", payeeId).filter("customerCompanyInfo.companyOrgUnit.id", info.getCompany().getId().toString()).filter("bankAccount", payeeAccountBank).build();
                        CustomerCompanyBankCollection customerBankColl = CustomerCompanyBankFactory.getLocalInstance((Context)ctx).getCustomerCompanyBankCollection(view);
                        if (customerBankColl.size() == 0) {
                            pageModel.put("saveBank", 1);
                        }
                    }
                } else if (asstActTypeInfo.getAsstHGAttribute().equals("provider")) {
                    String payeeId = info.getPayeeID();
                    String payeeAccountBank = info.getPayeeAccountBank();
                    if (payeeId != null && !"".equals(payeeId) && payeeAccountBank != null && !"".equals(payeeAccountBank)) {
                        EntityViewInfo view = CasBosUtils.entityViewBuilder().select("id").filter("supplierCompanyInfo.supplier.id", payeeId).filter("supplierCompanyInfo.companyOrgUnit.id", info.getCompany().getId().toString()).filter("bankAccount", payeeAccountBank).build();
                        SupplierCompanyBankCollection supplierBankColl = SupplierCompanyBankFactory.getLocalInstance((Context)ctx).getSupplierCompanyBankCollection(view);
                        if (supplierBankColl.size() == 0) {
                            pageModel.put("saveBank", 1);
                        }
                    }
                }
            }
        }
        catch (WfBizException e) {
            pageModel.put("error", 1);
            pageModel.put("msg", CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        PerfLogRecorder.endRecord(pfLogId_submit);
        return pageModel;
    }

    @Override
    protected Map _submit4Ca(Context ctx, PaymentBillInfo info, String plainText, String signature) throws BOSException, EASBizException {
        Map<String, Object> pageModel = new HashMap<String, Object>();
        try {
            String submitPermission = null;
            submitPermission = FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) ? "fundDispatchBill_batchSubmit" : "cas_paymentbill_batchSubmit";
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = new ArrayList<String>();
            list.add(info.getId().toString());
            iEASSignature.checkSignature4Web(list, submitPermission);
            iEASSignature.checkSignature4Web(plainText, signature, submitPermission);
            pageModel = this.submit(ctx, info);
            iEASSignature.checkSignature4Web(list, submitPermission);
            iEASSignature.saveSignature4Web(signature, plainText, info.getId().toString(), submitPermission);
        }
        catch (WfBizException e) {
            pageModel.put("error", 1);
            pageModel.put("msg", CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        String pfLogId_SaveBatch = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "PaymentbillWebFacadeControllerBean._batchSubmit.saveBatch");
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        HashSet<String> idSet = new HashSet<String>();
        ArrayList<String> idListAll = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
            idListAll.add(ids[i]);
        }
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        if (ids.length != colls.size()) {
            int i;
            ArrayList<String> existIdList = new ArrayList<String>();
            for (i = 0; i < colls.size(); ++i) {
                PaymentBillInfo info = colls.get(i);
                existIdList.add(info.getId().toString());
            }
            for (i = 0; i < idListAll.size(); ++i) {
                if (existIdList.contains(idListAll.get(i))) continue;
                result.getDetailMsgList().add("null," + CASWebUtil.getResource(ctx, "NOT_EXIST"));
                --success;
            }
        }
        PaymentBillCollection collsNew = new PaymentBillCollection();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            this.requesMutexs(ctx, idListAll, correctList, lockedList);
            if (lockedList.size() > 0) {
                for (int i = 0; i < colls.size(); ++i) {
                    PaymentBillInfo info = colls.get(i);
                    if (lockedList.contains(info.getId().toString())) {
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_SUBMIT_FAILED", new String[]{info.getNumber(), CASWebUtil.getResource(ctx, "HAS_LOCKED")}));
                        --success;
                        continue;
                    }
                    collsNew.add(info);
                }
            } else {
                collsNew = colls;
            }
            HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
            for (int i = 0; i < collsNew.size(); ++i) {
                PaymentBillInfo info = collsNew.get(i);
                ArrayList<String> idList = new ArrayList<String>();
                idList.add(ids[i]);
                try {
                    if (!paymentBill.exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_SUBMIT_FAILED", new String[]{info.getNumber(), CASWebUtil.getResource(ctx, "NOT_EXIST")}));
                        --success;
                        continue;
                    }
                    if (isFundDispatch && !permissionSet.contains(info.getCompany().getId())) {
                        boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "fundDispatchBill_batchSubmit");
                        if (!isPermission) {
                            String msg = FDUtils.getResource((Context)ctx, (String)"063_NO_SUBMIT_AUTH", (String[])new String[]{info.getCompany().getName()});
                            result.getDetailMsgList().add(FDUtils.getResource((Context)ctx, (String)"070_SUBMITFAIL_RESON", (String[])new String[]{info.getNumber(), msg}));
                            --success;
                            continue;
                        }
                        permissionSet.add(info.getCompany().getId());
                        if (info.getActPayAmt() == null || info.getActPayAmt().compareTo(Constants.ZERO) == 0) {
                            throw new RuntimeException(FDUtils.getResource((Context)ctx, (String)"077_AMOUT_NOT_EMPTY", null));
                        }
                        if (info.getActPayLocAmt() == null || info.getActPayLocAmt().compareTo(Constants.ZERO) == 0) {
                            throw new RuntimeException(FDUtils.getResource((Context)ctx, (String)"078_LOC_AMOUT_NO_EMPTY", null));
                        }
                    }
                    Map param = this.getParamAndCheck(ctx, info.getCompany());
                    this.verifyBeforeSubmit(ctx, info, param);
                    IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                    BOTRelationCollection relations = iBTPManager.getRelationCollection(info.getId().toString());
                    iBTPManager.submitRelations((CoreBillBaseInfo)info, relations);
                    continue;
                }
                catch (WfBizException e) {
                    logger.error((Object)"\u4ed8\u6b3e\u5355\u63d0\u4ea4\u5f02\u5e38", (Throwable)e);
                    --success;
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_SUBMIT_FAILED", new String[]{info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)"\u4ed8\u6b3e\u5355\u63d0\u4ea4\u5f02\u5e38", (Throwable)e);
                    --success;
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_SUBMIT_FAILED", new String[]{info.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(correctList);
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "SUBMIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord(pfLogId_SaveBatch);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchSubmit4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        String pfLogId_SaveBatch = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "PaymentbillWebFacadeControllerBean._batchSubmit.saveBatch");
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        logger.info(signatureList);
        logger.info((Object)("ids=" + ids));
        logger.info((Object)("length" + ids.length));
        if (signatureList == null || signatureList != null && signatureList.size() != ids.length) {
            result.setError(1);
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "341_SUBMIT_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        int success = ids.length;
        String submitPermission = null;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        submitPermission = isFundDispatch ? "fundDispatchBill_batchSubmit" : "cas_paymentbill_batchSubmit";
        IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            boolean islocked = false;
            if (!PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(ids[i]))) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_SUBMIT_FAILED", new String[]{ids[i], CASWebUtil.getResource(ctx, "NOT_EXIST")}));
                --success;
                continue;
            }
            try {
                islocked = iMutex.requestObjIDForUpdate(ids[i]);
                if (!islocked) {
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILLID_SUBMIT_FAILED", new String[]{ids[i], CASWebUtil.getResource(ctx, "HAS_LOCKED")}));
                    --success;
                    continue;
                }
                boolean orgCheck = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx).getCaOrgRangeCheck(ids[i], submitPermission);
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> signatureSubList = new ArrayList<String>();
                if (orgCheck) {
                    list.add(ids[i]);
                    iEASSignature.checkSignature4Web(list, submitPermission);
                    signatureSubList.add(signatureList.get(i));
                    iEASSignature.checkSignature4Web(list, signatureSubList, submitPermission);
                }
                Map errorMsg = PaymentBillFactory.getLocalInstance(ctx).saveBatch(list);
                success -= errorMsg.size();
                for (String number : errorMsg.keySet()) {
                    String msg = (String)errorMsg.get(number);
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_SUBMIT_FAILED", new String[]{number, msg}));
                }
                if (!orgCheck) continue;
                iEASSignature.checkSignature4Web(list, submitPermission);
                iEASSignature.saveSignature4Web(signatureSubList, list, submitPermission);
                continue;
            }
            finally {
                if (islocked) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "SUBMIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord(pfLogId_SaveBatch);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    protected IObjectPK getSubmitPk(Context ctx, IPaymentBill iPaymentBill, PaymentBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = CASWebHelper.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null && (btpRelationCollection == null || btpRelationCollection.size() == 0)) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
        }
        boolean enbale = false;
        if (btpRelationCollection != null && btpRelationCollection.size() > 0) {
            if (null != info && null != info.getId() && null != info.getBillStatus() && CasForArApUtil.isBillInShareFlow(ctx, false, info.getId().toString(), info.getBillStatus().getValue(), 11)) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u5173\u95ed\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().disableEventListener();
                enbale = true;
            }
            objectPK = iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection);
            if (enbale) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d,\u6253\u5f00\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        } else {
            if (null != info && null != info.getId() && null != info.getBillStatus() && CasForArApUtil.isBillInShareFlow(ctx, false, info.getId().toString(), info.getBillStatus().getValue(), 11)) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u5173\u95ed\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().disableEventListener();
                enbale = true;
            }
            if (H.same((Object)info.get("isRefundPay"), (Object)true)) {
                String transDetailId = (String)info.get("transDetailId");
                String refundPaymentBillId = (String)info.get("refundPaymentBillId");
                TransDetailInfo detailInfo = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailInfo((IObjectPK)new ObjectUuidPK(transDetailId));
                PaymentBillInfo refundPaymentBillInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(refundPaymentBillId));
                info.put("transDetailInfo", detailInfo);
                info.put("refundPaymentBillInfo", refundPaymentBillInfo);
                info.remove("transDetailId");
                info.remove("refundPaymentBillId");
            }
            objectPK = iPaymentBill.submit((CoreBaseInfo)info);
            if (enbale) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d,\u6253\u5f00\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
        return objectPK;
    }

    private void checkStatusChanged(Context ctx, PaymentBillInfo info, Map param) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billStatus");
        sic.add("settlementStatus");
        sic.add("fiVouchered");
        PaymentBillInfo oldInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
        if (info.getBillStatus() != oldInfo.getBillStatus() || info.getSettlementStatus() != oldInfo.getSettlementStatus() || info.isFiVouchered() != oldInfo.isFiVouchered()) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "CANNOT_SUBMIT_BILL_STATUS_CHANGED"));
        }
        if (oldInfo.getBillStatus().getValue() != 10 && oldInfo.getBillStatus().getValue() != 11 && oldInfo.getBillStatus().getValue() != 12) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "304_BILL_STATUS_NOT_SUBMIT", new String[]{oldInfo.getBillStatus().toString()}));
        }
        boolean val031 = (Boolean)param.get("CS031");
        boolean cs031_01 = (Boolean)param.get("CS031_01");
        if (!(val031 || cs031_01 || oldInfo.getBillStatus().getValue() <= 11 || oldInfo.getBillStatus().getValue() == 12 && this.isInWorkFlow(info.getId().toString(), ctx))) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "326_STATUS_NOT_SUBMIT"));
        }
    }

    private boolean isInWorkFlow(String selectId, Context ctx) {
        try {
            IEnactmentService service2 = EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] procInsts = service2.getProcessInstanceByHoldedObjectId(selectId);
            return procInsts != null && procInsts.length != 0;
        }
        catch (Exception e) {
            logger.error((Object)e);
            return false;
        }
    }

    @Override
    protected void _verifyBeforeSubmit(Context ctx, PaymentBillInfo info, Map param) throws BOSException, EASBizException {
        PeriodInfo periodInfo;
        boolean cs103;
        SettlementTypeInfo settType;
        AccountBankInfo payerAccountBank;
        SettBizTypeInfo bizTypeInfo;
        SelectorItemCollection sicc;
        AccountBankInfo payerAccountBank2;
        if (FundDispatchTypeEnum.PAYMENT_DEFAULT.equals((Object)info.getFundDispatchType())) {
            if (info.getPayerAccount() == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "290_PAYERACCOUNT_NOT_EMPTY"));
            }
            if (info.getPayBillType() == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "299_PAYBILLTYPE_NOT_EMPTY"));
            }
            if (info.isIsCBPay() && EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry())) {
                throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"250_PaymentBillWebFacadeControllerBean", (Locale)ctx.getLocale()));
            }
        } else if (FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "626_PAYERACCT_NOT_NULL"));
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBank())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "627_PAYERBANK_NOT_NULL"));
            }
            if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccountBankO())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "628_PAYEEACCT_NOT_NULL"));
            }
            if (EmptyUtil.isEmpty((String)info.getPayeeBank())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "629_PAYEEBANK_NOT_NULL"));
            }
            if (info.getPayeeAccountBankO() != null && info.getOppAccount() != null) {
                if (info.getPayeeAccountBankO().getAccount() == null) {
                    SelectorItemCollection sicc2 = new SelectorItemCollection();
                    sicc2.add(new SelectorItemInfo("account.id"));
                    AccountBankInfo tmp_acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeAccountBankO().getId().toString()), sicc2);
                    if (!info.getOppAccount().getId().equals((Object)tmp_acctBank.getAccount().getId())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "624_account_tip"));
                    }
                } else if (!info.getOppAccount().getId().equals((Object)info.getPayeeAccountBankO().getAccount().getId())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "624_account_tip"));
                }
            }
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank())) {
            payerAccountBank2 = info.getPayerAccountBank();
            sicc = new SelectorItemCollection();
            sicc.add(new SelectorItemInfo("*"));
            sicc.add(new SelectorItemInfo("InnerAcct.*"));
            sicc.add(new SelectorItemInfo("bank.*"));
            sicc.add(new SelectorItemInfo("account.*"));
            payerAccountBank2 = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payerAccountBank2.getId().toString()), sicc);
            if (payerAccountBank2.getInnerAcct() != null && info.getBizType() != null && !info.getBizType().isNotSubmitHouse()) {
                BankInfo bankInfo;
                bizTypeInfo = info.getBizType();
                boolean isOutBank = true;
                if (payerAccountBank2 != null && (bankInfo = payerAccountBank2.getBank()).isInGroup()) {
                    isOutBank = false;
                }
                if (!(EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerBank()) || EmptyUtil.isEmpty((String)info.getPayeeBank()) || isOutBank)) {
                    if (info.getPayerBank().getName(ctx.getLocale()).equals(info.getPayeeBank())) {
                        if (!SettBizTypeEnum.PAYINSIDE.equals((Object)bizTypeInfo.getType())) {
                            throw new RuntimeException(CASWebUtil.getResource(ctx, "318_mustPayinSide"));
                        }
                    } else if (!SettBizTypeEnum.PAYOUTSIDE.equals((Object)bizTypeInfo.getType()) && !SettBizTypeEnum.PAYINSIDEDIF.equals((Object)bizTypeInfo.getType())) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "319_mustPayinSideDif"));
                    }
                }
            }
        }
        if (EmptyUtil.isEmpty((String)info.getSourceBillId()) && info.getPayerAccountBank() != null) {
            payerAccountBank2 = info.getPayerAccountBank();
            sicc = new SelectorItemCollection();
            sicc.add(new SelectorItemInfo("*"));
            sicc.add(new SelectorItemInfo("InnerAcct.*"));
            sicc.add(new SelectorItemInfo("bank.*"));
            sicc.add(new SelectorItemInfo("account.*"));
            payerAccountBank2 = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payerAccountBank2.getId().toString()), sicc);
            if (info.getPayeeAccountBankO() != null && info.getPayeeAccountBankO().getId() != null) {
                AccountBankInfo payeeAccountBankO = info.getPayeeAccountBankO();
                payeeAccountBankO = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payeeAccountBankO.getId().toString()), sicc);
                info.setPayeeAccountBankO(payeeAccountBankO);
            }
            info.setPayerAccountBank(payerAccountBank2);
            if (info.getPayerBank() != null) {
                BankInfo payerBank = info.getPayerBank();
                payerBank = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getPayerBank().getId().toString()));
                if (payerBank.isInGroup() && info.getBizType() == null) {
                    throw new RecPayException(RecPayException.PAYBIZTYPEISNULL);
                }
            }
            if (payerAccountBank2.getInnerAcct() != null && info.getBizType() != null && !info.getBizType().isNotSubmitHouse()) {
                bizTypeInfo = info.getBizType();
                if (EmptyUtil.isEmpty((Object)bizTypeInfo.getType())) {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("type"));
                    bizTypeInfo = SettBizTypeFactory.getLocalInstance((Context)ctx).getSettBizTypeInfo((IObjectPK)new ObjectUuidPK(bizTypeInfo.getId().toString()), sic);
                }
                if (info.getDescription() == null || info.getDescription().length() == 0) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEDESCRIPTION);
                }
                if (!(bizTypeInfo.getType() != SettBizTypeEnum.PAYINSIDE || info.getPayeeAccountBankO() != null && info.getPayeeAccountBankO().getInnerAcct() != null && info.getPayeeAccountBankO().getBank().getId().equals((Object)payerAccountBank2.getBank().getId()))) {
                    throw new RecPayException(RecPayException.PAYEEACCOUNTPAYINSIDEMUSTHAVEINNERACCOUNT192);
                }
                if (bizTypeInfo.getType() == SettBizTypeEnum.PAYINSIDEDIF && (info.getPayeeAccountBankO() == null || info.getPayeeAccountBankO().getInnerAcct() == null || info.getPayeeAccountBankO().getBank().getId().equals((Object)payerAccountBank2.getBank().getId()))) {
                    throw new RecPayException(RecPayException.PAYEEACCOUNTPAYINSIDEDIFMUSTHAVEINNERACCOUNT193);
                }
                if (EmptyUtil.isEmpty((String)info.getPayeeName())) {
                    throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEPAYERNAME195);
                }
            }
        }
        if (!(info.getBillStatus().equals((Object)BillStatusEnum.SAVE) || info.getBillStatus().equals((Object)BillStatusEnum.SUBMIT) || ((Boolean)param.get("CS031")).booleanValue() || ((Boolean)param.get("CS031_01")).booleanValue())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "BILL_STATUS_NOT_SAVEORSUBMIT"));
        }
        if (info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "BILL_STATUS_NOT_SAVEORSUBMIT"));
        }
        if (((Boolean)param.get("CS034")).booleanValue() && !SourceTypeEnum.AP.equals((Object)info.getPayBillType().getSourceSysType()) && EmptyUtil.isEmpty((CoreBaseInfo)info.getFeeType())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "291_FEETYPE_NOT_EMPTY"));
        }
        if ((info.getFundDispatchType() == null || info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT)) && ((Boolean)param.get("CS027")).booleanValue() && EmptyUtil.isEmpty((CoreBaseInfo)info.getSettlementType())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "292_SETTLEMENTTYPE_NOT_EMPTY"));
        }
        if ((info.getFundDispatchType() == null || info.getFundDispatchType().equals((Object)FundDispatchTypeEnum.PAYMENT_DEFAULT)) && ((Boolean)param.get("CS035")).booleanValue() && info.getProject() == null) {
            throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"166_PaymentBillControllerBean", (Locale)ctx.getLocale()));
        }
        AccountBankInfo acctBank = info.getPayerAccountBank();
        SettlementTypeInfo settlementType = info.getSettlementType();
        if (acctBank != null && acctBank.isIsSetBankInterface() && settlementType != null && settlementType.isPayThroughBE() && ((Boolean)param.get("CS036")).booleanValue() && EmptyUtil.isEmpty((String)info.getUsage())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "293_USAGE_NOT_EMPTY"));
        }
        AccountViewInfo payerAccount = info.getPayerAccount();
        if (payerAccount != null && payerAccount.isIsBank() && EmptyUtil.isEmpty((CoreBaseInfo)info.getPayerAccountBank())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "334_PAYERACCOUNTBANK_NOT_EMPTY"));
        }
        PaymentBillTypeInfo billType = info.getPayBillType();
        if (EmptyUtil.isEmpty((Object)billType.getSourceSysType())) {
            billType = PaymentBillTypeFactory.getLocalInstance(ctx).getPaymentBillTypeInfo((IObjectPK)new ObjectUuidPK(billType.getId().toString()));
        }
        this.checkBizDateBeforeSaveSubmit(ctx, info);
        if (billType.isIsFinanceTranUp()) {
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getPayeeAccountBankO())) {
                info.setActRecAccountBank(info.getPayeeAccountBankO());
            }
            if (EmptyUtil.isEmpty((CoreBaseInfo)info.getActRecAccountBank())) {
                String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"f7ActualBankAcctCannotBeNull", (Locale)ctx.getLocale());
                throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
            }
        }
        RecPayHelper handler = new RecPayHelper();
        AccountViewInfo acct = info.getOppAccount();
        if (acct != null && !billType.isIsFinanceTranUp()) {
            if (acct.getId() != null) {
                acct = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(acct.getId().toString()));
            }
            if (acct.isIsBank()) {
                String accountId;
                String bankAccountNumber;
                if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank())) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayeeAccountBankCanNotBeNull", (Locale)ctx.getLocale());
                    throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
                }
                String companyNumber = info.getCompany().getId().toString();
                if (!handler.getBankAccountNumberBelong(ctx, companyNumber, bankAccountNumber = info.getPayeeAccountBank())) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayeeAccountBankCanNotExist", (Locale)ctx.getLocale());
                    throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
                }
                String companyId = info.getCompany().getId().toString();
                if (!handler.getAccountBelong(ctx, companyId, accountId = info.getOppAccount().getId().toString(), bankAccountNumber)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"RelAcctViewNotEqualOppAcctView", (Locale)ctx.getLocale());
                    throw new RecPayException(RecPayException.COMMON, new Object[]{msg});
                }
            }
        }
        boolean isOppAccountBank = false;
        HashSet<String> oppAccountIdSet = new HashSet<String>();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            AccountViewInfo acct1 = info.getEntries().get(i).getOppAccount();
            if (acct1 == null) continue;
            oppAccountIdSet.add(acct1.getId().toString());
        }
        ArrayList<String> oppAcctIdList = null;
        if (oppAccountIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            view.setTopCount(1);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", oppAccountIdSet, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("isBank", (Object)true));
            view.setFilter(filterInfo);
            AccountViewCollection accountViewColl = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
            boolean bl = isOppAccountBank = accountViewColl.size() > 0;
            if (isOppAccountBank) {
                oppAcctIdList = new ArrayList<String>();
                for (int i = 0; i < accountViewColl.size(); ++i) {
                    AccountViewInfo acct2 = accountViewColl.get(i);
                    oppAcctIdList.add(acct2.getId().toString());
                }
            }
        }
        if (isOppAccountBank) {
            String bankAccountNumber;
            if (EmptyUtil.isEmpty((String)info.getPayeeAccountBank())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "PAYEEACCOUNTBANK_CANNOT_BENULL"));
            }
            String companyId = info.getCompany().getId().toString();
            if (!this.getBankAccountNumberBelong(companyId, bankAccountNumber = info.getPayeeAccountBank(), ctx)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "310_PAYEEACCOUNTBANK_NOT_EXIST"));
            }
            if (!this.getAccountBelong(companyId, oppAcctIdList, bankAccountNumber, ctx)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "RelAcctViewNotEqualOppAcctView"));
            }
        }
        if ((payerAccountBank = info.getPayerAccountBank()) != null) {
            AccountViewInfo account;
            CurrencyInfo Crinfo = info.getCurrency();
            if (payerAccountBank != null && payerAccountBank.isIsByCurrency() && !Crinfo.getId().equals((Object)payerAccountBank.getCurrency().getId())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "311_PayerCurrencyNotEqual"));
            }
            if (payerAccountBank != null && payerAccountBank.getAccount() != null && (account = info.getPayerAccount()) != null && !payerAccountBank.getAccount().getId().equals((Object)account.getId())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "312_PayerAccountViewNotEqual"));
            }
            if (billType == null || !billType.getId().toString().equals("fjJCrQESEADgABpKwKgSQz6TKVs=")) {
                if (!payerAccountBank.isIsSetBankInterface()) {
                    payerAccountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection("select *,bank.name,company.id where id ='" + payerAccountBank.getId().toString() + "'").get(0);
                    info.setPayerAccountBank(payerAccountBank);
                }
                if (payerAccountBank.getAccountType() != null && payerAccountBank.getAccountType() == AccountType.PAYIN) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "313_PayerAccountCanNotBeIn"));
                }
                if (payerAccountBank.isNotOutPay()) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "314_PayerAccountCanNotOut"));
                }
            }
        }
        if (billType != null && (billType.getSourceSysType().equals((Object)SourceTypeEnum.AP) || billType.getSourceSysType().equals((Object)SourceTypeEnum.AR))) {
            AsstActTypeInfo payeeType = info.getPayeeType();
            if (payeeType != null && payeeType.equals((Object)FMSysDefinedEnum.OTHER)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "315_ArApPayeeTypeNotOther"));
            }
            if (EmptyUtil.isEmpty((String)info.getPayeeName())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "AsstActNameNotNull648"));
            }
        }
        boolean feeTypeAndProjectAllRequrie = (Boolean)param.get("CS045");
        if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
            feeTypeAndProjectAllRequrie = false;
        }
        if (feeTypeAndProjectAllRequrie && (info.getFeeType() != null && info.getProject() == null || info.getFeeType() == null && info.getProject() != null)) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "feeTypeAndProjectAllRequrie"));
        }
        boolean cs015 = (Boolean)param.get("CS015");
        if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
            cs015 = false;
        }
        Boolean MBG_C001 = FmMbgHelper.isMBG_C001((Context)ctx, (String)info.getCompany().getId().toString());
        if (FundDispatchTypeEnum.PAYMENT_DEFAULT.equals((Object)info.getFundDispatchType()) && cs015 && !MBG_C001.booleanValue()) {
            for (int i = 0; i < info.getEntries().size(); ++i) {
                PaymentBillEntryInfo entryInfo = info.getEntries().get(i);
                if (!EmptyUtil.isEmpty((String)entryInfo.getOutBgItemId())) continue;
                throw new RuntimeException(CASWebUtil.getResource(ctx, "317_OUTBGITEM_NOT_EMPTY"));
            }
        }
        if ((settType = info.getSettlementType()) != null && settType.getNtType() != null && NTTypeGroupEnum.RECEIVABLE.equals((Object)settType.getNtType().getSuperGroup())) {
            String txtSettleNum = info.getSettlementNumber();
            boolean isMatch = this.isSettleBillCurrencyMatch(info);
            if (!isMatch) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "320_settleBillCurrencyWrong"));
            }
            BigDecimal receivableBillAmt = this.getSettleAmt(info.getSettlementNumber(), info.getActPayAmt());
            BigDecimal locAmt = info.getActPayLocAmt();
            if (!EmptyUtil.isEmpty((String)txtSettleNum) && locAmt.compareTo(receivableBillAmt) != 0) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "322_payableBillAmtWrong"));
            }
        }
        this.verifyAssItem(ctx, info);
        if (param.get("CS103") != null && !(cs103 = ((Boolean)param.get("CS103")).booleanValue()) && info.getBizDate() != null && !SourceTypeEnum.AP.equals((Object)info.getSourceType()) && (periodInfo = SystemStatusCtrolUtils.getCurrentPeriod(ctx, SystemEnum.CASHMANAGEMENT, info.getCompany())) != null && info.getBizDate().before(periodInfo.getBeginDate())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "325_BizDateBeforeBeginDate"));
        }
        if (info.getAgentPayCompany() != null && info.getAgentPayCompany().getId().equals((Object)info.getCompany().getId())) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "COMPANY_AND_REALCOMPANY_CANNOT_SAME"));
        }
    }

    private void verifyAssItem(Context ctx, PaymentBillInfo editData) {
        AssItemsForCashPayCollection ac = editData.getAssItems();
        for (int i = 0; i < ac.size(); ++i) {
            AssItemsForCashPayInfo infoAc = ac.get(i);
            if (infoAc.isIsSelected() && EmptyUtil.isEmpty((String)infoAc.getFromNumber())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "OPPITEM_REQUIRED"));
            }
            if (EmptyUtil.isEmpty((String)infoAc.getFromNumber()) || infoAc.isIsSelected()) continue;
            throw new RuntimeException(CASWebUtil.getResource(ctx, "OPPITEM_SHOULD_BENULL"));
        }
        PaymentBillEntryCollection entryCol = editData.getEntries();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            PaymentBillEntryInfo info = entryCol.get(i);
            AssItemsForCashPayCollection assCol = info.getAssItemsEntries();
            int assColSize = assCol.size();
            for (int j = 0; j < assColSize; ++j) {
                AssItemsForCashPayInfo infoAc = assCol.get(j);
                if (infoAc.isIsSelected() && EmptyUtil.isEmpty((String)infoAc.getFromNumber())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "OPPITEM_REQUIRED"));
                }
                if (EmptyUtil.isEmpty((String)infoAc.getFromNumber()) || infoAc.isIsSelected()) continue;
                throw new RuntimeException(CASWebUtil.getResource(ctx, "OPPITEM_SHOULD_BENULL"));
            }
        }
    }

    private BigDecimal getSettleAmt(Object obj, BigDecimal settlementAmt) {
        BigDecimal amt = Constants.ZERO;
        if (obj == null) {
            return amt;
        }
        if (obj instanceof ReceivableBillInfo) {
            ReceivableBillInfo receivableBill = (ReceivableBillInfo)obj;
            amt = receivableBill.getBillAmt();
        } else if (obj instanceof Object[]) {
            Object[] receivableBillColl = (Object[])obj;
            for (int i = 0; i < receivableBillColl.length; ++i) {
                ReceivableBillInfo receivableBill = (ReceivableBillInfo)receivableBillColl[i];
                amt = amt.add(receivableBill.getBillAmt());
            }
        } else {
            amt = settlementAmt;
        }
        return amt;
    }

    private boolean isSettleBillCurrencyMatch(PaymentBillInfo info) {
        CurrencyInfo currency = info.getCurrency();
        String obj = info.getSettlementNumber();
        boolean isMatch = true;
        if (obj == null || EmptyUtil.isEmpty((String)obj.toString())) {
            return true;
        }
        if (obj instanceof ReceivableBillInfo) {
            ReceivableBillInfo receivableBill = (ReceivableBillInfo)obj;
            if (!currency.getId().equals((Object)receivableBill.getCurrency().getId())) {
                isMatch = false;
            }
        } else if (obj instanceof Object[]) {
            Object[] receivableBillColl = (Object[])obj;
            for (int i = 0; i < receivableBillColl.length; ++i) {
                ReceivableBillInfo receivableBill = (ReceivableBillInfo)receivableBillColl[i];
                if (currency.getId().equals((Object)receivableBill.getCurrency().getId())) continue;
                isMatch = false;
            }
        }
        return isMatch;
    }

    private boolean getBankAccountNumberBelong(String companyNumber, String bankAccountNumber, Context ctx) throws BOSException {
        String sql = " SELECT fBankAccountNumber FROM T_BD_AccountBanks where FCompanyID='" + companyNumber + "' and fBankAccountNumber ='" + bankAccountNumber + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            SysUtil.abort((Throwable)e);
        }
        return false;
    }

    private boolean getAccountBelong(String companyId, List<String> accountIdList, String bankacctNumber, Context ctx) throws BOSException {
        StringBuffer accountIds = new StringBuffer();
        for (String accountId : accountIdList) {
            accountIds.append("'" + accountId + "',");
        }
        accountIds.deleteCharAt(accountIds.length() - 1);
        String sql = "SELECT ab.fid FROM T_BD_AccountBanks ab ,T_ORG_Company c ,T_BD_AccountView av where ab.FCompanyID = c.FID and c.FID = '" + companyId + "' and ab.FAccountID = av.FID and av.FID in (" + accountIds.toString() + ") and ab.fbankaccountnumber = '" + bankacctNumber + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            SysUtil.abort((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _auditById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "AUDIT_SUCCESS");
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        boolean isCanUpdate = false;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            isCanUpdate = iMutex.requestObjIDForUpdate(id);
            if (!isCanUpdate) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            if (info == null || !PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                throw new CasWebException(CasWebException.NO_EXIST);
            }
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_05audit");
            } else {
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_05audit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                }
            }
            PaymentBillFactory.getLocalInstance(ctx).audit(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isCanUpdate) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _audit4CaById(Context ctx, String id, String plainText, String signature) throws BOSException, EASBizException {
        String permission = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "AUDIT_SUCCESS");
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanAudit = false;
        try {
            isCanAudit = iMutex.requestObjIDForUpdate(id);
            if (!isCanAudit) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                permission = "fundDispatchBill_05audit";
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_05audit");
            } else {
                permission = "cas_paymentbill_05audit";
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_05audit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                }
            }
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = new ArrayList<String>();
            list.add(id);
            iEASSignature.checkSignature4Web(list, permission);
            iEASSignature.checkSignature4Web(plainText, signature, permission);
            PaymentBillFactory.getLocalInstance(ctx).audit(idList);
            iEASSignature.checkSignature4Web(list, permission);
            iEASSignature.saveSignature4Web(signature, plainText, id, permission);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isCanAudit) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        PaymentBillInfo info;
        int i;
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        PaymentBillCollection collsNew = new PaymentBillCollection();
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        ArrayList<String> idListAll = new ArrayList<String>();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            idListAll.add(ids[i2]);
        }
        if (ids.length != colls.size()) {
            ArrayList<String> existIdList = new ArrayList<String>();
            for (i = 0; i < colls.size(); ++i) {
                info = colls.get(i);
                existIdList.add(info.getId().toString());
            }
            for (i = 0; i < idListAll.size(); ++i) {
                if (existIdList.contains(idListAll.get(i))) continue;
                result.getDetailMsgList().add("null," + CASWebUtil.getResource(ctx, "NOT_EXIST"));
            }
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            this.requesMutexs(ctx, idListAll, correctList, lockedList);
            if (lockedList.size() > 0) {
                for (i = 0; i < colls.size(); ++i) {
                    info = colls.get(i);
                    if (lockedList.contains(info.getId().toString())) {
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "HAS_LOCKED")}));
                        continue;
                    }
                    collsNew.add(info);
                }
            } else {
                collsNew = colls;
            }
            HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
            for (int i3 = 0; i3 < collsNew.size(); ++i3) {
                PaymentBillInfo info2 = collsNew.get(i3);
                try {
                    boolean isPermission;
                    if (isFundDispatch) {
                        if (!permissionSet.contains(info2.getCompany().getId())) {
                            isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info2.getCompany().getId()), "fundDispatchBill_05audit");
                            if (!isPermission) {
                                String msg = FDUtils.getResource((Context)ctx, (String)"064_NO_AUDIT_AUTH", (String[])new String[]{info2.getCompany().getName()});
                                result.getDetailMsgList().add(FDUtils.getResource((Context)ctx, (String)"010_AUDIT_FAIL_REASON", (String[])new String[]{info2.getNumber(), msg}));
                                continue;
                            }
                            permissionSet.add(info2.getCompany().getId());
                        }
                    } else if (!permissionSet.contains(info2.getCompany().getId())) {
                        isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info2.getCompany().getId()), "cas_paymentbill_05audit");
                        if (!isPermission) {
                            throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                        }
                        permissionSet.add(info2.getCompany().getId());
                    }
                    String billId = info2.getId().toString();
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add(billId);
                    PaymentBillFactory.getLocalInstance(ctx).audit(idSet);
                    ++success;
                    continue;
                }
                catch (WfBizException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_AUDIT_FAILED", new String[]{info2.getCompany().getName(), info2.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_AUDIT_FAILED", new String[]{info2.getCompany().getName(), info2.getNumber(), e.getMessage()}));
                }
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(correctList);
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "AUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unauditById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "UNAUDIT_SUCCESS");
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanAudit = false;
        try {
            isCanAudit = iMutex.requestObjIDForUpdate(id);
            if (!isCanAudit) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_06antiAudit");
            } else {
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_06antiAudit");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_UNAUDIT_AUTHRIZED);
                }
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            paymentBill.antiAudit(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isCanAudit) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchUnaudit(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < colls.size(); ++i) {
            boolean isCanAudit = false;
            PaymentBillInfo info = colls.get(i);
            HashSet<String> idList = new HashSet<String>();
            idList.add(info.getId().toString());
            try {
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                if (isFundDispatch) {
                    if (!permissionSet.contains(info.getCompany().getId())) {
                        boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "fundDispatchBill_06antiAudit");
                        if (!isPermission) {
                            String msg = FDUtils.getResource((Context)ctx, (String)"067_NO_UNAUDIT_AUTH", (String[])new String[]{info.getCompany().getName()});
                            result.getDetailMsgList().add(FDUtils.getResource((Context)ctx, (String)"015_ANTIAUDIT_FAIL_REASON", (String[])new String[]{info.getNumber(), msg}));
                            continue;
                        }
                        permissionSet.add(info.getCompany().getId());
                    }
                } else if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_06antiAudit");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_UNAUDIT_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                paymentBill.antiAudit(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_UNAUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_UNAUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isCanAudit) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "UNAUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _commitSettleById(Context ctx, String id, String[] planIds) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "467_COMMITSETTLE_SUCCESS");
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        boolean isCanUpdate = false;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            isCanUpdate = iMutex.requestObjIDForUpdate(id);
            if (!isCanUpdate) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
        }
        finally {
            if (isCanUpdate) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        try {
            if (!PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(id))) {
                throw new CasWebException(CasWebException.NO_EXIST);
            }
            paymentBill.commitSettle(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.equals((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.equals(e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _cancelCommitSettleById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "465_CANCELCOMMITSETTLE_SUCCESS");
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanAudit = false;
        try {
            isCanAudit = iMutex.requestObjIDForUpdate(id);
            if (!isCanAudit) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            paymentBill.cancelCommitSettle(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isCanAudit) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _payById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "PAY_SUCCESS");
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        boolean isCanUpdate = false;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            isCanUpdate = iMutex.requestObjIDForUpdate(id);
            if (!isCanUpdate) {
                throw new FMException(FMException.COMMMONEXCEPTION, (Object[])new String[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
        }
        finally {
            if (isCanUpdate) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        try {
            if (info == null || !PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                throw new CasWebException(CasWebException.NO_EXIST);
            }
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_09pay");
            } else {
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_09pay");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
                }
            }
            paymentBill.pay(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _cancelPayById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "CANCELPAY_SUCCESS");
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isLock = false;
        try {
            isLock = iMutex.requestObjIDForUpdate(id);
            if (!isLock) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_10cancelPay");
            } else {
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_10cancelPay");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_CANCELPAY_AUTHRIZED);
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
            }
            paymentBill.cancelPay(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "CANCELPAY_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isLock) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _imageById(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
            String imageUrl = image.getImageURL(BOSUuid.read((String)id).getType().toString(), id);
            if (StringUtils.isEmpty((String)imageUrl) || "null".equalsIgnoreCase(imageUrl)) {
                pageModel.put("error", 1);
                pageModel.put("summaryMsg", CASWebUtil.getResource(ctx, "ShareCenter_NO_ImageUrl"));
            } else {
                pageModel.put("error", 0);
                pageModel.put("imageUrl", imageUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("summaryMsg", CASWebUtil.getResource(ctx, "ShareCenter_NO_ImageUrl"));
        }
        return pageModel;
    }

    protected Map getParamAndCheck(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        String companyId = company.getId().toString();
        if (CASWebHelper.isAdjustPeriod(ctx, company)) {
            throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
        }
        if (this.company2Map.containsKey(companyId)) {
            return (Map)this.company2Map.get(companyId);
        }
        Map param = CASWebHelper.getParamMap(ctx, company.getId().toString(), "CS053", "CS031", "CS031_01", "CS034", "CS027", "CS036", "CS045", "CS015", "CS073", "CS103", "CS035");
        this.company2Map.put(companyId, param);
        return param;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCommitSettle(Context ctx, String[] ids) throws BOSException, EASBizException {
        PaymentBillInfo info;
        int i;
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        PaymentBillCollection collsNew = new PaymentBillCollection();
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        ArrayList<String> idListAll = new ArrayList<String>();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            idListAll.add(ids[i2]);
        }
        if (ids.length != colls.size()) {
            ArrayList<String> existIdList = new ArrayList<String>();
            for (i = 0; i < colls.size(); ++i) {
                info = colls.get(i);
                existIdList.add(info.getId().toString());
            }
            for (i = 0; i < idListAll.size(); ++i) {
                if (existIdList.contains(idListAll.get(i))) continue;
                result.getDetailMsgList().add("null," + CASWebUtil.getResource(ctx, "NOT_EXIST"));
            }
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            this.requesMutexs(ctx, idListAll, correctList, lockedList);
            if (lockedList.size() > 0) {
                for (i = 0; i < colls.size(); ++i) {
                    info = colls.get(i);
                    if (lockedList.contains(info.getId().toString())) {
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "462_PAYMENTBILL_COMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "HAS_LOCKED")}));
                        continue;
                    }
                    collsNew.add(info);
                }
            } else {
                collsNew = colls;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(correctList);
        }
        for (i = 0; i < collsNew.size(); ++i) {
            info = collsNew.get(i);
            HashSet<String> idList = new HashSet<String>();
            idList.add(info.getId().toString());
            try {
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                PaymentBillFactory.getLocalInstance(ctx).commitSettle(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "462_PAYMENTBILL_COMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "462_PAYMENTBILL_COMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "463_ALL_COMMITSETTLE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "464_COMMITSETTLE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCancelCommitSettle(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < colls.size(); ++i) {
            boolean isCanAudit = false;
            PaymentBillInfo info = colls.get(i);
            HashSet<String> idList = new HashSet<String>();
            idList.add(info.getId().toString());
            try {
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                paymentBill.cancelCommitSettle(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "459_PAYMENTBILL_CANCELCOMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "459_PAYMENTBILL_CANCELCOMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isCanAudit) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "460_ALL_CANCELCOMMITSETTLE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "461_CANCELCOMMITSETTLE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchPay(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        PaymentBillInfo info;
        int i;
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        PaymentBillCollection collsNew = new PaymentBillCollection();
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        ArrayList<String> idListAll = new ArrayList<String>();
        for (int i2 = 0; i2 < ids.length; ++i2) {
            idListAll.add(ids[i2]);
        }
        if (ids.length != colls.size()) {
            ArrayList<String> existIdList = new ArrayList<String>();
            for (i = 0; i < colls.size(); ++i) {
                info = colls.get(i);
                existIdList.add(info.getId().toString());
            }
            for (i = 0; i < idListAll.size(); ++i) {
                if (existIdList.contains(idListAll.get(i))) continue;
                result.getDetailMsgList().add("null," + CASWebUtil.getResource(ctx, "NOT_EXIST"));
            }
        }
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            this.requesMutexs(ctx, idListAll, correctList, lockedList);
            if (lockedList.size() > 0) {
                for (i = 0; i < colls.size(); ++i) {
                    info = colls.get(i);
                    if (lockedList.contains(info.getId().toString())) {
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_PAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "HAS_LOCKED")}));
                        continue;
                    }
                    collsNew.add(info);
                }
            } else {
                collsNew = colls;
            }
        }
        finally {
            iMutex.batchReleaseObjIDForUpdate(correctList);
        }
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i3 = 0; i3 < collsNew.size(); ++i3) {
            PaymentBillInfo info2 = collsNew.get(i3);
            try {
                boolean isPermission;
                if (isFundDispatch) {
                    if (!permissionSet.contains(info2.getCompany().getId())) {
                        isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info2.getCompany().getId()), "fundDispatchBill_09pay");
                        if (!isPermission) {
                            String msg = FDUtils.getResource((Context)ctx, (String)"068_NO_PAY_AUTH", (String[])new String[]{info2.getCompany().getName()});
                            result.getDetailMsgList().add(FDUtils.getResource((Context)ctx, (String)"071_PAYFAIL_RESON", (String[])new String[]{info2.getNumber(), msg}));
                            continue;
                        }
                        permissionSet.add(info2.getCompany().getId());
                    }
                } else if (!permissionSet.contains(info2.getCompany().getId())) {
                    isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info2.getCompany().getId()), "cas_paymentbill_09pay");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
                    }
                    permissionSet.add(info2.getCompany().getId());
                }
                HashSet<String> idList = new HashSet<String>();
                idList.add(info2.getId().toString());
                paymentBill.pay(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_PAY_FAILED", new String[]{info2.getCompany().getName(), info2.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_PAY_FAILED", new String[]{info2.getCompany().getName(), info2.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_PAY_SUCCESS") : summary + CASWebUtil.getResource(ctx, "PAY_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCancelPay(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("settleBizType"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CASWebUtil.ids2Set(ids), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sic);
        PaymentBillCollection coll = paymentBill.getPaymentBillCollection(evi);
        BatchExecuteResult result = new BatchExecuteResult();
        int billNum = ids.length;
        int success = 0;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        HashSet canceledIds = new HashSet();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < coll.size(); ++i) {
            PaymentBillInfo info = coll.get(i);
            if (canceledIds.contains(info.getId().toString())) {
                --billNum;
                continue;
            }
            HashSet<String> idList = new HashSet<String>();
            String id = info.getId().toString();
            idList.add(id);
            boolean isCanAudit = false;
            try {
                boolean isPermission;
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                if (isFundDispatch) {
                    if (!permissionSet.contains(info.getCompany().getId())) {
                        isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "fundDispatchBill_10cancelPay");
                        if (!isPermission) {
                            String msg = FDUtils.getResource((Context)ctx, (String)"069_NO_CANCELPAY_AUTH", (String[])new String[]{info.getCompany().getName()});
                            result.getDetailMsgList().add(FDUtils.getResource((Context)ctx, (String)"072_CANCELPAYFAIL_RESON", (String[])new String[]{info.getNumber(), msg}));
                            continue;
                        }
                        permissionSet.add(info.getCompany().getId());
                    }
                } else if (!permissionSet.contains(info.getCompany().getId())) {
                    isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_10cancelPay");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_CANCELPAY_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    throw new RecPayException(RecPayException.CANNOT_CANCELPAY_BEFORE_PAYED);
                }
                Map param = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS110");
                boolean isInsideSettleAutoRecPay = (Boolean)param.get("CS110");
                if (isInsideSettleAutoRecPay && info.getSettleBizType() != null && (info.getSettleBizType().equals((Object)SettBizTypeEnum.PAYINSIDE) || info.getSettleBizType().equals((Object)SettBizTypeEnum.PAYINSIDEDIF) || info.getSettleBizType().equals((Object)SettBizTypeEnum.RECINSIDE) || info.getSettleBizType().equals((Object)SettBizTypeEnum.RECINSIDEDIF))) {
                    if (11 != info.getSettlementStatus().getValue() && 12 != info.getSettlementStatus().getValue()) continue;
                    String msg = CASWebUtil.getResource(ctx, "620_SolutionSetService");
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_CANCELPAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), msg}));
                    continue;
                }
                Set realIds = new HashSet();
                if (info.getBillStatus().equals((Object)BillStatusEnum.PAYED)) {
                    realIds = RecPayHelper.getAllScrID(ctx, idList);
                    paymentBill.cancelPay(idList);
                }
                if (info.isPcaVouchered()) {
                    throw new RecPayException(RecPayException.HAS_PCAVOUCHER);
                }
                if (realIds.size() > 1) {
                    billNum += realIds.size() - 1;
                    success += realIds.size() - 1;
                    canceledIds.addAll(realIds);
                }
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_CANCELPAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_CANCELPAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isCanAudit) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{billNum + ""});
        summary = success == billNum ? summary + CASWebUtil.getResource(ctx, "ALL_CANCELPAY_SUCCESS") : summary + CASWebUtil.getResource(ctx, "CANCELPAY_RESULT", new String[]{String.valueOf(success), String.valueOf(billNum - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchDelete(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("isRefundmentPay"));
        sic.add(new SelectorItemInfo("srcAgenPaymentBillID"));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < colls.size(); ++i) {
            PaymentBillInfo info = colls.get(i);
            HashSet<String> idList = new HashSet<String>();
            String id = info.getId().toString();
            idList.add(id);
            boolean b = false;
            try {
                boolean isPermission;
                b = iMutex.requestObjIDForUpdate(id);
                if (!b) {
                    throw new Exception(CASWebUtil.getResource(ctx, "610_CantOpreateWhileOtherUse"));
                }
                if (isFundDispatch) {
                    if (!permissionSet.contains(info.getCompany().getId())) {
                        isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "fundDispatchBill_04remove");
                        if (!isPermission) {
                            String msg = FDUtils.getResource((Context)ctx, (String)"065_NO_DELETE_AUTH", (String[])new String[]{info.getCompany().getName()});
                            result.getDetailMsgList().add(FDUtils.getResource((Context)ctx, (String)"073_DELETEFAIL_RESON", (String[])new String[]{info.getNumber(), msg}));
                            continue;
                        }
                        permissionSet.add(info.getCompany().getId());
                    }
                } else if (!permissionSet.contains(info.getCompany().getId())) {
                    isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_04remove");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                String sourceBillId = info.getSourceBillId();
                if (!EmptyUtil.isEmpty((String)sourceBillId)) {
                    BOSUuid sbid = BOSUuid.read((String)sourceBillId);
                    if (sbid.getType().equals((Object)new ReceivingBillInfo().getBOSType())) {
                        throw new RecPayException(RecPayException.CANNOTDELETERECFORSOURCE);
                    }
                    if (sbid.getType().equals((Object)new PaymentBillInfo().getBOSType()) && !info.isIsTransBill() && !StringUtils.isEmpty((String)info.getSrcAgenPaymentBillID())) {
                        throw new RecPayException(RecPayException.AGENTPAYBILLNOTDELETE);
                    }
                    BOSObjectType transUpBillInfo_Type = new TransUpBillInfo().getBOSType();
                    if (transUpBillInfo_Type.equals((Object)sbid.getType())) {
                        throw new RecPayException(RecPayException.PAYMENTBILLDELETEERROR, new Object[]{info.getNumber()});
                    }
                }
                if (!(b = iMutex.requestObjIDForUpdate(id))) {
                    throw new Exception(CASWebUtil.getResource(ctx, "610_CantOpreateWhileOtherUse"));
                }
                PaymentBillFactory.getLocalInstance(ctx).batchRemove(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (b) {
                    iMutex.releaseObjIDForUpdate(id);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    @Override
    protected Map _getSumInfo(Context ctx, String filter, String selectedIds) throws BOSException, EASBizException {
        IQueryExecutor queryExecutor;
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer selectIdSql = new StringBuffer("SELECT id where " + filter);
        if (filter.indexOf("isCBPay = 1") != -1) {
            queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fm.cbs.app.CBPaymentWebQuery"));
            queryExecutor.setObjectView(selectIdSql.toString());
            IRowSet rowSet = queryExecutor.executeQuery();
            try {
                while (rowSet.next()) {
                    idSet.add(rowSet.getString("id"));
                }
            }
            catch (Exception e) {
                result.put("error", 1);
                result.put("msg", e.getMessage());
                e.printStackTrace();
            }
        }
        queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.CasPaymentBillSumQuery"));
        ObjectUuidPK userPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId());
        String sql = PermissionFactory.getLocalInstance((Context)ctx).getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "cas_paymentbill_01view");
        sql = filter.indexOf("isCBPay = 1") != -1 ? "SELECT billCount,moneySum where id in " + FMHelper.setTran2String(idSet) : "SELECT billCount,moneySum where " + filter;
        queryExecutor.setObjectView(sql);
        String ssql = queryExecutor.getSQL();
        IRowSet rowSet = queryExecutor.executeQuery();
        try {
            rowSet.next();
            result.put("billCount", rowSet.getBigDecimal("billCount"));
            result.put("moneySum", rowSet.getBigDecimal("moneySum"));
            result.put("error", 0);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        HashMap<String, BigDecimal> idMap = new HashMap<String, BigDecimal>();
        queryExecutor.setObjectView("SELECT id,actPayLocAmt where " + filter);
        try {
            rowSet = queryExecutor.executeQuery();
            while (rowSet.next()) {
                idMap.put(rowSet.getString("id"), rowSet.getBigDecimal("actPayLocAmt"));
            }
            result.put("idMap", idMap);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        StringBuffer validIdSql = new StringBuffer("SELECT id where " + filter + " and id in('NE'");
        ArrayList<String> validIdList = new ArrayList<String>();
        if (!"".equals(selectedIds)) {
            String[] idArr = selectedIds.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                validIdSql.append(",'" + idArr[i] + "'");
            }
            validIdSql.append(")");
            String QueryName = "com.kingdee.eas.fi.cas.PaymentBillWebQuery";
            if (filter.indexOf("isCBPay") != -1) {
                QueryName = "com.kingdee.eas.fm.cbs.app.CBPaymentWebQuery";
            }
            queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(QueryName));
            queryExecutor.setObjectView(validIdSql.toString());
            rowSet = queryExecutor.executeQuery();
            try {
                while (rowSet.next()) {
                    validIdList.add(rowSet.getString("id"));
                }
            }
            catch (Exception e) {
                result.put("error", 1);
                result.put("msg", e.getMessage());
                e.printStackTrace();
            }
        }
        if (filter.indexOf("isCBPay") != -1) {
            Object[] set = idMap.keySet().toArray();
            StringBuffer sb = new StringBuffer(1024);
            for (int i = 0; i < set.length; ++i) {
                if (i == set.length - 1) {
                    StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                    continue;
                }
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                sb.append(",");
            }
            sb.append(")");
            String sql3 = "select actPayAmt,currency.name,currency.isoCode,currency.precision where id in (" + sb.toString();
            sql3 = sql3.replace("lower", "");
            HashMap<String, String[]> currencyInfoMap = new HashMap<String, String[]>();
            PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(sql3);
            for (int i = 0; i < coll.size(); ++i) {
                String[] currencyInfo = new String[3];
                String currencyName = coll.get(i).getCurrency().getName();
                String currencyISO = coll.get(i).getCurrency().getIsoCode();
                int precision = coll.get(i).getCurrency().getPrecision();
                if (precision == 0) {
                    precision = 2;
                }
                BigDecimal actPayAmt = coll.get(i).getActPayAmt().setScale(precision, 4);
                currencyInfo[0] = currencyName;
                currencyInfo[1] = currencyISO;
                currencyInfo[2] = actPayAmt.toString();
                currencyInfoMap.put(coll.get(i).getId().toString(), currencyInfo);
            }
            result.put("currencyInfoMap", currencyInfoMap);
        }
        result.put("validIdList", validIdList);
        return result;
    }

    @Override
    protected PaymentBillInfo _createNewModel(Context ctx, String companyId, String operate, String billId, Map param) throws BOSException, EASBizException {
        PaymentBillInfo info;
        block35: {
            block36: {
                Map allAssGrpMap;
                PaymentBillEntryCollection entries;
                SelectorItemCollection mergeSelectors;
                block34: {
                    AsstActTypeCollection asstActTypeColl;
                    info = null;
                    SelectorItemCollection selectorColl = this.getSelector();
                    SelectorItemCollection dynSelectorColl = (SelectorItemCollection)param.get("copySelector");
                    mergeSelectors = PaymentBillWebFacadeControllerBean.getMergedSelector(selectorColl, dynSelectorColl);
                    if (operate != null) break block34;
                    CompanyOrgUnitInfo addNewDefaultcompany = (CompanyOrgUnitInfo)param.get("company");
                    info = new PaymentBillInfo();
                    info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
                    info.setCU(addNewDefaultcompany.getCU());
                    info.setBizDate(new Date());
                    info.setSourceType(SourceTypeEnum.CASH);
                    info.setSourceSysType(SourceTypeEnum.CASH);
                    info.setCompany(addNewDefaultcompany);
                    info.setExchangeRate(new BigDecimal("1"));
                    info.setCurrency(addNewDefaultcompany.getBaseCurrency());
                    info.setCreator((UserInfo)param.get("userInfo"));
                    info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    info.setPayeeName(null);
                    info.setPayeeNumber(null);
                    info.setBillStatus(BillStatusEnum.SAVE);
                    info.setIsDifferPlace(DifPlaceEnum.samePlace);
                    info.setIsEmergency(IsMergencyEnum.normal);
                    info.setFundDispatchType(FundDispatchTypeEnum.PAYMENT_DEFAULT);
                    PaymentBillEntryInfo entryInfo = new PaymentBillEntryInfo();
                    entryInfo.setSeq(1);
                    info.getEntries().add(entryInfo);
                    info.setSettleFeeType(SettleFeeTypeEnum.PayerPay);
                    info.setSettlementType(this.getDefaultSettleType(ctx));
                    PaymentBillTypeInfo defaultBillTypeInfo = this.getDefaultBillType(ctx);
                    if (defaultBillTypeInfo == null) {
                        EntityViewInfo ev = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        ev.setFilter(filter);
                        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
                        PaymentBillTypeCollection coll = PaymentBillTypeFactory.getLocalInstance(ctx).getPaymentBillTypeCollection(ev);
                        if (coll != null && !coll.isEmpty()) {
                            defaultBillTypeInfo = coll.get(0);
                        }
                    }
                    if (null != defaultBillTypeInfo && DeletedStatusEnum.DELETED.equals((Object)defaultBillTypeInfo.getDeletedStatus())) {
                        defaultBillTypeInfo = null;
                    }
                    if (defaultBillTypeInfo != null) {
                        info.setPayBillType(defaultBillTypeInfo);
                        info.setSourceSysType(defaultBillTypeInfo.getSourceSysType());
                    }
                    if ((asstActTypeColl = (AsstActTypeCollection)param.get("asstActTypeCollection")).size() > 0 && param.get("defaultAsstActType") != null) {
                        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)param.get("defaultAsstActType");
                        info.setPayeeType(asstActTypeInfo);
                    }
                    EntityViewInfo countryEvi = new EntityViewInfo();
                    FilterInfo countryFilter = new FilterInfo();
                    countryFilter.getFilterItems().add(new FilterItemInfo("name", (Object)CASWebUtil.getResource(ctx, "191_CHINA")));
                    countryEvi.setFilter(countryFilter);
                    CountryCollection countryCol = CountryFactory.getLocalInstance((Context)ctx).getCountryCollection(countryEvi);
                    if (countryCol == null || countryCol.size() <= 0) break block35;
                    CountryInfo china = countryCol.get(0);
                    info.setFRecCountry(china);
                    break block35;
                }
                if (!"copy".equals(operate)) break block36;
                IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
                PaymentBillInfo oldInfo = (PaymentBillInfo)iPaymentBill.getValue((IObjectPK)new ObjectUuidPK(billId), mergeSelectors);
                if (!(!EmptyUtil.isEmpty(param.get("fromFD")) && ((Boolean)param.get("fromFD")).booleanValue() || oldInfo.getFundDispatchType().getValue() != 2 && oldInfo.getFundDispatchType().getValue() != 1)) {
                    throw new FDException(FDException.BILL_NO_COPY);
                }
                info = oldInfo.copy();
                if (!StringUtils.isEmpty((String)info.getPayeeID())) {
                    try {
                        BOSUuid uuid = BOSUuid.read((String)info.getPayeeID());
                        BOSObjectType customerType = new CustomerInfo().getBOSType();
                        BOSObjectType supplierType = new SupplierInfo().getBOSType();
                        if (customerType.equals((Object)uuid.getType()) || supplierType.equals((Object)uuid.getType())) {
                            MetaDataPK queryPk = null;
                            EntityViewInfo evi = new EntityViewInfo();
                            FilterInfo fi = new FilterInfo();
                            evi.setFilter(fi);
                            fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId));
                            fi.getFilterItems().add(new FilterItemInfo("id", (Object)info.getPayeeID()));
                            fi.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1));
                            if (customerType.equals((Object)uuid.getType())) {
                                queryPk = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery");
                                fi.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)0));
                            } else if (supplierType.equals((Object)uuid.getType())) {
                                queryPk = MetaDataPK.create((String)"com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery");
                                fi.getFilterItems().add(new FilterItemInfo("supplierCompany.isFreezePayment", (Object)0));
                                fi.getFilterItems().add(new FilterItemInfo("supplierCompany.usingStatus", (Object)0));
                            }
                            boolean exist = QueryDataAccessFactory.getLocalInstance((Context)ctx).hasResult((IMetaDataPK)queryPk, evi, new HashMap(), new QueryExecuteOption());
                            if (!exist) {
                                info.setPayeeID(null);
                                info.setPayeeName(null);
                                info.setPayeeNumber(null);
                            }
                        }
                    }
                    catch (BOSException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (null != (entries = info.getEntries()) && entries.size() > 0) {
                    for (int i = 0; i < entries.size(); ++i) {
                        ExpenseTypeInfo ex;
                        PaymentBillEntryInfo paymentBillEntryInfo = entries.get(i);
                        ExpenseTypeInfo expenseType = paymentBillEntryInfo.getExpenseType();
                        if (null == expenseType || null == (ex = (ExpenseTypeInfo)ExpenseTypeFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)new ObjectUuidPK(expenseType.getId().toString()))) || ex.isIsStart()) continue;
                        paymentBillEntryInfo.setExpenseType(null);
                    }
                }
                info.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
                info.setCU(oldInfo.getCU());
                info.setBillStatus(BillStatusEnum.SAVE);
                info.setBizDate(new Date());
                info.setSourceType(SourceTypeEnum.CASH);
                info.setSourceSysType(SourceTypeEnum.CASH);
                info.setCompany(oldInfo.getCompany());
                info.setCreator((UserInfo)param.get("userInfo"));
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                if (SourceTypeEnum.AP.equals((Object)oldInfo.getSourceType())) {
                    CompanyOrgUnitInfo currentCompany = info.getCompany();
                    String baseCurrencyId = currentCompany.getBaseCurrency().getId().toString();
                    String currencyId = info.getCurrency().getId().toString();
                    boolean isLocalCurrency = currencyId.equals(baseCurrencyId);
                    Map exchangeRate = CASCommonWebFacadeFactory.getLocalInstance(ctx).getExchangeRate(companyId, currencyId, info.getDate("bizDate"));
                    BigDecimal value = (BigDecimal)exchangeRate.get("exchangeRate");
                    if (isLocalCurrency) {
                        value = new BigDecimal("1.0");
                    }
                    info.setExchangeRate(value);
                    AccountBankInfo accountBank = null;
                    boolean isClosed = false;
                    try {
                        if (!EmptyUtil.isEmpty((CoreBaseInfo)oldInfo.getPayerAccountBank())) {
                            accountBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(oldInfo.getPayerAccountBank().getId().toString()));
                            isClosed = accountBank.isIsClosed();
                        }
                    }
                    catch (Exception e) {
                        throw new BOSException(e.getCause());
                    }
                    if (isClosed) {
                        info.setPayerAccount(null);
                        info.setPayerBank(null);
                        info.setPayerAccountBank(null);
                    }
                }
                if ((allAssGrpMap = this.getAssItems(ctx, billId)).get(billId) != null) {
                    info.getOppAccount().put("assgrp", allAssGrpMap.get(billId));
                }
                Object assgrp = null;
                AccountViewInfo oppAccountInfo = null;
                AccountViewInfo _oppAccountInfo = null;
                for (int i = 0; i < oldInfo.getEntries().size(); ++i) {
                    assgrp = allAssGrpMap.get(oldInfo.getEntries().get(i).getId().toString());
                    if (assgrp == null) continue;
                    oppAccountInfo = info.getEntries().get(i).getOppAccount();
                    _oppAccountInfo = (AccountViewInfo)oppAccountInfo.clone();
                    _oppAccountInfo.put("assgrp", assgrp);
                    info.getEntries().get(i).setOppAccount(_oppAccountInfo);
                }
                if (!H.same(param.get("isRefundPay"), (Object)true)) break block35;
                info.put("isRefundPay", true);
                info.put("transDetailId", (String)param.get("transDetailId"));
                info.put("refundPaymentBillId", oldInfo.getId().toString());
                info.setIsRefundmentPay(true);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                ev.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
                IPaymentBillType iPaymentBillType = PaymentBillTypeFactory.getLocalInstance(ctx);
                PaymentBillTypeInfo defaultBillTypeInfo = null;
                PaymentBillTypeCollection coll = iPaymentBillType.getPaymentBillTypeCollection(ev);
                if (coll != null && !coll.isEmpty()) {
                    defaultBillTypeInfo = coll.get(0);
                }
                info.setPayBillType(defaultBillTypeInfo);
                break block35;
            }
            if ("template".equals(operate)) {
                ITemplatePaymentBill iTemplatePaymentBill = TemplatePaymentBillFactory.getLocalInstance(ctx);
                TemplatePaymentBillInfo oldInfo = (TemplatePaymentBillInfo)iTemplatePaymentBill.getValue((IObjectPK)new ObjectUuidPK(billId), this.getTempSelector());
                info = new PaymentBillInfo();
                this.transferTempToPayment(info, oldInfo);
                info.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
                info.setBillStatus(BillStatusEnum.SAVE);
                info.setBizDate(new Date());
                info.setSourceType(SourceTypeEnum.CASH);
                info.setSourceSysType(SourceTypeEnum.CASH);
                info.setCompany(oldInfo.getCompany());
                info.setCreator((UserInfo)param.get("userInfo"));
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                Map allAssGrpMap = this.getAssItems4Template(ctx, billId);
                if (allAssGrpMap.get(billId) != null) {
                    info.getOppAccount().put("assgrp", allAssGrpMap.get(billId));
                }
                AccountViewInfo oppAccountInfo = null;
                AccountViewInfo _oppAccountInfo = null;
                for (int i = 0; i < oldInfo.getEntries().size(); ++i) {
                    Object assgrp = allAssGrpMap.get(oldInfo.getEntries().get(i).getId().toString());
                    if (assgrp == null || (oppAccountInfo = info.getEntries().get(i).getOppAccount()) == null) continue;
                    _oppAccountInfo = (AccountViewInfo)oppAccountInfo.clone();
                    _oppAccountInfo.put("assgrp", assgrp);
                    info.getEntries().get(i).setOppAccount(_oppAccountInfo);
                }
            } else if ("offset".equals(operate)) {
                IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
                PaymentBillInfo oldInfo = (PaymentBillInfo)iPaymentBill.getValue((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
                DeepClone cloneUtil = new DeepClone();
                try {
                    info = (PaymentBillInfo)cloneUtil.copyOppValueInfo((CoreBaseInfo)oldInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BOSException((Throwable)e);
                }
                this.setNotCopyValues(info);
                info.setPaymentBillType(CasRecPayBillTypeEnum.commonType);
                info.setExchangeRate(info.getExchangeRate().abs());
                info.setBillStatus(BillStatusEnum.SAVE);
                info.setBizDate(new Date());
                info.setSourceType(SourceTypeEnum.CASH);
                info.setSourceSysType(SourceTypeEnum.CASH);
                info.setCompany(oldInfo.getCompany());
                info.setCreator((UserInfo)param.get("userInfo"));
                info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                Map allAssGrpMap = this.getAssItems(ctx, billId);
                if (allAssGrpMap.get(billId) != null) {
                    info.getOppAccount().put("assgrp", allAssGrpMap.get(billId));
                }
                AccountViewInfo oppAccountInfo = null;
                AccountViewInfo _oppAccountInfo = null;
                for (int i = 0; i < oldInfo.getEntries().size(); ++i) {
                    Object assgrp = allAssGrpMap.get(oldInfo.getEntries().get(i).getId().toString());
                    if (assgrp == null || (oppAccountInfo = info.getEntries().get(i).getOppAccount()) == null) continue;
                    _oppAccountInfo = (AccountViewInfo)oppAccountInfo.clone();
                    _oppAccountInfo.put("assgrp", assgrp);
                    info.getEntries().get(i).setOppAccount(_oppAccountInfo);
                }
            }
        }
        return info;
    }

    public static SelectorItemCollection getMergedSelector(SelectorItemCollection coll, SelectorItemCollection dynColl) {
        if (dynColl == null || dynColl.size() == 0) {
            return coll;
        }
        if (coll.size() == 0) {
            coll.add("*");
        }
        int size = dynColl.size();
        for (int i = 0; i < size; ++i) {
            coll.add(dynColl.get(i));
        }
        return coll;
    }

    private SettlementTypeInfo getDefaultSettleType(Context ctx) {
        SettlementTypeInfo defaultValue = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE));
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("ntType.group");
        sic.add("ntType.superGroup");
        sic.add("payThroughBE");
        view.setFilter(filter);
        view.setSelector(sic);
        try {
            SettlementTypeCollection colls = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
            if (colls.size() > 0) {
                defaultValue = colls.get(0);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    private void transferTempToPayment(PaymentBillInfo info, TemplatePaymentBillInfo oldInfo) {
        int i;
        info.setCompany(oldInfo.getCompany());
        info.setActPayAmt(oldInfo.getActPayAmt());
        info.setActPayLocAmt(oldInfo.getActPayLocAmt());
        info.setPayBillType(oldInfo.getPayBillType());
        info.setFeeType(oldInfo.getFeeType());
        info.setCurrency(oldInfo.getCurrency());
        info.setExchangeRate(oldInfo.getExchangeRate());
        info.setPayerAccount(oldInfo.getPayerAccount());
        info.setPayerAccountBank(oldInfo.getPayerAccountBank());
        info.setPayerBank(oldInfo.getPayerBank());
        info.setBizType(oldInfo.getBizType());
        info.setSettlementType(oldInfo.getSettlementType());
        info.setSettlementNumber(oldInfo.getSettlementNumber());
        info.setAdminOrgUnit(oldInfo.getAdminOrgUnit());
        info.setOutBgItemId(oldInfo.getOutBgItemId());
        info.setOutBgItemName(oldInfo.getOutBgItemName());
        info.setOutBgItemNumber(oldInfo.getOutBgItemNumber());
        info.setOppBgItemId(oldInfo.getOppBgItemId());
        info.setOppBgItemName(oldInfo.getOppBgItemName());
        info.setOppBgItemNumber(oldInfo.getOppBgItemNumber());
        info.setCostCenter(oldInfo.getCostCenter());
        info.setPerson(oldInfo.getPerson());
        info.setPayeeType(oldInfo.getPayeeType());
        info.setPayeeName(oldInfo.getPayeeName());
        info.setPayeeID(oldInfo.getPayeeID());
        info.setPayeeAccountBank(oldInfo.getPayeeAccountBank());
        info.setPayeeAccountBankO(oldInfo.getPayeeAccountBankO());
        info.setPayeeBank(oldInfo.getPayeeBank());
        info.setPayeeArea(oldInfo.getPayeeArea());
        info.setPayeeNumber(oldInfo.getPayeeNumber());
        info.setFRecCountry(oldInfo.getFRecCountry());
        info.setRecCity(oldInfo.getRecCity());
        info.setRecProvince(oldInfo.getRecProvince());
        info.setIsDifferPlace(oldInfo.getIsDifferPlace());
        info.setIsDifBank(oldInfo.getIsDifBank());
        info.setIsEmergency(oldInfo.getIsEmergency());
        info.setUsage(oldInfo.getUsage());
        info.setProject(oldInfo.getProject());
        info.setProjectManager(oldInfo.getProjectManager());
        info.setDescription(oldInfo.getDescription());
        info.setOppAccount(oldInfo.getOppAccount());
        info.setBankAcctName(oldInfo.getBankAcctName());
        info.setBankNumber(oldInfo.getBankNumber());
        PaymentBillEntryInfo paymentBillEntry = null;
        TemplatePaymentBillEntryInfo templatePaymentBillEntry = null;
        AssItemsForCashPayInfo cashPayInfo = null;
        AssItemsForTmplPayInfo tmplPayInfo = null;
        for (i = 0; i < oldInfo.getAssItems().size(); ++i) {
            cashPayInfo = new AssItemsForCashPayInfo();
            tmplPayInfo = oldInfo.getAssItems().get(i);
            cashPayInfo.setAsstActType(tmplPayInfo.getAsstActType());
            cashPayInfo.setFromID(tmplPayInfo.getFromID());
            cashPayInfo.setFromNumber(tmplPayInfo.getFromNumber());
            cashPayInfo.setIsSelected(tmplPayInfo.isIsSelected());
            cashPayInfo.setMappingFileds(tmplPayInfo.getMappingFileds());
            cashPayInfo.setTableName(tmplPayInfo.getTableName());
            cashPayInfo.setEntrySeq(tmplPayInfo.getEntrySeq());
            cashPayInfo.setSeq(tmplPayInfo.getSeq());
            info.getAssItems().add(cashPayInfo);
        }
        for (i = 0; i < oldInfo.getEntries().size(); ++i) {
            paymentBillEntry = new PaymentBillEntryInfo();
            templatePaymentBillEntry = oldInfo.getEntries().get(i);
            paymentBillEntry.setSeq(i);
            paymentBillEntry.setCurrency(info.getCurrency());
            paymentBillEntry.setCostCenter(templatePaymentBillEntry.getCostCenter());
            paymentBillEntry.setActualAmt(templatePaymentBillEntry.getActualAmt());
            paymentBillEntry.setActualLocAmt(templatePaymentBillEntry.getActualLocAmt());
            paymentBillEntry.setOppAccount(templatePaymentBillEntry.getOppAccount());
            paymentBillEntry.setExpenseType(templatePaymentBillEntry.getExpenseType());
            paymentBillEntry.setOutBgItemId(templatePaymentBillEntry.getOutBgItemId());
            paymentBillEntry.setOutBgItemName(templatePaymentBillEntry.getOutBgItemName());
            paymentBillEntry.setOutBgItemNumber(templatePaymentBillEntry.getOutBgItemNumber());
            paymentBillEntry.setFundFlowItem(templatePaymentBillEntry.getFundFlowItem());
            paymentBillEntry.setRemark(templatePaymentBillEntry.getRemark());
            paymentBillEntry.setSeq(templatePaymentBillEntry.getSeq());
            for (int j = 0; j < templatePaymentBillEntry.getAssItemsEntries().size(); ++j) {
                cashPayInfo = new AssItemsForCashPayInfo();
                tmplPayInfo = templatePaymentBillEntry.getAssItemsEntries().get(j);
                cashPayInfo.setAsstActType(tmplPayInfo.getAsstActType());
                cashPayInfo.setFromID(tmplPayInfo.getFromID());
                cashPayInfo.setFromNumber(tmplPayInfo.getFromNumber());
                cashPayInfo.setIsSelected(tmplPayInfo.isIsSelected());
                cashPayInfo.setMappingFileds(tmplPayInfo.getMappingFileds());
                cashPayInfo.setTableName(tmplPayInfo.getTableName());
                cashPayInfo.setEntrySeq(tmplPayInfo.getEntrySeq());
                cashPayInfo.setSeq(tmplPayInfo.getSeq());
                paymentBillEntry.getAssItemsEntries().add(cashPayInfo);
            }
            info.getEntries().add(paymentBillEntry);
        }
    }

    protected PaymentBillTypeInfo getDefaultBillType(Context ctx) throws BOSException {
        PaymentBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
        PaymentBillTypeCollection coll = PaymentBillTypeFactory.getLocalInstance(ctx).getPaymentBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }

    private void setNotCopyValues(PaymentBillInfo info) {
        info.setNumber(null);
        info.setSourceBillId(null);
        info.setAuditor(null);
        info.setAuditDate(null);
        info.setApprover(null);
        info.setApproveDate(null);
        info.setAccountant(null);
        info.setCashier(null);
        info.setAccepter(null);
        info.setVoucher(null);
        info.setVoucherNumber(null);
        info.setVoucherType(null);
        info.setBizDate(new Date());
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setSettlementStatus(SettlementStatusEnum.UNSUBMIT);
        info.setFiVouchered(false);
        info.setIsCommittoBe(false);
        info.setRefundPayBillId(null);
        info.setHasEReceipt(false);
        info.setBankCheckFlag(null);
        info.setCommitBeTime(null);
        info.setBankReturnInfo(null);
        info.setBatchNo(null);
        info.setSettlementNumber(null);
    }

    @Override
    public Map getAssItems(Context ctx, String paymentBillId) throws BOSException, EASBizException {
        HashMap allAssGrp = new HashMap();
        AssItemsForCashPayCollection assItemsColl = AssItemsForCashPayFactory.getLocalInstance(ctx).getAssItemsForCashPayCollection("select * where  parent.id = '" + paymentBillId + "'");
        if (assItemsColl.size() > 0) {
            HashMap assgrp = new HashMap();
            allAssGrp.put(paymentBillId, assgrp);
            ArrayList<AsstActTypeInfo> details = new ArrayList<AsstActTypeInfo>();
            assgrp.put("detail", details);
            for (int i = 0; i < assItemsColl.size(); ++i) {
                AssItemsForCashPayInfo assItem = assItemsColl.get(i);
                AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assItem.getAsstActType().getId().toString()));
                String id = assItem.getFromID();
                if (id != null && !id.equals("")) {
                    ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                    CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                    asstActTypeInfo.put("value", (Object)info);
                }
                details.add(asstActTypeInfo);
            }
        }
        assItemsColl = AssItemsForCashPayFactory.getLocalInstance(ctx).getAssItemsForCashPayCollection("select * where entryParent.paymentBill.id = '" + paymentBillId + "'");
        for (int i = 0; i < assItemsColl.size(); ++i) {
            AssItemsForCashPayInfo assItem = assItemsColl.get(i);
            String entryId = assItem.getEntryParent().getId().toString();
            HashMap assgrp = (HashMap)allAssGrp.get(entryId);
            ArrayList<AsstActTypeInfo> details = null;
            if (assgrp == null) {
                assgrp = new HashMap();
                allAssGrp.put(entryId, assgrp);
                details = new ArrayList<AsstActTypeInfo>();
                assgrp.put("detail", details);
            } else {
                details = (ArrayList<AsstActTypeInfo>)assgrp.get("detail");
            }
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assItem.getAsstActType().getId().toString())).clone();
            asstActTypeInfo.put("value", null);
            String id = assItem.getFromID();
            if (id != null && !id.equals("")) {
                ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                asstActTypeInfo.put("value", (Object)info);
            }
            details.add(asstActTypeInfo);
        }
        Object[] allAssGrps = allAssGrp.values().toArray();
        for (int i = 0; i < allAssGrps.length; ++i) {
            Map assgrp = (Map)allAssGrps[i];
            List details = (List)assgrp.get("detail");
            String displayName = "";
            for (int j = 0; j < details.size(); ++j) {
                CoreBaseInfo detailValue = (CoreBaseInfo)((AsstActTypeInfo)details.get(j)).get("value");
                if (detailValue == null) continue;
                displayName = detailValue.get("name") != null ? displayName + detailValue.get("name") + " | " : displayName + detailValue.get("name_" + LocaleUtils.getShortLocale((Locale)ctx.getLocale())) + " | ";
            }
            if (!displayName.equals("")) {
                displayName = displayName.substring(0, displayName.length() - 3);
            }
            assgrp.put("displayname", displayName);
        }
        return allAssGrp;
    }

    @Override
    protected Map _getAllParam(Context ctx, String companyId, String operateState) throws BOSException, EASBizException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(OPERATESTATE, operateState);
        long dTime = System.currentTimeMillis();
        this.setDefaultCompany(ctx, companyId, param);
        logger.info((Object)("setDefaultCompany: " + (System.currentTimeMillis() - dTime)));
        dTime = System.currentTimeMillis();
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        companyId = company.getId().toString();
        Map paramValue = CASWebHelper.getParamMap(ctx, companyId, "CS006", "CS014", "CS015", "CS017", "CS022", "CS024", "CS027", "NT011", "CS030", "CS031", "CS031_01", "CS031_02", "CS037", "CS034", "CS035", "CS036", "CS038", "CS041", "CS045", "CS050", "CS051", "CS053", "CS062", "CS064", "CS073", "CS081", "CS082", "CS083", "CS084", "CS103", "CS011", "CS110", "CS109", "CS131", "TM018", "TM105", "BE009", "MBG_C001", "BE021");
        param.putAll(paramValue);
        logger.info((Object)("getParamMap: " + (System.currentTimeMillis() - dTime)));
        dTime = System.currentTimeMillis();
        if (param.get("CS053") != null) {
            int val = Integer.parseInt((String)paramValue.get("CS053"));
            param.put("isSubmitCtrlOverDraft", val == 1);
        } else {
            param.put("isSubmitCtrlOverDraft", false);
        }
        AsstActTypeCollection asstActTypeColl = this.getAsstActTypeColl(ctx, company.getId().toString(), false);
        param.put("asstActTypeCollection", asstActTypeColl);
        param.put("defaultAsstActType", this.getDefaultAsstActTypeInfo(ctx, company.getId().toString()));
        logger.info((Object)("getAsstActTypeColl: " + (System.currentTimeMillis() - dTime)));
        return param;
    }

    protected void setDefaultCompany(Context ctx, String companyId, Map<String, Object> param) throws BOSException, EASBizException {
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
        logger.error((Object)("\u4f20\u5165\u7684\u516c\u53f8ID\u4e3a\uff1a" + companyId));
        String operateState = (String)param.get(OPERATESTATE);
        logger.error((Object)("\u4f20\u5165\u7684\u5355\u636e\u64cd\u4f5c\u72b6\u6001\u4e3a\uff1a" + operateState));
        if (operateState == null) {
            operateState = "VIEW";
        }
        String permItem = "cas_paymentbill_01view";
        if (operateState.equals("ADDNEW")) {
            permItem = "cas_paymentbill_02addNew";
        }
        CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), permItem, false);
        param.put("authrizedCompanyOrg", orgUnitCollection);
        CompanyOrgUnitInfo company = null;
        if (companyId == null) {
            CompanyOrgUnitInfo defaultOrgUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (defaultOrgUnit.isIsBizUnit()) {
                boolean havePower = false;
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).getId().toString().equals(defaultOrgUnit.getId().toString())) continue;
                    havePower = true;
                    break;
                }
                if (havePower) {
                    company = defaultOrgUnit;
                } else if (orgUnitCollection.size() > 0) {
                    company = orgUnitCollection.get(0);
                }
            } else {
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).isIsBizUnit()) continue;
                    company = orgUnitCollection.get(i);
                    break;
                }
            }
        } else {
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                if (!orgUnitCollection.get(i).getId().toString().equals(companyId) || !orgUnitCollection.get(i).isIsBizUnit()) continue;
                company = orgUnitCollection.get(i);
                break;
            }
        }
        if (company == null) {
            throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.isoCode"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        param.put("company", company);
        UserInfo userinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        param.put("userInfo", userinfo);
    }

    @Override
    protected BigDecimal _getBalanceValue(Context ctx, String companyId, String acctViewId, String acctBankId, String currencyId, String bizDate) throws BOSException, EASBizException {
        ObjectUuidPK companyPK = companyId == null || companyId.equals("") ? null : new ObjectUuidPK(companyId);
        ObjectUuidPK acctViewPK = acctViewId == null || acctViewId.equals("") ? null : new ObjectUuidPK(acctViewId);
        ObjectUuidPK acctBankPK = acctBankId == null || acctBankId.equals("") ? null : new ObjectUuidPK(acctBankId);
        ObjectUuidPK currencyPK = currencyId == null || currencyId.equals("") ? null : new ObjectUuidPK(currencyId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal totalBalance = new BigDecimal("0");
        boolean isBankinterface = false;
        if (acctBankPK != null && currencyPK != null) {
            AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)acctBankPK);
            isBankinterface = acctBankInfo.isIsSetBankInterface();
            String CS132 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS132", (IObjectPK)companyPK);
            if ("1".equals(CS132)) {
                isBankinterface = false;
            }
            if (acctBankPK != null && acctViewPK != null && currencyPK != null && companyPK != null && !isBankinterface) {
                try {
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
                    AccountViewInfo acctView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)acctViewPK);
                    AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)acctBankPK);
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)currencyPK);
                    totalBalance = RecPayHelper.getTotalBalance(ctx, company, acctView, acctBank, currency);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else if (isBankinterface) {
                totalBalance = PaymentBillFactory.getLocalInstance(ctx).getBalanceValue(acctBankId, currencyId);
            }
        }
        if (currencyId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("precision"));
            int precision = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)currencyPK, sic).getPrecision();
            totalBalance = totalBalance.setScale(precision, 4);
        }
        return totalBalance;
    }

    @Override
    protected Map _getAssItems(Context ctx, String paymentBillId) throws BOSException, EASBizException {
        HashMap allAssGrp = new HashMap();
        AssItemsForCashPayCollection assItemsColl = AssItemsForCashPayFactory.getLocalInstance(ctx).getAssItemsForCashPayCollection("select * where  parent.id = '" + paymentBillId + "'");
        if (assItemsColl.size() > 0) {
            HashMap assgrp = new HashMap();
            allAssGrp.put(paymentBillId, assgrp);
            ArrayList<AsstActTypeInfo> details = new ArrayList<AsstActTypeInfo>();
            assgrp.put("detail", details);
            for (int i = 0; i < assItemsColl.size(); ++i) {
                AssItemsForCashPayInfo assItem = assItemsColl.get(i);
                AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assItem.getAsstActType().getId().toString()));
                String id = assItem.getFromID();
                if (id != null && !id.equals("")) {
                    ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                    CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                    asstActTypeInfo.put("value", (Object)info);
                }
                details.add(asstActTypeInfo);
            }
        }
        assItemsColl = AssItemsForCashPayFactory.getLocalInstance(ctx).getAssItemsForCashPayCollection("select * where entryParent.paymentBill.id = '" + paymentBillId + "'");
        for (int i = 0; i < assItemsColl.size(); ++i) {
            AssItemsForCashPayInfo assItem = assItemsColl.get(i);
            String entryId = assItem.getEntryParent().getId().toString();
            HashMap assgrp = (HashMap)allAssGrp.get(entryId);
            ArrayList<AsstActTypeInfo> details = null;
            if (assgrp == null) {
                assgrp = new HashMap();
                allAssGrp.put(entryId, assgrp);
                details = new ArrayList<AsstActTypeInfo>();
                assgrp.put("detail", details);
            } else {
                details = (ArrayList<AsstActTypeInfo>)assgrp.get("detail");
            }
            AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assItem.getAsstActType().getId().toString()));
            String id = assItem.getFromID();
            if (id != null && !id.equals("")) {
                ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                asstActTypeInfo.put("value", (Object)info);
            }
            details.add(asstActTypeInfo);
        }
        Object[] allAssGrps = allAssGrp.values().toArray();
        for (int i = 0; i < allAssGrps.length; ++i) {
            Map assgrp = (Map)allAssGrps[i];
            List details = (List)assgrp.get("detail");
            String displayName = "";
            for (int j = 0; j < details.size(); ++j) {
                CoreBaseInfo detailValue = (CoreBaseInfo)((AsstActTypeInfo)details.get(j)).get("value");
                if (detailValue == null) continue;
                displayName = detailValue.get("name") != null ? displayName + detailValue.get("name") + " | " : displayName + detailValue.get("name_" + LocaleUtils.getShortLocale((Locale)ctx.getLocale())) + " | ";
            }
            if (!displayName.equals("")) {
                displayName = displayName.substring(0, displayName.length() - 3);
            }
            assgrp.put("displayname", displayName);
        }
        return allAssGrp;
    }

    @Override
    protected String _f7getCollection(Context ctx, String cuID, String groupID) throws BOSException, EASBizException {
        IRowSet rs = null;
        String sql = "select A.fparentid from T_BD_Generalasstacttype A inner join T_ORG_CtrlUnit D on D.FID=? inner join T_ORG_CtrlUnit E on E.FID=A.FControlUnitID and (CHARINDEX(E.FLongNumber||'!',D.FLongNumber)=1 or d.fid=e.fid) where A.fparentid is not null and FgroupID=? ";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cuID, groupID});
        StringBuffer parentid = new StringBuffer();
        try {
            while (rs.next()) {
                rs.getString("fparentid");
                parentid.append(rs.getString("fparentid")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return parentid.toString();
    }

    @Override
    protected SupplierCompanyInfoInfo _getSupplierCompany(Context ctx, String supplierId, String companyId) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("supplierBank.*"));
        sic.add(new SelectorItemInfo("supplierBank.beneficiaryBankCountryID.*"));
        sic.add(new SelectorItemInfo("supplierBank.agencyBankCountryID.*"));
        sic.add(new SelectorItemInfo("supplierBank.bankProvince.*"));
        sic.add(new SelectorItemInfo("supplierBank.bankCity.*"));
        sic.add(new SelectorItemInfo("email"));
        SupplierCompanyInfoInfo supplierCompany = SupplierFactory.getLocalInstance((Context)ctx).getCompanyInfo((IObjectPK)new ObjectUuidPK(supplierId), (IObjectPK)new ObjectUuidPK(companyId), sic);
        return supplierCompany;
    }

    @Override
    protected CustomerCompanyInfoInfo _getCustomerCompany(Context ctx, String customerId, String companyId) throws BOSException, EASBizException {
        SelectorItemCollection ctcSelector = new SelectorItemCollection();
        ctcSelector.add(new SelectorItemInfo("*"));
        ctcSelector.add(new SelectorItemInfo("id"));
        ctcSelector.add(new SelectorItemInfo("customerBank.adminOrgUnit.*"));
        ctcSelector.add(new SelectorItemInfo("customerBank.*"));
        ctcSelector.add(new SelectorItemInfo("customerBank.beneficiaryBankCountryID.*"));
        ctcSelector.add(new SelectorItemInfo("customerBank.agencyBankCountryID.*"));
        CustomerCompanyInfoInfo custCompany = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(customerId), (IObjectPK)new ObjectUuidPK(companyId), ctcSelector);
        return custCompany;
    }

    @Override
    protected Map _recBeInfo(Context ctx, String[] ids, String[] orgIds) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])orgIds), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
        PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(ctx).recBeInfoByMapping(FMHelper.Array2Set((String[])ids), null, (IObjectCollection)companys);
        BatchExecuteResult result = new BatchExecuteResult();
        if (ids.length == coll.size()) {
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "192_GEN_PAYMENTBILL_SUCCESS"));
        } else {
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "549_GEN_PAYMENTBILL", new String[]{String.valueOf(coll.size()), String.valueOf(ids.length - coll.size())}));
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "550_GEN_PAYMENT_FAIL"));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unitePay(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        result.setError(0);
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "UNITEPAY_SUCCESS"));
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            idList.add(ids[i]);
        }
        try {
            paymentBill.checkIsAdjustPeriod(idList);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
            return result;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("paymentBillType"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("payerAccount"));
        PaymentBillInfo info = null;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        ArrayList<String> correctList = new ArrayList<String>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            for (int i = 0; i < idList.size(); ++i) {
                boolean isTurstAcctBank;
                boolean isPermission;
                boolean isCanAudit = false;
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                correctList.add(ids[i]);
                info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()), sic);
                if (isFundDispatch) {
                    if (!permissionSet.contains(info.getCompany().getId())) {
                        isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "fundDispatchBill_unitePay");
                        if (!isPermission) {
                            String msg = FDUtils.getResource((Context)ctx, (String)"NO_UNITEPAY_AUTH", (String[])new String[]{info.getCompany().getName()});
                            result.getDetailMsgList().add(FDUtils.getResource((Context)ctx, (String)"074_UNITEPAYFAIL_RESON", (String[])new String[]{info.getNumber(), msg}));
                            continue;
                        }
                        permissionSet.add(info.getCompany().getId());
                    }
                } else if (!permissionSet.contains(info.getCompany().getId())) {
                    isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_unitePay");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_UNITEPAY_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
                    throw new CasException(CasException.NONEAUDITED);
                }
                boolean isAgentBill = info.getPaymentBillType().equals((Object)CasRecPayBillTypeEnum.AgentType);
                boolean bl = isTurstAcctBank = info.getPayerAccountBank() != null && !info.getPayerAccountBank().getCompany().getId().equals((Object)info.getCompany().getId());
                if (isAgentBill && isTurstAcctBank || info.getPayerAccount() != null) continue;
                throw new RecPayException(RecPayException.PAYERACCOUNT_CANNOT_BE_NULL);
            }
        }
        catch (Exception e) {
            result.setError(1);
            if (e instanceof CasWebException) {
                result.setSummaryMsg(e.getMessage());
            } else {
                result.setSummaryMsg(info.getNumber() + e.getMessage());
            }
            if (isFundDispatch) {
                BatchExecuteResult fundResult = result;
                BatchExecuteResult batchExecuteResult = fundResult = this.replacePaymentMsg(ctx, fundResult);
                return batchExecuteResult;
            }
            BatchExecuteResult fundResult = result;
            return fundResult;
        }
        finally {
            if (!EmptyUtil.isEmpty(correctList)) {
                iMutex.batchReleaseObjIDForUpdate(correctList);
            }
        }
        LinkedHashSet s = new LinkedHashSet();
        for (int i = 0; i < idList.size(); ++i) {
            s.add(idList.get(i));
        }
        try {
            paymentBill.unitePay(s);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
            return result;
        }
        catch (EASBizException e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _commitToBe(Context ctx, String id) throws BOSException, EASBizException {
        TaskManager taskManager = new TaskManager();
        this.checkGetVersion(ctx);
        List<Object> results = new ArrayList();
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        BatchExecuteResult result = new BatchExecuteResult();
        if (!PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(id))) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "NOT_EXIST"));
            return result;
        }
        try {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            this.requesMutexs(ctx, idList, correctList, lockedList);
            if (correctList.size() > 0) {
                results = taskManager.batchExecute(ctx, new String[]{id}, PaymentBillCommitToBeTask.class);
            }
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
        }
        if (results.size() > 0 && ((ExecuteResult)results.get(0)).isSuccess()) {
            result.setError(0);
            PaymentBillInfo paymentBillInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id));
            String strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM018", (IObjectPK)new ObjectUuidPK(paymentBillInfo.getCompany().getId()));
            if (strValue == null || "0".equals(strValue)) {
                result.setSummaryMsg(CASWebUtil.getResource(ctx, "332_COMMITTOBE_SUCCESS"));
            } else {
                String msg = EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"submit") + EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"bankPayBill") + EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"success");
                result.setSummaryMsg(msg);
            }
        } else if (lockedList.size() > 0) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "551_LOCKED"));
        } else {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{((ExecuteResult)results.get(0)).getMsg()}));
        }
        return result;
    }

    private void requesMutexs(Context ctx, List idList, List<String> correctList, List<String> lockedList) throws BOSException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        HashMap map = new HashMap();
        try {
            Map resultRequest = iMutex.batchRequestObjIDForUpdate(idList);
            for (int i = 0; i < idList.size(); ++i) {
                Boolean boolResult = (Boolean)resultRequest.get(idList.get(i));
                if (!boolResult.booleanValue()) {
                    lockedList.add((String)idList.get(i));
                    continue;
                }
                correctList.add((String)idList.get(i));
            }
        }
        catch (Exception en) {
            logger.error((Object)en);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCommitToBe(Context ctx, String[] ids, String billType) throws BOSException, EASBizException {
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        long dTime = System.currentTimeMillis();
        this.checkGetVersion(ctx);
        List idList = FMHelper.Array2List((String[])ids);
        ArrayList results = new ArrayList();
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        ArrayList notExistList = new ArrayList();
        try {
            this.requesMutexs(ctx, FMHelper.Array2List((String[])ids), correctList, lockedList);
            if (correctList.size() > 0) {
                int i;
                Set idSet = FMHelper.list2Set(correctList);
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
                view.setSelector(sic);
                view.setFilter(filter);
                PaymentBillCollection colls = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
                HashSet<String> correctSet = new HashSet<String>();
                for (i = 0; i < colls.size(); ++i) {
                    correctSet.add(colls.get(i).getId().toString());
                }
                for (i = 0; i < correctList.size(); ++i) {
                    if (correctSet.contains(correctList.get(i))) continue;
                    notExistList.add(correctList.get(i));
                }
                if (correctSet.size() > 0) {
                    PaymentCommitToBeServiceWeb paymentCommitToBeServiceWeb = new PaymentCommitToBeServiceWeb(ctx);
                    results = paymentCommitToBeServiceWeb.commitToBENewBatchWithThread(ctx, correctSet);
                }
            }
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
        }
        int idLength = ids.length;
        for (int i = 0; i < notExistList.size(); ++i) {
            BankPayResult bankPayResult = new BankPayResult();
            bankPayResult.setErrorDetail(CASWebUtil.getResource(ctx, "NOT_EXIST"));
            bankPayResult.setNumber(null);
            results.add((BankPayResult)bankPayResult);
        }
        if (!EmptyUtil.isEmpty(lockedList)) {
            Set idSet = FMHelper.list2Set(lockedList);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setSelector(sic);
            view.setFilter(filter);
            PaymentBillCollection colls = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                PaymentBillInfo info = colls.get(i);
                BankPayResult bankPayResult = new BankPayResult();
                bankPayResult.setErrorDetail(CASWebUtil.getResource(ctx, "551_LOCKED"));
                bankPayResult.setNumber(info.getNumber());
                results.add(bankPayResult);
            }
        }
        return this.buildCommitReturnMsgNew(ctx, idLength, results, idList, isFundDispatch);
    }

    private void checkGetVersion(Context ctx) throws FMException {
        FmBeHelper.checkBEIsAliveByPay((String)ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString());
    }

    private BatchExecuteResult buildCommitReturnMsgNew(Context ctx, int idLength, List<BankPayResult> results, List<String> correctList, boolean isFundDispatch) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{idLength + ""});
        int success = correctList.size();
        for (int i = 0; i < results.size(); ++i) {
            BankPayResult executeResult = results.get(i);
            if (EmptyUtil.isEmpty((String)executeResult.getErrorDetail())) continue;
            --success;
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_COMMITTOBE_FAILED_NEW", new String[]{executeResult.getNumber(), executeResult.getErrorDetail()}));
        }
        summary = success == idLength ? summary + CASWebUtil.getResource(ctx, "ALL_COMMITTOBE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "COMMITTOBE_RESULT", new String[]{String.valueOf(success), String.valueOf(idLength - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    private BatchExecuteResult buildCommitReturnMsg(Context ctx, int idLength, List<ExecuteResult> results, List<String> correctList, boolean isFundDispatch) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{idLength + ""});
        int success = correctList.size();
        for (int i = 0; i < results.size(); ++i) {
            ExecuteResult executeResult = results.get(i);
            if (executeResult.isSuccess()) continue;
            --success;
            PaymentBillInfo info = (PaymentBillInfo)executeResult.getOtherMap().get("INFO");
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_COMMITTOBE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), executeResult.getMsg()}));
        }
        summary = success == idLength ? summary + CASWebUtil.getResource(ctx, "ALL_COMMITTOBE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "COMMITTOBE_RESULT", new String[]{String.valueOf(success), String.valueOf(idLength - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    private PaymentBillCollection getPaymentCollection(Context ctx, List lockedList) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("fundDispatchPlanStatus"));
        sic.add(new SelectorItemInfo("bizType.type"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set((List)lockedList), CompareType.INCLUDE));
        view.setSelector(sic);
        view.setFilter(filter);
        PaymentBillCollection colls = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
        return colls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchAudit4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        if (signatureList == null || signatureList != null && signatureList.size() != ids.length) {
            result.setError(1);
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "343_AUDIT_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        String submitPermission = null;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        submitPermission = isFundDispatch ? "fundDispatchBill_05audit" : "cas_paymentbill_05audit";
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            boolean isCanAudit = false;
            boolean orgCheck = false;
            orgCheck = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx).getCaOrgRangeCheck(ids[i], submitPermission);
            PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                if (!paymentBill.exists((IObjectPK)new ObjectUuidPK(ids[i]))) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "NOT_EXIST")});
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> signatureSubList = new ArrayList<String>();
                if (orgCheck) {
                    list.add(ids[i]);
                    iEASSignature.checkSignature4Web(list, submitPermission);
                    signatureSubList.add(signatureList.get(i));
                    iEASSignature.checkSignature4Web(list, signatureSubList, submitPermission);
                }
                paymentBill.audit(idList);
                if (orgCheck) {
                    iEASSignature.checkSignature4Web(list, submitPermission);
                    iEASSignature.saveSignature4Web(signatureSubList, list, submitPermission);
                }
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isCanAudit) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "AUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _deleteById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("isRefundmentPay"));
        sic.add(new SelectorItemInfo("payBillType.*"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        sic.add(new SelectorItemInfo("srcAgenPaymentBillID"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "327_DELETE_SUCCESS");
        ObjectUuidPK pk = new ObjectUuidPK(id);
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)pk, sic);
        boolean b = false;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            b = iMutex.requestObjIDForUpdate(id);
            if (!b) {
                throw new Exception(CASWebUtil.getResource(ctx, "610_CantOpreateWhileOtherUse"));
            }
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_04remove");
            } else {
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_04remove");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            String sourceBillId = info.getSourceBillId();
            if (!info.isIsRefundmentPay() && !EmptyUtil.isEmpty((String)sourceBillId)) {
                BOSUuid sbid = BOSUuid.read((String)sourceBillId);
                if (sbid.getType().equals((Object)new ReceivingBillInfo().getBOSType())) {
                    throw new RecPayException(RecPayException.CANNOTDELETERECFORSOURCE);
                }
                if (sbid.getType().equals((Object)new PaymentBillInfo().getBOSType()) && !SourceTypeEnum.AP.equals((Object)info.getPayBillType().getSourceSysType()) && !info.isIsTransBill() && !StringUtils.isEmpty((String)info.getSrcAgenPaymentBillID())) {
                    throw new RecPayException(RecPayException.AGENTPAYBILLNOTDELETE);
                }
                BOSObjectType transUpBillInfo_Type = new TransUpBillInfo().getBOSType();
                if (transUpBillInfo_Type.equals((Object)sbid.getType())) {
                    throw new RecPayException(RecPayException.PAYMENTBILLDELETEERROR, new Object[]{info.getNumber()});
                }
            }
            paymentBill.delete((IObjectPK)pk);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (b) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _commitToBe4Ca(Context ctx, String id, String plainText, String signature) throws BOSException, EASBizException {
        this.checkGetVersion(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("isEdit", "1");
        param.put("plainText", plainText);
        param.put("signature", signature);
        TaskManager taskManager = new TaskManager(param);
        List<Object> results = new ArrayList();
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        if (!PaymentBillFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(id))) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "NOT_EXIST"));
            return result;
        }
        try {
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            this.requesMutexs(ctx, idList, correctList, lockedList);
            if (correctList.size() > 0) {
                results = taskManager.batchExecute(ctx, new String[]{id}, PaymentBillCommitToBeTask.class);
            }
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
        }
        if (results.size() > 0 && ((ExecuteResult)results.get(0)).isSuccess()) {
            if (((ExecuteResult)results.get(0)).getMsg() != null) {
                result.setSummaryMsg(((ExecuteResult)results.get(0)).getMsg());
            } else {
                result.setSummaryMsg(CASWebUtil.getResource(ctx, "332_COMMITTOBE_SUCCESS"));
            }
        } else if (lockedList.size() > 0) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "551_LOCKED"));
        } else {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "333_COMMITTOBE_FAILED", new String[]{((ExecuteResult)results.get(0)).getMsg()}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchCommitToBe4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        this.checkGetVersion(ctx);
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        int idLength = ids.length;
        String bEPermission = null;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        bEPermission = isFundDispatch ? "fundDispatchBill_16commitToBE" : "cas_paymentbill_16commitToBE";
        ArrayList<String> newIds = new ArrayList<String>();
        if (signatureList != null) {
            for (int i = 0; i < ids.length; ++i) {
                boolean orgCheck = false;
                orgCheck = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx).getCaOrgRangeCheck(ids[i], bEPermission);
                if (!orgCheck) continue;
                newIds.add(ids[i]);
            }
        }
        if (signatureList == null || signatureList != null && signatureList.size() != newIds.size()) {
            BatchExecuteResult result = new BatchExecuteResult();
            result.setError(1);
            String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "345_COMMITTOBE_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        Map<String, String> signatureMap = this.getSignatureMap(newIds.toArray(new String[newIds.size()]), signatureList);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("isEdit", "0");
        param.put("signature", signatureMap);
        List idList = FMHelper.Array2List((String[])ids);
        ArrayList results = new ArrayList();
        ArrayList<String> correctList = new ArrayList<String>();
        ArrayList<String> lockedList = new ArrayList<String>();
        try {
            this.requesMutexs(ctx, FMHelper.Array2List((String[])ids), correctList, lockedList);
            if (correctList.size() > 0) {
                Set idSet = FMHelper.list2Set(correctList);
                PaymentCommitToBeServiceWeb paymentCommitToBeServiceWeb = new PaymentCommitToBeServiceWeb(ctx);
                results = paymentCommitToBeServiceWeb.commitToBENewBatchWithThread(ctx, idSet);
            }
        }
        finally {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(correctList);
        }
        IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<String> temp_signatureList = new ArrayList<String>();
        if (!EmptyUtil.isEmpty((Collection)results)) {
            for (int i = 0; i < results.size(); ++i) {
                BankPayResult executeResult = (BankPayResult)results.get(i);
                if (EmptyUtil.isEmpty((Object)executeResult) || !EmptyUtil.isEmpty((String)executeResult.getErrorDetail())) continue;
                System.out.println("==SrcId===" + i + "==" + executeResult.getSrcId() + "======");
                list.add(executeResult.getSrcId());
                String temp_signature = signatureMap.get(executeResult.getSrcId());
                temp_signatureList.add(temp_signature);
                System.out.println("==temp_signature===" + i + "==" + temp_signature + "======");
            }
        }
        iEASSignature.saveSignature4Web(temp_signatureList, list, bEPermission);
        if (!EmptyUtil.isEmpty(lockedList)) {
            Set idSet = FMHelper.list2Set(lockedList);
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            view.setSelector(sic);
            view.setFilter(filter);
            PaymentBillCollection colls = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                PaymentBillInfo info = colls.get(i);
                BankPayResult bankPayResult = new BankPayResult();
                bankPayResult.setErrorDetail(CASWebUtil.getResource(ctx, "551_LOCKED"));
                bankPayResult.setNumber(info.getNumber());
                results.add(bankPayResult);
            }
        }
        return this.buildCommitReturnMsgNew(ctx, idLength, results, idList, isFundDispatch);
    }

    private Map<String, String> getSignatureMap(String[] ids, List<String> signatureList) {
        HashMap<String, String> signatureMap = new HashMap<String, String>();
        for (int i = 0; i < ids.length; ++i) {
            signatureMap.put(ids[i], signatureList.get(i));
        }
        return signatureMap;
    }

    @Override
    protected Map _pay4CaById(Context ctx, String id, String plainText, String signature) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "PAY_SUCCESS");
        PaymentBillInfo info = paymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        String payPermission = null;
        try {
            if (FundDispatchTypeEnum.NOT_SAME_NAME.equals((Object)info.getFundDispatchType()) || FundDispatchTypeEnum.SAME_COMPANY.equals((Object)info.getFundDispatchType())) {
                payPermission = "fundDispatchBill_09pay";
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), "fundDispatchBill_09pay");
            } else {
                payPermission = "cas_paymentbill_09pay";
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), payPermission);
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_PAY_AUTHRIZED);
                }
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = new ArrayList<String>();
            list.add(id);
            iEASSignature.checkSignature4Web(list, payPermission);
            iEASSignature.checkSignature4Web(plainText, signature, payPermission);
            paymentBill.pay(idList);
            iEASSignature.checkSignature4Web(list, payPermission);
            iEASSignature.saveSignature4Web(signature, plainText, id, payPermission);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "PAY_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchPay4Ca(Context ctx, String[] ids, String signature, String billType) throws BOSException, EASBizException {
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        List<String> signatureList = CASWebUtil.ids2List(signature != null ? signature.split(",") : null);
        if (signatureList == null || signatureList != null && signatureList.size() != ids.length) {
            result.setError(1);
            result.setSummaryMsg(summary + CASWebUtil.getResource(ctx, "344_PAY_FAILED").concat(CASWebUtil.getResource(ctx, "342_SIGNATURE_CHK_ERR")));
            return result;
        }
        String payPermission = null;
        boolean isFundDispatch = billType != null && billType.equals(String.valueOf(55));
        payPermission = isFundDispatch ? "fundDispatchBill_09pay" : "cas_paymentbill_09pay";
        IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < ids.length; ++i) {
            idSet.add(ids[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < colls.size(); ++i) {
            boolean isCanAudit = false;
            PaymentBillInfo info = colls.get(i);
            boolean orgCheck = false;
            orgCheck = IDSecondAuthorizeFactory.getLocalInstance((Context)ctx).getCaOrgRangeCheck(ids[i], payPermission);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                ArrayList<String> list = new ArrayList<String>();
                ArrayList<String> signatureSubList = new ArrayList<String>();
                if (orgCheck) {
                    list.add(ids[i]);
                    iEASSignature.checkSignature4Web(list, payPermission);
                    signatureSubList.add(signatureList.get(i));
                    iEASSignature.checkSignature4Web(list, signatureSubList, payPermission);
                }
                paymentBill.pay(idList);
                if (orgCheck) {
                    iEASSignature.checkSignature4Web(list, payPermission);
                    iEASSignature.saveSignature4Web(signatureSubList, list, payPermission);
                }
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_PAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_PAY_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isCanAudit) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_PAY_SUCCESS") : summary + CASWebUtil.getResource(ctx, "PAY_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        if (isFundDispatch) {
            BatchExecuteResult fundResult = result;
            fundResult = this.replacePaymentMsg(ctx, fundResult);
            return fundResult;
        }
        return result;
    }

    @Override
    protected Map _saveBank(Context ctx, String id) throws BOSException, EASBizException {
        HashMap pageModel = new HashMap();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("payeeId");
        sic.add("payeeAccountBank");
        sic.add("company.id");
        sic.add("payeeBank");
        sic.add("currency.id");
        sic.add("payeeType.id");
        sic.add("payeeType.asstHGAttribute");
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        AsstActTypeInfo asstActTypeInfo = info.getPayeeType();
        if (asstActTypeInfo.getAsstHGAttribute().equals("customer")) {
            String payeeId = info.getPayeeID();
            CustomerInfo customer = new CustomerInfo();
            customer.setId(BOSUuid.read((String)payeeId));
            EntityViewInfo view = CasBosUtils.entityViewBuilder().select("id").filter("customer.id", payeeId).filter("companyOrgUnit.id", info.getCompany().getId().toString()).build();
            CustomerCompanyInfoInfo companyInfo = null;
            ICustomerCompanyInfo iCompanyInfo = CustomerCompanyInfoFactory.getLocalInstance((Context)ctx);
            CustomerCompanyInfoCollection companyInfoColl = iCompanyInfo.getCustomerCompanyInfoCollection(view);
            if (companyInfoColl.size() == 0) {
                companyInfo = new CustomerCompanyInfoInfo();
                companyInfo.setCompanyOrgUnit(info.getCompany());
                companyInfo.setCustomer(customer);
                IObjectPK companyInfoPK = iCompanyInfo.addnew((CoreBaseInfo)companyInfo);
                companyInfo.setId(BOSUuid.read((String)companyInfoPK.toString()));
            } else {
                companyInfo = companyInfoColl.get(0);
            }
            CustomerCompanyBankInfo bankInfo = new CustomerCompanyBankInfo();
            bankInfo.setCustomerCompanyInfo(companyInfo);
            bankInfo.setBankAccount(info.getPayeeAccountBank());
            bankInfo.setBank(info.getPayeeBank());
            CustomerCompanyBankFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)bankInfo);
        } else if (asstActTypeInfo.getAsstHGAttribute().equals("provider")) {
            String payeeId = info.getPayeeID();
            SupplierInfo supplier = new SupplierInfo();
            supplier.setId(BOSUuid.read((String)payeeId));
            EntityViewInfo view = CasBosUtils.entityViewBuilder().select("id").filter("supplier.id", payeeId).filter("companyOrgUnit.id", info.getCompany().getId().toString()).build();
            SupplierCompanyInfoInfo companyInfo = null;
            ISupplierCompanyInfo iCompanyInfo = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx);
            SupplierCompanyInfoCollection companyInfoColl = iCompanyInfo.getSupplierCompanyInfoCollection(view);
            if (companyInfoColl.size() == 0) {
                companyInfo = new SupplierCompanyInfoInfo();
                companyInfo.setCompanyOrgUnit(info.getCompany());
                companyInfo.setSupplier(supplier);
                IObjectPK companyInfoPK = iCompanyInfo.addnew((CoreBaseInfo)companyInfo);
                companyInfo.setId(BOSUuid.read((String)companyInfoPK.toString()));
            } else {
                companyInfo = companyInfoColl.get(0);
            }
            SupplierCompanyBankInfo bankInfo = new SupplierCompanyBankInfo();
            bankInfo.setSupplierCompanyInfo(companyInfo);
            bankInfo.setBankAccount(info.getPayeeAccountBank());
            bankInfo.setBank(info.getPayeeBank());
            bankInfo.setSeq(0);
            SupplierCompanyBankFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)bankInfo);
        }
        return pageModel;
    }

    @Override
    protected Map _getBgDimensionGrp(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        PaymentBillEntryCollection entries = info.getEntries();
        HashMap allDimensionGrp = new HashMap();
        return allDimensionGrp;
    }

    @Override
    protected void _transAsstAccount(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        info.getAssItems().clear();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            AssItemsForCashPayInfo assItemInfo;
            Map value;
            AsstActTypeInfo asstTypeInfo;
            Map asstType;
            int j;
            PaymentBillEntryInfo entry = info.getEntries().get(i);
            entry.getAssItemsEntries().clear();
            if (entry.getOppAccount() == null || entry.getOppAccount().get("assgrp") == null) continue;
            Map assgrp = (Map)entry.getOppAccount().get("assgrp");
            List detail = (List)assgrp.get("detail");
            String caaId = (String)assgrp.get("CAAId");
            entry.getAssItemsEntries().clear();
            for (j = 0; j < detail.size(); ++j) {
                asstType = (Map)detail.get(j);
                asstTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstType.get("id").toString()));
                value = (Map)asstType.get("value");
                assItemInfo = new AssItemsForCashPayInfo();
                assItemInfo.setEntrySeq(i + 1);
                if (value != null) {
                    assItemInfo.setFromID(value.get("id").toString());
                    assItemInfo.setFromNumber(value.get("number").toString());
                }
                assItemInfo.setIsSelected(value != null);
                assItemInfo.setMappingFileds(asstTypeInfo.getMappingFieldName());
                assItemInfo.setTableName(asstTypeInfo.getRealtionDataObject());
                assItemInfo.setAsstActType(asstTypeInfo);
                entry.getAssItemsEntries().add(assItemInfo);
            }
            if (i != 0) continue;
            info.setOppAccount(entry.getOppAccount());
            for (j = 0; j < detail.size(); ++j) {
                asstType = (Map)detail.get(j);
                asstTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstType.get("id").toString()));
                value = (Map)asstType.get("value");
                assItemInfo = new AssItemsForCashPayInfo();
                assItemInfo.setEntrySeq(-99);
                if (value != null) {
                    assItemInfo.setFromID(value.get("id").toString());
                    assItemInfo.setFromNumber(value.get("number").toString());
                }
                assItemInfo.setIsSelected(value != null);
                assItemInfo.setMappingFileds(asstTypeInfo.getMappingFieldName());
                assItemInfo.setTableName(asstTypeInfo.getRealtionDataObject());
                assItemInfo.setAsstActType(asstTypeInfo);
                info.getAssItems().add(assItemInfo);
            }
        }
    }

    public Map getAssItems4Template(Context ctx, String templatePaymentBillId) throws BOSException, EASBizException {
        HashMap<String, Object> assgrp;
        HashMap allAssGrp = new HashMap();
        String sql = "select FAsstActTypeID as asstacttypeid, FFromID as fromid from T_CAS_AssItemsForTmplPay WHERE FParentID = '" + templatePaymentBillId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            HashMap assgrp2 = new HashMap();
            allAssGrp.put(templatePaymentBillId, assgrp2);
            ArrayList<AsstActTypeInfo> details = new ArrayList<AsstActTypeInfo>();
            assgrp2.put("detail", details);
            try {
                while (rowSet.next()) {
                    AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("asstacttypeid")));
                    String id = rowSet.getString("fromid");
                    if (id != null && !id.equals("")) {
                        ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                        CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                        asstActTypeInfo.put("value", (Object)info);
                    }
                    details.add(asstActTypeInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        sql = "select atp.FAsstActTypeID as asstacttypeid, atp.FentryParentID as entryparentid, atp.FFromID as fromid from T_CAS_AssItemsForTmplPay atp left outer join T_CAS_TemplatePaymentBillEntry tpe on tpe.fid = atp.FentryParentID WHERE tpe.FPaymentBillID = '" + templatePaymentBillId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                ArrayList<AsstActTypeInfo> details = null;
                String entryId = rowSet.getString("entryparentid");
                assgrp = (HashMap<String, Object>)allAssGrp.get(entryId);
                if (assgrp == null) {
                    assgrp = new HashMap<String, Object>();
                    allAssGrp.put(entryId, assgrp);
                    details = new ArrayList<AsstActTypeInfo>();
                    assgrp.put("detail", details);
                } else {
                    details = (ArrayList<AsstActTypeInfo>)assgrp.get("detail");
                }
                AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("asstacttypeid")));
                String id = rowSet.getString("fromid");
                if (id != null && !id.equals("")) {
                    ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                    CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                    asstActTypeInfo.put("value", (Object)info);
                }
                details.add(asstActTypeInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object[] allAssGrps = allAssGrp.values().toArray();
        for (int i = 0; i < allAssGrps.length; ++i) {
            assgrp = (Map)allAssGrps[i];
            List details = (List)assgrp.get("detail");
            String displayName = "";
            for (int j = 0; j < details.size(); ++j) {
                CoreBaseInfo detailValue = (CoreBaseInfo)((AsstActTypeInfo)details.get(j)).get("value");
                if (detailValue == null) continue;
                displayName = detailValue.get("name") != null ? displayName + detailValue.get("name") + " | " : displayName + detailValue.get("name_" + LocaleUtils.getShortLocale((Locale)ctx.getLocale())) + " | ";
            }
            if (!displayName.equals("")) {
                displayName = displayName.substring(0, displayName.length() - 3);
            }
            assgrp.put("displayname", displayName);
        }
        return allAssGrp;
    }

    @Override
    protected void _transBgDimension(Context ctx, PaymentBillInfo info) throws BOSException, EASBizException {
        for (int i = 0; i < info.getEntries().size(); ++i) {
            PaymentBillEntryInfo entry = info.getEntries().get(i);
            if (entry.getFundFlowItem() == null) continue;
            String mbgNumber = entry.getMbgNumber();
            String boName = "com.kingdee.eas.fi.cas.app.PaymentBill";
            entry.setMbgNumber(mbgNumber);
        }
    }

    @Override
    protected BigDecimal _getBEbalanceValue(Context ctx, String acctBankid, String currencyID) throws BOSException, EASBizException {
        ObjectUuidPK currencyPK = currencyID == null || currencyID.equals("") ? null : new ObjectUuidPK(currencyID);
        BigDecimal totalBalance = new BigDecimal("0");
        try {
            String[] accountBankIds = new String[]{acctBankid};
            Map result = BankFacadeFactory.getLocalInstance((Context)ctx).getBalance(currencyID, accountBankIds, new Date(), new Date());
            if (!result.get("successCount").equals("1")) {
                throw new Exception((String)result.get("detailMsg"));
            }
            totalBalance = PaymentBillFactory.getLocalInstance(ctx).getBalanceValue(acctBankid, currencyID);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return totalBalance;
    }

    @Override
    protected Map _checkParamStatus(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        PaymentBillInfo info = this.getPaymentCollection(ctx, idList).get(0);
        Boolean CS118 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS118", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
        result.put("CS118", CS118);
        if (CS118.booleanValue() && info.getFundDispatchPlanStatus().getValue() == 2) {
            result.setSummaryMsg(FDUtils.getResource((Context)ctx, (String)"041_REPORTED_NO_COMMIT", null));
            result.setError(1);
        } else if (CS118.booleanValue() && info.getFundDispatchPlanStatus().getValue() == 3) {
            result.put("status", 3);
        } else if (CS118.booleanValue() && !this.verifyBizTypeSettle(info)) {
            result.put("inside", true);
        }
        return result;
    }

    private BatchExecuteResult replacePaymentMsg(Context ctx, BatchExecuteResult result) {
        if (result.getDetailMsgList().size() > 0) {
            BatchExecuteResult cbResult = new BatchExecuteResult();
            cbResult.setSummaryMsg(result.getSummaryMsg());
            List<String> detailMsgList = result.getDetailMsgList();
            for (int i = 0; i < detailMsgList.size(); ++i) {
                String msg = detailMsgList.get(i);
                if (msg.indexOf(CASWebUtil.getResource(ctx, "613_PAYMENTBILL")) != -1) {
                    msg = msg.replaceAll(CASWebUtil.getResource(ctx, "613_PAYMENTBILL"), CASWebUtil.getResource(ctx, "614_FUNDDISPATCHBILL"));
                }
                cbResult.getDetailMsgList().add(msg);
            }
            return cbResult;
        }
        return result;
    }

    private void checkCS026(Context ctx, Set idSet, PaymentBillInfo info) throws FDException {
        boolean CS026 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS026", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        boolean CS118 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS118", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
        if (CS026 && CS118) {
            throw new FDException(FDException.PARAMERROR);
        }
    }

    private Boolean getCS120(Context ctx, String companyId) {
        String CS120;
        Boolean flag = false;
        if (companyId == null) {
            companyId = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString();
        }
        if ((CS120 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS120", (IObjectPK)new ObjectUuidPK(companyId))) != null && CS120.equals("1")) {
            flag = true;
        }
        return flag;
    }

    private boolean verifyBizTypeSettle(PaymentBillInfo info) {
        boolean flag = false;
        if (info.getBizType() != null && (info.getBizType().getType().getValue() == 2 || info.getBizType().getType().getValue() == 100)) {
            flag = true;
        }
        return flag;
    }

    private boolean verifyBizTypeSubmit(PaymentBillInfo info) {
        boolean flag = false;
        if (info.getBizType() == null || info.getBizType().getType().getValue() == 10) {
            flag = true;
        }
        return flag;
    }

    @Override
    protected Map _checkParamSubmitStatus(Context ctx, String id) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        PaymentBillInfo info = this.getPaymentCollection(ctx, idList).get(0);
        if (info == null) {
            return result;
        }
        Boolean CS120 = this.getCS120(ctx, info.getCompany().getId().toString());
        result.put("CS120", CS120);
        if (!info.isIsCBPay() && info.getFundDispatchPlanStatus() == null || info.getFundDispatchType().getValue() == 0) {
            if (CS120.booleanValue() && info.getFundDispatchPlanStatus().getValue() == 2) {
                result.setSummaryMsg(FDUtils.getResource((Context)ctx, (String)"041_REPORTED_NO_SUBMIT", null));
                result.setError(1);
            } else if (CS120.booleanValue() && info.getFundDispatchPlanStatus().getValue() == 3) {
                result.put("status", 3);
            } else if (CS120.booleanValue() && !this.verifyBizTypeSubmit(info)) {
                result.put("inside", true);
            }
            result.put("inside", true);
        }
        return result;
    }

    @Override
    protected void _batchModifyTradedTime(Context ctx, Set idSet, Date modifyTime) throws BOSException, EASBizException {
        PaymentBillFactory.getLocalInstance(ctx).batchModifyTradedTime(idSet, modifyTime);
    }

    @Override
    protected Map _verifyChongFu(Context ctx, String[] ids) throws BOSException, EASBizException {
        String msg;
        BatchExecuteResult result = new BatchExecuteResult();
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            idList.add(ids[i]);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.list2Set(idList), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add("payerAccount.*");
        PaymentBillCollection PaymentBillColl = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(evi);
        ArrayList<BOSUuid> readlIdList = new ArrayList<BOSUuid>();
        for (int i = 0; i < PaymentBillColl.size(); ++i) {
            PaymentBillInfo info = PaymentBillColl.get(i);
            if (info.getPayerAccount() == null || !info.getPayerAccount().isIsCash() && !info.getPayerAccount().isIsBank()) continue;
            readlIdList.add(info.getId());
        }
        Map map = PaymentBillFactory.getLocalInstance(ctx).verifyChongFu(readlIdList);
        if (map == null) {
            return null;
        }
        int days = (Integer)map.get("days");
        boolean isCS128 = (Boolean)map.get("isCS128");
        map.remove("days");
        map.remove("isCS128");
        for (Object number : map.keySet()) {
            StringBuffer message = new StringBuffer();
            List numberlist = (List)map.get(number);
            String msg2 = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"481_CasPaymentPayRepeat");
            msg2 = MessageFormat.format(msg2, number);
            message.append(msg2);
            for (int i = 0; i < numberlist.size(); ++i) {
                message.append(numberlist.get(i) + "; ");
            }
            result.getDetailMsgList().add(message.toString());
        }
        if (isCS128) {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"480_CasPaymentPayRepeat_CS128");
            msg = MessageFormat.format(msg, days);
            result.setSummaryMsg(msg);
        } else {
            msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"479_CasPaymentPayRepeat_CS124");
            msg = MessageFormat.format(msg, days);
            result.setSummaryMsg(msg);
        }
        result.put("isCS128", isCS128);
        return result;
    }

    private Date getSrcDate(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(5, calendar.get(5) + days);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _approve(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "APPROVE_SUCCESS");
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(id);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanAudit = false;
        try {
            isCanAudit = iMutex.requestObjIDForUpdate(id);
            if (!isCanAudit) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_approve");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            boolean CS024 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (!CS024) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "NOT_NEED_APPROVE"));
            }
            PaymentBillFactory.getLocalInstance(ctx).approve(idSet);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.equals((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "APPROVE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "APPROVE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.equals(e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "APPROVE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "APPROVE_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isCanAudit) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchApprove(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("number"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < colls.size(); ++i) {
            boolean isCanAudit = false;
            PaymentBillInfo info = colls.get(i);
            try {
                boolean CS024;
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_approve");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (!(CS024 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info.getCompany().getId())))) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "NOT_NEED_APPROVE"));
                }
                String billId = info.getId().toString();
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(billId);
                PaymentBillFactory.getLocalInstance(ctx).approve(idSet);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isCanAudit) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_APPROVE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "APPROVE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _unApprove(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        PaymentBillInfo info = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "UNAPPROVE_SUCCESS");
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        boolean isCanAudit = false;
        try {
            isCanAudit = iMutex.requestObjIDForUpdate(id);
            if (!isCanAudit) {
                throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
            }
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_untiApprove");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
            }
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            boolean CS024 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
            if (!CS024) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "NOT_NEED_UNAPPROVE"));
            }
            PaymentBillFactory.getLocalInstance(ctx).auditUnapprove((IObjectPK)new ObjectUuidPK(id));
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAPPROVE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "UNAPPROVE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAPPROVE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "UNAPPROVE_FAILED", new String[]{e.getMessage()});
        }
        finally {
            if (isCanAudit) {
                iMutex.releaseObjIDForUpdate(id);
            }
        }
        result.setSummaryMsg(summary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _batchUnApprove(Context ctx, String[] ids) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IPaymentBill paymentBill = PaymentBillFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])ids), CompareType.INCLUDE));
        PaymentBillCollection colls = paymentBill.getPaymentBillCollection(view);
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < colls.size(); ++i) {
            boolean isCanAudit = false;
            PaymentBillInfo info = colls.get(i);
            HashSet<String> idList = new HashSet<String>();
            idList.add(info.getId().toString());
            try {
                isCanAudit = iMutex.requestObjIDForUpdate(ids[i]);
                if (!isCanAudit) {
                    throw new RecPayException(RecPayException.COMMON, new Object[]{CASWebUtil.getResource(ctx, "HAS_LOCKED")});
                }
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_paymentbill_approve");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                boolean CS024 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS024", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                if (!CS024) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "NOT_NEED_UNAPPROVE"));
                }
                paymentBill.untiApprove(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_UNAPPROVE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "PAYMENTBILL_UNAPPROVE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
                continue;
            }
            finally {
                if (isCanAudit) {
                    iMutex.releaseObjIDForUpdate(ids[i]);
                }
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_UNAPPROVE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "UNAPPROVE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected void _appointGivenVoucher(Context ctx, String paymentBillId, String voucherId) throws BOSException, EASBizException {
        PaymentBillVoucherAppointService.appointVoucher(ctx, paymentBillId, voucherId);
    }
}

