/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.BankFacadeFactory;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.app.CommitToBeService;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.util.ExceptionMessageUtility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PaymentCommitToBeService
extends CommitToBeService {
    private static Logger logger = Logger.getLogger((String)PaymentCommitToBeService.class.getName());
    private IPaymentBill iPaymentBill;

    private IPaymentBill getPaymentBill(Context ctx) throws BOSException {
        if (this.iPaymentBill == null) {
            this.iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
        }
        return this.iPaymentBill;
    }

    protected IObjectPK executeBankPayingBill(Context ctx, BillBaseInfo bizBillInfo, boolean isNeedCommitToBank) throws BOSException, EASBizException {
        return this.getPaymentBill(ctx).commitToBE((PaymentBillInfo)bizBillInfo, isNeedCommitToBank);
    }

    protected List<BankPayResult> submitToBe(Context ctx, Set<String> bankPayBillIdSet) throws BOSException, EASBizException {
        ArrayList<BankPayResult> bankPayResults = new ArrayList<BankPayResult>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("serialNumber"));
        BankPayingBillCollection bankPayingBills = this.getBankPayingBillCollection(ctx, bankPayBillIdSet, sic);
        LinkedHashSet<String> bankPayBillIds = new LinkedHashSet<String>();
        IPaymentBill iPaymentBill = this.getPaymentBill(ctx);
        int size = bankPayingBills.size();
        for (int i = 0; i < size; ++i) {
            BankPayingBillInfo info = bankPayingBills.get(i);
            String sourceBillId = info.getSourceBillId();
            if (sourceBillId == null) continue;
            try {
                iPaymentBill.commitToBE4WF((IObjectPK)new ObjectUuidPK(sourceBillId));
                bankPayBillIds.add(info.getId().toString());
                continue;
            }
            catch (Exception e) {
                String returnMsg = new BEException(BEException.COMMITFAILURE, (Throwable)e).getMessage();
                BankPayResult bankResultInfo = new BankPayResult(info.getId().toString(), info.getSerialNumber(), BankPayingBillStateEnum.OF, returnMsg);
                bankResultInfo.setSrcId(info.getSourceBillId());
                bankResultInfo.setErrorDetail(ExceptionMessageUtility.getMessage((Throwable)e));
                bankPayResults.add(bankResultInfo);
            }
        }
        if (bankPayBillIds.size() > 0) {
            bankPayResults.addAll(BankFacadeFactory.getLocalInstance((Context)ctx).batchSubmit(bankPayBillIds));
        }
        return bankPayResults;
    }

    protected void reserveForBeException(Context ctx, String bankPayingbillId, String number) throws EASBizException, BOSException {
        this.getPaymentBill(ctx).reserveForBeException(bankPayingbillId);
    }

    protected void reserveForOtherException(Context ctx, BankPayingBillInfo bankPayingbillinfo, String returnMsg) throws EASBizException, BOSException {
        this.getPaymentBill(ctx).reserveForOtherException(bankPayingbillinfo, returnMsg);
    }

    protected void updateBillStateAndReturnMsg(Context ctx, String bankPayingBillId, int state, String returnMsg) throws EASBizException, BOSException {
        this.getPaymentBill(ctx).updateBillStateAndReturnMsg(bankPayingBillId, state, returnMsg);
    }

    protected IObjectCollection getBizBillCollection(Context ctx, Set<String> bizBillIdSet) throws BOSException, EASBizException {
        PaymentBillCollection orderedCollection = new PaymentBillCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bizBillIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelector());
        PaymentBillCollection paymentBillCollection = this.getPaymentBill(ctx).getPaymentBillCollection(view);
        Iterator paymentBillIterator = paymentBillCollection.iterator();
        for (String id : bizBillIdSet) {
            while (paymentBillIterator.hasNext()) {
                PaymentBillInfo next = (PaymentBillInfo)paymentBillIterator.next();
                if (!next.getId().toString().equals(id)) continue;
                orderedCollection.add(next);
            }
            paymentBillIterator = paymentBillCollection.iterator();
        }
        return orderedCollection;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("actPayAmt"));
        sic.add(new SelectorItemInfo("editFlag"));
        sic.add(new SelectorItemInfo("editFlagNew"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("recProvince"));
        sic.add(new SelectorItemInfo("recCity"));
        sic.add(new SelectorItemInfo("payeeArea.id"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.type"));
        sic.add(new SelectorItemInfo("payBillType.id"));
        sic.add(new SelectorItemInfo("payBillType.isFinanceTranUp"));
        sic.add(new SelectorItemInfo("settlementType.id"));
        sic.add(new SelectorItemInfo("settlementType.payThroughBE"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("payeeBank"));
        sic.add(new SelectorItemInfo("payeeAccountBank"));
        sic.add(new SelectorItemInfo("actRecAccountBank.id"));
        sic.add(new SelectorItemInfo("actRecAccountBank.number"));
        sic.add(new SelectorItemInfo("payerAccountBank.id"));
        sic.add(new SelectorItemInfo("payerAccountBank.isSetBankInterface"));
        sic.add(new SelectorItemInfo("payerAccountBank.bankAccountNumber"));
        return sic;
    }
}

