/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.IPaymentBillWebFacade;
import com.kingdee.eas.fi.cas.IPaymentReport;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillWebFacadeFactory;
import com.kingdee.eas.fi.cas.PaymentReportFactory;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.app.AbstractPaymentReportControllerBean;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PaymentReportControllerBean
extends AbstractPaymentReportControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.PaymentReportControllerBean");
    private static String PERMITEM_PAYMENTBILL_DELETE = "cas_paymentbill_04remove";

    @Override
    protected Map _deletePaymentBill(Context ctx, String jsonstr) throws BOSException, EASBizException {
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        BatchExecuteResult result = new BatchExecuteResult();
        Object[] selectedIds = jsonstr.split(",");
        HashSet idSet = new HashSet(Arrays.asList((Object[])selectedIds));
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
        IPaymentReport iPaymentReport = PaymentReportFactory.getLocalInstance(ctx);
        ArrayList<String> sucPKList = new ArrayList<String>();
        StringBuffer errorMsg = new StringBuffer();
        ArrayList errorMsgList = new ArrayList();
        String delPK = null;
        int success = idSet.size();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{idSet.size() + ""});
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        for (Object id : idSet) {
            delPK = id.toString();
            BillBaseInfo baseInfo = iPaymentBill.getBillBaseInfo((IObjectPK)new ObjectUuidPK(delPK), sic);
            try {
                ObjectUuidPK orgPk = new ObjectUuidPK(baseInfo.getCompany().getId());
                boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, PERMITEM_PAYMENTBILL_DELETE);
                if (!hasFunctionPermission) {
                    --success;
                    throw new CasWebException(CasWebException.NO_DELETE_AUTHRIZED);
                }
                int billStatus = iPaymentBill.getBillStatus(id.toString());
                if (billStatus == 10 || billStatus == 11) {
                    sucPKList.add(delPK);
                    continue;
                }
                --success;
                throw new RecPayException(RecPayException.BILLNOTSAVEORSUBMIT);
            }
            catch (Exception e) {
                HashMap<String, String> resultData = new HashMap<String, String>();
                resultData.put("title", CASWebUtil.getResource(ctx, "PAYMENTBILL_DELETE_FAILED", new String[]{baseInfo.getCompany().getName(), baseInfo.getNumber(), e.getMessage()}));
                resultData.put("iconType", "error");
                resultData.put("info", null);
                errorMsgList.add(resultData);
            }
        }
        int sucDelCount = sucPKList.size();
        IPaymentBillWebFacade iPaymentBillFacade = PaymentBillWebFacadeFactory.getLocalInstance(ctx);
        if (sucDelCount > 0) {
            String[] sucDelPKArray = new String[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                sucDelPKArray[idx] = (String)sucPKList.get(idx);
            }
            iPaymentBillFacade.batchDelete(sucDelPKArray, null);
        }
        summary = success == idSet.size() ? summary + CASWebUtil.getResource(ctx, "DeletedOK") : summary + CASWebUtil.getResource(ctx, "DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(idSet.size() - success)});
        result.put("resultData", errorMsgList);
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected String _getBillViewPageUIPK(Context ctx, String bosObjectType) throws BOSException {
        StringBuffer sql = new StringBuffer("select FWebViewUIPK as uipk from T_cas_billtype where FBOSObjectType = '");
        sql.append(bosObjectType).append("'");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String uipk = null;
            while (rowSet.next()) {
                uipk = rowSet.getString("uipk");
            }
            return uipk;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

