/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.cas.app.AbstractQingCapitalSumFacadeControllerBean;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class QingCapitalSumFacadeControllerBean
extends AbstractQingCapitalSumFacadeControllerBean {
    private static final long serialVersionUID = -137561176746910489L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.QingCapitalSumFacadeControllerBean");

    private IRowSet queryByDate(Context ctx, Map filterMap) throws BOSException, EASBizException {
        Set companyAllIdSet = (Set)filterMap.get("company.id");
        Set bankIdSet = (Set)filterMap.get("bank.id");
        Object LimitAmt = filterMap.get("limitAmt");
        String currencyId = (String)filterMap.get("currency.id");
        boolean isShowCancelUs = Boolean.valueOf(filterMap.get("isShowCancelUs").toString());
        int amountUnit = (Integer)filterMap.get("amountUnit");
        boolean includeCash = Boolean.valueOf(filterMap.get("includeCash").toString());
        boolean isHideNoDataAcct = Boolean.valueOf(filterMap.get("isHideNoDataAcct").toString());
        int level = (Integer)filterMap.get("level");
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Date beginDate = (Date)filterMap.get("startDate");
        Date endDate = (Date)filterMap.get("endDate");
        StringBuffer sbState = new StringBuffer();
        sbState.append("SELECT ss.fcompanyid , sp.fid spfid, sp.FPERIODYEAR beginYear, sp.FPERIODNUMBER beginMonth, sp.FPERIODYEAR*100 + sp.FPERIODNUMBER startperiod, cp.fid cpfid, cp.FPERIODYEAR*100 + cp.FPERIODNUMBER curPeriod ");
        sbState.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sbState.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sbState.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sbState.append(" and ss.fisstart=1");
        sbState.append(" and ");
        sbState.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companyAllIdSet.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbState.toString());
        PeriodInfo startPeriod = PeriodUtils.getPeriodInfo((Date)beginDate, (CompanyOrgUnitInfo)curCompany);
        int startYear = startPeriod.getPeriodYear();
        int startMonth = startPeriod.getPeriodNumber();
        try {
            int beginKey = startYear * 100 + startMonth;
            while (rs.next()) {
                if (beginKey <= rs.getInt("startperiod")) continue;
                startYear = rs.getInt("beginYear");
                startMonth = rs.getInt("beginMonth");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        startPeriod = PeriodUtils.getPeriodInfo((int)startYear, (int)startMonth, (CompanyOrgUnitInfo)curCompany);
        BigDecimal limit = null;
        limit = FMHelper.isEmpty(LimitAmt) ? null : TypeConversionUtils.objToBigDecimal(LimitAmt);
        String tbl = this.getTableTableName(ctx);
        this.queryDataByDate(ctx, companyAllIdSet, bankIdSet, startPeriod, currencyId, tbl, beginDate, endDate, isShowCancelUs);
        FMQuerySqlBuilder sb = this.genResult(ctx, amountUnit, includeCash, isHideNoDataAcct, level, curCompany, limit, tbl);
        if (sb.getSqlParams() != null) {
            return DbUtil.executeQuery((Context)ctx, (String)sb.getSql(), (Object[])sb.getSqlParams().getParams());
        }
        return DbUtil.executeQuery((Context)ctx, (String)sb.getSql());
    }

    private IRowSet queryByPeriod(Context ctx, Map filterMap) throws BOSException, EASBizException {
        Set companyAllIdSet = (Set)filterMap.get("company.id");
        Set bankIdSet = (Set)filterMap.get("bank.id");
        int beginYear = (Integer)filterMap.get("beginYear");
        int beginMonth = (Integer)filterMap.get("beginMonth");
        int endYear = (Integer)filterMap.get("endYear");
        int endMonth = (Integer)filterMap.get("endMonth");
        Object LimitAmt = filterMap.get("limitAmt");
        String currencyId = (String)filterMap.get("currency.id");
        boolean isShowCancelUs = Boolean.valueOf(filterMap.get("isShowCancelUs").toString());
        int amountUnit = (Integer)filterMap.get("amountUnit");
        boolean includeCash = Boolean.valueOf(filterMap.get("includeCash").toString());
        boolean isHideNoDataAcct = Boolean.valueOf(filterMap.get("isHideNoDataAcct").toString());
        int level = (Integer)filterMap.get("level");
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        String periodtypeId = curCompany.getAccountPeriodType().getId().toString();
        Set periodSet = this.getPeriodColl(ctx, periodtypeId, beginYear, beginMonth, endYear, endMonth);
        StringBuffer sbState = new StringBuffer();
        sbState.append("SELECT ss.fcompanyid , sp.fid spfid, sp.FPERIODYEAR beginYear, sp.FPERIODNUMBER beginMonth, sp.FPERIODYEAR*100 + sp.FPERIODNUMBER startperiod, cp.fid cpfid, cp.FPERIODYEAR*100 + cp.FPERIODNUMBER curPeriod ");
        sbState.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sbState.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sbState.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sbState.append(" and ss.fisstart=1");
        sbState.append(" and ");
        sbState.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companyAllIdSet.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbState.toString());
        HashSet<String> companySet = new HashSet<String>();
        int startYear = beginYear;
        int startMonth = beginMonth;
        try {
            int beginKey = beginYear * 100 + beginMonth;
            while (rs.next()) {
                if (beginKey > rs.getInt("startperiod")) {
                    startYear = rs.getInt("beginYear");
                    startMonth = rs.getInt("beginMonth");
                }
                companySet.add(rs.getString("fcompanyid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        PeriodInfo endPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)endYear, (int)endMonth, (CompanyOrgUnitInfo)curCompany);
        PeriodInfo beginPeriod = PeriodUtils.getPeriodInfo((Context)ctx, (int)beginYear, (int)beginMonth, (CompanyOrgUnitInfo)curCompany);
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)beginPeriod);
        if (prePeriod == null) {
            prePeriod = beginPeriod;
        }
        Set allPeriodSet = this.getPeriodColl(ctx, null, startYear, startMonth, prePeriod.getPeriodYear(), prePeriod.getPeriodNumber());
        PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (int)beginPeriod.getPeriodYear(), (int)1, (CompanyOrgUnitInfo)curCompany);
        PeriodInfo period2 = PeriodUtils.getPeriodInfo((Context)ctx, (int)(beginPeriod.getPeriodYear() + 1), (int)1, (CompanyOrgUnitInfo)curCompany);
        PeriodInfo period3 = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period2);
        if (period3 == null) {
            period3 = period2;
        }
        Set yearPeriodSet = this.getPeriodColl(ctx, null, period.getPeriodYear(), period.getPeriodNumber(), period3.getPeriodYear(), endPeriod.getPeriodNumber());
        PeriodInfo period4 = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)period);
        if (period4 == null) {
            period4 = period;
        }
        Set yearBeginPeriodSet = this.getPeriodColl(ctx, null, startYear, startMonth, period4.getPeriodYear(), period4.getPeriodNumber());
        BigDecimal limit = null;
        limit = FMHelper.isEmpty(LimitAmt) ? null : TypeConversionUtils.objToBigDecimal(LimitAmt);
        String tbl = this.getTableTableName(ctx);
        this.queryDataByPeriod(ctx, companySet, bankIdSet, currencyId, tbl, periodSet, yearPeriodSet, yearBeginPeriodSet, allPeriodSet, endPeriod.getEndDate(), isShowCancelUs);
        FMQuerySqlBuilder sb = this.genResult(ctx, amountUnit, includeCash, isHideNoDataAcct, level, curCompany, limit, tbl);
        logger.error((Object)("\u8f7b\u5206\u6790-sql:" + sb.getSql()));
        if (sb.getSqlParams() != null) {
            return DbUtil.executeQuery((Context)ctx, (String)sb.getSql(), (Object[])sb.getSqlParams().getParams());
        }
        return DbUtil.executeQuery((Context)ctx, (String)sb.getSql());
    }

    private Set getPeriodColl(Context ctx, String periodtypeId, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        if (periodtypeId != null) {
            sb.append(" and A.FTypeID='");
            sb.append(periodtypeId);
            sb.append("'");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("periodyear"));
        ev.getSorter().add(new SorterItemInfo("periodnumber"));
        PeriodCollection periocColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(ev);
        HashSet<String> idSet = new HashSet<String>();
        for (int index = 0; index < periocColl.size(); ++index) {
            idSet.add(periocColl.get(index).getId().toString());
        }
        return idSet;
    }

    private String getTableTableName(Context ctx) throws BOSException {
        String tbl = QingCapitalSumFacadeControllerBean.getTempTableName("casbalance", ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("FCOMPANYID        varchar(44),");
        createTableSql.append("FKey        varchar(44),");
        createTableSql.append("FBANKID           varchar(44),");
        createTableSql.append("FACCOUNTVIEWID    varchar(44),");
        createTableSql.append("FCURRENCYID       varchar(44),");
        createTableSql.append("FACCOUNTBANKID    varchar(44),");
        createTableSql.append("FAccountPropertyID    varchar(44),");
        createTableSql.append("FPERIODID         varchar(44),");
        createTableSql.append("FSTARTAMOUNT     NUMERIC(19,4),");
        createTableSql.append("FDEBITAMT     NUMERIC(19,4),");
        createTableSql.append("FCREDITAMT    NUMERIC(19,4) ,");
        createTableSql.append("FENDBALANCE      NUMERIC(19,4),");
        createTableSql.append("FYEARSTARTAMT      NUMERIC(19,4) ,");
        createTableSql.append("FYEARDEBITAMT      NUMERIC(19,4),");
        createTableSql.append("FYEARCREDITAMT     NUMERIC(19,4),");
        createTableSql.append("FYEARBALANCE       NUMERIC(19,4)");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    public static String getTempTableName(String desc, Context ctx) throws BOSException {
        return TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(desc);
    }

    private void queryDataByPeriod(Context ctx, Set companyIdSet, Set bankids, String currencyId, String tbl, Set periodSet, Set yearPeriod, Set yearBeginPeriod, Set allPeriodSet, Date endDate, boolean isShowCancelUs) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, fperiodid, faccountbankid, ");
        sb.appendSql(" fstartamount, fdebitamt, fcreditamt, fendbalance, fyearstartamt, fyeardebitamt, fyearcreditamt, fyearbalance )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.fperiodid, s.faccountbankid, ");
        sb.appendSql(" SUM (s.fmonthstartamt),  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt), ");
        sb.appendSql(" SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance, ");
        sb.appendSql(" SUM (s.yearstartamt), SUM (s.yeardebitamt), SUM (s.yearcreditamt), SUM (s.yearbalance) ");
        sb.appendSql("  FROM (");
        sb.appendSql(" SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.fperiodid, jb.faccountbankid,");
        sb.appendSql(" jb.fmonthstartamt,");
        sb.appendSql(" 0 fmonthdebitamt, 0 fmonthcreditamt, jb.fmonthstartamt fmonthbalance, ");
        sb.appendSql(" jb.fmonthstartamt yearstartamt, 0 yeardebitamt, 0 yearcreditamt, jb.fmonthstartamt yearbalance ");
        sb.appendSql("  FROM t_cas_journalbalance jb inner join t_bd_period pd on pd.fid=jb.fperiodid ");
        sb.appendSql("  WHERE ftype in(1,2) and fisinit = 1 ");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql(" AND ( jb.faccountbankid IN (");
            sb.appendSql(" SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("  WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql(" OR jb.faccountbankid IS NULL");
            sb.appendSql(" )");
        } else if (!isShowCancelUs) {
            sb.appendSql(" AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("  UNION");
        sb.appendSql(" SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid,");
        sb.appendSql(" 0 fmonthstartamt,");
        sb.appendSql(" SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance, ");
        sb.appendSql(" 0 yearstartamt, 0 yeardebitamt, 0 yearcreditamt, 0 yearbalance ");
        sb.appendSql(" FROM t_cas_journal j WHERE 1=1 ");
        sb.appendFilter("j.fperiodid", periodSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql(" SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid,");
        sb.appendSql("  SUM (fdebitamount-fcreditamount) fmonthstartamt,");
        sb.appendSql(" 0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance, ");
        sb.appendSql(" 0 yearstartamt, 0 yeardebitamt, 0 yearcreditamt, 0 yearbalance ");
        sb.appendSql("  FROM t_cas_journal j WHERE 1=1 ");
        sb.appendFilter("j.fperiodid", allPeriodSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql(" AND ( j.faccountbankid IN (");
            sb.appendSql(" SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("  WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("  OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        } else if (!isShowCancelUs) {
            sb.appendSql(" AND ( j.faccountbankid IN (");
            sb.appendSql(" SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("  WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql(" OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql(" SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid,");
        sb.appendSql(" 0 fmonthstartamt, 0 fmonthdebitamt, 0 fmonthcreditamt, SUM (fdebitamount-fcreditamount) fmonthbalance, ");
        sb.appendSql(" 0 yearstartamt, 0 yeardebitamt, 0 yearcreditamt, 0 yearbalance ");
        sb.appendSql(" FROM t_cas_journal j WHERE 1=1 ");
        Set allperiod = allPeriodSet;
        Iterator it = periodSet.iterator();
        while (it.hasNext()) {
            allperiod.add(it.next());
        }
        sb.appendFilter("j.fperiodid", allperiod, CompareType.INCLUDE);
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("  AND ( j.faccountbankid IN (");
            sb.appendSql("  SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("  WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("  OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        } else if (!isShowCancelUs) {
            sb.appendSql(" AND ( j.faccountbankid IN (");
            sb.appendSql(" SELECT fid FROM t_bd_accountbanks WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("  OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid,  j.fperiodid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql(" SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid,");
        sb.appendSql(" 0 fmonthstartamt, 0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance, ");
        sb.appendSql(" SUM (fdebitamount-fcreditamount) yearstartamt, 0 yeardebitamt, 0 yearcreditamt, 0 yearbalance ");
        sb.appendSql(" FROM t_cas_journal j WHERE 1=1 ");
        sb.appendFilter("j.fperiodid", yearBeginPeriod, CompareType.INCLUDE);
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("  AND ( j.faccountbankid IN (");
            sb.appendSql("  SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("  WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("  OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        } else if (!isShowCancelUs) {
            sb.appendSql(" AND ( j.faccountbankid IN (");
            sb.appendSql(" SELECT fid FROM t_bd_accountbanks WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("  OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql(" SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid,");
        sb.appendSql(" 0 fmonthstartamt, 0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance, ");
        sb.appendSql(" 0 yearstartamt, SUM (fdebitamount) yeardebitamt, SUM (fcreditamount) yearcreditamt, SUM (fdebitamount-fcreditamount) yearbalance ");
        sb.appendSql(" FROM t_cas_journal j WHERE 1=1 ");
        sb.appendFilter("j.fperiodid", yearPeriod, CompareType.INCLUDE);
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("  AND ( j.faccountbankid IN (");
            sb.appendSql("  SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("  WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("  OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        } else if (!isShowCancelUs) {
            sb.appendSql(" AND ( j.faccountbankid IN (");
            sb.appendSql(" SELECT fid FROM t_bd_accountbanks WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("  OR j.faccountbankid IS NULL");
            sb.appendSql("  )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.fperiodid, j.faccountbankid ");
        sb.appendSql(" ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.fperiodid, s.faccountbankid ");
        sb.appendSql(" UNION ");
        sb.appendSql(" select b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID , j.fperiodid, b.fid,");
        sb.appendSql(" 0 fmonthstartamt,0 fmonthdebitamt,0 fmonthcreditamt,0 fmonthbalance, ");
        sb.appendSql(" 0 yearstartamt, 0 yeardebitamt, 0 yearcreditamt, 0 yearbalance ");
        sb.appendSql(" from T_BD_ACCOUNTBANKS b  ");
        sb.appendSql(" left join t_cas_journal j  on j.faccountbankid=b.fid ");
        sb.appendSql(" left join t_cas_journalbalance jb on jb.faccountbankid=b.fid ");
        sb.appendSql(" where j.FACCOUNTBANKID is null and jb.FACCOUNTBANKID is null and ");
        sb.appendSql(" b.FACCOUNTID in(select a.fid from T_BD_ACCOUNTVIEW a where a.FISBANK=1) and");
        if (!isShowCancelUs) {
            sb.appendSql(" b.fisclosed=0 and ");
        }
        sb.appendSql(" b.fopendate<={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)endDate).toString());
        sb.appendSql("} ");
        sb.appendFilter("b.FCOMPANYID", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("b.FCURRENCYID", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        sb.execute(ctx);
    }

    private void queryDataByDate(Context ctx, Set companyIdSet, Set bankids, PeriodInfo startPeriod, String currencyId, String tbl, Date fromDate, Date toDate, boolean isShowCancelUs) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid, fstartamount, fdebitamt, fcreditamt, fendbalance ");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, ");
        sb.appendSql(" SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt), ");
        sb.appendSql("  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance ");
        sb.appendSql("  FROM (");
        sb.appendSql(" SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid,");
        sb.appendSql(" jb.fmonthstartamt,");
        sb.appendSql(" 0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthstartamt fmonthbalance ");
        sb.appendSql("  FROM t_cas_journalbalance jb inner join t_bd_period pd on pd.fid=jb.fperiodid ");
        sb.appendSql("  WHERE ftype in(1,2) and fisinit = 1 ");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  SUM (fdebitamount-fcreditamount) fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)startPeriod.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate < {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, SUM (fdebitamount-fcreditamount) fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)startPeriod.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid ");
        sb.appendSql(" UNION ");
        sb.appendSql(" select b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID ,b.fid,");
        sb.appendSql(" 0 fmonthstartamt,0 fmonthdebitamt,0 fmonthcreditamt,0 fmonthbalance ");
        sb.appendSql(" from T_BD_ACCOUNTBANKS b  ");
        sb.appendSql(" left join t_cas_journal j  on j.faccountbankid=b.fid ");
        sb.appendSql(" left join t_cas_journalbalance jb on jb.faccountbankid=b.fid ");
        sb.appendSql(" where j.FACCOUNTBANKID is null and jb.FACCOUNTBANKID is null and ");
        sb.appendSql(" b.FACCOUNTID in(select a.fid from T_BD_ACCOUNTVIEW a where a.FISBANK=1) and");
        if (!isShowCancelUs) {
            sb.appendSql(" b.fisclosed=0 and ");
        }
        sb.appendSql(" b.fopendate<={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("} ");
        sb.appendFilter("b.FCOMPANYID", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("b.FCURRENCYID", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        sb.execute(ctx);
    }

    private FMQuerySqlBuilder genResult(Context ctx, int amountUnit, boolean includeCash, boolean isHideNoDataAcct, int level, CompanyOrgUnitInfo curCompany, BigDecimal limit, String tbl) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" SELECT org.Fid orgId, org.Fid orgPId, org.FNumber orgNumber, org.FName_" + ctx.getLocale() + " orgName, v.FNumber viewNumber, v.Fname_" + ctx.getLocale() + " viewName, cur.Fname_" + ctx.getLocale());
        sb.appendSql(" curName, acct.Fnumber acctNumber, acct.Fname_" + ctx.getLocale() + " acctName, acct.FBankAccountNumber acctBankNumber, CONCAT(CONCAT(pe.FPeriodYear, '\u5e74'),CONCAT(pe.FPeriodNumber, '\u671f')) period,");
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fstartamount", " startamount", amountUnit));
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fdebitamt", " debitamt", amountUnit));
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fcreditamt", " creditamt", amountUnit));
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fendbalance", " endbalance", amountUnit));
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fyearstartamt", " yearstartamt", amountUnit));
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fyeardebitamt", " yeardebitamt", amountUnit));
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fyearcreditamt", " yearcreditamt", amountUnit));
        sb.appendSql(QingCapitalSumFacadeControllerBean.appUnit(" jb.fyearbalance", " yearbalance", amountUnit));
        sb.appendSql(" pro.FNumber proNumber, pro.FName_" + ctx.getLocale() + " proName, ");
        sb.appendSql(" bank.Fid BankId, bank.FParentId BankPId, bank.FNumber bankNumber, bank.FName_" + ctx.getLocale() + " bankName ");
        sb.appendSql(" FROM " + tbl + " jb ");
        sb.appendSql(" left join T_Org_Company org on jb.Fcompanyid = org.Fid ");
        sb.appendSql(" left join T_BD_AccountBanks acct on jb.faccountbankid = acct.Fid ");
        sb.appendSql(" left join T_BD_AccountView v on acct.faccountid = v.Fid ");
        sb.appendSql(" left join T_BD_Currency cur on jb.fcurrencyid = cur.Fid ");
        sb.appendSql(" left join T_BD_Period pe on jb.fperiodid = pe.Fid ");
        sb.appendSql(" left join T_BD_Bank bank on acct.fbank = bank.Fid ");
        sb.appendSql(" left join T_BD_AccountProperty pro on jb.FAccountPropertyID = pro.Fid ");
        sb.appendSql(" where 1=1");
        if (!includeCash) {
            sb.appendSql(" and jb.faccountbankid is not null");
        }
        if (isHideNoDataAcct) {
            sb.appendSql(" and (fyearstartamt <> 0 or fmonthstartamt <> 0 or fmonthdebitamt <> 0 or fmonthcreditamt <> 0 ");
            sb.appendSql(" or fmonthbalance <> 0 or fyeardebitamt <> 0 or fyearcreditamt <> 0 or fyearbalance <> 0 ");
            sb.appendSql(" or fdebitstartamt <> 0 or fcreditstartamt <> 0) ");
        }
        if (limit != null) {
            BigDecimal unitValue = new BigDecimal(String.valueOf(amountUnit));
            limit = limit.multiply(unitValue);
            sb.appendSql(" and  jb.fmonthbalance>=");
            sb.appendParam((Object)limit);
        }
        return sb;
    }

    public static String appUnit(String colName, String alia, int unit) {
        return colName + "/" + unit + " " + alia + ", ";
    }

    protected Map filedMetas(boolean isByDate) {
        HashMap<String, String> fileds = new HashMap<String, String>();
        fileds.put("orgNumber".toUpperCase(), "\u516c\u53f8\u7f16\u7801");
        fileds.put("orgName".toUpperCase(), "\u516c\u53f8\u540d\u79f0");
        fileds.put("viewNumber".toUpperCase(), "\u79d1\u76ee\u7f16\u7801");
        fileds.put("viewName".toUpperCase(), "\u79d1\u76ee\u540d\u79f0");
        fileds.put("curName".toUpperCase(), "\u5e01\u522b");
        fileds.put("acctNumber".toUpperCase(), "\u94f6\u884c\u8d26\u6237\u7f16\u7801");
        fileds.put("acctName".toUpperCase(), "\u94f6\u884c\u8d26\u6237\u540d\u79f0");
        fileds.put("acctBankNumber".toUpperCase(), "\u94f6\u884c\u8d26\u53f7");
        fileds.put("bankNumber".toUpperCase(), "\u94f6\u884c\u7f16\u7801");
        fileds.put("bankName".toUpperCase(), "\u94f6\u884c\u540d\u79f0");
        fileds.put("proNumber".toUpperCase(), "\u8d26\u6237\u7528\u9014\u7f16\u7801");
        fileds.put("proName".toUpperCase(), "\u8d26\u6237\u7528\u9014");
        if (isByDate) {
            fileds.put("createDate".toUpperCase(), "\u4e1a\u52a1\u65e5\u671f");
        } else {
            fileds.put("period".toUpperCase(), "\u671f\u95f4");
            fileds.put("startamount".toUpperCase(), "\u671f\u521d\u4f59\u989d");
            fileds.put("debitamt".toUpperCase(), "\u672c\u671f\u501f\u65b9");
            fileds.put("creditamt".toUpperCase(), "\u672c\u671f\u8d37\u65b9");
            fileds.put("endbalance".toUpperCase(), "\u671f\u672b\u4f59\u989d");
            fileds.put("yearstartamt".toUpperCase(), "\u5e74\u521d\u4f59\u989d");
            fileds.put("yeardebitamt".toUpperCase(), "\u672c\u5e74\u501f\u65b9");
            fileds.put("yearcreditamt".toUpperCase(), "\u672c\u5e74\u8d37\u65b9");
        }
        return fileds;
    }

    protected Map filedParentMetas() {
        HashMap<String, String> fileds = new HashMap<String, String>();
        fileds.put("orgId".toUpperCase(), "orgPId".toUpperCase());
        fileds.put("BankId".toUpperCase(), "BankPId".toUpperCase());
        return fileds;
    }

    private IRowSet getRowSetMeta(Context ctx, boolean isByDate) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" SELECT null orgId, null orgPId, null orgNumber, null orgName, null viewNumber, null viewName, null curName, null acctNumber, null acctName, null acctBankNumber, ");
        sb.appendSql(" null period, null proNumber, null proName, null BankId, null BankPId, null bankNumber, null bankName, 0.00 startamount, 0.00 debitamt, ");
        sb.appendSql(" 0.00 creditamt, 0.00 endbalance, 0.00 yearstartamt, 0.00 yeardebitamt, 0.00 yearcreditamt FROM dual ");
        return DbUtil.executeQuery((Context)ctx, (String)sb.getSql());
    }
}

