/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.batch.IBatchExecuteResult;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationEntryInfo;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.service.ServiceContext;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.NumberRuleUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.BillImageMapCollection;
import com.kingdee.eas.base.wssc.BillImageMapFactory;
import com.kingdee.eas.base.wssc.IBillImageMap;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.AgentPaymentBillDisposer;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.DisposerActionEnum;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.PaymentDisposerFactory;
import com.kingdee.eas.fi.cas.RecPayBillEntryInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingDisposerFactory;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.VcStatusEnum;
import com.kingdee.eas.fi.cas.app.AbstractRecPayBillControllerBean;
import com.kingdee.eas.fi.cas.validate.currency.GeneralCurrencyCheckBuilder;
import com.kingdee.eas.fi.cas.verifyStatusEnum;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class RecPayBillControllerBean
extends AbstractRecPayBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.RecPayBillControllerBean");
    protected static final String ARAP_RESOURCE = "com.kingdee.eas.fi.arap.ArapResource";
    private static BigDecimal ZERO = new BigDecimal("0.00");
    public static final String BIZFLOW_BOTP_RELATION_KEY = "relationColl";
    protected BigDecimal MAX_AMOUNT_VALUE = new BigDecimal("9999999999999.99");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkAccountView(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkAccountView(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkAccountView(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        RecPayBillInfo info = (RecPayBillInfo)model;
        this.checkAccountView(ctx, info.getOppAccount());
        IObjectCollection colls = (IObjectCollection)info.get("entries");
        Set ids = ConvertUtils.PROPS2SET((String)"oppAccount.id", (Object)colls);
        ids.remove(null);
        this.checkAccountViewBatch(ctx, ids);
    }

    private void checkAccountView(Context ctx, AccountViewInfo accountView) throws EASBizException, BOSException {
        if (accountView != null && (accountView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountView.getId()))).isIsCFreeze()) {
            throw new RecPayException(RecPayException.OPPACCTDISABLE);
        }
    }

    private void checkAccountViewBatch(Context ctx, Set ids) throws EASBizException, BOSException {
        if (ids != null && ids.size() > 0) {
            FilterInfo filter = ConvertUtils.FILTER((FilterItemInfo[])new FilterItemInfo[]{ConvertUtils.FITEM((Object[])new Object[]{"isCFreeze", 1}), ConvertUtils.include((String)"id", (Object)ids)});
            boolean hasFreeze = AccountViewFactory.getLocalInstance((Context)ctx).exists(filter);
            if (hasFreeze) {
                throw new RecPayException(RecPayException.OPPACCTDISABLE);
            }
        }
    }

    protected void _checkRL4CacelAudit(Context ctx, RecPayBillInfo id) throws BOSException, EASBizException {
        if (id == null) {
            return;
        }
        if (id.isIsBookRL()) {
            throw new RecPayException(RecPayException.HASBOOKGL);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this._exists(ctx, "where isInitializeBill=1 and id='" + pk.toString() + "'")) {
            String str = ResourceBase.getString((String)ARAP_RESOURCE, (String)"LogTitle", (Locale)ctx.getLocale());
            return str + super._getLogInfo(ctx, pk);
        }
        return super._getLogInfo(ctx, pk);
    }

    protected void recycleNumber(Context ctx, IObjectPK pk, RecPayBillInfo info) throws CodingRuleException, EASBizException, BOSException {
        String companyID;
        ICodingRuleManager iCodingRuleManager;
        if (info == null || info.getNumber() == null || info.getCompany() == null || info.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            info = this.getRecPayBillInfo(ctx, pk, sic);
        }
        if ((iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)info, companyID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)info)) && iCodingRuleManager.isUseIntermitNumber((IObjectValue)info, companyID)) {
            iCodingRuleManager.recycleNumber((IObjectValue)info, companyID, StringUtils.isEmpty((String)info.getOldNumber()) ? info.getNumber() : info.getOldNumber());
        }
    }

    protected boolean getbooleanValue(int origin) {
        return origin == 1;
    }

    protected SelectorItemCollection getPaymentBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("isCommitSettle"));
        sic.add(new SelectorItemInfo("fiVouchered"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        sic.add(new SelectorItemInfo("payerBank.name"));
        sic.add(new SelectorItemInfo("payerBank.inGroup"));
        sic.add(new SelectorItemInfo("payerAccount.name"));
        sic.add(new SelectorItemInfo("payeeType.name"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("settlementType.ntType.group"));
        sic.add(new SelectorItemInfo("settlementType.ntType.superGroup"));
        sic.add(new SelectorItemInfo("settlementType.payThroughBE"));
        sic.add(new SelectorItemInfo("cheque.number"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("projectManager.name"));
        sic.add(new SelectorItemInfo("payBillType.name"));
        sic.add(new SelectorItemInfo("payBillType.number"));
        sic.add(new SelectorItemInfo("payBillType.sourceSysType"));
        sic.add(new SelectorItemInfo("payBillType.isReturnBg"));
        sic.add(new SelectorItemInfo("payBillType.isFinanceTranUp"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.type"));
        sic.add(new SelectorItemInfo("feeType.name"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("company.baseExchangeTable"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.actualLocAmt"));
        sic.add(new SelectorItemInfo("entries.actualAmt"));
        sic.add(new SelectorItemInfo("entries.oppAccount.name"));
        sic.add(new SelectorItemInfo("entries.oppAccount.isBank"));
        sic.add(new SelectorItemInfo("entries.srcPlanBillId"));
        sic.add(new SelectorItemInfo("entries.srcPlanBillEntryId"));
        sic.add(new SelectorItemInfo("entries.outBgItemId"));
        sic.add(new SelectorItemInfo("entries.outBgItemNumber"));
        sic.add(new SelectorItemInfo("entries.outBgItemName"));
        sic.add(new SelectorItemInfo("entries.expenseType"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.number"));
        sic.add(new SelectorItemInfo("entries.assItemsEntries.*"));
        sic.add(new SelectorItemInfo("assItems.asstActType.id"));
        sic.add(new SelectorItemInfo("assItems.asstActType.number"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.number"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.name"));
        sic.add(new SelectorItemInfo("payerAccountBank.InnerAcct.company.id"));
        sic.add(new SelectorItemInfo("payerAccountBank.bank.inGroup"));
        sic.add(new SelectorItemInfo("actRecAccountBank.number"));
        sic.add(new SelectorItemInfo("actRecAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("actRecAccountBank.company.id"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.InnerAcct.number"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.InnerAcct.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.InnerAcct.name"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.InnerAcct.company.id"));
        return sic;
    }

    protected SelectorItemCollection getReceivingBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("accountant.name"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        sic.add(new SelectorItemInfo("entries.actualAmt"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("payeeAccount.name"));
        sic.add(new SelectorItemInfo("payeeAccount.isCash"));
        sic.add(new SelectorItemInfo("payeeAccount.isBank"));
        sic.add(new SelectorItemInfo("payerType.name"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("payeeBank.name"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("entries.actualLocAmt"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("projectManager.name"));
        sic.add(new SelectorItemInfo("payeeAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payeeAccountBank.ctrlStrategy.*"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("recBillType.name"));
        sic.add(new SelectorItemInfo("recBillType.number"));
        sic.add(new SelectorItemInfo("recBillType.sourceSysType"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.type"));
        sic.add(new SelectorItemInfo("feeType.name"));
        sic.add(new SelectorItemInfo("entries.oppAccount.name"));
        sic.add(new SelectorItemInfo("voucher.number"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("isCommitSettle"));
        sic.add(new SelectorItemInfo("payerType.*"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("settlementType.ntType.*"));
        sic.add(new SelectorItemInfo("payeeAccountBank.*"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("entries.*"));
        return sic;
    }

    @Override
    protected void _cancelAppointmentVoucher(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
    }

    @Override
    protected void _appointmentAccount(Context ctx, IObjectPK[] billId, AccountViewInfo accountViewInfo, AccountViewInfo oppAccount, ArrayList entriesIdlist) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelAppointmentAccount(Context ctx, IObjectPK[] billId, ArrayList entriesIdlist) throws BOSException, EASBizException {
    }

    protected void _cancelAppointmentAccount(Context ctx, IObjectPK billId) throws BOSException, EASBizException {
    }

    protected HashMap _appointmentAccount(Context ctx, IObjectPK[] billId, AccountViewInfo accountViewInfo) throws BOSException, EASBizException {
        return null;
    }

    protected HashMap _checkAppointmentAccount(Context ctx, IObjectPK[] billId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _dispose4Pay(Context ctx, PaymentBillInfo payBillInfo) throws BOSException, EASBizException {
        int i;
        IPaymentDisposer disposer = null;
        this.checkHasReversedVerifyBill(ctx, payBillInfo.getId().toString(), payBillInfo.getNumber(), false);
        PaymentBillEntryCollection entryColl = payBillInfo.getEntries();
        PaymentBillEntryInfo entryInfo = null;
        int size = entryColl.size();
        for (i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo == null) continue;
            disposer = PaymentDisposerFactory.getInstance(ctx, entryInfo.getSourceBillId());
            break;
        }
        if (disposer == null) {
            disposer = PaymentDisposerFactory.getInstance(ctx, payBillInfo.getSourceBillId());
        }
        if (disposer == null || disposer instanceof AgentPaymentBillDisposer) {
            size = entryColl.size();
            for (i = 0; i < size; ++i) {
                PaymentBillTypeInfo payBillType;
                entryInfo = entryColl.get(i);
                if (entryInfo.getSourceBillId() == null) continue;
                BOSObjectType bosType = BOSUuid.read((String)entryInfo.getSourceBillId()).getType();
                PaymentBillTypeInfo paymentBillTypeInfo = payBillType = payBillInfo.getPayBillType().getPreSetBillType() == null ? payBillInfo.getPayBillType() : payBillInfo.getPayBillType().getPreSetBillType();
                if (!bosType.equals((Object)payBillInfo.getBOSType()) || "201|202|203|204|205|206".indexOf(payBillType.getNumber()) < 0) continue;
                try {
                    String disposerName = "com.kingdee.eas.fi.ap.ApRefundBillDisposer";
                    disposer = (IPaymentDisposer)Class.forName(disposerName).newInstance();
                    break;
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        if (disposer != null) {
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setDestBill((CoreBaseInfo)payBillInfo);
            disposerAction.setActionType(DisposerActionEnum.PAY);
            disposer.dispose(ctx, disposerAction);
        }
    }

    @Override
    protected void _dispose4Rec(Context ctx, ReceivingBillInfo recBillInfo) throws BOSException, EASBizException {
        this.checkHasReversedVerifyBill(ctx, recBillInfo.getId().toString(), recBillInfo.getNumber(), true);
        ReceivingBillEntryCollection entryColl = recBillInfo.getEntries();
        ReceivingBillEntryInfo entryInfo = null;
        IReceivingDisposer disposer = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryColl.get(i);
            if (entryInfo == null) continue;
            disposer = ReceivingDisposerFactory.getInstance(ctx, entryInfo.getSourceBillId());
            break;
        }
        if (disposer != null) {
            BillDisposerAction disposerAction = new BillDisposerAction();
            disposerAction.setDestBill((CoreBaseInfo)recBillInfo);
            disposerAction.setActionType(DisposerActionEnum.REC);
            disposer.dispose(ctx, disposerAction);
        }
    }

    private String getCustomerBiz(Context ctx, String asstActID) throws BOSException, EASBizException {
        CustomerInfo cutomer;
        ObjectUuidPK pk;
        ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)ctx);
        if (iCustomer.exists((IObjectPK)(pk = new ObjectUuidPK(asstActID))) && (cutomer = iCustomer.getCustomerInfo((IObjectPK)pk)) != null && cutomer.getBizAnalysisCode() != null) {
            return cutomer.getBizAnalysisCode().getId().toString();
        }
        return "";
    }

    private String getSupplierBiz(Context ctx, String asstActID) throws BOSException, EASBizException {
        SupplierInfo supplier;
        ObjectUuidPK pk;
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        if (iSupplier.exists((IObjectPK)(pk = new ObjectUuidPK(asstActID))) && (supplier = iSupplier.getSupplierInfo((IObjectPK)pk)) != null && supplier.getBizAnalysisCode() != null) {
            return supplier.getBizAnalysisCode().getId().toString();
        }
        return "";
    }

    private IObjectValue getAsstAct(Context ctx, String asstActID) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bizAnalysisCode.id"));
        ObjectUuidPK pk = new ObjectUuidPK(asstActID);
        IObjectValue objVal = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(pk.getObjectType(), (IObjectPK)pk, sic);
        return objVal;
    }

    public boolean checkIsDefaultBillType(String number) {
        String[] defaultBillType = new String[]{"100", "102", "101", "103", "104", "105", "110", "201", "203", "202", "204", "205", "206", "210", "211", "212", "999"};
        for (int i = 0; i < defaultBillType.length; ++i) {
            if (!number.equalsIgnoreCase(defaultBillType[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block31: {
            int size;
            int relSize;
            EntityObjectInfo entityInfo;
            IObjectValue relEntryInfo;
            IORMappingDAO idao;
            block32: {
                logger.error((Object)("\u6536\u4ed8\u6b3e\u5355\u751f\u6210\u51ed\u8bc1\u540e\u7684\u53cd\u5199\uff0c\u64cd\u4f5c\u72b6\u6001\uff1a" + bOTBillOperStateEnum.getValue()));
                logger.error((Object)("\u6536\u4ed8\u6b3e\u5355\u751f\u6210\u51ed\u8bc1\u65f6\u5019\u7684\u5173\u8054\u5173\u7cfb\u96c6\u5408\u6570\u91cf\uff1a" + bOTRelationInfos.size()));
                if (bOTRelationInfos == null) return;
                if (bOTRelationInfos.size() < 1) {
                    return;
                }
                BOTRelationInfo botRelation = bOTRelationInfos.get(0);
                logger.error((Object)("\u6536\u4ed8\u6b3e\u5355\u751f\u6210\u51ed\u8bc1\u65f6\u5019\u7684\u5173\u8054\u5173\u7cfbid\uff1a" + botRelation.getId().toString()));
                logger.error((Object)("\u76ee\u6807\u5b9e\u4f53\u7684bostype\uff1a" + botRelation.getDestEntityID()));
                if (!new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
                    int i = 0;
                    int size2 = bOTRelationInfos.size();
                    while (i < size2) {
                        BOTRelationInfo tempBotRelation = bOTRelationInfos.get(i);
                        this._reverseSave(ctx, (IObjectPK)new ObjectStringPK(tempBotRelation.getSrcObjectID()), null, bOTBillOperStateEnum, (IObjectValue)tempBotRelation);
                        ++i;
                    }
                    return;
                }
                IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                String tableName = loader.getEntity(this.getBOSType()).getTable().getName();
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                String sql = "";
                conn = null;
                stmt = null;
                rs = null;
                try {
                    IRowSet rowSet;
                    String paramsql = null;
                    conn = this.getConnection(ctx);
                    stmt = conn.createStatement();
                    StringBuffer sqlID = new StringBuffer("");
                    for (int i = 0; i < bOTRelationInfos.size(); ++i) {
                        String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                        String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                        sqlID.append("'").append(srcBillId).append("',");
                        sql = BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum) ? "update " + tableName + " set fvoucherid=null,fvouchernumber=null,fvouchertypeid=null,ffivouchered=0,faccountantid=null,fisneedvoucher=1,FIsAppointVoucher=0 where FID = '" + srcBillId + "'" : (BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum) ? "Update " + tableName + " set (fvoucherid,fvouchernumber,fvouchertypeid,ffivouchered,faccountantid)= (select t2.fid,t2.fnumber,t2.fvouchertypeid,1,'" + userId + "' from t_gl_voucher t2 where t2.FID = '" + destBillId + "') where  " + tableName + ".FID = '" + srcBillId + "'" : "Update " + tableName + " set (fvoucherid,fvouchernumber,fvouchertypeid,ffivouchered,faccountantid,fisneedvoucher)= (select t2.fid,t2.fnumber,t2.fvouchertypeid,1,'" + userId + "',0 from t_gl_voucher t2 where t2.FID = '" + destBillId + "') where  " + tableName + ".FID = '" + srcBillId + "'");
                        logger.info((Object)sql);
                        logger.error((Object)("\u53cd\u5199\u6536\u4ed8\u6b3e\u5355\u7684\u662f\u5426\u751f\u6210\u51ed\u8bc1\u7b49\u5b57\u6bb5\u7684SQL\u8bed\u53e5\uff1a" + sql));
                        stmt.addBatch(sql);
                    }
                    if (sqlID.length() != 0) {
                        sqlID.deleteCharAt(sqlID.length() - 1);
                    }
                    if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                        String lockSql = "UPDATE " + tableName + " SET FLastUpdateTime = FLastUpdateTime WHERE FID IN (" + sqlID.toString() + ")";
                        DbUtil.execute((Context)ctx, (String)lockSql);
                        StringBuffer checkSql = new StringBuffer("");
                        checkSql.append("SELECT fid  FROM ").append(tableName);
                        checkSql.append(" WHERE FID IN (").append(sqlID.toString()).append(") and ffivouchered = 1");
                        IRowSet checkResult = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                        if (checkResult.next()) {
                            throw new RecPayException(RecPayException.VOUCHERED);
                        }
                    }
                    stmt.executeBatch();
                    boolean fAR = false;
                    if ("T_CAS_ReceivingBill".equals(tableName)) {
                        fAR = true;
                    }
                    if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                        if (sqlID.length() <= 0 || (rowSet = DbUtil.executeQuery((Context)ctx, (String)(paramsql = "select TOP 1 1 from " + tableName + " where fid in (" + sqlID.toString() + ") and fsourceType=" + (fAR ? "100" : "101")))).size() <= 0 || !rowSet.next()) break block31;
                        HashSet<String> delIDSet = new HashSet<String>();
                        int size3 = bOTRelationInfos.size();
                        for (int i = 0; i < size3; ++i) {
                            delIDSet.add(bOTRelationInfos.get(i).getDestObjectID());
                        }
                        if (delIDSet.size() > 0) {
                            StringBuffer delIDs = new StringBuffer("");
                            Iterator it = delIDSet.iterator();
                            while (it.hasNext()) {
                                delIDs.append("'").append(it.next()).append("',");
                            }
                            delIDs.deleteCharAt(delIDs.length() - 1);
                            DbUtil.execute((Context)ctx, (String)("DELETE FROM T_AR_ArApRelationEntry WHERE FDestObjectID IN (" + delIDs.toString() + ")"));
                        }
                        break block31;
                    }
                    if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                        if (sqlID.length() <= 0) break block31;
                        paramsql = null;
                        paramsql = fAR ? "select TOP 1 1 from " + tableName + " recbill where recbill.fid in (" + sqlID.toString() + ") AND recbill.fsourceType = 100" : "select TOP 1 1 from " + tableName + " paybill where paybill.fid in (" + sqlID.toString() + ") AND paybill.fsourceType = 101";
                        rowSet = DbUtil.executeQuery((Context)ctx, (String)paramsql);
                        boolean isARAP = false;
                        if (rowSet.next()) {
                            isARAP = true;
                        }
                        if (!isARAP) break block31;
                        idao = ORMappingDAO.getInstance((BOSObjectType)BOSObjectType.create((String)"97BBCB32"), (Context)ctx, (Connection)conn);
                        BOTRelationEntryInfo botRelationEntryInfo = null;
                        relEntryInfo = null;
                        entityInfo = loader.getEntity(BOSObjectType.create((String)"97BBCB32"));
                        relSize = 0;
                        size = bOTRelationInfos.size();
                        break block32;
                    }
                    if (!BOTBillOperStateEnum.EDIT.equals((Object)bOTBillOperStateEnum)) break block31;
                    rowSet = null;
                    if (sqlID.length() <= 0) break block31;
                    paramsql = "select fcompanyid,fisAppointVoucher,fid from " + tableName + " where fid in (" + sqlID.toString() + ") and fsourceType=" + (fAR ? "100" : "101");
                    rowSet = DbUtil.executeQuery((Context)ctx, (String)paramsql);
                    String companyID = "";
                    boolean isAllAppointVoucher = true;
                    StringBuffer fiVoucheredBillIDs = new StringBuffer("");
                    HashSet<String> companyIDSet = new HashSet<String>();
                    while (rowSet.next()) {
                        companyID = rowSet.getString(1);
                        companyIDSet.add(companyID);
                        if (isAllAppointVoucher) {
                            isAllAppointVoucher = rowSet.getBoolean(2);
                        }
                        if (rowSet.getBoolean(2)) continue;
                        fiVoucheredBillIDs.append("'").append(rowSet.getString(3)).append("',");
                    }
                    String companyIDs = this.convertSetToString(companyIDSet);
                    if (companyID.length() > 0 && companyIDs.length() > 0 && !isAllAppointVoucher) {
                        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                        company.setId(BOSUuid.read((String)companyID));
                        PeriodInfo arPeriod = CasForArApUtil.getSysStatusCtrolInfo(ctx, company, SystemEnum.ACCOUNTSRECEIVABLE).getCurrentPeriod();
                        PeriodInfo apPeriod = CasForArApUtil.getSysStatusCtrolInfo(ctx, company, SystemEnum.ACCOUNTSPAYABLE).getCurrentPeriod();
                        if (arPeriod == null) {
                            arPeriod = apPeriod;
                        } else if (apPeriod == null) {
                            apPeriod = arPeriod;
                        }
                        fiVoucheredBillIDs = fiVoucheredBillIDs.deleteCharAt(fiVoucheredBillIDs.length() - 1);
                        StringBuffer sb = new StringBuffer("");
                        sb.append("SELECT vouentry.FIsHand, vouentry.FID FROM ").append(tableName).append(" bill");
                        sb.append(" INNER JOIN T_GL_VOUCHERENTRY vouentry ON bill.FVoucherID = vouentry.FBillID");
                        sb.append(" WHERE bill.FID IN (").append(fiVoucheredBillIDs.toString()).append(")");
                        sb.append(" AND EXISTS (SELECT 1 FROM T_AR_CONTRASTACCOUNTVIEW account");
                        sb.append(" WHERE vouentry.FAccountID = account.FAccountID");
                        sb.append(" AND ((1 = 1 ");
                        if (arPeriod != null) {
                            sb.append(" AND account.FSystem = 1");
                            sb.append(" AND account.FPeriodYear = ").append(arPeriod.getPeriodYear());
                            sb.append(" AND account.FPeriodNumber = ").append(arPeriod.getPeriodNumber());
                        }
                        sb.append(")");
                        sb.append(" OR (1 = 1");
                        if (apPeriod != null) {
                            sb.append(" AND account.FSystem = 2");
                            sb.append(" AND account.FPeriodYear = ").append(apPeriod.getPeriodYear());
                            sb.append(" AND account.FPeriodNumber = ").append(apPeriod.getPeriodNumber());
                        }
                        sb.append(")) AND account.FCompanyID IN ").append(companyIDs.toString()).append(")");
                        rs = stmt.executeQuery(sb.toString());
                        HashSet<String> voucherEntryID = new HashSet<String>();
                        int rowCount = 0;
                        while (rs.next()) {
                            if (rs.getInt(1) == 1) {
                                throw new ArApRecPayException(ArApRecPayException.VOUCHER_FROM_DAP);
                            }
                            voucherEntryID.add(rs.getString(2));
                            ++rowCount;
                        }
                    }
                    break block31;
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            for (int i = 0; i < size; ++i) {
                for (BOTRelationEntryInfo botRelationEntryInfo : bOTRelationInfos.get(i).getRelationEntries()) {
                    relEntryInfo = Utils.newObjectValueInstance((EntityObjectInfo)entityInfo);
                    relEntryInfo.setString("srcObjectID", botRelationEntryInfo.getSrcObjectID());
                    relEntryInfo.setString("destObjectID", botRelationEntryInfo.getDestObjectID());
                    relEntryInfo.setString("srcEntryID", botRelationEntryInfo.getSrcEntryID());
                    relEntryInfo.setString("destEntryID", botRelationEntryInfo.getDestEntryID());
                    relEntryInfo.setDate("date", Calendar.getInstance().getTime());
                    idao.addNewBatch(relEntryInfo);
                    if (++relSize <= 2000) continue;
                    idao.executeBatch();
                    relSize = 0;
                }
            }
            if (relSize > 0) {
                idao.executeBatch();
            }
        }
        SQLUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
    }

    @Override
    public void _clearVouchFlag(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet.size() > 0) {
            StringBuffer sql = new StringBuffer("");
            StringBuffer idlist = new StringBuffer("");
            Iterator it = idSet.iterator();
            int i = 0;
            while (it.hasNext()) {
                if (i == 0) {
                    idlist.append("'").append(it.next()).append("'");
                    ++i;
                    continue;
                }
                idlist.append(",'").append(it.next()).append("'");
            }
            sql.append("update T_CAS_RECEIVINGBILL set FVoucherID=null,FfiVouchered=0,FvoucherNumber=null,FVoucherTypeID=null");
            sql.append("where FVoucherID in (").append(idlist).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            StringBuffer sql2 = new StringBuffer("");
            sql2.append("update T_CAS_PAYMENTBILL set FVoucherID=null,FfiVouchered=0,FvoucherNumber=null,FVoucherTypeID=null");
            sql2.append("where FVoucherID in (").append(idlist).append(")");
            DbUtil.execute((Context)ctx, (String)sql2.toString());
        }
    }

    protected boolean isExistAsstActByCompany(Context ctx, CompanyOrgUnitInfo comOrgInfo, AsstActTypeInfo assactTypeInfo, String asstActId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("");
        String relationDataObject = assactTypeInfo.getRealtionDataObject();
        if (relationDataObject == null) {
            assactTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assactTypeInfo.getId()));
            relationDataObject = assactTypeInfo.getRealtionDataObject();
        }
        boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
        boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
        boolean isexists = false;
        if (fCust) {
            sql.append(" SELECT CUSTOMER.FID FROM T_BD_Customer AS CUSTOMER ");
            sql.append(" INNER JOIN T_BD_CustomerCompanyInfo AS CUSTOMERCOMPANYINFO ");
            sql.append(" ON CUSTOMER.FID = CUSTOMERCOMPANYINFO.FCustomerID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON CUSTOMERCOMPANYINFO.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and CUSTOMER.fid= ? ");
        } else if (fSupp) {
            sql.append(" SELECT SUPPLIER.FID FROM T_BD_Supplier AS SUPPLIER ");
            sql.append(" INNER JOIN T_BD_SupplierCompanyInfo AS SUPPLIERCOMPANY ");
            sql.append(" ON SUPPLIER.FID = SUPPLIERCOMPANY.FSupplierID ");
            sql.append(" LEFT OUTER JOIN T_ORG_Company AS COMPANYORGUNIT ");
            sql.append(" ON SUPPLIERCOMPANY.FComOrgID = COMPANYORGUNIT.FID ");
            sql.append(" where COMPANYORGUNIT.FID = ?  and SUPPLIER.fid= ? ");
        } else {
            return true;
        }
        Object[] param = new Object[]{comOrgInfo.getId().toString(), asstActId};
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])param);
        if (rowSet.size() > 0) {
            isexists = true;
        } else {
            logger.info((Object)("CompanyID: " + comOrgInfo.getId().toString() + " AsstActID: " + asstActId));
        }
        return isexists;
    }

    @Override
    protected void _batchAppointmentVoucher(Context ctx, Collection ids, RecPayBillInfo billInfo, boolean isRec) throws BOSException, EASBizException {
        StringBuffer strIDs = new StringBuffer("");
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            strIDs.append("'").append(String.valueOf(it.next())).append("',");
        }
        if (strIDs.length() > 0) {
            strIDs.deleteCharAt(strIDs.length() - 1);
            String tableName = isRec ? "T_CAS_ReceivingBill" : "T_CAS_PaymentBill";
            String sbsql = "update " + tableName + " set FVoucherID = ?,FVoucherNumber = ?,FVoucherTypeID = ?,FIsAppointVoucher = 1,FFiVouchered = 1 ";
            sbsql = sbsql + ", FAccountantID=? ";
            sbsql = sbsql + "WHERE FID IN (" + strIDs.toString() + ")";
            Object[] params = new Object[]{billInfo.getVoucher().getId().toString(), billInfo.getVoucherNumber().toString(), billInfo.getVoucherType().getId().toString(), billInfo.getAccountant() == null ? null : billInfo.getAccountant().getId().toString()};
            DbUtil.execute((Context)ctx, (String)sbsql, (Object[])params);
        }
    }

    public BatchExecuteResult batchingExecute(Context ctx, MetaDataPK methodPK, Method batchMethod, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        ServiceStateManager.getInstance().setServiceState(this.getServiceState());
        ServiceStateManager.getInstance().getServiceState().enableServices();
        try {
            int i;
            BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
            ServiceContext[] arrSvcCtx = new ServiceContext[result.size()];
            for (int i2 = 0; i2 < arrSvcCtx.length; ++i2) {
                ServiceContext svcCtx = this.createServiceContext(methodPK, RecPayBillControllerBean.getParamValueArray(ctx, paramEntries[i2]));
                svcCtx.setExecutionMode(0);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i2] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            ArrayList<BatchExecuteParamsEntry> successedEntries = new ArrayList<BatchExecuteParamsEntry>();
            ArrayList<Integer> successedEntryIndex = new ArrayList<Integer>();
            for (int i3 = 0; i3 < arrSvcCtx.length; ++i3) {
                Throwable th = arrSvcCtx[i3].getServiceException();
                if (th == null) {
                    successedEntries.add(paramEntries[i3]);
                    successedEntryIndex.add(new Integer(i3));
                    continue;
                }
                result.setException(i3, th);
            }
            Object batchRtv = RecPayBillControllerBean.invoke(this, batchMethod, new Object[]{ctx, successedEntries.toArray(new BatchExecuteParamsEntry[0])});
            result.setBatchResult(batchRtv);
            if (batchRtv instanceof IBatchExecuteResult) {
                for (int i4 = 0; i4 < successedEntryIndex.size(); ++i4) {
                    IBatchExecuteResult ie = (IBatchExecuteResult)batchRtv;
                    if (!ie.exceptionOccured(i4)) continue;
                    int entryIndex = (Integer)successedEntryIndex.get(i4);
                    arrSvcCtx[entryIndex] = null;
                    if (!(ie instanceof BatchExecuteResult)) continue;
                    result.setException(entryIndex, ((BatchExecuteResult)ie).getException(entryIndex));
                }
            }
            for (i = 0; i < arrSvcCtx.length; ++i) {
                if (arrSvcCtx[i] == null) continue;
                if (arrSvcCtx[i].getServiceException() != null) {
                    arrSvcCtx[i] = null;
                    continue;
                }
                ServiceContext svcCtx = this.createServiceContext(methodPK, RecPayBillControllerBean.getParamValueArray(ctx, paramEntries[i]));
                svcCtx.setExecutionMode(1);
                svcCtx.setBatchExctue(true);
                arrSvcCtx[i] = svcCtx;
            }
            ServiceManagerFactory.getServiceManager().execute((IServiceContext[])arrSvcCtx);
            for (i = 0; i < arrSvcCtx.length; ++i) {
                Throwable th;
                if (arrSvcCtx[i] == null || (th = arrSvcCtx[i].getServiceException()) == null) continue;
                result.setException(i, th);
            }
            BatchExecuteResult batchExecuteResult = result;
            return batchExecuteResult;
        }
        catch (Throwable th) {
            this.setRollbackOnly();
            if (th instanceof BaseException) {
                throw (BaseException)th;
            }
            throw new BOSException(th);
        }
        finally {
            this.cleanUpServiceState();
        }
    }

    private static Object[] getParamValueArray(Context ctx, BatchExecuteParamsEntry entry) {
        Object[] params = new Object[entry.getParamTypes().length + 1];
        params[0] = ctx;
        Object[] entryItems = entry.toArray();
        System.arraycopy(entryItems, 0, params, 1, entryItems.length);
        return params;
    }

    private static Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected String convertSetToString(Set idSet) {
        StringBuffer idString = new StringBuffer("");
        if (idSet.size() > 0) {
            Iterator iterator = idSet.iterator();
            idString.append("(");
            while (iterator.hasNext()) {
                idString.append("'").append(iterator.next().toString()).append("'").append(",");
            }
            idString.deleteCharAt(idString.length() - 1);
            idString.append(")");
        }
        return idString.toString();
    }

    protected boolean isCheckCreditCondition(RecPayBillInfo info) {
        boolean isCheckCredit = false;
        if (info == null) {
            isCheckCredit = false;
        }
        if (!info.isIsCoopBuild()) {
            if (info instanceof ReceivingBillInfo) {
                ReceivingBillInfo recBillInfo = (ReceivingBillInfo)info;
                if (SourceTypeEnum.AR.equals((Object)info.getSourceType()) && !StringUtils.isEmpty((String)recBillInfo.getPayerID()) && (new CustomerInfo().getBOSType().equals((Object)BOSUuid.read((String)recBillInfo.getPayerID()).getType()) || new SupplierInfo().getBOSType().equals((Object)BOSUuid.read((String)recBillInfo.getPayerID()).getType()))) {
                    isCheckCredit = true;
                    if (info.isIsTransBill() && (StringUtils.isEmpty((String)recBillInfo.getAsstActID_SourceBill()) || recBillInfo.getPayerID().equals(recBillInfo.getAsstActID_SourceBill()))) {
                        isCheckCredit = false;
                    }
                }
            } else {
                PaymentBillInfo payBillInfo = (PaymentBillInfo)info;
                if (SourceTypeEnum.AP.equals((Object)payBillInfo.getSourceType()) && !StringUtils.isEmpty((String)payBillInfo.getPayeeID()) && (new CustomerInfo().getBOSType().equals((Object)BOSUuid.read((String)payBillInfo.getPayeeID()).getType()) || new SupplierInfo().getBOSType().equals((Object)BOSUuid.read((String)payBillInfo.getPayeeID()).getType()))) {
                    isCheckCredit = true;
                    if (info.isIsTransBill() && (StringUtils.isEmpty((String)payBillInfo.getAsstActID_SourceBill()) || payBillInfo.getPayeeID().equals(payBillInfo.getAsstActID_SourceBill()))) {
                        isCheckCredit = false;
                    }
                }
            }
        }
        return isCheckCredit;
    }

    protected void _newHandleAfterTransform(Context ctx, String action, IObjectCollection collection, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            collection.getObject(i).put(BIZFLOW_BOTP_RELATION_KEY, (Object)relationCol);
            collection.getObject(i).put("mappingId", (Object)mappingId);
        }
    }

    protected void _newHandleAfterTransform(Context ctx, String action, IObjectValue objectValue, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
        objectValue.put(BIZFLOW_BOTP_RELATION_KEY, (Object)relationCol);
        objectValue.put("mappingId", (Object)mappingId);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecPayBillInfo info;
        if (model.get("isEmergency") == null) {
            model.put("isEmergency", (Object)IsMergencyEnum.normal);
        }
        if ((info = (RecPayBillInfo)model).getVerifyStatus() == null) {
            info.setVerifyStatus(verifyStatusEnum.UNVERIFY);
        }
        return super._submit(ctx, (IObjectValue)info);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        RecPayBillInfo info = (RecPayBillInfo)model;
        if (info.getVerifyStatus() == null) {
            info.setVerifyStatus(verifyStatusEnum.UNVERIFY);
        }
        return super._save(ctx, (IObjectValue)info);
    }

    protected final void checkSourceCurrency(Context ctx, AbstractObjectCollection entries, String currencyId, String destBillName) throws BOSException, EASBizException {
        if (!entries.isEmpty()) {
            List<String> sourceBillIds = this.extractSourceBillIds(entries);
            if (sourceBillIds.isEmpty()) {
                return;
            }
            GeneralCurrencyCheckBuilder currencyCheck = new GeneralCurrencyCheckBuilder(ctx, sourceBillIds, destBillName);
            currencyCheck.check(currencyId);
        }
    }

    protected final List<String> extractSourceBillIds(AbstractObjectCollection entries) {
        HashSet<String> sourceBillIds = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            RecPayBillEntryInfo entry = (RecPayBillEntryInfo)entries.getObject(i);
            if (StringUtils.isEmpty((String)entry.getSourceBillId())) continue;
            sourceBillIds.add(entry.getSourceBillId());
        }
        return new ArrayList<String>(sourceBillIds);
    }

    protected RecPayBillInfo getRefundBillInfo(Context ctx, RecPayBillInfo redInfo) throws BOSException, EASBizException {
        BigDecimal totalUnLockAmtLoc;
        Boolean isAr = SourceTypeEnum.AR.equals((Object)redInfo.getSourceSysType());
        redInfo.setId(null);
        redInfo.setNumber(NumberRuleUtil.getNumberSilent((Context)ctx, (CoreBaseInfo)redInfo, (String)redInfo.getCompany().getId().toString()));
        redInfo.setBillStatus(BillStatusEnum.SAVE);
        redInfo.setSourceType(redInfo.getSourceSysType());
        redInfo.setBizDate(CasForArApUtil.getBizDateBySystem(ctx, isAr, redInfo.getCompany(), redInfo.getBizDate()));
        redInfo.put("billDate", DateUtil.getTime());
        redInfo.setFiVouchered(false);
        redInfo.setSettlementStatus(null);
        redInfo.setIsImport(false);
        redInfo.setIsRedBill(true);
        redInfo.setIsTransBill(false);
        redInfo.setIsTransOtherBill(false);
        redInfo.setVoucherType(null);
        redInfo.setVoucher(null);
        redInfo.setVoucherNumber(null);
        redInfo.setPcaVouchered(false);
        redInfo.setIsInitializeBill(false);
        BigDecimal totalUnLockAmt = totalUnLockAmtLoc = BigDecimal.ZERO;
        CurrencyInfo currency = redInfo.getCurrency();
        ExchangeRateInfo rateInfo = CasForArApUtil.getExchangeRate(ctx, redInfo.getCompany(), redInfo.getCurrency(), redInfo.getBizDate());
        BigDecimal converRate = new BigDecimal("1");
        boolean isDirectExchangeRate = true;
        if (rateInfo != null) {
            converRate = rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4);
            isDirectExchangeRate = CasForArApUtil.isDirectExchangeRate(rateInfo);
        }
        if (null != redInfo.getExchangeRate()) {
            converRate = redInfo.getExchangeRate();
        }
        AbstractObjectCollection entries = (AbstractObjectCollection)redInfo.get("entries");
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            RecPayBillEntryInfo entry = (RecPayBillEntryInfo)entries.getObject(i);
            BigDecimal unlockAmt = BigDecimal.ZERO;
            if (null != entry.getUnLockAmt()) {
                unlockAmt = entry.getUnLockAmt().negate();
            }
            BigDecimal unlockAmtLoc = BigDecimal.ZERO;
            if (null != entry.getUnLockLocAmt()) {
                unlockAmtLoc = entry.getUnLockLocAmt().negate();
            }
            if (BigDecimal.ZERO.compareTo(unlockAmtLoc) == 0) {
                unlockAmtLoc = CasForArApUtil.calculateLocalAmount(unlockAmt, converRate, isDirectExchangeRate, currency.getPrecision());
                unlockAmtLoc = unlockAmtLoc == null ? SysConstant.BIGZERO : unlockAmtLoc;
            }
            totalUnLockAmt = totalUnLockAmt.add(unlockAmt);
            totalUnLockAmtLoc = totalUnLockAmtLoc.add(unlockAmtLoc);
            entry.setId(null);
            entry.setVcStatus(VcStatusEnum.NOT_VERIFICATED);
            entry.setAmount(unlockAmt);
            entry.setAmountVc(ZERO);
            entry.setLocalAmt(unlockAmtLoc);
            entry.setLocalAmtVc(ZERO);
            entry.setUnVcAmount(entry.getAmount());
            entry.setUnVcLocAmount(entry.getLocalAmt());
            entry.setRebate(entry.getRebate() == null ? ZERO : entry.getRebate().negate());
            entry.setRebateLocAmt(entry.getRebateLocAmt() == null ? ZERO : entry.getRebateLocAmt().negate());
            entry.setRebateAmtVc(ZERO);
            entry.setRebateLocAmtVc(ZERO);
            entry.setActualAmt(entry.getAmount().subtract(entry.getRebate()));
            entry.setActualLocAmt(entry.getLocalAmt().subtract(entry.getRebateLocAmt()));
            entry.setActualAmtVc(ZERO);
            entry.setActualLocAmtVc(ZERO);
            entry.setLockAmt(ZERO);
            entry.setLockLocAmt(ZERO);
            entry.setUnLockAmt(entry.getAmount());
            entry.setUnLockLocAmt(entry.getLocalAmt());
            entry.setHisUnVcAmount(entry.getAmount());
            entry.setHisUnVcLocAmount(entry.getLocalAmt());
        }
        if (totalUnLockAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArApRecPayException(ArApRecPayException.UNLOCKZEROCANNOTREFUND);
        }
        redInfo.setAmount(totalUnLockAmt);
        redInfo.setLocalAmt(totalUnLockAmtLoc);
        redInfo.setVerifiedAmt(ZERO);
        redInfo.setUnVerifiedAmt(totalUnLockAmt);
        redInfo.setVerifiedAmtLoc(ZERO);
        redInfo.setUnVerifiedAmtLoc(totalUnLockAmtLoc);
        return redInfo;
    }

    protected void checkRecPayBill(RecPayBillInfo info) throws BOSException, EASBizException {
        BigDecimal totalUnLockAmt = ZERO;
        AbstractObjectCollection entryCol = (AbstractObjectCollection)info.get("entries");
        for (int j = 0; j < entryCol.size(); ++j) {
            RecPayBillEntryInfo entryInfo = (RecPayBillEntryInfo)entryCol.getObject(j);
            totalUnLockAmt = totalUnLockAmt.add(entryInfo.getUnLockAmt());
        }
        if (totalUnLockAmt.compareTo(BigDecimal.ZERO) == 0) {
            throw new ArApRecPayException(ArApRecPayException.UNLOCKZEROCANNOTREFUND);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super.delete(ctx, pk);
        boolean enable = WfEventListenerStateManager.getInstance().isEnable();
        if (enable) {
            WfEventListenerStateManager.getInstance().disableEventListener();
        }
        try {
            BOSUuid uuid = BOSUuid.read((String)pk.toString());
            String bosType = uuid.getType().toString();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("bosType", (Object)bosType));
            filter.getFilterItems().add(new FilterItemInfo("billID", (Object)pk.toString()));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("imageNumber"));
            view.setSelector(sic);
            IBillImageMap billImageMap = BillImageMapFactory.getLocalInstance((Context)ctx);
            BillImageMapCollection billImageMapCollection = billImageMap.getBillImageMapCollection(view);
            if (billImageMapCollection.size() > 0) {
                BillImageFacadeFactory.getLocalInstance((Context)ctx).deleteSSCAndImageDataByBillID(pk.toString(), true);
            }
        }
        finally {
            if (enable) {
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        super._delete(ctx, pk);
    }

    protected void handleLocAmt(Context ctx, RecPayBillInfo info, Map<String, ExchangeRateInfo> exchangeRateCache, boolean isPayBill) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = info.getCompany();
        CurrencyInfo currencyInfo = info.getCurrency();
        if (null != currencyInfo && null != companyOrgUnitInfo) {
            BigDecimal exchangeRate;
            ExchangeRateInfo exgRateInfo = com.kingdee.eas.fi.cas.utils.FMHelper.getExgRateInfo(ctx, currencyInfo, info.getBizDate(), companyOrgUnitInfo);
            boolean isDirectExchange = true;
            isDirectExchange = com.kingdee.eas.fi.cas.utils.FMHelper.chargeIsDirectExchange(exgRateInfo);
            int baseScale = 2;
            if (null != companyOrgUnitInfo.getBaseCurrency() && companyOrgUnitInfo.getBaseCurrency().getPrecision() > 0) {
                baseScale = companyOrgUnitInfo.getBaseCurrency().getPrecision();
            }
            if (null == (exchangeRate = info.getExchangeRate()) || exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                exchangeRate = null == exgRateInfo ? BigDecimal.ONE : exgRateInfo.getConvertRate();
            }
            AbstractObjectCollection entryColl = (AbstractObjectCollection)info.get("entries");
            RecPayBillEntryInfo entryInfo = null;
            BigDecimal payAmt = SysConstant.BIGZERO;
            BigDecimal rebateAmt = SysConstant.BIGZERO;
            BigDecimal apLocAmt = SysConstant.BIGZERO;
            BigDecimal vcAmt = SysConstant.BIGZERO;
            BigDecimal vcAmtLoc = SysConstant.BIGZERO;
            BigDecimal lockAmt = SysConstant.BIGZERO;
            BigDecimal lockAmtLoc = SysConstant.BIGZERO;
            BigDecimal rebateLocAmt = SysConstant.BIGZERO;
            BigDecimal matchedAmt = SysConstant.BIGZERO;
            BigDecimal matchedAmtLoc = SysConstant.BIGZERO;
            int size = entryColl.size();
            for (int j = 0; j < size; ++j) {
                entryInfo = (RecPayBillEntryInfo)entryColl.getObject(j);
                payAmt = null == entryInfo.getAmount() ? SysConstant.BIGZERO : entryInfo.getAmount();
                rebateAmt = null == entryInfo.getRebate() ? SysConstant.BIGZERO : entryInfo.getRebate();
                vcAmt = null == entryInfo.getAmountVc() ? SysConstant.BIGZERO : entryInfo.getAmountVc();
                vcAmtLoc = null == entryInfo.getLocalAmtVc() ? SysConstant.BIGZERO : entryInfo.getLocalAmtVc();
                lockAmt = null == entryInfo.getLockAmt() ? SysConstant.BIGZERO : entryInfo.getLockAmt();
                BigDecimal bigDecimal = lockAmtLoc = null == entryInfo.getLockLocAmt() ? SysConstant.BIGZERO : entryInfo.getLockLocAmt();
                if (null != entryInfo.getLocalAmt() && entryInfo.getLocalAmt().compareTo(BigDecimal.ZERO) != 0) continue;
                apLocAmt = com.kingdee.eas.fi.cas.utils.FMHelper.calLocAmt(payAmt, isDirectExchange, exchangeRate, baseScale);
                entryInfo.setLocalAmt(apLocAmt);
                entryInfo.setUnVcAmount(payAmt.subtract(vcAmt));
                entryInfo.setUnVcLocAmount(apLocAmt.subtract(vcAmtLoc));
                entryInfo.setUnLockAmt(payAmt.subtract(lockAmt));
                entryInfo.setUnLockLocAmt(apLocAmt.subtract(lockAmtLoc));
                rebateLocAmt = com.kingdee.eas.fi.cas.utils.FMHelper.calLocAmt(rebateAmt, isDirectExchange, exchangeRate, baseScale);
                entryInfo.setRebateLocAmt(rebateLocAmt);
                entryInfo.setActualAmt(payAmt.subtract(rebateAmt));
                entryInfo.setActualLocAmt(apLocAmt.subtract(rebateLocAmt));
                if (isPayBill) continue;
                matchedAmt = null == entryInfo.get("matchedAmount") ? SysConstant.BIGZERO : (BigDecimal)entryInfo.get("matchedAmount");
                matchedAmtLoc = com.kingdee.eas.fi.cas.utils.FMHelper.calLocAmt(matchedAmt, isDirectExchange, exchangeRate, baseScale);
                entryInfo.put("matchedAmountLoc", matchedAmtLoc);
            }
        }
    }

    @Override
    protected void _verify4WF(Context ctx, IObjectPK objectPK) throws BOSException {
    }

    protected void setExchangeRate(Context ctx, RecPayBillInfo info) throws BOSException, EASBizException {
        if (info.getExchangeRate() == null) {
            CurrencyInfo currency = info.getCurrency();
            CurrencyInfo baseCurrency = null;
            if (info.getCompany() != null) {
                baseCurrency = info.getCompany().getBaseCurrency();
            }
            ExchangeRateInfo exchangeRate = null;
            if (currency != null && !CasForArApUtil.idEquals((CoreBaseInfo)currency, (CoreBaseInfo)baseCurrency)) {
                exchangeRate = CasForArApUtil.getExchangeRate(ctx, info.getCompany(), currency, info.getBizDate());
                if (exchangeRate != null) {
                    info.setExchangeRate(exchangeRate.getConvertRate());
                }
            } else {
                info.setExchangeRate(CasConstants.BIGDECIMAL_ONE);
            }
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, sorter);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    protected void checkCancelRecPay4TransArAp(Context ctx, Set destSet, boolean isRec) throws BOSException, CasException {
        if (destSet == null || destSet.size() == 0) {
            return;
        }
        String ids = FMHelper.setTran2String((Set)destSet);
        String arapTable = isRec ? "T_AP_OTHERBILL" : "T_AR_OTHERBILL";
        StringBuffer sql = new StringBuffer(100);
        sql.append(" select  bill.fnumber as number from ").append(arapTable).append("  bill where fid in");
        sql.append(ids);
        sql.append(" and FIsTransBill = 1 and FIsTransOtherBill = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        StringBuilder numberBuilder = new StringBuilder();
        try {
            while (rowSet.next()) {
                String number = rowSet.getString("number");
                if (StringUtils.isEmpty((String)number)) continue;
                numberBuilder.append(number).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (numberBuilder.length() > 0) {
            if (isRec) {
                throw new CasException(CasException.CANNOTCANCELREC4TRANS, new Object[]{numberBuilder});
            }
            throw new CasException(CasException.CANNOTCANCELPAY4TRANS, new Object[]{numberBuilder});
        }
    }

    protected void checkHasReversedVerifyBill(Context ctx, String billId, String billNum, boolean isRec) throws BOSException, EASBizException {
        String tableName = isRec ? "T_AR_VERIFICATIONBILL" : "T_AP_VERIFICATIONBILL";
        String entryTableName = isRec ? "T_AR_VERIFICATIONBILLENTRY" : "T_AP_VERIFICATIONBILLENTRY";
        StringBuilder sqlBuilder = new StringBuilder(100);
        sqlBuilder.append("SELECT bill.FID ");
        sqlBuilder.append(" FROM ").append(tableName).append(" bill");
        sqlBuilder.append(" INNER JOIN ").append(entryTableName).append(" entry ON BILL.FID = ENTRY.FPARENTID");
        sqlBuilder.append(" WHERE entry.FBILLID = '").append(billId).append("'");
        sqlBuilder.append(" \tAND bill.FISREVERSEBILL = 1;");
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sqlBuilder.toString());
        try {
            if (result.next()) {
                throw new RecPayException(RecPayException.HAS_REVERSED_VERIFY, new Object[]{billNum});
            }
        }
        catch (SQLException e) {
            throw new BOSException("RecPayBillControllerBean.checkHasReversedVerifyBill SQLError", (Throwable)e);
        }
    }

    protected boolean isUpdateAsstNameMultiLangField() {
        return true;
    }
}

