/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CashCommonException;
import com.kingdee.eas.fi.cas.RecPayBillEntryInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.IDataImportVerify;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.Locale;

public class RecPayDataImportBaseVerify
implements IDataImportVerify {
    protected ExchangeRateInfo rateInfo = null;
    protected BigDecimal exchangeRate = null;
    protected int basePrecision = 2;

    protected String getCASAutoGenerateResource(Context ctx, String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)key, (Locale)ctx.getLocale());
    }

    protected void verifyEntryAmt(Context ctx, RecPayBillEntryInfo entry, RecPayBillInfo head) throws TaskExternalException {
        SourceTypeEnum type;
        if (null == this.rateInfo) {
            CompanyOrgUnitInfo curCompany = null;
            try {
                curCompany = head.getCompany();
                if (null == curCompany) {
                    throw new CashCommonException(CashCommonException.NULL_COMPANY);
                }
                this.rateInfo = CasForArApUtil.getExchangeRate(ctx, curCompany, head.getCurrency(), head.getBizDate());
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage());
            }
            CurrencyInfo baseCurrency = curCompany.getBaseCurrency();
            if (null == baseCurrency) {
                throw new TaskExternalException(this.getCASAutoGenerateResource(ctx, "222_CashHelper"));
            }
            this.basePrecision = baseCurrency.getPrecision();
            if (0 == this.basePrecision) {
                baseCurrency = this.getBaseCurrency(ctx, baseCurrency.getId().toString());
                this.basePrecision = baseCurrency.getPrecision();
            }
            this.exchangeRate = head.getExchangeRate();
        }
        if (SourceTypeEnum.AP.equals((Object)(type = head.getSourceType())) || SourceTypeEnum.AR.equals((Object)type)) {
            this.checkAmount(ctx, entry.getAmount(), entry.getLocalAmt(), "567_REC_PAY_AMT_NOT_MATCH_CALC");
            this.checkAmount(ctx, entry.getRebate(), entry.getRebateLocAmt(), "568_REBATE_AMT_NOT_MATCH_CALC");
        }
        this.checkAmount(ctx, entry.getAmountVc(), entry.getLocalAmtVc(), "558_VC_AMOUNT_NOT_MATCH_CALC");
    }

    protected void checkAmount(Context ctx, BigDecimal amt, BigDecimal localAmt, String resKey) throws TaskExternalException {
        if (null == amt && null == localAmt) {
            return;
        }
        if (null == amt) {
            amt = BigDecimal.ZERO;
        }
        if (null == localAmt) {
            amt = BigDecimal.ZERO;
        }
        boolean isDirectExchange = true;
        if (this.rateInfo != null && this.rateInfo.getExchangeAux() != null && ConvertModeEnum.INDIRECTEXCHANGERATE.equals((Object)this.rateInfo.getExchangeAux().getConvertMode())) {
            isDirectExchange = false;
        }
        if (isDirectExchange ? amt.multiply(this.exchangeRate).setScale(this.basePrecision, 4).compareTo(localAmt) != 0 : amt.divide(this.exchangeRate, this.basePrecision, 4).compareTo(localAmt) != 0) {
            throw new TaskExternalException(this.getCASAutoGenerateResource(ctx, resKey));
        }
    }

    protected CurrencyInfo getBaseCurrency(Context ctx, String baseCurrencyId) throws TaskExternalException {
        if (StringUtils.isEmpty((String)baseCurrencyId)) {
            throw new TaskExternalException(this.getCASAutoGenerateResource(ctx, "222_CashHelper"));
        }
        ObjectUuidPK pk = new ObjectUuidPK(baseCurrencyId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("precision"));
        CurrencyInfo currency = null;
        try {
            currency = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk, sic);
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return currency;
    }

    public boolean checkIsDefaultRedBillType(Integer number) {
        int[] defaultRedBillType = new int[]{102, 103, 105, 203, 204, 206};
        for (int i = 0; i < defaultRedBillType.length; ++i) {
            if (number != defaultRedBillType[i]) continue;
            return true;
        }
        return false;
    }

    public boolean checkIsDefaultBlueBillType(Integer number) {
        int[] defaultRedBillType = new int[]{100, 101, 104, 110, 201, 202, 205};
        for (int i = 0; i < defaultRedBillType.length; ++i) {
            if (number != defaultRedBillType[i]) continue;
            return true;
        }
        return false;
    }

    public void checkEmpty(Context ctx, Object obj, String msg) throws TaskExternalException {
        if (obj == null) {
            throw new TaskExternalException(msg + this.getCASAutoGenerateResource(ctx, "31_AgentPayBillImportVerify"));
        }
    }

    @Override
    public void verifyHead(Context ctx, CoreBaseInfo head) throws TaskExternalException {
    }

    @Override
    public void verifyEntry(Context ctx, CoreBaseInfo entry, SourceTypeEnum type) throws TaskExternalException {
    }
}

