/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IReceiptFormDisposer;
import com.kingdee.eas.fi.cas.ReceiptDisposerFactory;
import com.kingdee.eas.fi.cas.ReceiptException;
import com.kingdee.eas.fi.cas.ReceiptFormEntryCollection;
import com.kingdee.eas.fi.cas.ReceiptFormEntryInfo;
import com.kingdee.eas.fi.cas.ReceiptFormInfo;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.AbstractReceiptFormControllerBean;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceiptFormControllerBean
extends AbstractReceiptFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.ReceiptFormControllerBean");
    public static final BOSObjectType SRC_BILL_ACCT = new VoucherAssistRecordInfo().getBOSType();
    public static final BOSObjectType SRC_BILL_REC = new ReceivingBillInfo().getBOSType();

    protected void initNumber(Context ctx, ReceiptFormInfo info) throws BOSException, EASBizException {
        FilterInfo filter;
        if (!FMHelper.isEmpty((String)info.getNumber())) {
            return;
        }
        int i = 0;
        do {
            String numberSilent = FMHelper.getNumberSilent((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
            info.setNumber(numberSilent);
        } while (this._exists(ctx, filter = FMHelper.getCheckNumberDupFilter((IObjectValue)info, (boolean)true)) && ++i < 10);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ReceiptFormInfo info = (ReceiptFormInfo)model;
        if (info.getCompany() == null) {
            throw new ReceiptException(ReceiptException.COMPANY_ISNULL);
        }
        this.initNumber(ctx, info);
        this._checkNumberDup(ctx, model);
        this.writeBack2SrcBill(ctx, model);
        if (((ReceiptFormInfo)model).getBizDate() == null) {
            ((ReceiptFormInfo)model).setBizDate(DateTimeUtils.truncateDate((Date)new Date()));
        }
        if (info.getAmtSum() == null || info.getAmtSum().compareTo(FMConstants.ZERO) == 0) {
            info.setAmtSum(this.getAmtSum(info));
        }
        return super._addnew(ctx, model);
    }

    private BigDecimal getAmtSum(ReceiptFormInfo info) {
        BigDecimal sum = FMConstants.ZERO;
        if (info.getEntrys() == null || info.getEntrys().size() <= 0) {
            return sum;
        }
        int size = info.getEntrys().size();
        for (int i = 0; i < size; ++i) {
            sum = sum.add(info.getEntrys().get(i).getAmount());
        }
        return sum;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    private void writeBack2SrcBill(Context ctx, IObjectValue model) throws BOSException, ReceiptException {
        ReceiptFormInfo info = (ReceiptFormInfo)model;
        if (info == null || info.getEntrys() == null || info.getEntrys().size() < 1) {
            throw new ReceiptException(ReceiptException.BILLENTRY_ISNULL);
        }
        String srcBillID = info.getEntrys().get(0).getSrcBillID();
        if (srcBillID == null) {
            throw new ReceiptException(ReceiptException.SRCBILLID_ISNULL);
        }
        BOSObjectType bosType = BOSUuid.read((String)srcBillID).getType();
        if (bosType.equals((Object)SRC_BILL_ACCT)) {
            this.writeBack2Acct(ctx, (IObjectValue)info);
        } else if (bosType.equals((Object)SRC_BILL_REC)) {
            this.writeBack2Rec(ctx, (IObjectValue)info);
        }
    }

    private void writeBack2Acct(Context ctx, IObjectValue model) throws BOSException {
        ReceiptFormInfo info = (ReceiptFormInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_GL_VoucherAssistRecord SET FReceiptformID=?, FReceiptFormEntryID=? ").append(" Where FID = ?");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int size = info.getEntrys().size();
            for (int i = 0; i < size; ++i) {
                pstmt.setString(1, info.getId().toString());
                pstmt.setString(2, info.getEntrys().get(i).getId().toString());
                pstmt.setString(3, info.getEntrys().get(i).getSrcBillEntryID());
                pstmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private void writeBack2Rec(Context ctx, IObjectValue model) throws BOSException {
        ReceiptFormInfo info = (ReceiptFormInfo)model;
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_CAS_ReceivingBillEntry SET FReceiptNumber=?, FReceiptID=? ").append(" Where FID IN " + this.getIDs(info));
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, info.getNumber());
            pstmt.setString(2, info.getId().toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private String getIDs(ReceiptFormInfo info) {
        ReceiptFormEntryCollection coll = info.getEntrys();
        String ids = "(";
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            ids = i == 0 ? ids + "'" + coll.get(i).getSrcBillEntryID() + "'" : ids + ", '" + coll.get(i).getSrcBillEntryID() + "'";
        }
        return ids + ")";
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        ReceiptFormInfo info = (ReceiptFormInfo)this._getValue(ctx, pk);
        HashSet<String> set = new HashSet<String>();
        set.add(pk.toString());
        this._blankOut(ctx, set);
        super._delete(ctx, pk);
        FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    protected void _blankOut(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.size() < 1) {
            return;
        }
        String ids = FMHelper.setTran2String((Set)idSet);
        if (ids == null) {
            return;
        }
        this.checkCanBlankOut(ctx, ids);
        String sql = "UPDATE T_CAS_ReceiptForm SET FBillStatus = ? WHERE FID IN " + ids;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            pstmt.setInt(1, 0);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        String billId2 = null;
        IReceiptFormDisposer disposer = null;
        ReceiptFormEntryCollection entryColl = null;
        ReceiptFormEntryInfo entryInfo = null;
        for (String billId2 : idSet) {
            entryColl = (ReceiptFormEntryCollection)this.getBillEntryColl(ctx, (IObjectPK)new ObjectUuidPK(billId2));
            int size = entryColl.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = entryColl.get(i);
                if (entryInfo == null || (disposer = ReceiptDisposerFactory.getInstance(ctx, entryInfo.getSrcBillID())) == null) continue;
                disposer.clearReceiptNumber(ctx, entryInfo.getSrcBillID(), entryInfo.getSrcBillEntryID());
            }
        }
    }

    private void checkCanBlankOut(Context ctx, String ids) throws BOSException, EASBizException {
        String sql = "SELECT FBillStatus FROM T_CAS_ReceiptForm WHERE FID IN " + ids;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("FBillStatus") != 0) continue;
                throw new ReceiptException(ReceiptException.IS_BLANKOUTED);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
    }

    private IObjectCollection getBillEntryColl(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return new ReceiptFormEntryCollection();
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("entrys.id"));
        selector.add(new SelectorItemInfo("entrys.srcBillID"));
        selector.add(new SelectorItemInfo("entrys.srcBillEntryID"));
        ReceiptFormInfo info = this.getReceiptFormInfo(ctx, pk, selector);
        ReceiptFormEntryCollection coll = info.getEntrys();
        return coll;
    }
}

