/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.EJBAccessFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ProjectInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AbstractFMDataImport;
import com.kingdee.eas.fi.cas.AssItemsForCashRecCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashRecFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.FeeTypeInfo;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.IReceivingBillEntry;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryFactory;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.CASReceivingBillImportVerify;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil;
import com.kingdee.eas.fi.cas.app.RecAndPayDataImportUtil2;
import com.kingdee.eas.fi.gl.IVoucherFacade;
import com.kingdee.eas.fi.gl.VoucherFacadeFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.budget.BgItemInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceivingBillDataImport
extends AbstractFMDataImport {
    private static Logger logger = Logger.getLogger((String)ReceivingBillDataImport.class.getName());
    private CASReceivingBillImportVerify verify;
    private Map infoMap = new HashMap(100);
    private Map seqMap = new HashMap();
    private String lastKey;
    private String curKey;
    private boolean cs032;
    private boolean cs074;
    private boolean cs063;
    private boolean flag = false;
    private Map assTypeIDMap = new HashMap();

    @Override
    protected ICoreBase _getController(Context ctx) throws BOSException {
        return ReceivingBillFactory.getLocalInstance(ctx);
    }

    public CASReceivingBillImportVerify getVerify() {
        if (this.verify == null) {
            this.verify = new CASReceivingBillImportVerify();
        }
        return this.verify;
    }

    public void setVerify(CASReceivingBillImportVerify verify) {
        this.verify = verify;
    }

    @Override
    public CoreBaseInfo _transmit(Hashtable hsData, Context ctx) throws EASBizException, BOSException {
        String number = (String)this.getData(hsData, "FNumber");
        this.curKey = EmptyUtil.isEmpty((String)number) ? Uuid.create().toString() : number;
        if (this.lastKey == null) {
            this.lastKey = this.curKey;
        }
        String companyId = null;
        CompanyOrgUnitInfo company = null;
        Object companyData = this.getData(hsData, "FCompany_id");
        if (companyData != null && companyData.toString().trim().length() > 0) {
            company = RecAndPayDataImportUtil2.getCompanyByNumber(ctx, (String)companyData);
        }
        if (company == null) {
            company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        }
        companyId = company.getId().toString();
        ReceivingBillInfo head = null;
        ReceivingBillEntryInfo entry = null;
        IContextHelper contextHelper = ContextHelperFactory.getLocalInstance((Context)ctx);
        this.cs032 = contextHelper.getBooleanParam("CS032", (IObjectPK)new ObjectUuidPK(companyId));
        this.cs074 = contextHelper.getBooleanParam("CS074", (IObjectPK)new ObjectUuidPK(companyId));
        this.cs063 = contextHelper.getBooleanParam("CS063", (IObjectPK)new ObjectUuidPK(companyId));
        Integer datataskMode = (Integer)this.getContextParameter().get("DATATASKMODE");
        int mode = datataskMode;
        if (this.infoMap.containsKey(this.curKey)) {
            head = (ReceivingBillInfo)this.infoMap.get(this.curKey);
            head.setCompany(company);
        } else {
            head = this.getHeadInfo(ctx, mode, number, companyId);
            head.setCompany(company);
            head = (ReceivingBillInfo)this.parseHead(hsData, ctx, head);
            this.infoMap.put(this.curKey, head);
        }
        CurrencyInfo baseCurrency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(head.getCompany());
        String headId = head.getId() == null ? null : head.getId().toString();
        Integer fseq = this.seqMap.get(this.curKey) == null ? new Integer(1) : (Integer)this.seqMap.get(this.curKey);
        entry = this.getEntryInfo(ctx, mode, headId, fseq.toString());
        this.seqMap.put(this.curKey, new Integer(fseq + 1));
        entry = (ReceivingBillEntryInfo)this.parseEntry(hsData, ctx, entry, companyId);
        entry.setSeq(fseq);
        try {
            String data;
            AccountViewInfo acctViewInfo = entry.getOppAccount();
            VoucherInfo.DynamicColumnInfo[] dyColumnInfos = null;
            if (acctViewInfo != null && acctViewInfo.getCAA() != null) {
                Object[] fetchAssColumnInfo;
                IVoucherFacade voucherFacade = VoucherFacadeFactory.getLocalInstance((Context)ctx);
                try {
                    fetchAssColumnInfo = voucherFacade.fetchAssColumnInfo(acctViewInfo.getId().toString(), acctViewInfo.getCAA().getId().toString(), null);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"170_PaymentBillDataImport", (Locale)ctx.getLocale()) + acctViewInfo.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"171_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
                dyColumnInfos = (VoucherInfo.DynamicColumnInfo[])fetchAssColumnInfo[0];
                AssItemsForCashRecCollection assCol = entry.getAssItemsEntries();
                assCol.clear();
                if (assCol == null || assCol.size() == 0) {
                    for (int i = 0; i < dyColumnInfos.length; ++i) {
                        AsstActTypeInfo aTypeinfo_temp = (AsstActTypeInfo)this.assTypeIDMap.get(dyColumnInfos[i].getId());
                        if (aTypeinfo_temp == null) {
                            aTypeinfo_temp = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(dyColumnInfos[i].getId()));
                            this.assTypeIDMap.put(dyColumnInfos[i].getId(), aTypeinfo_temp);
                        }
                        AssItemsForCashRecInfo assInfo_temp = new AssItemsForCashRecInfo();
                        assInfo_temp.setAsstActType(aTypeinfo_temp);
                        assInfo_temp.setIsSelected(false);
                        assInfo_temp.setEntryParent(entry);
                        assInfo_temp.setEntrySeq(entry.getSeq());
                        assInfo_temp.setMappingFileds(aTypeinfo_temp.getMappingFieldName());
                        assInfo_temp.setTableName(aTypeinfo_temp.getRealtionDataObject());
                        assCol.add(assInfo_temp);
                    }
                }
                String entryId = entry.getId() == null ? null : entry.getId().toString();
                for (int k = 1; k <= 8; ++k) {
                    Object data2 = this.getData(hsData, "FAssType" + k);
                    if (data2 != null && data2.toString().trim().length() > 0) {
                        AsstActTypeInfo assTypeInfo = this.getAsstActType(ctx, data2);
                        if (assTypeInfo == null) {
                            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"172_PaymentBillDataImport", (Locale)ctx.getLocale()) + data2.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"173_PaymentBillDataImport", (Locale)ctx.getLocale()));
                        }
                        AssItemsForCashRecInfo assInfo = this.getAssItemInfo(ctx, mode, entryId, assCol, assTypeInfo);
                        assInfo = this.parseAssItem(hsData, ctx, assTypeInfo, assInfo, k, entry);
                        if (assCol != null && assCol.size() > 0) {
                            int exFlag = 0;
                            for (int i = 0; i < assCol.size(); ++i) {
                                AssItemsForCashRecInfo entryInfo = assCol.get(i);
                                if (!entryInfo.getAsstActType().getId().equals((Object)assInfo.getAsstActType().getId())) continue;
                                assCol.set(i, assInfo);
                                ++exFlag;
                                break;
                            }
                            if (exFlag != 0) continue;
                            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + assTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                        }
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"104_CasPaymentBillImportVerify", (Locale)ctx.getLocale()) + assTypeInfo.getName() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"105_CasPaymentBillImportVerify", (Locale)ctx.getLocale()));
                    }
                    data2 = this.getData(hsData, "FAssNumber" + k);
                    if (data2 == null || data2.toString().trim().length() <= 0) continue;
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"174_PaymentBillDataImport", (Locale)ctx.getLocale()) + data2.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"175_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
            } else {
                entry.getAssItemsEntries().clear();
            }
            this.getVerify().verifyEntry(ctx, (CoreBaseInfo)entry, head.getSourceType(), dyColumnInfos);
            ReceivingBillEntryCollection coll = head.getEntries();
            int collSize = coll.size();
            if (coll != null && coll.size() > 0) {
                for (int i = 0; i < collSize; ++i) {
                    ReceivingBillEntryInfo entryInfo = coll.get(i);
                    if (entryInfo.getSeq() == entry.getSeq()) {
                        coll.set(i, entry);
                    } else {
                        if (entry.getSeq() <= collSize) continue;
                        coll.add(entry);
                    }
                    break;
                }
            } else {
                coll.add(entry);
            }
            String srcCurrId = head.getCurrency().getId().toString();
            String destCurrId = baseCurrency.getId().toString();
            baseCurrency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(destCurrId));
            ExchangeRateInfo exchangeRate = this.getExRateInfo(ctx, srcCurrId, destCurrId, company, new java.util.Date());
            boolean isIndirectExRate = this.isIndirectExRate(exchangeRate);
            int scale = head.getCurrency().getPrecision();
            BigDecimal rate = head.getExchangeRate();
            int round = 4;
            BigDecimal temp = entry.getActualAmt();
            if (temp == null) {
                temp = new BigDecimal(0);
            }
            if (rate == null) {
                rate = Constants.ZERO;
            }
            temp = isIndirectExRate ? temp.divide(rate, baseCurrency.getPrecision(), round) : temp.multiply(rate).setScale(baseCurrency.getPrecision(), round);
            entry.setActualLocAmt(temp);
            ReceivingBillEntryCollection col = head.getEntries();
            BigDecimal tempActualAmt = null;
            if (col != null) {
                BigDecimal amt = Constants.ZERO;
                BigDecimal amtLoc = Constants.ZERO;
                for (int i = 0; i < col.size(); ++i) {
                    ReceivingBillEntryInfo entryInfo = col.get(i);
                    tempActualAmt = entryInfo.getActualAmt();
                    if (tempActualAmt == null) {
                        tempActualAmt = new BigDecimal(0);
                    }
                    amt = amt.add(tempActualAmt).setScale(scale, round);
                    amtLoc = amtLoc.add(entryInfo.getActualLocAmt()).setScale(baseCurrency.getPrecision(), round);
                }
                head.setActRecAmt(amt);
                head.setActRecLocAmt(amtLoc);
            }
            if ((data = (String)this.getData(hsData, "oppBgItemNumber")) != null && data.toString().trim().length() > 0) {
                BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(data.toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"21_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
                head.setOppBgItemNumber(data.toString());
                head.setOppBgItemId(bgItemInfo.getId().toString());
                head.setOppBgItemName(bgItemInfo.getName());
            }
            this.getVerify().verifyHead(ctx, (CoreBaseInfo)head);
        }
        catch (BOSException e) {
            this.seqMap.put(this.curKey, new Integer((Integer)this.seqMap.get(this.curKey) - 1));
            throw e;
        }
        return head;
    }

    private ReceivingBillInfo getHeadInfo(Context ctx, int mode, String number, String companyid) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (companyid == null || number == null) {
                return new ReceivingBillInfo();
            }
            try {
                IReceivingBill iReceivingBill = (IReceivingBill)this.getController(ctx);
                ReceivingBillCollection coll = iReceivingBill.getReceivingBillCollection("where number = '" + number + "' and company.id = '" + companyid + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new ReceivingBillInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new ReceivingBillInfo();
        }
        return new ReceivingBillInfo();
    }

    private ReceivingBillEntryInfo getEntryInfo(Context ctx, int mode, String parentId, String FSeq) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (parentId == null || FSeq == null) {
                return new ReceivingBillEntryInfo();
            }
            try {
                IReceivingBillEntry iReceivingBillEntry = ReceivingBillEntryFactory.getLocalInstance(ctx);
                ReceivingBillEntryCollection coll = iReceivingBillEntry.getReceivingBillEntryCollection("where receivingBill = '" + parentId + "' and seq = '" + FSeq + "'");
                if (coll != null && coll.size() > 0) {
                    return coll.get(0);
                }
                return new ReceivingBillEntryInfo();
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if (mode == 8) {
            return new ReceivingBillEntryInfo();
        }
        return new ReceivingBillEntryInfo();
    }

    private CoreBaseInfo parseHead(Hashtable hsData, Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        AccountBankInfo payeeAccountBank;
        BizTypeEnum enum1;
        this.prepareImport(ctx, (IObjectValue)info, hsData);
        Object data = null;
        data = this.getData(hsData, "FNumber");
        if (data != null && data.toString().trim().length() > 0) {
            info.setNumber(data.toString());
        }
        if ((data = this.getData(hsData, "Fproject")) != null && data.toString().trim().length() > 0) {
            try {
                info.setProject(RecAndPayDataImportUtil.getProjectByNumber(ctx, data.toString()));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        if ((data = this.getData(hsData, "FAccessoryAmt")) != null && data.toString().trim().length() > 0) {
            info.setAccessoryAmt(TypeConversionUtils.objToInt((Object)data));
        }
        if ((data = this.getData(hsData, "FBizDate")) != null && data.toString().trim().length() > 0) {
            java.util.Date objToDate = RecAndPayDataImportUtil2.objToDate(ctx, data);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String format = dateFormat.format(objToDate);
            try {
                info.setBizDate(dateFormat.parse(format));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"16_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setCurrency(RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString()));
        } else {
            CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            try {
                info.setCurrency(ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getCompany()));
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.getData(hsData, "FPayeeAccountID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setPayeeAccount(RecAndPayDataImportUtil2.getAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"48_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString()));
        }
        if ((data = this.getData(hsData, "FExchangeRate")) != null && data.toString().trim().length() > 0) {
            info.setExchangeRate(TypeConversionUtils.objToBigDecimal((Object)data));
        }
        if ((data = this.getData(hsData, "FFundType")) != null && data.toString().trim().length() > 0 && (enum1 = BizTypeEnum.getEnum(TypeConversionUtils.objToInt((Object)data))) != null) {
            info.setFundType(enum1);
        }
        if ((data = this.getData(hsData, "FPayeeAccountBankID")) != null && data.toString().trim().length() > 0) {
            AccountBankInfo accountBank = RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"47_ArApReceivingBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), data.toString(), true, false);
            info.setPayeeAccountBank(accountBank);
            if (accountBank != null) {
                if (!accountBank.getCompany().getId().toString().equals(info.getCompany().getId().toString())) {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"275_ReceivingBillControllerBean", (Locale)ctx.getLocale()));
                }
                info.setPayeeBank(accountBank.getBank());
                info.setPayeeAccount(accountBank.getAccount());
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"280_ReceivingBillDataImport", (Locale)ctx.getLocale()) + data.toString() + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"244_PaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((payeeAccountBank = info.getPayeeAccountBank()) != null && payeeAccountBank.isIsByCurrency()) {
            CurrencyInfo currency = payeeAccountBank.getCurrency();
            if (!info.getCurrency().getId().equals((Object)currency.getId())) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"278_ReceivingBillControllerBean", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FFeeTypeID")) != null && data.toString().trim().length() > 0) {
            FeeTypeInfo feeType = RecAndPayDataImportUtil2.getFeeTypeByNumber(ctx, (String)data);
            info.setFeeType(feeType);
        }
        if ((data = this.getData(hsData, "FSettlementTypeID")) != null && data.toString().trim().length() > 0) {
            info.setSettlementType(RecAndPayDataImportUtil2.getSettlementTypeByNumber(data.toString(), ctx));
        }
        if ((data = this.getData(hsData, "FSettlementNumber")) != null && data.toString().trim().length() > 0) {
            info.setSettlementNumber(data.toString());
        }
        if ((data = this.getData(hsData, "FRecBillTypeID")) != null && data.toString().trim().length() > 0) {
            info.setRecBillType(RecAndPayDataImportUtil2.getRecBillTypeByNumber(data.toString(), ctx));
        }
        if (info.getRecBillType().getSourceSysType().equals((Object)SourceTypeEnum.CASH)) {
            this.flag = true;
            info.setSourceType(SourceTypeEnum.CASH);
        } else {
            info.setSourceType(info.getRecBillType().getSourceSysType());
        }
        info.setSourceSysType(SourceTypeEnum.CASH);
        data = this.getData(hsData, "FOppAccountID");
        if (data != null && data.toString().trim().length() > 0) {
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), info.getCompany().getId().toString(), info.getCurrency().getId().toString(), data.toString(), this.cs063, this.flag));
        }
        if ((data = this.getData(hsData, "FDescription")) != null && data.toString().trim().length() > 0) {
            if (data.toString().length() > 255) {
                throw new RecPayException(RecPayException.DESCNOTMORE, new String[]{String.valueOf(255)});
            }
            info.setDescription(data.toString());
        }
        if ((data = this.getData(hsData, "FPayerTypeID")) != null && data.toString().trim().length() > 0) {
            info.setPayerType(RecAndPayDataImportUtil2.getAsstActTypeByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"210_ReceivingBillDataImport", (Locale)ctx.getLocale()), data.toString()));
        }
        String companyID = null;
        data = this.getData(hsData, "FPayerNumber");
        if (data != null && data.toString().trim().length() > 0) {
            if (info.getPayerType() == null) {
                info.setPayerName(data.toString());
                info.setPayerNumber(data.toString());
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)data.toString().trim()));
                view.setFilter(filter);
                CompanyOrgUnitCollection companyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (companyColl != null && companyColl.size() > 0) {
                    companyID = companyColl.get(0).getId().toString();
                }
            } else {
                IRowSet asstActInfo = RecAndPayDataImportUtil2.getAsstActInfo(info.getPayerType(), data.toString(), ctx);
                try {
                    if (asstActInfo.next()) {
                        info.setPayerID(asstActInfo.getString("fid"));
                        info.setPayerNumber(asstActInfo.getString("fnumber"));
                        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
                        info.setPayerName(asstActInfo.getString("fname_" + loc));
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException(e.getMessage());
                }
            }
        }
        if ((data = this.getData(hsData, "FPayerBank")) != null && data.toString().trim().length() > 0) {
            info.setPayerBank(data.toString());
        }
        if ((data = this.getData(hsData, "FPayerAccountBank")) != null && data.toString().trim().length() > 0) {
            info.setPayerAccountBank(data.toString());
            info.setPayerAccountBankO(RecAndPayDataImportUtil2.getAccountBankByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"19_AgentPayBillDataImport", (Locale)ctx.getLocale()), companyID, data.toString(), false, true));
        }
        if (info.getPayerAccountBankO() != null) {
            info.setOppInnerAcct(info.getPayerAccountBankO().getInnerAcct());
        }
        info.setIsInitializeBill(false);
        info.setIsImport(true);
        if (info.getBillStatus() == null) {
            info.setBillStatus(BillStatusEnum.SAVE);
        }
        if (((data = this.getData(hsData, "feeType")) == null || data.toString().trim().length() <= 0) && this.cs032) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"211_ReceivingBillDataImport", (Locale)ctx.getLocale()));
        }
        data = this.getData(hsData, "FCostCenterID");
        if (data != null) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(data.toString().trim(), ctx, info.getCompany().getId().toString()));
        }
        if ((data = this.getData(hsData, "FAdminOrgUnitId")) != null) {
            info.setAdminOrgUnit(RecAndPayDataImportUtil2.getDepartmentByNumber(ctx, data.toString().trim()));
        }
        return info;
    }

    private boolean isExistHeadByNumber(Context ctx, String company, String number) throws BOSException {
        if (this.infoMap.containsKey(this.curKey)) {
            return false;
        }
        if (company == null || number == null) {
            return true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.number", (Object)company));
        evi.setFilter(filter);
        ReceivingBillCollection coll = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillCollection(evi);
        if (coll != null && coll.size() > 1) {
            throw new BOSException(number + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"22_AgentPayBillDataImport", (Locale)ctx.getLocale()));
        }
        return false;
    }

    public void submitHead(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException {
        try {
            IObjectPK pk = ReceivingBillFactory.getLocalInstance(ctx).save(coreBaseInfo);
            coreBaseInfo.setId(BOSUuid.read((String)pk.toString()));
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    private CoreBaseInfo parseEntry(Hashtable hsData, Context ctx, ReceivingBillEntryInfo info, String companyId) throws BOSException, EASBizException {
        this.prepareImport(ctx, (IObjectValue)info, hsData, "entries");
        Object data = null;
        info.setReceivingBill(RecAndPayDataImportUtil2.getReceivingBillByNumber(hsData, ctx));
        data = this.getData(hsData, "FRemark");
        if (data != null && data.toString().trim().length() > 0) {
            info.setRemark(data.toString());
        }
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        CurrencyInfo currency = null;
        data = this.getData(hsData, "FCurrencyID");
        if (data != null && data.toString().trim().length() > 0) {
            currency = RecAndPayDataImportUtil2.getCurrencyByNumber(ctx, data.toString());
        } else {
            try {
                currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCompanyBaseCurrency(info.getReceivingBill().getCompany());
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"17_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        data = this.cs074 ? this.getData(hsData, "FEntryActualAmt") : this.getData(hsData, "FActualAmt");
        if (data != null && data.toString().trim().length() > 0) {
            try {
                if (data.toString().contains(",")) {
                    Double douData = new DecimalFormat().parse(data.toString()).doubleValue();
                    info.setActualAmt(new BigDecimal(douData).setScale(currency.getPrecision(), 4));
                } else {
                    info.setActualAmt(new BigDecimal(data.toString()).setScale(currency.getPrecision(), 4));
                }
            }
            catch (Exception e) {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"178_PaymentBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        if ((data = this.getData(hsData, "FEntryOppAccID")) != null && data.toString().trim().length() > 0 && currency != null) {
            info.setOppAccount(RecAndPayDataImportUtil2.getOppAccountByNumber(ctx, ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"20_AgentPayBillDataImport", (Locale)ctx.getLocale()), companyId, currency.getId().toString(), data.toString(), this.cs063, this.flag));
        }
        if ((data = this.getData(hsData, "FEntries_oppBgItemNumber")) != null && data.toString().trim().length() > 0) {
            BgItemInfo bgItemInfo = RecAndPayDataImportUtil2.getBgItemByNumber(data.toString(), ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"23_AgentPayBillDataImport", (Locale)ctx.getLocale()), ctx);
            info.setOppBgItemNumber(data.toString());
            info.setOppBgItemId(bgItemInfo.getId().toString());
            info.setOppBgItemName(bgItemInfo.getName());
        }
        if ((data = this.getData(hsData, "FEntryFundFlowItem")) != null && data.toString().trim().length() > 0) {
            info.setFundFlowItem(RecAndPayDataImportUtil2.getFundFlowItemByNumber(data.toString(), ctx));
        }
        if ((data = this.getData(hsData, "FEntryCostCenter")) != null && data.toString().trim().length() > 0) {
            info.setCostCenter(RecAndPayDataImportUtil2.getCostCenterByNumber(data.toString(), ctx, companyId));
        }
        if (EmptyUtil.isEmpty((Object)info.getId())) {
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        }
        return info;
    }

    @Override
    protected String getTemplateNumber() {
        return "receivingBill";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        Object obj = this.getContextParameter().get("filter");
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo filter1 = (FilterInfo)obj;
            try {
                filter.mergeFilter(filter1, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return filter;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.fi.cas.CasReceivingBillQuery";
    }

    @Override
    public Hashtable _exportTransmit(IRowSet rs, Context ctx) throws EASBizException, BOSException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        try {
            String entryID;
            String costCenter;
            String department;
            String remark;
            String FEntryCostCenter;
            String bgItem;
            String entryBgItem;
            String FEntryFundFlowItem;
            String entryOppAccount;
            BigDecimal entryActualAmt;
            String settlementNumber;
            String settlementType;
            String bizType;
            String feeTypeId;
            String feeType;
            String project;
            String payeeNumber;
            String payerType;
            String oppAccount;
            String payerBank;
            String actRecAmt;
            String payerAccountBank;
            String number;
            String currency;
            String recBillType;
            String payeeAccount;
            BigDecimal exchangeRate;
            String payeeAccountBank;
            BigDecimal actualLocalAmt;
            Date bizDate;
            BigDecimal actualAmt;
            String description;
            String companyID = this.getString(rs, "company.number");
            if (companyID != null) {
                result.put("FCompany_id", companyID);
            }
            if ((description = this.getString(rs, "description")) != null) {
                result.put("FDescription", description);
            }
            if ((actualAmt = rs.getBigDecimal("actRecAmt")) != null) {
                result.put("FActualAmt", actualAmt);
            }
            if ((bizDate = rs.getDate("bizDate")) != null) {
                result.put("FBizDate", DateTimeUtils.format((java.util.Date)bizDate, (String)"yyyy-MM-dd"));
            }
            if ((actualLocalAmt = rs.getBigDecimal("actRecLocAmt")) != null) {
                result.put("FActualLocAmt", actualLocalAmt);
            }
            if ((payeeAccountBank = this.getString(rs, "payeeAccountBank.number")) != null) {
                result.put("FPayeeAccountBankID", payeeAccountBank);
            }
            if ((exchangeRate = rs.getBigDecimal("exchangeRate")) != null) {
                result.put("FExchangeRate", exchangeRate);
            }
            if ((payeeAccount = this.getString(rs, "payeeAccount.number")) != null) {
                result.put("FPayeeAccountID", payeeAccount);
            }
            if ((recBillType = this.getString(rs, "recBillType.number")) != null) {
                result.put("FRecBillTypeID", recBillType);
            }
            if ((currency = this.getString(rs, "currency.number")) != null) {
                result.put("FCurrencyID", currency);
            }
            if ((number = this.getString(rs, "number")) != null) {
                result.put("FNumber", number);
            }
            if ((payerAccountBank = rs.getString("payerAccountBank")) != null) {
                result.put("FPayerAccountBank", payerAccountBank);
            }
            if ((actRecAmt = rs.getString("actRecAmt")) != null) {
                result.put("FPayeeAmount", actRecAmt);
            }
            if ((payerBank = rs.getString("PAYERBANK")) != null) {
                result.put("FPayerBank", payerBank);
            }
            if ((oppAccount = rs.getString("oppAccount.number")) != null) {
                result.put("FOppAccountID", oppAccount);
            }
            if ((payerType = rs.getString("payerType.number")) != null) {
                result.put("FPayerTypeID", payerType);
            }
            if ((payeeNumber = this.getString(rs, "payerNumber")) != null) {
                result.put("FPayerNumber", payeeNumber);
            }
            if ((project = this.getString(rs, "project.number")) != null) {
                result.put("Fproject", project);
            }
            if ((feeType = this.getString(rs, "feeType.name")) != null) {
                result.put("feeType", feeType);
            }
            if ((feeTypeId = this.getString(rs, "feeType.number")) != null) {
                result.put("FFeeTypeID", feeTypeId);
            }
            if ((bizType = this.getString(rs, "bizType.number")) != null) {
                result.put("bizType", bizType);
            }
            if ((settlementType = this.getString(rs, "settlementType.number")) != null) {
                result.put("FSettlementTypeID", settlementType);
            }
            if ((settlementNumber = this.getString(rs, "settlementNumber")) != null) {
                result.put("FSettlementNumber", settlementNumber);
            }
            if ((entryActualAmt = rs.getBigDecimal("entries.actualAmt")) != null) {
                result.put("FEntryActualAmt", entryActualAmt);
            }
            if ((entryOppAccount = this.getString(rs, "entries.oppAccount.number")) != null) {
                result.put("FEntryOppAccID", entryOppAccount);
            }
            if ((FEntryFundFlowItem = this.getString(rs, "entries.fundFlowItem.number")) != null) {
                result.put("FEntryFundFlowItem", FEntryFundFlowItem);
            }
            if ((entryBgItem = this.getString(rs, "entries.oppBgItemNumber")) != null) {
                result.put("FEntries_oppBgItemNumber", entryBgItem);
            }
            if ((bgItem = this.getString(rs, "oppBgItemNumber")) != null) {
                result.put("oppBgItemNumber", bgItem);
            }
            if ((FEntryCostCenter = this.getString(rs, "entries.costCenter.number")) != null) {
                result.put("FEntryCostCenter", FEntryCostCenter);
            }
            if ((remark = this.getString(rs, "entries.remark")) != null) {
                result.put("FRemark", remark);
            }
            if ((department = this.getString(rs, "adminOrgUnit.number")) != null) {
                result.put("FAdminOrgUnitId", department);
            }
            if ((costCenter = this.getString(rs, "costCenter.number")) != null) {
                result.put("FCostCenterID", costCenter);
            }
            if ((entryID = this.getString(rs, "entries.id")) != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("entryParent", (Object)entryID));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("*"));
                selector.add(new SelectorItemInfo("asstActType.name"));
                EntityViewInfo view = EntityViewInfo.getInstance((FilterInfo)filter, (SelectorItemCollection)selector, null);
                AssItemsForCashRecCollection assColl = AssItemsForCashRecFactory.getLocalInstance(ctx).getAssItemsForCashRecCollection(view);
                if (assColl != null && assColl.size() > 0) {
                    int j = assColl.size();
                    for (int i = 0; i < j; ++i) {
                        AssItemsForCashRecInfo assInfo = assColl.get(i);
                        if (assInfo.getAsstActType() != null && assInfo.getAsstActType().getName() != null) {
                            result.put("FAssType" + (i + 1), assInfo.getAsstActType().getName());
                        }
                        if ("T_BD_GeneralAsstActType".equals(assInfo.getTableName())) {
                            if (!EmptyUtil.isEmpty((String)assInfo.getFromID())) {
                                ObjectUuidPK pk = new ObjectUuidPK(assInfo.getFromID());
                                GeneralAsstActTypeInfo info = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx).getGeneralAsstActTypeInfo((IObjectPK)pk);
                                result.put("FAssNumber" + (i + 1), info.getLongNumber().replaceAll("!", "."));
                            }
                        } else if (assInfo.getFromNumber() != null) {
                            result.put("FAssNumber" + (i + 1), assInfo.getFromNumber());
                        }
                        if (EmptyUtil.isEmpty((String)assInfo.getFromID())) continue;
                        CoreBaseInfo entityInfo = EJBAccessFactory.createLocalInstance((Context)ctx).getEntityInfo(assInfo.getFromID());
                        result.put("FAssName" + (i + 1), entityInfo.get("name"));
                    }
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return result;
    }

    @Override
    protected void _submit(CoreBaseInfo coreBaseInfo, Context ctx) throws BOSException, EASBizException {
        if (coreBaseInfo == null) {
            return;
        }
        if (coreBaseInfo.getId() == null || !this._getController(ctx).exists((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()))) {
            this._getController(ctx).addnew(coreBaseInfo);
        } else {
            ReceivingBillInfo info = (ReceivingBillInfo)coreBaseInfo;
            if (BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) || BillStatusEnum.SUBMIT.equals((Object)info.getBillStatus())) {
                this._getController(ctx).update((IObjectPK)new ObjectUuidPK(coreBaseInfo.getId()), coreBaseInfo);
            } else {
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"14_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
    }

    private AssItemsForCashRecInfo parseAssItem(Hashtable hsData, Context ctx, AsstActTypeInfo assTypeInfo, AssItemsForCashRecInfo info, int assIndex, ReceivingBillEntryInfo entry) throws BOSException {
        Object data = null;
        data = this.getData(hsData, "FAssType" + assIndex);
        if (data != null && data.toString().trim().length() > 0) {
            info.setAsstActType(assTypeInfo);
            info.setEntrySeq(entry.getSeq());
            info.setIsSelected(false);
            info.setEntryParent(entry);
            info.setMappingFileds(assTypeInfo.getMappingFieldName());
            info.setTableName(assTypeInfo.getRealtionDataObject());
            String assNumber = (String)this.getData(hsData, "FAssNumber" + assIndex);
            if (assNumber != null && assNumber.trim().length() > 0) {
                DataBaseInfo assObj = this.getAsstActObject(ctx, assTypeInfo, assNumber);
                if (!EmptyUtil.isEmpty((CoreBaseInfo)assObj)) {
                    if (assObj instanceof ProjectInfo && 2 == ((ProjectInfo)assObj).getStatus().getValue()) {
                        throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"471_projectClosed", (Locale)ctx.getLocale(), (Object[])new Object[]{assNumber}));
                    }
                    info.setIsSelected(true);
                    info.setFromNumber(assObj.getNumber());
                    info.setFromID(assObj.getId().toString());
                } else {
                    throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"180_PaymentBillDataImport", (Locale)ctx.getLocale()) + assNumber + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"173_PaymentBillDataImport", (Locale)ctx.getLocale()));
                }
            }
        }
        return info;
    }

    private AssItemsForCashRecInfo getAssItemInfo(Context ctx, int mode, String entryId, AssItemsForCashRecCollection assCol, AsstActTypeInfo assTypeInfo) throws BOSException, EASBizException {
        if (mode == 16 || mode == 128) {
            if (entryId == null || assCol == null || assCol.size() == 0) {
                return new AssItemsForCashRecInfo();
            }
            try {
                Iterator it = assCol.iterator();
                while (it.hasNext()) {
                    AssItemsForCashRecInfo info = (AssItemsForCashRecInfo)it.next();
                    if (!info.getAsstActType().getId().equals((Object)assTypeInfo.getId())) continue;
                    return info;
                }
                return new AssItemsForCashRecInfo();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"15_AgentPayBillDataImport", (Locale)ctx.getLocale()));
            }
        }
        return new AssItemsForCashRecInfo();
    }
}

