/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fm.ss.BusinessTypeInfo;
import com.kingdee.eas.fm.ss.InterfaceTypeEnum;
import com.kingdee.eas.fm.ss.SmartSettleEntryBusinessInfo;
import com.kingdee.eas.fm.ss.SmartSettleSchemaInfo;
import com.kingdee.eas.fm.ss.app.AbstractSmartSettleProcess;
import com.kingdee.eas.fm.ss.app.ISmartSettleProcess;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceivingBillSmartFilter
extends AbstractSmartSettleProcess {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.ReceivingBillSmartFilter");

    public List getSourceBillList(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        List result = new ArrayList();
        filterSql = this.getFilter(ctx, schemaID, businessEntryID, companyID, filterSql, queryPK);
        String queryOql = "";
        try {
            FilterInfo filterInfo = new FilterInfo(filterSql);
            if (FilterUtility.hasFilterItem((FilterInfo)filterInfo)) {
                FilterItemCollection filterItemCol = filterInfo.getFilterItems();
                for (int i = 0; i < filterItemCol.size(); ++i) {
                    String compareOp;
                    FilterItemInfo filterItemInfo = filterItemCol.get(i);
                    String filterField = filterItemInfo.getPropertyName();
                    String filterValue = "";
                    Object cmpVal = filterItemInfo.getCompareValue();
                    if (cmpVal != null) {
                        filterValue = cmpVal.toString();
                    }
                    if ("=".equals(compareOp = filterItemInfo.getCompareType().toString()) && filterValue != null && filterValue.indexOf("00:00:00") > -1) {
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + filterValue.substring(0, 10) + " 23:59:59')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    if (!"=".equals(compareOp) || filterValue == null || filterValue.indexOf(":") <= -1 || filterValue.indexOf("-") <= -1) continue;
                    SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String endValue = "";
                    try {
                        Date date = df.parse(filterValue);
                        date.setTime(date.getTime() + 1000L);
                        endValue = df.format(date);
                        if (EmptyUtil.isEmpty((String)endValue)) continue;
                        String sql = "( " + filterField + ">='" + filterValue + "' and " + filterField + " <= '" + endValue + " ')";
                        filterSql = filterSql.replaceAll(filterItemInfo.toString(), sql);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        if (filterSql != null && filterSql.length() > 0) {
            queryOql = "select id where " + filterSql + " and company.id = '" + companyID + "' ";
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        logger.error((Object)("ReceivingBillSmartFilter============" + iexec.getSQL() + " and \"RECEIVINGBILL\".fissmart in (1,3) "));
        result = this.getSourceBillRowSet(ctx, iexec.getSQL() + " and \"RECEIVINGBILL\".fissmart in (1,3) ");
        return result;
    }

    private String getFilter(Context ctx, String schemaID, String businessEntryID, String companyID, String filterSql, String queryPK) throws BOSException, EASBizException {
        BusinessTypeInfo busiType;
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)ctx.get((Object)"busiInfo");
        String className = busiInfo.getBusinessType().getClassName();
        if (className == null || "".equals(className)) {
            return null;
        }
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)"companyInfo");
        String billIDFilter = "";
        try {
            billIDFilter = ((ISmartSettleProcess)Class.forName(className).newInstance()).getSouceBillFilter(ctx, (OrgUnitInfo)companyInfo);
        }
        catch (Exception e) {
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"156_FundDispatchBillSmartFilter", (Locale)ctx.getLocale()) + className + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"157_FundDispatchBillSmartFilter", (Locale)ctx.getLocale()), (Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append("id in (").append(billIDFilter).append(") ");
            if (filterSql != null && !"".equals(filterSql)) {
                result.append(" and ").append(filterSql);
            }
        } else {
            result.append(filterSql);
        }
        if ((busiType = busiInfo.getBusinessType()) != null && !EmptyUtil.isEmpty((String)busiInfo.getOperatorNumber())) {
            String operatorNumber = busiInfo.getOperatorNumber();
            if (InterfaceTypeEnum.rec_submit.getName().equals(operatorNumber) || InterfaceTypeEnum.rec_submit_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.rec_submit_audit_rec.getName().equals(operatorNumber) || InterfaceTypeEnum.rec_audit_settle.getName().equals(operatorNumber)) {
                result.append(" and billStatus in (10,11) ");
            }
            if (InterfaceTypeEnum.rec_audit.getName().equals(operatorNumber) || InterfaceTypeEnum.audit_rec.getName().equals(operatorNumber) || InterfaceTypeEnum.audit_settle.getName().equals(operatorNumber)) {
                result.append(" and billStatus = 11 ");
            }
            if (InterfaceTypeEnum.rec_rec.getName().equals(operatorNumber)) {
                result.append(" and billStatus = 12 ");
            }
            if (InterfaceTypeEnum.rec_settle.getName().equals(operatorNumber)) {
                result.append(" and billStatus = 12 ");
            }
        }
        return result.toString();
    }

    public Map _process(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        SmartSettleEntryBusinessInfo busiInfo = (SmartSettleEntryBusinessInfo)paramMap.get("busiInfo");
        SmartSettleSchemaInfo schemaInfo = (SmartSettleSchemaInfo)paramMap.get("schemaInfo");
        String auditor = "";
        String payeer = "";
        String creator = "";
        if (schemaInfo != null && schemaInfo.getAuditor() != null) {
            auditor = schemaInfo.getAuditor().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getPayeer() != null) {
            payeer = schemaInfo.getPayeer().getId().toString();
        }
        if (schemaInfo != null && schemaInfo.getOriginator() != null) {
            creator = schemaInfo.getOriginator().getId().toString();
        }
        BusinessTypeInfo busiType = busiInfo.getBusinessType();
        List billList = (List)paramMap.get("billList");
        int success = 0;
        int failure = 0;
        String errorMsg = "";
        String sqlFailMsg = "UPDATE T_CAS_ReceivingBill SET fsettleFailMsg = ? where fid = ?";
        if (!EmptyUtil.isEmpty((Collection)billList)) {
            String sql;
            Object[] params;
            String msg;
            HashSet set;
            Object[] params2;
            String msg2;
            HashSet set2;
            HashSet smartSet;
            String operatorNumber = busiInfo.getOperatorNumber();
            IReceivingBill biz = ReceivingBillFactory.getLocalInstance(ctx);
            if (InterfaceTypeEnum.rec_submit.getName().equals(operatorNumber)) {
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        errorMsg = errorMsg + e.getMessage();
                        e.printStackTrace();
                        String msg3 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg3) && msg3.length() > 2000) {
                            msg3 = msg3.substring(0, 2000);
                        }
                        Object[] params3 = new Object[]{msg3, billList.get(i).toString()};
                        paramList.add(params3);
                    }
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.rec_audit.getName().equals(operatorNumber)) {
                smartSet = new HashSet();
                HashSet auditSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        smartSet.add(billList.get(i));
                        biz.audit(set2);
                        if (!EmptyUtil.isEmpty((String)auditor)) {
                            auditSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        msg2 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                            msg2 = msg2.substring(0, 2000);
                        }
                        params2 = new Object[]{msg2, billList.get(i).toString()};
                        paramList.add(params2);
                    }
                }
                if (!EmptyUtil.isEmpty(smartSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])smartSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(auditSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.rec_rec.getName().equals(operatorNumber)) {
                HashSet payeerSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        HashSet set3 = new HashSet();
                        set3.add(billList.get(i));
                        biz.rec(set3);
                        if (!EmptyUtil.isEmpty((String)payeer)) {
                            payeerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        String msg4 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg4) && msg4.length() > 2000) {
                            msg4 = msg4.substring(0, 2000);
                        }
                        Object[] params4 = new Object[]{msg4, billList.get(i).toString()};
                        paramList.add(params4);
                    }
                }
                if (!EmptyUtil.isEmpty(payeerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payeerSet.toArray()) + "   ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payeer});
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.rec_settle.getName().equals(operatorNumber)) {
                smartSet = new HashSet();
                HashSet creatorSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        ReceivingBillInfo info = biz.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()));
                        if (info.getSettlementStatus().getValue() == 12 || info.getSettlementStatus().getValue() == 11) {
                            smartSet.add(billList.get(i));
                            continue;
                        }
                        biz.commitSettle(set2);
                        if (!EmptyUtil.isEmpty((String)creator)) {
                            creatorSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        msg2 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                            msg2 = msg2.substring(0, 2000);
                        }
                        params2 = new Object[]{msg2, billList.get(i).toString()};
                        paramList.add(params2);
                    }
                }
                if (!EmptyUtil.isEmpty(smartSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])smartSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(creatorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])creatorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    String sql2 = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_ReceivingBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_ReceivingBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql2);
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.rec_submit_audit.getName().equals(operatorNumber)) {
                smartSet = new HashSet();
                HashSet auditorSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set2 = new HashSet();
                        set2.add(billList.get(i));
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        smartSet.add(billList.get(i));
                        biz.audit(set2);
                        if (!EmptyUtil.isEmpty((String)auditor)) {
                            auditorSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        msg2 = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg2) && msg2.length() > 2000) {
                            msg2 = msg2.substring(0, 2000);
                        }
                        params2 = new Object[]{msg2, billList.get(i).toString()};
                        paramList.add(params2);
                    }
                }
                if (!EmptyUtil.isEmpty(smartSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])smartSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(auditorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FID", (Object[])auditorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.rec_submit_audit_rec.getName().equals(operatorNumber)) {
                smartSet = new HashSet();
                HashSet auditorSet = new HashSet();
                HashSet payeerSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet();
                        set.add(billList.get(i));
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        smartSet.add(billList.get(i));
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)auditor)) {
                            auditorSet.add(billList.get(i));
                        }
                        biz.rec(set);
                        if (!EmptyUtil.isEmpty((String)payeer)) {
                            payeerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        msg = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                            msg = msg.substring(0, 2000);
                        }
                        params = new Object[]{msg, billList.get(i).toString()};
                        paramList.add(params);
                    }
                }
                if (!EmptyUtil.isEmpty(smartSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])smartSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(auditorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(payeerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payeerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payeer});
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.rec_audit_settle.getName().equals(operatorNumber)) {
                smartSet = new HashSet();
                HashSet auditorSet = new HashSet();
                HashSet creatorSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        ReceivingBillInfo info;
                        set = new HashSet();
                        set.add(billList.get(i));
                        biz.submitBill((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)billList.get(i).toString())));
                        smartSet.add(billList.get(i));
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)auditor)) {
                            auditorSet.add(billList.get(i));
                        }
                        if ((info = biz.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info.getSettlementStatus().getValue() == 11) continue;
                        biz.commitSettle(set);
                        if (!EmptyUtil.isEmpty((String)creator)) {
                            creatorSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        msg = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                            msg = msg.substring(0, 2000);
                        }
                        params = new Object[]{msg, billList.get(i).toString()};
                        paramList.add(params);
                    }
                }
                if (!EmptyUtil.isEmpty(smartSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])smartSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(auditorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(creatorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])creatorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    sql = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_ReceivingBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_ReceivingBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.audit_rec.getName().equals(operatorNumber)) {
                smartSet = new HashSet();
                HashSet auditorSet = new HashSet();
                HashSet payeerSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        set = new HashSet();
                        set.add(billList.get(i));
                        smartSet.add(billList.get(i));
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)auditor)) {
                            auditorSet.add(billList.get(i));
                        }
                        biz.rec(set);
                        if (!EmptyUtil.isEmpty((String)payeer)) {
                            payeerSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        msg = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                            msg = msg.substring(0, 2000);
                        }
                        params = new Object[]{msg, billList.get(i).toString()};
                        paramList.add(params);
                    }
                }
                if (!EmptyUtil.isEmpty(smartSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])smartSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(auditorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(payeerSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FCASHIERID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])payeerSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{payeer});
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
            if (InterfaceTypeEnum.audit_settle.getName().equals(operatorNumber)) {
                smartSet = new HashSet();
                HashSet auditorSet = new HashSet();
                HashSet creatorSet = new HashSet();
                ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                for (int i = 0; i < billList.size(); ++i) {
                    try {
                        ReceivingBillInfo info;
                        set = new HashSet();
                        set.add(billList.get(i));
                        String sql3 = "UPDATE T_CAS_ReceivingBill SET fissmart = ?  WHERE FID = ? ";
                        DbUtil.execute((Context)ctx, (String)sql3, (Object[])new Object[]{5, billList.get(i)});
                        smartSet.add(billList.get(i));
                        biz.audit(set);
                        if (!EmptyUtil.isEmpty((String)auditor)) {
                            auditorSet.add(billList.get(i));
                        }
                        if ((info = biz.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(billList.get(i).toString()))).getSettlementStatus().getValue() == 12 || info.getSettlementStatus().getValue() == 11) continue;
                        biz.commitSettle(set);
                        if (!EmptyUtil.isEmpty((String)creator)) {
                            creatorSet.add(billList.get(i));
                        }
                        ++success;
                        continue;
                    }
                    catch (Exception e) {
                        ++failure;
                        e.printStackTrace();
                        errorMsg = errorMsg + e.getMessage();
                        msg = e.getMessage();
                        if (!EmptyUtil.isEmpty((String)msg) && msg.length() > 2000) {
                            msg = msg.substring(0, 2000);
                        }
                        params = new Object[]{msg, billList.get(i).toString()};
                        paramList.add(params);
                    }
                }
                if (!EmptyUtil.isEmpty(smartSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET fissmart = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])smartSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{5});
                }
                if (!EmptyUtil.isEmpty(auditorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_CAS_ReceivingBill SET FAUDITORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"fid", (Object[])auditorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{auditor});
                }
                if (!EmptyUtil.isEmpty(creatorSet)) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("UPDATE T_FS_SettlementBill SET FCREATORID = ? WHERE");
                    sb.append(StringUtil.buildIn((String)"FSOURCEBILLID", (Object[])creatorSet.toArray()) + "  ");
                    DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])new Object[]{creator});
                    sql = "UPDATE T_FS_SettlementBill settle  SET  FCompanyApproverID  = (SELECT FApproverID  FROM T_CAS_ReceivingBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") where exists (select 1 from  T_CAS_ReceivingBill payment where payment.fid=settle.FSOURCEBILLID and " + StringUtil.buildIn((String)"settle.FSOURCEBILLID", (Object[])creatorSet.toArray()) + ") ";
                    DbUtil.execute((Context)ctx, (String)sql);
                }
                if (!EmptyUtil.isEmpty(paramList)) {
                    DbUtil.executeBatch((Context)ctx, (String)sqlFailMsg, paramList);
                }
            }
        }
        result.put("state", errorMsg.toString().length() > 0 ? 1 : 0);
        result.put("success", success);
        result.put("errorMsg", errorMsg);
        result.put("failure", failure);
        return result;
    }
}

