/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.BOTPUtil;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AutoGenerateRecRuleCollection;
import com.kingdee.eas.fi.cas.AutoGenerateRecRuleFactory;
import com.kingdee.eas.fi.cas.AutoGenerateRecRuleInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.BizTypeEnum;
import com.kingdee.eas.fi.cas.EnableStatusEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.RecBookOptionFactory;
import com.kingdee.eas.fi.cas.RecBookOptionInfo;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.AbstractReceivingCenterFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fm.be.ITransDetail;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.be.TransDetailInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReceivingCenterFacadeControllerBean
extends AbstractReceivingCenterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.ReceivingCenterFacadeControllerBean");
    private static final String RECEIVINGBILLADDNEWPERM = "cas_receivingbill_02addNew";

    @Override
    protected Map _getTodayRecResult(Context ctx, String companyIds, java.sql.Date date, String currency) throws BOSException, EASBizException {
        String sql = null;
        HashMap<String, Number> result = new HashMap<String, Number>();
        String[] ids = companyIds.split(",");
        if (currency == null) {
            return null;
        }
        sql = this.getTodayRecResultSql(ids, date, currency);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int count = 0;
        double amount = 0.0;
        try {
            if (rowSet.next()) {
                count = rowSet.getInt("count");
                result.put("count", count);
                amount = rowSet.getDouble("amount");
                result.put("amount", amount);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private String getTodayRecResultSql(String[] companyIds, java.sql.Date date, String currency) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(FID) as count ,SUM(FActRecAmt) as amount from T_CAS_ReceivingBill WHERE ");
        sql.append("FCompanyID in ( ");
        for (int i = 0; i < companyIds.length; ++i) {
            if (i == companyIds.length - 1) {
                sql.append("'" + companyIds[i] + "' ) ");
                continue;
            }
            sql.append("'" + companyIds[i] + "', ");
        }
        java.sql.Date endDate = new java.sql.Date(date.getTime() + 86400000L);
        sql.append("AND FBizDate>={d'" + date + "'} AND FBizDate<{d'" + endDate + "'} ");
        sql.append("AND FCurrencyID = '" + currency + "'");
        sql.append("AND FBillStatus = 14");
        return sql.toString();
    }

    @Override
    protected int _getUnRecDetailCount(Context ctx, String companyIds, java.sql.Date date) throws BOSException, EASBizException {
        String sql = null;
        String[] ids = companyIds.split(",");
        sql = this.getUnRecDetailCountSql(ids, date);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int rowCount = 0;
        try {
            if (rowSet.next()) {
                rowCount = rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }

    private String getUnRecDetailCountSql(String[] companyIds, java.sql.Date date) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(FID) as count from T_BE_TransDetail WHERE ");
        StringBuffer companySql = new StringBuffer("( ");
        for (int i = 0; i < companyIds.length; ++i) {
            if (i == companyIds.length - 1) {
                companySql.append("'" + companyIds[i] + "' ) ");
                continue;
            }
            companySql.append("'" + companyIds[i] + "', ");
        }
        sql.append("FBankAccountID IN ( select bd.Fid from t_bd_accountbanks bd left outer join T_BD_AcctBankTrusterEntries AS en on en.FAcctBankID=bd.fid where bd.fcompanyid in " + companySql + " or en.ftrustCompanyID in " + companySql + ") ");
        java.sql.Date endDate = new java.sql.Date(date.getTime() + 86400000L);
        sql.append("AND FBizTime>={d'" + date + "'} AND FBizTime<{d'" + endDate + "'} ");
        sql.append("AND  FISDEBIT =0");
        sql.append("AND FIsTransUp = 0 ");
        sql.append("AND FIsReced = 0 ");
        return sql.toString();
    }

    @Override
    protected List _getCurrencyData(Context ctx, String companyIds) throws BOSException, EASBizException {
        ArrayList currencyData = new ArrayList();
        StringBuffer sqlBuffer = new StringBuffer();
        String[] ids = companyIds.split(",");
        sqlBuffer.append("select distinct(fcurrencyid) as currency from t_cas_receivingbill where FCompanyID in (");
        for (int i = 0; i < ids.length; ++i) {
            if (i == ids.length - 1) {
                sqlBuffer.append("'" + ids[i] + "')");
                continue;
            }
            sqlBuffer.append("'" + ids[i] + "',");
        }
        sqlBuffer.append("and fbillStatus = 14");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        try {
            while (rowSet.next()) {
                CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("currency")));
                HashMap<String, String> currency = new HashMap<String, String>();
                if (currencyInfo != null) {
                    currency.put("alias", currencyInfo.getName());
                    currency.put("value", currencyInfo.getId().toString());
                }
                currencyData.add(currency);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (currencyData.size() == 0) {
            CurrencyInfo currency = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getBaseCurrency();
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()));
            currency.put("alias", (Object)currency.getName());
            currency.put("value", (Object)currency.getId().toString());
        }
        return currencyData;
    }

    @Override
    protected int _getBillCountByStatus(Context ctx, String companyIds, java.sql.Date date, int status) throws BOSException, EASBizException {
        String sql = null;
        String[] ids = companyIds.split(",");
        sql = this.getBillCountByStatusSql(ids, date, status);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int rowCount = 0;
        try {
            if (rowSet.next()) {
                rowCount = rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }

    private String getBillCountByStatusSql(String[] companyIds, java.sql.Date date, int status) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(FID) as count from T_CAS_ReceivingBill WHERE ");
        sql.append("FCompanyID in ( ");
        for (int i = 0; i < companyIds.length; ++i) {
            if (i == companyIds.length - 1) {
                sql.append("'" + companyIds[i] + "' ) ");
                continue;
            }
            sql.append("'" + companyIds[i] + "', ");
        }
        java.sql.Date endDate = new java.sql.Date(date.getTime() + 86400000L);
        sql.append("AND FBizDate>={d'" + date + "'} AND FBizDate<{d'" + endDate + "'} ");
        sql.append(" And FisRefundmentPay = 0 AND FBillStatus = " + status);
        return sql.toString();
    }

    @Override
    protected void _ignore(Context ctx, String ids) throws BOSException, EASBizException {
        String[] billIds = ids.split(",");
        StringBuffer sql = new StringBuffer("Update T_CAS_ReceivingBill set FBankCheckStatus = 2 where FId in ( ");
        for (int i = 0; i < billIds.length; ++i) {
            if (i == billIds.length - 1) {
                sql.append("'" + billIds[i] + "' ) ");
                continue;
            }
            sql.append("'" + billIds[i] + "', ");
        }
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _verifyRecBillAndTransDetail(Context ctx, int dateInterval) throws BOSException, EASBizException {
        this.matchRecBillAndDetail(ctx, dateInterval);
        this.confirmBook(ctx);
    }

    protected void matchRecBillAndDetail(Context ctx, int dateInterval) throws BOSException, EASBizException {
        HashMap<String, String> idMap = new HashMap<String, String>();
        LinkedList<String> recIdList = new LinkedList<String>();
        LinkedList<String> detailIdList = new LinkedList<String>();
        LinkedList<String> numberList = new LinkedList<String>();
        ITransDetail iTrans = TransDetailFactory.getLocalInstance((Context)ctx);
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        String bosType = iReceivingBill.getType().toString();
        java.sql.Date beginDate = new java.sql.Date(DateHelper.getNextDay((Date)new Date(), (int)(dateInterval * -1)).getTime());
        String sql = "update T_CAS_ReceivingBill set FBankCheckStatus = 1 where FBankCheckStatus is null; ";
        DbUtil.execute((Context)ctx, (String)sql);
        sql = "Select Fid as id , FNumber as number ,FActRecAmt as amount ,FPayeeAccountBankID as payeeAccountBank ,FPayerAccountBank as payerAccountBank ,FPayerName as payerName from T_CAS_ReceivingBill where FBankCheckStatus != 0 and FBizDate >= {d'" + beginDate + "'} ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                sql = "Select FID as id from T_BE_TransDetail where FIsReced != 1 and FCreditAmount = ? and FBankAccountID = ? and FBizTime >= {d'" + beginDate + "'} and (FrecedBillType != ? or FrecedBillType is null)";
                IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rs.getBigDecimal("amount"), rs.getString("payeeAccountBank"), bosType});
                if (rs1.size() > 1) {
                    sql = "Select FID as id from T_BE_TransDetail where FIsReced != 1 and FCreditAmount = ? and FBankAccountID = ? and FOppUnit = ? and FOppBankNumber = ? and FBizTime >= {d'" + beginDate + "'} and (FrecedBillType != ? or FrecedBillType is null)";
                    IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rs.getBigDecimal("amount"), rs.getString("payeeAccountBank"), rs.getString("payerAccountBank"), rs.getString("payerName"), bosType});
                    if (rs2.size() > 0) {
                        if (!rs2.next() || idMap.containsKey(rs2.getString("id"))) continue;
                        idMap.put(rs2.getString("id"), rs.getString("id"));
                        recIdList.add(rs.getString("id"));
                        detailIdList.add(rs2.getString("id"));
                        numberList.add(rs.getString("number"));
                        continue;
                    }
                    if (!rs1.next() || idMap.containsKey(rs1.getString("id"))) continue;
                    idMap.put(rs1.getString("id"), rs.getString("id"));
                    recIdList.add(rs.getString("id"));
                    detailIdList.add(rs1.getString("id"));
                    numberList.add(rs.getString("number"));
                    continue;
                }
                if (rs1.size() != 1 || !rs1.next() || idMap.containsKey(rs1.getString("id"))) continue;
                idMap.put(rs1.getString("id"), rs.getString("id"));
                recIdList.add(rs.getString("id"));
                detailIdList.add(rs1.getString("id"));
                numberList.add(rs.getString("number"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql = "update T_CAS_ReceivingBill set FBankCheckStatus = 0, FSourceBillID = ? where Fid = ? ";
        for (String detailId : idMap.keySet()) {
            String recId = (String)idMap.get(detailId);
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{detailId, recId});
        }
        HashMap valueMap = new HashMap();
        int size = detailIdList.size();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("isReced", Boolean.TRUE);
            value.put("recedBillType", bosType);
            value.put("recedBillNumber", ((String)numberList.get(i)).toString());
            valueMap.put(((String)detailIdList.get(i)).toString(), value);
        }
        iTrans.disposeRecInfo(detailIdList, valueMap);
        BOTPUtil.saveBOTRelation((Context)ctx, idMap);
    }

    protected void confirmBook(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bookArea", (Object)"1"));
        filter.getFilterItems().add(new FilterItemInfo("bookArea", (Object)"2"));
        filter.setMaskString("(#0 or #1)");
        CoreBaseCollection colls = RecBookOptionFactory.getLocalInstance(ctx).getCollection(view);
        for (int index = 0; index < colls.size(); ++index) {
            RecBookOptionInfo info = (RecBookOptionInfo)colls.get(index);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            evi.setFilter(fi);
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("isRefundmentPay", (Object)false));
            fi.getFilterItems().add(new FilterItemInfo("bankCheckStatus", (Object)new Integer(0)));
            fi.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(11)));
            if ("2".equals((Object)info.getBookArea())) {
                fi.getFilterItems().add(new FilterItemInfo("billStatus", (Object)new Integer(12)));
                fi.setMaskString("(#0 and #1 and #2 and (#3 or #4))");
            }
            ReceivingBillCollection coll = ReceivingBillFactory.getLocalInstance(ctx).getReceivingBillCollection(evi);
            HashSet<String> idAuditSet = new HashSet<String>();
            HashSet<String> idRecSet = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                ReceivingBillInfo rec = coll.get(i);
                if (rec.getBillStatus().getValue() == 11) {
                    idAuditSet.add(rec.getId().toString());
                }
                idRecSet.add(rec.getId().toString());
            }
            try {
                if (idAuditSet.size() > 0) {
                    ReceivingBillFactory.getLocalInstance(ctx).audit(idAuditSet);
                }
                if (idRecSet.size() <= 0) continue;
                ReceivingBillFactory.getLocalInstance(ctx).rec(idRecSet);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.info((Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _runAutoGenerateReceivingBillFunc(Context ctx) throws BOSException, EASBizException {
        AutoGenerateRecRuleCollection autoGenerateRecRuleCollection = this.getAutoGenerateRecRuleCollection(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < autoGenerateRecRuleCollection.size(); ++i) {
            AutoGenerateRecRuleInfo rule = autoGenerateRecRuleCollection.get(i);
            String companyId = rule.getCompany().getId().toString();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            iMutex.requestObjIDForUpdate(rule.getId().toString());
            TransDetailCollection transColl = this.getTransDetailCollection(ctx, companyInfo, periodInfo);
            StringBuffer oql = new StringBuffer("select id, company.id, account.id, bank.id, bankAccountNumber where id in (select bd.fid from t_bd_accountbanks bd left outer join T_BD_AcctBankTrusterEntries AS en on en.FAcctBankID=bd.fid where bd.fcompanyid = '" + companyId + "' or en.ftrustCompanyID = '" + companyId + "')");
            AccountBankCollection accountBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(oql.toString());
            HashMap<String, AccountBankInfo> bankAccountNumberMap = new HashMap<String, AccountBankInfo>();
            for (int j = 0; j < accountBankColl.size(); ++j) {
                AccountBankInfo accountBank = accountBankColl.get(j);
                bankAccountNumberMap.put(accountBank.getBankAccountNumber(), accountBank);
            }
            try {
                String receiveMessager = rule.getMsgReceiverId();
                ReceivingBillCollection coll = null;
                boolean hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(receiveMessager), (IObjectPK)new ObjectUuidPK(companyId), RECEIVINGBILLADDNEWPERM);
                if (hasFunctionPermission) {
                    coll = this.trans2ReceivingColl(ctx, transColl, bankAccountNumberMap);
                }
                this.sendMessage(ctx, coll, companyInfo, receiveMessager);
                continue;
            }
            finally {
                iMutex.releaseObjIDForUpdate(rule.getId().toString());
            }
        }
    }

    private void sendMessage(Context ctx, ReceivingBillCollection coll, CompanyOrgUnitInfo companyInfo, String ReceiveMessager) {
        int receivingBillNum = coll.size();
        StringBuffer receivingBillstr = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            if (i == coll.size() - 1) {
                receivingBillstr.append(coll.get(i).getNumber());
                continue;
            }
            receivingBillstr.append(coll.get(i).getNumber()).append(",");
        }
        String companyName = companyInfo.getName();
        String bizDate = DateUtil.getSQLBegin((Date)new Date()).toString();
        String year = bizDate.substring(0, 4);
        String month = bizDate.substring(5, 7);
        String day = bizDate.substring(8, 10);
        String hour = String.valueOf(Calendar.getInstance().get(11));
        String msgTitle = CASWebUtil.getResource(ctx, "533_GENERATERECEIVINGBILLMESSAGETITLE", new String[]{year, month, day, hour, companyName});
        StringBuffer msgBody = new StringBuffer();
        if (receivingBillstr.length() > 0) {
            msgBody.append(CASWebUtil.getResource(ctx, "532_GENERATERECEIVINGBILLMESSAGEBODY", new String[]{companyName, "" + receivingBillNum, receivingBillstr.toString()}) + "\n");
        } else {
            msgBody.append(CASWebUtil.getResource(ctx, "534_GENERATERECEIVINGBILLMESSAGEBODY1", new String[]{companyName}) + "\n");
        }
        ReceivingCenterFacadeControllerBean.sendByMessage(ctx, msgTitle, "administrator", msgBody.toString(), ReceiveMessager);
    }

    private ReceivingBillCollection trans2ReceivingColl(Context ctx, TransDetailCollection transColl, Map<String, AccountBankInfo> bankAccountNumberMap) throws BOSException, EASBizException {
        ReceivingBillCollection coll = new ReceivingBillCollection();
        ReceivingBillInfo info = null;
        TransDetailInfo transInfo = null;
        int size = transColl.size();
        for (int i = 0; i < size; ++i) {
            transInfo = transColl.get(i);
            info = new ReceivingBillInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            String bankAcctNum = transInfo.getBankAccount().getBankAccountNumber();
            AccountBankInfo accountBank = bankAccountNumberMap.get(bankAcctNum);
            CompanyOrgUnitInfo company = accountBank.getCompany();
            info.setCompany(company);
            info.setFundType(BizTypeEnum.BANK);
            info.setCurrency(transInfo.getCurrency());
            info.setPayeeAccountBank(accountBank);
            info.setPayeeBank(accountBank.getBank());
            info.setPayeeAccount(accountBank.getAccount());
            info.setBizDate(transInfo.getBizTime());
            info.setDescription(transInfo.getDescription());
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("bank"));
            sic.add(new SelectorItemInfo("bankAccount"));
            sic.add(new SelectorItemInfo("customerCompanyInfo.customer.id"));
            sic.add(new SelectorItemInfo("customerCompanyInfo.customer.number"));
            sic.add(new SelectorItemInfo("customerCompanyInfo.customer.name"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)transInfo.getOppBankNumber(), CompareType.EQUALS));
            view.setFilter(filter);
            CustomerCompanyBankCollection customerCompanyBankColl = CustomerCompanyBankFactory.getLocalInstance((Context)ctx).getCustomerCompanyBankCollection(view);
            if (customerCompanyBankColl.size() > 0) {
                CustomerCompanyBankInfo customerCompanyBankInfo = customerCompanyBankColl.get(0);
                this.setAsSaleBill(ctx, info, customerCompanyBankInfo.getCustomerCompanyInfo().getCustomer().getId().toString(), customerCompanyBankInfo.getCustomerCompanyInfo().getCustomer().getNumber(), customerCompanyBankInfo.getCustomerCompanyInfo().getCustomer().getName());
                info.setPayerBank(customerCompanyBankInfo.getBank());
            } else {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                view.setSelector(sic);
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("name", (Object)transInfo.getOppUnit(), CompareType.EQUALS));
                view.setFilter(filter);
                CustomerCollection customerColl = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
                if (customerColl.size() > 0) {
                    CustomerInfo customer = customerColl.get(0);
                    this.setAsSaleBill(ctx, info, customer.getId().toString(), customer.getNumber(), customer.getName());
                } else {
                    info.setRecBillType(this.getDefaultBillType(ctx));
                    info.setPayerName(transInfo.getOppUnit());
                    info.setPayerBank(transInfo.getOppBank());
                }
            }
            info.setPayerAccountBank(transInfo.getOppBankNumber());
            info.setIsInitializeBill(false);
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setSettlementNumber(transInfo.getNumber());
            info.setSourceType(SourceTypeEnum.BE);
            ReceivingBillEntryInfo newEntryInfo = new ReceivingBillEntryInfo();
            newEntryInfo.setSeq(i + 1);
            newEntryInfo.setCurrency(transInfo.getCurrency());
            BigDecimal amount = transInfo.getCreditAmount();
            BigDecimal locAmount = null;
            Date date = new Date();
            BigDecimal rate = null;
            ExchangeRateInfo exRateInfo = FMHelper.getExRateInfo((Context)ctx, (CurrencyInfo)transInfo.getCurrency(), null, null, (Date)date);
            if (exRateInfo != null) {
                rate = exRateInfo.getConvertRate();
                locAmount = amount.multiply(rate);
            } else {
                rate = Constants.ONE;
                locAmount = amount.multiply(rate);
            }
            newEntryInfo.setActualLocAmt(locAmount);
            newEntryInfo.setActualAmt(amount);
            info.getEntries().add(newEntryInfo);
            info.setExchangeRate(rate);
            info.setHasEffected(false);
            info.setSourceBillId(transInfo.getId().toString());
            info.setActRecAmt(amount);
            info.setActRecLocAmt(locAmount);
            if (null != transInfo.getBankCheckFlag() && transInfo.getBankCheckFlag().length() > 0) {
                info.setBankCheckFlag(transInfo.getBankCheckFlag());
            }
            coll.add(info);
        }
        return coll;
    }

    private void setAsSaleBill(Context ctx, ReceivingBillInfo info, String payerId, String payerNumber, String payerName) throws BOSException {
        info.setRecBillType(this.getSaleBillType(ctx));
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("AsstHGAttribute", (Object)"customer", CompareType.EQUALS));
        view.setFilter(filter);
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(view);
        info.setPayerType(asstActTypeCollection.get(0));
        info.setPayerID(payerId);
        info.setPayerNumber(payerNumber);
        info.setPayerName(payerName);
    }

    protected ReceivingBillTypeInfo getSaleBillType(Context ctx) throws BOSException {
        ReceivingBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"100", CompareType.EQUALS));
        ReceivingBillTypeCollection coll = ReceivingBillTypeFactory.getLocalInstance(ctx).getReceivingBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }

    protected ReceivingBillTypeInfo getDefaultBillType(Context ctx) throws BOSException {
        ReceivingBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
        ReceivingBillTypeCollection coll = ReceivingBillTypeFactory.getLocalInstance(ctx).getReceivingBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }

    private TransDetailCollection getTransDetailCollection(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String companyID = companyInfo.getId().toString();
        sql.append("bankAccount.id IN ( select bd.Fid from t_bd_accountbanks bd left outer join T_BD_AcctBankTrusterEntries AS en on en.FAcctBankID=bd.fid where bd.fcompanyid = '" + companyID + "' or en.ftrustCompanyID = '" + companyID + "') ");
        java.sql.Date beginDate = new java.sql.Date(periodInfo.getBeginDate().getTime());
        java.sql.Date endDate = new java.sql.Date(periodInfo.getEndDate().getTime() + 86400000L);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(sql.toString()));
        filter.getFilterItems().add(new FilterItemInfo("bizDate >= {d'" + beginDate + "'}"));
        filter.getFilterItems().add(new FilterItemInfo("bizDate < {d'" + endDate + "'}"));
        filter.getFilterItems().add(new FilterItemInfo("creditAmount", (Object)new Double(0.0), CompareType.GREATER));
        filter.getFilterItems().add(new FilterItemInfo("isTransUp", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)0, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        ITransDetail iTrans = TransDetailFactory.getLocalInstance((Context)ctx);
        TransDetailCollection transColl = iTrans.getTransDetailCollection(evi);
        return transColl;
    }

    private AutoGenerateRecRuleCollection getAutoGenerateRecRuleCollection(Context ctx) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        java.sql.Date now = new java.sql.Date(new Date().getTime());
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)EnableStatusEnum.enable, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startDate <= {d'" + now + "'}"));
        filter.getFilterItems().add(new FilterItemInfo("endDate >= {d'" + now + "'}"));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        ev.setSelector(sic);
        AutoGenerateRecRuleCollection autoGenerateRecRuleCollection = AutoGenerateRecRuleFactory.getLocalInstance(ctx).getAutoGenerateRecRuleCollection(ev);
        return autoGenerateRecRuleCollection;
    }

    private static void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, String msgReceiver) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = ReceivingCenterFacadeControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", msgTitle, locale2);
            message.setLocaleStringHeader("sender", msgSender, locale2);
            message.setLocaleStringHeader("body", msgBody, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", msgReceiver);
        senderAgent.sendMessage(message);
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }
}

