/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.function.WfEventListenerStateManager;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.base.wssc.IBillImageFacade;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankException;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankGroupInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountMgrStrategyInfo;
import com.kingdee.eas.basedata.assistant.AccountType;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.OverdraftCtrlEnum;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.cas.AssItemsForCashRecCollection;
import com.kingdee.eas.fi.cas.AssItemsForCashRecFactory;
import com.kingdee.eas.fi.cas.AssItemsForCashRecInfo;
import com.kingdee.eas.fi.cas.AssItemsForTmplRecInfo;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.CasRecPayBillTypeEnum;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.DeepClone;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.ITemplateReceivingBill;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayAcctBankStratageCtrl;
import com.kingdee.eas.fi.cas.RecPayException;
import com.kingdee.eas.fi.cas.RecPayHelper;
import com.kingdee.eas.fi.cas.ReceivingBillCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.cas.SettlementStatusEnum;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.TemplateReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.TemplateReceivingBillFactory;
import com.kingdee.eas.fi.cas.TemplateReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.AbstractReceivingbillWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.PaymentBillWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.SystemStatusCtrolUtils;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PerfLogRecorder;
import com.kingdee.eas.fi.cas.utils.PeriodHelper;
import com.kingdee.eas.fm.be.BEException;
import com.kingdee.eas.fm.be.TransDetailCollection;
import com.kingdee.eas.fm.be.TransDetailFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.fpl.FPCtrlBillTypeEnum;
import com.kingdee.eas.fm.fpl.FPCtrlParamCollection;
import com.kingdee.eas.fm.fpl.FpCtrlFacadeFactory;
import com.kingdee.eas.fm.fpl.FpCtrlHelper;
import com.kingdee.eas.fm.fpl.ReceivingBillFPLCtrlHandler;
import com.kingdee.eas.fm.fs.SettBizTypeEnum;
import com.kingdee.eas.fm.fs.SettBizTypeFactory;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionUtil;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReceivingbillWebFacadeControllerBean
extends AbstractReceivingbillWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.ReceivingbillWebFacadeControllerBean");
    private static final String OPERATESTATE = "operateState";

    @Override
    protected Map _save(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getRecBillType()) && !EmptyUtil.isEmpty((Object)info.getRecBillType().getSourceSysType())) {
            info.setSourceType(info.getRecBillType().getSourceSysType());
        }
        this.checkPayerTypeForSysApAr(info);
        try {
            this.fillPayerAccountBank(ctx, info);
            if (info.getPayerAccountBankO() != null) {
                info.setOppInnerAcct(info.getPayerAccountBankO().getInnerAcct());
            } else {
                info.setOppInnerAcct(null);
            }
            this.transAsstAccount(ctx, info);
            IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("billStatus");
            if (iReceivingBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString()))) {
                ReceivingBillInfo oldInfo = (ReceivingBillInfo)iReceivingBill.getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
                if (this.isStatusChanged(ctx, info)) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "BILL_STATUS_CHANGED"));
                }
                boolean isBillInShareFlow = false;
                if (null != info && null != info.getId() && null != info.getBillStatus()) {
                    String billID = info.getId().toString();
                    isBillInShareFlow = CasForArApUtil.isBillInShareFlow(ctx, isBillInShareFlow, billID, info.getBillStatus().getValue(), 11);
                    logger.error((Object)("\u4fdd\u5b58\u5355\u636eID\u4e3a\uff1a" + billID + "\u5355\u636e\u662f\u5426\u5728\u5171\u4eab\u4e2d\uff1a" + isBillInShareFlow));
                    if (!isBillInShareFlow && oldInfo.getBillStatus().getValue() != 10) {
                        throw new RuntimeException(CASWebUtil.getResource(ctx, "BILL_STATUS_NOT_SAVE"));
                    }
                }
            }
            IObjectPK pk = this.getSavePk(ctx, iReceivingBill, info);
            pageModel.put("error", 0);
            pageModel.put("id", pk.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        return pageModel;
    }

    private void checkPayerTypeForSysApAr(ReceivingBillInfo info) throws CasWebException {
        if (info.getRecBillType() != null && (info.getRecBillType().getSourceSysType().equals((Object)SourceTypeEnum.AP) || info.getRecBillType().getSourceSysType().equals((Object)SourceTypeEnum.AR)) && info.getPayerType() == null) {
            throw new CasWebException(CasWebException.AR_AP_PAYERTYPE_NOT_OTHER);
        }
    }

    private IObjectPK getSavePk(Context ctx, IReceivingBill iReceivingBill, ReceivingBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = CASWebHelper.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null && (btpRelationCollection == null || btpRelationCollection.size() == 0)) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
        }
        objectPK = btpRelationCollection != null && btpRelationCollection.size() > 0 ? iBTPManager.saveRelations((CoreBillBaseInfo)info, btpRelationCollection) : iReceivingBill.save((CoreBaseInfo)info);
        return objectPK;
    }

    private IObjectPK getSubmitPk(Context ctx, IReceivingBill iReceivingBill, ReceivingBillInfo info) throws Exception {
        IObjectPK objectPK = null;
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BOTRelationCollection btpRelationCollection = CASWebHelper.getBOTRelationColFromExtendProperty(ctx, (IObjectValue)info);
        if (info.get("id") != null && (btpRelationCollection == null || btpRelationCollection.size() == 0)) {
            btpRelationCollection = iBTPManager.getRelationCollection(info.get("id").toString());
        }
        boolean enbale = false;
        if (btpRelationCollection != null && btpRelationCollection.size() > 0) {
            if (null != info && null != info.getId() && null != info.getBillStatus() && CasForArApUtil.isBillInShareFlow(ctx, false, info.getId().toString(), info.getBillStatus().getValue(), 11)) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u5173\u95ed\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().disableEventListener();
                enbale = true;
            }
            objectPK = iBTPManager.submitRelations((CoreBillBaseInfo)info, btpRelationCollection);
            if (enbale) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u6253\u5f00\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        } else {
            if (null != info && null != info.getId() && null != info.getBillStatus() && CasForArApUtil.isBillInShareFlow(ctx, false, info.getId().toString(), info.getBillStatus().getValue(), 11)) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u5173\u95ed\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().disableEventListener();
                enbale = true;
            }
            objectPK = iReceivingBill.submit((CoreBaseInfo)info);
            if (enbale) {
                logger.error((Object)("\u5355\u636eID\u4e3a\uff1a" + info.getId().toString() + "\u4e14\u5355\u636e\u5904\u4e8e\u5171\u4eab\u5de5\u4f5c\u6d41\u4e2d\uff0c\u6253\u5f00\u5de5\u4f5c\u6d41\u6821\u9a8c"));
                WfEventListenerStateManager.getInstance().enableEventListener();
            }
        }
        return objectPK;
    }

    private void fillPayerAccountBank(Context ctx, ReceivingBillInfo info) throws BOSException {
        String accountBankNumber = info.getPayerAccountBank();
        if (accountBankNumber == null || accountBankNumber.equals("")) {
            info.setPayerAccountBankO(null);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isByCurrency"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("accountType"));
            sic.add(new SelectorItemInfo("bank.name"));
            sic.add(new SelectorItemInfo("innerAcct.id"));
            sic.add(new SelectorItemInfo("bank.id"));
            view.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)accountBankNumber, CompareType.EQUALS));
            view.setFilter(filter);
            AccountBankCollection accountBankColl = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(view);
            if (accountBankColl.size() > 0) {
                info.setPayerAccountBankO(accountBankColl.get(0));
            }
        }
    }

    @Override
    protected Map _beforeSubmit(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        return this.submitWithOption(ctx, info, false);
    }

    private Map getSysParam(Context ctx, CompanyOrgUnitInfo company, String operateState) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean.getSysParam");
        String companyId = company.getId().toString();
        Map paramValue = CASWebHelper.getParamMap(ctx, companyId, "CS032", "CS040", "CS063", "CS082", "CS033", "CS037", "CS052");
        if (paramValue.get("CS052") != null) {
            int val = Integer.parseInt((String)paramValue.get("CS052"));
            paramValue.put("isSubmitCtrlOverDraft", val == 1);
        } else {
            paramValue.put("isSubmitCtrlOverDraft", false);
        }
        AsstActTypeCollection asstActTypeColl = this.getAsstActTypeColl(ctx, companyId, false);
        paramValue.put("asstActTypeCollection", asstActTypeColl);
        paramValue.put("defaultBillType", this.getDefaultBillType(ctx));
        if (asstActTypeColl.size() == 0) {
            paramValue.put("defaultAsstActType", null);
        } else {
            paramValue.put("defaultAsstActType", asstActTypeColl.get(0));
        }
        PerfLogRecorder.endRecord(pfLogId);
        return paramValue;
    }

    protected ReceivingBillTypeInfo getDefaultBillType(Context ctx) throws BOSException {
        ReceivingBillTypeInfo defaultBillTypeInfo = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
        ReceivingBillTypeCollection coll = ReceivingBillTypeFactory.getLocalInstance(ctx).getReceivingBillTypeCollection(ev);
        if (coll != null && !coll.isEmpty()) {
            defaultBillTypeInfo = coll.get(0);
        }
        return defaultBillTypeInfo;
    }

    public String fplCtrlWarnInfo(Context ctx, ReceivingBillInfo info) throws EASBizException, BOSException {
        String companyId = info.getCompany().getId().toString();
        boolean hasStrategy = FpCtrlHelper.hasExecutingStrategy((Context)ctx, (String)companyId, (FPCtrlBillTypeEnum)FPCtrlBillTypeEnum.RECEIVINGBILL);
        if (!hasStrategy) {
            return null;
        }
        ReceivingBillFPLCtrlHandler handler = new ReceivingBillFPLCtrlHandler();
        FPCtrlParamCollection params = handler.bulidParams(ctx, info);
        return FpCtrlFacadeFactory.getLocalInstance((Context)ctx).getWarnMsg(params);
    }

    private boolean isStatusChanged(Context ctx, ReceivingBillInfo info) throws Exception {
        IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        boolean changed = false;
        ReceivingBillInfo receivingBillInfo = null;
        ReceivingBillCollection coll = null;
        EntityViewInfo query = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        query.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("billStatus");
        sic.add("settlementStatus");
        sic.add("fiVouchered");
        query.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString()));
        coll = iReceivingBill.getReceivingBillCollection(query);
        if (coll.size() > 0) {
            receivingBillInfo = coll.get(0);
            if (info.getBillStatus() != receivingBillInfo.getBillStatus()) {
                changed = true;
            }
            if (info.getSettlementStatus() != receivingBillInfo.getSettlementStatus()) {
                changed = true;
            }
            if (info.isFiVouchered() != receivingBillInfo.isFiVouchered()) {
                changed = true;
            }
        }
        return changed;
    }

    @Override
    protected void _verifyBeforeSubmit(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean.verifyBeforeSubmit");
        try {
            boolean val;
            AccountViewInfo acctView;
            boolean feeTypeAndProjectAllRequrie;
            this.fillPayerAccountBank(ctx, info);
            Map param = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS032", "CS033", "CS044", "CS014", "CS073");
            if (info.getPayeeAccount() == null && !info.isIsInitializeBill()) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "PAYEEACCOUNT_EMPTY_BATCH"));
            }
            if (EmptyUtil.isEmpty((String)info.getSourceBillId()) && info.getPayeeAccountBank() != null) {
                BankInfo payeeBank;
                AccountBankInfo payeeAcctBank = info.getPayeeAccountBank();
                payeeAcctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payeeAcctBank.getId().toString()));
                int sourceType = info.getSourceType().getValue();
                if (info.getPayeeBank() != null && (payeeBank = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeBank().getId().toString()))).isInGroup() && info.getBizType() == null) {
                    throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
                }
                if (payeeAcctBank.getInnerAcct() != null && info.getBizType() != null) {
                    SettBizTypeInfo bizTypeInfo = info.getBizType();
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("type"));
                    sic.add(new SelectorItemInfo("notSubmitHouse"));
                    bizTypeInfo = SettBizTypeFactory.getLocalInstance((Context)ctx).getSettBizTypeInfo((IObjectPK)new ObjectUuidPK(bizTypeInfo.getId().toString()), sic);
                    info.setBizType(bizTypeInfo);
                    if (!bizTypeInfo.isNotSubmitHouse()) {
                        if (bizTypeInfo == null) {
                            throw new RecPayException(RecPayException.RECBIZTYPEISNULL);
                        }
                        if (info.getDescription() == null || info.getDescription().length() == 0) {
                            throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEDESCRIPTIONREC);
                        }
                        boolean isOutBank = true;
                        if (payeeAcctBank != null) {
                            BankInfo bankInfo = payeeAcctBank.getBank();
                            sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("inGroup"));
                            bankInfo = BankFactory.getLocalInstance((Context)ctx).getBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getId().toString()), sic);
                            if (bankInfo.isInGroup()) {
                                isOutBank = false;
                            }
                        }
                        if (!(FMHelper.isEmpty((String)info.getPayerBank()) || FMHelper.isEmpty((CoreBaseInfo)info.getPayeeBank()) || isOutBank)) {
                            if (info.getPayeeBank().getName(ctx.getLocale()).equals(info.getPayerBank())) {
                                if (bizTypeInfo != null && !SettBizTypeEnum.RECINSIDE.equals((Object)bizTypeInfo.getType())) {
                                    throw new RuntimeException(CASWebUtil.getResource(ctx, "mustRecinSide"));
                                }
                            } else if (bizTypeInfo != null && !SettBizTypeEnum.RECOUTSIDE.equals((Object)bizTypeInfo.getType()) && !SettBizTypeEnum.RECINSIDEDIF.equals((Object)bizTypeInfo.getType())) {
                                throw new RuntimeException(CASWebUtil.getResource(ctx, "483_mustRecinSideDif"));
                            }
                        }
                        if (!(bizTypeInfo.getType() != SettBizTypeEnum.RECINSIDE || info.getPayerAccountBankO() != null && info.getPayerAccountBankO().getInnerAcct() != null && info.getPayerAccountBankO().getBank().getId().equals((Object)payeeAcctBank.getBank().getId()))) {
                            throw new RecPayException(RecPayException.PAYERACCOUNTRECINSIDEMUSTHAVEINNERACCOUNT190);
                        }
                        if (bizTypeInfo.getType() == SettBizTypeEnum.RECINSIDEDIF && (info.getPayerAccountBankO() == null || info.getPayerAccountBankO().getInnerAcct() == null || info.getPayerAccountBankO().getBank().getId().equals((Object)payeeAcctBank.getBank().getId()))) {
                            throw new RecPayException(RecPayException.PAYERACCOUNTRECINSIDEDIFMUSTHAVEINNERACCOUNT191);
                        }
                        if (EmptyUtil.isEmpty((String)info.getPayerName())) {
                            throw new RecPayException(RecPayException.FORSETTLEMUSTHAVEPAYEENAME194);
                        }
                    }
                }
            }
            if (((Boolean)param.get("CS032")).booleanValue() && !SourceTypeEnum.AR.equals((Object)info.getSourceType()) && info.getFeeType() == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "RECBILLTYPE_REQUIRED"));
            }
            if (((Boolean)param.get("CS033")).booleanValue() && info.getProject() == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "PROJECT_REQUIRED"));
            }
            if (info.getRealRecCompany() != null && info.getRealRecCompany().getId().equals((Object)info.getCompany().getId())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "636_COMPANY_AND_REALRECCOMPANY_CANNOT_SAME"));
            }
            if (SourceTypeEnum.AR.equals((Object)info.getSourceType())) {
                PeriodInfo periodInfo = SystemStatusCtrolUtils.getStartPeriod(ctx, SystemEnum.ACCOUNTSRECEIVABLE, info.getCompany());
                if (periodInfo == null) {
                    throw new RecPayException(RecPayException.AR_ISNOT_START);
                }
                if (periodInfo.getBeginDate() != null && !info.isIsInitializeBill()) {
                    if (info.getCreateTime() == null) {
                        info.setCreateTime(new Timestamp(System.currentTimeMillis()));
                    }
                    if (info.getBizDate() != null && info.getBizDate().compareTo(periodInfo.getBeginDate()) < 0) {
                        throw new RecPayException(RecPayException.BILLDATEMUSTGREATTHANBEGINDATE);
                    }
                }
                if (periodInfo.getBeginDate() != null && info.isIsInitializeBill() && info.getBizDate().compareTo(periodInfo.getBeginDate()) >= 0) {
                    String str = EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"DateAfterStartDate", (Locale)ctx.getLocale());
                    throw new RecPayException(new NumericExceptionSubItem("DateAfterStartDate", str));
                }
            }
            if ((feeTypeAndProjectAllRequrie = ((Boolean)param.get("CS044")).booleanValue()) && (info.getFeeType() != null && info.getProject() == null || info.getFeeType() == null && info.getProject() != null)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "feeTypeAndProjectAllRequrie"));
            }
            ReceivingBillTypeInfo receiveType = ReceivingBillTypeFactory.getLocalInstance(ctx).getReceivingBillTypeInfo("select sourceSysType where id = '" + info.getRecBillType().getId() + "'");
            if (receiveType != null && (receiveType.getSourceSysType().equals((Object)SourceTypeEnum.AP) || receiveType.getSourceSysType().equals((Object)SourceTypeEnum.AR))) {
                AsstActTypeInfo payeeType = info.getPayerType();
                if (payeeType != null && payeeType.equals((Object)FMSysDefinedEnum.OTHER)) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"ArApPayerTypeNotOther");
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "ArApPayerTypeNotOther"));
                }
                if (info.getPayerName() == null || info.getPayerName().equals("")) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "PAYER_CANNOT_BENULL"));
                }
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isByCurrency"));
            sic.add(new SelectorItemInfo("currency.id"));
            sic.add(new SelectorItemInfo("account.id"));
            sic.add(new SelectorItemInfo("accountType"));
            if (info.getPayeeAccount() != null && (acctView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)new ObjectUuidPK(info.getPayeeAccount().getId().toString()))).isIsBank() && info.getPayeeAccountBank() == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "PAYEEACCOUNTBANK_CANNOT_BENULL"));
            }
            AccountBankInfo payeeAcctBank = null;
            if (info.getPayeeAccountBank() != null) {
                payeeAcctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayeeAccountBank().getId().toString()), sic);
            }
            if (!(payeeAcctBank == null || receiveType != null && receiveType.getId().toString().equals("fjJCrQESEADgABolwKgSQyqo2zU=") || payeeAcctBank.getAccountType() != AccountType.PAYOUT)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "ACCOUNTBANK_CANNOT_BEOUT"));
            }
            if (info.getSettlementType() != null && info.getPayeeAccount() == null && info.getPayeeAccountBank() == null) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "PAYEEACCOUNT_AND_PAYEEACCTBANK_CANNOT_BENULL"));
            }
            boolean isOppAccountBank = false;
            HashSet<String> oppAccountIdSet = new HashSet<String>();
            for (int i = 0; i < info.getEntries().size(); ++i) {
                AccountViewInfo acct = info.getEntries().get(i).getOppAccount();
                if (acct == null) continue;
                oppAccountIdSet.add(acct.getId().toString());
            }
            AccountViewCollection accountViewColl = new AccountViewCollection();
            if (oppAccountIdSet.size() > 0) {
                EntityViewInfo view = new EntityViewInfo();
                view.setTopCount(1);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", oppAccountIdSet, CompareType.INCLUDE));
                filterInfo.getFilterItems().add(new FilterItemInfo("isBank", (Object)true));
                view.setFilter(filterInfo);
                accountViewColl = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewCollection(view);
                boolean bl = isOppAccountBank = accountViewColl.size() > 0;
            }
            if (isOppAccountBank) {
                String bankAccountNumber;
                if (info.getPayerAccountBank() == null || info.getPayerAccountBank().equals("")) {
                    throw new BOSException(CASWebUtil.getResource(ctx, "PAYERACCOUNTBANK_CANNOT_BENULL"));
                }
                String companyNumber = info.getCompany().getId().toString();
                if (!this.getBankAccountNumberBelong(ctx, companyNumber, bankAccountNumber = info.getPayerAccountBank())) {
                    throw new BOSException(CASWebUtil.getResource(ctx, "PAYERACCOUNTBANK_NOT_EXIST"));
                }
                String companyId = info.getCompany().getId().toString();
                for (int i = 0; i < accountViewColl.size(); ++i) {
                    String accountId = accountViewColl.get(i).getId().toString();
                    if (this.getAccountBelong(ctx, companyId, accountId, bankAccountNumber)) continue;
                    throw new BOSException(CASWebUtil.getResource(ctx, "RelAcctViewNotEqualOppAcctView"));
                }
            }
            if (val = ((Boolean)param.get("CS014")).booleanValue()) {
                for (int i = 0; i < info.getEntries().size(); ++i) {
                    ReceivingBillEntryInfo entryInfo = info.getEntries().get(i);
                    if (entryInfo.getOppBgItemId() != null && !entryInfo.getOppBgItemId().equals("")) continue;
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "ENTRYOPPITEM_REQUIRED"));
                }
            }
            ReceivingbillWebFacadeControllerBean.verifyAssItem(ctx, info);
        }
        catch (BOSException e) {
            PerfLogRecorder.endRecord(pfLogId);
            throw e;
        }
        catch (EASBizException e) {
            PerfLogRecorder.endRecord(pfLogId);
            throw e;
        }
        catch (RuntimeException e) {
            PerfLogRecorder.endRecord(pfLogId);
            throw e;
        }
        PerfLogRecorder.endRecord(pfLogId);
    }

    public static void verifyAssItem(Context ctx, ReceivingBillInfo editData) throws BOSException {
        AssItemsForCashRecCollection ac = editData.getAssItems();
        for (int i = 0; i < ac.size(); ++i) {
            AssItemsForCashRecInfo infoAc = ac.get(i);
            if (infoAc.isIsSelected() && EmptyUtil.isEmpty((String)infoAc.getFromNumber())) {
                throw new BOSException(CASWebUtil.getResource(ctx, "OPPITEM_REQUIRED"));
            }
            if (EmptyUtil.isEmpty((String)infoAc.getFromNumber()) || infoAc.isIsSelected()) continue;
            throw new BOSException(CASWebUtil.getResource(ctx, "OPPITEM_SHOULD_BENULL"));
        }
        ReceivingBillEntryCollection entryCol = editData.getEntries();
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            ReceivingBillEntryInfo info = entryCol.get(i);
            AssItemsForCashRecCollection assCol = info.getAssItemsEntries();
            int assColSize = assCol.size();
            for (int j = 0; j < assColSize; ++j) {
                AssItemsForCashRecInfo infoAc = assCol.get(j);
                if (infoAc.isIsSelected() && EmptyUtil.isEmpty((String)infoAc.getFromNumber())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "OPPITEM_REQUIRED"));
                }
                if (EmptyUtil.isEmpty((String)infoAc.getFromNumber()) || infoAc.isIsSelected()) continue;
                throw new RuntimeException(CASWebUtil.getResource(ctx, "OPPITEM_SHOULD_BENULL"));
            }
        }
    }

    private boolean getBankAccountNumberBelong(Context ctx, String companyNumber, String bankAccountNumber) {
        String sql = " SELECT fBankAccountNumber FROM T_BD_AccountBanks where FCompanyID='" + companyNumber + "' and fBankAccountNumber ='" + bankAccountNumber + "'";
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = null;
        boolean result = false;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            SysUtil.abort((Throwable)e);
        }
        return result;
    }

    private boolean getAccountBelong(Context ctx, String companyId, String accountId, String bankacctNumber) {
        String sql = "SELECT ab.fid FROM T_BD_AccountBanks ab ,T_ORG_Company c ,T_BD_AccountView av where ab.FCompanyID = c.FID and c.FID = '" + companyId + "' and ab.FAccountID = av.FID and av.FID='" + accountId + "'and ab.fbankaccountnumber = '" + bankacctNumber + "'";
        ISQLExecutor exec = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = null;
        boolean result = false;
        try {
            rs = exec.executeSQL();
        }
        catch (BOSException e1) {
            SysUtil.abort((Throwable)e1);
        }
        try {
            if (rs != null && rs.next()) {
                result = true;
            }
        }
        catch (SQLException e) {
            SysUtil.abort((Throwable)e);
        }
        return result;
    }

    private String verifyOverDraftForReceivingBill(Context ctx, ReceivingBillInfo bean, AccountMgrStrategyInfo strategy, BigDecimal balance, ReceivingBillInfo editData) throws Exception {
        if (balance == null) {
            return null;
        }
        boolean isCtrlAcctBank = true;
        boolean isRemind = false;
        AccountBankInfo payerAcctBank = editData.getPayerAccountBankO();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("ctrlStrategy.*");
        payerAcctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(payerAcctBank.getId().toString()), sic);
        if (payerAcctBank == null || !payerAcctBank.getCompany().getId().equals((Object)editData.getCompany().getId())) {
            return null;
        }
        boolean isAcctBankNotChanged = bean.getPayerAccountBank() != null && editData.getPayerAccountBankO() != null && bean.getPayerAccountBankO().getId().equals((Object)editData.getPayerAccountBankO().getId());
        boolean isAcctViewNotChanged = bean.getPayerAccountBank() == null && editData.getPayerAccountBank() == null && bean.getOppAccount() != null && editData.getOppAccount() != null && bean.getOppAccount().getId().equals((Object)editData.getOppAccount().getId());
        String companyID = editData.getCompany().getId().toString();
        String acctBankID = payerAcctBank.getId().toString();
        String currencyID = editData.getCurrency().getId().toString();
        Map resultMap = BatchFetchParamFacadeFactory.getLocalInstance(ctx).instanceBalanceResult(companyID, acctBankID, currencyID);
        balance = (BigDecimal)resultMap.get("acctBankBalance");
        AccountBankGroupInfo acctBankGroup = (AccountBankGroupInfo)resultMap.get("acctBankGroup");
        BigDecimal acctBankGroupBalance = (BigDecimal)resultMap.get("acctBankGroupBalance");
        strategy = payerAcctBank.getCtrlStrategy();
        if (strategy == null) {
            isCtrlAcctBank = false;
        }
        if (strategy != null) {
            boolean bl = isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        }
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            balance = balance.add(editData.getActRecAmt());
        }
        BigDecimal amount = balance.subtract(editData.getActRecAmt());
        this.ctrlAcctBank(strategy, isCtrlAcctBank, payerAcctBank, isRemind, amount);
        if (acctBankGroup == null) {
            return null;
        }
        strategy = acctBankGroup.getStrategy();
        boolean bl = isRemind = strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTCONTROL) && strategy.isRemind();
        if (isAcctBankNotChanged || isAcctViewNotChanged) {
            acctBankGroupBalance = acctBankGroupBalance.add(editData.getActRecAmt());
        }
        amount = acctBankGroupBalance.subtract(editData.getActRecAmt());
        ObjectUuidPK companyPK = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(editData.getCurrency().getId());
        ObjectUuidPK acctBankGroupPK = new ObjectUuidPK(acctBankGroup.getId());
        BigDecimal totalbalance = InnerCashFacadeFactory.getRemoteInstance().getAcctGroupInstantBalance((IObjectPK)companyPK, (IObjectPK)acctBankGroupPK, (IObjectPK)currencyPK);
        amount = totalbalance.subtract(editData.getActRecAmt());
        if (amount.compareTo(new BigDecimal("0")) < 0 && isRemind) {
            return CASWebUtil.getResource(ctx, "OVERDRAFT_CONTINUE_LABEL");
        }
        return null;
    }

    private void ctrlAcctBank(AccountMgrStrategyInfo strategy, boolean isCtrlAcctBank, AccountBankInfo payerAcctBank, boolean isRemind, BigDecimal amount) throws AccountBankException {
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.INLIMITCANOVERDRAFT) && amount.compareTo(new BigDecimal("0")) < 0 && amount.negate().compareTo(strategy.getOverDraftAmount()) > 0) {
            throw new AccountBankException(AccountBankException.OVERDRAFT, new Object[]{payerAcctBank.getName(), strategy.getOverDraftAmount(), amount.abs().subtract(strategy.getOverDraftAmount())});
        }
        if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.NOTALLOW)) {
            if (amount.compareTo(new BigDecimal("0")) < 0) {
                throw new AccountBankException(AccountBankException.NOALLOWOVERDRAFT, new Object[]{payerAcctBank.getName(), amount.abs()});
            }
        } else if (strategy.getOverdraftCtrl().equals((Object)OverdraftCtrlEnum.LOWESTDEPOSITGUARANTEE) && amount.compareTo(strategy.getLowestBalance()) < 0) {
            throw new AccountBankException(AccountBankException.OVERLOWAMOUNT, new Object[]{payerAcctBank.getName(), strategy.getLowestBalance(), strategy.getLowestBalance().subtract(amount).abs()});
        }
    }

    @Override
    protected Map _submit(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        return this.submitWithOption(ctx, info, true);
    }

    protected Map submitWithOption(Context ctx, ReceivingBillInfo info, boolean ignoreWarnning) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._submit");
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            ReceivingBillInfo oldInfo;
            IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("billStatus");
            if (info.getId() != null && iReceivingBill.exists((IObjectPK)new ObjectUuidPK(info.getId().toString())) && (oldInfo = (ReceivingBillInfo)iReceivingBill.getValue((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic)).getBillStatus().getValue() != 10 && oldInfo.getBillStatus().getValue() != 11) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "BILL_STATUS_NOT_SAVEORSUBMIT"));
            }
            if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getRecBillType()) && !EmptyUtil.isEmpty((Object)info.getRecBillType().getSourceSysType())) {
                info.setSourceType(info.getRecBillType().getSourceSysType());
            }
            this.transAsstAccount(ctx, info);
            this.checkPayerTypeForSysApAr(info);
            if (PeriodHelper.isAdjustPeriod(ctx, info.getCompany().getId().toString())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD", new String[]{info.getNumber()}));
            }
            String initNumberLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._submit-initAndCheckNumber");
            PerfLogRecorder.endRecord(initNumberLogId);
            this.verifyBeforeSubmit(ctx, info);
            if (this.isStatusChanged(ctx, info)) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "CANNOT_SUBMIT_BILL_STATUS_CHANGED"));
            }
            String OverDraftLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._submit-overCtrl");
            if (info.getPayerAccountBankO() != null) {
                info.setOppInnerAcct(info.getPayerAccountBankO().getInnerAcct());
            } else {
                info.setOppInnerAcct(null);
            }
            if (!ignoreWarnning) {
                String msg = this.fplCtrlWarnInfo(ctx, info);
                if (msg != null) {
                    pageModel.put("msg", msg);
                    pageModel.put("error", 0);
                    PerfLogRecorder.endRecord(OverDraftLogId);
                    return pageModel;
                }
                Map paramValue = this.getSysParam(ctx, info.getCompany(), "EDIT");
                boolean isSubmitCtrlOverDraft = (Boolean)paramValue.get("isSubmitCtrlOverDraft");
                AccountBankInfo payerAcctBank = info.getPayerAccountBankO();
                if (payerAcctBank != null) {
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("company.id"));
                    sic.add(new SelectorItemInfo("ctrlStrategy.*"));
                    AccountBankInfo account = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getPayerAccountBankO().getId().toString()), sic);
                    boolean isPayerCompanyAcct = account.getCompany().getId().equals((Object)info.getCompany().getId());
                    if (payerAcctBank != null && account.getCtrlStrategy() != null && isPayerCompanyAcct) {
                        AccountMgrStrategyInfo strategy = account.getCtrlStrategy();
                        if (isSubmitCtrlOverDraft) {
                            String overDraftMsg;
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            BigDecimal balance = this.getBalanceValue(ctx, info.getCompany().getId().toString(), info.getPayeeAccount().getId().toString(), info.getPayeeAccountBank().getId().toString(), info.getCurrency().getId().toString(), sdf.format(info.getBizDate()));
                            ReceivingBillInfo old = iReceivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                            if (old == null) {
                                old = info;
                            }
                            if ((overDraftMsg = this.verifyOverDraftForReceivingBill(ctx, old, strategy, balance, info)) != null) {
                                pageModel.put("msg", overDraftMsg);
                                pageModel.put("error", 0);
                                PerfLogRecorder.endRecord(OverDraftLogId);
                                return pageModel;
                            }
                        }
                    }
                }
                return pageModel;
            }
            Map param = this.getSysParam(ctx, info.getCompany(), "EDIT");
            int overCtrlParam = 0;
            if (param.get("CS052") != null) {
                overCtrlParam = Integer.parseInt((String)param.get("CS052"));
            }
            if (1 == overCtrlParam) {
                RecPayAcctBankStratageCtrl.acctBankBalanceCtrl(ctx, (IObjectValue)info);
            }
            PerfLogRecorder.endRecord(OverDraftLogId);
            String submitLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._submit-guisubmit");
            IObjectPK pk = this.getSubmitPk(ctx, iReceivingBill, info);
            PerfLogRecorder.endRecord(submitLogId);
            pageModel.put("id", pk.toString());
            pageModel.put("error", 0);
        }
        catch (WfBizException e) {
            pageModel.put("error", 1);
            pageModel.put("msg", CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("msg", e.getMessage());
        }
        PerfLogRecorder.endRecord(pfLogId);
        return pageModel;
    }

    @Override
    protected Map _submitById(Context ctx, String id) throws BOSException, EASBizException {
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        String[] ids = new String[]{id};
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "SUBMIT_SUCCESS");
        ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), this.getSelector());
        try {
            Map submitResult = this.submit(ctx, info);
            result.setError((Integer)submitResult.get("error"));
            if (result.isError() != 0) {
                result.setSummaryMsg((String)submitResult.get("msg"));
            } else {
                result.setSummaryMsg(summary);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setError(1);
            summary = CASWebUtil.getResource(ctx, "SUBMIT_FAILED", new String[]{e.getMessage()});
            result.setSummaryMsg(summary);
        }
        return result;
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("payeeBank.name"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("company.accountTable.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.id"));
        sic.add(new SelectorItemInfo("company.baseCurrency.name"));
        sic.add(new SelectorItemInfo("company.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("payeeAccountBank.*"));
        sic.add(new SelectorItemInfo("payeeAccountBank.InnerAcct.*"));
        sic.add(new SelectorItemInfo("payeeAccountBank.InnerAcct.clearingHouse.*"));
        sic.add(new SelectorItemInfo("payeeAccountBank.bankAccountNumber"));
        sic.add(new SelectorItemInfo("payeeAccountBank.company.id"));
        sic.add(new SelectorItemInfo("payerAccountBankO.*"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("bizType.notSubmitHouse"));
        sic.add(new SelectorItemInfo("payerType.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("recBillType.name"));
        sic.add(new SelectorItemInfo("recBillType.sourceSysType"));
        sic.add(new SelectorItemInfo("recBillType.isSaleRec"));
        sic.add(new SelectorItemInfo("feeType.name"));
        sic.add(new SelectorItemInfo("payeeAccount.name"));
        sic.add(new SelectorItemInfo("payeeAccount.isCash"));
        sic.add(new SelectorItemInfo("payeeAccount.isBank"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("project.name"));
        sic.add(new SelectorItemInfo("costCenter.name"));
        sic.add(new SelectorItemInfo("profitCenter.*"));
        sic.add(new SelectorItemInfo("projectManager.name"));
        sic.add(new SelectorItemInfo("paymentType.name"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("cashier.name"));
        sic.add(new SelectorItemInfo("payerName"));
        sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("oppAccount.accountTableID.id"));
        sic.add(new SelectorItemInfo("oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("oppAccount.CAA.id"));
        sic.add(new SelectorItemInfo("oppAccount.CAA.isQty"));
        sic.add(new SelectorItemInfo("oppAccount.AC"));
        sic.add(new SelectorItemInfo("oppAccount.isBank"));
        sic.add(new SelectorItemInfo("oppAccount.name"));
        sic.add(new SelectorItemInfo("payeeAccount.longName"));
        sic.add(new SelectorItemInfo("oppAccount.number"));
        sic.add(new SelectorItemInfo("assItems.*"));
        sic.add(new SelectorItemInfo("entries.assItemsEntries.*"));
        sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.accountTableID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.companyID.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.CAA.id"));
        sic.add(new SelectorItemInfo("entries.oppAccount.CAA.isQty"));
        sic.add(new SelectorItemInfo("entries.oppAccount.AC"));
        sic.add(new SelectorItemInfo("entries.oppAccount.name"));
        sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        sic.add(new SelectorItemInfo("entries.oppAccount.longName"));
        sic.add(new SelectorItemInfo("entries.oppAccount.name"));
        sic.add(new SelectorItemInfo("entries.oppAccount.number"));
        sic.add(new SelectorItemInfo("entries.costCenter.name"));
        sic.add(new SelectorItemInfo("entries.costCenter.number"));
        sic.add(new SelectorItemInfo("entries.expenseType.name"));
        sic.add(new SelectorItemInfo("entries.expenseType.number"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.id"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.number"));
        sic.add(new SelectorItemInfo("entries.fundFlowItem.name"));
        sic.add(new SelectorItemInfo("entries.rebate"));
        sic.add(new SelectorItemInfo("entries.rebateLocAmt"));
        return sic;
    }

    @Override
    protected Map _auditById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "AUDIT_SUCCESS");
        ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            receivingBill.audit(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "AUDIT_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _unauditById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "UNAUDIT_SUCCESS");
        ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            receivingBill.antiAudit(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "UNAUDIT_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _commitSettleById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("sourceType"));
        IReceivingBill paymentBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "467_COMMITSETTLE_SUCCESS");
        ReceivingBillInfo info = paymentBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            int sourceType;
            int settlementStatus;
            int billStatus;
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            if (info.getBillStatus() != null && (billStatus = info.getBillStatus().getValue()) != 12) {
                throw new CasWebException(CasWebException.COMMITSETTLE_MUSTAUDITED_057);
            }
            if (info.getSettlementStatus() != null && (settlementStatus = info.getSettlementStatus().getValue()) != 10) {
                throw new CasWebException(CasWebException.CANNOT_MULTI_COMMITSETTLE_058);
            }
            SettBizTypeInfo bizTypeInfo = info.getBizType();
            if (info.getSourceType() != null && ((sourceType = info.getSourceType().getValue()) == 105 || bizTypeInfo == null)) {
                throw new CasWebException(CasWebException.RECEIVINGBILL_CANNOT_COMMITSETTLE_064);
            }
            paymentBill.commitSettle(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.equals((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.equals(e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "468_COMMITSETTLE_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _cancelCommitSettleById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IReceivingBill paymentBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "465_CANCELCOMMITSETTLE_SUCCESS");
        ReceivingBillInfo info = paymentBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            paymentBill.cancelCommitSettle(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            logger.error((Object)e);
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "466_CANCELCOMMITSETTLE_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _recById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "REC_SUCCESS");
        ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            receivingBill.rec(idList);
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "REC_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "REC_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "REC_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "REC_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _imageById(Context ctx, String id) throws BOSException, EASBizException {
        HashMap<String, Object> pageModel = new HashMap<String, Object>();
        try {
            IBillImageFacade image = BillImageFacadeFactory.getLocalInstance((Context)ctx);
            String imageUrl = image.getImageURL(BOSUuid.read((String)id).getType().toString(), id);
            if (StringUtils.isEmpty((String)imageUrl) || "null".equalsIgnoreCase(imageUrl)) {
                pageModel.put("error", 1);
                pageModel.put("summaryMsg", CASWebUtil.getResource(ctx, "ShareCenter_NO_ImageUrl"));
            } else {
                pageModel.put("error", 0);
                pageModel.put("imageUrl", imageUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            pageModel.put("error", 1);
            pageModel.put("summaryMsg", CASWebUtil.getResource(ctx, "ShareCenter_NO_ImageUrl"));
        }
        return pageModel;
    }

    @Override
    protected Map _cancelRecById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "CANCELREC_SUCCESS");
        ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(id), sic);
        HashSet<String> idList = new HashSet<String>();
        idList.add(id);
        try {
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            receivingBill.cancelRec(idList);
            result.setError(0);
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "CANCELREC_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "CANCELREC_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchSubmit(Context ctx, String[] ids) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._batchSubmit");
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        for (int i = 0; i < ids.length; ++i) {
            ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), this.getSelector());
            ArrayList<String> idList = new ArrayList<String>();
            idList.add(ids[i]);
            try {
                this.verifyBeforeSubmit(ctx, info);
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                String pfLogId_SaveBatch = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._batchSubmit.saveBatch");
                Map errorMsg = receivingBill.saveBatch(idList);
                PerfLogRecorder.endRecord(pfLogId_SaveBatch);
                Set set = errorMsg.keySet();
                Iterator it = set.iterator();
                while (it.hasNext()) {
                    --success;
                    String key = it.next().toString();
                    String msg = (String)errorMsg.get(key);
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), msg}));
                }
                continue;
            }
            catch (WfBizException e) {
                --success;
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                --success;
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_SUBMIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_SUBMIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "SUBMIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        PerfLogRecorder.endRecord(pfLogId);
        return result;
    }

    @Override
    protected Map _batchAudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < ids.length; ++i) {
            ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_receivingbill_05audit");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_AUDIT_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                receivingBill.audit(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_AUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_AUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "AUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchUnaudit(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                receivingBill.antiAudit(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_UNAUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_UNAUDIT_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_UNAUDIT_SUCCESS") : summary + CASWebUtil.getResource(ctx, "UNAUDIT_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchCommitSettle(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("bizType"));
        sic.add(new SelectorItemInfo("sourceType"));
        IReceivingBill paymentBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            ReceivingBillInfo info = paymentBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                int sourceType;
                int settlementStatus;
                int billStatus;
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                if (info.getBillStatus() != null && (billStatus = info.getBillStatus().getValue()) != 12) {
                    throw new CasWebException(CasWebException.COMMITSETTLE_MUSTAUDITED_057);
                }
                if (info.getSettlementStatus() != null && (settlementStatus = info.getSettlementStatus().getValue()) != 10) {
                    throw new CasWebException(CasWebException.CANNOT_MULTI_COMMITSETTLE_058);
                }
                SettBizTypeInfo bizTypeInfo = info.getBizType();
                if (info.getSourceType() != null && ((sourceType = info.getSourceType().getValue()) == 105 || bizTypeInfo == null)) {
                    throw new CasWebException(CasWebException.RECEIVINGBILL_CANNOT_COMMITSETTLE_062);
                }
                paymentBill.commitSettle(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "469_RECEIVINGBILL_COMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "469_RECEIVINGBILL_COMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "463_ALL_COMMITSETTLE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "464_COMMITSETTLE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchCancelCommitSettle(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        IReceivingBill paymentBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < ids.length; ++i) {
            ReceivingBillInfo info = paymentBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                paymentBill.cancelCommitSettle(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "470_RECEIVINGBILL_CANCELCOMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "470_RECEIVINGBILL_CANCELCOMMITSETTLE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "460_ALL_CANCELCOMMITSETTLE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "461_CANCELCOMMITSETTLE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchRec(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("settleBizType"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        HashSet<BOSUuid> permissionSet = new HashSet<BOSUuid>();
        for (int i = 0; i < ids.length; ++i) {
            ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idList = new HashSet<String>();
            idList.add(ids[i]);
            try {
                if (!permissionSet.contains(info.getCompany().getId())) {
                    boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "cas_receivingbill_07receive");
                    if (!isPermission) {
                        throw new CasWebException(CasWebException.NO_REC_AUTHRIZED);
                    }
                    permissionSet.add(info.getCompany().getId());
                }
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                Map param = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS110");
                boolean isInsideSettleAutoRecPay = (Boolean)param.get("CS110");
                if (isInsideSettleAutoRecPay && info.getSettleBizType() != null && (info.getSettleBizType().equals((Object)SettBizTypeEnum.PAYINSIDE) || info.getSettleBizType().equals((Object)SettBizTypeEnum.PAYINSIDEDIF) || info.getSettleBizType().equals((Object)SettBizTypeEnum.RECINSIDE) || info.getSettleBizType().equals((Object)SettBizTypeEnum.RECINSIDEDIF))) {
                    if (11 != info.getSettlementStatus().getValue() && 12 != info.getSettlementStatus().getValue()) continue;
                    String msg = CASWebUtil.getResource(ctx, "620_SolutionSetService");
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_CANCELREC_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), msg}));
                    continue;
                }
                receivingBill.rec(idList);
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_REC_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_REC_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_REC_SUCCESS") : summary + CASWebUtil.getResource(ctx, "REC_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _batchCancelRec(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("settleBizType"));
        sic.add(new SelectorItemInfo("settlementStatus"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CASWebUtil.ids2Set(ids), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sic);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        ReceivingBillCollection coll = receivingBill.getReceivingBillCollection(evi);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        for (int i = 0; i < coll.size(); ++i) {
            ReceivingBillInfo info = coll.get(i);
            HashSet<String> idList = new HashSet<String>();
            String id = info.getId().toString();
            idList.add(id);
            try {
                Map param;
                boolean isInsideSettleAutoRecPay;
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                if (!info.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
                    RecPayHelper.throwBizException(CASWebUtil.getResource(ctx, "STATUS_REC_CAN_CANCELREC"));
                }
                if ((isInsideSettleAutoRecPay = ((Boolean)(param = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS110")).get("CS110")).booleanValue()) && info.getSettleBizType() != null && (info.getSettleBizType().equals((Object)SettBizTypeEnum.PAYINSIDE) || info.getSettleBizType().equals((Object)SettBizTypeEnum.PAYINSIDEDIF) || info.getSettleBizType().equals((Object)SettBizTypeEnum.RECINSIDE) || info.getSettleBizType().equals((Object)SettBizTypeEnum.RECINSIDEDIF))) {
                    if (11 != info.getSettlementStatus().getValue() && 12 != info.getSettlementStatus().getValue()) continue;
                    String msg = CASWebUtil.getResource(ctx, "620_SolutionSetService");
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_CANCELREC_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), msg}));
                    continue;
                }
                if (info.getBillStatus().equals((Object)BillStatusEnum.RECED)) {
                    receivingBill.cancelRec(idList);
                }
                if (info.isPcaVouchered()) {
                    throw new RecPayException(RecPayException.HAS_PCAVOUCHER);
                }
                ++success;
                continue;
            }
            catch (WfBizException e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_CANCELREC_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
                continue;
            }
            catch (Exception e) {
                result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_CANCELREC_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), e.getMessage()}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_CANCELREC_SUCCESS") : summary + CASWebUtil.getResource(ctx, "CANCELREC_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _uniteRec(Context ctx, String[] ids) throws BOSException, EASBizException {
        int i;
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        result.setError(0);
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "UNITEREC_SUCCESS"));
        ArrayList<String> idList = new ArrayList<String>();
        for (i = 0; i < ids.length; ++i) {
            idList.add(ids[i]);
        }
        try {
            receivingBill.checkIsAdjustPeriod(idList);
        }
        catch (Exception e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
            return result;
        }
        for (i = 0; i < idList.size(); ++i) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("billStatus"));
            sic.add(new SelectorItemInfo("receivingBillType"));
            sic.add(new SelectorItemInfo("payeeAccount.id"));
            ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(idList.get(i).toString()), sic);
            if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
                result.setError(1);
                result.setSummaryMsg(CASWebUtil.getResource(ctx, "BILLSTATUS_NOT_AUDIT", new String[]{info.getNumber()}));
                return result;
            }
            boolean isCommonBill = CasRecPayBillTypeEnum.commonType.equals((Object)info.getReceivingBillType());
            if (!isCommonBill || info.getPayeeAccount() != null) continue;
            result.setError(1);
            result.setSummaryMsg(new RecPayException(RecPayException.PAYEEACCOUNT_CANNOT_BE_NULL).getMessage());
            return result;
        }
        LinkedHashSet s = new LinkedHashSet();
        for (int i2 = 0; i2 < idList.size(); ++i2) {
            s.add(idList.get(i2));
        }
        try {
            receivingBill.uniteRec(s);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW"));
            return result;
        }
        catch (EASBizException e) {
            result.setError(1);
            result.setSummaryMsg(e.getMessage());
            return result;
        }
        return result;
    }

    @Override
    protected Map _batchDelete(Context ctx, String[] ids) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("recBillType.sourceSysType"));
        sic.add(new SelectorItemInfo("srcRealRecBillID"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult execResult = new BatchExecuteResult();
        execResult.setError(0);
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = 0;
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < ids.length; ++i) {
            ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)new ObjectUuidPK(ids[i]), sic);
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(ids[i]);
            try {
                if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                    throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
                }
                boolean b = iMutex.requestObjIDForUpdate(ids[i]);
                if (!b) {
                    throw new Exception(CASWebUtil.getResource(ctx, "610_CantOpreateWhileOtherUse"));
                }
                String sourceBillId = info.getSourceBillId();
                if (!EmptyUtil.isEmpty((String)sourceBillId)) {
                    BOSUuid sbid = BOSUuid.read((String)sourceBillId);
                    if (sbid.getType().equals((Object)new PaymentBillInfo().getBOSType())) {
                        throw new RecPayException(RecPayException.CANNOTDELETEPAYFORSOURCE);
                    }
                    if (sbid.getType().equals((Object)new ReceivingBillInfo().getBOSType()) && !info.isIsTransBill() && !StringUtils.isEmpty((String)info.getSrcRealRecBillID())) {
                        throw new RecPayException(RecPayException.AGENTRECNOTDELETE);
                    }
                    BOSObjectType transDownBillInfo_Type = new TransDownBillInfo().getBOSType();
                    if (transDownBillInfo_Type.equals((Object)sbid.getType())) {
                        throw new RecPayException(RecPayException.RECEINGBILLDELETEERROR, new Object[]{info.getNumber()});
                    }
                }
                receivingBill.batchRemove(idSet);
                ++success;
                continue;
            }
            catch (Exception e) {
                execResult.setError(1);
                execResult.getDetailMsgList().add(CASWebUtil.getResource(ctx, "RECEIVINGBILL_DELETE_FAILED", new String[]{info.getCompany().getName(), info.getNumber(), BatchActionUtil.getExceptionMsg((Context)ctx, (Throwable)e)}));
            }
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "ALL_DELETE_SUCCESS") : summary + CASWebUtil.getResource(ctx, "DELETE_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        execResult.setSummaryMsg(summary);
        return execResult;
    }

    @Override
    protected Map _getSumInfo(Context ctx, String filter, String selectedIds) throws BOSException, EASBizException {
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
        CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), "cas_receivingbill_01view", false);
        StringBuffer where = new StringBuffer("company.id in ('NE',");
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            where.append("'" + orgUnitCollection.get(i).getId().toString() + "',");
        }
        where.deleteCharAt(where.length() - 1);
        where.append(")");
        filter = filter == null || filter.equals("") ? where.toString() : filter + " AND " + where.toString();
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.CasReceivingBillSumQuery"));
        ObjectUuidPK userPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId());
        String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "cas_receivingbill_01view");
        sql = !EmptyUtil.isEmpty((String)sql.trim()) ? "SELECT billCount,moneySum where " + filter + " and id in (" + sql + ")" : "SELECT billCount,moneySum where " + filter;
        queryExecutor.setObjectView(sql);
        System.out.println("Recevingbill SumInfo SQL: " + queryExecutor.getSQL());
        IRowSet rowSet = queryExecutor.executeQuery();
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            rowSet.next();
            result.put("billCount", rowSet.getBigDecimal("billCount"));
            result.put("moneySum", rowSet.getBigDecimal("moneySum"));
            result.put("error", 0);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        HashMap<String, BigDecimal> idMap = new HashMap<String, BigDecimal>();
        queryExecutor.setObjectView("SELECT id,actRecLocAmt where " + filter);
        try {
            rowSet = queryExecutor.executeQuery();
            while (rowSet.next()) {
                idMap.put(rowSet.getString("id"), rowSet.getBigDecimal("actRecLocAmt"));
            }
            result.put("idMap", idMap);
        }
        catch (Exception e) {
            result.put("error", 1);
            result.put("msg", e.getMessage());
            e.printStackTrace();
        }
        StringBuffer validIdSql = new StringBuffer("SELECT id where " + filter + " and id in('NE'");
        ArrayList<String> validIdList = new ArrayList<String>();
        if (!selectedIds.equals("")) {
            String[] idArr = selectedIds.split(",");
            for (int i = 0; i < idArr.length; ++i) {
                validIdSql.append(",'" + idArr[i] + "'");
            }
            validIdSql.append(")");
            queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.CasReceivingBillWebQuery"));
            queryExecutor.setObjectView(validIdSql.toString());
            rowSet = queryExecutor.executeQuery();
            try {
                while (rowSet.next()) {
                    validIdList.add(rowSet.getString("id"));
                }
            }
            catch (Exception e) {
                result.put("error", 1);
                result.put("msg", e.getMessage());
                e.printStackTrace();
            }
        }
        result.put("validIdList", validIdList);
        return result;
    }

    @Override
    protected ReceivingBillInfo _createNewModel(Context ctx, String companyId, String operate, String billId, Map param) throws BOSException, EASBizException {
        SelectorItemCollection selectorColl = this.getSelector();
        SelectorItemCollection dynSelectorColl = (SelectorItemCollection)param.get("copySelector");
        SelectorItemCollection mergeSelectors = PaymentBillWebFacadeControllerBean.getMergedSelector(selectorColl, dynSelectorColl);
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._createNewModel");
        if (param == null) {
            param = this.getAllParam(ctx, companyId, "ADDNEW");
        }
        ReceivingBillInfo info = null;
        if (operate == null) {
            CompanyOrgUnitInfo addNewDefaultcompany = (CompanyOrgUnitInfo)param.get("company");
            info = new ReceivingBillInfo();
            info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
            info.setBizDate(new Date());
            info.setSourceType(SourceTypeEnum.CASH);
            info.setSourceSysType(SourceTypeEnum.CASH);
            info.setCompany(addNewDefaultcompany);
            info.setCU(addNewDefaultcompany.getCU());
            info.setExchangeRate(new BigDecimal("1"));
            info.setCurrency(addNewDefaultcompany.getBaseCurrency());
            info.setCreator((UserInfo)param.get("userInfo"));
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            info.setPayerName(null);
            info.setPayerNumber(null);
            info.setBillStatus(BillStatusEnum.SAVE);
            AsstActTypeCollection asstActTypeColl = (AsstActTypeCollection)param.get("asstActTypeCollection");
            if (asstActTypeColl.size() > 0 && param.get("defaultAsstActType") != null) {
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)param.get("defaultAsstActType");
                info.setPayerType(asstActTypeInfo);
            }
            ReceivingBillEntryInfo entryInfo = new ReceivingBillEntryInfo();
            entryInfo.setSeq(1);
            info.getEntries().add(entryInfo);
            ReceivingBillTypeInfo defaultBillTypeInfo = this.getDefaultBillType(ctx);
            if (defaultBillTypeInfo == null) {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                ev.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)"999", CompareType.EQUALS));
                ReceivingBillTypeCollection coll = ReceivingBillTypeFactory.getLocalInstance(ctx).getReceivingBillTypeCollection(ev);
                if (coll != null && !coll.isEmpty()) {
                    defaultBillTypeInfo = coll.get(0);
                }
            }
            if (null != defaultBillTypeInfo && DeletedStatusEnum.DELETED.equals((Object)defaultBillTypeInfo.getDeletedStatus())) {
                defaultBillTypeInfo = null;
            }
            if (defaultBillTypeInfo != null) {
                info.setRecBillType(defaultBillTypeInfo);
                info.setSourceSysType(defaultBillTypeInfo.getSourceSysType());
            }
        } else if ("copy".equals(operate)) {
            Map allAssGrpMap;
            IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
            ReceivingBillInfo oldInfo = (ReceivingBillInfo)iReceivingBill.getValue((IObjectPK)new ObjectUuidPK(billId), mergeSelectors);
            info = oldInfo.copy();
            ReceivingBillEntryCollection entries = info.getEntries();
            if (null != entries && entries.size() > 0) {
                for (int i = 0; i < entries.size(); ++i) {
                    ExpenseTypeInfo ex;
                    ReceivingBillEntryInfo receivingBillEntryInfo = entries.get(i);
                    ExpenseTypeInfo expenseType = receivingBillEntryInfo.getExpenseType();
                    if (null == expenseType || null == (ex = (ExpenseTypeInfo)ExpenseTypeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(expenseType.getId().toString()))) || ex.isIsStart()) continue;
                    receivingBillEntryInfo.setExpenseType(null);
                }
            }
            info.setReceivingBillType(CasRecPayBillTypeEnum.commonType);
            info.setCU(oldInfo.getCU());
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setBizDate(new Date());
            info.setSourceType(SourceTypeEnum.CASH);
            info.setSourceSysType(SourceTypeEnum.CASH);
            info.setCompany(oldInfo.getCompany());
            info.setCreator((UserInfo)param.get("userInfo"));
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            if (SourceTypeEnum.AR.equals((Object)oldInfo.getSourceType())) {
                CompanyOrgUnitInfo currentCompany = info.getCompany();
                String baseCurrencyId = currentCompany.getBaseCurrency().getId().toString();
                String currencyId = info.getCurrency().getId().toString();
                boolean isLocalCurrency = currencyId.equals(baseCurrencyId);
                Map exchangeRate = CASCommonWebFacadeFactory.getRemoteInstance().getExchangeRate(companyId, currencyId, info.getDate("bizDate"));
                BigDecimal value = (BigDecimal)exchangeRate.get("exchangeRate");
                if (isLocalCurrency) {
                    value = new BigDecimal("1.0");
                }
                info.setExchangeRate(value);
            }
            if ((allAssGrpMap = this.getAssItems(ctx, billId)).get(billId) != null) {
                info.getOppAccount().put("assgrp", allAssGrpMap.get(billId));
            }
            Object assgrp = null;
            AccountViewInfo oppAccountInfo = null;
            AccountViewInfo _oppAccountInfo = null;
            for (int i = 0; i < oldInfo.getEntries().size(); ++i) {
                assgrp = allAssGrpMap.get(oldInfo.getEntries().get(i).getId().toString());
                if (assgrp == null) continue;
                oppAccountInfo = info.getEntries().get(i).getOppAccount();
                _oppAccountInfo = (AccountViewInfo)oppAccountInfo.clone();
                _oppAccountInfo.put("assgrp", assgrp);
                info.getEntries().get(i).setOppAccount(_oppAccountInfo);
            }
        } else if ("template".equals(operate)) {
            ITemplateReceivingBill iTemplateReceivingBill = TemplateReceivingBillFactory.getLocalInstance(ctx);
            TemplateReceivingBillInfo oldInfo = (TemplateReceivingBillInfo)iTemplateReceivingBill.getValue((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
            info = new ReceivingBillInfo();
            this.transferTempToRec(oldInfo, info);
            info.setReceivingBillType(CasRecPayBillTypeEnum.commonType);
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setBizDate(new Date());
            info.setSourceType(SourceTypeEnum.CASH);
            info.setSourceSysType(SourceTypeEnum.CASH);
            info.setCompany(oldInfo.getCompany());
            info.setCreator((UserInfo)param.get("userInfo"));
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            Map allAssGrpMap = this.getAssItems4Template(ctx, billId);
            if (allAssGrpMap.get(billId) != null) {
                info.getOppAccount().put("assgrp", allAssGrpMap.get(billId));
            }
            AccountViewInfo oppAccountInfo = null;
            AccountViewInfo _oppAccountInfo = null;
            for (int i = 0; i < oldInfo.getEntries().size(); ++i) {
                Object assgrp = allAssGrpMap.get(oldInfo.getEntries().get(i).getId().toString());
                if (assgrp == null) continue;
                oppAccountInfo = info.getEntries().get(i).getOppAccount();
                _oppAccountInfo = (AccountViewInfo)oppAccountInfo.clone();
                _oppAccountInfo.put("assgrp", assgrp);
                info.getEntries().get(i).setOppAccount(_oppAccountInfo);
            }
        } else if ("offset".equals(operate)) {
            IReceivingBill iReceivingBill = ReceivingBillFactory.getLocalInstance(ctx);
            ReceivingBillInfo oldInfo = (ReceivingBillInfo)iReceivingBill.getValue((IObjectPK)new ObjectUuidPK(billId), this.getSelector());
            DeepClone cloneUtil = new DeepClone();
            try {
                info = (ReceivingBillInfo)cloneUtil.copyOppValueInfo((CoreBaseInfo)oldInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
            this.setNotCopyValues(ctx, info);
            info.setReceivingBillType(CasRecPayBillTypeEnum.commonType);
            info.setExchangeRate(info.getExchangeRate().abs());
            info.setBillStatus(BillStatusEnum.SAVE);
            info.setBizDate(new Date());
            info.setSourceType(SourceTypeEnum.CASH);
            info.setSourceSysType(SourceTypeEnum.CASH);
            info.setCompany(oldInfo.getCompany());
            info.setCreator((UserInfo)param.get("userInfo"));
            info.setCreateTime(new Timestamp(System.currentTimeMillis()));
            Map allAssGrpMap = this.getAssItems(ctx, billId);
            if (allAssGrpMap.get(billId) != null) {
                info.getOppAccount().put("assgrp", allAssGrpMap.get(billId));
            }
            AccountViewInfo oppAccountInfo = null;
            AccountViewInfo _oppAccountInfo = null;
            for (int i = 0; i < oldInfo.getEntries().size(); ++i) {
                Object assgrp = allAssGrpMap.get(oldInfo.getEntries().get(i).getId().toString());
                if (assgrp == null) continue;
                oppAccountInfo = info.getEntries().get(i).getOppAccount();
                _oppAccountInfo = (AccountViewInfo)oppAccountInfo.clone();
                _oppAccountInfo.put("assgrp", assgrp);
                info.getEntries().get(i).setOppAccount(_oppAccountInfo);
            }
        }
        PerfLogRecorder.endRecord(pfLogId);
        return info;
    }

    private void transferTempToRec(TemplateReceivingBillInfo templateReceivingBill, ReceivingBillInfo receivingBill) {
        int i;
        receivingBill.setCompany(templateReceivingBill.getCompany());
        receivingBill.setActRecAmt(templateReceivingBill.getActRecAmt());
        receivingBill.setActRecLocAmt(templateReceivingBill.getActRecLocAmt());
        receivingBill.setRecBillType(templateReceivingBill.getRecBillType());
        receivingBill.setFeeType(templateReceivingBill.getFeeType());
        receivingBill.setCurrency(templateReceivingBill.getCurrency());
        receivingBill.setExchangeRate(templateReceivingBill.getExchangeRate());
        receivingBill.setPayeeAccountBank(templateReceivingBill.getPayeeAccountBank());
        receivingBill.setPayeeAccount(templateReceivingBill.getPayeeAccount());
        receivingBill.setPayeeBank(templateReceivingBill.getPayeeBank());
        receivingBill.setBizType(templateReceivingBill.getBizType());
        receivingBill.setSettlementType(templateReceivingBill.getSettlementType());
        receivingBill.setSettlementNumber(templateReceivingBill.getSettlementNumber());
        receivingBill.setAdminOrgUnit(templateReceivingBill.getAdminOrgUnit());
        receivingBill.setPerson(templateReceivingBill.getPerson());
        receivingBill.setOutBgItemId(templateReceivingBill.getOutBgItemId());
        receivingBill.setOutBgItemName(templateReceivingBill.getOutBgItemName());
        receivingBill.setOutBgItemNumber(templateReceivingBill.getOutBgItemNumber());
        receivingBill.setOppBgItemId(templateReceivingBill.getOppBgItemId());
        receivingBill.setOppBgItemName(templateReceivingBill.getOppBgItemName());
        receivingBill.setOppBgItemNumber(templateReceivingBill.getOppBgItemNumber());
        receivingBill.setCostCenter(templateReceivingBill.getCostCenter());
        receivingBill.setProject(templateReceivingBill.getProject());
        receivingBill.setProjectManager(templateReceivingBill.getProjectManager());
        receivingBill.setPayerType(templateReceivingBill.getPayerType());
        receivingBill.setPayerAccountBank(templateReceivingBill.getPayerAccountBank());
        receivingBill.setPayerAccountBankO(templateReceivingBill.getPayerAccountBankO());
        receivingBill.setPayerID(templateReceivingBill.getPayerID());
        receivingBill.setPayerBank(templateReceivingBill.getPayerBank());
        receivingBill.setPayerName(templateReceivingBill.getPayerName());
        receivingBill.setPayerNumber(templateReceivingBill.getPayerNumber());
        receivingBill.setDescription(templateReceivingBill.getDescription());
        receivingBill.setOppAccount(templateReceivingBill.getOppAccount());
        ReceivingBillEntryInfo receivingBillEntry = null;
        TemplateReceivingBillEntryInfo templateReceivingBilllEntry = null;
        AssItemsForCashRecInfo cashRecInfo = null;
        AssItemsForTmplRecInfo tmplRecInfo = null;
        for (i = 0; i < templateReceivingBill.getAssItems().size(); ++i) {
            cashRecInfo = new AssItemsForCashRecInfo();
            tmplRecInfo = templateReceivingBill.getAssItems().get(i);
            cashRecInfo.setAsstActType(tmplRecInfo.getAsstActType());
            cashRecInfo.setFromID(tmplRecInfo.getFromID());
            cashRecInfo.setFromNumber(tmplRecInfo.getFromNumber());
            cashRecInfo.setIsSelected(tmplRecInfo.isIsSelected());
            cashRecInfo.setMappingFileds(tmplRecInfo.getMappingFileds());
            cashRecInfo.setTableName(tmplRecInfo.getTableName());
            cashRecInfo.setEntrySeq(tmplRecInfo.getEntrySeq());
            cashRecInfo.setSeq(tmplRecInfo.getSeq());
            receivingBill.getAssItems().add(cashRecInfo);
        }
        receivingBill.getEntries().clear();
        for (i = 0; i < templateReceivingBill.getEntries().size(); ++i) {
            receivingBillEntry = new ReceivingBillEntryInfo();
            templateReceivingBilllEntry = templateReceivingBill.getEntries().get(i);
            receivingBillEntry.setSeq(i);
            receivingBillEntry.setCurrency(receivingBill.getCurrency());
            receivingBillEntry.setActualAmt(templateReceivingBilllEntry.getActualAmt());
            receivingBillEntry.setCostCenter(templateReceivingBilllEntry.getCostCenter());
            receivingBillEntry.setActualLocAmt(templateReceivingBilllEntry.getActualLocAmt());
            receivingBillEntry.setOppAccount(templateReceivingBilllEntry.getOppAccount());
            receivingBillEntry.setExpenseType(templateReceivingBilllEntry.getExpenseType());
            receivingBillEntry.setOppBgItemId(templateReceivingBilllEntry.getOppBgItemId());
            receivingBillEntry.setOppBgItemName(templateReceivingBilllEntry.getOppBgItemName());
            receivingBillEntry.setOppBgItemNumber(templateReceivingBilllEntry.getOppBgItemNumber());
            receivingBillEntry.setOutBgItemId(templateReceivingBilllEntry.getOutBgItemId());
            receivingBillEntry.setOutBgItemName(templateReceivingBilllEntry.getOutBgItemName());
            receivingBillEntry.setOutBgItemNumber(templateReceivingBilllEntry.getOutBgItemNumber());
            receivingBillEntry.setFundFlowItem(templateReceivingBilllEntry.getFundFlowItem());
            receivingBillEntry.setRemark(templateReceivingBilllEntry.getRemark());
            receivingBillEntry.setSeq(templateReceivingBilllEntry.getSeq());
            for (int j = 0; j < templateReceivingBilllEntry.getAssItemsEntries().size(); ++j) {
                cashRecInfo = new AssItemsForCashRecInfo();
                tmplRecInfo = templateReceivingBilllEntry.getAssItemsEntries().get(j);
                cashRecInfo.setAsstActType(tmplRecInfo.getAsstActType());
                cashRecInfo.setFromID(tmplRecInfo.getFromID());
                cashRecInfo.setFromNumber(tmplRecInfo.getFromNumber());
                cashRecInfo.setIsSelected(tmplRecInfo.isIsSelected());
                cashRecInfo.setMappingFileds(tmplRecInfo.getMappingFileds());
                cashRecInfo.setTableName(tmplRecInfo.getTableName());
                cashRecInfo.setEntrySeq(tmplRecInfo.getEntrySeq());
                cashRecInfo.setSeq(tmplRecInfo.getSeq());
                receivingBillEntry.getAssItemsEntries().add(cashRecInfo);
            }
            receivingBill.getEntries().add(receivingBillEntry);
        }
    }

    private void setNotCopyValues(Context ctx, ReceivingBillInfo info) {
        info.setNumber(null);
        info.setSourceBillId(null);
        info.setAuditor(null);
        info.setVoucher(null);
        info.setAuditDate(null);
        info.setCashier(null);
        info.setAccountant(null);
        info.setApprover(null);
        info.setAccepter(null);
        info.setVoucherNumber(null);
        info.setVoucherType(null);
        info.setBizDate(new Date());
        info.setBillStatus(BillStatusEnum.SAVE);
        info.setSettlementStatus(SettlementStatusEnum.UNSUBMIT);
        info.setFiVouchered(false);
        info.setHasEReceipt(false);
    }

    @Override
    protected Map _getAllParam(Context ctx, String companyId, String operateState) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean._getAllParam");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(OPERATESTATE, operateState);
        this.setDefaultCompany(ctx, companyId, param);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)param.get("company");
        companyId = company.getId().toString();
        String getParamMapLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "CASWebHelper.getParamMap");
        Map paramValue = CASWebHelper.getParamMap(ctx, companyId, "CS016", "CS032", "CS040", "CS063", "CS082", "CS033", "CS037", "CS110", "CS052", "CS131", "MBG_C001");
        param.putAll(paramValue);
        PerfLogRecorder.endRecord(getParamMapLogId);
        if (param.get("CS052") != null) {
            int val = Integer.parseInt((String)paramValue.get("CS052"));
            param.put("isSubmitCtrlOverDraft", val == 1);
        } else {
            param.put("isSubmitCtrlOverDraft", false);
        }
        AsstActTypeCollection asstActTypeColl = this.getAsstActTypeColl(ctx, company.getId().toString(), false);
        param.put("asstActTypeCollection", asstActTypeColl);
        param.put("defaultAsstActType", this.getDefaultAsstActTypeInfo(ctx, company.getId().toString()));
        PerfLogRecorder.endRecord(pfLogId);
        return param;
    }

    protected AsstActTypeInfo getDefaultAsstActTypeInfo(Context ctx, String cuID) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("select FAsstActTypeID, FLastUpdateUserId from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and Fcompanyid='" + cuID + "'");
        sb.append(" and FISDEFAULTACCOUNTRECEIVABLE = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        String id = null;
        try {
            if (rs.next()) {
                do {
                    id = rs.getString("FAsstActTypeID");
                } while (rs.getString("FLastUpdateUserId") == null && rs.next());
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        if (id != null) {
            return AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(id));
        }
        return null;
    }

    protected AsstActTypeInfo getDefaultAsstActType(Context ctx, String cuId) throws EASBizException, BOSException {
        AsstActTypeInfo defalutAssitType = null;
        AsstActTypeCollection asstActDefalutTypeColl = this.getAsstActTypeColl(ctx, cuId, true);
        if (asstActDefalutTypeColl != null && asstActDefalutTypeColl.size() > 0) {
            defalutAssitType = asstActDefalutTypeColl.get(0);
        }
        return defalutAssitType;
    }

    protected void setDefaultCompany(Context ctx, String companyId, Map<String, Object> param) throws BOSException, EASBizException {
        String pfLogId = PerfLogRecorder.startRecord(Thread.currentThread().getName(), "ReceivingbillWebFacadeControllerBean.setDefaultCompany");
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance(ctx);
        String operateState = (String)param.get(OPERATESTATE);
        String permItem = "cas_receivingbill_01view";
        if (operateState.equals("ADDNEW")) {
            permItem = "cas_receivingbill_02addNew";
        }
        CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(ctx.getCaller().toString(), permItem, false);
        param.put("authrizedCompanyOrg", orgUnitCollection);
        CompanyOrgUnitInfo company = null;
        if (companyId == null) {
            CompanyOrgUnitInfo defaultOrgUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
            if (defaultOrgUnit.isIsBizUnit()) {
                boolean havePower = false;
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).getId().toString().equals(defaultOrgUnit.getId().toString())) continue;
                    havePower = true;
                    break;
                }
                if (havePower) {
                    company = defaultOrgUnit;
                } else if (orgUnitCollection.size() > 0) {
                    company = orgUnitCollection.get(0);
                }
            } else {
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).isIsBizUnit()) continue;
                    company = orgUnitCollection.get(i);
                    break;
                }
            }
        } else {
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                if (!orgUnitCollection.get(i).getId().toString().equals(companyId) || !orgUnitCollection.get(i).isIsBizUnit()) continue;
                company = orgUnitCollection.get(i);
                break;
            }
        }
        if (company == null) {
            throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.number"));
        company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
        param.put("company", company);
        UserInfo userinfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        param.put("userInfo", userinfo);
        PerfLogRecorder.endRecord(pfLogId);
    }

    protected AsstActTypeCollection getAsstActTypeColl(Context ctx, String cuID, boolean isRec) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer();
        sb.append("where id in(select FAsstActTypeID from T_BD_AsstActTypeDefault where FIsAccountCussent=1 ");
        sb.append(" and Fcompanyid='" + cuID + "'");
        if (isRec) {
            sb.append(" and FISDEFAULTACCOUNTRECEIVABLE=1");
        }
        sb.append(")");
        EntityViewInfo evi = null;
        try {
            evi = new EntityViewInfo(sb.toString());
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        IAsstActType asstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
        AsstActTypeCollection asstActTypeCollection = asstActType.getAsstActTypeCollection(evi);
        return asstActTypeCollection;
    }

    @Override
    protected BigDecimal _getBalanceValue(Context ctx, String companyId, String acctViewId, String acctBankId, String currencyId, String bizDate) throws BOSException, EASBizException {
        ObjectUuidPK companyPK = companyId == null || companyId.equals("") ? null : new ObjectUuidPK(companyId);
        ObjectUuidPK acctViewPK = acctViewId == null || acctViewId.equals("") ? null : new ObjectUuidPK(acctViewId);
        ObjectUuidPK acctBankPK = acctBankId == null || acctBankId.equals("") ? null : new ObjectUuidPK(acctBankId);
        ObjectUuidPK currencyPK = currencyId == null || currencyId.equals("") ? null : new ObjectUuidPK(currencyId);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        BigDecimal totalBalance = new BigDecimal("0");
        boolean isBankinterface = false;
        if (acctBankPK != null && currencyPK != null) {
            AccountBankInfo acctBankInfo = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)acctBankPK);
            isBankinterface = acctBankInfo.isIsSetBankInterface();
            String CS132 = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("CS132", (IObjectPK)companyPK);
            if ("1".equals(CS132)) {
                isBankinterface = false;
            }
            if (acctBankPK != null && acctViewPK != null && currencyPK != null && companyPK != null && !isBankinterface) {
                try {
                    CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)companyPK);
                    AccountViewInfo acctView = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo((IObjectPK)acctViewPK);
                    AccountBankInfo acctBank = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankInfo((IObjectPK)acctBankPK);
                    CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)currencyPK);
                    totalBalance = RecPayHelper.getTotalBalance(ctx, company, acctView, acctBank, currency);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            } else if (isBankinterface) {
                totalBalance = PaymentBillFactory.getLocalInstance(ctx).getBalanceValue(acctBankId, currencyId);
            }
        }
        if (currencyId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("precision"));
            int precision = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)currencyPK, sic).getPrecision();
            totalBalance = totalBalance.setScale(precision, 4);
        }
        return totalBalance;
    }

    @Override
    protected Map _getAssItems(Context ctx, String receivingBillId) throws BOSException, EASBizException {
        HashMap allAssGrp = new HashMap();
        AssItemsForCashRecCollection assItemsColl = AssItemsForCashRecFactory.getLocalInstance(ctx).getAssItemsForCashRecCollection("select * where  parent.id = '" + receivingBillId + "'");
        if (assItemsColl.size() > 0) {
            HashMap assgrp = new HashMap();
            allAssGrp.put(receivingBillId, assgrp);
            ArrayList<AsstActTypeInfo> details = new ArrayList<AsstActTypeInfo>();
            assgrp.put("detail", details);
            for (int i = 0; i < assItemsColl.size(); ++i) {
                AssItemsForCashRecInfo assItem = assItemsColl.get(i);
                AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assItem.getAsstActType().getId().toString())).clone();
                asstActTypeInfo.put("value", null);
                String id = assItem.getFromID();
                if (id != null && !id.equals("")) {
                    ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                    CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                    asstActTypeInfo.put("value", (Object)info);
                }
                details.add(asstActTypeInfo);
            }
        }
        assItemsColl = AssItemsForCashRecFactory.getLocalInstance(ctx).getAssItemsForCashRecCollection("select * where entryParent.receivingBill.id = '" + receivingBillId + "'");
        for (int i = 0; i < assItemsColl.size(); ++i) {
            AssItemsForCashRecInfo assItem = assItemsColl.get(i);
            String entryId = assItem.getEntryParent().getId().toString();
            HashMap assgrp = (HashMap)allAssGrp.get(entryId);
            ArrayList<AsstActTypeInfo> details = null;
            if (assgrp == null) {
                assgrp = new HashMap();
                allAssGrp.put(entryId, assgrp);
                details = new ArrayList<AsstActTypeInfo>();
                assgrp.put("detail", details);
            } else {
                details = (ArrayList<AsstActTypeInfo>)assgrp.get("detail");
            }
            AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(assItem.getAsstActType().getId().toString())).clone();
            asstActTypeInfo.put("value", null);
            String id = assItem.getFromID();
            if (id != null && !id.equals("")) {
                ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                asstActTypeInfo.put("value", (Object)info);
            }
            details.add(asstActTypeInfo);
        }
        Object[] allAssGrps = allAssGrp.values().toArray();
        for (int i = 0; i < allAssGrps.length; ++i) {
            Map assgrp = (Map)allAssGrps[i];
            List details = (List)assgrp.get("detail");
            String displayName = "";
            for (int j = 0; j < details.size(); ++j) {
                CoreBaseInfo detailValue = (CoreBaseInfo)((AsstActTypeInfo)details.get(j)).get("value");
                if (detailValue == null) continue;
                displayName = detailValue.get("name") != null ? displayName + detailValue.get("name") + " | " : displayName + detailValue.get("name_" + LocaleUtils.getShortLocale((Locale)ctx.getLocale())) + " | ";
            }
            if (!displayName.equals("")) {
                displayName = displayName.substring(0, displayName.length() - 3);
            }
            assgrp.put("displayname", displayName);
        }
        return allAssGrp;
    }

    @Override
    protected String _f7getCollection(Context ctx, String cuID, String groupID) throws BOSException, EASBizException {
        IRowSet rs = null;
        String sql = "select A.fparentid from T_BD_Generalasstacttype A inner join T_ORG_CtrlUnit D on D.FID=? inner join T_ORG_CtrlUnit E on E.FID=A.FControlUnitID and (CHARINDEX(E.FLongNumber||'!',D.FLongNumber)=1 or d.fid=e.fid) where A.fparentid is not null and FgroupID=? ";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{cuID, groupID});
        StringBuffer parentid = new StringBuffer();
        try {
            while (rs.next()) {
                rs.getString("fparentid");
                parentid.append(rs.getString("fparentid")).append(",");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return parentid.toString();
    }

    @Override
    protected SupplierCompanyInfoInfo _getSupplierCompany(Context ctx, String supplierId, String companyId) throws BOSException, EASBizException {
        SupplierCompanyInfoInfo supplierCompany = SupplierFactory.getLocalInstance((Context)ctx).getCompanyInfo((IObjectPK)new ObjectUuidPK(supplierId), (IObjectPK)new ObjectUuidPK(companyId));
        return supplierCompany;
    }

    @Override
    protected CustomerCompanyInfoInfo _getCustomerCompany(Context ctx, String customerId, String companyId) throws BOSException, EASBizException {
        CustomerCompanyInfoInfo custCompany = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCompanyInfo((IObjectPK)new ObjectUuidPK(customerId), (IObjectPK)new ObjectUuidPK(companyId));
        return custCompany;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _recBeInfo(Context ctx, String[] ids, String[] orgIds) throws BOSException, EASBizException {
        Set appliedSet = new HashSet();
        try {
            appliedSet = this.requestMutexs(ctx, ids);
            TransDetailCollection transColl = this.getTransDetailColl(ctx, appliedSet);
            if (EmptyUtil.isEmpty((AbstractObjectCollection)transColl) || transColl.size() == 0) {
                throw new BEException(BEException.NOTRANSDETAIL);
            }
            AccountBankCollection accBankColl = this.getAccBankMapByOrgs(ctx, orgIds);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.Array2Set((String[])orgIds), CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(evi);
            ReceivingBillFactory.getLocalInstance(ctx).recBeInfoByMapping(appliedSet, null, (IObjectCollection)companys);
        }
        finally {
            this.releaseMutexs(FMHelper.set2List(appliedSet));
        }
        int length = ids.length;
        BatchExecuteResult result = this.buildRecBeMsg(ctx, appliedSet, length);
        return result;
    }

    private BatchExecuteResult buildRecBeMsg(Context ctx, Set appliedSet, int length) {
        BatchExecuteResult result = new BatchExecuteResult();
        if (appliedSet.size() == length) {
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "GENRECEIVINGBILL_SUCCESS"));
        } else {
            result.setSummaryMsg(CASWebUtil.getResource(ctx, "552_GEN_RECEIVINGBILL", new String[]{String.valueOf(appliedSet.size()), String.valueOf(length - appliedSet.size())}));
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "550_GEN_PAYMENT_FAIL"));
        }
        return result;
    }

    private void releaseMutexs(List correctList) {
        MutexServiceControlFactory.getRemoteInstance().batchReleaseObjIDForUpdate(correctList);
    }

    private AccountBankCollection getAccBankMapByOrgs(Context ctx, String[] orgIds) throws BOSException {
        StringBuffer inFilter = new StringBuffer("(");
        for (int i = 0; i < orgIds.length; ++i) {
            inFilter.append("'" + orgIds[i] + "',");
        }
        inFilter.deleteCharAt(inFilter.length() - 1);
        inFilter.append(")");
        StringBuffer oql = new StringBuffer("select id, company.id, account.id, bank.id, bankAccountNumber where id in (select bd.fid from t_bd_accountbanks bd left outer join T_BD_AcctBankTrusterEntries AS en on en.FAcctBankID=bd.fid where bd.fcompanyid in " + inFilter + " or en.ftrustCompanyID in " + inFilter + ")");
        return AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(oql.toString());
    }

    private TransDetailCollection getTransDetailColl(Context ctx, Set appliedSet) throws BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)appliedSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isReced", (Object)false, CompareType.EQUALS));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("*"));
        evi.getSelector().add(new SelectorItemInfo("bankAccount.bankAccountNumber"));
        TransDetailCollection transColl = TransDetailFactory.getLocalInstance((Context)ctx).getTransDetailCollection(evi);
        return transColl;
    }

    private Set requestMutexs(Context ctx, String[] ids) throws BOSException {
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        ArrayList<String> idList = new ArrayList<String>();
        for (int i = 0; i < ids.length; ++i) {
            idList.add(ids[i]);
        }
        HashSet appliedSet = new HashSet();
        Map detailsRequest = iMutex.batchRequestObjIDForUpdate(idList);
        for (int i = 0; i < idList.size(); ++i) {
            Boolean boolDetail = (Boolean)detailsRequest.get(idList.get(i));
            if (!boolDetail.booleanValue()) continue;
            appliedSet.add(idList.get(i));
        }
        return appliedSet;
    }

    @Override
    protected Map _deleteById(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("recBillType.sourceSysType"));
        sic.add(new SelectorItemInfo("srcRealRecBillID"));
        IReceivingBill receivingBill = ReceivingBillFactory.getLocalInstance(ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "327_DELETE_SUCCESS");
        ObjectUuidPK pk = new ObjectUuidPK(id);
        ReceivingBillInfo info = receivingBill.getReceivingBillInfo((IObjectPK)pk, sic);
        try {
            if (CASWebHelper.isAdjustPeriod(ctx, info.getCompany())) {
                throw new RuntimeException(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD_SINGLE"));
            }
            IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            boolean b = iMutex.requestObjIDForUpdate(id);
            if (!b) {
                throw new Exception(CASWebUtil.getResource(ctx, "610_CantOpreateWhileOtherUse"));
            }
            String sourceBillId = info.getSourceBillId();
            if (!EmptyUtil.isEmpty((String)sourceBillId)) {
                BOSUuid sbid = BOSUuid.read((String)sourceBillId);
                if (sbid.getType().equals((Object)new PaymentBillInfo().getBOSType())) {
                    throw new RecPayException(RecPayException.CANNOTDELETEPAYFORSOURCE);
                }
                if (sbid.getType().equals((Object)new ReceivingBillInfo().getBOSType()) && !info.isIsTransBill() && !StringUtils.isEmpty((String)info.getSrcRealRecBillID())) {
                    throw new RecPayException(RecPayException.AGENTRECNOTDELETE);
                }
                BOSObjectType transDownBillInfo_Type = new TransDownBillInfo().getBOSType();
                if (transDownBillInfo_Type.equals((Object)sbid.getType())) {
                    throw new RecPayException(RecPayException.RECEINGBILLDELETEERROR, new Object[]{info.getNumber()});
                }
            }
            receivingBill.delete((IObjectPK)pk);
            result.setError(0);
        }
        catch (WfBizException e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")}));
            summary = CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{CASWebUtil.getResource(ctx, "ALREADY_IN_WORKFLOW")});
        }
        catch (Exception e) {
            result.setError(1);
            result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{e.getMessage()}));
            summary = CASWebUtil.getResource(ctx, "328_DELETE_FAILED", new String[]{e.getMessage()});
        }
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected void _transAsstAccount(Context ctx, ReceivingBillInfo info) throws BOSException, EASBizException {
        info.getAssItems().clear();
        for (int i = 0; i < info.getEntries().size(); ++i) {
            AssItemsForCashRecInfo assItemInfo;
            Map value;
            AsstActTypeInfo asstTypeInfo;
            Map asstType;
            int j;
            ReceivingBillEntryInfo entry = info.getEntries().get(i);
            entry.getAssItemsEntries().clear();
            if (entry.getOppAccount() == null || entry.getOppAccount().get("assgrp") == null) continue;
            Map assgrp = (Map)entry.getOppAccount().get("assgrp");
            List detail = (List)assgrp.get("detail");
            String caaId = (String)assgrp.get("CAAId");
            entry.getAssItemsEntries().clear();
            for (j = 0; j < detail.size(); ++j) {
                asstType = (Map)detail.get(j);
                asstTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstType.get("id").toString()));
                value = (Map)asstType.get("value");
                assItemInfo = new AssItemsForCashRecInfo();
                assItemInfo.setEntrySeq(i + 1);
                if (value != null) {
                    assItemInfo.setFromID(value.get("id").toString());
                    assItemInfo.setFromNumber(value.get("number").toString());
                }
                assItemInfo.setIsSelected(value != null);
                assItemInfo.setMappingFileds(asstTypeInfo.getMappingFieldName());
                assItemInfo.setTableName(asstTypeInfo.getRealtionDataObject());
                assItemInfo.setAsstActType(asstTypeInfo);
                entry.getAssItemsEntries().add(assItemInfo);
            }
            if (i != 0) continue;
            info.setOppAccount(entry.getOppAccount());
            for (j = 0; j < detail.size(); ++j) {
                asstType = (Map)detail.get(j);
                asstTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(asstType.get("id").toString()));
                value = (Map)asstType.get("value");
                assItemInfo = new AssItemsForCashRecInfo();
                assItemInfo.setEntrySeq(-99);
                if (value != null) {
                    assItemInfo.setFromID(value.get("id").toString());
                    assItemInfo.setFromNumber(value.get("number").toString());
                }
                assItemInfo.setIsSelected(value != null);
                assItemInfo.setMappingFileds(asstTypeInfo.getMappingFieldName());
                assItemInfo.setTableName(asstTypeInfo.getRealtionDataObject());
                assItemInfo.setAsstActType(asstTypeInfo);
                info.getAssItems().add(assItemInfo);
            }
        }
    }

    public Map getAssItems4Template(Context ctx, String templateReceivingBillId) throws BOSException, EASBizException {
        HashMap<String, Object> assgrp;
        HashMap allAssGrp = new HashMap();
        String sql = "select FAsstActTypeID as asstacttypeid, FFromID as fromid from T_CAS_AssItemsForTmplRec WHERE FParentID = '" + templateReceivingBillId + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (rowSet.size() > 0) {
            HashMap assgrp2 = new HashMap();
            allAssGrp.put(templateReceivingBillId, assgrp2);
            ArrayList<AsstActTypeInfo> details = new ArrayList<AsstActTypeInfo>();
            assgrp2.put("detail", details);
            try {
                while (rowSet.next()) {
                    AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("asstacttypeid")));
                    String id = rowSet.getString("fromid");
                    if (id != null && !id.equals("")) {
                        ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                        CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                        asstActTypeInfo.put("value", (Object)info);
                    }
                    details.add(asstActTypeInfo);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        sql = "select atr.FAsstActTypeID as asstacttypeid, atr.FentryParentID as entryparentid, atr.FFromID as fromid from T_CAS_AssItemsForTmplRec atr left outer join t_cas_TemplateRecBillEntry tre on tre.fid = atr.FentryParentID WHERE tre.FReceivingBillID = '" + templateReceivingBillId + "'";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                ArrayList<AsstActTypeInfo> details = null;
                String entryId = rowSet.getString("entryparentid");
                assgrp = (HashMap<String, Object>)allAssGrp.get(entryId);
                if (assgrp == null) {
                    assgrp = new HashMap<String, Object>();
                    allAssGrp.put(entryId, assgrp);
                    details = new ArrayList<AsstActTypeInfo>();
                    assgrp.put("detail", details);
                } else {
                    details = (ArrayList<AsstActTypeInfo>)assgrp.get("detail");
                }
                AsstActTypeInfo asstActTypeInfo = AsstActTypeFactory.getLocalInstance((Context)ctx).getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("asstacttypeid")));
                String id = rowSet.getString("fromid");
                if (id != null && !id.equals("")) {
                    ICoreBase valueInf = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)id).getType());
                    CoreBaseInfo info = valueInf.getValue((IObjectPK)new ObjectUuidPK(id));
                    asstActTypeInfo.put("value", (Object)info);
                }
                details.add(asstActTypeInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Object[] allAssGrps = allAssGrp.values().toArray();
        for (int i = 0; i < allAssGrps.length; ++i) {
            assgrp = (Map)allAssGrps[i];
            List details = (List)assgrp.get("detail");
            String displayName = "";
            for (int j = 0; j < details.size(); ++j) {
                CoreBaseInfo detailValue = (CoreBaseInfo)((AsstActTypeInfo)details.get(j)).get("value");
                if (detailValue == null) continue;
                displayName = detailValue.get("name") != null ? displayName + detailValue.get("name") + " | " : displayName + detailValue.get("name_" + LocaleUtils.getShortLocale((Locale)ctx.getLocale())) + " | ";
            }
            if (!displayName.equals("")) {
                displayName = displayName.substring(0, displayName.length() - 3);
            }
            assgrp.put("displayname", displayName);
        }
        return allAssGrp;
    }

    @Override
    public AccountBankInfo _getAccountBankInfo(Context ctx, String innerCompanyId) throws BOSException, EASBizException {
        AccountBankInfo accountBankInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)innerCompanyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)0, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.getSelector().add(new SelectorItemInfo("bankAccountNumber"));
        evi.getSelector().add(new SelectorItemInfo("bank.name"));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        evi.setSorter(sort);
        IAccountBank iAccountBank = AccountBankFactory.getRemoteInstance();
        AccountBankCollection accountBankColls = iAccountBank.getAccountBankCollection(evi);
        if (accountBankColls != null && accountBankColls.size() > 0) {
            accountBankInfo = accountBankColls.get(0);
        }
        return accountBankInfo;
    }

    @Override
    public SupplierInfo _getSupplierInfo(Context ctx, String supplierId) throws BOSException, EASBizException {
        SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo("select isInternalCompany,internalCompany.id where id = '" + supplierId + "'");
        return supplierInfo;
    }

    @Override
    public CustomerInfo _getCustomerInfo(Context ctx, String customerId) throws BOSException, EASBizException {
        CustomerInfo customerInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo("select isInternalCompany,internalCompany.id where id = '" + customerId + "'");
        return customerInfo;
    }
}

