/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.app.AbstractRptCapitalSumFacadeControllerBean;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.AmountUnitEnum;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMQuerySqlBuilder;
import com.kingdee.eas.framework.bireport.util.SchemaSource;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.DynamicRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class RptCapitalSumFacadeControllerBean
extends AbstractRptCapitalSumFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.RptCapitalSumFacadeControllerBean");
    private static final String resPath = "com.kingdee.eas.fm.common.FMResource";
    private static final String resPath2 = "com.kingdee.eas.fi.cas.CapitalVcSummaryResource";
    private static final String resPath3 = "com.kingdee.eas.fi.cas.CasResources";
    private String subTotal = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CapitalVcSummaryResource", (String)"subTotal", (Locale)this.getLocale());
    private String total = ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Outstanding_Amount", (Locale)this.getLocale());

    private Locale getLocale() {
        return ContextUtils.getLocaleFromEnv();
    }

    private String getString(String resName) {
        return ResourceBase.getString((String)resPath, (String)resName, (Locale)this.getLocale());
    }

    protected SchemaSource readySchemaSource(RptParams params, Context ctx) throws BOSException, EASBizException {
        this.subTotal = ResourceBase.getString((String)resPath2, (String)"subTotal", (Locale)this.getLocale());
        this.total = ResourceBase.getString((String)resPath3, (String)"Outstanding_Amount", (Locale)this.getLocale());
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        SchemaSource ss = new SchemaSource();
        ss.setCaller(this.getClass());
        boolean isByDay = (Boolean)params.getObject("isByDay");
        Set accountPropertyIdSet = (Set)params.getObject("accountPropertyIdSet");
        int amountUnit = ((AmountUnitEnum)params.getObjectElement("jtAmountUnit.value")).getValue();
        Set bankIdSet = (Set)params.getObject("bankIdSet");
        Set companyAllIdSet = (Set)params.getObject("companyIdSet");
        String currencyId = ((CurrencyInfo)params.getObjectElement("cboCurrency.value")).getId().toString();
        boolean includeCash = (Boolean)params.getObjectElement("chkIncudeCash.value");
        boolean isHideNoDataAcct = false;
        boolean isShowCancelUs = true;
        if (params.getObject("isHideNoDataAcct") != null) {
            isHideNoDataAcct = (Boolean)params.getObject("isHideNoDataAcct");
        }
        if (params.getObject("isShowCancelUs") != null) {
            isShowCancelUs = (Boolean)params.getObject("isShowCancelUs");
        }
        boolean forCompany = (Boolean)params.getObjectElement("jrbCompany.value");
        boolean forBank = (Boolean)params.getObjectElement("jrbBank.value");
        boolean forAccountProperty = (Boolean)params.getObjectElement("jrbAccountProperty.value");
        boolean forCompanyAcct = (Boolean)params.getObjectElement("jrbCompanyAcct.value");
        boolean forComProAcct = (Boolean)params.getObjectElement("jrbComProAcct.value");
        boolean forProComAcct = (Boolean)params.getObjectElement("jrbProComAcct.value");
        boolean forAcct = (Boolean)params.getObjectElement("jrbAccount.value");
        boolean forProAcct = (Boolean)params.getObjectElement("jrbProAcct.value");
        int groupType = 0;
        if (forCompany) {
            groupType = 1;
        }
        if (forBank) {
            groupType = 2;
        }
        if (forAccountProperty) {
            groupType = 3;
        }
        if (forCompanyAcct) {
            groupType = 4;
        }
        if (forComProAcct) {
            groupType = 5;
        }
        if (forProComAcct) {
            groupType = 6;
        }
        if (forAcct) {
            groupType = 7;
        }
        if (forProAcct) {
            groupType = 8;
        }
        int level = (Integer)params.getObjectElement("spiLevel.value");
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curCompany)) {
            level = 0;
        }
        if ((groupType == 2 || groupType == 3 || groupType == 4 || groupType == 5 || groupType == 6) && GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curCompany)) {
            int currLevel = curCompany.getLevel();
            level += currLevel - 1;
        }
        if (isByDay) {
            this.queryByDay(params, ctx, ss, accountPropertyIdSet, amountUnit, bankIdSet, companyAllIdSet, currencyId, includeCash, isHideNoDataAcct, isShowCancelUs, groupType, level);
        } else {
            this.queryByPeriod(params, ctx, ss, accountPropertyIdSet, amountUnit, bankIdSet, companyAllIdSet, currencyId, includeCash, isHideNoDataAcct, isShowCancelUs, groupType, level);
        }
        ss.setMacroValue("bankAccountCaption", this.getString("bankAccount"));
        ss.setMacroValue("bankAccountNumberCaption", ResourceBase.getString((String)resPath3, (String)"bankAccountNumber", (Locale)this.getLocale()));
        ss.setMacroValue("companyCaption", this.getString("company"));
        ss.setMacroValue("bankCaption", this.getString("bank"));
        ss.setMacroValue("periodCaption", this.getString("period"));
        ss.setMacroValue("amountCaption", this.getString("amount"));
        ss.setMacroValue("beginYearBalanceCaption", this.getString("beginYearBalance"));
        ss.setMacroValue("beginPeriodBalanceCaption", this.getString("beginPeriodBalance"));
        ss.setMacroValue("currentPeriodDebit", this.getString("currentPeriodDebit"));
        ss.setMacroValue("currentPeriodCredit", this.getString("currentPeriodCredit"));
        ss.setMacroValue("currentYearDebit", this.getString("currentYearDebit"));
        ss.setMacroValue("currentYearCredit", this.getString("currentYearCredit"));
        ss.setMacroValue("endPeriodBalance", this.getString("endPeriodBalance"));
        ss.setMacroValue("daystartamtCaption", this.getString("daystartamt"));
        ss.setMacroValue("debitamtCaption", this.getString("debitamt"));
        ss.setMacroValue("creditamtCaption", this.getString("creditamt"));
        ss.setMacroValue("dayendamtCaption", this.getString("dayendamt"));
        ss.setMacroValue("AccountPropertyCaption", this.getString("AccountProperty"));
        return ss;
    }

    private void queryByPeriod(RptParams params, Context ctx, SchemaSource ss, Set accountPropertyIdSet, int amountUnit, Set bankIdSet, Set companyAllIdSet, String currencyId, boolean includeCash, boolean isHideNoDataAcct, boolean isShowCancelUs, int groupType, int level) throws BOSException, EASBizException {
        FMQuerySqlBuilder sb;
        StringBuffer sbState = new StringBuffer();
        sbState.append("SELECT ss.fcompanyid , sp.fid spfid,sp.FPERIODYEAR*100 + sp.FPERIODNUMBER startperiod,cp.fid cpfid, cp.FPERIODYEAR*100 + cp.FPERIODNUMBER curPeriod ");
        sbState.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
        sbState.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
        sbState.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
        sbState.append(" and ss.fisstart=1");
        sbState.append(" and ");
        sbState.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companyAllIdSet.toArray()));
        int beginYear = (Integer)params.getObjectElement("spiBeginYear.value");
        int beginMonth = (Integer)params.getObjectElement("spiBeginMonth.value");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbState.toString());
        HashMap<String, HashSet<String>> otherCompany = new HashMap<String, HashSet<String>>();
        HashSet<String> okCompany = new HashSet<String>();
        HashSet<String> allCompany = new HashSet<String>();
        try {
            while (rs.next()) {
                Set<String> csSet;
                String pkey;
                int beginKey = beginYear * 100 + beginMonth;
                if (beginKey >= rs.getInt("startperiod") && beginKey <= rs.getInt("curPeriod")) {
                    okCompany.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                }
                if (beginKey > rs.getInt("curPeriod")) {
                    pkey = rs.getString("cpfid");
                    csSet = (HashSet<String>)otherCompany.get(pkey);
                    if (csSet == null) {
                        csSet = new HashSet<String>();
                        otherCompany.put(pkey, (HashSet<String>)csSet);
                    }
                    csSet.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                }
                if (beginKey >= rs.getInt("startperiod")) continue;
                pkey = rs.getString("spfid");
                csSet = (Set)otherCompany.get(pkey);
                if (csSet == null) {
                    csSet = new HashSet();
                    otherCompany.put(pkey, (HashSet<String>)csSet);
                }
                csSet.add(rs.getString("fcompanyid"));
                allCompany.add(rs.getString("fcompanyid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        int endYear = (Integer)params.getObjectElement("spiEndYear.value");
        int endMonth = (Integer)params.getObjectElement("spiEndMonth.value");
        CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        Object objectElement = params.getObject("txtSmallLimitAmt.numberValue");
        BigDecimal limit = null;
        limit = FMHelper.isEmpty((Object)objectElement) ? null : TypeConversionUtils.objToBigDecimal((Object)objectElement);
        String periodtypeId = curCompany.getAccountPeriodType().getId().toString();
        PeriodCollection periocColl = this.getPeriodColl(ctx, periodtypeId, beginYear, beginMonth, endYear, endMonth);
        String tbl = this.getTableTableName(ctx);
        this.checkCompanyForPeriodType(ctx, periodtypeId, okCompany);
        this.genBalance(ctx, tbl, okCompany, bankIdSet, periocColl, currencyId, isShowCancelUs);
        for (Map.Entry element : otherCompany.entrySet()) {
            String period = (String)element.getKey();
            Set otherCompanySet = (Set)element.getValue();
            PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period));
            PeriodCollection otherperiocColl = this.getPeriodColl(ctx, periodtypeId, periodInfo.getPeriodYear(), periodInfo.getPeriodNumber(), endYear, endMonth);
            if (otherperiocColl.size() == 0) continue;
            this.checkCompanyForPeriodType(ctx, periodtypeId, otherCompanySet);
            this.genBalance(ctx, tbl, otherCompanySet, bankIdSet, otherperiocColl, currencyId, isShowCancelUs);
        }
        FMQuerySqlBuilder rsFact = sb = this.genResult(ctx, amountUnit, groupType, includeCash, isHideNoDataAcct, level, curCompany, limit, tbl);
        ss.setDataItem("Fact", rsFact.getSql(), rsFact.getSqlParams());
        FMQuerySqlBuilder accountbankids = this.getIdSB(tbl, "FAccountBankId");
        if (!FMHelper.isEmpty((Collection)bankIdSet)) {
            accountbankids.appendSql(" where FAccountBankId in(select fid from T_BD_ACCOUNTBANKS where fbank in (" + this.newBuildIn(bankIdSet.toArray()) + ")");
        }
        ss.setDataItem("Period", RptCapitalSumFacadeControllerBean.getPeriodRowSet(ctx, AccessHelper.getIds((Object[])periocColl.toArray())), null);
        FMQuerySqlBuilder accountBankSb = RptCapitalSumFacadeControllerBean.getAccountBankSb(ctx, accountbankids, accountPropertyIdSet, true);
        ss.setDataItem("BankAccount", accountBankSb.getSql(), accountBankSb.getSqlParams());
        ss.setDataItem("AccountProperty", RptCapitalSumFacadeControllerBean.getPropertyRowSet(ctx, accountPropertyIdSet), null);
        HashSet<String> currencyIds = new HashSet<String>();
        currencyIds.add(currencyId);
        ss.setDataItem("Currency", RptCapitalSumFacadeControllerBean.getCurrencyRowSet(ctx, currencyIds), null);
        switch (groupType) {
            case 1: {
                ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, 0), null);
                ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, level), null);
                break;
            }
            case 2: {
                ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, level), null);
                ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, 0), null);
                break;
            }
            case 3: {
                ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, level), null);
                ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, 0), null);
                break;
            }
            default: {
                ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, 0), null);
                ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, level), null);
            }
        }
        this.setMDX_ByPeriod(ss, groupType, curCompany);
    }

    private void checkCompanyForPeriodType(Context ctx, String periodtypeId, Set companyIdSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)companyIdSet, CompareType.INCLUDE));
        CompanyOrgUnitCollection colls = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        for (int index = 0; index < colls.size(); ++index) {
            String currentType;
            CompanyOrgUnitInfo company = colls.get(index);
            if (company.getAccountPeriodType() == null || periodtypeId.equals(currentType = company.getAccountPeriodType().getId().toString())) continue;
            throw new CasException(CasException.PERIODTYPENOSAME);
        }
    }

    private void setMDX_ByPeriod(SchemaSource ss, int groupType, CompanyOrgUnitInfo curCompany) {
        StringBuffer mdx = new StringBuffer();
        mdx.append(" with ");
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curCompany)) {
            switch (groupType) {
                case 1: {
                    mdx.append("member  [Bank].[" + this.subTotal + "] as 'sum([Bank].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter( {[Period].members*{[Company].members*{[Bank].[" + this.subTotal + "],[Bank].members}}").append("},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and Bank.currentMember.name='" + this.subTotal + "')) on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_company_unit.xml");
                    break;
                }
                case 2: {
                    mdx.append("  member [Company].[" + this.subTotal + "] as 'sum([Company].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter( {[Period].members*{ [Bank].members*{[Company].[" + this.subTotal + "],[Company].members}}").append("},(isleaf([Bank].currentmember) or (not isleaf([Bank].currentmember)) and Company.currentMember.name='" + this.subTotal + "')) on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_bank_unit.xml");
                    break;
                }
                case 3: {
                    mdx.append("member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [Company].[" + this.subTotal + "] as 'sum([Company].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty {[Period].members*{[AccountProperty].[" + this.subTotal + "]*[Company].[" + this.subTotal + "],[AccountProperty].members*{[Company].[" + this.subTotal + "],[Company].members}}").append("} on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_acctProperty_unit.xml");
                    break;
                }
                case 5: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].levels(0).members)' member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter([Period].members* {[Company].[" + this.subTotal + "]*[AccountProperty].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*{[AccountProperty].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[AccountProperty].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members").append("}}},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "')) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_comProAcct_unit.xml");
                    break;
                }
                case 6: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].levels(0).members)' member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter([Period].members* {[AccountProperty].[" + this.subTotal + "]*[Company].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[AccountProperty].members*{[Company].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members}").append("}},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "' )) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_comProAcct_unit.xml");
                    break;
                }
                case 7: {
                    mdx.append("member [BankAccount].[" + this.total + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty ([Period].members* {[BankAccount].members ,[BankAccount].[" + this.total + "]}) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_account.xml");
                    break;
                }
                case 8: {
                    mdx.append(" member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" member [Period].[" + this.total + "] as 'sum([Period].members)' ");
                    mdx.append(" member [AccountProperty].[" + this.total + "] as 'sum([AccountProperty].members)' member [BankAccount].[" + this.total + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" select [Measures].members on columns,").append(" non empty {[Period].members*{[AccountProperty].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members},[AccountProperty].[" + this.total + "]*[BankAccount].[" + this.total + "]}} dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_proAcct_unit.xml");
                    break;
                }
                default: {
                    mdx.append("member   [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter([Period].members* [Company].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members").append("},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "' )) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_companyAcct_unit.xml");
                    break;
                }
            }
        } else {
            switch (groupType) {
                case 1: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({[Period].members*{[Company].[" + this.subTotal + "]*[Bank].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*[Bank].members *[BankAccount].members}").append("},(Bank.currentmember.name<>'" + this.subTotal + "' or Bank.currentMember.name='" + this.subTotal + "')) dimension properties BankAccount.[accountnumber] on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_company.xml");
                    break;
                }
                case 2: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].levels(0).members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].levels(0).members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({[Period].members*[Bank].members*[Company].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members}").append("},(isleaf([Bank].currentmember) and BankAccount.currentmember.name<>'" + this.subTotal + "') or ((not isleaf([Bank].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "')) dimension properties BankAccount.[accountnumber] on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_bank.xml");
                    break;
                }
                case 3: {
                    mdx.append("member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].members)'  member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({[Period].members*{[AccountProperty].[" + this.subTotal + "],[AccountProperty].members}* {[Bank].[" + this.subTotal + "] *[BankAccount].[" + this.subTotal + "] , [Bank].members* [BankAccount].members}").append("},(AccountProperty.currentmember.name<>'" + this.subTotal + "' or (AccountProperty.currentmember.name='" + this.subTotal + "' and Bank.currentmember.name='" + this.subTotal + "'))) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_acctProperty.xml");
                    break;
                }
                case 7: {
                    mdx.append("member [BankAccount].[" + this.total + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty ([Period].members* {[BankAccount].members ,[BankAccount].[" + this.total + "]}) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_account.xml");
                    break;
                }
                default: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({[Period].members*{[Company].[" + this.subTotal + "]*[Bank].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*[Bank].members *[BankAccount].members}").append("},(Bank.currentmember.name<>'" + this.subTotal + "' or Bank.currentMember.name='" + this.subTotal + "')) dimension properties BankAccount.[accountnumber] on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_company.xml");
                }
            }
        }
        ss.setMdx(mdx.toString());
    }

    private void queryByDay(RptParams params, Context ctx, SchemaSource ss, Set accountPropertyIdSet, int amountUnit, Set bankIdSet, Set companyAllIdSet, String currencyId, boolean includeCash, boolean isHideNoDataAcct, boolean isShowCancelUs, int groupType, int level) throws BOSException, EASBizException {
        try {
            FMQuerySqlBuilder sb;
            CompanyOrgUnitInfo curCompany = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
            Date fromDate = (Date)params.getObjectElement("dtpFromDate.value");
            Date toDate = (Date)params.getObjectElement("dtpToDate.value");
            PeriodInfo beginPeriodInfo = null;
            StringBuffer sbState = new StringBuffer();
            sbState.append("SELECT ss.fcompanyid , sp.fid spfid,sp.FPERIODYEAR*100 + sp.FPERIODNUMBER startperiod,cp.fid cpfid, cp.FPERIODYEAR*100 + cp.FPERIODNUMBER curPeriod ");
            sbState.append(" FROM t_bd_systemstatusctrol ss, t_bd_period sp, t_bd_period cp");
            sbState.append(" WHERE ss.fstartperiodid = sp.fid AND ss.fcurrentperiodid = cp.fid");
            sbState.append(" and ss.FSYSTEMSTATUSID in (select fid from t_bd_systemstatus  where fname =7)");
            sbState.append(" and ss.fisstart=1");
            sbState.append(" and ");
            sbState.append(FMHelper.buildIn((String)"ss.fcompanyid", (Object[])companyAllIdSet.toArray()));
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sbState.toString());
            HashMap<String, HashSet<String>> otherCompany = new HashMap<String, HashSet<String>>();
            HashSet<String> okCompany = new HashSet<String>();
            HashSet<String> allCompany = new HashSet<String>();
            try {
                while (rs.next()) {
                    if (beginPeriodInfo == null) {
                        String pkey = rs.getString("spfid");
                        HashSet<String> csSet = (HashSet<String>)otherCompany.get(pkey);
                        if (csSet == null) {
                            csSet = new HashSet<String>();
                            otherCompany.put(pkey, csSet);
                        }
                        csSet.add(rs.getString("fcompanyid"));
                        allCompany.add(rs.getString("fcompanyid"));
                        continue;
                    }
                    int beginKey = beginPeriodInfo.getPeriodYear() * 100 + beginPeriodInfo.getPeriodNumber();
                    if (beginKey >= rs.getInt("startperiod") && beginKey <= rs.getInt("curPeriod")) {
                        okCompany.add(rs.getString("fcompanyid"));
                        allCompany.add(rs.getString("fcompanyid"));
                    }
                    if (beginKey <= rs.getInt("curPeriod")) continue;
                    String pkey = rs.getString("cpfid");
                    HashSet<String> csSet = (HashSet<String>)otherCompany.get(pkey);
                    if (csSet == null) {
                        csSet = new HashSet<String>();
                        otherCompany.put(pkey, csSet);
                    }
                    csSet.add(rs.getString("fcompanyid"));
                    allCompany.add(rs.getString("fcompanyid"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            Object objectElement = params.getObject("txtSmallLimitAmt.numberValue");
            BigDecimal limit = null;
            limit = FMHelper.isEmpty((Object)objectElement) ? null : TypeConversionUtils.objToBigDecimal((Object)objectElement);
            String tbl = this.getTableTableNameByDate(ctx);
            this.genBalanceByDate(ctx, tbl, okCompany, bankIdSet, beginPeriodInfo, currencyId, fromDate, toDate, isShowCancelUs);
            Iterator iter = otherCompany.entrySet().iterator();
            Calendar cal = Calendar.getInstance();
            cal.setTime(toDate);
            int endYear = cal.get(1);
            int endMonth = cal.get(2) + 1;
            String periodtypeId = curCompany.getAccountPeriodType().getId().toString();
            while (iter.hasNext()) {
                Map.Entry element = iter.next();
                String period = (String)element.getKey();
                Set otherCompanySet = (Set)element.getValue();
                PeriodInfo periodInfo = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period));
                PeriodCollection otherperiocColl = this.getPeriodColl(ctx, periodtypeId, periodInfo.getPeriodYear(), periodInfo.getPeriodNumber(), endYear, endMonth);
                if (periodInfo == null || otherperiocColl.size() == 0) continue;
                this.genBalanceByDate(ctx, tbl, otherCompanySet, bankIdSet, periodInfo, currencyId, fromDate, toDate, isShowCancelUs);
            }
            FMQuerySqlBuilder rsFact = sb = this.genResultByDate(ctx, amountUnit, groupType, includeCash, isHideNoDataAcct, level, curCompany, limit, tbl);
            ss.setDataItem("Fact", rsFact.getSql(), rsFact.getSqlParams());
            FMQuerySqlBuilder accountbankids = this.getIdSB(tbl, "FAccountBankId");
            if (!FMHelper.isEmpty((Collection)bankIdSet)) {
                accountbankids.appendSql(" where FAccountBankId in(select fid from T_BD_ACCOUNTBANKS where fbank in (" + this.newBuildIn(bankIdSet.toArray()) + ")");
            }
            FMQuerySqlBuilder accountBankSb = RptCapitalSumFacadeControllerBean.getAccountBankSb(ctx, accountbankids, accountPropertyIdSet, true);
            ss.setDataItem("BankAccount", accountBankSb.getSql(), accountBankSb.getSqlParams());
            ss.setDataItem("AccountProperty", RptCapitalSumFacadeControllerBean.getPropertyRowSet(ctx, accountPropertyIdSet), null);
            HashSet<String> currencyIds = new HashSet<String>();
            currencyIds.add(currencyId);
            ss.setDataItem("Currency", RptCapitalSumFacadeControllerBean.getCurrencyRowSet(ctx, currencyIds), null);
            switch (groupType) {
                case 1: {
                    ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, 0), null);
                    ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, level), null);
                    break;
                }
                case 2: {
                    ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, level), null);
                    ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, 0), null);
                    break;
                }
                case 3: {
                    ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, level), null);
                    ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, 0), null);
                    break;
                }
                default: {
                    ss.setDataItem("Company", RptCapitalSumFacadeControllerBean.getCompanyRowSet(ctx, companyAllIdSet, 0), null);
                    ss.setDataItem("Bank", RptCapitalSumFacadeControllerBean.getBankRowSet(ctx, tbl, bankIdSet, includeCash, true, level), null);
                }
            }
            this.setMDX_byDate(ss, groupType, curCompany);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw e;
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }

    private void setMDX_byDate(SchemaSource ss, int groupType, CompanyOrgUnitInfo curCompany) {
        StringBuffer mdx = new StringBuffer();
        mdx.append(" with ");
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curCompany)) {
            switch (groupType) {
                case 1: {
                    mdx.append("member   [Bank].[" + this.subTotal + "] as 'sum([Bank].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter( {{[Company].members*{[Bank].[" + this.subTotal + "],[Bank].members}}").append("},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and Bank.currentMember.name='" + this.subTotal + "')) on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_company_bydate_unit.xml");
                    break;
                }
                case 2: {
                    mdx.append("member   [Company].[" + this.subTotal + "] as 'sum([Company].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter( {{ [Bank].members*{[Company].[" + this.subTotal + "],[Company].members}}").append("},(isleaf([Bank].currentmember) or (not isleaf([Bank].currentmember)) and Company.currentMember.name='" + this.subTotal + "')) on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_bank_bydate_unit.xml");
                    break;
                }
                case 3: {
                    mdx.append("member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [Company].[" + this.subTotal + "] as 'sum([Company].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty ({{[AccountProperty].[" + this.subTotal + "]*[Company].[" + this.subTotal + "],[AccountProperty].members*{[Company].[" + this.subTotal + "],[Company].members}}").append("}) on rows").append("\n from fm");
                    ss.setFilename("RptCapitalSum_acctProperty_bydate_unit.xml");
                    break;
                }
                case 5: {
                    mdx.append("member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [Company].[" + this.subTotal + "] as 'sum([Company].levels(0).members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter({[Company].[" + this.subTotal + "]*[AccountProperty].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*{[AccountProperty].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[AccountProperty].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members}}").append("},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "' ))  dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_comProAcct_bydate_unit.xml");
                    break;
                }
                case 6: {
                    mdx.append("member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [Company].[" + this.subTotal + "] as 'sum([Company].levels(0).members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter({[AccountProperty].[" + this.subTotal + "]*[Company].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[AccountProperty].members*{[Company].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members}}").append("},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "' )) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_comProAcct_bydate_unit.xml");
                    break;
                }
                case 7: {
                    mdx.append("member [BankAccount].[" + this.total + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" select [Measures].members on columns,").append("non empty {[BankAccount].members,[BankAccount].[" + this.total + "]}  dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_account_bydate.xml");
                    break;
                }
                case 8: {
                    mdx.append(" member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" member [AccountProperty].[" + this.total + "] as 'sum([AccountProperty].members)' member [BankAccount].[" + this.total + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" select [Measures].members on columns,").append(" non empty {[AccountProperty].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members},[AccountProperty].[" + this.total + "]*[BankAccount].[" + this.total + "]} dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_proAcct_bydate_unit.xml");
                    break;
                }
                default: {
                    mdx.append(" member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n  non empty filter( {{[Company].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members}}").append("},(isleaf([Company].currentmember) or (not isleaf([Company].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "' ))  dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_companyAcct_bydate_unit.xml");
                    break;
                }
            }
        } else {
            switch (groupType) {
                case 1: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({{[Company].[" + this.subTotal + "]*[Bank].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*[Bank].members *[BankAccount].members}").append("},(Bank.currentmember.name<>'" + this.subTotal + "' or Bank.currentMember.name='" + this.subTotal + "')) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_company_bydate.xml");
                    break;
                }
                case 2: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].levels(0).members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].levels(0).members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({[Bank].members*[Company].members*{[BankAccount].[" + this.subTotal + "],[BankAccount].members}").append("},(isleaf([Bank].currentmember) and BankAccount.currentmember.name<>'" + this.subTotal + "') or ((not isleaf([Bank].currentmember)) and BankAccount.currentMember.name='" + this.subTotal + "')) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_bank_bydate.xml");
                    break;
                }
                case 3: {
                    mdx.append("member [AccountProperty].[" + this.subTotal + "] as 'sum([AccountProperty].members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)' ");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({{[AccountProperty].[" + this.subTotal + "],[AccountProperty].members} * {[Bank].[" + this.subTotal + "] *[BankAccount].[" + this.subTotal + "] , [Bank].members* [BankAccount].members}").append("},(AccountProperty.currentmember.name<>'" + this.subTotal + "' or (AccountProperty.currentmember.name='" + this.subTotal + "' and Bank.currentmember.name='" + this.subTotal + "'))) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_acctProperty_bydate.xml");
                    break;
                }
                case 7: {
                    mdx.append("member [BankAccount].[" + this.total + "] as 'sum([BankAccount].members)'  ");
                    mdx.append(" select [Measures].members on columns,").append("non empty {[BankAccount].members, [BankAccount].[" + this.total + "]} dimension properties BankAccount.[accountnumber] on rows  ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_account_bydate.xml");
                    break;
                }
                default: {
                    mdx.append("member [Company].[" + this.subTotal + "] as 'sum([Company].members)' member [Bank].[" + this.subTotal + "] as 'sum([Bank].members)' member [BankAccount].[" + this.subTotal + "] as 'sum([BankAccount].members)'");
                    mdx.append(" select [Measures].members on columns,").append("\n non empty filter({{[Company].[" + this.subTotal + "]*[Bank].[" + this.subTotal + "]*[BankAccount].[" + this.subTotal + "],[Company].members*[Bank].members *[BankAccount].members}").append("},(Bank.currentmember.name<>'" + this.subTotal + "' or Bank.currentMember.name='" + this.subTotal + "')) dimension properties BankAccount.[accountnumber] on rows ").append("\n from fm");
                    ss.setFilename("RptCapitalSum_company_bydate.xml");
                }
            }
        }
        ss.setMdx(mdx.toString());
    }

    private FMQuerySqlBuilder genResult(Context ctx, int amountUnit, int groupType, boolean includeCash, boolean isHideNoDataAcct, int level, CompanyOrgUnitInfo curCompany, BigDecimal limit, String tbl) throws BOSException {
        this.prepareDate(ctx, groupType, level, tbl);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" SELECT isnull(jb.fcompanyid,'0') fcompanyid , jb.faccountviewid, jb.fcurrencyid, isnull(jb.faccountbankid,'0') faccountbankid,jb.fperiodid,");
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fyearstartamt", " fyearstartamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fmonthstartamt", " fmonthstartamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fmonthdebitamt", " fmonthdebitamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fmonthcreditamt", "fmonthcreditamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fmonthbalance", " fmonthbalance", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fyeardebitamt", " fyeardebitamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fyearcreditamt", " fyearcreditamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fyearbalance", " fyearbalance", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fdebitstartamt", " fdebitstartamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fcreditstartamt", " fcreditstartamt", amountUnit));
        sb.appendSql(" isnull(jb.FAccountPropertyID,'00') FAccountPropertyID,");
        sb.appendSql(" isnull(jb.fbankid,'00') fbankId");
        sb.appendSql(" FROM " + tbl + " jb ");
        sb.appendSql(" where 1=1");
        if (!includeCash) {
            sb.appendSql(" and jb.faccountbankid is not null");
        }
        if (isHideNoDataAcct) {
            sb.appendSql(" and (fyearstartamt <> 0 or fmonthstartamt <> 0 or fmonthdebitamt <> 0 or fmonthcreditamt <> 0 ");
            sb.appendSql(" or fmonthbalance <> 0 or fyeardebitamt <> 0 or fyearcreditamt <> 0 or fyearbalance <> 0 ");
            sb.appendSql(" or fdebitstartamt <> 0 or fcreditstartamt <> 0) ");
        }
        if (limit != null) {
            BigDecimal unitValue = new BigDecimal(String.valueOf(amountUnit));
            limit = limit.multiply(unitValue);
            sb.appendSql(" and  jb.fmonthbalance>=");
            sb.appendParam((Object)limit);
        }
        return sb;
    }

    private void prepareDate(Context ctx, int groupType, int level, String tbl) throws BOSException {
        String sql = "update " + tbl + " set (fbankid, FAccountPropertyID) = (select t_bd_accountbanks.fbank ,t_bd_accountbanks.FPropertyID from t_bd_accountbanks where t_bd_accountbanks.fid = " + tbl + ".faccountbankid)";
        DbUtil.execute((Context)ctx, (String)sql);
        String sqluplevel = null;
        if (level > 0) {
            switch (groupType) {
                case 1: {
                    sqluplevel = "update " + tbl + " set (fbankid,FKey) =(select p.fid,null from  t_bd_bank p, t_bd_bank c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fbankid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                case 2: {
                    sqluplevel = "update " + tbl + " set (fcompanyid,FKey) =(select p.fid, null from  t_org_company p, t_org_company c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fCompanyid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                case 3: {
                    sqluplevel = "update " + tbl + " set (fcompanyid,FKey) =(select p.fid, null from  t_org_company p, t_org_company c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fCompanyid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                    break;
                }
                default: {
                    sqluplevel = "update " + tbl + " set (fbankid,FKey) =(select p.fid,null from  t_bd_bank p, t_bd_bank c where charindex(p.flongnumber||'!',c.flongnumber)=1 and p.flevel =" + level + " and c.fid=" + tbl + ".fbankid)";
                    DbUtil.execute((Context)ctx, (String)sqluplevel);
                }
            }
        }
    }

    private FMQuerySqlBuilder genResultByDate(Context ctx, int amountUnit, int groupType, boolean includeCash, boolean isHideNoDataAcct, int level, CompanyOrgUnitInfo curCompany, BigDecimal limit, String tbl) throws BOSException {
        this.prepareDate(ctx, groupType, level, tbl);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" SELECT isnull(jb.fcompanyid,'0') fcompanyid , jb.faccountviewid, jb.fcurrencyid, isnull(jb.faccountbankid,'0') faccountbankid,");
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fdaystartamt", " fdaystartamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fdebitamt", " fdebitamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fcreditamt", " fcreditamt", amountUnit));
        sb.appendSql(RptCapitalSumFacadeControllerBean.appUnit(" jb.fdayendamt", "fdayendamt", amountUnit));
        sb.appendSql(" isnull(jb.FAccountPropertyID,'00') FAccountPropertyID,");
        sb.appendSql(" isnull(jb.fbankid,'00') fbankId");
        sb.appendSql(" FROM " + tbl + " jb ");
        sb.appendSql(" where 1=1");
        if (!includeCash) {
            sb.appendSql(" and jb.faccountbankid is not null");
        }
        if (isHideNoDataAcct) {
            sb.appendSql(" and (fdaystartamt <> 0 or fdebitamt <> 0 or fcreditamt <> 0  or fdayendamt <> 0)");
        }
        if (limit != null) {
            BigDecimal unitValue = new BigDecimal(String.valueOf(amountUnit));
            limit = limit.multiply(unitValue);
            sb.appendSql(" and  jb.fdayendamt>=");
            sb.appendParam((Object)limit);
        }
        System.out.println(sb.getTestSql());
        return sb;
    }

    private String getTableTableNameByDate(Context ctx) throws BOSException {
        String tbl = RptCapitalSumFacadeControllerBean.getTempTableName((String)"casbalance", (Context)ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("FCOMPANYID        varchar(44),");
        createTableSql.append("FKey        varchar(44),");
        createTableSql.append("FBANKID           varchar(44),");
        createTableSql.append("FACCOUNTVIEWID    varchar(44),");
        createTableSql.append("FAccountPropertyID    varchar(44),");
        createTableSql.append("FCURRENCYID       varchar(44),");
        createTableSql.append("FACCOUNTBANKID    varchar(44),");
        createTableSql.append("FPERIODID         varchar(44),");
        createTableSql.append("FDAYSTARTAMT       NUMERIC(19,4) ,");
        createTableSql.append("FDEBITAMT          NUMERIC(19,4),");
        createTableSql.append("FCREDITAMT         NUMERIC(19,4),");
        createTableSql.append("FDAYENDAMT         NUMERIC(19,4) ");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    private String getTableTableName(Context ctx) throws BOSException {
        String tbl = RptCapitalSumFacadeControllerBean.getTempTableName((String)"casbalance", (Context)ctx);
        StringBuffer createTableSql = new StringBuffer();
        createTableSql.append("CREATE TABLE ");
        createTableSql.append(tbl);
        createTableSql.append("\t(");
        createTableSql.append("FCOMPANYID        varchar(44),");
        createTableSql.append("FKey        varchar(44),");
        createTableSql.append("FBANKID           varchar(44),");
        createTableSql.append("FACCOUNTVIEWID    varchar(44),");
        createTableSql.append("FCURRENCYID       varchar(44),");
        createTableSql.append("FACCOUNTBANKID    varchar(44),");
        createTableSql.append("FAccountPropertyID    varchar(44),");
        createTableSql.append("FPERIODID         varchar(44),");
        createTableSql.append("FYEARSTARTAMT      NUMERIC(19,4) ,");
        createTableSql.append("FMONTHSTARTAMT     NUMERIC(19,4),");
        createTableSql.append("FMONTHDEBITAMT     NUMERIC(19,4),");
        createTableSql.append("FMONTHCREDITAMT    NUMERIC(19,4) ,");
        createTableSql.append("FYEARDEBITAMT      NUMERIC(19,4),");
        createTableSql.append("FYEARCREDITAMT     NUMERIC(19,4),");
        createTableSql.append("FMONTHBALANCE      NUMERIC(19,4),");
        createTableSql.append("FYEARBALANCE       NUMERIC(19,4),");
        createTableSql.append("FDEBITSTARTAMT     NUMERIC(19,4),");
        createTableSql.append("FCREDITSTARTAMT    NUMERIC(19,4)");
        createTableSql.append(")");
        TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createTableSql.toString());
        return tbl;
    }

    private PeriodCollection getPeriodColl(Context ctx, String periodtypeId, int beginYear, int beginMonth, int endYear, int endMonth) throws BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("select fid from t_bd_period A ");
        sb.append(" where A.FPERIODYEAR*100 + A.FPERIODNUMBER >=");
        sb.append(beginYear * 100 + beginMonth);
        sb.append(" and A.FPERIODYEAR*100 + A.FPERIODNUMBER  <=");
        sb.append(endYear * 100 + endMonth);
        sb.append(" and A.FTypeID='");
        sb.append(periodtypeId);
        sb.append("'");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INNER));
        ev.setFilter(filter);
        ev.getSorter().add(new SorterItemInfo("periodyear"));
        ev.getSorter().add(new SorterItemInfo("periodnumber"));
        PeriodCollection periocColl = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(ev);
        return periocColl;
    }

    private FMQuerySqlBuilder getIdSB(String tbl, String colName) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("select distinct ").appendSql(colName).appendSql(" from " + tbl);
        return sb;
    }

    private void genBalance(Context ctx, String tbl, Set companyIdSet, Set bankids, PeriodCollection periodIds, String currencyId, boolean isShowCancelUs) throws BOSException, EASBizException {
        if (companyIdSet.size() == 0) {
            return;
        }
        if (periodIds == null || periodIds.size() == 0) {
            return;
        }
        String beginPeriodId = periodIds.get(0).getId().toString();
        FMQuerySqlBuilder sbfirst = this.getFirstPeriod(ctx, companyIdSet, bankids, beginPeriodId, currencyId, tbl, isShowCancelUs);
        sbfirst.execute(ctx);
        for (int i = 1; i < periodIds.size(); ++i) {
            FMQuerySqlBuilder sbnext = this.getNextPeriod(ctx, companyIdSet, bankids, periodIds.get(i - 1).getId().toString(), periodIds.get(i).getId().toString(), currencyId, tbl, periodIds.get(i).getPeriodNumber() == 1, isShowCancelUs);
            sbnext.execute(ctx);
        }
    }

    private void genBalanceByDate(Context ctx, String tbl, Set companyIdSet, Set bankids, PeriodInfo periodId, String currencyId, Date fromDate, Date toDate, boolean isShowCancelUs) throws BOSException, SQLException {
        if (companyIdSet.size() == 0) {
            return;
        }
        if (periodId == null) {
            return;
        }
        FMQuerySqlBuilder sbfirst = this.getFirstPeriodByDate(ctx, companyIdSet, bankids, periodId, currencyId, tbl, fromDate, toDate, isShowCancelUs);
        sbfirst.execute(ctx);
    }

    public static String appUnit(String colName, String alia, int unit) {
        return colName + "/" + unit + " " + alia + ", ";
    }

    private FMQuerySqlBuilder getFirstPeriod(Context ctx, Set companyIdSet, Set bankids, String beginPeriodId, String currencyId, String tbl, boolean isShowCancelUs) throws EASBizException, BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid, fperiodid,");
        sb.appendSql(" fyearstartamt,fmonthstartamt,");
        sb.appendSql(" fmonthdebitamt, fmonthcreditamt, fmonthbalance,");
        sb.appendSql(" fyeardebitamt, fyearcreditamt, fyearbalance,");
        sb.appendSql(" fdebitstartamt,fcreditstartamt");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid,s.fperiodid, ");
        sb.appendSql(" SUM (s.fyearstartamt), SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt),  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance,");
        sb.appendSql("  SUM (s.fyeardebitamt),  SUM (s.fyearcreditamt),   SUM (s.fyearstartamt) + SUM (s.fyeardebitamt)   - SUM (s.fyearcreditamt) fyearbalance,");
        sb.appendSql("  SUM (s.fdebitstartamt), SUM (s.fcreditstartamt)");
        sb.appendSql("     FROM (SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid, jb.fperiodid,");
        sb.appendSql("                   jb.fyearstartamt, jb.fmonthstartamt,");
        sb.appendSql("\t\t\t\t  0 fmonthdebitamt, 0 fmonthcreditamt,0 fmonthbalance,");
        sb.appendSql("     \t\t\t   jb.fyeardebitamt -jb.fmonthdebitamt  fyeardebitamt , jb.fyearcreditamt - jb.fmonthcreditamt fyearcreditamt,jb.fyearbalance,");
        sb.appendSql("      \t\t\t   jb.fdebitstartamt, jb.fcreditstartamt");
        sb.appendSql("              FROM t_cas_journalbalance jb");
        sb.appendSql("              WHERE ftype in(1,2) and fisinit=0");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("           UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid, j.fperiodid,");
        sb.appendSql("                  0 fyearstartamt, 0 fmonthstartamt,");
        sb.appendSql("                  SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance,");
        sb.appendSql("                  SUM (fdebitamount) fyeardebitamt, SUM (fcreditamount) fyearcreditamt, 0 fyearbalance,");
        sb.appendSql("                  0 fdebitstartamt, 0 fcreditstartamt");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("             GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid, j.fperiodid");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, s.fperiodid");
        sb.appendSql(" UNION ");
        sb.appendSql(" select b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID ,b.fid, '" + beginPeriodId + "',");
        sb.appendSql(" 0 fyearstartamt, 0 fmonthstartamt, 0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance,");
        sb.appendSql(" 0 fyeardebitamt, 0 fyearcreditamt, 0 fyearbalance,   0 fdebitstartamt, 0 fcreditstartamt ");
        sb.appendSql(" from T_BD_ACCOUNTBANKS b  ");
        sb.appendSql(" left join t_cas_journal j  on j.faccountbankid=b.fid ");
        sb.appendSql(" left join t_cas_journalbalance jb on jb.faccountbankid=b.fid ");
        sb.appendSql(" left join T_BD_Period p on jb.FPERIODID  = p.FID  ");
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(beginPeriodId));
        sb.appendSql(" where (j.FACCOUNTBANKID is null or j.FCREATEDATE >{ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)period.getEndDate()).toString());
        sb.appendSql("})");
        sb.appendSql(" and (jb.FACCOUNTBANKID is null  or  p.FBEGINDATE >{ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)period.getBeginDate()).toString());
        sb.appendSql("})");
        sb.appendSql("and  b.FACCOUNTID in(select a.fid from T_BD_ACCOUNTVIEW a where a.FISBANK=1) and");
        if (!isShowCancelUs) {
            sb.appendSql(" b.fisclosed=0 and ");
        }
        sb.appendSql(" b.fopendate<={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)period.getEndDate()).toString());
        sb.appendSql("} ");
        sb.appendFilter("b.FCOMPANYID", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("b.FCURRENCYID", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        sb.appendSql(" GROUP BY b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID ,b.fid");
        return sb;
    }

    private FMQuerySqlBuilder getFirstPeriodByDate(Context ctx, Set companyIdSet, Set bankids, PeriodInfo beginPeriodId, String currencyId, String tbl, Date fromDate, Date toDate, boolean isShowCancelUs) {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid,");
        sb.appendSql(" fdaystartamt,fdebitamt,");
        sb.appendSql(" fcreditamt, fdayendamt ");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, ");
        sb.appendSql(" SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt), ");
        sb.appendSql("  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance ");
        sb.appendSql("  FROM (");
        sb.appendSql(" SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid,");
        sb.appendSql(" jb.fmonthstartamt,");
        sb.appendSql(" 0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthstartamt fmonthbalance ");
        sb.appendSql("  FROM t_cas_journalbalance jb inner join t_bd_period pd on pd.fid=jb.fperiodid ");
        sb.appendSql("  WHERE ftype in(1,2) and fisinit=0");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("pd.fnumber", FMHelper.asSet((String)("" + beginPeriodId.getNumber())), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  SUM (fdebitamount-fcreditamount) fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)beginPeriodId.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate < {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql("  UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid,");
        sb.appendSql("                  0 fmonthstartamt,");
        sb.appendSql("    0 fmonthdebitamt, 0 fmonthcreditamt, SUM (fdebitamount-fcreditamount) fmonthbalance ");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendSql(" and j.FCreateDate >={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)beginPeriodId.getBeginDate()).toString());
        sb.appendSql("} and j.FCreateDate <= {");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("}");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql(" GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid ");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid ");
        sb.appendSql(" UNION ");
        sb.appendSql(" select b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID ,b.fid,");
        sb.appendSql(" 0 fmonthstartamt,0 fmonthdebitamt,0 fmonthcreditamt,0 fmonthbalance ");
        sb.appendSql(" from T_BD_ACCOUNTBANKS b  ");
        sb.appendSql(" left join t_cas_journal j  on j.faccountbankid=b.fid ");
        sb.appendSql(" left join t_cas_journalbalance jb on jb.faccountbankid=b.fid ");
        sb.appendSql(" left join T_BD_Period p on jb.FPERIODID  = p.FID  ");
        sb.appendSql(" where (j.FACCOUNTBANKID is null or j.FCREATEDATE >{ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("})");
        sb.appendSql(" and (jb.FACCOUNTBANKID is null or p.FBEGINDATE >{ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)fromDate).toString());
        sb.appendSql("})");
        sb.appendSql(" and b.FACCOUNTID in(select a.fid from T_BD_ACCOUNTVIEW a where a.FISBANK=1) and");
        if (!isShowCancelUs) {
            sb.appendSql(" b.fisclosed=0 and ");
        }
        sb.appendSql(" b.fopendate<={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)toDate).toString());
        sb.appendSql("} ");
        sb.appendFilter("b.FCOMPANYID", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("b.FCURRENCYID", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        sb.appendSql(" GROUP BY b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID ,b.fid");
        return sb;
    }

    private FMQuerySqlBuilder getFirstPeriodM(Set companyIdSet, Set bankids, String beginPeriodId, String currencyId, String tbl) {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid, fperiodid,");
        sb.appendSql(" fyearstartamt,fmonthstartamt,");
        sb.appendSql(" fmonthdebitamt, fmonthcreditamt, fmonthbalance,");
        sb.appendSql(" fyeardebitamt, fyearcreditamt, fyearbalance,");
        sb.appendSql(" fdebitstartamt,fcreditstartamt");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid,s.fperiodid, ");
        sb.appendSql(" SUM (s.fyearstartamt), SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt),  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance,");
        sb.appendSql("  SUM (s.fyeardebitamt),  SUM (s.fyearcreditamt),   SUM (s.fyearstartamt) + SUM (s.fyeardebitamt)   - SUM (s.fyearcreditamt) fyearbalance,");
        sb.appendSql("  SUM (s.fdebitstartamt), SUM (s.fcreditstartamt)");
        sb.appendSql("     FROM (SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid, jb.fperiodid,");
        sb.appendSql("                   jb.fyearstartamt, jb.fmonthstartamt,");
        sb.appendSql("\t\t\t\t  0 fmonthdebitamt, 0 fmonthcreditamt,0 fmonthbalance,");
        sb.appendSql("     \t\t\t   jb.fyeardebitamt, jb.fyearcreditamt,jb.fyearbalance,");
        sb.appendSql("      \t\t\t   jb.fdebitstartamt, jb.fcreditstartamt");
        sb.appendSql("              FROM t_cas_journalbalance jb");
        sb.appendSql("              WHERE ftype in(1,2) and fisinit=0");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1 and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR jb.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql("           UNION");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid, j.fperiodid,");
        sb.appendSql("                  0 fyearstartamt, 0 fmonthstartamt,");
        sb.appendSql("                  SUM (fdebitamount) fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance,");
        sb.appendSql("                  SUM (fdebitamount) fyeardebitamt, SUM (fcreditamount) fyearcreditamt, 0 fyearbalance,");
        sb.appendSql("                  0 fdebitstartamt, 0 fcreditstartamt");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("                                              SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("                                              WHERE 1=1  and fisclosed=0");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("                                              )");
            sb.appendSql("                        OR j.faccountbankid IS NULL");
            sb.appendSql("                       )");
        }
        sb.appendSql("             GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid, j.fperiodid");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, s.fperiodid");
        return sb;
    }

    private FMQuerySqlBuilder getNextPeriod(Context ctx, Set companyIdSet, Set bankids, String beginPeriodId, String nextPeriodId, String currencyId, String tbl, boolean isyear, boolean isShowCancelUs) throws EASBizException, BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("insert into ");
        sb.appendSql(tbl);
        sb.appendSql(" (");
        sb.appendSql(" fcompanyid, faccountviewid, fcurrencyid, faccountbankid, fperiodid,");
        sb.appendSql(" fyearstartamt,fmonthstartamt,");
        sb.appendSql(" fmonthdebitamt, fmonthcreditamt,fmonthbalance,");
        sb.appendSql(" fyeardebitamt, fyearcreditamt, fyearbalance,");
        sb.appendSql(" fdebitstartamt,fcreditstartamt");
        sb.appendSql(" )");
        sb.appendSql(" SELECT   s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid,'" + nextPeriodId + "', ");
        sb.appendSql(" SUM (s.fyearstartamt), SUM (s.fmonthstartamt),");
        sb.appendSql("  SUM (s.fmonthdebitamt), SUM (s.fmonthcreditamt),  SUM (s.fmonthstartamt) + SUM (s.fmonthdebitamt) - SUM (s.fmonthcreditamt) fmonthbalance,");
        sb.appendSql("  SUM (s.fyeardebitamt),  SUM (s.fyearcreditamt),   SUM (s.fyearstartamt) + SUM (s.fyeardebitamt)   - SUM (s.fyearcreditamt) fyearbalance,");
        sb.appendSql("  SUM (s.fdebitstartamt), SUM (s.fcreditstartamt)");
        sb.appendSql("     FROM (SELECT  jb.fcompanyid, jb.faccountviewid, jb.fcurrencyid, jb.faccountbankid, jb.fperiodid,");
        if (isyear) {
            sb.appendSql("                   jb.fmonthbalance fyearstartamt,jb.fmonthbalance  fmonthstartamt,");
            sb.appendSql("\t\t\t\t  0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthbalance,");
            sb.appendSql("     \t\t\t  0 fyeardebitamt, 0 fyearcreditamt,0 fyearbalance,");
        } else {
            sb.appendSql("                   jb.fyearstartamt fyearstartamt,jb.fmonthbalance  fmonthstartamt,");
            sb.appendSql("\t\t\t\t  0 fmonthdebitamt, 0 fmonthcreditamt,jb.fmonthbalance,");
            sb.appendSql("     \t\t\t   jb.fyeardebitamt, jb.fyearcreditamt,jb.fyearbalance,");
        }
        sb.appendSql("      \t\t\t   jb.fdebitstartamt, jb.fcreditstartamt");
        sb.appendSql("              FROM " + tbl + " jb");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendFilter("jb.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("jb.fperiodid", FMHelper.asSet((String)beginPeriodId), CompareType.INCLUDE);
        sb.appendFilter("jb.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( jb.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR jb.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("           UNION ALL");
        sb.appendSql("           SELECT j.fcompanyid, j.faccountviewid, j.fcurrencyid,j.faccountbankid, j.fperiodid,");
        sb.appendSql("                  0 fyearstartamt, 0 fmonthstartamt,");
        sb.appendSql("                  SUM (fdebitamount)  fmonthdebitamt, SUM (fcreditamount) fmonthcreditamt, 0 fmonthbalance,");
        sb.appendSql("                  SUM (fdebitamount)  fyeardebitamt,  SUM (fcreditamount) fyearcreditamt, 0 fyearbalance,");
        sb.appendSql("                  0 fdebitstartamt, 0 fcreditstartamt");
        sb.appendSql("             FROM t_cas_journal j");
        sb.appendSql("              WHERE 1=1 ");
        sb.appendFilter("j.fcompanyid", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("j.fperiodid", FMHelper.asSet((String)nextPeriodId), CompareType.INCLUDE);
        sb.appendFilter("j.fcurrencyid", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        if (bankids != null && bankids.size() > 0) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendFilter("fbank", bankids, CompareType.INCLUDE);
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        } else if (!isShowCancelUs) {
            sb.appendSql("                  AND ( j.faccountbankid IN (");
            sb.appendSql("        SELECT fid FROM t_bd_accountbanks ");
            sb.appendSql("            WHERE 1=1 ");
            sb.appendSql(isShowCancelUs ? " " : " and fisclosed=0 ");
            sb.appendSql("  )");
            sb.appendSql("     OR j.faccountbankid IS NULL");
            sb.appendSql("     )");
        }
        sb.appendSql("             GROUP BY j.fcompanyid, j.faccountviewid, j.fcurrencyid, j.faccountbankid, j.fperiodid");
        sb.appendSql(" \t\t  ) s");
        sb.appendSql(" GROUP BY s.fcompanyid, s.faccountviewid, s.fcurrencyid, s.faccountbankid, s.fperiodid");
        sb.appendSql(" UNION ");
        sb.appendSql(" select b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID ,b.fid, '" + nextPeriodId + "',");
        sb.appendSql(" 0 fyearstartamt, 0 fmonthstartamt, 0 fmonthdebitamt, 0 fmonthcreditamt, 0 fmonthbalance,");
        sb.appendSql(" 0 fyeardebitamt, 0 fyearcreditamt, 0 fyearbalance,   0 fdebitstartamt, 0 fcreditstartamt ");
        sb.appendSql(" from T_BD_ACCOUNTBANKS b  ");
        sb.appendSql(" left join t_cas_journal j  on j.faccountbankid=b.fid ");
        sb.appendSql(" left join t_cas_journalbalance jb on jb.faccountbankid=b.fid ");
        sb.appendSql(" left join T_BD_Period p on jb.FPERIODID  = p.FID  ");
        sb.appendSql(" where (j.FACCOUNTBANKID is null or j.FCREATEDATE >{ ");
        PeriodInfo nextPeriod = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(nextPeriodId));
        sb.appendSql(TypeConversionUtils.objToDate((Object)nextPeriod.getEndDate()).toString());
        sb.appendSql("})");
        sb.appendSql(" and (jb.FACCOUNTBANKID is null or p.FBEGINDATE >{ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)nextPeriod.getBeginDate()).toString());
        sb.appendSql("})");
        sb.appendSql(" and b.FACCOUNTID in(select a.fid from T_BD_ACCOUNTVIEW a where a.FISBANK=1) and");
        if (!isShowCancelUs) {
            sb.appendSql(" b.fisclosed=0 and ");
        }
        sb.appendSql(" b.fopendate<={ ");
        sb.appendSql(TypeConversionUtils.objToDate((Object)nextPeriod.getEndDate()).toString());
        sb.appendSql("} ");
        sb.appendFilter("b.FCOMPANYID", companyIdSet, CompareType.INCLUDE);
        sb.appendFilter("b.FCURRENCYID", FMHelper.asSet((String)currencyId), CompareType.INCLUDE);
        sb.appendSql(" GROUP BY b.FCOMPANYID ,b.FACCOUNTID ,b.FCURRENCYID ,b.fid");
        return sb;
    }

    public static ResultSet getAccountBankRowSet(Context ctx, Set ids, boolean hasEmpty) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        if (hasEmpty) {
            sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"470_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        sb.appendSql(" select A.FID, A.FNAME_" + loc + "  FName from t_bd_accountbanks A where 1=1 and fisclosed=0");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        ResultSet rs = sb.exeQuery(ctx);
        logger.info((Object)("----------" + sb.getSql() + "-------------"));
        return rs;
    }

    public static FMQuerySqlBuilder getAccountBankSb(Context ctx, FMQuerySqlBuilder ids, Set accountPropertyIdSet, boolean hasEmpty) throws BOSException {
        String rule = null;
        StringBuffer aBankDataBuffer = new StringBuffer();
        ResultSet rs = ids.exeQuery(ctx);
        TreeSet<String> idSet = new TreeSet<String>();
        try {
            while (rs.next()) {
                if (rs.getString(1) == null) continue;
                idSet.add(rs.getString(1));
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        rule = CashHelper.getAccBankPermissionRule(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        try {
            if (rule != null) {
                evi = new EntityViewInfo(rule);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                AccountBankCollection acctBankCol = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
                Iterator acctBankIt = acctBankCol.iterator();
                while (acctBankIt.hasNext()) {
                    AccountBankInfo accountBankInfo = (AccountBankInfo)acctBankIt.next();
                    if (!idSet.contains(accountBankInfo.getId().toString())) continue;
                    aBankDataBuffer.append("'");
                    aBankDataBuffer.append(accountBankInfo.getId().toString());
                    aBankDataBuffer.append("'");
                    if (!acctBankIt.hasNext()) continue;
                    aBankDataBuffer.append(",");
                }
                if (aBankDataBuffer.length() > 0 && aBankDataBuffer.charAt(aBankDataBuffer.length() - 1) == ',') {
                    aBankDataBuffer.deleteCharAt(aBankDataBuffer.length() - 1);
                }
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
        FMQuerySqlBuilder rstSb = new FMQuerySqlBuilder();
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        if (hasEmpty) {
            rstSb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"85_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        rstSb.appendSql(" select A.FID,  A.FNAME_" + loc + " FName, A.FbankAccountNumber FbankAccountNumber  from t_bd_accountbanks A ,T_BD_AccountProperty B where 1=1");
        if (rule != null) {
            rstSb.appendSql(" and ");
            if (aBankDataBuffer.toString().equals("")) {
                rstSb.appendSql("A.fid in (''");
            } else {
                rstSb.appendSql("A.fid in (" + aBankDataBuffer.toString());
            }
            rstSb.appendSql(") ");
        } else {
            rstSb.appendSql(" and ");
            rstSb.appendSql("A.fid in (" + ids.getSql());
            rstSb.appendSql(") ");
        }
        rstSb.appendSql("and  ");
        rstSb.appendSql(" B.fid=A.FPropertyId");
        if (!FMHelper.isEmpty((Collection)accountPropertyIdSet)) {
            rstSb.appendSql(" and ");
            rstSb.appendParam("A.FPropertyId", accountPropertyIdSet.toArray());
        }
        logger.info((Object)("----------" + rstSb.getSql() + "-------------"));
        rstSb.addParams(ids.getParamaters().toArray());
        return rstSb;
    }

    private static String getAccountBankPropertyEnumName(String FeildName) {
        StringBuffer sql = new StringBuffer();
        List list = AccountBankPropertyEnum.getEnumList();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                sql.append(" case ");
            }
            AccountBankPropertyEnum enumValue = (AccountBankPropertyEnum)list.get(i);
            int enumIntValue = enumValue.getValue();
            String enumStringValue = enumValue.toString();
            sql.append("  when " + FeildName + "=" + enumIntValue + " then  '" + enumStringValue + "'");
        }
        if (list.size() > 1) {
            sql.append(" end ");
        }
        return sql.toString();
    }

    public static String getPeriodRowSet(Context ctx, Set ids) throws BOSException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, to_char(A.FPERIODYEAR)||'-'||to_char(A.FPERIODNUMBER) FName ,A.FPERIODYEAR*100 +A.FPERIODNUMBER FOrder from t_bd_period A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        return sb.getTestSql();
    }

    public static RowSet createSelfDimension(ResultSet rsFact, String key) throws BOSException {
        DynamicRowSet drs;
        try {
            drs = new DynamicRowSet(4);
            drs.setColInfo(1, "fid", "id", 1, null);
            drs.setColInfo(2, "fname", "name", 12, null);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (rsFact == null) {
            return drs;
        }
        HashSet<String> set = new HashSet<String>();
        try {
            rsFact.beforeFirst();
            while (rsFact.next()) {
                set.add(rsFact.getString(key));
            }
            for (String val : set) {
                drs.insertRow();
                drs.updateString(1, val);
                drs.updateString(2, val);
            }
            rsFact.beforeFirst();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return drs;
    }

    public static String getCompanyRowSet(Context ctx, Set ids, int level) throws BOSException {
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName, A.FParentID from t_org_company  A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        if (level > 0) {
            sb.appendSql(" and  A.FLevel<=");
            sb.appendParam((Object)new Integer(level));
        }
        return sb.getTestSql();
    }

    public static String getPropertyRowSet(Context ctx, Set ids) throws BOSException {
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"86_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName  from T_BD_AccountProperty  A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        return sb.getTestSql();
    }

    public static FMQuerySqlBuilder getCompanySb(Context ctx, FMQuerySqlBuilder ids) throws BOSException {
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNumber, A.FName_" + loc + " FName, A.FParentID from t_org_company  A where 1=1 ");
        sb.appendSql(" and ");
        sb.appendSql("A.fid in ( ").appendSql(ids.getSql());
        sb.appendSql(")");
        sb.addParams(ids.getParamaters().toArray());
        return sb;
    }

    public static String getCurrencyRowSet(Context ctx, Set ids) throws BOSException {
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql(" select A.FID, A.FNAME_" + loc + "  FName from t_bd_currency A where 1=1 ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        return sb.getTestSql();
    }

    public static String getBankRowSet(Context ctx, String tbl, Set ids, boolean hasEmpty, boolean hasParent, int level) throws BOSException {
        String loc = RptCapitalSumFacadeControllerBean.getLoc((Context)ctx);
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        if (hasEmpty) {
            sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"87_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
            sb.appendSql(" ");
            sb.appendSql(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"88_CashManagementNewFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        if (hasParent) {
            sb.appendSql(" select distinct P.FID, P.FNAME_" + loc + " FNAME , isnull(P.FParentID,'0')  FParentID ");
            sb.appendSql(" from t_bd_Bank A, t_bd_Bank P where ( charindex( P.flongnumber,A.flongnumber)=1");
            sb.appendSql(" and charindex('!', right(A.flongnumber, length(A.flongnumber) - length(P.flongnumber))) = 1");
            sb.appendSql("  or ");
            sb.appendSql(" P.fid = A.fid)");
        } else {
            sb.appendSql(" select distinct A.FID, A.FNAME_" + loc + " FNAME , isnull( A.FParentID,'0')  FParentID from t_bd_Bank A where 1=1 ");
        }
        sb.appendSql(" and A.fid in ( select fbankid from " + tbl + " ) ");
        if (!FMHelper.isEmpty((Collection)ids)) {
            sb.appendSql(" and ");
            sb.appendParam("A.fid", ids.toArray());
        }
        if (level > 0) {
            sb.appendSql(" and P.flevel<=");
            sb.appendParam((Object)new Integer(level));
        }
        return sb.getTestSql();
    }

    private String newBuildIn(Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        for (int i = 0; i < set.length; ++i) {
            if (i == set.length - 1) {
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                continue;
            }
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

