/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.analysis.bicomponent.ComponentConfig;
import com.kingdee.bos.ctrl.analysis.olap.Filter;
import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.analysis.olap.ModelFactory;
import com.kingdee.bos.ctrl.analysis.olap.OlapException;
import com.kingdee.bos.ctrl.analysis.olap.OlapModel;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Member;
import com.kingdee.bos.ctrl.analysis.olapadapter.kingdeeolap.KDOLAP_Position;
import com.kingdee.bos.olap.Connection;
import com.kingdee.bos.olap.OLAPException;
import com.kingdee.bos.olap.remoting.RemoteConnection;
import com.kingdee.bos.olap.remoting.RemoteInvoke;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IRptCapitalSumFacade;
import com.kingdee.eas.fi.cas.RptCapitalSumFacadeFactory;
import com.kingdee.eas.fi.cas.app.AbstractRptCapitalSumWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.utils.BirtBaseRemoteInvokeAdapter;
import com.kingdee.eas.fi.cas.vo.RptCapitalSumVO;
import com.kingdee.eas.framework.bireport.IBireportBaseFacade;
import com.kingdee.eas.framework.bireport.util.OlapParams;
import com.kingdee.eas.framework.report.util.RptParams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class RptCapitalSumWebFacadeControllerBean
extends AbstractRptCapitalSumWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.RptCapitalSumWebFacadeControllerBean");

    @Override
    protected Map _getRptData(Context ctx, RptParams params) throws BOSException, EASBizException {
        HashMap<String, List<RptCapitalSumVO>> pageModel = new HashMap<String, List<RptCapitalSumVO>>();
        params.setObject("OLAP_KEY_PK", (Object)ctx.getCaller());
        params.setBoolean("OLAP_KEY_SHOULDCLOSEFIRST", true);
        params.setString("PERMISSION_PARAM_ORG_ID", ((CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company)).getId().toString());
        params.setString("PERMISSION_PARAM_USER_ID", ctx.getCaller().toString());
        params.setBoolean("useNonEmpty", false);
        params.setBoolean("nonEmptyForRow", ComponentConfig.getConfig().nonEmptyForRow);
        params.setBoolean("nonEmptyForColumn", ComponentConfig.getConfig().nonEmptyForColumn);
        IRptCapitalSumFacade facade = RptCapitalSumFacadeFactory.getLocalInstance(ctx);
        OlapParams olapParams = facade.etlModel(params, true, facade.hashCode());
        try {
            RemoteConnection con = new RemoteConnection((RemoteInvoke)new BirtBaseRemoteInvokeAdapter((IBireportBaseFacade)facade, this.hashCode()), false);
            con.setDefaultCubeName(olapParams.getDefaultCubeName());
            con.setSr(olapParams.getSchemaReader());
            olapParams.setConnection((Connection)con);
            OlapModel model = this.makeModel(olapParams);
            model.setMdxResult(olapParams.getResult());
            List<RptCapitalSumVO> listVo = this.fillData(model);
            pageModel.put("queryTable", listVo);
        }
        catch (OlapException e) {
            throw new BOSException(e.getMessage());
        }
        catch (OLAPException e) {
            throw new BOSException(e.getMessage());
        }
        return pageModel;
    }

    private List<RptCapitalSumVO> fillData(OlapModel model) {
        ArrayList<RptCapitalSumVO> listVo = new ArrayList<RptCapitalSumVO>();
        try {
            List rows = model.getResult().getRowAxis().getPositions();
            for (int i = 0; i < rows.size(); ++i) {
                KDOLAP_Position rowPosition = (KDOLAP_Position)rows.get(i);
                KDOLAP_Member[] members = (KDOLAP_Member[])rowPosition.getMembers();
                RptCapitalSumVO vo = new RptCapitalSumVO();
                for (int j = 0; j < members.length; ++j) {
                    String name = members[j].getDimension().getName();
                    String caption = model.lookupMember(members[j].getUniqueName()).getCaption();
                    String key = (String)members[j].getKey();
                    if (name.equals("Period")) {
                        if (!EmptyUtil.isEmpty((String)key)) {
                            vo.setPeriodId(key);
                        }
                        vo.setPeriodCaption(caption);
                        continue;
                    }
                    if (name.equals("Company")) {
                        if (!EmptyUtil.isEmpty((String)key)) {
                            vo.setCompanyId(key);
                        }
                        vo.setCompanyCaption(caption);
                        continue;
                    }
                    if (name.equals("Bank")) {
                        if (!EmptyUtil.isEmpty((String)key)) {
                            vo.setBankId(key);
                        }
                        vo.setBankCaption(caption);
                        continue;
                    }
                    if (name.equals("BankAccount")) {
                        if (!EmptyUtil.isEmpty((String)key)) {
                            vo.setBankAccountId(key);
                        }
                        vo.setBankAccountCaption(caption);
                        vo.setBankAccountNumberCaption(members[j].getProperty("accountnumber").getValue());
                        continue;
                    }
                    if (!name.equals("AccountProperty")) continue;
                    if (!EmptyUtil.isEmpty((String)key)) {
                        vo.setAccountPropertyId(key);
                    }
                    vo.setAccountPropertyCaption(caption);
                }
                Member[] colMembers = model.getMeasures();
                for (int k = 0; k < colMembers.length; ++k) {
                    String name = colMembers[k].getName();
                    BigDecimal val = (BigDecimal)model.getResult().getCell(k, i).getValue();
                    if (name.equals("FBeginYearBanalce")) {
                        vo.setBeginYearBalanceCaption(val);
                        continue;
                    }
                    if (name.equals("FBeginMounthBalance")) {
                        vo.setBeginPeriodBalanceCaption(val);
                        continue;
                    }
                    if (name.equals("FMonthDebit")) {
                        vo.setCurrentPeriodDebit(val);
                        continue;
                    }
                    if (name.equals("FMonthCredit")) {
                        vo.setCurrentPeriodCredit(val);
                        continue;
                    }
                    if (name.equals("FYearDebit")) {
                        vo.setCurrentYearDebit(val);
                        continue;
                    }
                    if (name.equals("FYearCredit")) {
                        vo.setCurrentYearCredit(val);
                        continue;
                    }
                    if (name.equals("FEndBMounth")) {
                        vo.setEndPeriodBalance(val);
                        continue;
                    }
                    if (name.equals("fdaystartamt")) {
                        vo.setDayStartAmtCaption(val);
                        continue;
                    }
                    if (name.equals("fdebitamt")) {
                        vo.setDebitAmtCaption(val);
                        continue;
                    }
                    if (name.equals("fcreditamt")) {
                        vo.setCreditAmtCaption(val);
                        continue;
                    }
                    if (!name.equals("fdayendamt")) continue;
                    vo.setDayEndAmtCaption(val);
                }
                listVo.add(vo);
            }
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        return listVo;
    }

    private OlapModel makeModel(OlapParams olapParams) {
        String mdx = olapParams.getMdx();
        String filter = olapParams.getFiltString();
        OlapModel model = null;
        try {
            model = ModelFactory.makeKDOlapModel((Connection)olapParams.getConnection(), (String)mdx);
            if (filter != null && filter.trim().length() > 0) {
                ((Filter)model.getExtension("filter")).setCondition(filter);
            }
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        return model;
    }
}

