/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.TemplateReceivingBillInfo;
import com.kingdee.eas.fi.cas.app.AbstractTemplateReceivingBillControllerBean;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.AbstractCoreBaseControllerBean;
import org.apache.log4j.Logger;

public class TemplateReceivingBillControllerBean
extends AbstractTemplateReceivingBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.TemplateReceivingBillControllerBean");

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number != null && number.length() > 0) {
            this._checkNumberDup(ctx, model);
        }
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number != null && number.length() > 0) {
            this._checkNumberDup(ctx, model);
        }
        return super._save(ctx, model);
    }

    private void checkNumberDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{model.getString("number")});
        }
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.initAndCheckNumber(ctx, model);
        return super._addnew(ctx, model);
    }

    private void initAndCheckNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TemplateReceivingBillInfo info = (TemplateReceivingBillInfo)model;
        FMHelper.initNumber((Context)ctx, (BillBaseInfo)info, (AbstractCoreBaseControllerBean)this);
        this._checkNumberDup(ctx, model);
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        String number = model.getString("number");
        if (number == null || number.length() <= 0) {
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        model.setString("number", number.trim());
        FilterInfo filter = FMHelper.getCheckNumberDupFilter((IObjectValue)model, (boolean)true);
        if (this._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{model.getString("number"), ""});
        }
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        TemplateReceivingBillInfo info = this.getTemplateReceivingBillInfo(ctx, pk, this.getSelector());
        if (info.getNumber() != null && info.getNumber().trim().length() > 0) {
            FMHelper.recycleNumber((Context)ctx, (CoreBaseInfo)info, (String)info.getCompany().getId().toString());
        }
        super._delete(ctx, pk);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payeeBank.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("bizType.*"));
        return sic;
    }
}

