/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.ISQLDataAccess;
import com.kingdee.bos.dao.query.server.SQLDataAccessFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.management.LanguageCollection;
import com.kingdee.bos.metadata.management.SolutionInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.bos.service.message.agent.SenderAgent;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AutoGenerateRuleCollection;
import com.kingdee.eas.fi.cas.AutoGenerateRuleFactory;
import com.kingdee.eas.fi.cas.AutoGenerateRuleInfo;
import com.kingdee.eas.fi.cas.BillTypeCollection;
import com.kingdee.eas.fi.cas.BillTypeFactory;
import com.kingdee.eas.fi.cas.BillTypeInfo;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.EnableStatusEnum;
import com.kingdee.eas.fi.cas.FilterTypeEnum;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentFailReasonEnum;
import com.kingdee.eas.fi.cas.PaymentReportCollection;
import com.kingdee.eas.fi.cas.PaymentReportFactory;
import com.kingdee.eas.fi.cas.PaymentReportInfo;
import com.kingdee.eas.fi.cas.PaymentStateEnum;
import com.kingdee.eas.fi.cas.SubSystemItem;
import com.kingdee.eas.fi.cas.UnPaidFilterCollection;
import com.kingdee.eas.fi.cas.UnPaidFilterFactory;
import com.kingdee.eas.fi.cas.UnPaidFilterInfo;
import com.kingdee.eas.fi.cas.app.AbstractUnPaidBillCenterFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.IUnPaidBillID;
import com.kingdee.eas.fi.cas.app.botp.BOTPTransmitRecorderForBillAndRules;
import com.kingdee.eas.fi.cas.app.botp.CasBotpUtil;
import com.kingdee.eas.fi.cas.app.botp.NoRuleRecorder;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnPaidBillCenterFacadeControllerBean
extends AbstractUnPaidBillCenterFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.UnPaidBillCenterFacadeControllerBean");
    protected static final String PAYMENTBILLTYPE = "40284E81";
    private static final String PAYMENTBILLADDNEWPERM = "cas_paymentbill_02addNew";

    @Override
    protected int _getPaidCount(Context ctx, CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo, int subSystemValue) throws BOSException, EASBizException {
        String sql = this.getPaidCountSql(ctx, companyColl, periodInfo, subSystemValue);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        int rowCount = 0;
        try {
            while (rowSet.next()) {
                rowCount = rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }

    protected String getPaidCountSql(Context ctx, CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo, int subSystemValue) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("SELECT COUNT(FID) as count from T_CAS_Paymentbill WHERE ");
        CompanyOrgUnitInfo companyInfo = null;
        String companyId = null;
        sql.append("FCompanyID in ( ");
        for (int i = 0; i < companyColl.size(); ++i) {
            companyInfo = companyColl.get(i);
            companyId = companyInfo.getId().toString();
            if (i == companyColl.size() - 1) {
                sql.append("'" + companyId + "' ) ");
                continue;
            }
            sql.append("'" + companyId + "', ");
        }
        java.sql.Date beginDate = new java.sql.Date(periodInfo.getBeginDate().getTime());
        java.sql.Date endDate = new java.sql.Date(periodInfo.getEndDate().getTime() + 86400000L);
        sql.append("AND FBizDate>={d'" + beginDate + "'} AND FBizDate<{d'" + endDate + "'} ");
        sql.append("AND FSourceSysType = " + subSystemValue);
        return sql.toString();
    }

    private String getImplementClass(Context ctx, String bosType, int subSystemValue) throws BOSException {
        String sql = "select FClassName from T_CAS_UnPaidBillID where FBOSObjectType = ? and FSubSystem = ? ";
        String className = "";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bosType, subSystemValue});
            while (rowSet.next()) {
                className = rowSet.getString("FClassName");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return className;
    }

    private IQueryExecutor getQueryExecutor(Context ctx, IMetaDataPK queryPK, String oql) throws BOSException {
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(oql);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 10000;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = KDTDataRequestManager.defaultPageRow;
        exec.option().isIgnorePermissionCheck = true;
        return exec;
    }

    private IQueryExecutor getQueryExecutor(Context ctx, IMetaDataPK queryPK, EntityViewInfo view) throws BOSException {
        IQueryExecutor exec = null;
        exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(view);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = false;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().topCount = 10000;
        exec.option().isIgnoreRowCount = true;
        exec.option().pageCount = KDTDataRequestManager.defaultPageRow;
        exec.option().isIgnorePermissionCheck = true;
        return exec;
    }

    private UnPaidFilterInfo getUnPaidFilterInfo(Context ctx, String companyId, String bosType, int subSystemValue) throws BOSException {
        UnPaidFilterInfo unPaidFilterInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("filterType"));
        selector.add(new SelectorItemInfo("filter"));
        selector.add(new SelectorItemInfo("beforeDays"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billType.bosObjectType", (Object)bosType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)subSystemValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)ContextUtil.getCurrentUserInfo((Context)ctx).getId(), CompareType.EQUALS));
        view.setSelector(selector);
        view.setFilter(filter);
        UnPaidFilterCollection coll = UnPaidFilterFactory.getLocalInstance(ctx).getUnPaidFilterCollection(view);
        if (coll.size() > 0) {
            unPaidFilterInfo = coll.get(0);
        }
        return unPaidFilterInfo;
    }

    private String getFuncPermissionId(Context ctx, String permissionItem) throws EASBizException, BOSException {
        String permItemId = "";
        String permSql = "select FID from t_pm_permitem where fnumber = '" + permissionItem + "'";
        ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
        IRowSet rs = dataAccess.getRowSet(permSql);
        try {
            if (rs.next()) {
                permItemId = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return permItemId;
    }

    protected String getCompanyFilterSQL(String userId, String permssiomId, boolean isFunPerm, CompanyOrgUnitInfo root, String periodTypeID, boolean onlyLeaf) {
        StringBuffer sql = new StringBuffer();
        sql.append(" from t_bd_systemstatusctrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        sql.append(" inner join t_org_company cp on cp.fid = ssc.fcompanyid ");
        if (!onlyLeaf) {
            sql.append(" inner join t_org_company pcp on charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid ");
        }
        sql.append(" where ssc.fstartperiodid is not null ");
        sql.append(" and cp.fisbizunit = 1 ");
        sql.append(" and cp.faccounttableid is not null ");
        if (periodTypeID != null) {
            sql.append(" and cp.faccountperiodid = '").append(periodTypeID).append("'");
        }
        if (root != null && !onlyLeaf) {
            sql.append(" and (pcp.flongnumber like '").append(root.getLongNumber()).append("!%' or pcp.fid = '").append(root.getId().toString()).append("')");
        } else if (root != null && onlyLeaf) {
            sql.append(" and (cp.flongnumber like '").append(root.getLongNumber()).append("!%' or cp.fid = '").append(root.getId().toString()).append("')");
        }
        if (isFunPerm && !StringUtils.isEmpty((String)permssiomId)) {
            sql.append(" and cp.fid in (").append(UnPaidBillCenterFacadeControllerBean.getOrgPermissonSQL(userId, permssiomId)).append(")");
        }
        return sql.toString();
    }

    public static String getOrgPermissonSQL(String userId, String permssiomId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT UserOrgPerm.FOrgID FOrgID ");
        sql.append(" FROM T_PM_UserOrgPerm UserOrgPerm WHERE UserOrgPerm.FOwner = '").append(userId).append("'");
        sql.append(" AND UserOrgPerm.FPermItemID = '").append(permssiomId).append("'");
        sql.append(" UNION ALL");
        sql.append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ");
        sql.append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID");
        sql.append(" WHERE UserRoleOrg.FUserID = '").append(userId).append("'");
        sql.append(" AND RolePerm.FPermItemID = '").append(permssiomId).append("'");
        return sql.toString();
    }

    @Override
    protected CompanyOrgUnitCollection _getPermissionCompanyCollection(Context ctx, String permissionItem) throws BOSException, EASBizException {
        CoreBaseInfo user = (CoreBaseInfo)ctx.get((Object)"UserInfo");
        String userId = user.getId().toString();
        String permItemId = this.getFuncPermissionId(ctx, permissionItem);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT cp.fid as FID ");
        sql.append(this.getCompanyFilterSQL(userId, permItemId, true, null, null, true));
        ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
        IRowSet rowSet = dataAccess.getRowSet(sql.toString());
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection result = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
        OrgUnitInfo orgInfo = (OrgUnitInfo)ctx.get((Object)OrgType.getEnum((int)OrgType.Company.getValue()));
        for (int i = 0; i < result.size(); ++i) {
            if (orgInfo == null || !orgInfo.getId().equals((Object)result.get(i).getId())) continue;
            CompanyOrgUnitInfo newCompany = new CompanyOrgUnitInfo();
            CompanyOrgUnitInfo companyFst = result.get(0);
            CompanyOrgUnitInfo companyTmp = result.get(i);
            result.set(0, newCompany);
            result.set(i, companyFst);
            result.set(0, companyTmp);
        }
        return result;
    }

    @Override
    protected void _saveUnPaidFilter(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        UnPaidFilterInfo unPaidFilterInfo = (UnPaidFilterInfo)info;
        UnPaidFilterFactory.getLocalInstance(ctx).save((CoreBaseInfo)unPaidFilterInfo);
    }

    @Override
    protected List _getSubSystemItemList(Context ctx, String[] companyIDs) throws BOSException, EASBizException {
        ArrayList<SubSystemItem> result = new ArrayList<SubSystemItem>();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("subSystem"));
        CoreBaseInfo user = (CoreBaseInfo)ctx.get((Object)"UserInfo");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)user.getId().toString(), CompareType.EQUALS));
        if (companyIDs != null) {
            String companySql = "company IN (";
            for (String company : companyIDs) {
                companySql = companySql + "'" + company + "',";
            }
            companySql = companySql.substring(0, companySql.length() - 1);
            companySql = companySql + ")";
            filter.getFilterItems().add(new FilterItemInfo(companySql));
        }
        if (companyIDs != null) {
            String systemSys = this.getSystemStartByCompanySql(ctx, companyIDs);
            if (systemSys.isEmpty()) {
                return result;
            }
            filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)systemSys, CompareType.INNER));
        }
        SorterItemCollection sorter = new SorterItemCollection();
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sorter);
        UnPaidFilterCollection UnPaidFilterColl = UnPaidFilterFactory.getLocalInstance(ctx).getUnPaidFilterCollection(view);
        Iterator it = UnPaidFilterColl.iterator();
        while (it.hasNext()) {
            UnPaidFilterInfo UnPaidFilterInfo2 = (UnPaidFilterInfo)it.next();
            SubSystemItem systemEnum = UnPaidFilterInfo2.getSubSystem();
            result.add(systemEnum);
        }
        HashSet<SubSystemItem> set = new HashSet<SubSystemItem>();
        set.addAll(result);
        result.clear();
        result.addAll(set);
        return result;
    }

    private String getSystemStartByCompanySql(Context ctx, String[] companyIDs) throws BOSException, EASBizException {
        String sql = "SELECT FSUBSYSTEM FROM T_CAS_SUBSYSTEM WHERE FSYSTEMSYS IN (";
        String inSql = "SELECT SS.FNAME FROM T_BD_SystemStatusCtrol SSC LEFT OUTER JOIN T_BD_SystemStatus SS ON SSC.FSYSTEMSTATUSID = SS.FID WHERE SSC.FCOMPANYID IN(";
        for (String company : companyIDs) {
            inSql = inSql + "'" + company + "',";
        }
        inSql = inSql.substring(0, inSql.length() - 1);
        inSql = inSql + "))";
        sql = sql + inSql;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String systemSys = "";
        try {
            while (rowSet.next()) {
                systemSys = systemSys + "'" + rowSet.getInt("FSUBSYSTEM") + "',";
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        systemSys = systemSys + "120";
        return systemSys;
    }

    private String getPeriodString(Context ctx, PeriodInfo periodInfo) throws EASBizException, BOSException {
        String resFullName = "com.kingdee.eas.basedata.assistant.PeriodResource";
        String s = EASCommonResource.getString((String)resFullName, (String)"periodformat", (Locale)ctx.getLocale());
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(new String[]{new Integer(periodInfo.getPeriodYear()).toString(), new Integer(periodInfo.getPeriodNumber()).toString()});
        if (periodInfo.isIsAdjustPeriod()) {
            result = result + "(" + EASCommonResource.getString((String)resFullName, (String)"PeriodAdjuxt", (Locale)ctx.getLocale()) + ")";
        }
        return result;
    }

    private Map getPeriodMap(Context ctx, List idList) throws BOSException, EASBizException {
        EntityViewInfo view1 = new EntityViewInfo();
        SelectorItemCollection selector1 = new SelectorItemCollection();
        selector1.add(new SelectorItemInfo("accountPeriodType.id"));
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("id", new HashSet(idList), CompareType.INCLUDE));
        view1.setSelector(selector1);
        view1.setFilter(filter1);
        CompanyOrgUnitCollection companyCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view1);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("periodYear"));
        selector.add(new SelectorItemInfo("periodNumber"));
        selector.add(new SelectorItemInfo("number"));
        HashSet<String> accountPeriodTypes = new HashSet<String>();
        FilterInfo filter = null;
        CompanyOrgUnitInfo companyOrgUnitInfo2 = null;
        PeriodCollection periodCollection = null;
        for (CompanyOrgUnitInfo companyInfo : companyCol) {
            accountPeriodTypes.add(companyInfo.getAccountPeriodType().getId().toString());
        }
        if (accountPeriodTypes.size() > 1) {
            HashMap<String, Integer> failureResult = new HashMap<String, Integer>();
            failureResult.put("error", 1);
            return failureResult;
        }
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        sorterItem.setSortType(SortType.DESCEND);
        sortCol.add(sorterItem);
        view.setSelector(selector);
        view.setSorter(sortCol);
        PeriodCollection totalPeriodCollection = new PeriodCollection();
        PeriodInfo periodInfo = null;
        HashMap<String, Object> map = null;
        HashMap resultMap = new HashMap();
        for (CompanyOrgUnitInfo companyOrgUnitInfo2 : companyCol) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyOrgUnitInfo2.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            periodCollection = PeriodFactory.getLocalInstance((Context)ctx).getPeriodCollection(view);
            for (int i = 0; i < periodCollection.size(); ++i) {
                periodInfo = periodCollection.get(i);
                String alias = this.getPeriodString(ctx, periodInfo);
                map = new HashMap<String, Object>();
                map.put("alias", alias);
                map.put("value", periodInfo.getNumber());
                resultMap.put(periodInfo.getNumber(), map);
            }
        }
        return resultMap;
    }

    @Override
    protected Map _getPeriodData(Context ctx, List idList) throws BOSException, EASBizException {
        HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
        Map periodsMap = this.getPeriodMap(ctx, idList);
        if (periodsMap.get("error") != null) {
            return periodsMap;
        }
        ArrayList periodList = new ArrayList(periodsMap.entrySet());
        Collections.sort(periodList, new Comparator<Map.Entry<Integer, Map>>(){

            @Override
            public int compare(Map.Entry<Integer, Map> o1, Map.Entry<Integer, Map> o2) {
                return o1.getKey() - o2.getKey();
            }
        });
        ArrayList periods = new ArrayList();
        for (int i = 0; i < periodList.size(); ++i) {
            periods.add(((Map.Entry)periodList.get(i)).getValue());
        }
        result.put("periods", periods);
        Map currentperiodInfoMap = this._getCurrentPeriodInfo(ctx, idList);
        String firstCompanyId = (String)idList.get(0);
        if (currentperiodInfoMap != null && currentperiodInfoMap.containsKey(firstCompanyId)) {
            PeriodInfo periodInfo = (PeriodInfo)currentperiodInfoMap.get(firstCompanyId);
            CompanyOrgUnitInfo company = CasBotpUtil.getCompanyInfoById(ctx, firstCompanyId);
            if (periodInfo == null) {
                throw new CasWebException(CasWebException.NO_PERIOD_COMPANY, new String[]{company.getName()});
            }
            HashMap<String, Object> current = new HashMap<String, Object>();
            String alias = this.getPeriodString(ctx, periodInfo);
            current.put("alias", alias);
            current.put("value", periodInfo.getNumber());
            result.put("current", current);
        }
        return result;
    }

    @Override
    protected Map _getCurrentPeriodInfo(Context ctx, List idList) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        String companyId = null;
        HashMap<String, PeriodInfo> map = new HashMap<String, PeriodInfo>();
        for (int i = 0; i < idList.size(); ++i) {
            companyId = idList.get(i).toString();
            companyOrgUnitInfo = new CompanyOrgUnitInfo();
            companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
            map.put(companyId, SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyOrgUnitInfo));
        }
        return map;
    }

    @Override
    protected List _getSubSystemCollection(Context ctx) throws BOSException, EASBizException {
        ArrayList<SubSystemItem> result = new ArrayList<SubSystemItem>();
        String sql = "select FSubSystem from T_CAS_SubSystem order by FSeq asc";
        try {
            ISQLDataAccess dataAccess = SQLDataAccessFactory.getLocalInstance((Context)ctx);
            IRowSet rs = dataAccess.getRowSet(sql);
            while (rs.next()) {
                int subSystemValue = rs.getInt("FSubSystem");
                SubSystemItem subSystemEnum = SubSystemItem.getEnum(subSystemValue);
                result.add(subSystemEnum);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Map _getSubSystemData(Context ctx, String[] companyIDs) throws BOSException, EASBizException {
        HashMap<String, List> result = new HashMap<String, List>();
        List systems = this._getSubSystemCollection(ctx);
        result.put("systems", systems);
        List customs = this._getSubSystemItemList(ctx, companyIDs);
        result.put("customs", customs);
        return result;
    }

    protected String getBillCountByStatusSql(CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo, int billStatus) {
        StringBuffer sql = new StringBuffer("SELECT COUNT(FID) as count from T_CAS_Paymentbill WHERE ");
        CompanyOrgUnitInfo companyInfo = null;
        String companyId = null;
        sql.append("FCompanyID in ( ");
        for (int i = 0; i < companyColl.size(); ++i) {
            companyInfo = companyColl.get(i);
            companyId = companyInfo.getId().toString();
            if (i == companyColl.size() - 1) {
                sql.append("'" + companyId + "' ) ");
                continue;
            }
            sql.append("'" + companyId + "', ");
        }
        java.sql.Date beginDate = new java.sql.Date(periodInfo.getBeginDate().getTime());
        java.sql.Date endDate = new java.sql.Date(periodInfo.getEndDate().getTime() + 86400000L);
        sql.append("AND FBizDate>={d'" + beginDate + "'} AND FBizDate<{d'" + endDate + "'} ");
        sql.append("AND FBillStatus = " + billStatus);
        return sql.toString();
    }

    @Override
    protected Map _getBillCountByStatus(Context ctx, CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo, Map statusList) throws BOSException, EASBizException {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        String sql = null;
        Iterator it = statusList.keySet().iterator();
        Object key = null;
        while (it.hasNext()) {
            key = it.next();
            sql = this.getBillCountByStatusSql(companyColl, periodInfo, (Integer)statusList.get(key));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            int rowCount = 0;
            try {
                while (rowSet.next()) {
                    rowCount = rowSet.getInt("count");
                }
                map.put(key, rowCount);
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return map;
    }

    @Override
    protected IObjectCollection _getRulesByCompanyAndBOSType(Context ctx, String companyId, String bosType) throws BOSException, EASBizException {
        String badDeptBosType = null;
        if (bosType.equals("C9C8D8AF")) {
            badDeptBosType = bosType;
            bosType = "3C41FD86";
        }
        BOTMappingCollection col = BOTMappingFactory.getLocalInstance((Context)ctx).getMappingCollectionForSelect(bosType, PAYMENTBILLTYPE, DefineSysEnum.BTP);
        if (badDeptBosType != null) {
            for (int i = col.size() - 1; i >= 0; --i) {
                String viewStr;
                BOTMappingInfo mappingInfo = col.get(i);
                EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping((BOTMappingInfo)mappingInfo);
                if (view != null && ((viewStr = view.toString()).contains("verificationType = 111") || viewStr.contains("verificationType = 112"))) continue;
                col.removeObject(i);
            }
        }
        return col;
    }

    protected boolean mappingInfoIsCBPay(Context ctx, BOTMappingInfo mappingInfo) throws BOSException {
        boolean flag = false;
        try {
            String fexpression;
            logger.error((Object)("--------mappingInfo  " + mappingInfo.getName() + "----------------"));
            String sql = "select FEXPRESSION  from T_BOT_RULESEGMENT where FDESTPROPERTYNAME='isCBPay' and FRULEID in (SELECT max(fid) FROM T_BOT_RULE where FMAPPINGID='" + mappingInfo.getId().toString() + "')";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.next() && "true".equals(fexpression = rowSet.getString("FEXPRESSION"))) {
                flag = true;
                logger.error((Object)("--------mappingInfo  " + mappingInfo.getName() + "  isCBPay==true----------------"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return flag;
    }

    @Override
    protected void _generatePaymentBill(Context ctx, String companyId, String bosType, int subSystem, String[] billIds, String[] botpRuleIds, boolean isAuto, boolean isCBPay) throws BOSException, EASBizException {
        boolean hasFunctionPermission;
        BOTMappingCollection botpRulesSelected = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPk = new ObjectUuidPK(companyId);
        CompanyOrgUnitInfo company = CasBotpUtil.getCompanyInfoById(ctx, companyId);
        BillTypeInfo BillType2 = CasBotpUtil.getBillTypeByBOSType(ctx, bosType, subSystem);
        CoreBillBaseCollection sourceBillCollection = CasBotpUtil.getSrcCollectionByIds(ctx, billIds, null);
        if (!isAuto && !(hasFunctionPermission = PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPk, (IObjectPK)orgPk, PAYMENTBILLADDNEWPERM))) {
            this.recordReportWithoutPerm(ctx, sourceBillCollection, company, BillType2, isCBPay);
            return;
        }
        if (!(botpRuleIds == null || botpRuleIds.length <= 0 || botpRuleIds.length == 1 && StringUtils.isEmpty((String)botpRuleIds[0]))) {
            botpRulesSelected = CasBotpUtil.getBotpRulesSelected(ctx, botpRuleIds);
        }
        if (botpRulesSelected == null || botpRulesSelected.size() == 0) {
            NoRuleRecorder recorder = new NoRuleRecorder(companyId, ctx, billIds);
            recorder.setCBPay(isCBPay);
            recorder.record(ctx, bosType, subSystem, userInfo);
        } else {
            String[] entrysNames = new String[]{CasBotpUtil.getBillMainEntryName(bosType)};
            List entriesKeys = CasBotpUtil.getSelectEntryIDs(sourceBillCollection, entrysNames[0]);
            BOTPTransmitRecorderForBillAndRules recorder = CasBotpUtil.checkBotMapping(ctx, companyId, billIds, entrysNames, entriesKeys, botpRulesSelected);
            recorder.setCBPay(isCBPay);
            recorder.generatePaymentBill(ctx, bosType, subSystem, userInfo);
        }
    }

    public void recordReportWithoutPerm(Context ctx, CoreBillBaseCollection billCol, CompanyOrgUnitInfo company, BillTypeInfo billType, boolean isCBPay) throws EASBizException, BOSException {
        CoreBaseCollection vrc = new CoreBaseCollection();
        for (int i = 0; i < billCol.size(); ++i) {
            CoreBillBaseInfo billInfo = billCol.get(i);
            PaymentReportInfo vri = new PaymentReportInfo();
            vrc.add((CoreBaseInfo)vri);
            vri.setCompany(company);
            vri.setSubSystem(billType.getSubSystem());
            vri.setBillType(billType);
            vri.setBillID(billInfo.get("id").toString());
            vri.setBillNumber((String)billInfo.get("number"));
            vri.setBizDate((Date)billInfo.get("bizDate"));
            vri.setUser(ContextUtil.getCurrentUserInfo((Context)ctx));
            vri.setPaymentState(PaymentStateEnum.fail);
            vri.setFailureCause(PaymentFailReasonEnum.failForNoPerm.getAlias());
            vri.setIsCBPay(isCBPay);
        }
        PaymentReportFactory.getLocalInstance(ctx).submitBatchData(vrc);
    }

    @Override
    protected PeriodInfo _getPeriodByComAndNum(Context ctx, CompanyOrgUnitCollection companyColl, int period) throws BOSException, EASBizException {
        int PeriodYear = period / 100;
        int PeriodNumber = period % 100;
        Iterator it = companyColl.iterator();
        CompanyOrgUnitInfo companyInfo = null;
        PeriodTypeInfo periodType = null;
        Object filter = null;
        while (it.hasNext()) {
            companyInfo = (CompanyOrgUnitInfo)it.next();
            periodType = companyInfo.getAccountPeriodType();
            String periodTypeId = periodType.getId().toString();
            String oql = "select * where periodYear = " + PeriodYear + " and periodNumber = " + PeriodNumber + " and periodType = '" + periodTypeId + "'";
            if (!PeriodFactory.getLocalInstance((Context)ctx).exists(oql)) continue;
            return PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
        }
        return null;
    }

    @Override
    protected double _getPaidAmountInfo(Context ctx, CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo) throws BOSException, EASBizException {
        String sql = this.getPaidAmountInfoSql(companyColl, periodInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        double amount = 0.0;
        try {
            while (rowSet.next()) {
                amount = rowSet.getDouble("amount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return amount;
    }

    protected String getPaidAmountInfoSql(CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer("SELECT SUM(FactPayLocAmt) as amount from T_CAS_Paymentbill WHERE ");
        CompanyOrgUnitInfo companyInfo = null;
        String companyId = null;
        sql.append("FCompanyID in ( ");
        for (int i = 0; i < companyColl.size(); ++i) {
            companyInfo = companyColl.get(i);
            companyId = companyInfo.getId().toString();
            if (i == companyColl.size() - 1) {
                sql.append("'" + companyId + "' ) ");
                continue;
            }
            sql.append("'" + companyId + "', ");
        }
        java.sql.Date beginDate = new java.sql.Date(periodInfo.getBeginDate().getTime());
        java.sql.Date endDate = new java.sql.Date(periodInfo.getEndDate().getTime() + 86400000L);
        sql.append("AND FBizDate>={d'" + beginDate + "'} AND FBizDate<{d'" + endDate + "'} ");
        sql.append("AND FBillStatus = 15");
        return sql.toString();
    }

    protected String getUnPaidAmountInfoSql(CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo) {
        StringBuffer sql = new StringBuffer("SELECT SUM(FactPayLocAmt) as amount from T_CAS_Paymentbill WHERE ");
        CompanyOrgUnitInfo companyInfo = null;
        String companyId = null;
        sql.append("FCompanyID in ( ");
        for (int i = 0; i < companyColl.size(); ++i) {
            companyInfo = companyColl.get(i);
            companyId = companyInfo.getId().toString();
            if (i == companyColl.size() - 1) {
                sql.append("'" + companyId + "' ) ");
                continue;
            }
            sql.append("'" + companyId + "', ");
        }
        java.sql.Date beginDate = new java.sql.Date(periodInfo.getBeginDate().getTime());
        java.sql.Date endDate = new java.sql.Date(periodInfo.getEndDate().getTime() + 86400000L);
        sql.append("AND FBizDate>={d'" + beginDate + "'} AND FBizDate<{d'" + endDate + "'} ");
        sql.append("AND FBillStatus <> 15");
        return sql.toString();
    }

    @Override
    protected double _getUnPaidAmountInfo(Context ctx, CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo) throws BOSException, EASBizException {
        String sql = this.getUnPaidAmountInfoSql(companyColl, periodInfo);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        double amount = 0.0;
        try {
            while (rowSet.next()) {
                amount = rowSet.getDouble("amount");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return amount;
    }

    @Override
    protected List _getUnPaidCountAndAmount(Context ctx, CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo, int subSystemValue) throws BOSException, EASBizException {
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        Object orgPk = null;
        ArrayList result = new ArrayList();
        BillTypeCollection billTypeCollection = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection(subSystemValue);
        Iterator it = billTypeCollection.iterator();
        String bosType = null;
        String queryPK = null;
        Object permissionItem = null;
        StringBuffer sql = null;
        IRowSet rowSet = null;
        while (it.hasNext()) {
            BillTypeInfo billTypeInfo = (BillTypeInfo)it.next();
            bosType = billTypeInfo.getBosObjectType();
            queryPK = billTypeInfo.getQueryPK();
            sql = this.getUnPaidCountAndAmountSql(ctx, companyColl, periodInfo, queryPK, bosType, subSystemValue);
            if (sql == null || sql.length() == 0) continue;
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            double amount = 0.0;
            int count = 0;
            try {
                while (rowSet.next()) {
                    amount = rowSet.getDouble("amount");
                    count = rowSet.getInt("count");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            HashMap<String, Serializable> itemMap = new HashMap<String, Serializable>();
            itemMap.put("bill", billTypeInfo);
            itemMap.put("amount", Double.valueOf(amount));
            itemMap.put("count", Integer.valueOf(count));
            result.add(itemMap);
        }
        return result;
    }

    protected StringBuffer getUnPaidCountAndAmountSql(Context ctx, CompanyOrgUnitCollection companyColl, PeriodInfo periodInfo, String queryPK, String bosType, int subSystemValue) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer();
        ArrayList paramList = new ArrayList();
        StringBuffer sqlBuffer = new StringBuffer();
        String unPaidAmountStr = "";
        CompanyOrgUnitInfo companyInfo = null;
        UnPaidFilterInfo unPaidFilterInfo = null;
        String filterByUser = "";
        String billCountAndAmountFilter = "";
        String className = "";
        int days = 0;
        for (int i = 0; i < companyColl.size(); ++i) {
            companyInfo = companyColl.get(i);
            unPaidFilterInfo = this.getUnPaidFilterInfo(ctx, companyInfo.getId().toString(), bosType, subSystemValue);
            if (unPaidFilterInfo == null) continue;
            if (unPaidFilterInfo != null) {
                filterByUser = unPaidFilterInfo.getFilter();
                days = unPaidFilterInfo.getBeforeDays();
                if (unPaidFilterInfo.getFilterType() == FilterTypeEnum.PAID_NONE) {
                    filterByUser = "id is not null";
                }
            }
            if (StringUtils.isEmpty((String)filterByUser)) {
                className = this.getImplementClass(ctx, bosType, subSystemValue);
                if (className == null || "".equals(className)) {
                    return null;
                }
                try {
                    if (!paramList.isEmpty()) {
                        paramList.clear();
                    }
                    billCountAndAmountFilter = ((IUnPaidBillID)Class.forName(className).newInstance()).getUnPaidBillCountAndAmount(ctx, companyInfo, periodInfo, days, paramList);
                }
                catch (InstantiationException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                catch (ClassNotFoundException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                if (StringUtils.isEmpty((String)billCountAndAmountFilter)) {
                    return null;
                }
            } else {
                billCountAndAmountFilter = this.getUnPaidBillFilter(ctx, companyInfo, periodInfo, paramList, bosType, queryPK, subSystemValue);
                if (StringUtils.isEmpty((String)billCountAndAmountFilter)) {
                    return null;
                }
            }
            sqlBuffer.append(billCountAndAmountFilter + " union all ");
        }
        if (sqlBuffer.length() == 0) {
            return null;
        }
        String lastElevenChars = sqlBuffer.substring(sqlBuffer.length() - 11, sqlBuffer.length());
        if (" union all ".equals(lastElevenChars)) {
            sqlBuffer = new StringBuffer(sqlBuffer.substring(0, sqlBuffer.length() - 11));
        }
        String oql = "";
        ArrayList signList = new ArrayList();
        ArrayList newParamList = new ArrayList();
        StringBuffer sb = new StringBuffer();
        if (paramList.size() > 1) {
            for (int i = 0; i < paramList.size(); ++i) {
                if (i % 2 == 1) {
                    signList.add(paramList.get(i));
                    continue;
                }
                if (i == paramList.size() - 1) {
                    sb.append(paramList.get(i));
                } else {
                    sb.append(paramList.get(i) + ",");
                }
                newParamList.add(paramList.get(i));
            }
            oql = "select id," + sb.toString() + " where id in ( " + sqlBuffer.append(" )").toString();
        } else {
            unPaidAmountStr = paramList.get(0).toString();
            oql = "select id, " + unPaidAmountStr + " where id in ( " + sqlBuffer.append(" )").toString();
        }
        logger.info((Object)oql);
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, oql);
        String sql = iexec.getSQL();
        int distinctIndex = sql.indexOf("DISTINCT");
        int fromIndex = sql.indexOf("FROM");
        if (distinctIndex < 0 || distinctIndex > fromIndex) {
            sql = sql.replaceFirst("SELECT", "SELECT DISTINCT");
        }
        if (!StringUtils.isEmpty((String)unPaidAmountStr)) {
            sqlBuf.append(" select count(DISTINCT id) as count, sum(");
            sqlBuf.append("\"" + unPaidAmountStr + "\"");
            sqlBuf.append(") as amount from (").append(sql).append(") as tmp ");
        } else {
            sqlBuf.append(" select count(id) as count, sum( ");
            for (int i = 0; i < newParamList.size(); ++i) {
                sqlBuf.append("\"" + newParamList.get(i) + "\"");
                if (i >= signList.size()) continue;
                sqlBuf.append(signList.get(i));
            }
            sqlBuf.append(" ) as amount from (").append(sql).append(") as tmp ");
        }
        return sqlBuf;
    }

    private String getUnPaidBillFilter(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, List paramList, String bosType, String queryPK, int subSystemValue) throws BOSException, EASBizException {
        String className = this.getImplementClass(ctx, bosType, subSystemValue);
        if (className == null || "".equals(className)) {
            return null;
        }
        String billIDFilter = "";
        UnPaidFilterInfo unPaidFilterInfo = this.getUnPaidFilterInfo(ctx, companyInfo.getId().toString(), bosType, subSystemValue);
        String filterByUser = "";
        String sql = "";
        EntityViewInfo view = new EntityViewInfo();
        int days = 0;
        if (unPaidFilterInfo != null) {
            filterByUser = unPaidFilterInfo.getFilter();
            days = unPaidFilterInfo.getBeforeDays();
            if (unPaidFilterInfo.getFilterType() == FilterTypeEnum.PAID_NONE) {
                filterByUser = "id is not null";
            }
            try {
                FilterInfo filter = new FilterInfo(filterByUser);
                view.setFilter(filter);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            sql = filterByUser;
            IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
            IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, view);
            sql = iexec.getSQL();
            int whereIndex = sql.indexOf("WHERE");
            sql = sql.substring(whereIndex + "WHERE".length()).trim();
        }
        try {
            if (!paramList.isEmpty()) {
                paramList.clear();
            }
            billIDFilter = ((IUnPaidBillID)Class.forName(className).newInstance()).getUnPaidBillCountAndAmount(ctx, companyInfo, periodInfo, days, paramList);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer result = new StringBuffer();
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            result.append(billIDFilter);
            if (sql != null && !"".equals(sql)) {
                result.append(" and ").append(sql);
            }
        } else {
            result.append(sql);
        }
        return result.toString();
    }

    @Override
    protected List<Map> _getUnPaidCountSingleOrg(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, int subSystemValue) throws BOSException, EASBizException {
        ObjectUuidPK userPk = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        ObjectUuidPK orgPk = new ObjectUuidPK(companyInfo.getId());
        ArrayList<Map> result = new ArrayList<Map>();
        BillTypeCollection billTypeCollection = BillTypeFactory.getLocalInstance(ctx).getBillTypeCollection(subSystemValue);
        Iterator it = billTypeCollection.iterator();
        while (it.hasNext()) {
            BillTypeInfo billTypeInfo = (BillTypeInfo)it.next();
            String bosType = billTypeInfo.getBosObjectType();
            String queryPK = billTypeInfo.getQueryPK();
            StringBuffer sql = this.getUnPaidCountSql(ctx, companyInfo, periodInfo, queryPK, bosType, subSystemValue);
            if (sql == null || sql.length() == 0) continue;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            int rowCount = 0;
            try {
                while (rowSet.next()) {
                    rowCount = rowSet.getInt("count");
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            if (rowCount == 0) continue;
            Object[] ids = this._getUnPaidBillIDs(ctx, companyInfo.getId().toString(), periodInfo.getNumber(), bosType, subSystemValue, null);
            String idstr = org.apache.commons.lang.StringUtils.join((Object[])ids, (char)',');
            HashMap<String, Object> itemMap = new HashMap<String, Object>();
            itemMap.put("company", companyInfo);
            itemMap.put("bill", billTypeInfo);
            itemMap.put("count", rowCount);
            itemMap.put("ids", idstr);
            result.add(itemMap);
        }
        return result;
    }

    private StringBuffer getUnPaidCountSql(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, String queryPK, String bosType, int subSystemValue) throws BOSException, EASBizException {
        StringBuffer sqlBuf = new StringBuffer();
        ArrayList paramList = new ArrayList();
        int days = 0;
        UnPaidFilterInfo unPaidFilterInfo = this.getUnPaidFilterInfo(ctx, companyInfo.getId().toString(), bosType, subSystemValue);
        paramList = new ArrayList();
        if (unPaidFilterInfo == null) {
            return null;
        }
        String filterByUser = "";
        if (unPaidFilterInfo != null) {
            filterByUser = unPaidFilterInfo.getFilter();
            days = unPaidFilterInfo.getBeforeDays();
            if (unPaidFilterInfo.getFilterType() == FilterTypeEnum.PAID_NONE) {
                filterByUser = "id is not null";
            }
        }
        if (StringUtils.isEmpty((String)filterByUser)) {
            String className = this.getImplementClass(ctx, bosType, subSystemValue);
            if (className == null || "".equals(className)) {
                return null;
            }
            String billIDFilter = "";
            try {
                billIDFilter = ((IUnPaidBillID)Class.forName(className).newInstance()).getUnPaidBillCountAndAmount(ctx, companyInfo, periodInfo, days, paramList);
            }
            catch (InstantiationException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            if (StringUtils.isEmpty((String)billIDFilter)) {
                return null;
            }
            sqlBuf.append(" select count(1) as count from( select distinct fid from (").append(billIDFilter).append(") as temp ) as tmp ");
        } else {
            String filter = this.getUnPaidBillFilter(ctx, companyInfo, periodInfo, paramList, bosType, queryPK, subSystemValue);
            if (StringUtils.isEmpty((String)filter)) {
                return null;
            }
            String oql = "select id where  id in (" + filter + ")";
            logger.info((Object)oql);
            IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
            IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, oql);
            String sql = iexec.getSQL();
            int distinctIndex = sql.indexOf("DISTINCT");
            int fromIndex = sql.indexOf("FROM");
            if (distinctIndex < 0 || distinctIndex > fromIndex) {
                sql = sql.replaceFirst("SELECT", "SELECT DISTINCT");
            }
            sqlBuf.append(" select count(1) as count from (").append(sql).append(") as tmp ");
        }
        return sqlBuf;
    }

    @Override
    protected int _getPaidBillCount(Context ctx, String companyId, String bosType, int subSystemValue) throws BOSException, EASBizException {
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        StringBuffer buf = new StringBuffer().append("select count(1) as paidCount from t_cas_paymentReport where ").append("fCompanyId = '").append(companyId).append("'").append(" and fUserId = '").append(userId).append("'").append(" and fBillTypeId = (").append("select fid from t_cas_billType where ").append("FBOSObjectType = '").append(bosType).append("'").append(" and FSubSystem = ").append(subSystemValue).append(")").append(" and fPaymentState = 0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        int count = 0;
        try {
            while (rs.next()) {
                count = rs.getInt("paidCount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return count;
    }

    @Override
    protected String[] _getUnPaidBillIDs(Context ctx, String companyId, int period, String bosType, int subSystemValue, String[] billIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        PeriodInfo periodInfo = this.getPeriodInfo(ctx, companyInfo, period);
        ArrayList paramList = new ArrayList();
        String queryPK = this.getQueryPKByBosType(ctx, bosType, subSystemValue);
        String filter = this.getUnPaidBillFilterForQuery(ctx, companyInfo, periodInfo, bosType, subSystemValue);
        StringBuffer queryOql = new StringBuffer("select id  where ").append(filter);
        if (billIds != null && billIds.length > 0) {
            StringBuffer idOql = new StringBuffer();
            idOql.append(" and id in (");
            int len = billIds.length;
            for (int i = 0; i < len; ++i) {
                idOql.append("'").append(billIds[i]).append("',");
            }
            idOql.replace(idOql.length() - 1, idOql.length(), ")");
            queryOql.append(idOql.toString());
        }
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql.toString());
        IRowSet rowSet = iexec.executeQuery();
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rowSet.next()) {
                ids.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String[] result = new String[]{};
        result = ids.toArray(result);
        return result;
    }

    private PeriodInfo getPeriodInfo(Context ctx, CompanyOrgUnitInfo companyInfo, int period) throws EASBizException, BOSException {
        int PeriodYear = period / 100;
        int PeriodNumber = period % 100;
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
    }

    @Override
    protected String _getUnPaidBillFilterForQuery(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, String bosType, int subSystemValue) throws BOSException, EASBizException {
        ArrayList paramList = new ArrayList();
        String queryPK = this.getQueryPKByBosType(ctx, bosType, subSystemValue);
        String className = this.getImplementClass(ctx, bosType, subSystemValue);
        if (className == null || "".equals(className)) {
            return null;
        }
        String billIDFilter = "";
        UnPaidFilterInfo unPaidFilterInfo = this.getUnPaidFilterInfo(ctx, companyInfo.getId().toString(), bosType, subSystemValue);
        String filterByUser = "";
        String sql = "";
        EntityViewInfo view = new EntityViewInfo();
        int days = 0;
        if (unPaidFilterInfo != null) {
            filterByUser = unPaidFilterInfo.getFilter();
            days = unPaidFilterInfo.getBeforeDays();
            if (unPaidFilterInfo.getFilterType() == FilterTypeEnum.PAID_NONE) {
                filterByUser = "id is not null";
            }
            try {
                FilterInfo filter = new FilterInfo(filterByUser);
                view.setFilter(filter);
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
            sql = filterByUser;
        }
        try {
            billIDFilter = ((IUnPaidBillID)Class.forName(className).newInstance()).getUnPaidBillCountAndAmount(ctx, companyInfo, periodInfo, days, paramList);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer oql = new StringBuffer("");
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            oql.append("id in (").append(billIDFilter).append(") and ").append(sql);
        } else {
            oql.append(sql);
        }
        return oql.toString();
    }

    private String getQueryPKByBosType(Context ctx, String bosType, int subSystemValue) throws EASBizException, BOSException {
        StringBuffer billTypeOql = new StringBuffer("select id, bosObjectType, queryPK where bosObjectType = '").append(bosType).append("' and subSystem = ").append(subSystemValue);
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo(billTypeOql.toString());
        String queryPK = billTypeInfo.getQueryPK();
        return queryPK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _AutoGenratePaymentBill(Context ctx) throws BOSException, EASBizException {
        AutoGenerateRuleCollection autoGenerateRuleCollection = this.getAutoGenerateRuleCollection(ctx);
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < autoGenerateRuleCollection.size(); ++i) {
            AutoGenerateRuleInfo rule = autoGenerateRuleCollection.get(i);
            String companyId = rule.getCompany().getId().toString();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
            String id = rule.getBillType().getId().toString();
            BillTypeInfo billType = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(id));
            String bosType = billType.getBosObjectType();
            String billTypeId = billType.getId().toString();
            String botpRuleName = rule.getBotpRuleName();
            int subSystemValue = rule.getSubSystem().getValue();
            String[] ids = this.getSourceBillIDS(ctx, rule, bosType, subSystemValue, companyInfo, periodInfo);
            String[] botpRules = rule.getBotpRuleId().split(",");
            boolean isCanUpdate = iMutex.requestObjIDForUpdate(rule.getId().toString());
            try {
                String receiveMessager = rule.getMsgReceiverId();
                CasBotpUtil.clearPreviousBOTPReport(ctx, receiveMessager, rule.isIsCBPay());
                UserInfo userInfo = UserFactory.getLocalInstance((Context)ctx).getUserInfo((IObjectPK)new ObjectUuidPK(receiveMessager));
                ctx.put((Object)"UserInfo", (Object)userInfo);
                this._generatePaymentBill(ctx, companyId, bosType, subSystemValue, ids, botpRules, Boolean.TRUE, rule.isIsCBPay());
                this.sendMessage(ctx, companyInfo, billTypeId, botpRuleName, subSystemValue, receiveMessager);
                continue;
            }
            finally {
                iMutex.releaseObjIDForUpdate(rule.getId().toString());
            }
        }
    }

    public void sendMessage(Context ctx, CompanyOrgUnitInfo companyInfo, String billTypeId, String botpRuleName, int subSystemValue, String ReceiveMessager) throws BOSException, EASBizException {
        String companyId = companyInfo.getId().toString();
        String companyName = companyInfo.getName();
        PaymentReportCollection paymentReportCollection = this.getPaymentReport(ctx, companyId, billTypeId, subSystemValue);
        int paymentBillNum = 0;
        int failureBillNum = paymentReportCollection.size();
        StringBuffer paymentBillNumbers = new StringBuffer("");
        String paymentBillstr = "";
        StringBuffer failureCause = new StringBuffer("");
        HashSet<String> paymentBillSet = new HashSet<String>();
        for (int i = 0; i < paymentReportCollection.size(); ++i) {
            PaymentReportInfo paymentReport = paymentReportCollection.get(i);
            String billTypeID = paymentReport.getBillType().getId().toString();
            BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK(billTypeID));
            if (paymentReport.getPaymentBill() != null || paymentReport.getPaymentState().getValue() == 0) {
                --failureBillNum;
                String paymentBillId = paymentReport.getPaymentBill().getId().toString();
                PaymentBillInfo paymentBillInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(paymentBillId));
                paymentBillSet.add(paymentBillInfo.getNumber());
                continue;
            }
            failureCause.append(paymentReport.getBillNumber()).append(billTypeInfo.getName()).append(",").append(paymentReport.getFailureCause()).append("\u3002\n");
        }
        for (String paymentBillNumber : paymentBillSet) {
            paymentBillNumbers.append(paymentBillNumber).append(",");
            ++paymentBillNum;
        }
        if (paymentBillNumbers.length() > 0) {
            paymentBillstr = paymentBillNumbers.substring(0, paymentBillNumbers.length() - 1);
        }
        String bizDate = DateUtil.getSQLBegin((Date)new Date()).toString();
        String year = bizDate.substring(0, 4);
        String month = bizDate.substring(5, 7);
        String day = bizDate.substring(8, 10);
        String hour = String.valueOf(Calendar.getInstance().get(11));
        String msgTitle = CASWebUtil.getResource(ctx, "530_GENERATEPAYMENTBILLMESSAGETITLE", new String[]{year, month, day, hour, companyName});
        StringBuffer msgBody = new StringBuffer();
        msgBody.append(CASWebUtil.getResource(ctx, "529_GENERATEPAYMENTBILLMESSAGEBODY", new String[]{companyName, botpRuleName, "" + paymentBillNum, paymentBillstr, "" + failureBillNum}) + "\n");
        msgBody.append(failureCause);
        UnPaidBillCenterFacadeControllerBean.sendByMessage(ctx, msgTitle, "administrator", msgBody.toString(), ReceiveMessager);
    }

    public PaymentReportCollection getPaymentReport(Context ctx, String companyId, String billTypeId, int subSystemValue) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        CoreBaseInfo user = (CoreBaseInfo)ctx.get((Object)"UserInfo");
        String userId = user.getId().toString();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("billType", (Object)billTypeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)subSystemValue, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("user", (Object)userId, CompareType.EQUALS));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        ev.setSelector(sic);
        PaymentReportCollection paymentReportCollection = PaymentReportFactory.getLocalInstance(ctx).getPaymentReportCollection(ev);
        return paymentReportCollection;
    }

    public String[] getSourceBillIDS(Context ctx, AutoGenerateRuleInfo AutoGenerateRuleInfo2, String bosType, int subSystemValue, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo) throws EASBizException, BOSException {
        int days = AutoGenerateRuleInfo2.getBeforeDays();
        String className = this.getImplementClass(ctx, bosType, subSystemValue);
        ArrayList paramList = new ArrayList();
        String queryPK = this.getQueryPKByBosType(ctx, bosType, subSystemValue);
        String filterByUser = AutoGenerateRuleInfo2.getFilter();
        String billIDFilter = "";
        EntityViewInfo view = new EntityViewInfo();
        if (AutoGenerateRuleInfo2.getFilterType() == FilterTypeEnum.PAID_NONE) {
            filterByUser = "id is not null";
        }
        try {
            billIDFilter = ((IUnPaidBillID)Class.forName(className).newInstance()).getUnPaidBillCountAndAmount(ctx, companyInfo, periodInfo, days, paramList);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer oql = new StringBuffer("");
        if (!StringUtils.isEmpty((String)billIDFilter)) {
            oql.append("id in (").append(billIDFilter).append(") and ").append(filterByUser);
        } else {
            oql.append(filterByUser);
        }
        String queryOql = "select id  where " + oql.toString();
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, queryOql);
        IRowSet rowSet = iexec.executeQuery();
        HashSet<String> ids = new HashSet<String>();
        try {
            while (rowSet.next()) {
                ids.add(rowSet.getString("id"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String[] result = new String[]{};
        result = ids.toArray(result);
        return result;
    }

    public AutoGenerateRuleCollection getAutoGenerateRuleCollection(Context ctx) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        java.sql.Date now = new java.sql.Date(new Date().getTime());
        filter.getFilterItems().add(new FilterItemInfo("isStart", (Object)EnableStatusEnum.enable, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("startDate <= {d'" + now + "'}"));
        filter.getFilterItems().add(new FilterItemInfo("endDate >= {d'" + now + "'}"));
        ev.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        ev.setSelector(sic);
        AutoGenerateRuleCollection autoGenerateRuleCollection = AutoGenerateRuleFactory.getLocalInstance(ctx).getAutoGenerateRuleCollection(ev);
        return autoGenerateRuleCollection;
    }

    private static void sendByMessage(Context ctx, String msgTitle, String msgSender, String msgBody, String msgReceiver) {
        SenderAgent senderAgent = SenderAgent.getSenderAgent();
        Locale[] lcla = UnPaidBillCenterFacadeControllerBean.getContextLocales(ctx);
        Locale locale2 = null;
        Message message = MessageFactory.newMessage((String)"kingdee.workflow");
        for (Locale locale2 : lcla) {
            message.setLocaleStringHeader("title", msgTitle, locale2);
            message.setLocaleStringHeader("sender", msgSender, locale2);
            message.setLocaleStringHeader("body", msgBody, locale2);
        }
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 50);
        message.setIntHeader("sourceStatus", 0);
        message.setIntHeader("priority", 10);
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("receiver", msgReceiver);
        senderAgent.sendMessage(message);
    }

    private static Locale[] getContextLocales(Context ctx) {
        LanguageCollection langs;
        Locale[] locales = null;
        SolutionInfo solu = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getSolution();
        if (solu != null && (langs = solu.getLanguages()) != null) {
            locales = new Locale[langs.size()];
            for (int i = 0; i < langs.size(); ++i) {
                locales[i] = langs.get(i).getLocale();
            }
        }
        return locales;
    }

    @Override
    protected int _getUnPaidBillCount(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodInfo, String bosType, int subSystemValue) throws BOSException, EASBizException {
        String queryPK = this.getQueryPKByBosType(ctx, bosType, subSystemValue);
        StringBuffer sql = this.getUnPaidCountSql(ctx, companyInfo, periodInfo, queryPK, bosType, subSystemValue);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int rowCount = 0;
        try {
            while (rowSet.next()) {
                rowCount = rowSet.getInt("count");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return rowCount;
    }

    @Override
    protected HashMap _getUnPaidBillCountAndAmountSingleOrg(Context ctx, String fields, String bosType, String filter) throws BOSException, EASBizException {
        String[] fieldArray = fields.split(",");
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        String queryPK = this.getQueryPKByBosType(bosType);
        StringBuffer oql = new StringBuffer("select ").append(fields).append(" where ").append(filter);
        IMetaDataPK mainQueryPK = MetaDataPKFactory.getMetaDataPK((String)queryPK);
        IQueryExecutor iexec = this.getQueryExecutor(ctx, mainQueryPK, oql.toString());
        StringBuffer sql = new StringBuffer("SELECT ");
        for (int i = 0; i < fieldArray.length; ++i) {
            if (i < fieldArray.length - 1) {
                sql.append("\"" + fieldArray[i] + "\" as " + fieldArray[i] + ",");
                continue;
            }
            sql.append("\"" + fieldArray[i] + "\" as " + fieldArray[i] + " ");
        }
        sql.append(" from(" + iexec.getSQL() + ") as tmp");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        for (int i = 0; i < fieldArray.length - 1; ++i) {
            result.put(fieldArray[i], new Double(0.0));
        }
        ArrayList<String> ids = new ArrayList<String>();
        result.put("ids", ids);
        int count = 0;
        try {
            while (rowSet.next()) {
                for (int i = 0; i < fieldArray.length - 1; ++i) {
                    Double amount = (Double)result.get(fieldArray[i]);
                    result.put(fieldArray[i], Double.valueOf(amount + rowSet.getDouble(fieldArray[i])));
                }
                ids.add(rowSet.getString(fieldArray[fieldArray.length - 1]));
                ++count;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        result.put("count", Integer.valueOf(count));
        return result;
    }

    private String getQueryPKByBosType(String bosType) throws EASBizException, BOSException {
        StringBuffer billTypeOql = new StringBuffer("select id, bosObjectType, queryPK where bosObjectType = '").append(bosType).append("'");
        BillTypeInfo billTypeInfo = BillTypeFactory.getRemoteInstance().getBillTypeInfo(billTypeOql.toString());
        String queryPK = billTypeInfo.getQueryPK();
        return queryPK;
    }
}

