/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.FilterTypeEnum;
import com.kingdee.eas.fi.cas.IUnPaidFilter;
import com.kingdee.eas.fi.cas.UnPaidBillCenterException;
import com.kingdee.eas.fi.cas.UnPaidFilterFactory;
import com.kingdee.eas.fi.cas.UnPaidFilterInfo;
import com.kingdee.eas.fi.cas.app.AbstractUnPaidFilterControllerBean;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.vo.UnPaidFilterVO;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class UnPaidFilterControllerBean
extends AbstractUnPaidFilterControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.UnPaidFilterControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        UnPaidFilterInfo info = (UnPaidFilterInfo)model;
        if (info.getUser() == null || info.getUser().getId() == null) {
            UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
            info.setUser(user);
        }
        this.checkFilter(ctx, info);
        return super._save(ctx, model);
    }

    private void checkFilter(Context ctx, UnPaidFilterInfo info) throws BOSException, EASBizException {
        if (info.getCompany() == null || info.getCompany().getId() == null || info.getSubSystem() == null || info.getBillType() == null || info.getBillType().getId() == null || info.getFilterType() == null) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKEMPTY);
        }
        if (info.getFilterType().equals((Object)FilterTypeEnum.PAID_PART) && (info.getFilter() == null || info.getFilter().trim().length() == 0 || info.getFilter().trim().equals("()"))) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKFILTER);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("subSystem", (Object)new Integer(info.getSubSystem().getValue())));
        filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)info.getBillType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("user.id", (Object)info.getUser().getId().toString()));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        if (this.exists(ctx, filter)) {
            throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKDUPLICATE);
        }
        FilterInfo apfilter = new FilterInfo();
        if (info.getBillType().getBosObjectType().equals("48DA3A71") || info.getBillType().getBosObjectType().toString().equals("D001019A")) {
            apfilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)info.getCompany().getId().toString()));
            if (info.getId() != null) {
                apfilter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
            }
            if (info.getBillType().getBosObjectType().toString().equals("48DA3A71")) {
                apfilter.getFilterItems().add(new FilterItemInfo("billType.bosObjectType", (Object)"D001019A"));
                if (this.exists(ctx, apfilter)) {
                    throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKAPPRDUPLICATE, new String[]{info.getCompany().getName()});
                }
            } else {
                apfilter.getFilterItems().add(new FilterItemInfo("billType.bosObjectType", (Object)"48DA3A71"));
                if (this.exists(ctx, apfilter)) {
                    throw new UnPaidBillCenterException(UnPaidBillCenterException.BFS_CHECKAPOBDUPLICATE, new String[]{info.getCompany().getName()});
                }
            }
        }
    }

    @Override
    protected Map _deleteUnPaidFilter(Context ctx, String jsonstr) throws BOSException, EASBizException {
        BatchExecuteResult result = new BatchExecuteResult();
        UnPaidFilterVO dataVO = (UnPaidFilterVO)JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr, UnPaidFilterVO.class);
        IUnPaidFilter iUnPaidFilter = UnPaidFilterFactory.getLocalInstance(ctx);
        ArrayList<ObjectUuidPK> PKList = new ArrayList<ObjectUuidPK>();
        for (String id : dataVO.getDeleteIDs()) {
            PKList.add(new ObjectUuidPK(id));
        }
        int sucDelCount = PKList.size();
        if (sucDelCount > 0) {
            ObjectUuidPK[] sucDelPKArray = new ObjectUuidPK[sucDelCount];
            for (int idx = 0; idx < sucDelCount; ++idx) {
                sucDelPKArray[idx] = (IObjectPK)PKList.get(idx);
            }
            iUnPaidFilter.deleteBatchData((IObjectPK[])sucDelPKArray);
        }
        result.setSummaryMsg(CASWebUtil.getResource(ctx, "DeletedOK"));
        return result;
    }
}

