/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.BookNotifyFacadeFactory;
import com.kingdee.eas.fi.cas.CASCommonWebFacadeFactory;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IBookNotifyFacade;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.app.AbstractVoucherCheckWebFacadeControllerBean;
import com.kingdee.eas.fi.cas.app.BankVcCheckWebHelper;
import com.kingdee.eas.fi.cas.model.BatchExecuteResult;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMException;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.UserOptionInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherCheckWebFacadeControllerBean
extends AbstractVoucherCheckWebFacadeControllerBean {
    public String resourcePath = "com.kingdee.eas.fi.cas.BookNotifyResource";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.VoucherCheckWebFacadeControllerBean");

    @Override
    protected Map _getInitData(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Integer> onloadData = new HashMap<String, Integer>();
        int error = 0;
        Object errorMsg = null;
        Map<String, Object> tempInitData = this.buildInitData();
        onloadData.put("error", error);
        onloadData.put("errorMsg", (Integer)errorMsg);
        return onloadData;
    }

    protected Map<String, Object> buildInitData() {
        HashMap<String, Object> initData = new HashMap<String, Object>();
        return initData;
    }

    @Override
    protected Map _autoCheck(Context ctx, String[] ids, boolean isDoCheck, Date appointTime) throws BOSException, EASBizException {
        boolean error = false;
        Object errorMsg = null;
        HashMap onloadData = new HashMap();
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        ArrayList list = new ArrayList();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        int voucherBookDateSum = 0;
        if (success > 0) {
            for (int i = 0; i < ids.length; ++i) {
                ArrayList<String> realIdList = new ArrayList<String>();
                realIdList.add(ids[i]);
                String voucherCompanyName = null;
                String voucherNumber = null;
                try {
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(this.getFilterInfoByID(realIdList));
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("isCheck"));
                    sic.add(new SelectorItemInfo("company.name"));
                    sic.add(new SelectorItemInfo("bookedDate"));
                    view.setSelector(sic);
                    Iterator iterator = voucher.getVoucherCollection(view).iterator();
                    ArrayList<String> finalIdList = new ArrayList<String>();
                    while (iterator.hasNext()) {
                        VoucherInfo voucherInfo = (VoucherInfo)iterator.next();
                        Date voucherBookDate = this.getVoucherBookDate(ctx, voucherInfo);
                        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)voucherInfo.getCompany());
                        voucherCompanyName = voucherInfo.getCompany().getName();
                        voucherNumber = voucherInfo.getNumber();
                        boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId()), "cas_voucher_02check");
                        if (!isPermission) {
                            throw new CasWebException(CasWebException.NO_CAS_VOUCHER_02CHECK_AUTHRIZED);
                        }
                        Boolean isCheck = voucherInfo.isIsCheck();
                        if (isCheck.booleanValue()) {
                            throw new RuntimeException(CASWebUtil.getResource(ctx, "197_VOUCHER_CHECKED"));
                        }
                        if (currPeriodInfo != null && voucherBookDate != null && currPeriodInfo.getBeginDate().after(voucherBookDate) && !isDoCheck) {
                            ++voucherBookDateSum;
                            throw new RuntimeException(CASWebUtil.getResource(ctx, "196_VoucherNoCheck", new String[]{voucherCompanyName, voucherNumber}));
                        }
                        finalIdList.add(voucherInfo.getId().toString());
                    }
                    if (finalIdList.size() <= 0) continue;
                    voucher.checkVoucherCollection(finalIdList);
                    continue;
                }
                catch (Exception e) {
                    --success;
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "195_VOUCHER_CHECK_FAILED", new String[]{voucherCompanyName, voucherNumber, e.getMessage()}));
                }
            }
        } else {
            error = true;
            summary = summary + CASWebUtil.getResource(ctx, "SelectManualCash");
            result.setSummaryMsg(summary);
            return result;
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "193_ALL_AUTOCHECK_SUCCESS") : summary + CASWebUtil.getResource(ctx, "194_AUTOCHECK_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        if (voucherBookDateSum == ids.length) {
            summary = "";
            result.getDetailMsgList().clear();
        }
        result.put("resultData", list);
        result.setSummaryMsg(summary);
        return result;
    }

    private FilterInfo getFilterInfoByID(List idList) throws BOSException {
        FilterInfo filter = new FilterInfo();
        StringBuffer strFilter = new StringBuffer("");
        for (int i = 0; i < idList.size(); ++i) {
            String strID = idList.get(i).toString();
            if (i > 0) {
                strFilter.append(",");
            }
            strFilter.append(strID);
        }
        FilterInfo filterID = new FilterInfo();
        filterID.getFilterItems().add(new FilterItemInfo("id", (Object)strFilter.toString(), CompareType.INCLUDE));
        filter.mergeFilter(filterID, "and");
        return filter;
    }

    public Date getVoucherBookDate(Context ctx, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        String voucherCompanyId = voucherInfo.getCompany().getId().toString();
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        String companyId = voucherCompanyId;
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
        Map bookUserMap = iUserOption.getUserOptionMap(userInfo.getId().toString(), companyInfo.getId().toString(), "com.kingdee.eas.fi.cas.client.BookUserOptionUI", null);
        Map bookAppointMap = iUserOption.getUserOptionMap(userInfo.getId().toString(), companyInfo.getId().toString(), "com.kingdee.eas.fi.cas.client.BookAppointDateUI", null);
        boolean isBySystemTime = false;
        boolean isByBillTime = true;
        boolean isByBizTime = false;
        boolean isByAppointTime = false;
        if (bookUserMap != null) {
            isBySystemTime = new Boolean((String)bookUserMap.get("kDRadioButtonSystemTime"));
            isByBillTime = new Boolean((String)bookUserMap.get("kDRadioButtonBillTime"));
            isByBizTime = new Boolean((String)bookUserMap.get("kDRadioButtonBizTime"));
            isByAppointTime = new Boolean((String)bookUserMap.get("kDRadioButtonAppointTime"));
        }
        Date bookDate = null;
        if (isBySystemTime) {
            bookDate = DateHelper.getDayBegin();
        } else if (isByBillTime) {
            bookDate = voucherInfo.getBookedDate();
        } else if (isByAppointTime) {
            Map bookDateMap = bookAppointMap;
            if (bookDateMap != null && bookDateMap.get("dpkBookDate") != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    bookDate = sdf.parse(bookDateMap.get("dpkBookDate").toString());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                bookDate = voucherInfo.getBookedDate();
            }
        } else if (isByBizTime) {
            bookDate = voucherInfo.getBizDate();
        }
        return bookDate;
    }

    @Override
    protected Map _beforeCheck(Context ctx, String[] ids, boolean isHandCheck, Date appointTime) throws BOSException, EASBizException {
        int error = 0;
        Object errorMsg = null;
        HashMap onloadData = new HashMap();
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        Boolean isAutoCheck = true;
        CompanyOrgUnitInfo company = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        if (appointTime != null && !appointTime.equals("")) {
            try {
                Date beginDate = DateTimeUtils.truncateDate((Date)VoucherCheckWebFacadeControllerBean.getBeginDateOfCurrentPeriod(ctx));
                Date userDate = DateTimeUtils.truncateDate((Date)appointTime);
                if (userDate.before(beginDate)) {
                    throw new BookNotifyException(BookNotifyException.APPOINT_DATE_ERROR);
                }
                PeriodInfo period = PeriodUtils.getPeriodInfo((Date)userDate, (CompanyOrgUnitInfo)company);
                if (period == null) {
                    throw new BookNotifyException(BookNotifyException.APPOINT_DATE_NOT_VALID);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                error = 1;
                result.setError(error);
                result.setOtherProperty("msg", e.getMessage());
                isAutoCheck = false;
                return result;
            }
            UserOptionInfo userOptionInfo = new UserOptionInfo();
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            userOptionInfo.setName("Hello");
            userOptionInfo.setCreateUser(userInfo);
            userOptionInfo.setCreateDate(new Date());
            userOptionInfo.setCompany(company);
            userOptionInfo.setOptKey("com.kingdee.eas.fi.cas.client.BookAppointDateUI");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
            String ctime = formatter.format(appointTime);
            userOptionInfo.setOptValue("dpkBookDate=" + ctime);
            IUserOption userOption = UserOptionFactory.getLocalInstance((Context)ctx);
            userOptionInfo.setCompany(company);
            userOption.submit(userOptionInfo, false, company.getId().toString());
        }
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        int voucherBookDateSum = 0;
        if (success > 0) {
            ArrayList<String> finalIdList = new ArrayList<String>();
            Object voucherCompanyOldId = null;
            for (int i = 0; i < ids.length; ++i) {
                ArrayList<String> realIdList = new ArrayList<String>();
                realIdList.add(ids[i]);
                String voucherCompanyId = null;
                String voucherCompanyName = null;
                String voucherNumber = null;
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(this.getFilterInfoByID(realIdList));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("isCheck"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("bookedDate"));
                sic.add(new SelectorItemInfo("bizDate"));
                view.setSelector(sic);
                for (VoucherInfo voucherInfo : voucher.getVoucherCollection(view)) {
                    Date voucherBookDate = this.getVoucherBookDate(ctx, voucherInfo);
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)voucherInfo.getCompany());
                    voucherCompanyId = voucherInfo.getCompany().getId().toString();
                    voucherCompanyName = voucherInfo.getCompany().getName();
                    voucherNumber = voucherInfo.getNumber();
                    Boolean isCheck = voucherInfo.isIsCheck();
                    if (!isCheck.booleanValue()) {
                        finalIdList.add(voucherInfo.getId().toString());
                        if (currPeriodInfo == null || voucherBookDate == null || !currPeriodInfo.getBeginDate().after(voucherBookDate)) continue;
                        result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "188_VoucherCheckList", new String[]{voucherCompanyName, voucherNumber}));
                        isAutoCheck = false;
                        ++voucherBookDateSum;
                        continue;
                    }
                    finalIdList.add(voucherInfo.getId().toString());
                    result.setOtherProperty("reFresh", false);
                    isAutoCheck = true;
                }
            }
            if (finalIdList.size() <= 0) {
                summary = summary + CASWebUtil.getResource(ctx, "189_hasNotValidRecord");
                result.setSummaryMsg(summary);
                isAutoCheck = false;
                return result;
            }
        } else {
            error = 1;
            summary = summary + CASWebUtil.getResource(ctx, "190_NO_ROW_SELECTED");
            result.setSummaryMsg(summary);
            isAutoCheck = false;
            return result;
        }
        if (isHandCheck) {
            if (voucherBookDateSum > 0) {
                summary = summary + CASWebUtil.getResource(ctx, "258_VoucherBookOneDate", new String[]{String.valueOf(voucherBookDateSum)});
                result.setOtherProperty("reFresh", false);
            }
            result.setSummaryMsg(summary);
            result.setOtherProperty("isAutoCheck", isAutoCheck);
            return result;
        }
        if (isAutoCheck.booleanValue()) {
            result.putAll(this._autoCheck(ctx, ids, true, null));
            result.setOtherProperty("reFresh", true);
            result.setOtherProperty("isAutoCheck", isAutoCheck);
            return result;
        }
        if (voucherBookDateSum > 0) {
            summary = summary + CASWebUtil.getResource(ctx, "258_VoucherBookOneDate", new String[]{String.valueOf(voucherBookDateSum)});
            result.setOtherProperty("reFresh", false);
        }
        String detailMsg = "";
        if (result.getDetailMsgList().size() > 0) {
            int detailMsgSize = result.getDetailMsgList().size();
            for (int g = 0; g < detailMsgSize - 1; ++g) {
                detailMsg = detailMsg + result.getDetailMsgList().get(g) + "<br>";
            }
            detailMsg = detailMsg + result.getDetailMsgList().get(detailMsgSize - 1);
            result.setOtherProperty("detailMsg", detailMsg);
        }
        result.setSummaryMsg(summary);
        result.setOtherProperty("isAutoCheck", isAutoCheck);
        return result;
    }

    public static boolean isAssociationCashManagement(Context ctx, CompanyOrgUnitInfo company) {
        try {
            IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
            String strValue = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(company.getId()), "CS001");
            if (strValue == null || strValue.length() == 0) {
                return false;
            }
            int bookType = Integer.parseInt(strValue);
            if (bookType != 1) {
                return false;
            }
            boolean association = false;
            association = SystemStatusCtrolUtils.isRelAccount(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
            return association;
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        return false;
    }

    @Override
    protected Map _cancelCheck(Context ctx, String[] ids) throws BOSException, EASBizException {
        boolean error = false;
        Object errorMsg = null;
        HashMap onloadData = new HashMap();
        ArrayList list = new ArrayList();
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        if (success > 0) {
            for (int i = 0; i < ids.length; ++i) {
                ArrayList<String> realIdList = new ArrayList<String>();
                realIdList.add(ids[i]);
                String voucherCompanyName = null;
                String voucherNumber = null;
                try {
                    EntityViewInfo view = new EntityViewInfo();
                    view.setFilter(this.getFilterInfoByID(realIdList));
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("isCheck"));
                    sic.add(new SelectorItemInfo("company.name"));
                    view.setSelector(sic);
                    Iterator iterator = voucher.getVoucherCollection(view).iterator();
                    ArrayList<BOSUuid> finalIdList = new ArrayList<BOSUuid>();
                    while (iterator.hasNext()) {
                        VoucherInfo voucherInfo = (VoucherInfo)iterator.next();
                        Date voucherBookDate = this.getVoucherBookDate(ctx, voucherInfo);
                        voucherCompanyName = voucherInfo.getCompany().getName();
                        voucherNumber = voucherInfo.getNumber();
                        PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)voucherInfo.getCompany());
                        if (CheckUtils.exist((Object)currPeriodInfo) && currPeriodInfo.isIsAdjustPeriod()) {
                            throw new FMException(FMException.CURRPERIODISADJUST);
                        }
                        boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(voucherInfo.getCompany().getId()), "cas_voucher_03cancelCheck");
                        if (!isPermission) {
                            throw new CasWebException(CasWebException.NO_CAS_VOUCHER_03CANCELCHECK_AUTHRIZED);
                        }
                        Boolean isCheck = voucherInfo.isIsCheck();
                        if (!isCheck.booleanValue()) {
                            throw new RuntimeException(CASWebUtil.getResource(ctx, "198__VOUCHER_CANCELCHECKED"));
                        }
                        finalIdList.add(voucherInfo.getId());
                    }
                    if (finalIdList.size() <= 0) {
                        summary = summary + CASWebUtil.getResource(ctx, "202_hasNotValidRecord");
                        result.setSummaryMsg(summary);
                        return result;
                    }
                    voucher.antiCheckVoucher((IObjectPK)new ObjectUuidPK(ids[i]));
                    continue;
                }
                catch (Exception e) {
                    --success;
                    result.getDetailMsgList().add(CASWebUtil.getResource(ctx, "199_VOUCHER_CANCELCHECK_FAILED", new String[]{voucherCompanyName, voucherNumber, e.getMessage()}));
                }
            }
        } else {
            error = true;
            summary = summary + CASWebUtil.getResource(ctx, "203_PLEASESELECTCANCELDATA");
            result.setSummaryMsg(summary);
            return result;
        }
        summary = success == ids.length ? summary + CASWebUtil.getResource(ctx, "200_ALL_CANCELCHECK_SUCCESS") : summary + CASWebUtil.getResource(ctx, "201_CANCELCHECK_RESULT", new String[]{String.valueOf(success), String.valueOf(ids.length - success)});
        result.setSummaryMsg(summary);
        return result;
    }

    @Override
    protected Map _getNotifyEditInitData(Context ctx, String id, String status) throws BOSException, EASBizException {
        boolean error = false;
        Object errorMsg = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        String builderName = "com.kingdee.eas.fi.gl.VoucherBookNotifyBuilder";
        try {
            JournalCollection coll = this.getJournalCollection(ctx, builderName, id, status);
            VoucherInfo voucherInfo = new VoucherInfo();
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            voucherInfo = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(id), VoucherCheckWebFacadeControllerBean.getVoucherSelector());
            if (coll != null && coll.size() != 0) {
                boolean isPermission;
                JournalInfo journalInfo = coll.get(0);
                Date bookDate = null;
                bookDate = journalInfo.getCreateDate().before(journalInfo.getBizDate()) ? journalInfo.getBizDate() : journalInfo.getCreateDate();
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(journalInfo.getCompany().getId());
                company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
                onloadData.put("company", company);
                onloadData.put("status", status);
                onloadData.put("datePicker", bookDate);
                String txtVoucherType = journalInfo.getVoucherType().toString();
                String txtVoucherNumber = journalInfo.getVoucherNumber();
                onloadData.put("voucher", txtVoucherType + txtVoucherNumber);
                onloadData.put("voucherId", id);
                onloadData.put("voucherNumber", txtVoucherNumber);
                VoucherTypeInfo voucherType = journalInfo.getVoucherType();
                onloadData.put("voucherType", voucherType);
                String[] args = new String[]{String.valueOf(journalInfo.getPeriod().getPeriodYear()), String.valueOf(journalInfo.getPeriod().getPeriodNumber())};
                MessageFormat mf = new MessageFormat(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)ctx.getLocale()));
                String result = mf.format(args);
                onloadData.put("period", result);
                onloadData.put("periodId", journalInfo.getPeriod().getId().toString());
                Calendar c1 = Calendar.getInstance();
                c1.setTime(bookDate);
                int year = c1.get(1);
                int month = c1.get(2) + 1;
                int day = c1.get(5);
                String labelMsg = CASWebUtil.getResource(ctx, "276_VoucherBookNotifyEdit_labelMsg", new String[]{company.getName(), result, year + "", month + "", day + "", txtVoucherType + " " + txtVoucherNumber});
                onloadData.put("labelMsg", labelMsg);
                if (!status.equals("VIEW") && !(isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(company.getId()), "cas_voucher_02check"))) {
                    throw new CasWebException(CasWebException.NO_CAS_VOUCHER_02CHECK_AUTHRIZED);
                }
                ArrayList loadData = new ArrayList();
                StringBuffer currencyFilter = new StringBuffer("id in (");
                CurrencyCollection commonCurrencyInitColl = new CurrencyCollection();
                StringBuffer accountBankFilter = new StringBuffer("id in (");
                AccountBankCollection commonAccountBankInitColl = new AccountBankCollection();
                StringBuffer accountViewFilter = new StringBuffer("id in (");
                AccountViewCollection commonAccountViewInitColl = new AccountViewCollection();
                StringBuffer oppAccountViewFilter = new StringBuffer("id in (");
                AccountViewCollection commonOppAccountViewInitColl = new AccountViewCollection();
                StringBuffer oppAccountView_Filter = new StringBuffer("id in (");
                AccountViewCollection commonOpp_oppAccountView_Filter = new AccountViewCollection();
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    if (coll.get(i).getBizDate() != null) {
                        row.put("bizDate", coll.get(i).getBizDate());
                    }
                    if (coll.get(i).getType() != null) {
                        row.put("journalType", coll.get(i).getType());
                    }
                    if (coll.get(i).getCurrency() != null) {
                        row.put("currency", coll.get(i).getCurrency());
                        int precision = this.getPrecision(ctx, coll.get(i).getCurrency().getId().toString());
                        row.put("precision", precision);
                        if (!commonCurrencyInitColl.contains(coll.get(i).getCurrency())) {
                            commonCurrencyInitColl.add(coll.get(i).getCurrency());
                            currencyFilter.append("'" + coll.get(i).getCurrency().getId().toString() + "',");
                        }
                    }
                    if (coll.get(i).getBillEntryID() != null) {
                        row.put("billEntryID", coll.get(i).getBillEntryID());
                    }
                    if (coll.get(i).getAccountBank() != null) {
                        row.put("bankAccount", coll.get(i).getAccountBank());
                        if (!commonAccountBankInitColl.contains(coll.get(i).getAccountBank())) {
                            commonAccountBankInitColl.add(coll.get(i).getAccountBank());
                            accountBankFilter.append("'" + coll.get(i).getAccountBank().getId().toString() + "',");
                        }
                    }
                    if (coll.get(i).getAccountView() != null) {
                        AccountViewInfo accountView = new AccountViewInfo();
                        accountView = coll.get(i).getAccountView();
                        accountView.setCompanyID(company);
                        accountView.setAccountTableID(company.getAccountTable());
                        row.put("accountView", accountView);
                        if (!commonAccountViewInitColl.contains(coll.get(i).getAccountView())) {
                            commonAccountViewInitColl.add(coll.get(i).getAccountView());
                            accountViewFilter.append("'" + coll.get(i).getAccountView().getId().toString() + "',");
                        }
                        if (!commonOppAccountViewInitColl.contains(coll.get(i).getAccountView())) {
                            commonOppAccountViewInitColl.add(coll.get(i).getAccountView());
                            oppAccountViewFilter.append("'" + coll.get(i).getAccountView().getId().toString() + "',");
                        }
                    }
                    if (coll.get(i).getDescription() != null) {
                        row.put("summary", coll.get(i).getDescription().toString());
                    }
                    if (coll.get(i).getOppAccountView() != null) {
                        AccountViewInfo oppAccountView = new AccountViewInfo();
                        oppAccountView = coll.get(i).getOppAccountView();
                        oppAccountView.setCompanyID(company);
                        oppAccountView.setAccountTableID(company.getAccountTable());
                        row.put("oppAccountView", oppAccountView);
                        if (!commonOppAccountViewInitColl.contains(coll.get(i).getOppAccountView())) {
                            commonOppAccountViewInitColl.add(coll.get(i).getOppAccountView());
                            oppAccountViewFilter.append("'" + coll.get(i).getOppAccountView().getId().toString() + "',");
                        }
                    }
                    if (coll.get(i).getSettlementType() != null) {
                        row.put("settlementType", coll.get(i).getSettlementType());
                    }
                    if (coll.get(i).getSettlementNumber() != null) {
                        row.put("settlementNumber", coll.get(i).getSettlementNumber().toString());
                    }
                    AccountViewInfo accountView = coll.get(i).getAccountView();
                    BalanceDirectionEnum direction = VoucherCheckWebFacadeControllerBean.getAccountDirection(voucherInfo, accountView);
                    AccountViewCollection colls = new AccountViewCollection();
                    AccountViewCollection accountCollections = VoucherCheckWebFacadeControllerBean.getAccountCollectionByVoucherId(voucherInfo);
                    for (int j = 0; j < accountCollections.size(); ++j) {
                        AccountViewInfo account = (AccountViewInfo)accountCollections.getObject(j);
                        BalanceDirectionEnum direction2 = VoucherCheckWebFacadeControllerBean.getAccountDirection(voucherInfo, account);
                        if (direction.getValue() == direction2.getValue()) continue;
                        colls.add(account);
                        oppAccountView_Filter.append("'" + account.getId().toString() + "',");
                    }
                    oppAccountView_Filter.deleteCharAt(oppAccountView_Filter.length() - 1);
                    oppAccountView_Filter.append(") ");
                    row.put("oppAccountView_Filter", oppAccountView_Filter);
                    oppAccountView_Filter = new StringBuffer("id in (");
                    if (coll.get(i).getDebitAmount() != null) {
                        row.put("debitAmount", coll.get(i).getDebitAmount());
                        row.put("direction", "debit");
                    }
                    if (coll.get(i).getCreditAmount() != null) {
                        row.put("creditAmount", coll.get(i).getCreditAmount());
                        row.put("direction", "credit");
                    }
                    loadData.add(row);
                }
                currencyFilter.deleteCharAt(currencyFilter.length() - 1);
                currencyFilter.append(") ");
                onloadData.put("currencyF7Filter", currencyFilter);
                if (accountBankFilter.equals("id in ( ")) {
                    accountBankFilter = new StringBuffer("id in ('NE')");
                } else {
                    accountBankFilter.deleteCharAt(accountBankFilter.length() - 1);
                    accountBankFilter.append(") ");
                }
                onloadData.put("accountBankFilter", accountBankFilter);
                accountViewFilter.deleteCharAt(accountViewFilter.length() - 1);
                accountViewFilter.append(") ");
                onloadData.put("accountViewFilter", accountViewFilter);
                oppAccountViewFilter.deleteCharAt(oppAccountViewFilter.length() - 1);
                oppAccountViewFilter.append(") ");
                onloadData.put("oppAccountViewFilter", oppAccountViewFilter);
                if (commonCurrencyInitColl.size() == 1) {
                    onloadData.put("currencyF7Count", commonCurrencyInitColl.size());
                }
                if (commonAccountBankInitColl.size() == 1) {
                    onloadData.put("accountBankF7Count", commonAccountBankInitColl.size());
                }
                if (commonAccountViewInitColl.size() == 1) {
                    onloadData.put("accountViewF7Count", commonAccountViewInitColl.size());
                }
                if (commonOppAccountViewInitColl.size() == 1) {
                    onloadData.put("oppAccountViewF7Count", commonOppAccountViewInitColl.size());
                }
                onloadData.put("onloadData", loadData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            e.printStackTrace();
            onloadData.put("error", 1);
            onloadData.put("errorMsg", e.getMessage());
        }
        return onloadData;
    }

    private int getPrecision(Context ctx, String currencyId) {
        String str = "select fid,fprecision from t_bd_currency where fid ='" + currencyId + "'";
        ISQLExecutor sqlExe = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)str);
        IRowSet rs = null;
        try {
            rs = sqlExe.executeSQL();
            if (rs.next()) {
                return new Integer(rs.getInt(2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 10;
    }

    public JournalCollection getJournalCollection(Context ctx, String builderName, String billId, String status) throws Exception {
        JournalCollection coll = null;
        if (status.equals(OprtState.ADDNEW)) {
            coll = this.getJournalCollectionByParsing(ctx, builderName, billId);
        } else if ((status.equals("EDIT") || status.equals("VIEW")) && ((coll = this.getJournalCollectionByBillID(ctx, billId)) == null || coll.size() == 0)) {
            throw new BookNotifyException(BookNotifyException.NOT_CHECK);
        }
        return coll;
    }

    private static BalanceDirectionEnum getAccountDirection(VoucherInfo voucherInfo, AccountViewInfo accountView) {
        for (int i = 0; i < voucherInfo.getEntries().size(); ++i) {
            VoucherEntryInfo entry = voucherInfo.getEntries().get(i);
            if (!entry.getAccount().getId().equals((Object)accountView.getId())) continue;
            if (entry.getEntryDC().getValue() == 0) {
                return BalanceDirectionEnum.CREDIT;
            }
            return BalanceDirectionEnum.DEBIT;
        }
        return null;
    }

    public static AccountViewCollection getAccountCollectionByVoucherId(VoucherInfo voucherInfo) throws Exception {
        AccountViewCollection accountViewCollection = new AccountViewCollection();
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        VoucherEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (accountViewCollection.contains(entryInfo.getAccount())) continue;
            accountViewCollection.add(entryInfo.getAccount());
        }
        return accountViewCollection;
    }

    private JournalCollection getJournalCollectionByParsing(Context ctx, String builderName, String billId) throws Exception {
        IBookNotifyFacade notifyFacade = BookNotifyFacadeFactory.getLocalInstance(ctx);
        JournalCollection coll = notifyFacade.genJournalCollection(builderName, billId);
        for (int i = 0; i < coll.size(); ++i) {
            JournalInfo info = coll.get(i);
            if (info.getDebitAmount().compareTo(new BigDecimal("0")) == 0) {
                info.setDebitAmount(null);
            }
            if (info.getCreditAmount().compareTo(new BigDecimal("0")) != 0) continue;
            info.setCreditAmount(null);
        }
        return coll;
    }

    private JournalCollection getJournalCollectionByBillID(Context ctx, String billId) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("accountBank.*"));
        sic.add(new SelectorItemInfo("accountView.number"));
        sic.add(new SelectorItemInfo("accountView.name"));
        sic.add(new SelectorItemInfo("oppAccountBank.name"));
        sic.add(new SelectorItemInfo("planItem.name"));
        sic.add(new SelectorItemInfo("oppAccountView.number"));
        sic.add(new SelectorItemInfo("oppAccountView.name"));
        sic.add(new SelectorItemInfo("settlementType.name"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("*"));
        evi.setFilter(fi);
        JournalCollection coll = null;
        coll = JournalFactory.getLocalInstance(ctx).getJournalCollection(evi);
        if (coll == null || coll.size() == 0) {
            EntityViewInfo vEvi = new EntityViewInfo();
            FilterInfo vFi = new FilterInfo();
            vFi.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId));
            SelectorItemCollection vSic = vEvi.getSelector();
            vSic.add(new SelectorItemInfo("id"));
            vEvi.setFilter(vFi);
            VoucherEntryCollection VeColl = VoucherEntryFactory.getLocalInstance((Context)ctx).getVoucherEntryCollection(vEvi);
            HashSet<String> set = new HashSet<String>();
            if (VeColl != null && VeColl.size() != 0) {
                for (int i = 0; i < VeColl.size(); ++i) {
                    set.add(VeColl.get(i).getId().toString());
                }
                fi.getFilterItems().clear();
                fi.getFilterItems().add(new FilterItemInfo("billId", set, CompareType.INCLUDE));
                coll = JournalFactory.getLocalInstance(ctx).getJournalCollection(evi);
            }
        }
        JournalInfo info = null;
        for (int i = 0; i < coll.size(); ++i) {
            info = coll.get(i);
            if (info.getDebitAmount().compareTo(new BigDecimal("0")) == 0) {
                info.setDebitAmount(null);
            }
            if (info.getCreditAmount().compareTo(new BigDecimal("0")) != 0) continue;
            info.setCreditAmount(null);
        }
        return coll;
    }

    @Override
    protected Map _saveNotifyEditInitData(Context ctx, String modelStr) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int error = 0;
        String msg = null;
        List journalListData = null;
        JournalCollection journalCollection = new JournalCollection();
        try {
            HashMap modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr);
            String companyId = (String)modelMap.get("companyId");
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            company.setId(BOSUuid.read((String)companyId));
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()));
            PeriodInfo period = new PeriodInfo();
            period.setId(BOSUuid.read((String)((String)modelMap.get("periodId"))));
            period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(period.getId().toString()));
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date datePicker = sdf.parse(modelMap.get("datePicker").toString());
            Date beginDate = DateTimeUtils.truncateDate((Date)VoucherCheckWebFacadeControllerBean.getBeginDateOfCurrentPeriod(ctx));
            period = PeriodUtils.getPeriodInfo(null, (Date)datePicker, (CompanyOrgUnitInfo)company);
            if (period == null) {
                throw new RuntimeException(ResourceBase.getString((String)this.resourcePath, (String)"PEROID_INVALAID", (Locale)ctx.getLocale()));
            }
            beginDate = period.getBeginDate();
            if (datePicker.before(beginDate)) {
                throw new RuntimeException(ResourceBase.getString((String)this.resourcePath, (String)"APPOINT_DATE_ERROR", (Locale)ctx.getLocale()));
            }
            String voucherNumber = (String)modelMap.get("voucherNumber");
            String voucherId = (String)modelMap.get("voucherId");
            VoucherInfo voucherInfo = new VoucherInfo();
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
            voucherInfo = (VoucherInfo)iVoucher.getValue((IObjectPK)new ObjectUuidPK(voucherId), VoucherCheckWebFacadeControllerBean.getVoucherSelector());
            String voucherTypeId = (String)modelMap.get("voucherTypeId");
            VoucherTypeInfo voucherType = new VoucherTypeInfo();
            voucherType.setId(BOSUuid.read((String)voucherTypeId));
            if (modelMap.get("editGridData") != null) {
                journalListData = (List)modelMap.get("editGridData");
            }
            Object currencyId = null;
            boolean prec = false;
            for (int i = 0; i < journalListData.size(); ++i) {
                JournalInfo info = new JournalInfo();
                Map row = (Map)journalListData.get(i);
                info.setVoucherId(voucherId);
                info.setBizDate(sdf.parse(row.get("bizDate").toString()));
                if (row.get("journalType").toString() == null || row.get("journalType").toString().equals("")) {
                    int seq = i + 1;
                    throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"291_VoucherCheckWebFacadeControllerBean", (Locale)ctx.getLocale()) + seq + ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"292_VoucherCheckWebFacadeControllerBean", (Locale)ctx.getLocale()));
                }
                if (Double.valueOf(row.get("journalType").toString()) - Double.valueOf(JournalTypeEnum.BANK.getValue()) == 0.0) {
                    info.setType(JournalTypeEnum.BANK);
                } else if (Double.valueOf(row.get("journalType").toString()) - Double.valueOf(JournalTypeEnum.CASH.getValue()) == 0.0) {
                    info.setType(JournalTypeEnum.CASH);
                }
                UserInfo cashier = new UserInfo();
                cashier = UserFactory.getLocalInstance((Context)ctx).getUserByID(ctx.getCaller());
                info.setCashier(cashier);
                CurrencyInfo currency = new CurrencyInfo();
                currency.setId(BOSUuid.read((String)((String)((Map)row.get("currency")).get("id"))));
                info.setCurrency(currency);
                AccountBankInfo accountBank = new AccountBankInfo();
                if (row.get("bankAccount") != null && !row.get("bankAccount").equals("")) {
                    accountBank.setId(BOSUuid.read((String)((String)((Map)row.get("bankAccount")).get("id"))));
                    info.setAccountBank(accountBank);
                }
                AccountViewInfo accountView = new AccountViewInfo();
                accountView.setId(BOSUuid.read((String)((String)((Map)row.get("accountView")).get("id"))));
                info.setAccountView(accountView);
                if (row.get("summary") != null) {
                    info.setDescription(row.get("summary").toString());
                }
                AccountViewInfo oppAccountView = new AccountViewInfo();
                oppAccountView.setId(BOSUuid.read((String)((String)((Map)row.get("oppAccountView")).get("id"))));
                info.setOppAccountView(oppAccountView);
                SettlementTypeInfo settlementType = new SettlementTypeInfo();
                if (row.get("settlementType") != null && !row.get("settlementType").equals("")) {
                    settlementType.setId(BOSUuid.read((String)((String)((Map)row.get("settlementType")).get("id"))));
                    info.setSettlementType(settlementType);
                }
                if (row.get("settlementNumber") != null) {
                    info.setSettlementNumber(row.get("settlementNumber").toString());
                }
                if (row.get("debitAmount") != null && !row.get("debitAmount").equals("")) {
                    BigDecimal debitAmount = new BigDecimal(row.get("debitAmount").toString());
                    info.setDebitAmount(debitAmount);
                }
                if (row.get("creditAmount") != null && !row.get("creditAmount").equals("")) {
                    BigDecimal creditAmount = new BigDecimal(row.get("creditAmount").toString());
                    info.setCreditAmount(creditAmount);
                }
                if (row.get("billEntryID") != null) {
                    info.setBillEntryID((String)row.get("billEntryID"));
                }
                info.setCreateDate(datePicker);
                info.setVoucherType(voucherType);
                info.setPeriod(period);
                info.setVoucherNumber(voucherNumber);
                info.setBillNumber(voucherNumber);
                info.setVerifyStatus(VerifyScopeEnum.NOVA);
                info.setSource(JournalSourceEnum.BYVOUCHER);
                if (info.getBillId() == null) {
                    if (row.get("billEntryID") != null) {
                        info.setBillId((String)row.get("billEntryID"));
                    } else {
                        info.setBillId(voucherId);
                    }
                }
                if (info.getBillType() == null) {
                    info.setBillType(BillTypeEnum.voucher);
                }
                if (info.getDebitAmount() == null) {
                    info.setDebitAmount(FMConstants.ZERO);
                    info.setIsDebit(true);
                }
                if (info.getCreditAmount() == null) {
                    info.setCreditAmount(FMConstants.ZERO);
                    info.setIsDebit(false);
                }
                if (info.getCompany() == null) {
                    info.setCompany(company);
                }
                journalCollection.add(info);
            }
            this.checkCurrencyAndAmount(journalCollection, voucherInfo);
            IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
            if (journalCollection == null || journalCollection.size() == 0) {
                msg = CASWebUtil.getResource(ctx, "SAVE_FAIL");
            } else {
                voucher.checkVoucher((IObjectCollection)journalCollection, (IObjectPK)new ObjectUuidPK(voucherId));
            }
            msg = CASWebUtil.getResource(ctx, "280_handCheckSaveSuccess");
        }
        catch (Exception e) {
            e.printStackTrace();
            error = 1;
            msg = e.getMessage();
            logger.error((Object)e);
            e.printStackTrace();
            result.put("error", 1);
            result.put("errorMsg", e.getMessage());
        }
        result.put("error", error);
        result.put("summaryMsg", msg);
        return result;
    }

    public static SelectorItemCollection getVoucherSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.account.name"));
        sic.add(new SelectorItemInfo("entries.account.longName"));
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.originalAmount"));
        sic.add(new SelectorItemInfo("entries.entryDC"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.bankAccount.*"));
        return sic;
    }

    public static Date getBeginDateOfCurrentPeriod(Context ctx) throws Exception {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        if (startPeriod != null) {
            return startPeriod.getBeginDate();
        }
        return new Date();
    }

    public void checkCurrencyAndAmount(JournalCollection journalCollection, VoucherInfo voucherInfo) throws Exception {
        BigDecimal journalCashDebit = CasConstants.ZERO;
        BigDecimal journalCashCredit = CasConstants.ZERO;
        BigDecimal journalBankDebit = CasConstants.ZERO;
        BigDecimal journalBankCredit = CasConstants.ZERO;
        BigDecimal voucherCashDebit = CasConstants.ZERO;
        BigDecimal voucherCashCredit = CasConstants.ZERO;
        BigDecimal voucherBankDebit = CasConstants.ZERO;
        BigDecimal voucherBankCredit = CasConstants.ZERO;
        BigDecimal tempDebitAmount = CasConstants.ZERO;
        BigDecimal tempCreditAmount = CasConstants.ZERO;
        Object row = null;
        for (int i = 0; i < journalCollection.size(); ++i) {
            JournalInfo info = new JournalInfo();
            info = journalCollection.get(i);
            JournalTypeEnum type = info.getType();
            if (type.equals((Object)JournalTypeEnum.CASH)) {
                tempDebitAmount = info.getDebitAmount();
                tempCreditAmount = info.getCreditAmount();
                if (tempDebitAmount == null) {
                    tempDebitAmount = CasConstants.ZERO;
                }
                if (tempCreditAmount == null) {
                    tempCreditAmount = CasConstants.ZERO;
                }
                journalCashDebit = journalCashDebit.add(tempDebitAmount);
                journalCashCredit = journalCashCredit.add(tempCreditAmount);
            }
            if (!type.equals((Object)JournalTypeEnum.BANK)) continue;
            tempDebitAmount = info.getDebitAmount();
            tempCreditAmount = info.getCreditAmount();
            if (tempDebitAmount == null) {
                tempDebitAmount = CasConstants.ZERO;
            }
            if (tempCreditAmount == null) {
                tempCreditAmount = CasConstants.ZERO;
            }
            journalBankDebit = journalBankDebit.add(tempDebitAmount);
            journalBankCredit = journalBankCredit.add(tempCreditAmount);
        }
        VoucherEntryCollection entryCollection = voucherInfo.getEntries();
        VoucherEntryInfo entryInfo = null;
        for (int i = 0; i < entryCollection.size(); ++i) {
            entryInfo = entryCollection.get(i);
            if (entryInfo.getAccount().isIsCash()) {
                tempDebitAmount = CasConstants.ZERO;
                tempCreditAmount = CasConstants.ZERO;
                if (entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                    tempCreditAmount = entryInfo.getOriginalAmount();
                }
                if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                    tempDebitAmount = entryInfo.getOriginalAmount();
                }
                voucherCashDebit = voucherCashDebit.add(tempDebitAmount);
                voucherCashCredit = voucherCashCredit.add(tempCreditAmount);
            }
            if (!entryInfo.getAccount().isIsBank()) continue;
            tempDebitAmount = CasConstants.ZERO;
            tempCreditAmount = CasConstants.ZERO;
            if (entryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                tempCreditAmount = entryInfo.getOriginalAmount();
            }
            if (entryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                tempDebitAmount = entryInfo.getOriginalAmount();
            }
            voucherBankDebit = voucherBankDebit.add(tempDebitAmount);
            voucherBankCredit = voucherBankCredit.add(tempCreditAmount);
        }
        if (journalCashDebit.compareTo(voucherCashDebit) != 0) {
            throw new RuntimeException(MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"CashDebitNotEqual"), journalCashDebit, voucherCashDebit));
        }
        if (journalCashCredit.compareTo(voucherCashCredit) != 0) {
            throw new RuntimeException(MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"CashCreditNotEqual"), journalCashCredit, voucherCashCredit));
        }
        if (journalBankDebit.compareTo(voucherBankDebit) != 0) {
            throw new RuntimeException(MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"BankDebitNotEqual"), journalBankDebit, voucherBankDebit));
        }
        if (journalBankCredit.compareTo(voucherBankCredit) != 0) {
            throw new RuntimeException(MessageFormat.format(EASResource.getString((String)this.resourcePath, (String)"BankCreditNotEqual"), journalBankCredit, voucherBankCredit));
        }
        this.checkAssiantNew(journalCollection, voucherInfo);
        this.checkAccount(journalCollection, voucherInfo);
    }

    public void checkAssiantNew(JournalCollection journalCollection, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        BigDecimal assistantAmount = CasConstants.ZERO;
        BigDecimal entryCreditAmount = CasConstants.ZERO;
        BigDecimal entryDebitAmount = CasConstants.ZERO;
        BigDecimal entryAmountTotal = CasConstants.ZERO;
        BigDecimal tmpAmount = CasConstants.ZERO;
        AccountBankInfo assiBankAcct = null;
        AccountBankInfo bankAcct = null;
        Object row = null;
        String acctId = null;
        HashMap<String, BigDecimal> assistantMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryMap = new HashMap<String, BigDecimal>();
        String key2 = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            VoucherAssistRecordCollection voucherAssistRecordColl;
            VoucherEntryInfo voucherEntryInfo = entryColl.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            if (!accountViewInfo.isIsBank() || (voucherAssistRecordColl = voucherEntryInfo.getAssistRecords()) == null || voucherAssistRecordColl.size() == 0) continue;
            for (int j = 0; j < voucherAssistRecordColl.size(); ++j) {
                VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordColl.get(j);
                if (assistRecordInfo.getAssGrp() == null || (assiBankAcct = assistRecordInfo.getAssGrp().getBankAccount()) == null) continue;
                acctId = assiBankAcct.getId().toString();
                key2 = voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "debit" + acctId : "credit" + acctId;
                assistantAmount = assistRecordInfo.getOriginalAmount();
                if (assistantMap.containsKey(key2)) {
                    tmpAmount = (BigDecimal)assistantMap.get(key2);
                    tmpAmount = tmpAmount.add(assistantAmount);
                    assistantMap.remove(key2);
                    assistantMap.put(key2, tmpAmount);
                    continue;
                }
                assistantMap.put(key2, assistantAmount);
            }
        }
        JournalInfo info = new JournalInfo();
        for (int k = 0; k < journalCollection.size(); ++k) {
            info = journalCollection.get(k);
            bankAcct = info.getAccountBank();
            if (bankAcct == null) continue;
            acctId = bankAcct.getId().toString();
            entryCreditAmount = info.getCreditAmount();
            entryDebitAmount = info.getDebitAmount();
            if (entryCreditAmount != null && entryCreditAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryCreditAmount;
                key2 = "credit" + acctId;
            }
            if (entryDebitAmount != null && entryDebitAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryDebitAmount;
                key2 = "debit" + acctId;
            }
            if (entryMap.containsKey(key2)) {
                tmpAmount = (BigDecimal)entryMap.get(key2);
                tmpAmount = tmpAmount.add(entryAmountTotal);
                entryMap.remove(key2);
                entryMap.put(key2, tmpAmount);
                continue;
            }
            entryMap.put(key2, entryAmountTotal);
        }
        Set keySet = assistantMap.keySet();
        for (String key2 : keySet) {
            assistantAmount = assistantMap.containsKey(key2) ? (BigDecimal)assistantMap.get(key2) : CasConstants.ZERO;
            if (assistantAmount.compareTo(entryAmountTotal = entryMap.containsKey(key2) ? (BigDecimal)entryMap.get(key2) : CasConstants.ZERO) == 0) continue;
            throw new RuntimeException(EASResource.getString((String)this.resourcePath, (String)"AmountNotEqual"));
        }
    }

    public void checkAccount(JournalCollection journalCollection, VoucherInfo voucherInfo) throws EASBizException, BOSException {
        VoucherEntryCollection entryColl = voucherInfo.getEntries();
        BigDecimal assistantAmount = CasConstants.ZERO;
        BigDecimal entryCreditAmount = CasConstants.ZERO;
        BigDecimal entryDebitAmount = CasConstants.ZERO;
        BigDecimal entryAmountTotal = CasConstants.ZERO;
        BigDecimal tmpAmount = CasConstants.ZERO;
        Object row = null;
        String acctId = null;
        HashMap<String, BigDecimal> assistantMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> entryMap = new HashMap<String, BigDecimal>();
        String key2 = null;
        for (int i = 0; i < entryColl.size(); ++i) {
            VoucherEntryInfo voucherEntryInfo = entryColl.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            if (!accountViewInfo.isIsBank() && !accountViewInfo.isIsCash()) continue;
            acctId = accountViewInfo.getId().toString();
            key2 = voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT) ? "debit" + acctId : "credit" + acctId;
            assistantAmount = voucherEntryInfo.getOriginalAmount();
            if (assistantMap.containsKey(key2)) {
                tmpAmount = (BigDecimal)assistantMap.get(key2);
                tmpAmount = tmpAmount.add(assistantAmount);
                assistantMap.remove(key2);
                assistantMap.put(key2, tmpAmount);
                continue;
            }
            assistantMap.put(key2, assistantAmount);
        }
        JournalInfo info = new JournalInfo();
        for (int k = 0; k < journalCollection.size(); ++k) {
            info = journalCollection.get(k);
            AccountViewInfo bankAcct = info.getAccountView();
            if (bankAcct == null) continue;
            acctId = bankAcct.getId().toString();
            entryCreditAmount = info.getCreditAmount();
            entryDebitAmount = info.getDebitAmount();
            if (entryCreditAmount != null && entryCreditAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryCreditAmount;
                key2 = "credit" + acctId;
            }
            if (entryDebitAmount != null && entryDebitAmount.compareTo(CasConstants.ZERO) != 0) {
                entryAmountTotal = entryDebitAmount;
                key2 = "debit" + acctId;
            }
            if (entryMap.containsKey(key2)) {
                tmpAmount = (BigDecimal)entryMap.get(key2);
                tmpAmount = tmpAmount.add(entryAmountTotal);
                entryMap.remove(key2);
                entryMap.put(key2, tmpAmount);
                continue;
            }
            entryMap.put(key2, entryAmountTotal);
        }
        Set keySet = assistantMap.keySet();
        for (String key2 : keySet) {
            assistantAmount = assistantMap.containsKey(key2) ? (BigDecimal)assistantMap.get(key2) : CasConstants.ZERO;
            if (assistantAmount.compareTo(entryAmountTotal = entryMap.containsKey(key2) ? (BigDecimal)entryMap.get(key2) : CasConstants.ZERO) == 0) continue;
            throw new RuntimeException(EASResource.getString((String)this.resourcePath, (String)"AmountNotEqual"));
        }
    }

    @Override
    protected Map _bookAppointDate(Context ctx, String[] ids, boolean isHandCheck) throws BOSException, EASBizException {
        int error = 0;
        Object errorMsg = null;
        HashMap onloadData = new HashMap();
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        BatchExecuteResult result = new BatchExecuteResult();
        Boolean isAutoCheck = true;
        Boolean isBookAppointDate = false;
        String summary = CASWebUtil.getResource(ctx, "BILLSUM", new String[]{ids.length + ""});
        int success = ids.length;
        boolean voucherBookDateSum = false;
        ArrayList<String> finalIdList = new ArrayList<String>();
        if (success > 0) {
            Object voucherCompanyOldId = null;
            block0: for (int i = 0; i < ids.length && !isBookAppointDate.booleanValue(); ++i) {
                ArrayList<String> realIdList = new ArrayList<String>();
                realIdList.add(ids[i]);
                String voucherCompanyId = null;
                String voucherCompanyName = null;
                String voucherNumber = null;
                EntityViewInfo view = new EntityViewInfo();
                view.setFilter(this.getFilterInfoByID(realIdList));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("isCheck"));
                sic.add(new SelectorItemInfo("company.name"));
                sic.add(new SelectorItemInfo("bookedDate"));
                view.setSelector(sic);
                for (VoucherInfo voucherInfo : voucher.getVoucherCollection(view)) {
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)voucherInfo.getCompany());
                    voucherCompanyId = voucherInfo.getCompany().getId().toString();
                    voucherCompanyName = voucherInfo.getCompany().getName();
                    voucherNumber = voucherInfo.getNumber();
                    Boolean isCheck = voucherInfo.isIsCheck();
                    if (isCheck.booleanValue()) continue;
                    finalIdList.add(voucherInfo.getId().toString());
                    if (isHandCheck || !VoucherCheckWebFacadeControllerBean.isAssociationCashManagement(ctx, voucherInfo.getCompany())) continue;
                    IUserOption iUserOption = UserOptionFactory.getLocalInstance((Context)ctx);
                    UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
                    CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                    String companyId = voucherCompanyId;
                    String optKey = "com.kingdee.eas.fi.cas.client.BookUserOptionUI";
                    companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                    Map bookUserMap = iUserOption.getUserOptionMap(userInfo.getId().toString(), companyInfo.getId().toString(), optKey, null);
                    boolean isByAppointTime = false;
                    if (bookUserMap != null) {
                        isByAppointTime = new Boolean((String)bookUserMap.get("kDRadioButtonAppointTime"));
                    }
                    if (!isByAppointTime) continue;
                    isBookAppointDate = true;
                    summary = summary + CASWebUtil.getResource(ctx, "288_BookAppointDate");
                    continue block0;
                }
            }
        } else {
            error = 1;
            summary = summary + CASWebUtil.getResource(ctx, "190_NO_ROW_SELECTED");
            result.setSummaryMsg(summary);
            result.setOtherProperty("msg", summary);
            isAutoCheck = false;
            result.setError(error);
        }
        if (finalIdList.size() <= 0) {
            error = 1;
            summary = summary + CASWebUtil.getResource(ctx, "189_hasNotValidRecord");
            result.setOtherProperty("msg", summary);
            result.setSummaryMsg(summary);
            isAutoCheck = false;
            result.setError(error);
        }
        if (isBookAppointDate.booleanValue()) {
            result.setSummaryMsg(summary);
            result.setOtherProperty("isAutoCheck", isAutoCheck);
            result.setOtherProperty("isBookAppointDate", isBookAppointDate);
        }
        return result;
    }

    @Override
    protected String _getOrgDataFilter(Context ctx) throws BOSException, EASBizException {
        String permItem = "cas_voucher_01view";
        if (permItem == null) {
            throw new RuntimeException("permItem can't be null");
        }
        StringBuffer orgDataFilter = new StringBuffer("id in ( ");
        try {
            CompanyOrgUnitCollection companyCollAssociation = new CompanyOrgUnitCollection();
            companyCollAssociation = CashHelper.getAssociationGeneralLeger();
            HashSet<String> companySetAssociation = new HashSet<String>();
            HashSet<String> companySetCS001 = new HashSet<String>();
            if (!EmptyUtil.isEmpty((AbstractObjectCollection)companyCollAssociation)) {
                for (int i = 0; i < companyCollAssociation.size(); ++i) {
                    companySetAssociation.add(companyCollAssociation.get(i).getId().toString());
                }
            }
            String sql = "select FOrgUnitID from  T_BAS_ParamItem where FKeyID in(select fid from T_BAS_Param where fnumber = 'CS001') and FValue_L2 ='1'";
            IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
            while (rowSet.next()) {
                String id = (String)rowSet.getObject("FOrgUnitID");
                if (EmptyUtil.isEmpty((String)id) || !companySetAssociation.contains(id)) continue;
                companySetCS001.add(id);
            }
            ArrayList rowObjects = new ArrayList();
            CompanyOrgUnitCollection orgUnitCollection = CASCommonWebFacadeFactory.getLocalInstance(ctx).getAuthizedCompanyOrg(permItem);
            CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            CompanyOrgUnitCollection sort = new CompanyOrgUnitCollection();
            if (orgUnitCollection.size() > 0) {
                if (!orgUnitCollection.get(0).getId().equals((Object)current.getId())) {
                    sort.add(current);
                    orgUnitCollection.remove(current);
                    sort.addCollection(orgUnitCollection);
                } else {
                    sort.addCollection(orgUnitCollection);
                }
            }
            for (int i = 0; i < sort.size(); ++i) {
                CompanyOrgUnitInfo orgUnit = sort.get(i);
                String orgNumber = orgUnit.getNumber();
                String orgName = orgUnit.getName();
                String orgUnitId = orgUnit.getId().toString();
                boolean include = true;
                if (EmptyUtil.isEmpty((String)orgUnitId) || !companySetCS001.contains(orgUnitId)) continue;
                orgDataFilter.append("'" + orgUnitId + "',");
            }
            if (orgDataFilter.toString().equals("id in ( ")) {
                orgDataFilter = new StringBuffer("id in ('NE')");
            } else {
                orgDataFilter.deleteCharAt(orgDataFilter.length() - 1);
                orgDataFilter.append(") ");
            }
            return orgDataFilter.toString();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected Map _storeUserOption(Context ctx, String jsonstr, String checkOp) {
        HashMap<String, String> mapData = new HashMap<String, String>();
        try {
            HashMap searchFilter;
            HashMap hashMap = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr);
            String orgid = (String)hashMap.get("orgid");
            String[] orgids = orgid.split(",");
            HashMap map = searchFilter = JSONUtils.convertJsonToObject((Context)ctx, (String)checkOp);
            StringBuffer optValue = new StringBuffer();
            int i = 1;
            for (String key : map.keySet()) {
                if (i < map.size()) {
                    optValue.append(key + "=" + map.get(key).toString() + ";");
                } else {
                    optValue.append(key + "=" + map.get(key).toString());
                }
                ++i;
            }
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            for (int j = 0; j < orgids.length; ++j) {
                UserOptionInfo userOptionInfo = new UserOptionInfo();
                userOptionInfo.setName("Hello");
                userOptionInfo.setCreateUser(userInfo);
                userOptionInfo.setCreateDate(new Date());
                userOptionInfo.setOptKey("com.kingdee.eas.fi.cas.client.BookUserOptionUI");
                userOptionInfo.setOptValue(optValue.toString());
                IUserOption userOption = UserOptionFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                String companyId = orgids[j];
                companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
                userOptionInfo.setCompany(companyInfo);
                userOption.submit(userOptionInfo, false, companyInfo.getId().toString());
            }
        }
        catch (EASBizException e1) {
            mapData.put("MsgStr", e1.getMessage());
            mapData.put("MsgDetail", e1.toString());
            e1.printStackTrace();
        }
        catch (BOSException e2) {
            mapData.put("MsgStr", e2.getMessage());
            mapData.put("MsgDetail", e2.toString());
            e2.printStackTrace();
        }
        return mapData;
    }

    @Override
    protected Map _getUserOption(Context ctx, String jsonstr) throws BOSException, EASBizException {
        Map<String, Integer> map = new HashMap<String, String>();
        try {
            HashMap hashMap = JSONUtils.convertJsonToObject((Context)ctx, (String)jsonstr);
            String orgid = (String)hashMap.get("orgid");
            String[] orgids = orgid.split(",");
            IUserOption userOption = UserOptionFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
            CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
            String companyId = orgids[0];
            String optKey = "com.kingdee.eas.fi.cas.client.BookUserOptionUI";
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            map = userOption.getUserOptionMap(userInfo.getId().toString(), companyInfo.getId().toString(), optKey, null);
            if (map != null && map.size() != 0) {
                map.put("size", map.size());
            } else {
                map = new HashMap();
                map.put("size", 0);
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            map.put("MsgStr", (Integer)((Object)e1.getMessage()));
            map.put("MsgDetail", (Integer)((Object)e1.toString()));
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            map.put("MsgStr", (Integer)((Object)e2.getMessage()));
            map.put("MsgDetail", (Integer)((Object)e2.toString()));
        }
        return map;
    }

    @Override
    protected String _getOrgDataFilterList(Context ctx, boolean share) throws BOSException, EASBizException {
        CompanyOrgUnitCollection orgUnitCollection;
        String permItem = "cas_voucher_01view";
        ArrayList orgDataFilter_Cs001 = new ArrayList();
        ArrayList orgDataFilter_OrgUnit = new ArrayList();
        StringBuffer orgDataFilter = new StringBuffer("id in ( ");
        if (!share) {
            CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
            if (current.isIsBizUnit()) {
                boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(current.getId().toString()), "cas_voucher_01view");
                if (!isPermission) {
                    throw new CasWebException(CasWebException.NO_VOUCHER__PERMISSION_ONE);
                }
            } else {
                throw new CasWebException(CasWebException.BIZUNIT_NO_AHTHORITY);
            }
        }
        if ((orgUnitCollection = CASCommonWebFacadeFactory.getLocalInstance(ctx).getAuthizedCompanyOrg(permItem)).size() <= 0 && share) {
            throw new CasWebException(CasWebException.NO_VOUCHER__PERMISSION);
        }
        CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        CompanyOrgUnitCollection sort = new CompanyOrgUnitCollection();
        if (share) {
            if (orgUnitCollection.size() > 0) {
                if (!orgUnitCollection.get(0).getId().equals((Object)current.getId())) {
                    sort.add(current);
                    orgUnitCollection.remove(current);
                    sort.addCollection(orgUnitCollection);
                } else {
                    sort.addCollection(orgUnitCollection);
                }
            }
        } else {
            sort.add(current);
        }
        StringBuffer showOrgName = new StringBuffer();
        boolean isAGL = true;
        HashSet<String> sortMsSetAssociation = new HashSet<String>();
        for (int i = 0; i < sort.size(); ++i) {
            CompanyOrgUnitInfo orgUnit = sort.get(i);
            isAGL = CashHelper.isAssociationGeneralLeger(orgUnit);
            if (!isAGL) {
                showOrgName.append(orgUnit.getName() + ",");
                continue;
            }
            sortMsSetAssociation.add(orgUnit.getId().toString());
        }
        if (sortMsSetAssociation.size() <= 0) {
            if (share) {
                NumericExceptionSubItem numericExceptionSubItem = new NumericExceptionSubItem("VOUCHER_MS_ALLNAME", showOrgName.toString() + CASWebUtil.getResource(ctx, "456_VOUCHER_MS_ALLNAME"));
                throw new CasWebException(numericExceptionSubItem);
            }
            throw new CasWebException(CasWebException.NO_VOUCHER_MS);
        }
        HashSet<String> companySetCS001 = new HashSet<String>();
        String sql = "select FOrgUnitID from  T_BAS_ParamItem where FKeyID in(select fid from T_BAS_Param where fnumber = 'CS001') and FValue_L2 ='1'";
        IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        try {
            while (rowSet.next()) {
                String id = (String)rowSet.getObject("FOrgUnitID");
                if (EmptyUtil.isEmpty((String)id) || !sortMsSetAssociation.contains(id)) continue;
                companySetCS001.add(id);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (companySetCS001.size() <= 0) {
            if (share) {
                throw new CasWebException(CasWebException.NO_VOUCHER_PERMISSION_OTHER);
            }
            throw new CasWebException(CasWebException.NO_VOUCHER_CS001);
        }
        ArrayList<String> orgDataFilterList = new ArrayList<String>();
        if (companySetCS001.contains(current.getId().toString())) {
            orgDataFilterList.add(current.getId().toString());
            companySetCS001.remove(current.getId().toString());
            orgDataFilterList.addAll(companySetCS001);
        } else {
            orgDataFilterList.addAll(companySetCS001);
        }
        for (int j = 0; j < orgDataFilterList.size(); ++j) {
            String orgUnitId = (String)orgDataFilterList.get(j);
            orgDataFilter.append("'" + orgUnitId + "',");
        }
        if (orgDataFilter.toString().equals("id in ( ")) {
            orgDataFilter = new StringBuffer("id in ('NE')");
        } else {
            orgDataFilter.deleteCharAt(orgDataFilter.length() - 1);
            orgDataFilter.append(") ");
        }
        return orgDataFilter.toString();
    }

    @Override
    protected Map _getNotifyVerifyResult(Context ctx, String id, String status, String companyId) throws BOSException, EASBizException {
        boolean error = false;
        Object errorMsg = null;
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        String builderName = "com.kingdee.eas.fi.gl.VoucherBookNotifyBuilder";
        try {
            String permission = "cas_voucher_02check";
            boolean isPermission = CASWebHelper.hasFunctionPermission(ctx, ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyId), "cas_voucher_02check");
            if (!isPermission) {
                throw new CasWebException(CasWebException.NO_CAS_VOUCHER_02CHECK_AUTHRIZED);
            }
            try {
                JournalCollection journalCollection = this.getJournalCollection(ctx, builderName, id, status);
            }
            catch (Exception e) {
                e.printStackTrace();
                onloadData.put("error", 1);
                onloadData.put("errorMsg", e.getMessage());
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            onloadData.put("error", 1);
            onloadData.put("errorMsg", e1.getMessage());
        }
        catch (BOSException e2) {
            e2.printStackTrace();
            onloadData.put("error", 1);
            onloadData.put("errorMsg", e2.getMessage());
        }
        return onloadData;
    }

    @Override
    protected boolean _queryPermissions(Context ctx, boolean share) throws BOSException, EASBizException {
        CompanyOrgUnitInfo defaultFIUnit = ContextUtil.getCurrentFIUnit((Context)ctx);
        CompanyOrgUnitInfo current = (CompanyOrgUnitInfo)ctx.get((Object)"CompanyInfo");
        BankVcCheckWebHelper bankVCHelper = new BankVcCheckWebHelper(ctx);
        boolean purview = bankVCHelper.queryPermissions_Currency_Voucher_BeShare(current, share);
        return purview;
    }

    @Override
    protected List _getSelectAllId(Context ctx, String filter) throws BOSException, EASBizException {
        ArrayList<String> idList = new ArrayList<String>();
        String filtermust = " AND ID IN (SELECT T0.FBILLID  FROM T_GL_VoucherEntry T0 INNER JOIN T_BD_AccountView T1  ON T0.FAccountID=T1.FID WHERE T0.FBillID=VOUCHER.FID AND (T1.FIsCash=1 OR T1.FIsBank=1)) and (bizStatus=1 or bizStatus=3 or bizStatus=5)";
        IQueryExecutor queryExecutor = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.VoucherCheckWebQuery"));
        try {
            queryExecutor.setObjectView("SELECT id where " + filter + filtermust);
            logger.info((Object)("VoucherSelect is: " + queryExecutor.getSQL()));
            IRowSet rs = queryExecutor.executeQuery();
            while (rs.next()) {
                idList.add(rs.getString("id"));
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return VoucherCheckWebFacadeControllerBean.removeDuplicate(idList);
    }

    public static List removeDuplicate(List list) {
        HashSet h = new HashSet(list);
        list.clear();
        list.addAll(h);
        return list;
    }
}

