/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.StringUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.IJournal;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.VoucherImport2JournalByEntryBuilder;
import com.kingdee.eas.fi.cas.app.AbstractVoucherImport2JournalByEntryFacadeControllerBean;
import com.kingdee.eas.fi.gl.IVoucherEntry;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryFactory;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherException;
import com.kingdee.eas.fi.gl.VoucherOperateStatusEnum;
import com.kingdee.eas.fi.gl.VoucherStatusEnum;
import com.kingdee.eas.fm.common.FMVerifyHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class VoucherImport2JournalByEntryFacadeControllerBean
extends AbstractVoucherImport2JournalByEntryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.cas.app.VoucherImport2JournalByEntryFacadeControllerBean");
    private static final boolean[][] voucherStatus = new boolean[][]{{true, false, false, false, false, false}, {true, true, false, false, false, false}, {true, true, true, false, false, false}, {false, true, false, false, true, false}, {false, false, false, true, false, false}, {false, true, false, true, false, true}, {false, true, false, true, true, true}, {false, false, false, true, false, false}, {false, false, false, false, false, true}, {false, true, false, false, false, false}, {false, false, true, false, false, false}, {false, false, false, false, false, true}};

    @Override
    protected void _cancelVoucherByEntry(Context ctx, List entryIds) throws BOSException, EASBizException {
        if (entryIds == null || entryIds.size() == 0) {
            return;
        }
        boolean booleanParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS121", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString()));
        if (!booleanParam) {
            entryIds = this.getRelatedVoucherEntryId(ctx, entryIds);
        }
        VoucherEntryCollection voucherEntryColl = this.getVoucherEntryColl(ctx, entryIds);
        VoucherEntryInfo entryInfo = null;
        int size = voucherEntryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = voucherEntryColl.get(i);
            this.checkVoucherValidForCheckingByEntry(ctx, entryInfo, VoucherOperateStatusEnum.ANTICHECK);
        }
        String sql = "update t_gl_voucherentry set fischeck =0 , fcashierid=null where " + StringUtil.buildIn((String)"fid", (Object[])entryIds.toArray());
        DbUtil.execute((Context)ctx, (String)sql);
        this.antiBook(ctx, new HashSet(entryIds));
        sql = "SELECT fbillid    FROM (SELECT   fbillid, SUM (fischeck) checknum, COUNT (*) sumnum \t\t\t   FROM t_gl_voucherentry \t\t\t  WHERE FBillId In (\t\t\t  \tSELECT FBillId FROM T_GL_VoucherEntry WHERE " + StringUtil.buildIn((String)"fid", (Object[])entryIds.toArray()) + "\t\t\t\t)\t\t   GROUP BY fbillid ) as aa   WHERE checknum = 0";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashSet<String> unCheckIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                unCheckIdSet.add(rs.getString("fbillid"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        if (unCheckIdSet != null && !unCheckIdSet.isEmpty()) {
            sql = "update t_gl_voucher set fischeck =0 , fcashierid=null, FLastUpdateTime=?  where " + StringUtil.buildIn((String)"fid", (Object[])unCheckIdSet.toArray());
        }
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{VoucherImport2JournalByEntryFacadeControllerBean.getTime()});
    }

    private List getRelatedVoucherEntryId(Context ctx, List ids) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sqlToGetVoucherEntryId = "select fid from T_GL_VOUCHERENTRY where fbillid in(select fbillid from T_GL_VOUCHERENTRY where " + StringUtil.buildIn((String)"fid", (Object[])ids.toArray()) + ")";
        ArrayList<String> sqlResultList = new ArrayList<String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sqlToGetVoucherEntryId.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                sqlResultList.add(rs.getString("fid"));
            }
            for (int i = 0; i < sqlResultList.size(); ++i) {
                if (ids.contains(sqlResultList.get(i))) continue;
                ids.add(sqlResultList.get(i));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return ids;
    }

    @Override
    protected void _checkVoucherByEntry(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() == 0) {
            return;
        }
        boolean booleanParam = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS121", (IObjectPK)new ObjectUuidPK(ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany().getId().toString()));
        if (!booleanParam) {
            ids = this.getRelatedVoucherEntryId(ctx, ids);
        }
        VoucherEntryCollection voucherEntryColl = this.getVoucherEntryColl(ctx, ids);
        VoucherEntryInfo entryInfo = null;
        int size = voucherEntryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = voucherEntryColl.get(i);
            this.checkVoucherValidForCheckingByEntry(ctx, entryInfo, VoucherOperateStatusEnum.CHECK);
        }
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String sql = "update t_gl_voucherentry set fischeck =1, fcashierid=? where fid in (" + this.newBuildIn(ids.toArray());
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new String[]{userId});
        VoucherImport2JournalByEntryBuilder builder = new VoucherImport2JournalByEntryBuilder();
        JournalCollection journalColl = builder.getJournalColl(ctx, new HashSet(ids));
        this.bookBatch(ctx, (IObjectCollection)journalColl);
        sql = "update t_gl_voucher set fischeck =1, fcashierid=?, FLastUpdateTime=? where  fid in (select fbillid from t_gl_voucherentry where fid in (" + this.newBuildIn(ids.toArray()) + ")";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{userId, VoucherImport2JournalByEntryFacadeControllerBean.getTime()});
    }

    public static Timestamp getTime() {
        java.util.Date date = new java.util.Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    private VoucherEntryCollection getVoucherEntryColl(Context ctx, List ids) throws BOSException {
        if (ids == null || ids.isEmpty()) {
            return new VoucherEntryCollection();
        }
        HashSet idSet = new HashSet(ids);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        evi.getSelector().add("bill.bizStatus");
        evi.setFilter(filter);
        IVoucherEntry iVoucherEntry = VoucherEntryFactory.getLocalInstance((Context)ctx);
        return iVoucherEntry.getVoucherEntryCollection(evi);
    }

    private void checkVoucherValidForCheckingByEntry(Context ctx, VoucherEntryInfo entryinfo, VoucherOperateStatusEnum status) throws VoucherException, EASBizException {
        if (status == VoucherOperateStatusEnum.CHECK) {
            this.checkStatusAndOperate(entryinfo.getBill().getBizStatus(), status);
            return;
        }
    }

    private void checkStatusAndOperate(VoucherStatusEnum bizStatus, VoucherOperateStatusEnum operateStatus) throws EASBizException {
        int i = operateStatus.getValue();
        int j = bizStatus.getValue();
        Object[] info = new String[]{operateStatus.toString(), bizStatus.toString()};
        if (!voucherStatus[i][j]) {
            throw new VoucherException(VoucherException.STATUS_AND_OPERATE, info);
        }
    }

    private void bookBatch(Context ctx, IObjectCollection journalCollection) throws BOSException, EASBizException {
        JournalCollection journalC = (JournalCollection)journalCollection;
        if (journalC == null || journalC.size() == 0) {
            return;
        }
        IContextHelper localInstance = ContextHelperFactory.getLocalInstance((Context)ctx);
        this.checkCashSystemStatus(ctx);
        JournalInfo journalInfo = null;
        UserInfo user = localInstance.getCurrentUser();
        int size = journalCollection.size();
        for (int i = 0; i < size; ++i) {
            journalInfo = (JournalInfo)journalCollection.getObject(i);
            PeriodInfo currenPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)journalInfo.getCompany());
            int val = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("CS001", (IObjectPK)new ObjectUuidPK(journalInfo.getCompany().getId()));
            if (val == 1) continue;
            journalInfo.setLineNo(i);
            journalInfo.setHasEffected(true);
            journalInfo.setCashier(user);
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"company");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"billId");
            FMVerifyHelper.checkBlank((Context)ctx, (IObjectValue)journalInfo, (String)"createDate");
            if (journalInfo.getCreditAmount() == null) {
                journalInfo.setCreditAmount(CasConstants.ZERO);
            }
            if (journalInfo.getDebitAmount() == null) {
                journalInfo.setDebitAmount(CasConstants.ZERO);
            }
            if (journalInfo.getDebitAmount().signum() != 0) {
                journalInfo.setIsDebit(true);
            } else {
                journalInfo.setIsDebit(false);
            }
            if (currenPeriodInfo != null && journalInfo.getCreateDate() != null && currenPeriodInfo.getBeginDate().after(journalInfo.getCreateDate())) {
                journalInfo.setCreateDate(currenPeriodInfo.getBeginDate());
                journalInfo.setPeriod(currenPeriodInfo);
            }
            if (journalInfo.getPeriod() == null) {
                PeriodInfo period = PeriodUtils.getPeriodInfo((Context)ctx, (java.util.Date)journalInfo.getCreateDate(), (CompanyOrgUnitInfo)journalInfo.getCompany());
                if (period == null || period.getId() == null) {
                    throw new CasException(CasException.PERIODISNULL);
                }
                journalInfo.setPeriod(period);
            }
            if (!journalInfo.getPeriod().isIsAdjustPeriod() && !currenPeriodInfo.isIsAdjustPeriod()) continue;
            throw new CasException(CasException.ADJUSTCANNOTBOOK);
        }
        JournalCollection newjournalCollection = new JournalCollection();
        int size2 = journalC.size();
        for (int i = 0; i < size2; ++i) {
            JournalInfo info = journalC.get(i);
            if (info.getDebitAmount() != null && info.getDebitAmount().signum() != 0) {
                newjournalCollection.add(info);
                continue;
            }
            if (info.getCreditAmount() == null || info.getCreditAmount().signum() == 0) continue;
            newjournalCollection.add(info);
        }
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        HashSet<String> billIds = new HashSet<String>();
        for (int i = 0; i < journalC.size(); ++i) {
            billIds.add(journalC.get(i).getBillId());
        }
        this.antiBook(ctx, billIds);
        journal.addBatch((IObjectCollection)newjournalCollection);
    }

    private void checkCashSystemStatus(Context ctx) throws BOSException, EASBizException, CasException {
        PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany());
        if (startPeriod == null) {
            throw new CasException(CasException.STARTPERIODNULL);
        }
    }

    private void antiBook(Context ctx, Set billIds) throws BOSException, EASBizException {
        this.checkStatus(ctx, billIds);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billIds, CompareType.INCLUDE));
        IJournal journal = JournalFactory.getLocalInstance(ctx);
        journal.delete(filter);
    }

    private void checkStatus(Context ctx, Set billIds) throws BOSException, EASBizException {
        String sql = "SELECT FCreateDate,FVerifyStatus, FCompanyID FROM T_CAS_Journal WHERE " + StringUtil.buildIn((String)"FBillId", (Object[])billIds.toArray());
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                int verifyStatus = rs.getInt("FVerifyStatus");
                Date createDate = rs.getDate("FCreateDate");
                String companyID = rs.getString("FCompanyID");
                CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
                if (periodInfo == null) continue;
                if (verifyStatus == 1) {
                    throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
                }
                if (!periodInfo.getBeginDate().after(createDate)) continue;
                throw new BookNotifyException(BookNotifyException.ALREADY_VERIFY);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String newBuildIn(Object[] set) {
        if (set == null || set.length == 0) {
            return " ";
        }
        StringBuffer sb = new StringBuffer(1204);
        for (int i = 0; i < set.length; ++i) {
            if (i == set.length - 1) {
                StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
                continue;
            }
            StringUtil.appendStrValue((StringBuffer)sb, (Object)set[i]);
            sb.append(",");
        }
        sb.append(")");
        return sb.toString();
    }
}

