/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.botp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.util.ArrayList;
import java.util.Map;

public class ArApRecPayServerUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BTPTransformResult transformForBotpWithMutex(Context ctx, CoreBillBaseCollection srcBillCols, String destBillBosType, IObjectPK botMappingId, boolean isNeedMutex) throws BOSException, EASBizException {
        ArrayList<String> thisLockList = new ArrayList<String>();
        ArrayList<String> otherLockList = new ArrayList<String>();
        ArrayList<IObjectPK> botMappingColl = new ArrayList<IObjectPK>();
        ArrayList<CoreBillBaseCollection> srcBillList = new ArrayList<CoreBillBaseCollection>();
        botMappingColl.add(botMappingId);
        srcBillList.add(srcBillCols);
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IBTPManager ibtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        try {
            if (isNeedMutex) {
                int size = srcBillCols.size();
                ArrayList<String> idList = new ArrayList<String>();
                for (int i = 0; i < size; ++i) {
                    CoreBillBaseInfo billInfo = (CoreBillBaseInfo)srcBillCols.getObject(i);
                    idList.add(billInfo.getId().toString());
                }
                Map requestLockMap = mutexService.batchRequestObjIDForUpdate(idList);
                for (int i = 0; i < size; ++i) {
                    String id = (String)idList.get(i);
                    if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                        thisLockList.add(id);
                        continue;
                    }
                    otherLockList.add(id);
                }
                if (otherLockList.size() > 0) {
                    throw new CasForArApException(CasForArApException.BILL_LOCKED);
                }
            }
            BTPTransformResult bTPTransformResult = ibtpManager.transformForBotp(srcBillList, destBillBosType, botMappingColl);
            return bTPTransformResult;
        }
        finally {
            if (thisLockList != null && thisLockList.size() != 0) {
                mutexService.batchReleaseObjIDForUpdate(thisLockList);
            }
        }
    }
}

