/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.botp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BotpHelper;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentFailReasonEnum;
import com.kingdee.eas.fi.cas.PaymentReportFactory;
import com.kingdee.eas.fi.cas.PaymentReportInfo;
import com.kingdee.eas.fi.cas.PaymentStateEnum;
import com.kingdee.eas.fi.cas.app.botp.BillToRule;
import com.kingdee.eas.fi.cas.app.botp.BotEngineNew;
import com.kingdee.eas.fi.cas.app.botp.CasBotpUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BOTPTransmitRecorderForBillAndRules {
    public static final String PAYMENT_SUCCEED = "paymentSucceed";
    public static final String PAYMENT_FAILED = "paymentFailed";
    private Set<BillToRule> billToRuleSet = new HashSet<BillToRule>();
    private String[] billIds = null;
    private BillTypeInfo billType = null;
    private CompanyOrgUnitInfo company = null;
    private ICoreBillBase icbb = null;
    private String failMsg = null;
    private String status = null;
    private BTPTransformResult result = null;
    protected boolean isCBPay;

    public boolean isCBPay() {
        return this.isCBPay;
    }

    public void setCBPay(boolean isCBPay) {
        this.isCBPay = isCBPay;
    }

    public BOTPTransmitRecorderForBillAndRules(String companyId, Context ctx, String[] billIds) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company;
        this.company = company = CasBotpUtil.getCompanyInfoById(ctx, companyId);
        this.billIds = billIds;
    }

    public void addBillToRule(BillToRule btr) {
        this.billToRuleSet.add(btr);
    }

    public void generatePaymentBill(Context ctx, String bostype, int subSystem, UserInfo user) throws BOSException, EASBizException {
        this.billType = CasBotpUtil.getBillTypeByBOSType(ctx, bostype, subSystem);
        HashMap<String, List> rule_bills = new HashMap<String, List>();
        HashMap<String, List> bill_rules = new HashMap<String, List>();
        ArrayList<String> noRule = new ArrayList<String>();
        this.icbb = CasBotpUtil.getSrcBizInterface(ctx, BOSObjectType.create((String)bostype));
        this.preprocessing(rule_bills, bill_rules, noRule);
        this.genReporters(ctx, bill_rules, noRule, user);
        BotEngineNew botEngineNew = new BotEngineNew();
        Set es = rule_bills.entrySet();
        for (Map.Entry mEn : es) {
            String ruleId = (String)mEn.getKey();
            String[] billIds = new String[]{};
            billIds = ((List)mEn.getValue()).toArray(billIds);
            SelectorItemCollection botpSelectors = null;
            BOTMappingInfo mappingInfo = CasBotpUtil.getBotpRuleByPk(ctx, ruleId);
            try {
                botpSelectors = BotpHelper.getBOTPSelectors((BOTMappingInfo)mappingInfo);
            }
            catch (Exception e) {
                throw new BTPException(BTPException.CALLBACKBIZERR, new Object[]{e.getMessage()});
            }
            Map transGroups = botEngineNew.preMerge(ctx, billIds, ruleId);
            ObjectUuidPK rulePK = new ObjectUuidPK(ruleId);
            Set entrySet = transGroups.entrySet();
            Iterator it = null;
            for (Map.Entry entry : entrySet) {
                String[] srcBillIds;
                block10: {
                    srcBillIds = new String[]{};
                    srcBillIds = ((List)entry.getValue()).toArray(srcBillIds);
                    ArrayList entryids = new ArrayList();
                    Object entryName = null;
                    try {
                        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
                        this.result = iBTPManager.transformForBotp(srcBillIds, new String[]{entryName}, entryids, null, mappingInfo.getDestEntityName(), (IObjectPK)rulePK, mappingInfo.getSrcEntityName());
                        IObjectCollection destBillCols = this.result.getBills();
                        BOTRelationCollection botRelationCols = this.result.getBOTRelationCollection();
                        int count = destBillCols.size();
                        for (int i = 0; i < count; ++i) {
                            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
                            iBTPManager.saveRelations(destBillInfo, botRelationCols);
                        }
                        this.status = PAYMENT_SUCCEED;
                    }
                    catch (Exception e) {
                        this.status = PAYMENT_FAILED;
                        if (e instanceof BOSException && e.getCause() != null) {
                            this.failMsg = e.getCause().getMessage();
                            if (this.failMsg == null) {
                                this.failMsg = e.getMessage() == null ? EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"200_BOTPTransmitRecorderForBillAndRules", (Locale)ctx.getLocale()) : e.getMessage();
                            }
                        } else {
                            this.failMsg = e.getMessage();
                        }
                        if (this.failMsg.length() <= 1000) break block10;
                        this.failMsg = this.failMsg.substring(0, 990) + "...";
                    }
                }
                this.record(ctx, srcBillIds);
            }
        }
    }

    private void preprocessing(Map<String, List> rule_bills, Map<String, List> bill_rules, List<String> noRule) {
        int len = this.billIds.length;
        Iterator<BillToRule> it = null;
        BillToRule btr2 = null;
        ArrayList<String> billToRuleTmp = null;
        for (int i = 0; i < len; ++i) {
            billToRuleTmp = new ArrayList<String>();
            String billId = this.billIds[i];
            for (BillToRule btr2 : this.billToRuleSet) {
                if (!billId.equals(btr2.getBillId())) continue;
                billToRuleTmp.add(btr2.getRuleId());
            }
            int size = billToRuleTmp.size();
            if (size <= 0) {
                noRule.add(billId);
                continue;
            }
            if (size == 1) {
                String ruleId = (String)billToRuleTmp.get(0);
                List<String> tmp = null;
                if (rule_bills.containsKey(ruleId)) {
                    tmp = rule_bills.get(ruleId);
                    tmp.add(billId);
                    continue;
                }
                tmp = new ArrayList();
                tmp.add(billId);
                rule_bills.put(ruleId, tmp);
                continue;
            }
            bill_rules.put(billId, billToRuleTmp);
        }
    }

    private void genReporters(Context ctx, Map bill_rules, List noRule, UserInfo user) throws BOSException, EASBizException {
        CoreBaseCollection vrc = new CoreBaseCollection();
        Map.Entry me2 = null;
        Iterator it = null;
        Set s = null;
        Map billIdToInfo = this.getBillIdToInfo(bill_rules, noRule);
        String billId = null;
        CoreBillBaseInfo billInfo = null;
        if (billIdToInfo != null) {
            PaymentReportInfo vri;
            if (bill_rules != null) {
                s = bill_rules.entrySet();
                for (Map.Entry me2 : s) {
                    vri = new PaymentReportInfo();
                    vrc.add((CoreBaseInfo)vri);
                    billId = (String)me2.getKey();
                    billInfo = (CoreBillBaseInfo)billIdToInfo.get(billId);
                    this.setCommonFieldInRecord(ctx, billInfo, vri, user);
                    vri.setPaymentState(PaymentStateEnum.fail);
                    List ruleIds = (List)me2.getValue();
                    vri.setFailureCause(PaymentFailReasonEnum.failForMultiBOTP.getAlias());
                    vri.setBotpRuleIds(StringUtils.arrayToString((Object[])ruleIds.toArray(), (String)","));
                }
            }
            if (noRule != null) {
                int len = noRule.size();
                for (int i = 0; i < len; ++i) {
                    vri = new PaymentReportInfo();
                    vrc.add((CoreBaseInfo)vri);
                    billId = (String)noRule.get(i);
                    billInfo = (CoreBillBaseInfo)billIdToInfo.get(billId);
                    this.setCommonFieldInRecord(ctx, billInfo, vri, user);
                    vri.setPaymentState(PaymentStateEnum.fail);
                    vri.setFailureCause(PaymentFailReasonEnum.failForNoBOTP.getAlias());
                }
            }
            PaymentReportFactory.getLocalInstance(ctx).submitBatchData(vrc);
        }
    }

    private Map getBillIdToInfo(Map bill_rules, List noRule) throws BOSException {
        int i = 0;
        int len = 0;
        Iterator it = null;
        StringBuffer buf = new StringBuffer();
        StringBuffer idOql = new StringBuffer();
        buf.append("select id, number, bizDate where id in (");
        Set s = null;
        if (bill_rules != null) {
            s = bill_rules.keySet();
            it = s.iterator();
            while (it.hasNext()) {
                idOql.append("'").append((String)it.next()).append("',");
            }
        }
        if (noRule != null) {
            len = noRule.size();
            for (i = 0; i < len; ++i) {
                idOql.append("'").append((String)noRule.get(i)).append("',");
            }
        }
        CoreBillBaseCollection billCol = null;
        if (idOql.length() > 0) {
            idOql.replace(idOql.length() - 1, idOql.length(), ")");
            buf.append(idOql.toString());
            billCol = this.icbb.getCoreBillBaseCollection(buf.toString());
        }
        if (billCol != null && billCol.size() > 0) {
            HashMap<String, CoreBillBaseInfo> idToInfo = new HashMap<String, CoreBillBaseInfo>();
            len = billCol.size();
            for (i = 0; i < len; ++i) {
                CoreBillBaseInfo billInfo = billCol.get(i);
                idToInfo.put(billInfo.getId().toString(), billInfo);
            }
            return idToInfo;
        }
        return null;
    }

    private void setCommonFieldInRecord(Context ctx, CoreBillBaseInfo billInfo, PaymentReportInfo vri, UserInfo user) {
        vri.setCompany(this.company);
        vri.setSubSystem(this.billType.getSubSystem());
        vri.setBillType(this.billType);
        vri.setBillID(billInfo.get("id").toString());
        vri.setBillNumber((String)billInfo.get("number"));
        vri.setBizDate((Date)billInfo.get("bizDate"));
        vri.setIsCBPay(this.isCBPay);
        vri.setUser(user);
    }

    private void record(Context ctx, String[] billIds) throws BOSException, EASBizException {
        CoreBaseCollection vrc = null;
        PaymentReportInfo vri = null;
        ArrayList billIdslist = new ArrayList();
        vrc = new CoreBaseCollection();
        String[] selectFields = new String[]{"number", "bizDate"};
        CoreBillBaseCollection billCol = CasBotpUtil.getSrcCollectionByIds(ctx, billIds, selectFields);
        if (PAYMENT_SUCCEED.equals(this.status)) {
            BOTRelationCollection relations = this.result.getBOTRelationCollection();
            int len = relations.size();
            for (int i = 0; i < len; ++i) {
                BOTRelationInfo relation = relations.get(i);
                CoreBillBaseInfo billInfo = CasBotpUtil.getSrcBillInfoById(ctx, relation.getSrcObjectID(), selectFields);
                String paymentBillId = relation.getDestObjectID();
                PaymentBillInfo paymentInfo = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(paymentBillId));
                vri = new PaymentReportInfo();
                vri.setCompany(this.company);
                vri.setSubSystem(this.billType.getSubSystem());
                vri.setBillType(this.billType);
                vri.setBillID(billInfo.get("id").toString());
                vri.setBillNumber((String)billInfo.get("number"));
                vri.setBizDate((Date)billInfo.get("bizDate"));
                vri.setUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                vri.setPaymentState(PaymentStateEnum.success);
                vri.setPaymentBill(paymentInfo);
                vri.setIsCBPay(this.isCBPay);
                vrc.addObject((IObjectValue)vri);
            }
        } else {
            int len = billCol.size();
            for (int i = 0; i < len; ++i) {
                CoreBillBaseInfo billInfo = billCol.get(i);
                vri = new PaymentReportInfo();
                vri.setCompany(this.company);
                vri.setSubSystem(this.billType.getSubSystem());
                vri.setBillType(this.billType);
                vri.setBillID(billInfo.get("id").toString());
                vri.setBillNumber((String)billInfo.get("number"));
                vri.setBizDate((Date)billInfo.get("bizDate"));
                vri.setUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                vri.setPaymentState(PaymentStateEnum.fail);
                vri.setFailureCause((Object)((Object)PaymentFailReasonEnum.failForOtherCause) + this.failMsg);
                vri.setIsCBPay(this.isCBPay);
                vrc.addObject((IObjectValue)vri);
            }
        }
        this.clearPreRecordForSuccessBill(ctx, billIdslist);
        PaymentReportFactory.getLocalInstance(ctx).submitBatchData(vrc);
    }

    private void clearPreRecordForSuccessBill(Context ctx, List billIds) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        Object[] billIdArr = new String[]{};
        if (billIds != null && billIds.size() > 0) {
            billIdArr = billIds.toArray(billIdArr);
            fi.getFilterItems().add(new FilterItemInfo("billID", (Object)StringUtils.arrayToString((Object[])billIdArr, (String)","), CompareType.INCLUDE));
            evi.setFilter(fi);
            PaymentReportFactory.getLocalInstance(ctx).delete(evi.toString());
        }
    }
}

