/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.botp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.app.BOTRuleFilterTools;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.dap.app.DAPAppTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeFactory;
import com.kingdee.eas.fi.cas.BillTypeInfo;
import com.kingdee.eas.fi.cas.app.botp.BOTPTransmitRecorderForBillAndRules;
import com.kingdee.eas.fi.cas.app.botp.BillToRule;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CasBotpUtil {
    public static BOTMappingCollection getBOTPMeetAllBills(Context ctx, String bostype, String[] billIds, BOTMappingCollection dapCollection) throws BOSException {
        Object view = null;
        BOTMappingInfo mapInfo = null;
        int billNum = billIds.length;
        CoreBillBaseCollection filteredCols = null;
        for (int i = dapCollection.size() - 1; i >= 0; --i) {
            mapInfo = dapCollection.get(i);
            filteredCols = CasBotpUtil.filterByRule(ctx, BOSObjectType.create((String)bostype), billIds, mapInfo);
            if (filteredCols != null && filteredCols.size() == billNum) continue;
            dapCollection.removeObject(i);
        }
        return dapCollection;
    }

    private static CoreBillBaseCollection filterByRule(Context ctx, BOSObjectType bosType, String[] srcBillIDs, BOTMappingInfo mappingInfo) throws BOSException {
        int iTotal = srcBillIDs.length;
        int iStep = 800;
        int iMax = iTotal % iStep == 0 ? iTotal / iStep : iTotal / iStep + 1;
        boolean bAllEmptyViewFilter = true;
        CoreBillBaseCollection realObjectCols = null;
        int resultSize = 0;
        EntityViewInfo view = BOTRuleFilterTools.getBOTRuleFilterByMapping((BOTMappingInfo)mappingInfo);
        boolean hasEntryFilter = false;
        if (view.getEntryFilters() != null && view.getEntryFilters().size() > 0) {
            hasEntryFilter = true;
        }
        for (int i = 0; i < iMax; ++i) {
            int iTempTotal = iStep;
            if (i == iMax - 1 && iMax * iStep != iTotal) {
                iTempTotal = iTotal % iStep;
            }
            int iStart = i * iStep;
            int iEnd = iStart + iTempTotal;
            String[] newIDs = new String[iTempTotal];
            for (int j = 0; j < iTempTotal; ++j) {
                newIDs[j] = srcBillIDs[iStart + j];
            }
            EntityViewInfo stepView = BOTRuleFilterTools.getRuleFilter((String[])newIDs, (BOTMappingInfo)mappingInfo);
            if (stepView == null) continue;
            bAllEmptyViewFilter = false;
            CoreBillBaseCollection filteredCols = CasBotpUtil.getSrcBillCollection(ctx, bosType.toString(), stepView);
            if (filteredCols == null || filteredCols.size() <= 0) continue;
            if (realObjectCols == null) {
                realObjectCols = filteredCols;
                continue;
            }
            resultSize += filteredCols.size();
            realObjectCols.addObjectCollection((IObjectCollection)filteredCols);
        }
        if (bAllEmptyViewFilter) {
            HashSet<String> s = new HashSet<String>();
            int size = srcBillIDs.length;
            for (int i = 0; i < size; ++i) {
                s.add(srcBillIDs[i]);
            }
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", s, CompareType.INCLUDE));
            evi.setFilter(fi);
            realObjectCols = CasBotpUtil.getSrcBillCollection(ctx, bosType.toString(), evi);
        }
        if (realObjectCols == null || realObjectCols.size() == 0) {
            return null;
        }
        if (hasEntryFilter) {
            int n = view.getEntryFilters().size();
            for (int j = 0; j < n; ++j) {
                String entryName = view.getEntryFilters().get(j).getEntryName();
                for (int i = realObjectCols.size() - 1; i >= 0; --i) {
                    IObjectValue filteredInfo = realObjectCols.getObject(i);
                    Object objColl = filteredInfo.get(entryName);
                    if (objColl != null && objColl instanceof IObjectCollection && ((IObjectCollection)objColl).size() > 0) continue;
                    realObjectCols.removeObject(i);
                }
            }
        }
        DAPAppTools.execDataFilterMultiEntry((Context)ctx, realObjectCols, (BOTMappingInfo)mappingInfo);
        return realObjectCols;
    }

    private static CoreBillBaseCollection getSrcBillCollection(Context ctx, String srcBillType, EntityViewInfo evi) throws BOSException {
        BOSObjectType bosType = BOSObjectType.create((String)srcBillType);
        ICoreBillBase bizCtrl = CasBotpUtil.createInterface(ctx, bosType);
        CoreBillBaseCollection sourceBillCollection = null;
        try {
            sourceBillCollection = bizCtrl.getCoreBillBaseCollection(evi);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        return sourceBillCollection;
    }

    public static ICoreBillBase createInterface(Context ctx, BOSObjectType bosType) throws BOSException {
        ICoreBillBase bizCtrl = null;
        if (ctx == null) {
            Class<?> model;
            BusinessObjectInfo meta = MetaDataLoaderFactory.getRemoteMetaDataLoader().getBusinessObject(bosType);
            String interfaceClass = meta.getBusinessInterface();
            try {
                model = Class.forName(interfaceClass);
            }
            catch (ClassNotFoundException e) {
                throw new BOSException((Throwable)e);
            }
            bizCtrl = (ICoreBillBase)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)bosType, model);
        } else {
            bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        }
        return bizCtrl;
    }

    public static String getBillMainEntryName(String bosType) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entity = loader.getEntity(BOSObjectType.create((String)bosType));
        PropertyCollection props = entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo propInfo : props) {
            RelationshipInfo relation;
            if (!(propInfo instanceof LinkPropertyInfo) || (relation = ((LinkPropertyInfo)propInfo).getRelationship()).getType() != RelationshipType.COMPOSITION && !Boolean.TRUE.toString().equalsIgnoreCase(propInfo.getExtendedProperty("isEntries"))) continue;
            EntityObjectInfo relateEntity = null;
            if (relation.getClientObject().getFullName().equals(entity.getFullName()) && (relation.getSupplierCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getSupplierCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getSupplierObject();
            } else if (relation.getSupplierObject().getFullName().equals(entity.getFullName()) && (relation.getClientCardinality() == CardinalityType.ONE_TO_UNBOUNDED || relation.getClientCardinality() == CardinalityType.ZERO_TO_UNBOUNDED)) {
                relateEntity = relation.getClientObject();
            }
            if (relateEntity == null) continue;
            return propInfo.getName();
        }
        return "entries";
    }

    public static CoreBillBaseCollection getSrcCollectionByIds(Context ctx, String[] billIds, String[] selectFields) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("id");
        if (selectFields != null) {
            SelectorItemCollection sic = entityViewInfo.getSelector();
            int len = selectFields.length;
            for (int i = 0; i < len; ++i) {
                sic.add(selectFields[i]);
            }
        }
        String strIdLists = StringUtils.arrayToString((Object[])billIds, (String)",");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        entityViewInfo.setFilter(filterInfo);
        CoreBillBaseCollection sourceBillCollection = CasBotpUtil.getSrcBizInterface(ctx, billIds[0].toString()).getCoreBillBaseCollection(entityViewInfo);
        return sourceBillCollection;
    }

    public static CoreBillBaseInfo getSrcBillInfoById(Context ctx, String billId, String[] selectFields) throws BOSException {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add("id");
        if (selectFields != null) {
            SelectorItemCollection sic = entityViewInfo.getSelector();
            int len = selectFields.length;
            for (int i = 0; i < len; ++i) {
                sic.add(selectFields[i]);
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)billId, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        CoreBillBaseCollection sourceBillCollection = CasBotpUtil.getSrcBizInterface(ctx, billId.toString()).getCoreBillBaseCollection(entityViewInfo);
        return sourceBillCollection.get(0);
    }

    public static ICoreBillBase getSrcBizInterface(Context ctx, BOSObjectType srcBOSType) throws BOSException {
        ICoreBillBase bizCtrl = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)srcBOSType.toString()));
        return bizCtrl;
    }

    public static ICoreBillBase getSrcBizInterface(Context ctx, String billId) throws BOSException {
        return CasBotpUtil.getSrcBizInterface(ctx, CasBotpUtil.getBOSTypeById(billId));
    }

    public static BOSObjectType getBOSTypeById(String id) {
        return new ObjectUuidPK(id).getObjectType();
    }

    public static List getSelectEntryIDs(CoreBillBaseCollection srcBills, String entryName) {
        ArrayList<String> entryids = new ArrayList<String>();
        if (StringUtils.isEmpty((String)entryName)) {
            return entryids;
        }
        for (int i = 0; i < srcBills.size(); ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            IObjectCollection entries = (IObjectCollection)bills.get(entryName);
            if (entries == null) {
                return entryids;
            }
            for (CoreBaseInfo cInfo : entries) {
                String ss = cInfo.getId().toString();
                entryids.add(ss);
            }
        }
        return entryids;
    }

    public static BOTPTransmitRecorderForBillAndRules checkBotMapping(Context ctx, String companyId, String[] srcBillIDs, String[] entrieNames, List entriesKeys, BOTMappingCollection botMappingCols) throws BOSException, EASBizException {
        BOTPTransmitRecorderForBillAndRules recorder = new BOTPTransmitRecorderForBillAndRules(companyId, ctx, srcBillIDs);
        BOTMappingCollection checkBotMappingCols = new BOTMappingCollection();
        for (int i = 0; i < botMappingCols.size(); ++i) {
            BOTMappingInfo mappingInfo = botMappingCols.get(i);
            if (BOTRuleFilterTools.isExistBOTRuleFilter((BOTMappingInfo)mappingInfo)) {
                checkBotMappingCols.add(mappingInfo);
                continue;
            }
            CasBotpUtil.addAllBillInRecorder(recorder, srcBillIDs, mappingInfo.getId().toString());
        }
        if (checkBotMappingCols.size() > 0) {
            String currId = srcBillIDs[0];
            BOSUuid uuid = BOSUuid.read((String)currId);
            BOSObjectType bosType = uuid.getType();
            HashMap<String, Object> entriesKeysMap = new HashMap<String, Object>();
            for (int k = 0; k < entriesKeys.size(); ++k) {
                entriesKeysMap.put(entriesKeys.get(k).toString(), null);
            }
            for (int i = 0; i < checkBotMappingCols.size(); ++i) {
                BOTMappingInfo mappingInfo = checkBotMappingCols.get(i);
                CasBotpUtil.checkIsErrorBotpRuleFilterByStep(ctx, bosType, srcBillIDs, entrieNames, entriesKeysMap, mappingInfo, recorder);
            }
        }
        return recorder;
    }

    private static void addAllBillInRecorder(BOTPTransmitRecorderForBillAndRules recorder, String[] billIds, String ruleId) {
        int len = billIds.length;
        for (int j = 0; j < len; ++j) {
            recorder.addBillToRule(new BillToRule(billIds[j], ruleId));
        }
    }

    private static void checkIsErrorBotpRuleFilterByStep(Context ctx, BOSObjectType bosType, String[] srcBillIDs, String[] entrieNames, Map entriesKeysMap, BOTMappingInfo mappingInfo, BOTPTransmitRecorderForBillAndRules recorder) throws BOSException {
        CoreBillBaseCollection realObjectCols = CasBotpUtil.filterByRule(ctx, bosType, srcBillIDs, mappingInfo);
        if (realObjectCols != null && realObjectCols.size() > 0) {
            CasBotpUtil.addAllBillInRecorder(recorder, realObjectCols, mappingInfo.getId().toString());
        }
    }

    private static void addAllBillInRecorder(BOTPTransmitRecorderForBillAndRules recorder, CoreBillBaseCollection realObjectCols, String ruleId) {
        int len = realObjectCols.size();
        for (int j = 0; j < len; ++j) {
            recorder.addBillToRule(new BillToRule(realObjectCols.get(j).getId().toString(), ruleId));
        }
    }

    public static CompanyOrgUnitInfo getCompanyInfoById(Context ctx, String id) throws EASBizException, BOSException {
        CompanyOrgUnitInfo info = null;
        if (id != null && id.length() > 0) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("baseCurrency.sign"));
            sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
            sic.add(new SelectorItemInfo("reportCurrency.id"));
            sic.add(new SelectorItemInfo("reportCurrency.number"));
            sic.add(new SelectorItemInfo("reportCurrency.name"));
            sic.add(new SelectorItemInfo("reportCurrency.precision"));
            sic.add(new SelectorItemInfo("reportCurrency.sign"));
            sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
            sic.add(new SelectorItemInfo("accountPeriodType.id"));
            sic.add(new SelectorItemInfo("accountPeriodType.number"));
            sic.add(new SelectorItemInfo("accountPeriodType.name"));
            sic.add(new SelectorItemInfo("isGrouping"));
            sic.add(new SelectorItemInfo("isGroup"));
            sic.add(new SelectorItemInfo("level"));
            sic.add(new SelectorItemInfo("isOnlyUnion"));
            sic.add(new SelectorItemInfo("isBizUnit"));
            sic.add(new SelectorItemInfo("isSealUp"));
            sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("reportConvertMode"));
            sic.add(new SelectorItemInfo("CU.id"));
            sic.add(new SelectorItemInfo("CU.number"));
            sic.add(new SelectorItemInfo("CU.name"));
            sic.add(new SelectorItemInfo("CU.longNumber"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
            sic.add(new SelectorItemInfo("reportExchangeTable.id"));
            sic.add(new SelectorItemInfo("isAssistantOrg"));
            sic.add(new SelectorItemInfo("mainOrg.id"));
            sic.add(new SelectorItemInfo("mainOrg.name"));
            sic.add(new SelectorItemInfo("mainOrg.number"));
            sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
            sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
            sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
            sic.add(new SelectorItemInfo("accountScheme.id"));
            sic.add(new SelectorItemInfo("accountScheme.name"));
            sic.add(new SelectorItemInfo("accountScheme.number"));
            sic.add(new SelectorItemInfo("SimpleName"));
            sic.add(new SelectorItemInfo("orgTypeStr"));
            info = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
        }
        return info;
    }

    public static BillTypeInfo getBillTypeByBOSType(Context ctx, String bosType, int subSystem) throws BOSException, EASBizException {
        return BillTypeFactory.getLocalInstance(ctx).getBillTypeInfo("select id, bosObjectType, subSystem where bosObjectType = '" + bosType + "' and subSystem = " + subSystem);
    }

    public static BOTMappingCollection getBotpRulesSelected(Context ctx, String[] botpRuleId) throws BOSException, EASBizException {
        BOTMappingCollection dapRulesSelected = new BOTMappingCollection();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("name");
        sic.add("alias");
        sic.add("srcEntityName");
        sic.add("destEntityName");
        sic.add("description");
        sic.add("defineSys");
        sic.add("lastUpdateTime");
        sic.add("isTempSave");
        sic.add("isShowEditUI");
        sic.add("extConfig");
        sic.add("mappingType");
        sic.add("extRule.id");
        sic.add("extRule.filter");
        sic.add("extRule.dataFilter");
        sic.add("extRule.isEffected");
        sic.add("extRule.org.id");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)StringUtils.arrayToString((Object[])botpRuleId, (String)","), CompareType.INCLUDE));
        evi.setFilter(fi);
        dapRulesSelected = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(evi);
        return dapRulesSelected;
    }

    public static BOTMappingInfo getBotpRuleByPk(Context ctx, String botpRuleId) throws BOSException, EASBizException {
        BOTMappingCollection dapRules = new BOTMappingCollection();
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = evi.getSelector();
        sic.add("id");
        sic.add("name");
        sic.add("alias");
        sic.add("srcEntityName");
        sic.add("destEntityName");
        sic.add("description");
        sic.add("defineSys");
        sic.add("lastUpdateTime");
        sic.add("isTempSave");
        sic.add("isShowEditUI");
        sic.add("extConfig");
        sic.add("mappingType");
        sic.add("extRule.id");
        sic.add("extRule.filter");
        sic.add("extRule.dataFilter");
        sic.add("extRule.isEffected");
        sic.add("extRule.org.id");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)botpRuleId, CompareType.EQUALS));
        evi.setFilter(fi);
        dapRules = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingCollection(evi);
        BOTMappingInfo dapRule = dapRules.get(0);
        return dapRule;
    }

    public static void clearPreviousBOTPReport(Context ctx, String userID, boolean isCBPay) throws BOSException {
        StringBuffer buf = new StringBuffer().append("delete from T_CAS_PaymentReport where ");
        buf.append("fUserID = '").append(userID).append("'");
        if (isCBPay) {
            buf.append(" and FIsCBPay=1");
        } else {
            buf.append(" and FIsCBPay=0");
        }
        DbUtil.execute((Context)ctx, (String)buf.toString());
    }
}

