/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class CashMgtInitModel {
    private CompanyOrgUnitInfo company = null;
    CompanyOrgUnitCollection orgUnitCollection = null;
    boolean btnFinishInitEnable = false;
    boolean btnAntiInitEnable = false;
    boolean isFinishInit = false;
    boolean isFirstPeriod = false;
    boolean isGLStart = false;
    CurrencyCollection currencyCollection = null;
    CurrencyInfo currency = null;
    PeriodInfo startPeriodInfo = null;
    JournalBalanceCollection cashCollection = null;
    JournalBalanceCollection bankCollection = null;
    JournalBalanceCollection statementCollection = null;
    int error = 0;
    String msg = null;
    private Context ctx = null;

    public CashMgtInitModel(Context ctx) {
        this.ctx = ctx;
    }

    public Map<String, Object> toJsonObject() {
        HashMap<String, Object> onloadData = new HashMap<String, Object>();
        onloadData.put("error", this.error);
        onloadData.put("msg", this.msg);
        if (this.company == null) {
            return onloadData;
        }
        onloadData.put("company", CASWebUtil.parseInfo((CoreBaseInfo)this.company));
        StringBuffer orgFilter = new StringBuffer("unit.id in (");
        for (int i = 0; i < this.orgUnitCollection.size(); ++i) {
            orgFilter.append("'" + this.orgUnitCollection.get(i).getId().toString() + "',");
        }
        orgFilter.deleteCharAt(orgFilter.length() - 1);
        orgFilter.append(")");
        onloadData.put("companyF7Filter", orgFilter.toString());
        onloadData.put("btnFinishInitEnable", this.btnFinishInitEnable);
        onloadData.put("btnAntiInitEnable", this.btnAntiInitEnable);
        onloadData.put("isFinishInit", this.isFinishInit);
        onloadData.put("isFirstPeriod", this.isFirstPeriod);
        onloadData.put("isGLStart", this.isGLStart);
        ArrayList currencyDataSource = new ArrayList();
        for (int i = 0; i < this.currencyCollection.size(); ++i) {
            CurrencyInfo currency = this.currencyCollection.get(i);
            HashMap<String, String> item = new HashMap<String, String>();
            item.put("value", currency.getId().toString());
            item.put("alias", currency.getName());
            currencyDataSource.add(item);
        }
        onloadData.put("currencyDataSource", currencyDataSource);
        onloadData.put("currency", this.currency.getId().toString());
        onloadData.put("precision", this.currency.getPrecision());
        if (this.error > 0) {
            onloadData.put("error", this.error);
            onloadData.put("msg", this.msg);
            return onloadData;
        }
        String[] args = new String[]{String.valueOf(this.startPeriodInfo.getPeriodYear()), String.valueOf(this.startPeriodInfo.getPeriodNumber())};
        MessageFormat mf = new MessageFormat(EASCommonResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period", (Locale)this.ctx.getLocale()));
        String result = mf.format(args);
        onloadData.put("startPeriod", result);
        onloadData.put("startPeriodId", this.startPeriodInfo.getId());
        ArrayList cashGridData = new ArrayList();
        for (int i = 0; i < this.cashCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = this.cashCollection.get(i);
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("cashAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountView()));
            row.put("yearDebitAmt", jbInfo.getDebitStartAmt());
            row.put("yearCreditAmt", jbInfo.getCreditStartAmt());
            row.put("beginBalance", jbInfo.getMonthStartAmt());
            row.put("glStartAmt", jbInfo.get("glStartAmt"));
            row.put("match", jbInfo.getMonthStartAmt().doubleValue() == ((BigDecimal)jbInfo.get("glStartAmt")).doubleValue());
            cashGridData.add(row);
        }
        onloadData.put("cashGridData", cashGridData);
        ArrayList bankGridData = new ArrayList();
        for (int i = 0; i < this.bankCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = this.bankCollection.get(i);
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("bankDepositAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountView()));
            row.put("bankAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountBank(), "id", "name", "number", "bankAccountNumber"));
            row.put("yearDebitAmt", jbInfo.getDebitStartAmt());
            row.put("yearCreditAmt", jbInfo.getCreditStartAmt());
            row.put("beginBalance", jbInfo.getMonthStartAmt());
            row.put("asBalance", jbInfo.getAcctStatementMonthStartAmt());
            row.put("adjJournalBalance", jbInfo.getAdjustedJournalMonthStartAmt());
            row.put("adjAsBalance", jbInfo.getAdjustedASMonthStartAmt());
            row.put("bankMatch", jbInfo.isIsBalanced());
            row.put("glStartBalance", jbInfo.get("glStartBalance"));
            row.put("glMatch", ((BigDecimal)jbInfo.get("glStartBalance")).doubleValue() == jbInfo.getMonthStartAmt().doubleValue());
            bankGridData.add(row);
        }
        onloadData.put("bankGridData", bankGridData);
        ArrayList statementGridData = new ArrayList();
        for (int i = 0; i < this.statementCollection.size(); ++i) {
            JournalBalanceInfo jbInfo = this.statementCollection.get(i);
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("bankDepositAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountView()));
            row.put("bankAcct", CASWebUtil.parseInfo((CoreBaseInfo)jbInfo.getAccountBank(), "id", "name", "number", "bankAccountNumber"));
            row.put("yearDebitAmt", jbInfo.getDebitStartAmt());
            row.put("yearCreditAmt", jbInfo.getCreditStartAmt());
            row.put("beginBalance", jbInfo.getMonthStartAmt());
            row.put("journalBalance", jbInfo.getJournalMonthStartAmt());
            row.put("adjustJournalBalance", jbInfo.getAdjustedJournalMonthStartAmt());
            row.put("adjustASBalance", jbInfo.getAdjustedASMonthStartAmt());
            row.put("match", jbInfo.isIsBalanced());
            statementGridData.add(row);
        }
        onloadData.put("statementGridData", statementGridData);
        return onloadData;
    }

    public static CashMgtInitModel parseModel(Context ctx, String modelStr) throws BOSException {
        CashMgtInitModel model = new CashMgtInitModel(ctx);
        HashMap modelMap = JSONUtils.convertJsonToObject((Context)ctx, (String)modelStr);
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)((String)modelMap.get("companyId"))));
        model.setCompany(company);
        CurrencyInfo currency = new CurrencyInfo();
        String currencyId = (String)modelMap.get("currencyId");
        if (currencyId == null) {
            throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"162_CashMgtInitModel", (Locale)ctx.getLocale()));
        }
        currency.setId(BOSUuid.read((String)currencyId));
        model.setCurrency(currency);
        PeriodInfo period = new PeriodInfo();
        String startPeriodId = (String)modelMap.get("startPeriodId");
        if (EmptyUtil.isEmpty((String)startPeriodId) || startPeriodId.equals("undefined")) {
            throw new RuntimeException(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"163_CashMgtInitModel", (Locale)ctx.getLocale()));
        }
        period.setId(BOSUuid.read((String)startPeriodId));
        model.setStartPeriodInfo(period);
        if (modelMap.get("cashGridData") != null) {
            model.setCashCollection(CashMgtInitModel.parseCashGrid(company, currency, period, (List)modelMap.get("cashGridData")));
        }
        if (modelMap.get("bankGridData") != null) {
            model.setBankCollection(CashMgtInitModel.parseBankOrStatementGrid(company, currency, period, (List)modelMap.get("bankGridData"), AccountTypeEnum.BANKACCOUNT));
        }
        if (modelMap.get("statementGridData") != null) {
            model.setStatementCollection(CashMgtInitModel.parseBankOrStatementGrid(company, currency, period, (List)modelMap.get("statementGridData"), AccountTypeEnum.ACCTSTATEMENT));
        }
        return model;
    }

    private static JournalBalanceCollection parseCashGrid(CompanyOrgUnitInfo company, CurrencyInfo currency, PeriodInfo period, List cashGridData) {
        JournalBalanceCollection cashCollection = new JournalBalanceCollection();
        for (int i = 0; i < cashGridData.size(); ++i) {
            Map row = (Map)cashGridData.get(i);
            BigDecimal yearDebitAmt = new BigDecimal(row.get("yearDebitAmt").toString());
            BigDecimal yearCreditAmt = new BigDecimal(row.get("yearCreditAmt").toString());
            BigDecimal beginBalance = new BigDecimal(row.get("beginBalance").toString());
            if (yearDebitAmt.doubleValue() == 0.0 && yearCreditAmt.doubleValue() == 0.0 && beginBalance.doubleValue() == 0.0) continue;
            JournalBalanceInfo journalBalInfo = new JournalBalanceInfo();
            journalBalInfo.setIsInit(true);
            journalBalInfo.setCompany(company);
            journalBalInfo.setCurrency(currency);
            journalBalInfo.setPeriod(period);
            journalBalInfo.setType(AccountTypeEnum.CASHACCOUNT);
            AccountViewInfo accountView = new AccountViewInfo();
            accountView.setId(BOSUuid.read((String)((String)((Map)row.get("cashAcct")).get("id"))));
            journalBalInfo.setAccountView(accountView);
            journalBalInfo.setDebitStartAmt(yearDebitAmt);
            journalBalInfo.setCreditStartAmt(yearCreditAmt);
            journalBalInfo.setMonthStartAmt(beginBalance);
            journalBalInfo.setYearStartAmt(beginBalance);
            cashCollection.add(journalBalInfo);
        }
        return cashCollection;
    }

    private static JournalBalanceCollection parseBankOrStatementGrid(CompanyOrgUnitInfo company, CurrencyInfo currency, PeriodInfo period, List gridData, AccountTypeEnum accountType) {
        JournalBalanceCollection journalBalCol = new JournalBalanceCollection();
        if (gridData.size() > 0) {
            for (int i = 0; i < gridData.size(); ++i) {
                Map row = (Map)gridData.get(i);
                BigDecimal yearDebitAmt = new BigDecimal(row.get("yearDebitAmt").toString());
                BigDecimal yearCreditAmt = new BigDecimal(row.get("yearCreditAmt").toString());
                BigDecimal beginBalance = new BigDecimal(row.get("beginBalance").toString());
                if (yearDebitAmt.doubleValue() == 0.0 && yearCreditAmt.doubleValue() == 0.0 && beginBalance.doubleValue() == 0.0) continue;
                JournalBalanceInfo journalBalInfo = new JournalBalanceInfo();
                journalBalInfo.setIsInit(true);
                journalBalInfo.setCompany(company);
                journalBalInfo.setCurrency(currency);
                journalBalInfo.setPeriod(period);
                journalBalInfo.setType(accountType);
                AccountBankInfo accountView = new AccountBankInfo();
                accountView.setId(BOSUuid.read((String)((String)((Map)row.get("bankAcct")).get("id"))));
                journalBalInfo.setAccountBank(accountView);
                journalBalInfo.setDebitStartAmt(yearDebitAmt);
                journalBalInfo.setCreditStartAmt(yearCreditAmt);
                journalBalInfo.setMonthStartAmt(beginBalance);
                journalBalInfo.setYearStartAmt(beginBalance);
                journalBalCol.add(journalBalInfo);
            }
        }
        return journalBalCol;
    }

    public CompanyOrgUnitInfo getCompany() {
        return this.company;
    }

    public void setCompany(CompanyOrgUnitInfo company) {
        this.company = company;
    }

    public boolean isBtnFinishInitEnable() {
        return this.btnFinishInitEnable;
    }

    public void setBtnFinishInitEnable(boolean btnFinishInitEnable) {
        this.btnFinishInitEnable = btnFinishInitEnable;
    }

    public boolean isBtnAntiInitEnable() {
        return this.btnAntiInitEnable;
    }

    public void setBtnAntiInitEnable(boolean btnAntiInitEnable) {
        this.btnAntiInitEnable = btnAntiInitEnable;
    }

    public boolean isFinishInit() {
        return this.isFinishInit;
    }

    public void setFinishInit(boolean isFinishInit) {
        this.isFinishInit = isFinishInit;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public PeriodInfo getStartPeriodInfo() {
        return this.startPeriodInfo;
    }

    public void setStartPeriodInfo(PeriodInfo startPeriodInfo) {
        this.startPeriodInfo = startPeriodInfo;
    }

    public JournalBalanceCollection getCashCollection() {
        return this.cashCollection;
    }

    public void setCashCollection(JournalBalanceCollection cashCollection) {
        this.cashCollection = cashCollection;
    }

    public JournalBalanceCollection getBankCollection() {
        return this.bankCollection;
    }

    public void setBankCollection(JournalBalanceCollection bankCollection) {
        this.bankCollection = bankCollection;
    }

    public JournalBalanceCollection getStatementCollection() {
        return this.statementCollection;
    }

    public void setStatementCollection(JournalBalanceCollection statementCollection) {
        this.statementCollection = statementCollection;
    }

    public CompanyOrgUnitCollection getOrgUnitCollection() {
        return this.orgUnitCollection;
    }

    public void setOrgUnitCollection(CompanyOrgUnitCollection orgUnitCollection) {
        this.orgUnitCollection = orgUnitCollection;
    }

    public CurrencyCollection getCurrencyCollection() {
        return this.currencyCollection;
    }

    public void setCurrencyCollection(CurrencyCollection currencyCollection) {
        this.currencyCollection = currencyCollection;
    }

    public boolean isFirstPeriod() {
        return this.isFirstPeriod;
    }

    public void setFirstPeriod(boolean isFirstPeriod) {
        this.isFirstPeriod = isFirstPeriod;
    }

    public boolean isGLStart() {
        return this.isGLStart;
    }

    public void setGLStart(boolean isGLStart) {
        this.isGLStart = isGLStart;
    }

    public int getError() {
        return this.error;
    }

    public void setError(int error) {
        this.error = error;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

