/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.mthread;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteContext;
import com.kingdee.eas.fi.cas.app.mthread.task.ITask;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheInvocationHandler
implements InvocationHandler {
    private Object target;
    protected Map<String, List<Map>> cachedMethod = new HashMap<String, List<Map>>();

    public CacheInvocationHandler(Object target) {
        this.target = target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.getName().equals("execute") && !method.getName().equals("setInterface")) {
            int i;
            System.out.println("cached method: " + method.getName() + " start.");
            List<Object> methodInvokeList = null;
            String key = method.getName();
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (i = 0; i < parameterTypes.length; ++i) {
                key = key + "-" + parameterTypes[i].getName();
            }
            if (this.cachedMethod.get(key) == null) {
                methodInvokeList = new ArrayList();
                this.cachedMethod.put(key, methodInvokeList);
            } else {
                methodInvokeList = this.cachedMethod.get(key);
            }
            for (i = 0; i < methodInvokeList.size(); ++i) {
                Map invokeMap = (Map)methodInvokeList.get(i);
                Object[] invokeParams = (Object[])invokeMap.get("params");
                boolean equal = true;
                for (int j = 0; j < args.length; ++j) {
                    if (args[j] == null && invokeParams[j] != null) {
                        equal = false;
                        break;
                    }
                    if (args[j] != null && invokeParams[j] == null) {
                        equal = false;
                        break;
                    }
                    if (args[j].equals(invokeParams[j])) continue;
                    equal = false;
                    break;
                }
                if (!equal) continue;
                boolean isFinish = (Boolean)invokeMap.get("finish");
                while (!isFinish) {
                    try {
                        Thread.sleep(10L);
                        isFinish = (Boolean)invokeMap.get("finish");
                    }
                    catch (Exception exception) {}
                }
                System.out.println("Cache hit, result is " + invokeMap.get("result"));
                return invokeMap.get("result");
            }
            HashMap<String, Object> invokeMap = new HashMap<String, Object>();
            invokeMap.put("params", args);
            invokeMap.put("finish", false);
            methodInvokeList.add(invokeMap);
            Object rev = null;
            try {
                rev = method.invoke(this.target, args);
                invokeMap.put("result", rev);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                invokeMap.put("finish", true);
            }
            System.out.println("cached method: " + method.getName() + " end.");
            return rev;
        }
        Object rev = method.invoke(this.target, args);
        return rev;
    }

    public static void main(String[] args) throws Exception {
        Class<?> interfaceClass = Class.forName("com.kingdee.eas.fi.cas.mthread.IDemoTask");
        Class<?> taskClass = Class.forName("com.kingdee.eas.fi.cas.mthread.DemoTask");
        Class[] proxyInterface = new Class[]{interfaceClass};
        CacheInvocationHandler handler = new CacheInvocationHandler(taskClass.newInstance());
        ClassLoader classLoader = handler.getClass().getClassLoader();
        ITask task = (ITask)Proxy.newProxyInstance(classLoader, proxyInterface, (InvocationHandler)handler);
        task.setInterface(task);
        task.setExecuteContext(new ExecuteContext(new Context()));
        task.execute("10");
    }
}

