/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.mthread;

import com.kingdee.bos.Context;
import com.kingdee.eas.fi.cas.app.mthread.CacheInvocationHandler;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteContext;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteResult;
import com.kingdee.eas.fi.cas.app.mthread.TaskRunner;
import com.kingdee.eas.fi.cas.app.mthread.task.DemoTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TaskManager {
    protected Context ctx = null;
    protected String[] ids = null;
    protected int multiThreadNum = 10;
    protected Map parameter = null;
    protected CacheInvocationHandler handler = null;

    public TaskManager() {
    }

    public TaskManager(int multiThreadNum) {
        this.setMultiThreadNum(multiThreadNum);
    }

    public TaskManager(Map parameter) {
        this.parameter = parameter;
    }

    public TaskManager(Map parameter, int multiThreadNum) {
        this.parameter = parameter;
        this.setMultiThreadNum(multiThreadNum);
    }

    public int getMultiThreadNum() {
        return this.multiThreadNum;
    }

    public void setMultiThreadNum(int multiThreadNum) {
        this.multiThreadNum = multiThreadNum;
    }

    public List<ExecuteResult> batchExecute(Context ctx, String[] ids, Class taskClass) {
        this.ids = ids;
        this.ctx = ctx;
        Class<?> interfaceClass = taskClass.getInterfaces()[0];
        ExecuteContext eContext = this.buildExecuteContext(ids);
        try {
            this.handler = new CacheInvocationHandler(taskClass.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (ids.length <= this.multiThreadNum) {
            return this.batchExecute(eContext, ids, taskClass, interfaceClass, 0, ids.length);
        }
        ArrayList<ExecuteResult> resultList = new ArrayList<ExecuteResult>();
        for (int i = 0; i < ids.length; i += this.multiThreadNum) {
            List<ExecuteResult> oneBatch = this.batchExecute(eContext, ids, taskClass, interfaceClass, i, i + this.multiThreadNum);
            resultList.addAll(oneBatch);
        }
        return resultList;
    }

    protected List<ExecuteResult> batchExecute(ExecuteContext ctx, String[] ids, Class taskClass, Class interfaceClass, int fromIndex, int endIndex) {
        ArrayList<TaskRunner> taskRunnerList = new ArrayList<TaskRunner>();
        for (int i = fromIndex; i < endIndex && i < ids.length; ++i) {
            TaskRunner runner = new TaskRunner(ctx, ids[i], taskClass, interfaceClass, this.handler);
            taskRunnerList.add(runner);
            new Thread(runner).start();
        }
        boolean allFinish = true;
        do {
            allFinish = true;
            for (int i = 0; i < taskRunnerList.size(); ++i) {
                if (((TaskRunner)taskRunnerList.get(i)).isFinish()) continue;
                allFinish = false;
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (Exception i) {
                // empty catch block
            }
        } while (!allFinish);
        ArrayList<ExecuteResult> resultList = new ArrayList<ExecuteResult>();
        for (int i = 0; i < taskRunnerList.size(); ++i) {
            resultList.add(((TaskRunner)taskRunnerList.get(i)).getExecuteResult());
        }
        return resultList;
    }

    public ExecuteContext buildExecuteContext(String[] ids) {
        ExecuteContext eContext = new ExecuteContext(this.ctx);
        eContext.setIds(ids);
        if (this.parameter != null) {
            eContext.getParameterMap().putAll(this.parameter);
        }
        return eContext;
    }

    public static void main(String[] args) {
        String[] ids = new String[25];
        for (int i = 0; i < 25; ++i) {
            ids[i] = i + "";
        }
        long dTime = System.currentTimeMillis();
        TaskManager taskManager = new TaskManager();
        taskManager.batchExecute(new Context(), ids, DemoTask.class);
        System.out.println("Multi Spent: " + (System.currentTimeMillis() - dTime));
    }
}

