/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.mthread;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.app.mthread.CacheInvocationHandler;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteContext;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteResult;
import com.kingdee.eas.fi.cas.app.mthread.task.ITask;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class TaskRunner
implements Runnable {
    protected ExecuteContext context = null;
    protected String id = null;
    protected ITask task = null;
    protected boolean finish = false;
    protected ExecuteResult result = null;

    public TaskRunner(ExecuteContext context, String id, Class taskClass, Class interfaceClass, CacheInvocationHandler handler) {
        this.context = context;
        this.id = id;
        try {
            Class[] proxyInterface = new Class[]{interfaceClass};
            ClassLoader classLoader = handler.getClass().getClassLoader();
            this.task = (ITask)Proxy.newProxyInstance(classLoader, proxyInterface, (InvocationHandler)handler);
            this.task.setInterface(this.task);
            this.task.setExecuteContext(context);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long dTime = System.currentTimeMillis();
        try {
            this.result = this.task.execute(this.id);
        }
        catch (EASBizException e) {
            this.result = new ExecuteResult();
            this.result.success = false;
            this.result.msg = e.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.result = new ExecuteResult();
            this.result.success = false;
            this.result.msg = e.getMessage();
        }
        finally {
            this.finish = true;
            this.result.setSpent(System.currentTimeMillis() - dTime);
        }
    }

    public boolean isFinish() {
        return this.finish;
    }

    public ExecuteResult getExecuteResult() {
        return this.result;
    }
}

