/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.app.mthread.task;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.security.EASSignatureFactory;
import com.kingdee.eas.base.security.IEASSignature;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.FundDispatchTypeEnum;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteContext;
import com.kingdee.eas.fi.cas.app.mthread.ExecuteResult;
import com.kingdee.eas.fi.cas.app.mthread.task.AbstractTask;
import com.kingdee.eas.fi.cas.app.mthread.task.IPaymentBillCommitToBeTask;
import com.kingdee.eas.fi.cas.utils.CASWebHelper;
import com.kingdee.eas.fi.cas.utils.CASWebUtil;
import com.kingdee.eas.fi.cas.utils.PeriodHelper;
import com.kingdee.eas.fm.be.BankPayResult;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PaymentBillCommitToBeTask
extends AbstractTask<IPaymentBillCommitToBeTask>
implements IPaymentBillCommitToBeTask {
    protected final String INFO_MAP = "INFO_MAP";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ExecuteResult execute(String id) throws Exception {
        Context ctx = this.getExecuteContext().getAppContext();
        ExecuteResult result = new ExecuteResult();
        result.setSuccess(true);
        String commitToBePermission = "cas_paymentbill_16commitToBE";
        try {
            BankPayResult resultInfo;
            Pattern pattern;
            Matcher matcher;
            IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
            PaymentBillInfo info = this.getInfoById(id);
            if (!EmptyUtil.isEmpty((Object)((Object)info.getFundDispatchType()))) {
                boolean isFundDispatch;
                String billType = String.valueOf(info.getFundDispatchType().getValue());
                boolean bl = isFundDispatch = billType != null && (billType.equals(String.valueOf(2)) || billType.equals(String.valueOf(1)));
                if (isFundDispatch) {
                    commitToBePermission = "fundDispatchBill_16commitToBE";
                }
            }
            result.getOtherMap().put("INFO", info);
            if (FundDispatchTypeEnum.PAYMENT_DEFAULT.equals((Object)info.getFundDispatchType())) {
                IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
                iPermission.checkDataPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), commitToBePermission, (IObjectPK)new ObjectUuidPK(id));
            }
            IEASSignature iEASSignature = EASSignatureFactory.getLocalInstance((Context)ctx);
            ArrayList<String> list = null;
            ArrayList<String> signatureList = null;
            Map<String, Object> paramCa = this.getExecuteContext().getParameterMap();
            if (paramCa != null && paramCa.containsKey("isEdit")) {
                list = new ArrayList<String>();
                list.add(id);
                iEASSignature.checkSignature4Web(list, commitToBePermission);
                signatureList = new ArrayList<String>();
                if (paramCa.get("isEdit").equals("1")) {
                    String plainText = (String)paramCa.get("plainText");
                    String signature = (String)paramCa.get("signature");
                    iEASSignature.checkSignature4Web(plainText, signature, commitToBePermission);
                } else {
                    Map signatureMap = (Map)paramCa.get("signature");
                    signatureList.add((String)signatureMap.get(id));
                    iEASSignature.checkSignature4Web(list, signatureList, commitToBePermission);
                }
            }
            if (!info.getBillStatus().equals((Object)BillStatusEnum.AUDITED)) {
                result.setSuccess(false);
                result.setMsg(CASWebUtil.getResource(ctx, "329_COMMITTOBE_AUDITED"));
                return result;
            }
            if (info.getBankNumber() != null && (matcher = (pattern = Pattern.compile("[\u4e00-\u9fa5]")).matcher(info.getBankNumber())).find()) {
                result.setSuccess(false);
                result.setMsg(ResourceBase.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"165_PaymentBillCommitToBeTask", (Locale)ctx.getLocale()));
                return result;
            }
            AccountBankInfo acctBank = info.getPayerAccountBank();
            SettlementTypeInfo settlementType = info.getSettlementType();
            if (acctBank != null && acctBank.isIsSetBankInterface() && settlementType != null && settlementType.isPayThroughBE()) {
                if (!(EmptyUtil.isEmpty((String)info.getPayeeName()) || EmptyUtil.isEmpty((String)info.getPayeeBank()) || EmptyUtil.isEmpty((String)info.getPayeeAccountBank()) || EmptyUtil.isEmpty((String)info.getRecProvince()) || EmptyUtil.isEmpty((String)info.getRecCity()) || EmptyUtil.isEmpty((CoreBaseInfo)info.getFRecCountry()))) {
                    result.setSuccess(false);
                    result.setMsg(CASWebUtil.getResource(ctx, "331_COMMITTOBE_CHECKBEINFO"));
                    return result;
                }
                Map param = CASWebHelper.getParamMap(ctx, info.getCompany().getId().toString(), "CS036");
                if (((Boolean)param.get("CS036")).booleanValue() && EmptyUtil.isEmpty((String)info.getUsage())) {
                    result.setSuccess(false);
                    result.setMsg(CASWebUtil.getResource(ctx, "293_USAGE_NOT_EMPTY"));
                    return result;
                }
            } else {
                if (settlementType != null && settlementType.isPayThroughBE()) {
                    result.setSuccess(false);
                    result.setMsg(CASWebUtil.getResource(ctx, "330_COMMITTOBE_BANKINTERFACE"));
                    return result;
                }
                result.setSuccess(false);
                result.setMsg(CASWebUtil.getResource(ctx, "630_forBeMustHaveSettleType"));
                return result;
            }
            if (((IPaymentBillCommitToBeTask)this.inf).isAdjustPeriod(ctx, info.getCompany().getId().toString())) {
                result.setSuccess(false);
                result.setMsg(CASWebUtil.getResource(ctx, "IN_ADJUST_PERIOD", new String[]{info.getNumber()}));
                return result;
            }
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(id);
            ArrayList resultList = iPaymentBill.commitToBENewBatch(idSet);
            if (resultList.size() > 0 && !(resultInfo = (BankPayResult)resultList.get(0)).isSubmitToBe()) {
                result.setSuccess(false);
                result.setMsg(EmptyUtil.isEmpty((String)resultInfo.getErrorDetail()) ? resultInfo.getBankResult() : resultInfo.getErrorDetail());
            }
            if (paramCa == null) return result;
            if (!paramCa.containsKey("isEdit")) return result;
            iEASSignature.checkSignature4Web(list, commitToBePermission);
            if (paramCa.get("isEdit").equals("1")) {
                String plainText = (String)paramCa.get("plainText");
                String signature = (String)paramCa.get("signature");
                iEASSignature.saveSignature4Web(signature, plainText, id, commitToBePermission);
                return result;
            }
            iEASSignature.saveSignature4Web(signatureList, list, commitToBePermission);
            return result;
        }
        catch (EASBizException e) {
            result.setSuccess(false);
            result.setMsg(e.getMessage());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.setSuccess(false);
            result.setMsg(e.getMessage());
            return result;
        }
    }

    @Override
    public boolean isAdjustPeriod(Context ctx, String companyId) throws EASBizException, BOSException {
        return PeriodHelper.isAdjustPeriod(ctx, companyId);
    }

    protected void batchGetInfo() throws BOSException {
        ExecuteContext eContext = this.getExecuteContext();
        HashMap<String, PaymentBillInfo> infoMap = (HashMap<String, PaymentBillInfo>)eContext.getParameter("INFO_MAP");
        if (infoMap != null) {
            return;
        }
        String[] ids = eContext.getIds();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.name"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("payeeName"));
        sic.add(new SelectorItemInfo("payeeBank"));
        sic.add(new SelectorItemInfo("payeeAccountBank.*"));
        sic.add(new SelectorItemInfo("FRecCountry.*"));
        sic.add(new SelectorItemInfo("recProvince"));
        sic.add(new SelectorItemInfo("recCity"));
        sic.add(new SelectorItemInfo("usage"));
        sic.add(new SelectorItemInfo("isCBPay"));
        sic.add(new SelectorItemInfo("fundDispatchType"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)CASWebUtil.ids2Set(ids), CompareType.INCLUDE));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        evi.setSelector(sic);
        PaymentBillCollection coll = PaymentBillFactory.getLocalInstance(eContext.getAppContext()).getPaymentBillCollection(evi);
        infoMap = new HashMap<String, PaymentBillInfo>();
        for (int i = 0; i < coll.size(); ++i) {
            infoMap.put(coll.get(i).getId().toString(), coll.get(i));
        }
        eContext.setParameter("INFO_MAP", infoMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PaymentBillInfo getInfoById(String id) throws BOSException {
        ExecuteContext eContext;
        ExecuteContext executeContext = eContext = this.getExecuteContext();
        synchronized (executeContext) {
            this.batchGetInfo();
        }
        return (PaymentBillInfo)((Map)eContext.getParameter("INFO_MAP")).get(id);
    }
}

